/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Vector;
import megamek.common.Compute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitiativeRoll
implements Comparable<InitiativeRoll>,
Serializable {
    private static final long serialVersionUID = -1850190415242027657L;
    private Vector<Integer> rolls = new Vector();
    private Vector<Integer> originalRolls = new Vector();
    private Vector<Boolean> wasRollReplaced = new Vector();

    public void clear() {
        this.rolls.removeAllElements();
        this.originalRolls.removeAllElements();
        this.wasRollReplaced.removeAllElements();
    }

    public void addRoll(int n) {
        Integer n2 = n + new Integer(Compute.d6(2));
        this.rolls.addElement(n2);
        this.originalRolls.addElement(n2);
        this.wasRollReplaced.addElement(new Boolean(false));
    }

    public void replaceRoll(int n) {
        Integer n2 = n + new Integer(Compute.d6(2));
        this.rolls.setElementAt(n2, this.size() - 1);
        this.wasRollReplaced.setElementAt(new Boolean(true), this.size() - 1);
    }

    public int size() {
        return this.rolls.size();
    }

    public int getRoll(int n) {
        return this.rolls.elementAt(n);
    }

    public boolean equals(InitiativeRoll initiativeRoll) {
        if (this.size() != initiativeRoll.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.getRoll(i) == initiativeRoll.getRoll(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(InitiativeRoll initiativeRoll) {
        int n = Math.min(this.size(), initiativeRoll.size());
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = this.getRoll(i) - initiativeRoll.getRoll(i);
            if (n2 == 0) continue;
            return n2;
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < this.rolls.size(); ++i) {
            Integer n = this.rolls.elementAt(i);
            Integer n2 = this.originalRolls.elementAt(i);
            if (this.wasRollReplaced.elementAt(i).booleanValue()) {
                stringBuffer.append(n2.toString()).append("(").append(n.toString()).append(")");
                bl = true;
            } else {
                stringBuffer.append(n.toString());
            }
            if (i == this.rolls.size() - 1) continue;
            stringBuffer.append(" / ");
        }
        if (bl) {
            stringBuffer.append("  (Tactical Genius ability used)");
        }
        return stringBuffer.toString();
    }
}

