/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.File;
import java.io.Serializable;
import megamek.common.Aero;
import megamek.common.BattleArmor;
import megamek.common.Dropship;
import megamek.common.Entity;
import megamek.common.EntityWeightClass;
import megamek.common.GunEmplacement;
import megamek.common.Infantry;
import megamek.common.Jumpship;
import megamek.common.Mech;
import megamek.common.Protomech;
import megamek.common.SmallCraft;
import megamek.common.SpaceStation;
import megamek.common.Tank;
import megamek.common.VTOL;
import megamek.common.Warship;

public class MechSummary
implements Serializable {
    private static final long serialVersionUID = -6635709122122038237L;
    private String m_sName;
    private String m_sChassis;
    private String m_sModel;
    private String m_sUnitType;
    private File m_sSourceFile;
    private String m_sEntryName;
    private int m_nYear;
    private int m_nType;
    private int m_nTons;
    private int m_nBV;
    private int m_nCost;
    private long m_lModified;
    private String m_sLevel;
    private boolean canon;

    public String getName() {
        return this.m_sName;
    }

    public String getChassis() {
        return this.m_sChassis;
    }

    public String getModel() {
        return this.m_sModel;
    }

    public String getUnitType() {
        return this.m_sUnitType;
    }

    public boolean isCanon() {
        return this.canon;
    }

    public static String determineUnitType(Entity entity) {
        int n = entity.getMovementMode();
        if (entity instanceof BattleArmor) {
            return "BattleArmor";
        }
        if (entity instanceof Infantry) {
            return "Infantry";
        }
        if (entity instanceof VTOL) {
            return "VTOL";
        }
        if (n == 7 || n == 8 || n == 9) {
            return "Naval";
        }
        if (entity instanceof Tank) {
            return "Tank";
        }
        if (entity instanceof Mech) {
            return "Mek";
        }
        if (entity instanceof Protomech) {
            return "ProtoMek";
        }
        if (entity instanceof GunEmplacement) {
            return "Gun Emplacement";
        }
        if (entity instanceof SpaceStation) {
            return "Space Station";
        }
        if (entity instanceof Warship) {
            return "Warship";
        }
        if (entity instanceof Jumpship) {
            return "Jumpship";
        }
        if (entity instanceof Dropship) {
            return "Dropship";
        }
        if (entity instanceof SmallCraft) {
            return "Small Craft";
        }
        if (entity instanceof Aero) {
            return "Aero";
        }
        return "Unknown";
    }

    public File getSourceFile() {
        return this.m_sSourceFile;
    }

    public String getEntryName() {
        return this.m_sEntryName;
    }

    public int getYear() {
        return this.m_nYear;
    }

    public int getType() {
        return this.m_nType;
    }

    public int getTons() {
        return this.m_nTons;
    }

    public int getBV() {
        return this.m_nBV;
    }

    public int getCost() {
        return this.m_nCost;
    }

    public long getModified() {
        return this.m_lModified;
    }

    public String getLevel() {
        return this.m_sLevel;
    }

    public void setName(String string) {
        this.m_sName = string;
    }

    public void setChassis(String string) {
        this.m_sChassis = string;
    }

    public void setModel(String string) {
        this.m_sModel = string;
    }

    public void setUnitType(String string) {
        this.m_sUnitType = string;
    }

    public void setSourceFile(File file) {
        this.m_sSourceFile = file;
    }

    public void setEntryName(String string) {
        this.m_sEntryName = string;
    }

    public void setYear(int n) {
        this.m_nYear = n;
    }

    public void setType(int n) {
        this.m_nType = n;
    }

    public void setTons(int n) {
        this.m_nTons = n;
    }

    public void setCost(int n) {
        this.m_nCost = n;
    }

    public void setBV(int n) {
        this.m_nBV = n;
    }

    public void setModified(long l) {
        this.m_lModified = l;
    }

    public void setLevel(String string) {
        this.m_sLevel = string;
    }

    public void setCanon(boolean bl) {
        this.canon = bl;
    }

    public int getWeightClass() {
        return EntityWeightClass.getWeightClass(this.m_nTons);
    }
}

