/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import megamek.MegaMek;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mech;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.Tank;
import megamek.common.TechConstants;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.preference.PreferenceManager;
import megamek.common.verifier.EntityVerifier;
import megamek.common.verifier.TestEntity;
import megamek.common.verifier.TestMech;
import megamek.common.verifier.TestTank;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MechSummaryCache {
    static MechSummaryCache m_instance;
    private boolean initialized = false;
    private boolean initializing = false;
    private ArrayList<Listener> listeners = new ArrayList();
    private StringBuffer loadReport = new StringBuffer();
    private static final String CONFIG_FILENAME = "data/mechfiles/UnitVerifierOptions.xml";
    private EntityVerifier entityVerifier = null;
    private Thread loader;
    private MechSummary[] m_data;
    private Map<String, MechSummary> m_nameMap = new HashMap<String, MechSummary>();
    private Map<String, MechSummary> m_fileNameMap = new HashMap<String, MechSummary>();
    private Map<String, String> hFailedFiles;
    private int cacheCount;
    private int fileCount;
    private int zipCount;
    private static final char SEPARATOR = '|';
    private static final File ROOT;
    private static final File CACHE;

    public static synchronized MechSummaryCache getInstance() {
        if (m_instance == null) {
            m_instance = new MechSummaryCache();
        }
        if (!MechSummaryCache.m_instance.initialized && !MechSummaryCache.m_instance.initializing) {
            MechSummaryCache.m_instance.initializing = true;
            MechSummaryCache.m_instance.loader = new Thread(new Runnable(){

                public void run() {
                    m_instance.loadMechData();
                }
            }, "Mech Cache Loader");
            MechSummaryCache.m_instance.loader.setPriority(4);
            MechSummaryCache.m_instance.loader.start();
        }
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose() {
        if (m_instance != null) {
            MechSummaryCache mechSummaryCache = m_instance;
            synchronized (mechSummaryCache) {
                MechSummaryCache.m_instance.loader.interrupt();
                m_instance = null;
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        ArrayList<Listener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    private MechSummaryCache() {
    }

    public MechSummary[] getAllMechs() {
        this.block();
        return this.m_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void block() {
        if (!this.initialized) {
            MechSummaryCache mechSummaryCache = m_instance;
            synchronized (mechSummaryCache) {
                try {
                    m_instance.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public MechSummary getMech(String string) {
        this.block();
        if (this.m_nameMap.containsKey(string)) {
            return this.m_nameMap.get(string);
        }
        return this.m_fileNameMap.get(string);
    }

    public Map<String, String> getFailedFiles() {
        this.block();
        return this.hFailedFiles;
    }

    void loadMechData() {
        Object object;
        Vector<MechSummary> vector = new Vector<MechSummary>();
        HashSet<String> hashSet = new HashSet<String>();
        long l = 0L;
        this.entityVerifier = new EntityVerifier(new File(CONFIG_FILENAME));
        this.hFailedFiles = new HashMap<String, String>();
        EquipmentType.initializeTypes();
        this.loadReport.append("\n");
        this.loadReport.append("Reading unit files:\n");
        try {
            if (CACHE.exists() && CACHE.lastModified() >= MegaMek.TIMESTAMP) {
                String string;
                this.loadReport.append("  Reading from unit cache file...\n");
                l = CACHE.lastModified();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(CACHE));
                while ((string = bufferedReader.readLine()) != null) {
                    if (Thread.interrupted()) {
                        this.done();
                        return;
                    }
                    object = new MechSummary();
                    int n = string.indexOf(124);
                    ((MechSummary)object).setName(string.substring(0, n));
                    int n2 = string.indexOf(124, n + 1);
                    ((MechSummary)object).setChassis(string.substring(n + 1, n2));
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    ((MechSummary)object).setModel(string.substring(n + 1, n2));
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    ((MechSummary)object).setUnitType(string.substring(n + 1, n2));
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    ((MechSummary)object).setSourceFile(new File(string.substring(n + 1, n2)));
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    ((MechSummary)object).setEntryName(string.substring(n + 1, n2));
                    if (((MechSummary)object).getEntryName().equals("null")) {
                        ((MechSummary)object).setEntryName(null);
                    }
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    ((MechSummary)object).setYear(Integer.parseInt(string.substring(n + 1, n2)));
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    ((MechSummary)object).setType(Integer.parseInt(string.substring(n + 1, n2)));
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    ((MechSummary)object).setTons(Integer.parseInt(string.substring(n + 1, n2)));
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    ((MechSummary)object).setBV(Integer.parseInt(string.substring(n + 1, n2)));
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    ((MechSummary)object).setLevel(string.substring(n + 1, n2));
                    n = n2;
                    n2 = string.indexOf(124, n + 1);
                    ((MechSummary)object).setCost(Integer.parseInt(string.substring(n + 1, n2)));
                    ((MechSummary)object).setCanon(string.substring(n2 + 1).equals("T"));
                    File file = ((MechSummary)object).getSourceFile();
                    if (!file.exists() || file.lastModified() >= l) continue;
                    vector.addElement((MechSummary)object);
                    hashSet.add(((MechSummary)object).getSourceFile().toString());
                    ++this.cacheCount;
                }
            }
        }
        catch (Exception exception) {
            this.loadReport.append("  Unable to load unit cache: ").append(exception.getMessage()).append("\n");
        }
        boolean bl = this.loadMechsFromDirectory(vector, hashSet, l, ROOT);
        this.m_data = new MechSummary[vector.size()];
        vector.copyInto(this.m_data);
        for (int i = 0; i < this.m_data.length; ++i) {
            this.m_nameMap.put(this.m_data[i].getName(), this.m_data[i]);
            if (this.m_data[i].getEntryName() == null) {
                this.m_fileNameMap.put(this.m_data[i].getSourceFile().getName(), this.m_data[i]);
                continue;
            }
            object = this.m_data[i].getEntryName();
            if (((String)object).indexOf("\\") > -1) {
                object = ((String)object).substring(((String)object).lastIndexOf("\\") + 1);
            }
            if (((String)object).indexOf("/") > -1) {
                object = ((String)object).substring(((String)object).lastIndexOf("/") + 1);
            }
            this.m_fileNameMap.put((String)object, this.m_data[i]);
        }
        if (bl) {
            try {
                this.saveCache();
            }
            catch (Exception exception) {
                this.loadReport.append("  Unable to save mech cache\n");
            }
        }
        this.loadReport.append(this.m_data.length).append(" units loaded.\n");
        if (this.hFailedFiles.size() > 0) {
            this.loadReport.append("  ").append(this.hFailedFiles.size()).append(" units failed to load...\n");
        }
        System.out.print(this.loadReport.toString());
        this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void done() {
        this.initialized = true;
        Object object = m_instance;
        synchronized (object) {
            m_instance.notifyAll();
        }
        object = this.listeners;
        synchronized (object) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).doneLoading();
            }
        }
    }

    private void saveCache() throws Exception {
        this.loadReport.append("Saving unit cache.\n");
        FileWriter fileWriter = new FileWriter(CACHE);
        for (int i = 0; i < this.m_data.length; ++i) {
            fileWriter.write(this.m_data[i].getName() + '|' + this.m_data[i].getChassis() + '|' + this.m_data[i].getModel() + '|' + this.m_data[i].getUnitType() + '|' + this.m_data[i].getSourceFile().getPath() + '|' + this.m_data[i].getEntryName() + '|' + this.m_data[i].getYear() + '|' + this.m_data[i].getType() + '|' + this.m_data[i].getTons() + '|' + this.m_data[i].getBV() + '|' + this.m_data[i].getLevel() + '|' + this.m_data[i].getCost() + '|' + (this.m_data[i].isCanon() ? (char)'T' : 'F') + "\r\n");
        }
        fileWriter.flush();
        fileWriter.close();
    }

    private MechSummary getSummary(Entity entity, File file, String string) {
        MechSummary mechSummary = new MechSummary();
        mechSummary.setName(entity.getShortNameRaw());
        mechSummary.setChassis(entity.getChassis());
        mechSummary.setModel(entity.getModel());
        mechSummary.setUnitType(MechSummary.determineUnitType(entity));
        mechSummary.setSourceFile(file);
        mechSummary.setEntryName(string);
        mechSummary.setYear(entity.getYear());
        mechSummary.setType(entity.getTechLevel());
        mechSummary.setTons((int)entity.getWeight());
        mechSummary.setBV(entity.calculateBattleValue());
        mechSummary.setLevel(TechConstants.T_SIMPLE_LEVEL[entity.getTechLevel()]);
        mechSummary.setCost((int)entity.getCost());
        mechSummary.setCanon(entity.isCanon());
        if (entity instanceof Mech || entity instanceof Tank) {
            TestEntity testEntity = null;
            testEntity = entity instanceof Mech ? new TestMech((Mech)entity, this.entityVerifier.mechOption, null) : new TestTank((Tank)entity, this.entityVerifier.tankOption, null);
            if (!testEntity.correctEntity(new StringBuffer())) {
                mechSummary.setLevel("F");
            }
        }
        return mechSummary;
    }

    private boolean loadMechsFromDirectory(Vector<MechSummary> vector, Set<String> set, long l, File file) {
        boolean bl = false;
        this.loadReport.append("  Looking in ").append(file.getPath()).append("...\n");
        int n = 0;
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (Thread.interrupted()) {
                    this.done();
                    return false;
                }
                File file2 = new File(file, stringArray[i]);
                if (file2.equals(CACHE)) continue;
                if (file2.isDirectory()) {
                    if (file2.getName().toLowerCase().equals("unsupported") || file2.getName().toLowerCase().equals("_svn")) continue;
                    bl |= this.loadMechsFromDirectory(vector, set, l, file2);
                    continue;
                }
                if (file2.getName().indexOf(46) == -1 || file2.getName().toLowerCase().endsWith(".txt") || file2.getName().toLowerCase().endsWith(".log") || file2.getName().toLowerCase().endsWith(".svn-base") || file2.getName().toLowerCase().endsWith(".svn-work") || file2.getName().equals("UnitVerifierOptions.xml")) continue;
                if (file2.getName().toLowerCase().endsWith(".zip")) {
                    bl |= this.loadMechsFromZipFile(vector, set, l, file2);
                    continue;
                }
                if (file2.lastModified() < l && set.contains(file2.toString())) continue;
                try {
                    MechFileParser mechFileParser = new MechFileParser(file2);
                    Entity entity = mechFileParser.getEntity();
                    MechSummary mechSummary = this.getSummary(entity, file2, null);
                    vector.addElement(mechSummary);
                    set.add(file2.toString());
                    bl = true;
                    ++n;
                    ++this.fileCount;
                    Iterator<String> iterator = entity.getFailedEquipment();
                    if (!iterator.hasNext()) continue;
                    this.loadReport.append("    Loading from ").append(file2).append("\n");
                    while (iterator.hasNext()) {
                        this.loadReport.append("      Failed to load equipment: ").append(iterator.next()).append("\n");
                    }
                    continue;
                }
                catch (EntityLoadingException entityLoadingException) {
                    this.loadReport.append("    Loading from ").append(file2).append("\n");
                    this.loadReport.append("***   Unable to load file: ").append(entityLoadingException.getMessage()).append("\n");
                    this.hFailedFiles.put(file2.toString(), entityLoadingException.getMessage());
                }
            }
        }
        this.loadReport.append("  ...loaded ").append(n).append(" files.\n");
        return bl;
    }

    private boolean loadMechsFromZipFile(Vector<MechSummary> vector, Set<String> set, long l, File file) {
        ZipFile zipFile;
        boolean bl = false;
        int n = 0;
        try {
            zipFile = new ZipFile(file);
        }
        catch (Exception exception) {
            this.loadReport.append("  Unable to load file ").append(file.getName()).append(": ").append(exception.getMessage()).append("\n");
            return false;
        }
        this.loadReport.append("  Looking in zip file ").append(file.getPath()).append("...\n");
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            if (Thread.interrupted()) {
                this.done();
                return false;
            }
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) {
                if (!zipEntry.getName().toLowerCase().equals("unsupported")) continue;
                this.loadReport.append("  Do not place special 'unsupported' type folders in zip files, they must\n    be uncompressed directories to work properly.  Note that you may place\n    zip files inside of 'unsupported' type folders, though.\n");
                continue;
            }
            if (zipEntry.getName().toLowerCase().endsWith(".txt") || Math.max(file.lastModified(), zipEntry.getTime()) < l && set.contains(file.toString())) continue;
            try {
                MechFileParser mechFileParser = new MechFileParser(zipFile.getInputStream(zipEntry), zipEntry.getName());
                Entity entity = mechFileParser.getEntity();
                MechSummary mechSummary = this.getSummary(entity, file, zipEntry.getName());
                vector.addElement(mechSummary);
                set.add(zipEntry.getName());
                bl = true;
                ++n;
                ++this.zipCount;
                Iterator<String> iterator = entity.getFailedEquipment();
                if (!iterator.hasNext()) continue;
                this.loadReport.append("    Loading from zip file").append(" >> ").append(zipEntry.getName()).append("\n");
                while (iterator.hasNext()) {
                    this.loadReport.append("      Failed to load equipment: ").append(iterator.next()).append("\n");
                }
            }
            catch (Exception exception) {
                this.loadReport.append("    Loading from zip file").append(" >> ").append(zipEntry.getName()).append("\n");
                this.loadReport.append("      Unable to load file: ").append(exception.getMessage()).append("\n");
                if (exception.getMessage() == null) continue;
                this.hFailedFiles.put(zipEntry.getName(), exception.getMessage());
            }
        }
        try {
            zipFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadReport.append("  ...loaded ").append(n).append(" files.\n");
        return bl;
    }

    public int getCacheCount() {
        return this.cacheCount;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public int getZipCount() {
        return this.zipCount;
    }

    static {
        ROOT = new File(PreferenceManager.getClientPreferences().getMechDirectory());
        CACHE = new File(ROOT, "units.cache");
    }

    public static interface Listener {
        public void doneLoading();
    }
}

