/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.IGame;
import megamek.common.Infantry;

public class MechWarrior
extends Infantry {
    private static final long serialVersionUID = 6227549671448329770L;
    private int originalRideId;
    private int originalRideExternalId;
    private int pickedUpById = -1;
    private int pickedUpByExternalId = -1;

    public MechWarrior(Entity entity) {
        this.setCrew(entity.getCrew());
        this.setChassis("MechWarrior");
        this.setModel(entity.getCrew().getName());
        this.setWeight(1.0f);
        StringBuffer stringBuffer = new StringBuffer(this.getDisplayName());
        stringBuffer.append(" of ").append(entity.getDisplayName());
        this.displayName = stringBuffer.toString();
        this.setOwner(entity.getOwner());
        this.initializeInternal(1, 0);
        this.setOriginalRideId(entity.getId());
        this.setOriginalRideExternalId(entity.getExternalId());
        IGame iGame = entity.getGame();
        if (iGame != null && iGame.getOptions().booleanOption("armed_mechwarriors")) {
            try {
                this.addEquipment(EquipmentType.get("InfantryRifle"), 0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean isSelectableThisTurn() {
        return this.pickedUpById == -1 && super.isSelectableThisTurn();
    }

    public int getOriginalRideId() {
        return this.originalRideId;
    }

    public void setOriginalRideId(int n) {
        this.originalRideId = n;
    }

    public int getOriginalRideExternalId() {
        return this.originalRideExternalId;
    }

    public void setOriginalRideExternalId(int n) {
        this.originalRideExternalId = n;
    }

    public int getPickedUpByExternalId() {
        return this.pickedUpByExternalId;
    }

    public void setPickedUpByExternalId(int n) {
        this.pickedUpByExternalId = n;
    }

    public int getPickedUpById() {
        return this.pickedUpById;
    }

    public void setPickedUpById(int n) {
        this.pickedUpById = n;
    }

    public int calculateBattleValue() {
        return 0;
    }

    public void newRound(int n) {
        super.newRound(n);
        this.getCrew().setEjected(false);
    }
}

