/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Player;
import megamek.common.Team;
import megamek.common.WeaponComparator;
import megamek.common.WeaponType;

public class SmallCraft
extends Aero {
    protected static String[] LOCATION_ABBRS = new String[]{"NOS", "LS", "RS", "AFT"};
    protected static String[] LOCATION_NAMES = new String[]{"Nose", "Left Side", "Right Side", "Aft"};
    private int nCrew = 0;
    private int nPassenger = 0;

    public void setNCrew(int n) {
        this.nCrew = n;
    }

    public void setNPassenger(int n) {
        this.nPassenger = n;
    }

    public int getNCrew() {
        return this.nCrew;
    }

    public int getNPassenger() {
        return this.nPassenger;
    }

    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public HitData rollHitLocation(int n, int n2) {
        int n3 = Compute.d6(2);
        if (n == 4 || n == 5) {
            int n4 = 2;
            int n5 = Compute.d6(1);
            if (n5 > 3) {
                n4 = 1;
            }
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(1);
                    return new HitData(0, false, 0);
                }
                case 4: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 5: {
                    this.setPotCrit(17);
                    if (n5 > 3) {
                        this.setPotCrit(16);
                    }
                    return new HitData(n4, false, 0);
                }
                case 6: {
                    this.setPotCrit(11);
                    return new HitData(n4, false, 0);
                }
                case 7: {
                    this.setPotCrit(2);
                    return new HitData(n4, false, 0);
                }
                case 8: {
                    this.setPotCrit(13);
                    return new HitData(n4, false, 0);
                }
                case 9: {
                    this.setPotCrit(17);
                    if (n5 > 3) {
                        this.setPotCrit(16);
                    }
                    return new HitData(n4, false, 0);
                }
                case 10: {
                    this.setPotCrit(8);
                    return new HitData(3, false, 0);
                }
                case 11: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
            }
        }
        if (n2 == 0) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(0);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(8);
                    return new HitData(0, false, 0);
                }
                case 4: {
                    this.setPotCrit(2);
                    return new HitData(2, false, 0);
                }
                case 5: {
                    this.setPotCrit(17);
                    return new HitData(2, false, 0);
                }
                case 6: {
                    this.setPotCrit(1);
                    return new HitData(0, false, 0);
                }
                case 7: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 8: {
                    this.setPotCrit(3);
                    return new HitData(0, false, 0);
                }
                case 9: {
                    this.setPotCrit(16);
                    return new HitData(1, false, 0);
                }
                case 10: {
                    this.setPotCrit(2);
                    return new HitData(1, false, 0);
                }
                case 11: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 12: {
                    this.setPotCrit(14);
                    return new HitData(0, false, 0);
                }
            }
        } else if (n2 == 2) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(1);
                    return new HitData(1, false, 0);
                }
                case 4: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 5: {
                    this.setPotCrit(16);
                    return new HitData(0, false, 0);
                }
                case 6: {
                    this.setPotCrit(11);
                    return new HitData(1, false, 0);
                }
                case 7: {
                    this.setPotCrit(2);
                    return new HitData(1, false, 0);
                }
                case 8: {
                    this.setPotCrit(13);
                    return new HitData(1, false, 0);
                }
                case 9: {
                    this.setPotCrit(16);
                    return new HitData(3, false, 0);
                }
                case 10: {
                    this.setPotCrit(8);
                    return new HitData(3, false, 0);
                }
                case 11: {
                    this.setPotCrit(6);
                    return new HitData(1, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
            }
        } else if (n2 == 3) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(1);
                    return new HitData(2, false, 0);
                }
                case 4: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 5: {
                    this.setPotCrit(17);
                    return new HitData(0, false, 0);
                }
                case 6: {
                    this.setPotCrit(11);
                    return new HitData(2, false, 0);
                }
                case 7: {
                    this.setPotCrit(2);
                    return new HitData(2, false, 0);
                }
                case 8: {
                    this.setPotCrit(13);
                    return new HitData(2, false, 0);
                }
                case 9: {
                    this.setPotCrit(17);
                    return new HitData(3, false, 0);
                }
                case 10: {
                    this.setPotCrit(8);
                    return new HitData(3, false, 0);
                }
                case 11: {
                    this.setPotCrit(6);
                    return new HitData(2, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
            }
        } else if (n2 == 1) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(15);
                    return new HitData(3, false, 0);
                }
                case 3: {
                    this.setPotCrit(3);
                    return new HitData(3, false, 0);
                }
                case 4: {
                    this.setPotCrit(2);
                    return new HitData(2, false, 0);
                }
                case 5: {
                    this.setPotCrit(13);
                    return new HitData(2, false, 0);
                }
                case 6: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 7: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
                case 8: {
                    this.setPotCrit(12);
                    return new HitData(3, false, 0);
                }
                case 9: {
                    this.setPotCrit(13);
                    return new HitData(1, false, 0);
                }
                case 10: {
                    this.setPotCrit(2);
                    return new HitData(1, false, 0);
                }
                case 11: {
                    this.setPotCrit(9);
                    return new HitData(3, false, 0);
                }
                case 12: {
                    this.setPotCrit(7);
                    return new HitData(3, false, 0);
                }
            }
        }
        return new HitData(0, false, 0);
    }

    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        if (!this.isSpheroid()) {
            switch (mounted.getLocation()) {
                case 0: {
                    return 11;
                }
                case 2: {
                    if (mounted.isRearMounted()) {
                        return 15;
                    }
                    return 13;
                }
                case 1: {
                    if (mounted.isRearMounted()) {
                        return 14;
                    }
                    return 12;
                }
                case 3: {
                    return 16;
                }
            }
            return 0;
        }
        switch (mounted.getLocation()) {
            case 0: {
                return 11;
            }
            case 2: {
                if (mounted.isRearMounted()) {
                    return 20;
                }
                return 18;
            }
            case 1: {
                if (mounted.isRearMounted()) {
                    return 19;
                }
                return 17;
            }
            case 3: {
                return 16;
            }
        }
        return 0;
    }

    public int getArcswGuns() {
        int n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            if (this.hasWeaponInArc(i, false)) {
                ++n;
            }
            if (!this.hasWeaponInArc(i, true)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasWeaponInArc(int n, boolean bl) {
        boolean bl2 = false;
        for (Mounted mounted : this.getWeaponList()) {
            if (mounted.getLocation() != n || mounted.isRearMounted() != bl) continue;
            bl2 = true;
        }
        return bl2;
    }

    public boolean loadWeapon(Mounted mounted, Mounted mounted2) {
        boolean bl = false;
        WeaponType weaponType = (WeaponType)mounted.getType();
        AmmoType ammoType = (AmmoType)mounted2.getType();
        if (mounted.getLocation() != mounted2.getLocation()) {
            return bl;
        }
        if (mounted2.isAmmoUsable() && !weaponType.hasFlag(16384L) && ammoType.getAmmoType() == weaponType.getAmmoType() && ammoType.getRackSize() == weaponType.getRackSize()) {
            mounted.setLinked(mounted2);
            bl = true;
        }
        return bl;
    }

    public double getArmorWeight() {
        int n = this.getTotalOArmor();
        n -= this.getSI() * this.locations();
        double d = 16.0;
        if (this.isClan()) {
            d = 20.0;
        }
        if (this.isSpheroid()) {
            if (this.weight >= 12500.0f) {
                d = 14.0;
                if (this.isClan()) {
                    d = 17.0;
                }
            } else if (this.weight >= 20000.0f) {
                d = 12.0;
                if (this.isClan()) {
                    d = 14.0;
                }
            } else if (this.weight >= 35000.0f) {
                d = 10.0;
                if (this.isClan()) {
                    d = 12.0;
                }
            } else if (this.weight >= 50000.0f) {
                d = 8.0;
                if (this.isClan()) {
                    d = 10.0;
                }
            } else if (this.weight >= 65000.0f) {
                d = 6.0;
                if (this.isClan()) {
                    d = 7.0;
                }
            }
        } else if (this.weight >= 6000.0f) {
            d = 14.0;
            if (this.isClan()) {
                d = 17.0;
            }
        } else if (this.weight >= 9500.0f) {
            d = 12.0;
            if (this.isClan()) {
                d = 14.0;
            }
        } else if (this.weight >= 12500.0f) {
            d = 10.0;
            if (this.isClan()) {
                d = 12.0;
            }
        } else if (this.weight >= 17500.0f) {
            d = 8.0;
            if (this.isClan()) {
                d = 10.0;
            }
        } else if (this.weight >= 25000.0f) {
            d = 6.0;
            if (this.isClan()) {
                d = 7.0;
            }
        }
        double d2 = d * EquipmentType.getArmorPointMultiplier(this.armorType, this.techLevel);
        double d3 = 0.0;
        while ((int)Math.round(d3 * d2) < n) {
            d3 += 0.5;
        }
        return d3;
    }

    public double getCost() {
        double d = 0.0;
        d += (double)(200000.0f + 10.0f * this.weight);
        d += 200000.0;
        d += (double)(5000 * (this.getNCrew() + this.getNPassenger()));
        d += 80000.0;
        d += 100000.0;
        d += (double)(10000 * this.getArcswGuns());
        d += (double)(100000 * this.getSI());
        d += (double)(25000.0f + 10.0f * this.getWeight());
        double d2 = 0.065;
        if (this.isClan()) {
            d2 = 0.061;
        }
        double d3 = (double)((float)this.getOriginalWalkMP() * this.weight) * d2;
        d += d3 * 1000.0;
        d += (double)((float)(500 * this.getOriginalWalkMP()) * this.weight) / 100.0;
        d += (double)(200 * this.getFuel()) / 80.0;
        d += this.getArmorWeight() * EquipmentType.getArmorCost(this.armorType);
        int n = 2000 + 4000 * this.getHeatType();
        d += (double)(n * this.getHeatSinks());
        double d4 = 1.0f + this.weight / 50.0f;
        return Math.round((d += (double)this.getWeaponsAndEquipmentCost()) * d4);
    }

    public int getMaxEngineHits() {
        return 6;
    }

    public int calculateBattleValue(boolean bl, boolean bl2) {
        int n;
        EquipmentType equipmentType;
        double d = 0.0;
        double d2 = 0.0;
        d += (double)this.getTotalArmor() * 2.5;
        d += (double)this.getSI() * 2.0;
        double d3 = 0.0;
        for (Mounted serializable2 : this.getEquipment()) {
            EquipmentType d4 = serializable2.getType();
            if (serializable2.isDestroyed() || !(d4 instanceof WeaponType && d4.hasFlag(0x800000L) || d4 instanceof AmmoType && ((AmmoType)d4).getAmmoType() == 14) && (!(d4 instanceof MiscType) || !d4.hasFlag(1024L) && !d4.hasFlag(0x2000000L) && !d4.hasFlag(8192L) && !d4.hasFlag(0x800000000L))) continue;
            d3 += d4.getBV(this);
        }
        d += d3;
        d *= 1.0;
        int n2 = 6 + this.getHeatCapacity();
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        double d4 = 0.0;
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType d7 = (WeaponType)mounted.getType();
            double d5 = d7.getHeat();
            if (mounted.isMissing() || mounted.isHit() || mounted.isDestroyed() || mounted.isBreached()) continue;
            if (d7.getAmmoType() == 29 || d7.hasFlag(16384L)) {
                d5 *= 0.25;
            }
            if (d7.getAmmoType() == 20 || d7.getAmmoType() == 33) {
                d5 *= 2.0;
            }
            if (d7.getAmmoType() == 23) {
                d5 *= 6.0;
            }
            if (d7.getAmmoType() == 11 || d7.getAmmoType() == 42 || d7.getAmmoType() == 31) {
                d5 *= 0.5;
            }
            d4 += d5;
            if (d7.hasFlag(131072L) && d7.getAmmoType() != 46 || d7.hasFlag(16384L) || d7.hasFlag(2048L) || d7.getAmmoType() == -1) continue;
            String string = d7.getAmmoType() + ":" + d7.getRackSize();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, d7.getBV(this));
                continue;
            }
            hashMap.put(string, d7.getBV(this) + (Double)hashMap.get(string));
        }
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        boolean bl3 = this.hasTargComp();
        if (d4 <= (double)n2) {
            for (Mounted mounted : this.getWeaponList()) {
                Iterator<Mounted> iterator = (WeaponType)mounted.getType();
                double mounted2 = ((EquipmentType)((Object)iterator)).getBV(this);
                if (mounted.isDestroyed() || ((EquipmentType)((Object)iterator)).hasFlag(0x800000L)) continue;
                if (((EquipmentType)((Object)iterator)).hasFlag(1L) && bl3) {
                    mounted2 *= 1.25;
                }
                if (mounted.getLocation() == 3) {
                    d8 += mounted2;
                    continue;
                }
                d7 += mounted2;
            }
        } else {
            int d12 = 0;
            ArrayList<Mounted> arrayList = this.getWeaponList();
            Collections.sort(arrayList, new WeaponComparator());
            for (Mounted mounted : arrayList) {
                Mounted mounted3;
                equipmentType = (WeaponType)mounted.getType();
                double d9 = equipmentType.getBV(this);
                if (mounted.isDestroyed() || equipmentType.hasFlag(0x800000L)) continue;
                if (equipmentType.hasFlag(0x100000000L)) {
                    double d10 = 0.0;
                    for (Mounted mounted4 : this.getWeaponList()) {
                        if (!mounted4.getType().hasFlag(512L) || mounted4.getLocation() != mounted.getLocation()) continue;
                        d10 += mounted4.getType().getBV(this);
                    }
                    d9 = d10 * 0.67;
                }
                if (equipmentType.hasFlag(1L) && bl3) {
                    d9 *= 1.25;
                }
                if (mounted.getLinkedBy() != null && (mounted3 = mounted.getLinkedBy()).getType() instanceof MiscType && mounted3.getType().hasFlag(512L)) {
                    d9 *= 1.2;
                }
                if (d12 > n2 && ((WeaponType)equipmentType).getHeat() > 0) {
                    d9 /= 2.0;
                }
                if (mounted.getLocation() == 3) {
                    d8 += d9;
                } else {
                    d7 += d9;
                }
                d12 += ((WeaponType)mounted.getType()).getHeat();
            }
        }
        if (d7 > d8) {
            d6 += d7;
            d6 += d8 * 0.5;
        } else {
            d6 += d8;
            d6 += d7 * 0.5;
        }
        double d11 = 0.0;
        for (Mounted mounted : this.getMisc()) {
            equipmentType = (MiscType)mounted.getType();
            if (mounted.isDestroyed() || equipmentType.hasFlag(1024L) || equipmentType.hasFlag(8192L) || equipmentType.hasFlag(0x2000000L) || equipmentType.hasFlag(0x800000000L) || equipmentType.hasFlag(2048L)) continue;
            d11 += ((MiscType)equipmentType).getBV(this);
            if (!equipmentType.hasFlag(0x80000000L)) continue;
            if (this.getArmor(mounted.getLocation(), false) != -3) {
                d11 += (double)this.getArmor(mounted.getLocation());
            }
            if (!this.hasRearArmor(mounted.getLocation()) || this.getArmor(mounted.getLocation(), true) == -3) continue;
            d11 += (double)this.getArmor(mounted.getLocation(), true);
        }
        d6 += d11;
        double d12 = 0.0;
        double d13 = 0.0;
        HashMap<Object, Double> hashMap2 = new HashMap<Object, Double>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Mounted mounted : this.getAmmo()) {
            Object object;
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14 || mounted.getLocation() == -1) continue;
            if (ammoType.getMunitionType() == 262144L && (object = this.getOwner()) != null) {
                if (((Player)object).hasTAG()) {
                    d13 += ammoType.getBV(this);
                } else if (((Player)object).getTeam() != 0 && this.game != null) {
                    Enumeration<Team> enumeration = this.game.getTeams();
                    while (enumeration.hasMoreElements()) {
                        Team team = enumeration.nextElement();
                        if (team.getId() != ((Player)object).getTeam()) continue;
                        if (!team.hasTAG(this.game)) break;
                        d13 += ammoType.getBV(this);
                        break;
                    }
                }
            }
            if (!arrayList.contains(object = ammoType.getAmmoType() + ":" + ammoType.getRackSize())) {
                arrayList.add(object);
            }
            if (!hashMap2.containsKey(object)) {
                hashMap2.put(object, ammoType.getBV(this));
                continue;
            }
            hashMap2.put(object, ammoType.getBV(this) + (Double)hashMap2.get(object));
        }
        for (String string : arrayList) {
            if (hashMap.get(string) != null) {
                if ((Double)hashMap2.get(string) > (Double)hashMap.get(string)) {
                    d12 += ((Double)hashMap.get(string)).doubleValue();
                    continue;
                }
                d12 += ((Double)hashMap2.get(string)).doubleValue();
                continue;
            }
            if (!string.equals(new Integer(36).toString() + "1")) continue;
            d12 += ((Double)hashMap2.get(string)).doubleValue();
        }
        double d14 = this.getOriginalRunMP();
        double d15 = Math.pow(1.0 + (d14 - 5.0) / 10.0, 1.2);
        d15 = (double)Math.round(d15 * 100.0) / 100.0;
        d2 = (d6 += d12) * d15;
        double d16 = 0.0;
        d16 += d13;
        if ((this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.C3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5 || bl) && !bl2 && this.game != null) {
            n = 0;
            n += this.calculateBattleValue(false, true);
            for (Entity entity : this.game.getC3NetworkMembers(this)) {
                if (this.equals(entity) || !this.onSameC3NetworkAs(entity)) continue;
                n += entity.calculateBattleValue(true);
            }
            n = (int)((double)n * 0.05);
            d16 += (double)n;
        }
        n = (int)Math.round(d + d2 + d16);
        double d17 = this.crew.getBVSkillMultiplier();
        int n3 = (int)Math.round((double)n * d17);
        if (bl2) {
            return n;
        }
        return n3;
    }

    public int calculateBattleValue(boolean bl) {
        return this.calculateBattleValue(bl, false);
    }
}

