/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.InitiativeRoll;
import megamek.common.Team;
import megamek.common.TurnVectors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TurnOrdered
implements Serializable {
    private InitiativeRoll initiative = new InitiativeRoll();
    private transient int turns_other = 0;
    private transient int turns_even = 0;
    private transient int turns_multi = 0;

    public int getNormalTurns(IGame iGame) {
        return this.getMultiTurns(iGame) + this.getOtherTurns();
    }

    public int getOtherTurns() {
        return this.turns_other;
    }

    public int getEvenTurns() {
        return this.turns_even;
    }

    public int getMultiTurns(IGame iGame) {
        return (int)Math.ceil((double)this.turns_multi / (double)iGame.getOptions().intOption("inf_proto_move_multi"));
    }

    public void incrementOtherTurns() {
        ++this.turns_other;
    }

    public void incrementEvenTurns() {
        ++this.turns_even;
    }

    public void incrementMultiTurns() {
        ++this.turns_multi;
    }

    public void resetOtherTurns() {
        this.turns_other = 0;
    }

    public void resetEvenTurns() {
        this.turns_even = 0;
    }

    public void resetMultiTurns() {
        this.turns_multi = 0;
    }

    public InitiativeRoll getInitiative() {
        return this.initiative;
    }

    public void clearInitiative() {
        this.getInitiative().clear();
    }

    public static void rollInitiative(Vector<? extends TurnOrdered> vector) {
        Enumeration<? extends TurnOrdered> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TurnOrdered turnOrdered = enumeration.nextElement();
            turnOrdered.clearInitiative();
        }
        TurnOrdered.rollInitAndResolveTies(vector, null);
    }

    public static void rollInitAndResolveTies(Vector<? extends TurnOrdered> vector, Vector<? extends TurnOrdered> vector2) {
        TurnOrdered turnOrdered;
        Enumeration<? extends TurnOrdered> enumeration;
        Object object;
        Object object2 = vector.elements();
        block0: while (object2.hasMoreElements()) {
            object = object2.nextElement();
            int n = 0;
            if (object instanceof Team) {
                n = ((Team)object).getTotalInitBonus();
            }
            if (object instanceof Entity) {
                enumeration = (Entity)object;
                n = ((Entity)((Object)enumeration)).game.getTeamForPlayer(((Entity)((Object)enumeration)).owner).getTotalInitBonus();
            }
            if (vector2 == null) {
                ((TurnOrdered)object).getInitiative().addRoll(n);
                continue;
            }
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                turnOrdered = (TurnOrdered)enumeration.nextElement();
                if (object != turnOrdered) continue;
                ((TurnOrdered)object).getInitiative().replaceRoll(n);
                continue block0;
            }
        }
        object2 = new Vector();
        object = vector.elements();
        while (object.hasMoreElements()) {
            TurnOrdered turnOrdered2 = (TurnOrdered)object.nextElement();
            ((Vector)object2).removeAllElements();
            ((Vector)object2).addElement(turnOrdered2);
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                turnOrdered = enumeration.nextElement();
                if (turnOrdered2 == turnOrdered || !turnOrdered2.getInitiative().equals(turnOrdered.getInitiative())) continue;
                ((Vector)object2).addElement(turnOrdered);
            }
            if (((Vector)object2).size() <= 1) continue;
            TurnOrdered.rollInitAndResolveTies((Vector<? extends TurnOrdered>)object2, null);
        }
    }

    public static TurnVectors generateTurnOrder(Vector<? extends TurnOrdered> vector, IGame iGame) {
        int n;
        int n2;
        int n3;
        int[] nArray = new int[vector.size()];
        int[] nArray2 = new int[vector.size()];
        int n4 = 0;
        int n5 = 0;
        TurnOrdered[] turnOrderedArray = new TurnOrdered[vector.size()];
        int n6 = 0;
        ArrayList<? extends TurnOrdered> arrayList = new ArrayList<TurnOrdered>(vector.size());
        arrayList.addAll(vector);
        Collections.sort(arrayList, new Comparator<TurnOrdered>(){

            @Override
            public int compare(TurnOrdered turnOrdered, TurnOrdered turnOrdered2) {
                return turnOrdered.getInitiative().compareTo(turnOrdered2.getInitiative());
            }
        });
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TurnOrdered turnOrdered;
            turnOrderedArray[n6] = turnOrdered = (TurnOrdered)iterator.next();
            nArray2[n6] = turnOrdered.getNormalTurns(iGame);
            nArray[n6] = turnOrdered.getEvenTurns();
            n4 += nArray[n6];
            n5 += nArray2[n6];
            ++n6;
        }
        int n7 = Integer.MAX_VALUE;
        for (n3 = 0; n3 < n6; ++n3) {
            if (nArray2[n3] == 0 || nArray2[n3] >= n7) continue;
            n7 = nArray2[n3];
        }
        TurnVectors turnVectors = new TurnVectors(n5, n4, n7);
        int n8 = n5;
        while (n8 > 0) {
            for (n3 = 0; n3 < n6; ++n3) {
                if (nArray2[n3] == 0) continue;
                n2 = nArray2[n3] / n7;
                for (n = 0; n < n2; ++n) {
                    turnVectors.addNormal(turnOrderedArray[n3]);
                    int n9 = n3;
                    nArray2[n9] = nArray2[n9] - 1;
                    --n8;
                }
            }
            --n7;
        }
        if (n4 > 0) {
            n7 = Integer.MAX_VALUE;
            for (n3 = 0; n3 < n6; ++n3) {
                if (nArray[n3] == 0 || nArray[n3] >= n7) continue;
                n7 = nArray[n3];
            }
            n8 = n4;
            while (n8 > 0) {
                for (n3 = 0; n3 < n6; ++n3) {
                    if (nArray[n3] == 0) continue;
                    n2 = nArray[n3] / n7;
                    for (n = 0; n < n2; ++n) {
                        turnVectors.addEven(turnOrderedArray[n3]);
                        int n10 = n3;
                        nArray[n10] = nArray[n10] - 1;
                        --n8;
                    }
                }
                --n7;
            }
        }
        return turnVectors;
    }
}

