/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import megamek.common.ASFBay;
import megamek.common.AmmoType;
import megamek.common.Bay;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HeavyVehicleBay;
import megamek.common.HitData;
import megamek.common.Jumpship;
import megamek.common.LightVehicleBay;
import megamek.common.MechBay;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Player;
import megamek.common.SmallCraftBay;
import megamek.common.Team;
import megamek.common.WeaponComparator;
import megamek.common.WeaponType;
import megamek.common.weapons.BayWeapon;

public class Warship
extends Jumpship {
    public static final int LOC_NOSE = 0;
    public static final int LOC_FLS = 1;
    public static final int LOC_FRS = 2;
    public static final int LOC_AFT = 3;
    public static final int LOC_ALS = 4;
    public static final int LOC_ARS = 5;
    public static final int LOC_LBS = 6;
    public static final int LOC_RBS = 7;
    protected static String[] LOCATION_ABBRS = new String[]{"NOS", "FLS", "FRS", "AFT", "ALS", "ARS", "LBS", "RBS"};
    protected static String[] LOCATION_NAMES = new String[]{"Nose", "Left Front Side", "Right Front Side", "Aft", "Aft Left Side", "Aft Right Side", "Left Broadsides", "Right Broadsides"};
    private int[] damThresh = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int[] standard_damage = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int kf_integrity = 0;
    private int sail_integrity = 0;

    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public int locations() {
        return 8;
    }

    public void setThresh(int n, int n2) {
        this.damThresh[n2] = n;
    }

    public int getThresh(int n) {
        return this.damThresh[n];
    }

    public void autoSetThresh() {
        for (int i = 0; i < this.locations(); ++i) {
            this.initializeThresh(i);
        }
    }

    public void setKFIntegrity(int n) {
        this.kf_integrity = n;
    }

    public int getKFIntegrity() {
        return this.kf_integrity;
    }

    public void setSailIntegrity(int n) {
        this.sail_integrity = n;
    }

    public int getSailIntegrity() {
        return this.sail_integrity;
    }

    public void initializeSailIntegrity() {
        int n = 1 + (int)Math.round((30.0 + (double)this.weight / 20000.0) / 20.0);
        this.setSailIntegrity(n);
    }

    public void initializeKFIntegrity() {
        int n = (int)Math.round(2.0 + 0.4525 * (double)this.weight / 25000.0);
        this.setKFIntegrity(n);
    }

    public boolean canJump() {
        return this.kf_integrity > 0;
    }

    public void initializeThresh(int n) {
        int n2 = (int)Math.ceil((double)this.getArmor(n) / 10.0);
        this.setThresh(n2, n);
    }

    public int getStandardDamage(int n) {
        return this.standard_damage[n];
    }

    public void resetStandardDamage() {
        for (int i = 0; i < this.locations(); ++i) {
            this.standard_damage[i] = 0;
        }
    }

    public void addStandardDamage(int n, HitData hitData) {
        this.standard_damage[hitData.getLocation()] = this.standard_damage[hitData.getLocation()] + n;
    }

    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        switch (mounted.getLocation()) {
            case 0: {
                return 11;
            }
            case 2: {
                return 18;
            }
            case 1: {
                return 17;
            }
            case 5: {
                return 20;
            }
            case 4: {
                return 19;
            }
            case 3: {
                return 16;
            }
            case 6: {
                return 21;
            }
            case 7: {
                return 22;
            }
        }
        return 0;
    }

    public int calculateBattleValue(boolean bl, boolean bl2) {
        EquipmentType equipmentType;
        double d = 0.0;
        double d2 = 0.0;
        d += (double)(this.getTotalArmor() * 25);
        d += (double)(this.getSI() * 20);
        double d3 = 0.0;
        for (Mounted serializable2 : this.getEquipment()) {
            EquipmentType d4 = serializable2.getType();
            if (serializable2.isDestroyed() || !(d4 instanceof WeaponType && d4.hasFlag(0x800000L) || d4 instanceof AmmoType && ((AmmoType)d4).getAmmoType() == 14) && (!(d4 instanceof MiscType) || !d4.hasFlag(1024L) && !d4.hasFlag(0x2000000L) && !d4.hasFlag(8192L) && !d4.hasFlag(0x800000000L))) continue;
            d3 += d4.getBV(this);
        }
        d += d3;
        d *= 1.0;
        int n = this.getHeatCapacity();
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        double d4 = 0.0;
        for (Mounted mounted : this.getTotalWeaponList()) {
            WeaponType d7 = (WeaponType)mounted.getType();
            if (d7 instanceof BayWeapon) continue;
            double d5 = d7.getHeat();
            if (mounted.isMissing() || mounted.isHit() || mounted.isDestroyed() || mounted.isBreached()) continue;
            if (d7.getAmmoType() == 29 || d7.hasFlag(16384L)) {
                d5 *= 0.25;
            }
            if (d7.getAmmoType() == 20 || d7.getAmmoType() == 33) {
                d5 *= 2.0;
            }
            if (d7.getAmmoType() == 23) {
                d5 *= 6.0;
            }
            if (d7.getAmmoType() == 11 || d7.getAmmoType() == 42 || d7.getAmmoType() == 31) {
                d5 *= 0.5;
            }
            d4 += d5;
            if (d7.hasFlag(131072L) && d7.getAmmoType() != 46 || d7.hasFlag(16384L) || d7.hasFlag(2048L) || d7.getAmmoType() == -1) continue;
            String string = d7.getAmmoType() + ":" + d7.getRackSize();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, d7.getBV(this));
                continue;
            }
            hashMap.put(string, d7.getBV(this) + (Double)hashMap.get(string));
        }
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        boolean bl3 = this.hasTargComp();
        if (d4 <= (double)n) {
            for (Mounted mounted : this.getTotalWeaponList()) {
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (weaponType instanceof BayWeapon) continue;
                double mounted2 = weaponType.getBV(this);
                if (mounted.isDestroyed() || weaponType.hasFlag(0x800000L)) continue;
                if (weaponType.hasFlag(1L) && bl3) {
                    mounted2 *= 1.25;
                }
                if (mounted.getLocation() == 3) {
                    d8 += mounted2;
                    continue;
                }
                d7 += mounted2;
            }
        } else {
            int d12 = 0;
            ArrayList<Mounted> arrayList = this.getTotalWeaponList();
            Collections.sort(arrayList, new WeaponComparator());
            for (Mounted mounted : arrayList) {
                Mounted mounted3;
                equipmentType = (WeaponType)mounted.getType();
                if (equipmentType instanceof BayWeapon) continue;
                double d9 = equipmentType.getBV(this);
                if (mounted.isDestroyed() || equipmentType.hasFlag(0x800000L)) continue;
                if (equipmentType.hasFlag(0x100000000L)) {
                    double d10 = 0.0;
                    for (Mounted mounted4 : this.getTotalWeaponList()) {
                        if (!mounted4.getType().hasFlag(512L) || mounted4.getLocation() != mounted.getLocation()) continue;
                        d10 += mounted4.getType().getBV(this);
                    }
                    d9 = d10 * 0.67;
                }
                if (equipmentType.hasFlag(1L) && bl3) {
                    d9 *= 1.25;
                }
                if (mounted.getLinkedBy() != null && (mounted3 = mounted.getLinkedBy()).getType() instanceof MiscType && mounted3.getType().hasFlag(512L)) {
                    d9 *= 1.2;
                }
                if (d12 > n && ((WeaponType)equipmentType).getHeat() > 0) {
                    d9 /= 2.0;
                }
                if (mounted.getLocation() == 3) {
                    d8 += d9;
                } else {
                    d7 += d9;
                }
                d12 += ((WeaponType)mounted.getType()).getHeat();
            }
        }
        if (d7 > d8) {
            d6 += d7;
            d6 += d8 * 0.5;
        } else {
            d6 += d8;
            d6 += d7 * 0.5;
        }
        double d11 = 0.0;
        for (Mounted mounted : this.getMisc()) {
            equipmentType = (MiscType)mounted.getType();
            if (mounted.isDestroyed() || equipmentType.hasFlag(1024L) || equipmentType.hasFlag(8192L) || equipmentType.hasFlag(0x2000000L) || equipmentType.hasFlag(0x800000000L) || equipmentType.hasFlag(2048L)) continue;
            d11 += ((MiscType)equipmentType).getBV(this);
            if (!equipmentType.hasFlag(0x80000000L)) continue;
            if (this.getArmor(mounted.getLocation(), false) != -3) {
                d11 += (double)this.getArmor(mounted.getLocation());
            }
            if (!this.hasRearArmor(mounted.getLocation()) || this.getArmor(mounted.getLocation(), true) == -3) continue;
            d11 += (double)this.getArmor(mounted.getLocation(), true);
        }
        d6 += d11;
        double d12 = 0.0;
        double d13 = 0.0;
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Mounted mounted : this.getAmmo()) {
            String string;
            Player player;
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14 || mounted.getLocation() == -1) continue;
            double d14 = ammoType.getBV(this);
            if (mounted.byShot()) {
                double d15 = (double)mounted.getShotsLeft() / (double)ammoType.getShots();
                if (ammoType.getAmmoRatio() > 0.0) {
                    d15 = (double)mounted.getShotsLeft() * ammoType.getAmmoRatio();
                }
                d14 *= d15;
            }
            if (ammoType.getMunitionType() == 262144L && (player = this.getOwner()) != null) {
                if (player.hasTAG()) {
                    d13 += d14;
                } else if (player.getTeam() != 0 && this.game != null) {
                    Enumeration<Team> enumeration = this.game.getTeams();
                    while (enumeration.hasMoreElements()) {
                        Team team = enumeration.nextElement();
                        if (team.getId() != player.getTeam()) continue;
                        if (!team.hasTAG(this.game)) break;
                        d13 += d14;
                        break;
                    }
                }
            }
            if (!arrayList.contains(string = ammoType.getAmmoType() + ":" + ammoType.getRackSize())) {
                arrayList.add(string);
            }
            if (!hashMap2.containsKey(string)) {
                hashMap2.put(string, d14);
                continue;
            }
            hashMap2.put(string, d14 + (Double)hashMap2.get(string));
        }
        for (String string : arrayList) {
            if (hashMap.get(string) != null) {
                if ((Double)hashMap2.get(string) > (Double)hashMap.get(string)) {
                    d12 += ((Double)hashMap.get(string)).doubleValue();
                    continue;
                }
                d12 += ((Double)hashMap2.get(string)).doubleValue();
                continue;
            }
            if (!string.equals(new Integer(36).toString() + "1")) continue;
            d12 += ((Double)hashMap2.get(string)).doubleValue();
        }
        double d16 = this.getOriginalWalkMP();
        double d17 = Math.pow(1.0 + (d16 - 5.0) / 10.0, 1.2);
        d17 = (double)Math.round(d17 * 100.0) / 100.0;
        d2 = (d6 += d12) * d17;
        double d18 = 0.0;
        d18 += d13;
        if ((this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.C3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5 || bl) && !bl2 && this.game != null) {
            int n2 = 0;
            n2 += this.calculateBattleValue(false, true);
            for (Entity entity : this.game.getC3NetworkMembers(this)) {
                if (this.equals(entity) || !this.onSameC3NetworkAs(entity)) continue;
                n2 += entity.calculateBattleValue(true);
            }
            n2 = (int)((double)n2 * 0.05);
            d18 += (double)n2;
        }
        int n3 = (int)Math.round(d + d2 + d18);
        double d19 = this.crew.getBVSkillMultiplier();
        int n4 = (int)Math.round((double)n3 * d19);
        if (bl2) {
            return n3;
        }
        return n4;
    }

    public int calculateBattleValue(boolean bl) {
        return this.calculateBattleValue(bl, false);
    }

    public double getCost() {
        double d = 0.0;
        d += (double)(200000.0f + 10.0f * this.weight);
        d += 200000.0;
        d += (double)(5000 * (this.getNCrew() + this.getNPassenger()));
        d += 80000.0;
        d += 100000.0;
        d += (double)(10000 * this.getArcswGuns());
        d += (double)(100000 * this.getSI());
        d += 25000.0;
        d += (double)(100000 * this.getDocks());
        double d2 = (double)((float)this.getOriginalWalkMP() * this.weight) * 0.06;
        d += d2 * 1000.0;
        d += (double)((float)(500 * this.getOriginalWalkMP()) * this.weight) / 100.0;
        d += 1000.0;
        if (this.hasHPG()) {
            d += 1.0E9;
        }
        d += (double)(200 * this.getFuel()) / this.getFuelPerTon();
        d += this.getArmorWeight(this.locations() - 2) * EquipmentType.getArmorCost(this.armorType);
        int n = 2000 + 4000 * this.getHeatType();
        d += (double)(n * this.getHeatSinks());
        double d3 = 0.0;
        d3 += (double)(60000000 + 75000000 * this.getDocks());
        d3 += (double)(25000000 + 5000000 * this.getDocks());
        d3 += 5.0E7;
        d3 += (double)(50000 * this.getKFIntegrity());
        d3 += (double)(50000 * Math.round(30.0f + this.weight / 20000.0f));
        d3 += (double)(500000 + 200000 * this.getDocks());
        d3 *= 5.0;
        if (this.hasLF()) {
            d3 *= 3.0;
        }
        d += d3;
        d += (double)(5000000 * this.getGravDeck());
        d += (double)(10000000 * this.getGravDeckLarge());
        d += (double)(40000000 * this.getGravDeckHuge());
        d += (double)this.getWeaponsAndEquipmentCost();
        int n2 = 0;
        int n3 = 0;
        for (Bay bay : this.getTransportBays()) {
            n2 += bay.getDoors();
            if (bay instanceof MechBay || bay instanceof ASFBay || bay instanceof SmallCraftBay) {
                n3 += 20000 * bay.totalSpace;
            }
            if (!(bay instanceof LightVehicleBay) && !(bay instanceof HeavyVehicleBay)) continue;
            n3 += 20000 * bay.totalSpace;
        }
        d += (double)(n3 + n2 * 1000);
        double d4 = 2.0;
        return Math.round((d += (double)(5000 * (this.getLifeBoats() + this.getEscapePods()))) * d4);
    }
}

