/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import java.util.Enumeration;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.GunEmplacement;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MovePath;
import megamek.common.MoveStep;
import megamek.common.Tank;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.VTOL;
import megamek.common.actions.DisplacementAttackAction;

public class DfaAttackAction
extends DisplacementAttackAction {
    private static final long serialVersionUID = 3953889779582616903L;

    public DfaAttackAction(int n, int n2, Coords coords) {
        super(n, n2, coords);
    }

    public DfaAttackAction(int n, int n2, int n3, Coords coords) {
        super(n, n2, n3, coords);
    }

    public static int getDamageTakenBy(Entity entity) {
        return (int)Math.ceil((double)entity.getWeight() / 5.0);
    }

    public static int getDamageFor(Entity entity, boolean bl) {
        int n = (int)Math.ceil((double)entity.getWeight() / 10.0 * 3.0);
        if (bl) {
            n = Math.max(1, n / 10);
        }
        return n;
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, MovePath movePath) {
        MoveStep moveStep;
        Entity entity = iGame.getEntity(n);
        if (targetable == null) {
            return new ToHitData(Integer.MAX_VALUE, "Target is null");
        }
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        Coords coords = entity.getPosition();
        MoveStep moveStep2 = null;
        if (entity instanceof Infantry) {
            return new ToHitData(Integer.MAX_VALUE, "Infantry can't D.F.A.");
        }
        if (entity.getJumpType() == 3) {
            return new ToHitData(Integer.MAX_VALUE, "Can't D.F.A. using mechanical jump boosters.");
        }
        if (!movePath.contains(9)) {
            return new ToHitData(Integer.MAX_VALUE, "D.F.A. action not found in movment path");
        }
        if (!movePath.contains(7)) {
            return new ToHitData(Integer.MAX_VALUE, "D.F.A. must involve jumping");
        }
        if (entity2 != null && -1 != entity2.getTransportId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is a passenger.");
        }
        if (entity2 != null && -1 != entity2.getSwarmTargetId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is swarming a Mek.");
        }
        movePath.compile(iGame, entity);
        Enumeration<MoveStep> enumeration = movePath.getSteps();
        while (enumeration.hasMoreElements() && (moveStep = enumeration.nextElement()).isLegal()) {
            if (moveStep.getType() == 9) {
                moveStep2 = moveStep;
                continue;
            }
            coords = moveStep.getPosition();
        }
        if (moveStep2 == null || !targetable.getPosition().equals(moveStep2.getPosition())) {
            return new ToHitData(Integer.MAX_VALUE, "Could not reach target with movement");
        }
        if (entity2 != null && !entity2.isDone()) {
            return new ToHitData(Integer.MAX_VALUE, "Target must be done with movement");
        }
        return DfaAttackAction.toHit(iGame, n, targetable, coords);
    }

    public ToHitData toHit(IGame iGame) {
        Entity entity = iGame.getEntity(this.getEntityId());
        return DfaAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()), entity.getPosition());
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, Coords coords) {
        Entity entity = iGame.getEntity(n);
        if (entity == null) {
            throw new IllegalArgumentException("Attacker is null");
        }
        if (targetable == null) {
            return new ToHitData(Integer.MAX_VALUE, "Target is null");
        }
        int n2 = -1;
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
            n2 = targetable.getTargetId();
        }
        boolean bl = Compute.isInBuilding(iGame, entity2);
        ToHitData toHitData = null;
        int n3 = entity.getElevation() + iGame.getBoard().getHex(entity.getPosition()).getElevation();
        int n4 = targetable.getElevation() + iGame.getBoard().getHex(targetable.getPosition()).getElevation();
        int n5 = n3 + entity.getHeight();
        if (targetable instanceof VTOL && ((VTOL)targetable).isFlying() && n4 - n5 > entity.getJumpMP()) {
            return new ToHitData(Integer.MAX_VALUE, "Elevation difference to high");
        }
        if (entity.equals(entity2)) {
            return new ToHitData(Integer.MAX_VALUE, "You can't target yourself");
        }
        if (entity instanceof Infantry) {
            return new ToHitData(Integer.MAX_VALUE, "Infantry can't dfa");
        }
        if (entity2 != null && -1 != entity2.getTransportId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is a passenger.");
        }
        if (entity2 != null && -1 != entity2.getSwarmTargetId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is swarming a Mek.");
        }
        if (coords.distance(targetable.getPosition()) > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is prone");
        }
        if (entity2 != null && entity2.hasDisplacementAttack()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is already making a charge/DFA attack");
        }
        if (entity2 != null && entity2.isTargetOfDisplacementAttack() && entity2.findTargetedDisplacement().getEntityId() != entity.getId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is the target of another charge/DFA");
        }
        if (bl) {
            return new ToHitData(Integer.MAX_VALUE, "Target is inside building");
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15 || targetable instanceof GunEmplacement) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting adjacent building.");
        }
        if (targetable.getTargetType() == 4 || targetable.getTargetType() == 1 || targetable.getTargetType() == 2) {
            return new ToHitData(Integer.MAX_VALUE, "Invalid attack");
        }
        int n6 = entity.getCrew().getPiloting();
        toHitData = new ToHitData(n6, "base");
        if (entity2 instanceof Infantry) {
            toHitData.addModifier(3, "Infantry target");
        }
        if (entity2 instanceof BattleArmor) {
            toHitData.addModifier(1, "battle armor target");
        }
        toHitData.append(Compute.getAttackerMovementModifier(iGame, n, 3));
        toHitData.append(Compute.getTargetMovementModifier(iGame, n2));
        if (entity2 != null && entity.getCrew().getPiloting() != entity2.getCrew().getPiloting()) {
            toHitData.addModifier(entity.getCrew().getPiloting() - entity2.getCrew().getPiloting(), "piloting skill differential");
        }
        if (entity.isSpotting()) {
            toHitData.addModifier(1, "attacker is spotting");
        }
        if (entity2 != null && entity2.isProne()) {
            toHitData.addModifier(-2, "target prone and adjacent");
        }
        if (entity instanceof Mech && ((Mech)entity).getCockpitType() == 1) {
            int n7;
            int n8 = entity.getBadCriticals(0, 1, 0);
            if (n8 + (n7 = entity.getBadCriticals(0, 1, 1)) == 3) {
                return new ToHitData(Integer.MAX_VALUE, "Sensors Completely Destroyed for Torso-Mounted Cockpit");
            }
            if (n8 == 2) {
                toHitData.addModifier(4, "Head Sensors Destroyed for Torso-Mounted Cockpit");
            }
        }
        toHitData.append(Compute.getImmobileMod(entity2));
        toHitData.append(DfaAttackAction.nightModifiers(iGame, targetable, null, entity));
        Compute.modifyPhysicalBTHForAdvantages(entity, entity2, toHitData, iGame);
        if (entity2 != null) {
            if (entity2 instanceof Tank) {
                toHitData.setSideTable(0);
                toHitData.setHitTable(0);
            } else if (entity2.isProne()) {
                toHitData.setSideTable(1);
                toHitData.setHitTable(0);
            } else {
                toHitData.setSideTable(entity2.sideTable(coords));
                toHitData.setHitTable(1);
            }
        }
        return toHitData;
    }
}

