/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.AbstractAttackAction;

public class ThrashAttackAction
extends AbstractAttackAction {
    private static final long serialVersionUID = -1527653560370040648L;

    public ThrashAttackAction(int n, int n2) {
        super(n, n2);
    }

    public ThrashAttackAction(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public ThrashAttackAction(int n, Targetable targetable) {
        super(n, targetable.getTargetType(), targetable.getTargetId());
    }

    public ToHitData toHit(IGame iGame) {
        Entity entity = this.getEntity(iGame);
        Targetable targetable = this.getTarget(iGame);
        if (entity == null || targetable == null) {
            throw new IllegalArgumentException("Attacker or target not valid");
        }
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        if (!(entity instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Only mechs can thrash at infantry");
        }
        if (!entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Only prone mechs can thrash at infantry");
        }
        if (entity2 == null || !(entity2 instanceof Infantry)) {
            return new ToHitData(Integer.MAX_VALUE, "Can only thrash at infantry");
        }
        if (-1 != entity2.getSwarmTargetId()) {
            return new ToHitData(Integer.MAX_VALUE, "Can't thrash at swarming infantry");
        }
        if (targetable.getPosition() == null || entity.getPosition().distance(targetable.getPosition()) > 0) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in same hex");
        }
        if (targetable.getElevation() != entity.getElevation()) {
            return new ToHitData(Integer.MAX_VALUE, "Target not at same elevation");
        }
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        if (iHex.containsTerrain(1) || iHex.containsTerrain(23) || iHex.containsTerrain(2) || iHex.containsTerrain(3) || iHex.containsTerrain(33) || iHex.containsTerrain(10)) {
            return new ToHitData(Integer.MAX_VALUE, "Not a clear or pavement hex.");
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 4 || targetable.getTargetType() == 15 || targetable.getTargetType() == 16 || targetable.getTargetType() == 1 || targetable.getTargetType() == 2) {
            return new ToHitData(Integer.MAX_VALUE, "Invalid attack");
        }
        for (int i = 0; i < entity.locations(); ++i) {
            if (!entity.weaponFiredFrom(i)) continue;
            return new ToHitData(Integer.MAX_VALUE, "Weapons fired from " + entity.getLocationName(i) + " this turn");
        }
        if (entity.isLocationBad(4) && entity.isLocationBad(5) && entity.isLocationBad(6) && entity.isLocationBad(7)) {
            return new ToHitData(Integer.MAX_VALUE, "Mech has no arms or legs to thrash");
        }
        return new ToHitData(Integer.MIN_VALUE, "thrash attacks always hit");
    }

    public static int getDamageFor(Entity entity) {
        int n = Math.round(entity.getWeight() / 3.0f);
        return n;
    }
}

