/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.util.BuildingBlock;

public class BLKFile {
    BuildingBlock dataFile;
    public static final int FUSION = 0;
    public static final int ICE = 1;
    public static final int XL = 2;
    public static final int XXL = 3;
    public static final int LIGHT = 4;
    public static final int COMPACT = 5;

    protected void loadEquipment(Entity entity, String string, int n) throws EntityLoadingException {
        String[] stringArray = this.dataFile.getDataAsString(string + " Equipment");
        if (stringArray == null) {
            return;
        }
        String string2 = entity.getTechLevel() == 2 ? "Clan " : "IS ";
        if (stringArray[0] != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i].trim();
                EquipmentType equipmentType = EquipmentType.get(string3);
                if (equipmentType == null) {
                    equipmentType = EquipmentType.get(string2 + string3);
                }
                if (equipmentType != null) {
                    try {
                        entity.addEquipment(equipmentType, n);
                        continue;
                    }
                    catch (LocationFullException locationFullException) {
                        throw new EntityLoadingException(locationFullException.getMessage());
                    }
                }
                if (string3 == "0") continue;
                entity.addFailedEquipment(string3);
            }
        }
    }

    public boolean isMine() {
        return this.dataFile.exists("blockversion");
    }

    static int translateEngineCode(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 0;
        }
        if (n == 2) {
            return 2;
        }
        if (n == 4) {
            return 3;
        }
        if (n == 3) {
            return 4;
        }
        if (n == 5) {
            return 5;
        }
        return -1;
    }
}

