/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import java.util.Vector;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.Mounted;
import megamek.common.SupportVTOL;
import megamek.common.TroopSpace;
import megamek.common.loaders.BLKFile;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;
import megamek.common.util.BuildingBlock;

public class BLKSupportVTOLFile
extends BLKFile
implements IMechLoader {
    private static final String[] MOVES = new String[]{"", "", "", "Tracked", "Wheeled", "Hover", "VTOL"};

    public BLKSupportVTOLFile(BuildingBlock buildingBlock) {
        this.dataFile = buildingBlock;
    }

    public Entity getEntity() throws EntityLoadingException {
        int n;
        int n2;
        SupportVTOL supportVTOL = new SupportVTOL();
        if (!this.dataFile.exists("barrating")) {
            throw new EntityLoadingException("Could not find barrating block.");
        }
        supportVTOL.setBARRating(this.dataFile.getDataAsInt("barrating")[0]);
        if (!this.dataFile.exists("Name")) {
            throw new EntityLoadingException("Could not find name block.");
        }
        supportVTOL.setChassis(this.dataFile.getDataAsString("Name")[0]);
        if (this.dataFile.exists("Model") && this.dataFile.getDataAsString("Model")[0] != null) {
            supportVTOL.setModel(this.dataFile.getDataAsString("Model")[0]);
        } else {
            supportVTOL.setModel("");
        }
        if (!this.dataFile.exists("year")) {
            throw new EntityLoadingException("Could not find year block.");
        }
        supportVTOL.setYear(this.dataFile.getDataAsInt("year")[0]);
        if (!this.dataFile.exists("type")) {
            throw new EntityLoadingException("Could not find type block.");
        }
        if (this.dataFile.getDataAsString("type")[0].equals("IS")) {
            if (supportVTOL.getYear() == 3025) {
                supportVTOL.setTechLevel(0);
            } else {
                supportVTOL.setTechLevel(1);
            }
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 1")) {
            supportVTOL.setTechLevel(0);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 2")) {
            supportVTOL.setTechLevel(1);
        } else if (this.dataFile.getDataAsString("type")[0].equals("IS Level 3")) {
            supportVTOL.setTechLevel(5);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan") || this.dataFile.getDataAsString("type")[0].equals("Clan Level 2")) {
            supportVTOL.setTechLevel(2);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Clan Level 3")) {
            supportVTOL.setTechLevel(6);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (IS Chassis)")) {
            supportVTOL.setTechLevel(5);
            supportVTOL.setMixedTech(true);
        } else if (this.dataFile.getDataAsString("type")[0].equals("Mixed (Clan Chassis)")) {
            supportVTOL.setTechLevel(6);
            supportVTOL.setMixedTech(true);
        } else {
            if (this.dataFile.getDataAsString("type")[0].equals("Mixed")) {
                throw new EntityLoadingException("Unsupported tech base: \"Mixed\" is no longer allowed by itself.  You must specify \"Mixed (IS Chassis)\" or \"Mixed (Clan Chassis)\".");
            }
            throw new EntityLoadingException("Unsupported tech level: " + this.dataFile.getDataAsString("type")[0]);
        }
        if (!this.dataFile.exists("tonnage")) {
            throw new EntityLoadingException("Could not find weight block.");
        }
        supportVTOL.setWeight(this.dataFile.getDataAsFloat("tonnage")[0]);
        if (!this.dataFile.exists("motion_type")) {
            throw new EntityLoadingException("Could not find movement block.");
        }
        String string = this.dataFile.getDataAsString("motion_type")[0];
        int n3 = -1;
        for (n2 = 0; n2 < MOVES.length; ++n2) {
            if (!string.equals(MOVES[n2])) continue;
            n3 = n2;
            break;
        }
        if (n3 == -1) {
            throw new EntityLoadingException("Invalid movment type: " + string);
        }
        supportVTOL.setMovementMode(n3);
        if (this.dataFile.exists("transporters")) {
            String[] stringArray = this.dataFile.getDataAsString("transporters");
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].startsWith("TroopSpace:", 0)) continue;
                Double d = new Double(stringArray[n].substring(11));
                supportVTOL.addTransporter(new TroopSpace(d));
            }
        }
        n2 = 0;
        if (this.dataFile.exists("engine_type")) {
            n2 = this.dataFile.getDataAsInt("engine_type")[0];
        }
        n = 2;
        if (supportVTOL.isClan()) {
            n |= 1;
        }
        if (!this.dataFile.exists("cruiseMP")) {
            throw new EntityLoadingException("Could not find cruiseMP block.");
        }
        int n4 = this.dataFile.getDataAsInt("cruiseMP")[0] * (int)supportVTOL.getWeight() - supportVTOL.getSuspensionFactor();
        supportVTOL.setEngine(new Engine(n4, BLKFile.translateEngineCode(n2), n));
        if (this.dataFile.exists("armor_type")) {
            supportVTOL.setArmorType(this.dataFile.getDataAsInt("armor_type")[0]);
        }
        if (this.dataFile.exists("armor_tech")) {
            supportVTOL.setArmorTechLevel(this.dataFile.getDataAsInt("armor_tech")[0]);
        }
        if (this.dataFile.exists("internal_type")) {
            supportVTOL.setStructureType(this.dataFile.getDataAsInt("internal_type")[0]);
        }
        if (!this.dataFile.exists("armor")) {
            throw new EntityLoadingException("Could not find armor block.");
        }
        int[] nArray = this.dataFile.getDataAsInt("armor");
        if (nArray.length != 5) {
            throw new EntityLoadingException("Incorrect armor array length");
        }
        int[] nArray2 = new int[nArray.length + 1];
        nArray2[0] = 0;
        System.arraycopy(nArray, 0, nArray2, 1, nArray.length);
        for (int i = 0; i < nArray2.length; ++i) {
            supportVTOL.initializeArmor(nArray2[i], i);
        }
        supportVTOL.autoSetInternal();
        this.loadEquipment(supportVTOL, "Front", 1);
        this.loadEquipment(supportVTOL, "Right", 2);
        this.loadEquipment(supportVTOL, "Left", 3);
        this.loadEquipment(supportVTOL, "Rear", 4);
        this.loadEquipment(supportVTOL, "Body", 0);
        if (this.dataFile.exists("omni")) {
            supportVTOL.setOmni(true);
        }
        return supportVTOL;
    }

    public static void encode(String string, SupportVTOL supportVTOL) {
        String string2;
        BuildingBlock buildingBlock = new BuildingBlock();
        buildingBlock.createNewBlock();
        buildingBlock.writeBlockData("UnitType", "SupportVTOL");
        buildingBlock.writeBlockData("blockversion", 1);
        buildingBlock.writeBlockData("Name", supportVTOL.getChassis());
        buildingBlock.writeBlockData("Model", supportVTOL.getModel());
        buildingBlock.writeBlockData("year", supportVTOL.getYear());
        if (supportVTOL.isMixedTech()) {
            string2 = !supportVTOL.isClan() ? "Mixed (IS Chassis)" : "Mixed (Clan Chassis)";
        } else {
            switch (supportVTOL.getTechLevel()) {
                case 0: {
                    string2 = "IS Level 1";
                    break;
                }
                case 1: {
                    string2 = "IS Level 2";
                    break;
                }
                default: {
                    string2 = "IS Level 3";
                    break;
                }
                case 2: {
                    string2 = "Clan Level 2";
                    break;
                }
                case 6: {
                    string2 = "Clan Level 3";
                }
            }
        }
        buildingBlock.writeBlockData("type", string2);
        buildingBlock.writeBlockData("tonnage", supportVTOL.getWeight());
        buildingBlock.writeBlockData("motion_type", supportVTOL.getMovementModeAsString());
        if (supportVTOL.getTroopCarryingSpace() > 0) {
            buildingBlock.writeBlockData("transporters", "TroopSpace: " + supportVTOL.getTroopCarryingSpace());
        }
        int n = 0;
        switch (supportVTOL.getEngine().getEngineType()) {
            case 0: {
                n = 1;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 4: {
                n = 3;
            }
        }
        buildingBlock.writeBlockData("engine_type", n);
        buildingBlock.writeBlockData("cruiseMP", supportVTOL.getOriginalWalkMP());
        if (supportVTOL.getArmorType() != 0) {
            buildingBlock.writeBlockData("armor_type", supportVTOL.getArmorType());
            buildingBlock.writeBlockData("armor_tech", supportVTOL.getArmorTechLevel());
        }
        if (supportVTOL.getStructureType() != 0) {
            buildingBlock.writeBlockData("internal_type", supportVTOL.getStructureType());
        }
        if (supportVTOL.isOmni()) {
            buildingBlock.writeBlockData("omni", 1);
        }
        int[] nArray = new int[supportVTOL.locations() - 1];
        for (int i = 1; i < supportVTOL.locations(); ++i) {
            nArray[i - 1] = supportVTOL.getOArmor(i);
        }
        buildingBlock.writeBlockData("armor", nArray);
        Vector vector = new Vector(supportVTOL.locations());
        for (int i = 0; i < supportVTOL.locations(); ++i) {
            vector.add(new Vector());
        }
        for (Mounted mounted : supportVTOL.getEquipment()) {
            String string3 = mounted.getType().getInternalName();
            int n2 = mounted.getLocation();
            if (n2 == -1) continue;
            ((Vector)vector.get(n2)).add(string3);
        }
        for (int i = 0; i < supportVTOL.locations(); ++i) {
            buildingBlock.writeBlockData(supportVTOL.getLocationName(i) + " Equipment", (Vector)vector.get(i));
        }
        buildingBlock.writeBlockFile(string);
    }
}

