/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import megamek.common.Board;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Hex;
import megamek.common.IBoard;
import megamek.common.IHex;
import megamek.common.ITerrain;
import megamek.common.ITerrainFactory;
import megamek.common.MapSettings;
import megamek.common.Terrains;
import megamek.common.util.BuildingTemplate;
import megamek.common.util.CityBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoardUtilities {
    public static IBoard combine(int n, int n2, int n3, int n4, IBoard[] iBoardArray, int n5) {
        int n6 = n * n3;
        int n7 = n2 * n4;
        IHex[] iHexArray = new IHex[n6 * n7];
        boolean bl = true;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                IBoard iBoard = iBoardArray[i * n3 + j];
                if (iBoard.getWidth() != n || iBoard.getHeight() != n2) {
                    throw new IllegalArgumentException("board is the wrong size, expected " + n + "x" + n2 + ", got " + iBoard.getWidth() + "x" + iBoard.getHeight());
                }
                BoardUtilities.copyBoardInto(iHexArray, n6, j * n, i * n2, iBoardArray[i * n3 + j]);
                if (iBoardArray[i * n3 + j].getRoadsAutoExit()) continue;
                bl = false;
            }
        }
        Board board = new Board();
        board.setRoadsAutoExit(bl);
        board.newData(n6, n7, iHexArray);
        board.setType(n5);
        return board;
    }

    protected static void copyBoardInto(IHex[] iHexArray, int n, int n2, int n3, IBoard iBoard) {
        for (int i = 0; i < iBoard.getHeight(); ++i) {
            for (int j = 0; j < iBoard.getWidth(); ++j) {
                iHexArray[(i + n3) * n + j + n2] = iBoard.getHex(j, i);
            }
        }
    }

    public static IBoard generateRandom(MapSettings mapSettings) {
        int n;
        int n2;
        int n3;
        int[][] nArray = new int[mapSettings.getBoardWidth()][mapSettings.getBoardHeight()];
        double d = (double)(mapSettings.getBoardWidth() * mapSettings.getBoardHeight()) / 272.0;
        BoardUtilities.generateElevation(mapSettings.getHilliness(), mapSettings.getBoardWidth(), mapSettings.getBoardHeight(), mapSettings.getRange() + 1, mapSettings.getProbInvert(), mapSettings.getInvertNegativeTerrain(), nArray, mapSettings.getAlgorithmToUse());
        IHex[] iHexArray = new IHex[mapSettings.getBoardWidth() * mapSettings.getBoardHeight()];
        int n4 = 0;
        for (int i = 0; i < mapSettings.getBoardHeight(); ++i) {
            for (int j = 0; j < mapSettings.getBoardWidth(); ++j) {
                iHexArray[n4++] = mapSettings.getMedium() == 2 ? new Hex(0, "space:1", mapSettings.getTheme()) : new Hex(nArray[j][i], "", mapSettings.getTheme());
            }
        }
        Board board = new Board(mapSettings.getBoardWidth(), mapSettings.getBoardHeight(), iHexArray);
        if (mapSettings.getMedium() == 2) {
            board.setType(2);
            return board;
        }
        HashMap<IHex, Point> hashMap = new HashMap<IHex, Point>(2 * mapSettings.getBoardWidth() * mapSettings.getBoardHeight());
        for (n3 = 0; n3 < mapSettings.getBoardHeight(); ++n3) {
            for (n2 = 0; n2 < mapSettings.getBoardWidth(); n2 += 1) {
                hashMap.put(board.getHex(n2, n3), new Point(n2, n3));
            }
        }
        for (n3 = mapSettings.getMountainPeaks(); n3 > 0; --n3) {
            n2 = mapSettings.getMountainHeightMin() + Compute.randomInt(1 + mapSettings.getMountainHeightMax() - mapSettings.getMountainHeightMin());
            n = mapSettings.getMountainWidthMin() + Compute.randomInt(1 + mapSettings.getMountainWidthMax() - mapSettings.getMountainWidthMin());
            int n5 = board.getWidth();
            int n6 = board.getHeight();
            Coords coords = new Coords(n5 / 4 + Compute.randomInt((n5 + 1) / 2), n6 / 4 + Compute.randomInt((n6 + 1) / 2));
            BoardUtilities.generateMountain(board, n, coords, n2, mapSettings.getMountainStyle());
        }
        if (mapSettings.getCliffs() > 0) {
            BoardUtilities.addCliffs(board, mapSettings.getCliffs());
        }
        n2 = mapSettings.getMinForestSpots();
        if (mapSettings.getMaxForestSpots() > 0) {
            n2 += Compute.randomInt(mapSettings.getMaxForestSpots());
        }
        n2 = (int)((double)n2 * d);
        for (n = 0; n < n2; n += 1) {
            BoardUtilities.placeSomeTerrain(board, 1, mapSettings.getProbHeavy(), mapSettings.getMinForestSize(), mapSettings.getMaxForestSize(), hashMap, true);
        }
        n2 = mapSettings.getMinRoughSpots();
        if (mapSettings.getMaxRoughSpots() > 0) {
            n2 += Compute.randomInt(mapSettings.getMaxRoughSpots());
        }
        n2 = (int)((double)n2 * d);
        for (n = 0; n < n2; n += 1) {
            BoardUtilities.placeSomeTerrain(board, 2, 0, mapSettings.getMinRoughSize(), mapSettings.getMaxRoughSize(), hashMap, true);
        }
        n2 = mapSettings.getMinSwampSpots();
        if (mapSettings.getMaxSwampSpots() > 0) {
            n2 += Compute.randomInt(mapSettings.getMaxSwampSpots());
        }
        n2 = (int)((double)n2 * d);
        for (n = 0; n < n2; n += 1) {
            BoardUtilities.placeSomeTerrain(board, 9, 0, mapSettings.getMinSwampSize(), mapSettings.getMaxSwampSize(), hashMap, false);
        }
        n2 = mapSettings.getMinFortifiedSpots();
        if (mapSettings.getMaxFortifiedSpots() > 0) {
            n2 += Compute.randomInt(mapSettings.getMaxFortifiedSpots());
        }
        n2 = (int)((double)n2 * d);
        for (n = 0; n < n2; n += 1) {
            BoardUtilities.placeSomeTerrain(board, 21, 0, mapSettings.getMinFortifiedSize(), mapSettings.getMaxFortifiedSize(), hashMap, false);
        }
        n2 = mapSettings.getMinRubbleSpots();
        if (mapSettings.getMaxRubbleSpots() > 0) {
            n2 += Compute.randomInt(mapSettings.getMaxRubbleSpots());
        }
        n2 = (int)((double)n2 * d);
        for (n = 0; n < n2; n += 1) {
            BoardUtilities.placeSomeTerrain(board, 3, 0, mapSettings.getMinRubbleSize(), mapSettings.getMaxRubbleSize(), hashMap, true);
        }
        n2 = mapSettings.getMinWaterSpots();
        if (mapSettings.getMaxWaterSpots() > 0) {
            n2 += Compute.randomInt(mapSettings.getMaxWaterSpots());
        }
        n2 = (int)((double)n2 * d);
        for (n = 0; n < n2; n += 1) {
            BoardUtilities.placeSomeTerrain(board, 4, mapSettings.getProbDeep(), mapSettings.getMinWaterSize(), mapSettings.getMaxWaterSize(), hashMap, true);
        }
        n2 = mapSettings.getMinPavementSpots();
        if (mapSettings.getMaxPavementSpots() > 0) {
            n2 += Compute.randomInt(mapSettings.getMaxPavementSpots());
        }
        n2 = (int)((double)n2 * d);
        for (n = 0; n < n2; n += 1) {
            BoardUtilities.placeSomeTerrain(board, 5, 0, mapSettings.getMinPavementSize(), mapSettings.getMaxPavementSize(), hashMap, true);
        }
        n2 = mapSettings.getMinIceSpots();
        if (mapSettings.getMaxIceSpots() > 0) {
            n2 += Compute.randomInt(mapSettings.getMaxIceSpots());
        }
        n2 = (int)((double)n2 * d);
        for (n = 0; n < n2; n += 1) {
            BoardUtilities.placeSomeTerrain(board, 20, 0, mapSettings.getMinIceSize(), mapSettings.getMaxIceSize(), hashMap, true);
        }
        if (Compute.randomInt(100) < mapSettings.getProbCrater()) {
            BoardUtilities.addCraters(board, mapSettings.getMinRadius(), mapSettings.getMaxRadius(), (int)((double)mapSettings.getMinCraters() * d), (int)((double)mapSettings.getMaxCraters() * d));
        }
        if (Compute.randomInt(100) < mapSettings.getProbRiver()) {
            BoardUtilities.addRiver(board, hashMap);
        }
        if (Compute.randomInt(100) < mapSettings.getProbFlood()) {
            BoardUtilities.PostProcessFlood(iHexArray, mapSettings.getFxMod());
        }
        if (Compute.randomInt(100) < mapSettings.getProbDrought()) {
            BoardUtilities.PostProcessDrought(iHexArray, mapSettings.getFxMod());
        }
        if (Compute.randomInt(100) < mapSettings.getProbFreeze()) {
            BoardUtilities.PostProcessDeepFreeze(iHexArray, mapSettings.getFxMod());
        }
        if (Compute.randomInt(100) < mapSettings.getProbForestFire()) {
            BoardUtilities.PostProcessForestFire(iHexArray, mapSettings.getFxMod());
        }
        n = 0;
        if (Compute.randomInt(100) < mapSettings.getProbRoad()) {
            n = 1;
        }
        ArrayList<BuildingTemplate> arrayList = mapSettings.getBoardBuildings();
        CityBuilder cityBuilder = new CityBuilder(mapSettings, board);
        if (arrayList.size() == 0) {
            arrayList = cityBuilder.generateCity(n != 0);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            BoardUtilities.placeBuilding(board, arrayList.get(i));
        }
        return board;
    }

    private static void placeBuilding(IBoard iBoard, BuildingTemplate buildingTemplate) {
        int n = buildingTemplate.getType();
        int n2 = buildingTemplate.getCF();
        int n3 = buildingTemplate.getHeight();
        ITerrainFactory iTerrainFactory = Terrains.getTerrainFactory();
        ArrayList<IHex> arrayList = new ArrayList<IHex>();
        int n4 = 0;
        Iterator<Coords> iterator = buildingTemplate.getCoords();
        while (iterator.hasNext()) {
            Coords coords = iterator.next();
            IHex iHex = iBoard.getHex(coords);
            int n5 = 0;
            for (int i = 0; i < 6; ++i) {
                if (!buildingTemplate.containsCoords(coords.translated(i))) continue;
                n5 |= 1 << i;
            }
            iHex.removeAllTerrains();
            iHex.addTerrain(iTerrainFactory.createTerrain(5, 1));
            iHex.addTerrain(iTerrainFactory.createTerrain(10, n, true, n5));
            iHex.addTerrain(iTerrainFactory.createTerrain(11, n2));
            iHex.addTerrain(iTerrainFactory.createTerrain(12, n3));
            arrayList.add(iHex);
            n4 += iHex.getElevation();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((IHex)arrayList.get(i)).setElevation(n4 / arrayList.size());
        }
    }

    protected static void placeSomeTerrain(IBoard iBoard, int n, int n2, int n3, int n4, HashMap<IHex, Point> hashMap, boolean bl) {
        int n5;
        Point point = new Point(Compute.randomInt(iBoard.getWidth()), Compute.randomInt(iBoard.getHeight()));
        int n6 = n3;
        if (n4 - n3 > 0) {
            n6 += Compute.randomInt(n4 - n3);
        }
        HashSet<IHex> hashSet = new HashSet<IHex>();
        HashSet<IHex> hashSet2 = new HashSet<IHex>();
        IHex iHex2 = iBoard.getHex(point.x, point.y);
        if (!iHex2.containsTerrain(n)) {
            hashSet2.add(iHex2);
        } else {
            BoardUtilities.findAllUnused(iBoard, n, hashSet, hashSet2, iHex2, hashMap);
        }
        ITerrainFactory iTerrainFactory = Terrains.getTerrainFactory();
        for (n5 = 0; n5 < n6; ++n5) {
            int n7;
            if (hashSet2.isEmpty()) {
                return;
            }
            int n8 = Compute.randomInt(hashSet2.size());
            Iterator<IHex> iterator = hashSet2.iterator();
            for (n7 = 0; n7 < n8 - 1; ++n7) {
                iterator.next();
            }
            iHex2 = iterator.next();
            if (bl) {
                iHex2.removeAllTerrains();
            }
            n7 = Compute.randomInt(100) < n2 ? 2 : 1;
            ITerrain iTerrain = iTerrainFactory.createTerrain(n, n7);
            iHex2.addTerrain(iTerrain);
            hashSet2.remove(iHex2);
            BoardUtilities.findAllUnused(iBoard, n, hashSet, hashSet2, iHex2, hashMap);
        }
        if (n == 4) {
            n5 = Integer.MAX_VALUE;
            for (IHex iHex2 : hashSet2) {
                if (iHex2.getElevation() >= n5) continue;
                n5 = iHex2.getElevation();
            }
            for (IHex iHex2 : hashSet) {
                iHex2.setElevation(n5);
            }
        }
    }

    private static void findAllUnused(IBoard iBoard, int n, HashSet<IHex> hashSet, HashSet<IHex> hashSet2, IHex iHex, HashMap<IHex, Point> hashMap) {
        HashSet<IHex> hashSet3 = new HashSet<IHex>();
        hashSet3.add(iHex);
        do {
            Iterator iterator;
            IHex iHex2;
            if ((iHex2 = (IHex)(iterator = hashSet3.iterator()).next()) == null) continue;
            for (int i = 0; i < 6; ++i) {
                Point point = hashMap.get(iHex2);
                IHex iHex3 = iBoard.getHexInDir(point.x, point.y, i);
                if (iHex3 == null || hashSet.contains(iHex3) || hashSet3.contains(iHex3) || hashSet2.contains(iHex3)) continue;
                (iHex3.containsTerrain(n) ? hashSet3 : hashSet2).add(iHex3);
            }
            hashSet3.remove(iHex2);
            hashSet.add(iHex2);
        } while (!hashSet3.isEmpty());
    }

    public static void addCraters(IBoard iBoard, int n, int n2, int n3, int n4) {
        int n5 = n3;
        if (n4 > n3) {
            n5 += Compute.randomInt(n4 - n3);
        }
        for (int i = 0; i < n5; ++i) {
            int n6;
            int n7 = iBoard.getWidth();
            int n8 = iBoard.getHeight();
            Point point = new Point(Compute.randomInt(n7), Compute.randomInt(n8));
            int n9 = Compute.randomInt(n2 - n + 1) + n;
            int n10 = 3;
            if (n9 < 3) {
                n10 = 1;
            }
            if (n9 >= 3 && n9 <= 8) {
                n10 = 2;
            }
            if (n9 > 14) {
                n10 = 4;
            }
            int n11 = Compute.randomInt(n10) + 1;
            int[] nArray = new int[n9];
            for (n6 = 0; n6 < n9; ++n6) {
                nArray[n6] = BoardUtilities.craterProfile((double)n6 / (double)n9, n11);
            }
            for (n6 = 0; n6 < n8; ++n6) {
                for (int j = 0; j < n7; ++j) {
                    int n12 = (int)BoardUtilities.distance(point, new Point(j, n6));
                    if (n12 >= n9) continue;
                    IHex iHex = iBoard.getHex(j, n6);
                    iHex.setElevation(nArray[n12]);
                }
            }
        }
    }

    public static int craterProfile(double d, int n) {
        double d2 = 0.0;
        d2 = d < 0.75 ? (Math.exp(d * 5.0 / 0.75 - 3.0) - 0.04979) * 1.5 / 7.33926 - 0.5 : (Math.cos((d - 0.75) * 4.0) + 1.0) / 2.0;
        return (int)(d2 * (double)n);
    }

    private static double distance(Point point, Point point2) {
        double d = point.x - point2.x;
        double d2 = point.y - point2.y;
        return Math.sqrt(d * d + d2 * d2);
    }

    public static void addRiver(IBoard iBoard, HashMap<IHex, Point> hashMap) {
        int n = Integer.MAX_VALUE;
        HashSet<IHex> hashSet = new HashSet<IHex>();
        Point point = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = iBoard.getWidth();
        int n6 = iBoard.getHeight();
        if (n5 < 5 || n6 < 5) {
            return;
        }
        switch (Compute.randomInt(4)) {
            case 0: {
                point = new Point(0, Compute.randomInt(5) - 2 + n6 / 2);
                n2 = Compute.randomInt(2) + 1;
                n3 = n2 - 1;
                n4 = n2 + 1;
                break;
            }
            case 1: {
                point = new Point(n5 - 1, Compute.randomInt(5) - 2 + n6 / 2);
                n2 = Compute.randomInt(2) + 4;
                n3 = n2 - 1;
                n4 = (n2 + 1) % 6;
                break;
            }
            case 2: 
            case 3: {
                point = new Point(Compute.randomInt(5) - 2 + n5 / 2, 0);
                n2 = 2;
                n4 = 3;
                n3 = 4;
            }
        }
        IHex iHex2 = iBoard.getHex(point.x, point.y);
        ITerrainFactory iTerrainFactory = Terrains.getTerrainFactory();
        do {
            iHex2.removeAllTerrains();
            iHex2.addTerrain(iTerrainFactory.createTerrain(4, 1));
            hashSet.add(iHex2);
            point = hashMap.get(iHex2);
            hashSet.addAll(BoardUtilities.extendRiverToSide(iBoard, point, Compute.randomInt(3), n3, hashMap));
            hashSet.addAll(BoardUtilities.extendRiverToSide(iBoard, point, Compute.randomInt(3), n4, hashMap));
            switch (Compute.randomInt(4)) {
                case 0: {
                    iHex2 = iBoard.getHexInDir(point.x, point.y, (n2 + 5) % 6);
                    break;
                }
                case 1: {
                    iHex2 = iBoard.getHexInDir(point.x, point.y, (n2 + 1) % 6);
                    break;
                }
                default: {
                    iHex2 = iBoard.getHexInDir(point.x, point.y, n2);
                }
            }
        } while (iHex2 != null);
        HashSet hashSet2 = new HashSet(hashSet);
        while (!hashSet2.isEmpty()) {
            Iterator iterator = hashSet2.iterator();
            iHex2 = (IHex)iterator.next();
            if (iHex2.getElevation() < n) {
                n = iHex2.getElevation();
            }
            hashSet2.remove(iHex2);
            Point point2 = hashMap.get(iHex2);
            for (int i = 0; i < 6; ++i) {
                iHex2 = iBoard.getHexInDir(point2.x, point2.y, i);
                if (iHex2 != null && iHex2.getElevation() < n) {
                    n = iHex2.getElevation();
                }
                hashSet2.remove(iHex2);
            }
        }
        for (IHex iHex2 : hashSet) {
            iHex2.setElevation(n);
        }
    }

    private static HashSet<IHex> extendRiverToSide(IBoard iBoard, Point point, int n, int n2, HashMap<IHex, Point> hashMap) {
        Point point2 = new Point(point);
        HashSet<IHex> hashSet = new HashSet<IHex>();
        IHex iHex = iBoard.getHexInDir(point2.x, point2.y, n2);
        while (iHex != null && n-- > 0) {
            iHex.removeAllTerrains();
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(4, 1));
            hashSet.add(iHex);
            point2 = hashMap.get(iHex);
            iHex = iBoard.getHexInDir(point2.x, point2.y, n2);
        }
        return hashSet;
    }

    protected static void PostProcessFlood(IHex[] iHexArray, int n) {
        ITerrainFactory iTerrainFactory = Terrains.getTerrainFactory();
        for (int i = 0; i < iHexArray.length; ++i) {
            IHex iHex = iHexArray[i];
            int n2 = iHex.getElevation() - n;
            if (n2 == 0 && !iHex.containsTerrain(4) && !iHex.containsTerrain(5)) {
                iHex.addTerrain(iTerrainFactory.createTerrain(9, 1));
                continue;
            }
            if (n2 >= 0) continue;
            if (n2 < -4) {
                n2 = -4;
            }
            iHex.removeAllTerrains();
            iHex.addTerrain(iTerrainFactory.createTerrain(4, -n2));
            iHex.setElevation(n);
        }
    }

    protected static void PostProcessDeepFreeze(IHex[] iHexArray, int n) {
        ITerrainFactory iTerrainFactory = Terrains.getTerrainFactory();
        for (int i = 0; i < iHexArray.length; ++i) {
            IHex iHex = iHexArray[i];
            if (iHex.containsTerrain(4)) {
                int n2 = iHex.terrainLevel(4);
                if (n != 0) {
                    iHex.removeTerrain(4);
                    if ((n2 -= n) > 0) {
                        iHex.addTerrain(iTerrainFactory.createTerrain(4, n2));
                    }
                }
                iHex.addTerrain(iTerrainFactory.createTerrain(20, 1));
                continue;
            }
            if (!iHex.containsTerrain(9)) continue;
            iHex.removeTerrain(9);
            if (iHex.terrainsPresent() != 0) continue;
            if (Compute.randomInt(100) < 30) {
                iHex.addTerrain(iTerrainFactory.createTerrain(2, 1));
                continue;
            }
            iHex.addTerrain(iTerrainFactory.createTerrain(20, 1));
        }
    }

    protected static void PostProcessForestFire(IHex[] iHexArray, int n) {
        ITerrainFactory iTerrainFactory = Terrains.getTerrainFactory();
        for (int i = 0; i < iHexArray.length; ++i) {
            int n2;
            int n3;
            IHex iHex = iHexArray[i];
            int n4 = iHex.terrainLevel(1);
            if (n4 == Integer.MIN_VALUE || (n3 = n4 - (n2 = Compute.randomInt(5) - 2 + n)) > n4) continue;
            iHex.removeTerrain(1);
            if (n3 <= 0) {
                iHex.addTerrain(iTerrainFactory.createTerrain(2, 1));
                continue;
            }
            iHex.addTerrain(iTerrainFactory.createTerrain(1, n3));
            iHex.addTerrain(iTerrainFactory.createTerrain(7, 1));
            iHex.addTerrain(iTerrainFactory.createTerrain(8, 1));
        }
    }

    protected static void PostProcessDrought(IHex[] iHexArray, int n) {
        int n2 = 1 + Compute.randomInt(3) + n;
        if (n2 < 0) {
            return;
        }
        ITerrainFactory iTerrainFactory = Terrains.getTerrainFactory();
        for (int i = 0; i < iHexArray.length; ++i) {
            int n3;
            IHex iHex = iHexArray[i];
            if (iHex.containsTerrain(9)) {
                iHex.removeTerrain(9);
                if (iHex.terrainsPresent() == 0 && Compute.randomInt(100) < 30) {
                    iHex.addTerrain(iTerrainFactory.createTerrain(2, 1));
                }
            }
            if ((n3 = iHex.terrainLevel(4)) == Integer.MIN_VALUE) continue;
            int n4 = n3 - n2;
            iHex.removeTerrain(4);
            if (n4 == 0) {
                iHex.addTerrain(iTerrainFactory.createTerrain(9, 1));
            } else if (n4 < 0) {
                iHex.addTerrain(iTerrainFactory.createTerrain(2, 1));
            } else {
                iHex.addTerrain(iTerrainFactory.createTerrain(4, n4));
            }
            n4 = n3 > n2 ? n2 : n3;
            iHex.setElevation(iHex.getElevation() - n4);
        }
    }

    private static boolean hexCouldBeCliff(IBoard iBoard, Coords coords) {
        int n = iBoard.getHex(coords).getElevation();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        for (int i = 0; i < 6; ++i) {
            Coords coords2 = coords.translated(i);
            if (!iBoard.contains(coords2)) continue;
            IHex iHex = iBoard.getHex(coords2);
            int n3 = iHex.getElevation();
            if (n3 > n) {
                bl2 = true;
                continue;
            }
            if (n3 < n) {
                bl = true;
                continue;
            }
            ++n2;
        }
        return bl && bl2 && n2 <= 3 && n2 > 0;
    }

    private static void findCliffNeighbours(IBoard iBoard, Coords coords, ArrayList<Coords> arrayList, HashSet<Coords> hashSet) {
        arrayList.add(coords);
        hashSet.add(coords);
        int n = iBoard.getHex(coords).getElevation();
        for (int i = 0; i < 6; ++i) {
            Coords coords2 = coords.translated(i);
            if (!iBoard.contains(coords2) || hashSet.contains(coords2)) continue;
            if (BoardUtilities.hexCouldBeCliff(iBoard, coords2)) {
                IHex iHex = iBoard.getHex(coords2);
                int n2 = iHex.getElevation();
                if (n2 != n) continue;
                BoardUtilities.findCliffNeighbours(iBoard, coords2, arrayList, hashSet);
                continue;
            }
            hashSet.add(coords2);
        }
    }

    protected static void addCliffs(IBoard iBoard, int n) {
        HashSet<Coords> hashSet = new HashSet<Coords>();
        ArrayList<Coords> arrayList = new ArrayList<Coords>();
        for (int i = 0; i < iBoard.getWidth(); ++i) {
            for (int j = 0; j < iBoard.getHeight(); ++j) {
                Coords coords2 = new Coords(i, j);
                int n2 = iBoard.getHex(coords2).getElevation();
                if (hashSet.contains(coords2)) continue;
                if (!BoardUtilities.hexCouldBeCliff(iBoard, coords2)) {
                    hashSet.add(coords2);
                    continue;
                }
                BoardUtilities.findCliffNeighbours(iBoard, coords2, arrayList, hashSet);
                if (arrayList.size() >= 3 && Compute.randomInt(100) < n) {
                    n2 = n2 > 0 ? --n2 : ++n2;
                    for (Coords coords2 : arrayList) {
                        IHex iHex = iBoard.getHex(coords2);
                        iHex.setElevation(n2);
                    }
                }
                arrayList.clear();
            }
        }
    }

    public static void generateElevation(int n, int n2, int n3, int n4, int n5, int n6, int[][] nArray, int n7) {
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = 0;
        int n14 = n4;
        boolean bl = Compute.randomInt(100) < n5;
        for (n12 = 0; n12 < n2; ++n12) {
            for (n11 = 0; n11 < n3; ++n11) {
                nArray[n12][n11] = 0;
            }
        }
        switch (n7) {
            case 0: {
                BoardUtilities.cutSteps(n, n2, n3, nArray);
                break;
            }
            case 1: {
                BoardUtilities.midPoint(n, n2, n3, nArray);
                break;
            }
            case 2: {
                BoardUtilities.cutSteps(n, n2, n3, nArray);
                BoardUtilities.midPoint(n, n2, n3, nArray);
            }
        }
        n12 = nArray[0][0];
        n11 = nArray[0][0];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (nArray[i][j] > n11) {
                    n11 = nArray[i][j];
                }
                if (nArray[i][j] >= n12) continue;
                n12 = nArray[i][j];
            }
        }
        double d = (double)(n14 - n13) / (double)(n11 - n12);
        int n15 = (int)(-d * (double)n12 + (double)n13);
        int[] nArray2 = new int[n14 + 1];
        for (n10 = 0; n10 < n2; ++n10) {
            for (n9 = 0; n9 < n3; ++n9) {
                int[] nArray3 = nArray[n10];
                int n16 = n9;
                nArray3[n16] = (int)((double)nArray3[n16] * d);
                int[] nArray4 = nArray[n10];
                int n17 = n9;
                nArray4[n17] = nArray4[n17] + n15;
                int n18 = nArray[n10][n9];
                nArray2[n18] = nArray2[n18] + 1;
            }
        }
        n10 = 0;
        for (n9 = 1; n9 <= n4; ++n9) {
            if (nArray2[n9] <= nArray2[n10]) continue;
            n10 = n9;
        }
        for (n9 = 0; n9 < n2; ++n9) {
            for (n8 = 0; n8 < n3; ++n8) {
                int[] nArray5 = nArray[n9];
                int n19 = n8;
                nArray5[n19] = nArray5[n19] - n10;
                if (!bl) continue;
                int[] nArray6 = nArray[n9];
                int n20 = n8;
                nArray6[n20] = nArray6[n20] * -1;
            }
        }
        if (n6 == 1) {
            for (n9 = 0; n9 < n2; ++n9) {
                for (n8 = 0; n8 < n3; ++n8) {
                    if (nArray[n9][n8] >= 0) continue;
                    int[] nArray7 = nArray[n9];
                    int n21 = n8;
                    nArray7[n21] = nArray7[n21] * -1;
                }
            }
        }
    }

    public static void generateMountain(IBoard iBoard, int n, Coords coords, int n2, int n3) {
        int n4 = iBoard.getWidth();
        int n5 = iBoard.getHeight();
        ITerrainFactory iTerrainFactory = Terrains.getTerrainFactory();
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n5; ++j) {
                Coords coords2 = new Coords(i, j);
                int n6 = coords2.distance(coords);
                int n7 = 100 * n2 * (n - n6) / n;
                n7 = n7 / 100 + (Compute.randomInt(100) < n7 % 100 ? 1 : 0);
                IHex iHex = iBoard.getHex(coords2);
                if (n7 >= n2 - 2) {
                    switch (n3) {
                        case 4: {
                            iHex.setTheme("snow");
                            break;
                        }
                        case 2: 
                        case 3: {
                            iHex.setTheme("lunar");
                            break;
                        }
                        case 5: {
                            int n8 = n / 4;
                            int n9 = n8 - n6 + 1;
                            if (n9 < 1) {
                                n9 = 1;
                            }
                            iHex.addTerrain(iTerrainFactory.createTerrain(4, n9));
                            n7 -= Math.abs(n8 - n7) - 1;
                        }
                    }
                }
                if (n7 == n2) {
                    switch (n3) {
                        case 3: {
                            iHex.removeAllTerrains();
                            iHex.addTerrain(iTerrainFactory.createTerrain(24, 2));
                            n7 -= 2;
                            break;
                        }
                        case 2: {
                            iHex.removeAllTerrains();
                            iHex.addTerrain(iTerrainFactory.createTerrain(24, 1));
                            n7 -= 2;
                            break;
                        }
                        case 1: {
                            iHex.setTheme("lunar");
                            n7 -= 2;
                        }
                    }
                }
                if (iHex.getElevation() >= n7) continue;
                iHex.setElevation(n7);
            }
        }
    }

    public static void flip(IBoard iBoard, boolean bl, boolean bl2) {
        int n;
        int n2;
        if (!bl2 && !bl) {
            return;
        }
        int n3 = iBoard.getWidth();
        int n4 = iBoard.getHeight();
        if (bl) {
            n2 = n3 / 2;
            n = n4;
        } else {
            n2 = n3;
            n = n4 / 2;
        }
        for (int i = 0; i < n2; ++i) {
            int n5 = bl ? n3 - i - 1 : i;
            for (int j = 0; j < n; ++j) {
                int n6 = bl2 ? n4 - j - 1 : j;
                IHex iHex = iBoard.getHex(i, j);
                iBoard.setHex(i, j, iBoard.getHex(n5, n6));
                iBoard.setHex(n5, n6, iHex);
                IHex iHex2 = iBoard.getHex(n5, n6);
                IHex iHex3 = iBoard.getHex(i, j);
                ITerrain iTerrain = iHex2.getTerrain(6);
                if (null != iTerrain) {
                    iTerrain.flipExits(bl, bl2);
                }
                if (null != (iTerrain = iHex3.getTerrain(6))) {
                    iTerrain.flipExits(bl, bl2);
                }
                if (null != (iTerrain = iHex2.getTerrain(10))) {
                    iTerrain.flipExits(bl, bl2);
                }
                if (null != (iTerrain = iHex3.getTerrain(10))) {
                    iTerrain.flipExits(bl, bl2);
                }
                if (null != (iTerrain = iHex2.getTerrain(33))) {
                    iTerrain.flipExits(bl, bl2);
                }
                if (null != (iTerrain = iHex3.getTerrain(33))) {
                    iTerrain.flipExits(bl, bl2);
                }
                if (null != (iTerrain = iHex2.getTerrain(14))) {
                    iTerrain.flipExits(bl, bl2);
                }
                if (null == (iTerrain = iHex3.getTerrain(14))) continue;
                iTerrain.flipExits(bl, bl2);
            }
        }
    }

    protected static void cutSteps(int n, int n2, int n3, int[][] nArray) {
        Point point = new Point(0, 0);
        Point point2 = new Point(0, 0);
        block8: for (int i = 0; i < n * 20; ++i) {
            int n4 = Compute.randomInt(2) == 0 ? -1 : 1;
            int n5 = -n4;
            int n6 = Compute.randomInt(6);
            switch (n6) {
                case 0: {
                    point.setLocation(0, Compute.randomInt(n3));
                    point2.setLocation(Compute.randomInt(n2), n3 - 1);
                    BoardUtilities.markSides(point, point2, n5, n4, nArray, n3);
                    BoardUtilities.markRect(point2.x, n2, n4, nArray, n3);
                    continue block8;
                }
                case 1: {
                    point.setLocation(Compute.randomInt(n2), 0);
                    point2.setLocation(Compute.randomInt(n2), n3 - 1);
                    if (point.x < point2.x) {
                        BoardUtilities.markSides(point, point2, n4, n5, nArray, n3);
                    } else {
                        BoardUtilities.markSides(point2, point, n5, n4, nArray, n3);
                    }
                    BoardUtilities.markRect(0, point.x, n4, nArray, n3);
                    BoardUtilities.markRect(point2.x, n2, n5, nArray, n3);
                    continue block8;
                }
                case 2: {
                    point.setLocation(Compute.randomInt(n2), n3 - 1);
                    point2.setLocation(n2, Compute.randomInt(n3));
                    BoardUtilities.markSides(point, point2, n5, n4, nArray, n3);
                    BoardUtilities.markRect(0, point.x, n4, nArray, n3);
                    continue block8;
                }
                case 3: {
                    point.setLocation(0, Compute.randomInt(n3));
                    point2.setLocation(n2, Compute.randomInt(n3));
                    BoardUtilities.markSides(point, point2, n4, n5, nArray, n3);
                    continue block8;
                }
                case 4: {
                    point.setLocation(0, Compute.randomInt(n3));
                    point2.setLocation(Compute.randomInt(n2), 0);
                    BoardUtilities.markSides(point, point2, n5, n4, nArray, n3);
                    BoardUtilities.markRect(point2.x, n2, n5, nArray, n3);
                    continue block8;
                }
                case 5: {
                    point.setLocation(Compute.randomInt(n2), 0);
                    point2.setLocation(n2, Compute.randomInt(n3));
                    BoardUtilities.markSides(point, point2, n5, n4, nArray, n3);
                    BoardUtilities.markRect(0, point.x, n5, nArray, n3);
                }
            }
        }
    }

    protected static void markRect(int n, int n2, int n3, int[][] nArray, int n4) {
        for (int i = n; i < n2; ++i) {
            int n5 = 0;
            while (n5 < n4) {
                int[] nArray2 = nArray[i];
                int n6 = n5++;
                nArray2[n6] = nArray2[n6] + n3;
            }
        }
    }

    protected static void markSides(Point point, Point point2, int n, int n2, int[][] nArray, int n3) {
        for (int i = point.x; i < point2.x; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4 = (point2.y - point.y) / (point2.x - point.x) * (i - point.x) + point.y;
                if (j > n4) {
                    int[] nArray2 = nArray[i];
                    int n5 = j;
                    nArray2[n5] = nArray2[n5] + n;
                    continue;
                }
                if (j >= n4) continue;
                int[] nArray3 = nArray[i];
                int n6 = j;
                nArray3[n6] = nArray3[n6] + n2;
            }
        }
    }

    protected static void midPoint(int n, int n2, int n3, int[][] nArray) {
        int n4;
        int n5;
        int n6;
        int n7 = 1;
        int n8 = n6 = n2 > n3 ? n2 : n3;
        while (n6 > 0) {
            ++n7;
            n6 /= 2;
        }
        n6 = (1 << n7) + 1;
        int[][] nArray2 = new int[n6 + 1][n6 + 1];
        for (n5 = 0; n5 < n6; ++n5) {
            for (n4 = 0; n4 < n6; ++n4) {
                nArray2[n5][n4] = n5 < n2 && n4 < n3 ? nArray[n5][n4] : 0;
            }
        }
        for (n5 = n7; n5 > 0; --n5) {
            BoardUtilities.midPointStep((double)n / 100.0, n6, 100, nArray2, n5, true);
        }
        for (n5 = 0; n5 < n2; ++n5) {
            for (n4 = 0; n4 < n3; ++n4) {
                nArray[n5][n4] = nArray2[n5][n4];
            }
        }
    }

    protected static void midPointStep(double d, int n, int n2, int[][] nArray, int n3, boolean bl) {
        int n4;
        int n5 = n >> n3 - 1;
        int n6 = n5 / 2;
        d = (1.0 - d) / 2.0;
        n2 = (int)((double)n2 * Math.exp(-0.6931 * d * (2.0 * (double)n3 - 1.0)));
        int n7 = n2 << 5;
        int n8 = n6;
        do {
            n4 = n6;
            do {
                nArray[n8][n4] = BoardUtilities.middleValue(nArray[n8 + n6][n4 + n6], nArray[n8 + n6][n4 - n6], nArray[n8 - n6][n4 + n6], nArray[n8 - n6][n4 - n6], n7);
            } while ((n4 += n5) < n - n6);
        } while ((n8 += n5) < n - n6);
        n2 = (int)((double)n2 * Math.exp(-0.6931 * d));
        n7 = n2 << 5;
        if (bl) {
            n8 = n6;
            do {
                n4 = n8;
                nArray[0][n8] = BoardUtilities.middleValue(nArray[0][n8 + n6], nArray[0][n8 - n6], nArray[n6][n8], n7);
                nArray[n][n8] = BoardUtilities.middleValue(nArray[n - 1][n8 + n6], nArray[n - 1][n8 - n6], nArray[n - n6 - 1][n8], n7);
                n4 = 0;
                nArray[n8][0] = BoardUtilities.middleValue(nArray[n8 + n6][0], nArray[n8 - n6][0], nArray[n8][n6], n7);
                nArray[n8][n] = BoardUtilities.middleValue(nArray[n8 + n6][n - 1], nArray[n8 - n6][n - 1], nArray[n8][n - n6 - 1], n7);
            } while ((n8 += n5) < n - n6);
        }
        BoardUtilities.diagMid(new Point(n6, n5), n5, n6, n7, n, nArray);
        BoardUtilities.diagMid(new Point(n5, n6), n5, n6, n7, n, nArray);
    }

    protected static void diagMid(Point point, int n, int n2, int n3, int n4, int[][] nArray) {
        int n5 = point.x;
        int n6 = n5 + n2;
        while (n5 < n4 - n2 && n6 < n4) {
            int n7 = point.y;
            int n8 = n7 + n2;
            while (n7 < n4 - n2 && n8 < n4) {
                nArray[n5][n7] = BoardUtilities.middleValue(nArray[n5][n8], nArray[n5][n7 - n2], nArray[n6][n7], nArray[n5 - n2][n7], n3);
                n8 = (n7 += n) + n2;
            }
            n6 = (n5 += n) + n2;
        }
    }

    protected static int middleValue(int n, int n2, int n3, int n4) {
        int n5 = (n + n2 + n3) / 3 + BoardUtilities.normRNG(n4);
        return n5;
    }

    protected static int middleValue(int n, int n2, int n3, int n4, int n5) {
        int n6 = (n + n2 + n3 + n4) / 4 + BoardUtilities.normRNG(n5);
        return n6;
    }

    private static int normRNG(int n) {
        return (2 * (Compute.randomInt(++n) + Compute.randomInt(n) + Compute.randomInt(n)) - 3 * (n - 1)) / 32;
    }

    protected static class Point {
        public int x;
        public int y;

        public Point(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        public Point(Point point) {
            this.x = point.x;
            this.y = point.y;
        }

        public void setLocation(int n, int n2) {
            this.x = n;
            this.y = n2;
        }
    }
}

