/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.verifier;

import java.util.Iterator;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.TechConstants;
import megamek.common.WeaponType;
import megamek.common.util.StringUtil;
import megamek.common.verifier.Armor;
import megamek.common.verifier.Structure;
import megamek.common.verifier.TestEntityOption;

public abstract class TestEntity
implements TestEntityOption {
    public static final float CEIL_TON = 1.0f;
    public static final float CEIL_HALFTON = 2.0f;
    public static final float CEIL_QUARTERTON = 4.0f;
    public static final String[] MOVEMENT_CHASSIS_NAMES = new String[]{"Building", "Biped Mech", "Quad Mech", "Tracked Vehicle", "Wheeled Vehicle", "Hovercraft", "VTOL", "Naval Vehicle", "Hydrofoil Vehicle", "Submarine", "Leg Infantry", "Motorized Infantry", "Jump Infantry", "Biped Mech", "Quad Mech", "WIGE Vehicle", "Aerodyne Dropship", "Spheroid Dropship", "UMU Infantry", "Airmech", "Aerospace"};
    protected Engine engine = null;
    protected Armor armor = null;
    protected Structure structure = null;
    private TestEntityOption options = null;
    public String fileString = null;

    public abstract Entity getEntity();

    public abstract boolean isTank();

    public abstract boolean isMech();

    public abstract float getWeightControls();

    public abstract float getWeightMisc();

    public abstract int getWeightHeatSinks();

    public abstract boolean hasDoubleHeatSinks();

    public abstract int getCountHeatSinks();

    public abstract String printWeightMisc();

    public abstract String printWeightControls();

    public abstract boolean correctEntity(StringBuffer var1);

    public abstract boolean correctEntity(StringBuffer var1, boolean var2);

    public abstract StringBuffer printEntity();

    public abstract String getName();

    public TestEntity(TestEntityOption testEntityOption, Engine engine, Armor armor, Structure structure) {
        this.options = testEntityOption;
        this.engine = engine;
        this.armor = armor;
        this.structure = structure;
    }

    public boolean isClan() {
        return this.getEntity().isClan();
    }

    public boolean isClanArmor() {
        return this.getEntity().isClanArmor();
    }

    public float getWeight() {
        return this.getEntity().getWeight();
    }

    public int getTotalOArmor() {
        return this.getEntity().getTotalOArmor();
    }

    public String getLocationAbbr(int n) {
        return this.getEntity().getLocationAbbr(n);
    }

    public float getWeightCeilingEngine() {
        return this.options.getWeightCeilingEngine();
    }

    public float getWeightCeilingStructure() {
        return this.options.getWeightCeilingStructure();
    }

    public float getWeightCeilingArmor() {
        return this.options.getWeightCeilingArmor();
    }

    public float getWeightCeilingControls() {
        return this.options.getWeightCeilingControls();
    }

    public float getWeightCeilingWeapons() {
        return this.options.getWeightCeilingWeapons();
    }

    public float getWeightCeilingTargComp() {
        return this.options.getWeightCeilingTargComp();
    }

    public float getWeightCeilingGyro() {
        return this.options.getWeightCeilingGyro();
    }

    public float getWeightCeilingTurret() {
        return this.options.getWeightCeilingTurret();
    }

    public float getWeightCeilingPowerAmp() {
        return this.options.getWeightCeilingPowerAmp();
    }

    public float getMaxOverweight() {
        return this.options.getMaxOverweight();
    }

    public boolean showOverweightedEntity() {
        return this.options.showOverweightedEntity();
    }

    public float getMinUnderweight() {
        return this.options.getMinUnderweight();
    }

    public boolean showUnderweightedEntity() {
        return this.options.showUnderweightedEntity();
    }

    public boolean showCorrectArmor() {
        return this.options.showCorrectArmor();
    }

    public boolean showCorrectCritical() {
        return this.options.showCorrectCritical();
    }

    public boolean showFailedEquip() {
        return this.options.showFailedEquip();
    }

    public boolean ignoreFailedEquip(String string) {
        return this.options.ignoreFailedEquip(string);
    }

    public boolean skip() {
        return this.options.skip();
    }

    public int getTargCompCrits() {
        return this.options.getTargCompCrits();
    }

    public int getPrintSize() {
        return this.options.getPrintSize();
    }

    protected static float ceil(float f, float f2) {
        return (float)Math.ceil(f * f2) / f2;
    }

    public static float ceilMaxHalf(float f, float f2) {
        if (f2 == 1.0f) {
            return TestEntity.ceil(f, 2.0f);
        }
        return TestEntity.ceil(f, f2);
    }

    protected static String makeWeightString(float f) {
        return (f < 100.0f ? " " : "") + (f < 10.0f ? " " : "") + Float.toString(f) + (Math.ceil(f * 10.0f) == (double)(f * 10.0f) ? "0" : "");
    }

    private boolean hasMASC() {
        if (this.getEntity() instanceof Mech) {
            return ((Mech)this.getEntity()).hasMASC();
        }
        return false;
    }

    public String printShortMovement() {
        return "Movement: " + Integer.toString(this.getEntity().getOriginalWalkMP()) + "/" + Integer.toString((int)Math.ceil((double)this.getEntity().getOriginalWalkMP() * 1.5)) + (this.hasMASC() ? "(" + Integer.toString(this.getEntity().getOriginalWalkMP() * 2) + ")" : "") + (this.getEntity().getOriginalJumpMP() != 0 ? "/" + Integer.toString(this.getEntity().getOriginalJumpMP()) : "") + "\n";
    }

    public String printWeightHeatSinks() {
        return StringUtil.makeLength("Heat Sinks: " + Integer.toString(this.getCountHeatSinks()) + (this.hasDoubleHeatSinks() ? " [" + Integer.toString(2 * this.getCountHeatSinks()) + "]" : ""), this.getPrintSize() - 5) + TestEntity.makeWeightString(this.getWeightHeatSinks()) + "\n";
    }

    public String printWeightEngine() {
        return StringUtil.makeLength("Engine: " + this.engine.getEngineName(), this.getPrintSize() - 5) + TestEntity.makeWeightString(this.getWeightEngine()) + "\n";
    }

    public float getWeightEngine() {
        return this.engine.getWeightEngine(this.getWeightCeilingEngine());
    }

    public String printWeightStructure() {
        return StringUtil.makeLength("Structure: " + Integer.toString(this.getEntity().getTotalOInternal()) + " " + this.structure.getShortName(), this.getPrintSize() - 5) + TestEntity.makeWeightString(this.getWeightStructure()) + "\n";
    }

    public float getWeightStructure() {
        return this.structure.getWeightStructure(this.getWeight(), this.getWeightCeilingStructure());
    }

    public String printWeightArmor() {
        return StringUtil.makeLength("Armor: " + Integer.toString(this.getTotalOArmor()) + " " + this.armor.getShortName(), this.getPrintSize() - 5) + TestEntity.makeWeightString(this.getWeightArmor()) + "\n";
    }

    public float getWeightArmor() {
        return this.armor.getWeightArmor(this.getTotalOArmor(), this.getWeightCeilingArmor());
    }

    public float getWeightMiscEquip(MiscType miscType) {
        if (miscType.hasFlag(1L) || miscType.hasFlag(2L)) {
            return 0.0f;
        }
        if (miscType.hasFlag(0x800000L)) {
            return 0.0f;
        }
        if (miscType.hasFlag(0x1000000L)) {
            return 0.0f;
        }
        if (miscType.hasFlag(4L)) {
            return miscType.getTonnage(this.getEntity());
        }
        if (miscType.hasFlag(0x8000000L) && (miscType.hasSubType(4) || miscType.hasSubType(16))) {
            return TestEntity.ceil(this.getWeight() / 15.0f, this.getWeightCeilingWeapons());
        }
        if (miscType.hasFlag(0x8000000L) && miscType.hasSubType(8)) {
            return TestEntity.ceilMaxHalf(this.getWeight() / 20.0f, this.getWeightCeilingWeapons());
        }
        if (miscType.hasFlag(0x8000000L) && miscType.hasSubType(0x800000)) {
            return TestEntity.ceilMaxHalf(0.5f + this.getWeight() / 20.0f, this.getWeightCeilingWeapons());
        }
        if (miscType.hasFlag(0x8000000L) && miscType.hasSubType(64)) {
            return TestEntity.ceilMaxHalf(this.getWeight() / 10.0f, this.getWeightCeilingWeapons());
        }
        if (miscType.hasFlag(0x8000000L) && miscType.hasSubType(512)) {
            return TestEntity.ceilMaxHalf(10.0f, this.getWeightCeilingWeapons());
        }
        if (miscType.hasFlag(0x8000000L) && miscType.hasSubType(0x100000)) {
            return TestEntity.ceilMaxHalf(5.0f, this.getWeightCeilingWeapons());
        }
        if (miscType.hasFlag(0x8000000L) && miscType.hasSubType(128)) {
            return TestEntity.ceilMaxHalf(7.0f, this.getWeightCeilingWeapons());
        }
        if (miscType.hasFlag(0x8000000L) && miscType.hasSubType(262144)) {
            return TestEntity.ceilMaxHalf(5.0f, this.getWeightCeilingWeapons());
        }
        if (miscType.hasFlag(16L)) {
            if (miscType.hasSubType(1)) {
                return TestEntity.ceilMaxHalf(this.getWeightEngine() / 10.0f, 2.0f);
            }
            if (miscType.getInternalName().equals("ISMASC")) {
                return Math.round(this.getWeight() / 20.0f);
            }
            if (miscType.getInternalName().equals("CLMASC")) {
                return Math.round(this.getWeight() / 25.0f);
            }
        } else if (miscType.hasFlag(2048L)) {
            float f = 0.0f;
            for (Mounted mounted : this.getEntity().getWeaponList()) {
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (!weaponType.hasFlag(1L)) continue;
                f += weaponType.getTonnage(this.getEntity());
            }
            if (miscType.getInternalName().equals("ISTargeting Computer")) {
                return TestEntity.ceil(f / 4.0f, this.getWeightCeilingTargComp());
            }
            if (miscType.getInternalName().equals("CLTargeting Computer")) {
                return TestEntity.ceil(f / 5.0f, this.getWeightCeilingTargComp());
            }
        } else {
            if (miscType.hasFlag(32768L)) {
                return Math.round(this.getWeight() / 10.0f);
            }
            return miscType.getTonnage(this.getEntity());
        }
        return 0.0f;
    }

    public float getWeightMiscEquip() {
        float f = 0.0f;
        for (Mounted mounted : this.getEntity().getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            f += this.getWeightMiscEquip(miscType);
        }
        return f;
    }

    public StringBuffer printMiscEquip() {
        return this.printMiscEquip(new StringBuffer());
    }

    public StringBuffer printMiscEquip(StringBuffer stringBuffer) {
        return this.printMiscEquip(stringBuffer, 20, this.getPrintSize());
    }

    public StringBuffer printMiscEquip(StringBuffer stringBuffer, int n, int n2) {
        for (Mounted mounted : this.getEntity().getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (mounted.getLocation() == -1 || this.getWeightMiscEquip(miscType) == 0.0f) continue;
            stringBuffer.append(StringUtil.makeLength(miscType.getName(), 20));
            stringBuffer.append(StringUtil.makeLength(this.getLocationAbbr(mounted.getLocation()), this.getPrintSize() - 5 - 20)).append(TestEntity.makeWeightString(this.getWeightMiscEquip(miscType)));
            stringBuffer.append("\n");
        }
        return stringBuffer;
    }

    public float getWeightWeapon() {
        float f = 0.0f;
        for (Mounted mounted : this.getEntity().getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            f += weaponType.getTonnage(this.getEntity());
        }
        return f;
    }

    public StringBuffer printWeapon() {
        return this.printWeapon(new StringBuffer());
    }

    public StringBuffer printWeapon(StringBuffer stringBuffer) {
        return this.printWeapon(stringBuffer, 20, this.getPrintSize());
    }

    public StringBuffer printWeapon(StringBuffer stringBuffer, int n, int n2) {
        for (Mounted mounted : this.getEntity().getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (mounted.getLocation() == -1) continue;
            stringBuffer.append(StringUtil.makeLength(weaponType.getName(), 20));
            stringBuffer.append(StringUtil.makeLength(this.getLocationAbbr(mounted.getLocation()), this.getPrintSize() - 5 - 20)).append(TestEntity.makeWeightString(weaponType.getTonnage(this.getEntity()))).append("\n");
        }
        return stringBuffer;
    }

    public float getWeightAmmo() {
        float f = 0.0f;
        for (Mounted mounted : this.getEntity().getAmmo()) {
            if (mounted.getLocation() == -1) continue;
            AmmoType ammoType = (AmmoType)mounted.getType();
            f += ammoType.getTonnage(this.getEntity());
        }
        return f;
    }

    public StringBuffer printAmmo() {
        return this.printAmmo(new StringBuffer());
    }

    public StringBuffer printAmmo(StringBuffer stringBuffer) {
        return this.printAmmo(stringBuffer, 20, this.getPrintSize());
    }

    public StringBuffer printAmmo(StringBuffer stringBuffer, int n, int n2) {
        for (Mounted mounted : this.getEntity().getAmmo()) {
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getLocation() == -1) continue;
            stringBuffer.append(StringUtil.makeLength(ammoType.getName(), 20));
            stringBuffer.append(StringUtil.makeLength(this.getLocationAbbr(mounted.getLocation()), this.getPrintSize() - 5 - 20)).append(TestEntity.makeWeightString(ammoType.getTonnage(this.getEntity()))).append("\n");
        }
        return stringBuffer;
    }

    public String printLocations() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.getEntity().locations(); ++i) {
            String string = this.getEntity().getLocationName(i);
            stringBuffer.append(string + ":");
            stringBuffer.append("\n");
            for (int j = 0; j < this.getEntity().getNumberOfCriticals(i); ++j) {
                CriticalSlot criticalSlot = this.getEntity().getCritical(i, j);
                if (criticalSlot == null) {
                    stringBuffer.append(Integer.toString(j) + ". -Emtpy-");
                    stringBuffer.append("\n");
                    continue;
                }
                if (criticalSlot.getType() == 0) {
                    if (this.isMech()) {
                        stringBuffer.append(Integer.toString(j));
                        stringBuffer.append(". ");
                        stringBuffer.append(((Mech)this.getEntity()).getSystemName(criticalSlot.getIndex()));
                        stringBuffer.append("\n");
                        continue;
                    }
                    stringBuffer.append(Integer.toString(j) + ". UNKNOWN SYSTEM NAME");
                    stringBuffer.append("\n");
                    continue;
                }
                if (criticalSlot.getType() != 1) continue;
                Mounted mounted = this.getEntity().getEquipment(criticalSlot.getIndex());
                stringBuffer.append(Integer.toString(j) + ". " + mounted.getType().getInternalName());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public int calcMiscCrits(MiscType miscType) {
        if (miscType.hasFlag(0x8000000L) && (miscType.hasSubType(4) || miscType.hasSubType(8) || miscType.hasSubType(16))) {
            return (int)Math.ceil((double)this.getWeight() / 15.0);
        }
        if (miscType.hasFlag(0x8000000L) && miscType.hasSubType(64)) {
            return (int)Math.ceil((double)this.getWeight() / 10.0);
        }
        if (miscType.hasFlag(0x8000000L) && miscType.hasSubType(0x800000)) {
            return 1 + (int)Math.ceil((double)this.getWeight() / 20.0);
        }
        if (miscType.hasFlag(0x8000000L) && miscType.hasSubType(512)) {
            return 8;
        }
        if (miscType.hasFlag(0x8000000L) && miscType.hasSubType(0x100000)) {
            return 5;
        }
        if (miscType.hasFlag(0x8000000L) && miscType.hasSubType(128)) {
            return 7;
        }
        if (miscType.hasFlag(0x8000000L) && miscType.hasSubType(262144)) {
            return 6;
        }
        if (miscType.hasFlag(16L)) {
            if (miscType.getInternalName().equals("ISMASC")) {
                return Math.round(this.getWeight() / 20.0f);
            }
            if (miscType.getInternalName().equals("CLMASC")) {
                return Math.round(this.getWeight() / 25.0f);
            }
        } else if (miscType.hasFlag(2048L)) {
            float f = 0.0f;
            for (Mounted mounted : this.getEntity().getWeaponList()) {
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (!weaponType.hasFlag(1L)) continue;
                f += weaponType.getTonnage(this.getEntity());
            }
            float f2 = 0.0f;
            if (miscType.getInternalName().equals("ISTargeting Computer")) {
                f2 = TestEntity.ceil(f / 4.0f, this.getWeightCeilingTargComp());
            } else if (miscType.getInternalName().equals("CLTargeting Computer")) {
                f2 = TestEntity.ceil(f / 5.0f, this.getWeightCeilingTargComp());
            }
            switch (this.getTargCompCrits()) {
                case 0: {
                    return (int)Math.ceil(f2);
                }
                case 1: {
                    return Math.round(f2);
                }
                case 2: {
                    return (int)Math.floor(f2);
                }
            }
        } else {
            if (EquipmentType.getArmorTypeName(1).equals(miscType.getInternalName())) {
                if (this.isClanArmor()) {
                    return 7;
                }
                return 14;
            }
            if (EquipmentType.getArmorTypeName(9).equals(miscType.getInternalName())) {
                return 16;
            }
            if (EquipmentType.getArmorTypeName(5).equals(miscType.getInternalName())) {
                return 7;
            }
            if (EquipmentType.getArmorTypeName(6).equals(miscType.getInternalName())) {
                return 21;
            }
            if (EquipmentType.getStructureTypeName(1).equals(miscType.getInternalName())) {
                if (this.isClan()) {
                    return 7;
                }
                return 14;
            }
            if (EquipmentType.getStructureTypeName(2).equals(miscType.getInternalName())) {
                return 16;
            }
            if (EquipmentType.getArmorTypeName(2).equals(miscType.getInternalName())) {
                if (this.isClanArmor()) {
                    return 7;
                }
                return 14;
            }
            if (EquipmentType.getArmorTypeName(3).equals(miscType.getInternalName())) {
                if (this.isClanArmor()) {
                    return 5;
                }
                return 10;
            }
        }
        return miscType.getCriticals(this.getEntity());
    }

    public float calculateWeight() {
        float f = 0.0f;
        f += this.getWeightEngine();
        f += this.getWeightStructure();
        f += this.getWeightControls();
        f += (float)this.getWeightHeatSinks();
        f += this.getWeightArmor();
        f += this.getWeightMisc();
        f += this.getWeightMiscEquip();
        f += this.getWeightWeapon();
        f += this.getWeightAmmo();
        return f += (float)this.getWeightCarryingSpace();
    }

    public String printWeightCalculation() {
        return this.printWeightEngine() + this.printWeightStructure() + this.printWeightControls() + this.printWeightHeatSinks() + this.printWeightArmor() + this.printWeightMisc() + this.printWeightCarryingSpace() + "Equipment:\n" + this.printMiscEquip() + this.printWeapon() + this.printAmmo();
    }

    public boolean correctWeight(StringBuffer stringBuffer) {
        return this.correctWeight(stringBuffer, this.showOverweightedEntity(), this.showUnderweightedEntity());
    }

    public boolean correctWeight(StringBuffer stringBuffer, boolean bl, boolean bl2) {
        float f = this.calculateWeight();
        float f2 = this.getWeight();
        if (bl && f2 + this.getMaxOverweight() < f) {
            stringBuffer.append("Weight: ").append(this.calculateWeight()).append(" is greater then ").append(this.getWeight()).append("\n");
            return false;
        }
        if (bl2 && f2 - this.getMinUnderweight() > f) {
            stringBuffer.append("Weight: ").append(this.calculateWeight()).append(" is lesser then ").append(this.getWeight()).append("\n");
            return false;
        }
        return true;
    }

    public boolean hasIllegalTechLevels(StringBuffer stringBuffer) {
        return this.hasIllegalTechLevels(stringBuffer, true);
    }

    public boolean hasIllegalTechLevels(StringBuffer stringBuffer, boolean bl) {
        boolean bl2 = false;
        int n = this.getEntity().getTechLevel();
        for (Mounted mounted : this.getEntity().getEquipment()) {
            EquipmentType equipmentType = mounted.getType();
            if (bl && equipmentType instanceof AmmoType || TechConstants.isLegal(n, equipmentType.getTechLevel(), true)) continue;
            if (!bl2) {
                stringBuffer.append("Equipment illegal at unit's tech level:\n");
            }
            bl2 = true;
            stringBuffer.append(equipmentType.getName()).append("\n");
        }
        return bl2;
    }

    public boolean hasFailedEquipment(StringBuffer stringBuffer) {
        boolean bl = false;
        Iterator<String> iterator = this.getEntity().getFailedEquipment();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (this.ignoreFailedEquip(string)) continue;
            if (!bl) {
                stringBuffer.append("Equipment that Failed to Load:\n");
            }
            stringBuffer.append(string).append("\n");
            bl = true;
        }
        return bl;
    }

    public boolean hasIllegalEquipmentCombinations(StringBuffer stringBuffer) {
        int n = 0;
        boolean bl = false;
        for (Mounted mounted : this.getEntity().getWeaponList()) {
            if (!mounted.getType().hasFlag(0x4000000L) || mounted.getType().hasFlag(0x8000000L)) continue;
            ++n;
        }
        if (n > 1) {
            stringBuffer.append("Unit has more than one TAG\n");
            bl = true;
        }
        return bl;
    }

    public StringBuffer printFailedEquipment(StringBuffer stringBuffer) {
        if (this.getEntity().getFailedEquipment().hasNext()) {
            stringBuffer.append("Equipment that Failed to Load:\n");
        }
        Iterator<String> iterator = this.getEntity().getFailedEquipment();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next()).append("\n");
        }
        return stringBuffer;
    }

    public int getWeightCarryingSpace() {
        return this.getEntity().getTroopCarryingSpace();
    }

    public String printWeightCarryingSpace() {
        if (this.getEntity().getTroopCarryingSpace() != 0) {
            return StringUtil.makeLength("Carrying Capacity:", this.getPrintSize() - 5) + TestEntity.makeWeightString(this.getEntity().getTroopCarryingSpace()) + "\n";
        }
        return "";
    }

    public String printArmorLocation(int n) {
        if (this.getEntity().hasRearArmor(n)) {
            return StringUtil.makeLength(this.getEntity().getLocationAbbr(n) + ":", 5) + StringUtil.makeLength(this.getEntity().getOInternal(n), 4) + StringUtil.makeLength(this.getEntity().getOArmor(n), 3) + " / " + StringUtil.makeLength(this.getEntity().getOArmor(n, true), 2);
        }
        return StringUtil.makeLength(this.getEntity().getLocationAbbr(n) + ":", 5) + StringUtil.makeLength(this.getEntity().getOInternal(n), 4) + StringUtil.makeLength(this.getEntity().getOArmor(n), 6) + "  ";
    }

    public String printArmorPlacement() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Armor Placement:\n");
        for (int i = 0; i < this.getEntity().locations(); ++i) {
            stringBuffer.append(this.printArmorLocation(i)).append("\n");
        }
        return stringBuffer.toString();
    }

    public String printTechLevel() {
        return "Chassis: " + MOVEMENT_CHASSIS_NAMES[this.getEntity().getMovementMode()] + " - " + TechConstants.getLevelName(this.getEntity().getTechLevel()) + " (" + Integer.toString(this.getEntity().getYear()) + ")\n";
    }
}

