/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.verifier;

import megamek.common.Entity;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.SupportTank;
import megamek.common.Tank;
import megamek.common.VTOL;
import megamek.common.WeaponType;
import megamek.common.util.StringUtil;
import megamek.common.verifier.Armor;
import megamek.common.verifier.Structure;
import megamek.common.verifier.TestEntity;
import megamek.common.verifier.TestEntityOption;

public class TestTank
extends TestEntity {
    private Tank tank = null;

    public TestTank(Tank tank, TestEntityOption testEntityOption, String string) {
        super(testEntityOption, tank.getEngine(), TestTank.getArmor(tank), TestTank.getStructure(tank));
        this.tank = tank;
        this.fileString = string;
    }

    private static Structure getStructure(Tank tank) {
        int n = 0;
        int n2 = 0;
        if (tank.getStructureType() == 1) {
            n = 1;
        }
        if (tank.isClan()) {
            n2 |= 1;
        }
        return new Structure(n, n2);
    }

    private static Armor getArmor(Tank tank) {
        int n = 0;
        int n2 = 0;
        n = tank.getArmorType();
        if (tank.isClanArmor()) {
            n2 |= 1;
        }
        return new Armor(n, n2);
    }

    public Entity getEntity() {
        return this.tank;
    }

    public boolean isTank() {
        return true;
    }

    public boolean isMech() {
        return false;
    }

    public float getTankWeightTurret() {
        float f = 0.0f;
        for (Mounted mounted : this.tank.getWeaponList()) {
            if (mounted.getLocation() != 5) continue;
            f += ((WeaponType)mounted.getType()).getTonnage(this.tank);
        }
        return TestTank.ceilMaxHalf(f / 10.0f, this.getWeightCeilingTurret());
    }

    public float getTankWeightLifting() {
        if (this.tank.getMovementMode() == 5) {
            return this.tank.getWeight() / 10.0f;
        }
        if (this.tank.getMovementMode() == 6) {
            return this.tank.getWeight() / 10.0f;
        }
        if (this.tank.getMovementMode() == 8) {
            return this.tank.getWeight() / 10.0f;
        }
        if (this.tank.getMovementMode() == 9) {
            return this.tank.getWeight() / 10.0f;
        }
        return 0.0f;
    }

    public float getTankPowerAmplifier() {
        if (!this.engine.isFusion()) {
            int n = 0;
            for (Mounted mounted : this.tank.getWeaponList()) {
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (weaponType.hasFlag(4L) || weaponType.hasFlag(8L) || weaponType.hasFlag(2L) && weaponType.getAmmoType() == -1) {
                    n = (int)((float)n + weaponType.getTonnage(this.tank));
                }
                if (mounted.getLinkedBy() == null || !(mounted.getLinkedBy().getType() instanceof MiscType) || !mounted.getLinkedBy().getType().hasFlag(0x1000000000L)) continue;
                n = (int)((float)n + ((MiscType)mounted.getLinkedBy().getType()).getTonnage(this.tank));
            }
            return TestTank.ceil((float)n / 10.0f, this.getWeightCeilingPowerAmp());
        }
        return 0.0f;
    }

    public float getWeightMisc() {
        return this.getTankWeightTurret() + this.getTankWeightLifting() + this.getTankPowerAmplifier();
    }

    public float getWeightControls() {
        return TestEntity.ceilMaxHalf(this.tank.getWeight() / 20.0f, this.getWeightCeilingControls());
    }

    private int getTankCountHeatLaserWeapons() {
        int n = 0;
        for (Mounted mounted : this.tank.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.hasFlag(4L) || weaponType.hasFlag(8L)) {
                n += weaponType.getHeat();
            }
            if (mounted.getLinkedBy() == null || !(mounted.getLinkedBy().getType() instanceof MiscType) || !mounted.getLinkedBy().getType().hasFlag(0x1000000000L)) continue;
            n += 5;
        }
        return n;
    }

    public boolean hasDoubleHeatSinks() {
        if (!this.engine.isFusion()) {
            return false;
        }
        if (this.getTankCountHeatLaserWeapons() <= 10) {
            return false;
        }
        if (this.tank.getTechLevel() == 0) {
            return false;
        }
        return false;
    }

    public int getCountHeatSinks() {
        float f = this.getTankCountHeatLaserWeapons();
        if (this.hasDoubleHeatSinks()) {
            f /= 2.0f;
        }
        return Math.round(f);
    }

    public int getWeightHeatSinks() {
        int n = this.getCountHeatSinks();
        if ((n -= this.engine.getCountEngineHeatSinks()) < 0) {
            n = 0;
        }
        return n;
    }

    public String printWeightMisc() {
        return (!this.tank.hasNoTurret() ? StringUtil.makeLength("Turret:", this.getPrintSize() - 5) + TestTank.makeWeightString(this.getTankWeightTurret()) + "\n" : "") + (this.getTankWeightLifting() != 0.0f ? StringUtil.makeLength("Lifting Equip:", this.getPrintSize() - 5) + TestTank.makeWeightString(this.getTankWeightLifting()) + "\n" : "") + (this.getTankPowerAmplifier() != 0.0f ? StringUtil.makeLength("Power Amp:", this.getPrintSize() - 5) + TestTank.makeWeightString(this.getTankPowerAmplifier()) + "\n" : "");
    }

    public String printWeightControls() {
        return StringUtil.makeLength("Controls:", this.getPrintSize() - 5) + TestTank.makeWeightString(this.getWeightControls()) + "\n";
    }

    public Tank getTank() {
        return this.tank;
    }

    public boolean correctEntity(StringBuffer stringBuffer) {
        return this.correctEntity(stringBuffer, true);
    }

    public boolean correctEntity(StringBuffer stringBuffer, boolean bl) {
        if (this.tank instanceof VTOL || this.tank instanceof SupportTank) {
            return true;
        }
        boolean bl2 = true;
        if (this.skip()) {
            return true;
        }
        if (!this.correctWeight(stringBuffer)) {
            stringBuffer.insert(0, this.printTechLevel() + this.printShortMovement());
            stringBuffer.append(this.printWeightCalculation()).append("\n");
            bl2 = false;
        }
        if (!this.engine.engineValid) {
            stringBuffer.append(this.engine.problem.toString()).append("\n\n");
            bl2 = false;
        }
        if (this.showFailedEquip() && this.hasFailedEquipment(stringBuffer)) {
            bl2 = false;
        }
        if (this.hasIllegalTechLevels(stringBuffer, bl)) {
            bl2 = false;
        }
        if (this.hasIllegalEquipmentCombinations(stringBuffer)) {
            bl2 = false;
        }
        if (!this.tank.getEngine().isFusion() && !this.tank.doomedInVacuum()) {
            stringBuffer.append("Vacuum protection requires fusion engine.\n");
            bl2 = false;
        }
        return bl2;
    }

    public StringBuffer printEntity() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Tank: ").append(this.tank.getDisplayName()).append("\n");
        stringBuffer.append("Found in: ").append(this.fileString).append("\n");
        stringBuffer.append(this.printTechLevel());
        stringBuffer.append(this.printShortMovement());
        if (this.correctWeight(stringBuffer, true, true)) {
            stringBuffer.append("Weight: ").append(this.getWeight()).append(" (").append(this.calculateWeight()).append(")\n");
        }
        stringBuffer.append(this.printWeightCalculation()).append("\n");
        this.printFailedEquipment(stringBuffer);
        return stringBuffer;
    }

    public String getName() {
        return "Tank: " + this.tank.getDisplayName();
    }
}

