/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.MissileWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATMHandler
extends MissileWeaponHandler {
    private static final long serialVersionUID = -2536312899803153911L;

    public ATMHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcDamagePerHit() {
        int n;
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        if (ammoType.getMunitionType() == 128L) {
            this.sSalvoType = " high-explosive missile(s) ";
            n = 3;
        } else if (ammoType.getMunitionType() == 64L) {
            this.sSalvoType = " extended-range missile(s) ";
            n = 1;
        } else {
            n = 2;
        }
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            n = (int)Math.ceil(n * this.wtype.getRackSize() / 5);
            if (this.bGlancing) {
                n = (int)Math.floor((double)n / 2.0);
            }
            return n;
        }
        return n;
    }

    @Override
    protected int calcnCluster() {
        return 5;
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            return 1;
        }
        int n = super.calcHits(vector);
        n = this.nDamPerHit * n;
        this.nDamPerHit = 1;
        return n;
    }
}

