/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Mounted;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.Weapon;
import megamek.server.Server;

public abstract class AmmoWeapon
extends Weapon {
    public AttackHandler fire(WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        this.checkAmmo(weaponAttackAction, iGame);
        return super.fire(weaponAttackAction, iGame, server);
    }

    protected void checkAmmo(WeaponAttackAction weaponAttackAction, IGame iGame) {
        Entity entity = weaponAttackAction.getEntity(iGame);
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        Mounted mounted2 = mounted.getLinked();
        if (mounted2 == null || mounted2.getShotsLeft() < 1) {
            entity.loadWeaponWithSameAmmo(mounted);
            mounted2 = mounted.getLinked();
        }
    }

    protected AttackHandler getCorrectHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        return new AmmoWeaponHandler(toHitData, weaponAttackAction, iGame, server);
    }
}

