/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.io.Serializable;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.LosEffects;
import megamek.common.Mounted;
import megamek.common.Report;
import megamek.common.RoundUpdated;
import megamek.common.SpecialHexDisplay;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.VTOL;
import megamek.common.actions.ArtilleryAttackAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtilleryWeaponIndirectFireHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = -1277649123562229298L;
    boolean handledAmmoAndReport = false;

    protected ArtilleryWeaponIndirectFireHandler() {
    }

    public ArtilleryWeaponIndirectFireHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    public boolean cares(IGame.Phase phase) {
        return phase == IGame.Phase.PHASE_OFFBOARD || phase == IGame.Phase.PHASE_TARGETING;
    }

    @Override
    public boolean handle(IGame.Phase phase, Vector<Report> vector) {
        Serializable serializable;
        Object object;
        AmmoType ammoType;
        if (!this.cares(phase)) {
            return true;
        }
        ArtilleryAttackAction artilleryAttackAction = (ArtilleryAttackAction)this.waa;
        if (phase == IGame.Phase.PHASE_TARGETING) {
            if (!this.handledAmmoAndReport) {
                this.addHeat();
                this.r = new Report(3121);
                this.r.indent();
                this.r.newlines = 0;
                this.r.subject = this.subjectId;
                this.r.add(this.wtype.getName());
                this.r.add(artilleryAttackAction.turnsTilHit);
                vector.addElement(this.r);
                Report.addNewline(vector);
                this.handledAmmoAndReport = true;
                this.game.getBoard().addSpecialHexDisplay(artilleryAttackAction.getTarget(this.game).getPosition(), new SpecialHexDisplay(SpecialHexDisplay.Type.ARTILLERY_INCOMING, this.game.getRoundCount() + artilleryAttackAction.turnsTilHit, this.game.getPlayer(artilleryAttackAction.getPlayerId()).getName(), "Artilery Incoming. Better text later."));
            }
            if (artilleryAttackAction.turnsTilHit == 0) {
                this.announcedEntityFiring = false;
            }
            return true;
        }
        if (artilleryAttackAction.turnsTilHit > 0) {
            --artilleryAttackAction.turnsTilHit;
            return true;
        }
        final Vector<Integer> vector2 = artilleryAttackAction.getSpotterIds();
        final Targetable targetable = artilleryAttackAction.getTarget(this.game);
        Coords coords = targetable.getPosition();
        final int n = artilleryAttackAction.getPlayerId();
        boolean bl = targetable instanceof VTOL;
        RoundUpdated roundUpdated = null;
        Entity entity = this.game.getEntity(artilleryAttackAction.getEntityId());
        if (entity == null) {
            entity = this.game.getOutOfGameEntity(artilleryAttackAction.getEntityId());
        }
        if (entity == null) {
            System.err.println("Artillery Entity is null!");
            return true;
        }
        Mounted mounted = entity.getEquipment(artilleryAttackAction.getAmmoId());
        AmmoType ammoType2 = ammoType = mounted == null ? null : (AmmoType)mounted.getType();
        if (null != vector2 && !bl) {
            object = this.game.getSelectedEntities(new EntitySelector(){
                public int player;
                public Targetable targ;
                {
                    this.player = n;
                    this.targ = targetable;
                }

                public boolean accept(Entity entity) {
                    Integer n2 = new Integer(entity.getId());
                    return this.player == entity.getOwnerId() && vector2.contains(n2) && !LosEffects.calculateLos(ArtilleryWeaponIndirectFireHandler.this.game, entity.getId(), this.targ).isBlocked() && entity.isActive() && !entity.isINarcedWith(4L);
                }
            });
            while (object.hasMoreElements()) {
                serializable = (Entity)object.nextElement();
                if (roundUpdated != null && ((Entity)serializable).crew.getGunnery() >= ((Entity)roundUpdated).crew.getGunnery()) continue;
                roundUpdated = serializable;
            }
        }
        if (null != roundUpdated) {
            int n2 = (((Entity)roundUpdated).crew.getGunnery() - 4) / 2;
            this.toHit.addModifier(n2, "Spotting modifier");
        }
        if (null != (object = artilleryAttackAction.getEntity(this.game)) && !bl) {
            serializable = ((Entity)object).getEquipment(artilleryAttackAction.getWeaponId());
            if (this.roll >= this.toHit.getValue()) {
                ((Entity)object).aTracker.setModifier((Mounted)serializable, Integer.MIN_VALUE, coords);
                this.game.getBoard().addSpecialHexDisplay(coords, new SpecialHexDisplay(SpecialHexDisplay.Type.ARTILLERY_AUTOHIT, this.game.getRoundCount(), this.game.getPlayer(artilleryAttackAction.getPlayerId()).getName(), "Artilery AutoHit. Better text later.", false));
            } else if (null != roundUpdated) {
                ((Entity)object).aTracker.setModifier((Mounted)serializable, ((Entity)object).aTracker.getModifier((Mounted)serializable, coords) - 1, coords);
                this.game.getBoard().addSpecialHexDisplay(coords, new SpecialHexDisplay(SpecialHexDisplay.Type.ARTILLERY_ADJUSTED, this.game.getRoundCount(), this.game.getPlayer(artilleryAttackAction.getPlayerId()).getName(), "Artilery toHit Adjusted. Better text later.", false));
            }
        }
        this.r = new Report(3120);
        this.r.indent();
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        if (this.wtype != null) {
            this.r.add(this.wtype.getName());
        } else {
            this.r.add("Error: From Nowhwere");
        }
        this.r.add(targetable.getDisplayName(), true);
        vector.addElement(this.r);
        if (this.toHit.getValue() == Integer.MAX_VALUE) {
            this.r = new Report(3135);
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
            return false;
        }
        if (this.toHit.getValue() == 0x7FFFFFFE) {
            this.r = new Report(3140);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else if (this.toHit.getValue() == Integer.MIN_VALUE) {
            this.r = new Report(3145);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else {
            this.r = new Report(3150);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getValue());
            vector.addElement(this.r);
        }
        this.r = new Report(3155);
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.roll);
        vector.addElement(this.r);
        if (!bl) {
            this.game.getBoard().addSpecialHexDisplay(coords, new SpecialHexDisplay(SpecialHexDisplay.Type.ARTILLERY_TARGET, this.game.getRoundCount(), this.game.getPlayer(artilleryAttackAction.getPlayerId()).getName(), "Artilery Target. Better text later.", false));
        }
        boolean bl2 = this.bMissed = this.roll < this.toHit.getValue();
        if (!this.handledAmmoAndReport) {
            this.addHeat();
        }
        serializable = targetable.getPosition();
        if (!this.bMissed) {
            if (!bl) {
                this.r = new Report(3190);
                this.game.getBoard().addSpecialHexDisplay(artilleryAttackAction.getCoords(), new SpecialHexDisplay(SpecialHexDisplay.Type.ARTILLERY_HIT, this.game.getRoundCount(), "Artilery Hit. Better text later."));
            } else {
                this.r = new Report(3191);
            }
            this.r.subject = this.subjectId;
            this.r.add(((Coords)serializable).getBoardNum());
            vector.addElement(this.r);
            this.game.getBoard().addSpecialHexDisplay(coords, new SpecialHexDisplay(SpecialHexDisplay.Type.ARTILLERY_HIT, this.game.getRoundCount(), "Artilery Hit. Better text later."));
        } else {
            serializable = Compute.scatter((Coords)serializable, this.game.getOptions().booleanOption("margin_scatter_distance") ? this.toHit.getValue() - this.roll : -1);
            if (this.game.getBoard().contains((Coords)serializable)) {
                if (!bl) {
                    this.r = new Report(3195);
                    this.game.getBoard().addSpecialHexDisplay((Coords)serializable, new SpecialHexDisplay(SpecialHexDisplay.Type.ARTILLERY_HIT, this.game.getRoundCount(), "Artilery Scatered Here. Better text later."));
                } else {
                    this.r = new Report(3192);
                }
                this.r.subject = this.subjectId;
                this.r.add(((Coords)serializable).getBoardNum());
                vector.addElement(this.r);
            } else {
                this.r = bl ? new Report(3193) : new Report(3200);
                this.r.subject = this.subjectId;
                vector.addElement(this.r);
                return !this.bMissed;
            }
        }
        if (ammoType.getMunitionType() == 131072L) {
            int n3 = ammoType.getAmmoType() == 15 ? 4 : (ammoType.getAmmoType() == 16 ? 3 : Math.max(1, ammoType.getRackSize() / 5));
            this.server.deliverArtilleryFlare((Coords)serializable, n3);
            return false;
        }
        if (ammoType.getMunitionType() == 0x20000000000L) {
            this.server.doNuclearExplosion((Coords)serializable, 1, vector);
            return false;
        }
        if (ammoType.getMunitionType() == 0x2000000000L) {
            this.server.deliverFASCAMMinefield((Coords)serializable, entity.getOwner().getId());
            return false;
        }
        if (ammoType.getMunitionType() == 0x4000000000L) {
            this.server.deliverArtilleryInferno((Coords)serializable, this.subjectId, vector);
            return false;
        }
        if (ammoType.getMunitionType() == 0x8000000000L) {
            this.server.deliverThunderVibraMinefield((Coords)serializable, entity.getOwner().getId(), 20, this.waa.getOtherAttackInfo());
            return false;
        }
        if (ammoType.getMunitionType() == 0x10000000000L) {
            this.server.deliverArtillerySmoke((Coords)serializable, vector);
            return false;
        }
        int n4 = 0;
        if (bl) {
            n4 = ((VTOL)targetable).getElevation();
        }
        this.server.artilleryDamageArea((Coords)serializable, ((Entity)object).getPosition(), ammoType, this.subjectId, (Entity)object, bl, n4, vector);
        return false;
    }

    @Override
    protected int calcDamagePerHit() {
        float f = this.wtype.getDamage();
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            f = (float)((double)f / 0.5);
        }
        if (this.bGlancing) {
            f = (int)Math.floor((double)f / 2.0);
        }
        System.err.println("Attack is doing " + f + " damage.");
        return (int)Math.ceil(f);
    }
}

