/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mounted;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HAGWeaponHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = -8193801876308832102L;
    Mounted ammo;

    public HAGWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcnCluster() {
        return 5;
    }

    @Override
    protected int calcDamagePerHit() {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            double d = this.wtype.getRackSize();
            d /= 10.0;
            d += 1.0;
            d = Math.ceil(d);
            if (this.bGlancing) {
                d = Math.floor(d / 2.0);
            }
            return (int)d;
        }
        return 1;
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            return 1;
        }
        int n = 0;
        if (this.nRange <= this.wtype.getShortRange()) {
            n += 2;
        } else if (this.nRange > this.wtype.getMediumRange()) {
            n -= 2;
        }
        int n2 = this.allShotsHit() ? this.wtype.getRackSize() : Compute.missilesHit(this.wtype.getRackSize(), n, this.bGlancing, false);
        this.r = new Report(3325);
        this.r.subject = this.subjectId;
        this.r.add(n2);
        this.r.add(" projectiles ");
        this.r.add(this.toHit.getTableDesc());
        this.r.newlines = 0;
        vector.addElement(this.r);
        if (n != 0) {
            this.r = new Report(3340);
            if (n < 0) {
                this.r = new Report(3341);
            }
            this.r.subject = this.subjectId;
            this.r.add(n);
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        this.r = new Report(3345);
        this.r.subject = this.subjectId;
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.bSalvo = true;
        return n2;
    }
}

