/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Report;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.InfantryFlamerHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfantryFlamerHeatHandler
extends InfantryFlamerHandler {
    private static final long serialVersionUID = -4808077901373647109L;

    public InfantryFlamerHeatHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n = Compute.missilesHit(((Infantry)this.ae).getShootingStrength());
        this.r = new Report(3325);
        this.r.subject = this.subjectId;
        this.r.add(n);
        this.r.add(" troopers ");
        this.r.add(this.toHit.getTableDesc() + ", causing " + this.damage[n - 1] + "heat.");
        this.r.newlines = 0;
        vector.addElement(this.r);
        return this.damage[n - 1];
    }

    @Override
    protected void handleEntityDamage(Entity entity, Vector<Report> vector, Building building, int n, int n2, int n3, int n4) {
        if (entity instanceof Mech && this.game.getOptions().booleanOption("flamer_heat")) {
            HitData hitData = entity.rollHitLocation(this.toHit.getHitTable(), this.toHit.getSideTable(), this.waa.getAimedLocation(), this.waa.getAimingMode());
            if (entity.removePartialCoverHits(hitData.getLocation(), this.toHit.getCover(), Compute.targetSideTable(this.ae, (Targetable)entity))) {
                this.r = new Report(3460);
                this.r.subject = this.subjectId;
                this.r.add(entity.getShortName());
                this.r.add(entity.getLocationAbbr(hitData));
                this.r.newlines = 0;
                this.r.indent(2);
                vector.addElement(this.r);
                this.missed = true;
                return;
            }
            int n5 = this.wtype.getHeat();
            this.r = new Report(3400);
            this.r.subject = this.subjectId;
            this.r.indent(2);
            this.r.add(n5);
            this.r.newlines = 0;
            this.r.choose(true);
            vector.addElement(this.r);
            entity.heatFromExternal += n5;
        } else {
            super.handleEntityDamage(entity, vector, building, n, n2, n3, n4);
        }
    }
}

