/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Minefield;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.MissileWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MRMHandler
extends MissileWeaponHandler {
    private static final long serialVersionUID = 38852986607304997L;

    public MRMHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected boolean specialResolution(Vector<Report> vector, Entity entity, boolean bl) {
        if (!bl && this.target.getTargetType() == 5) {
            int n = Compute.d6(2);
            if (n >= 5) {
                this.r = new Report(3255);
                this.r.indent(1);
                this.r.subject = this.subjectId;
                vector.addElement(this.r);
                Coords coords = this.target.getPosition();
                Enumeration<Minefield> enumeration = this.game.getMinefields(coords).elements();
                while (enumeration.hasMoreElements()) {
                    Minefield minefield = enumeration.nextElement();
                    this.server.removeMinefield(minefield);
                }
            } else {
                this.r = new Report(3260);
                this.r.indent(1);
                this.r.subject = this.subjectId;
                vector.addElement(this.r);
            }
        }
        return false;
    }
}

