/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.INarcPod;
import megamek.common.NarcPod;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.MissileWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NarcHandler
extends MissileWeaponHandler {
    private static final long serialVersionUID = 3195613885543781820L;

    public NarcHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        this.bSalvo = true;
        if (this.amsEnganged) {
            this.r = new Report(3235);
            this.r.subject = this.subjectId;
            vector.add(this.r);
            this.r = new Report(3230);
            this.r.indent(1);
            this.r.subject = this.subjectId;
            vector.add(this.r);
            int n = Compute.d6();
            if (n <= 3) {
                this.r = new Report(3240);
                this.r.subject = this.subjectId;
                this.r.add(n);
                vector.add(this.r);
                return 0;
            }
            this.r = new Report(3241);
            this.r.add(n);
            this.r.subject = this.subjectId;
            vector.add(this.r);
        }
        return 1;
    }

    @Override
    protected int calcnCluster() {
        return 1;
    }

    @Override
    protected int calcDamagePerHit() {
        return 0;
    }

    @Override
    protected void handleEntityDamage(Entity entity, Vector<Report> vector, Building building, int n, int n2, int n3, int n4) {
        HitData hitData = entity.rollHitLocation(this.toHit.getHitTable(), this.toHit.getSideTable(), this.waa.getAimedLocation(), this.waa.getAimingMode());
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        if (ammoType.getAmmoType() == 13) {
            NarcPod narcPod = new NarcPod(this.ae.getOwner().getTeam(), hitData.getLocation());
            this.r = new Report(3250);
            this.r.subject = this.subjectId;
            this.r.add(entity.getDisplayName());
            this.r.add(entity.getLocationAbbr(hitData));
            vector.addElement(this.r);
            entity.attachNarcPod(narcPod);
        } else if (ammoType.getAmmoType() == 30) {
            INarcPod iNarcPod = null;
            if (ammoType.getMunitionType() == 0x100000000L) {
                iNarcPod = new INarcPod(this.ae.getOwner().getTeam(), 2, hitData.getLocation());
                this.r = new Report(3251);
                this.r.subject = this.subjectId;
                this.r.add(entity.getDisplayName());
                this.r.add(entity.getLocationAbbr(hitData));
                vector.addElement(this.r);
            } else if (ammoType.getMunitionType() == 0x200000000L) {
                iNarcPod = new INarcPod(this.ae.getOwner().getTeam(), 4, hitData.getLocation());
                this.r = new Report(3252);
                this.r.subject = this.subjectId;
                this.r.add(entity.getDisplayName());
                this.r.add(entity.getLocationAbbr(hitData));
                vector.addElement(this.r);
            } else if (ammoType.getMunitionType() == 0x400000000L) {
                iNarcPod = new INarcPod(this.ae.getOwner().getTeam(), 8, hitData.getLocation());
                this.r = new Report(3253);
                this.r.add(entity.getDisplayName());
                this.r.add(entity.getLocationAbbr(hitData));
                this.r.subject = this.subjectId;
                vector.addElement(this.r);
            } else {
                iNarcPod = new INarcPod(this.ae.getOwner().getTeam(), 1, hitData.getLocation());
                this.r = new Report(3254);
                this.r.subject = this.subjectId;
                this.r.add(entity.getDisplayName());
                this.r.add(entity.getLocationAbbr(hitData));
                vector.addElement(this.r);
            }
            entity.attachINarcPod(iNarcPod);
        }
    }
}

