/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Report;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlasmaCannonHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = 2304364403526293671L;

    public PlasmaCannonHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.generalDamageType = -3;
    }

    @Override
    protected void handleEntityDamage(Entity entity, Vector<Report> vector, Building building, int n, int n2, int n3, int n4) {
        if (entity instanceof Mech) {
            HitData hitData = entity.rollHitLocation(this.toHit.getHitTable(), this.toHit.getSideTable(), this.waa.getAimedLocation(), this.waa.getAimingMode());
            hitData.setGeneralDamageType(this.generalDamageType);
            if (entity.removePartialCoverHits(hitData.getLocation(), this.toHit.getCover(), Compute.targetSideTable(this.ae, (Targetable)entity))) {
                this.r = new Report(3460);
                this.r.subject = this.subjectId;
                this.r.add(entity.getShortName());
                this.r.add(entity.getLocationAbbr(hitData));
                this.r.newlines = 0;
                this.r.indent(2);
                vector.addElement(this.r);
                this.missed = true;
                return;
            }
            if (!this.bSalvo) {
                this.r = new Report(3405);
                this.r.subject = this.subjectId;
                this.r.add(this.toHit.getTableDesc());
                this.r.add(entity.getLocationAbbr(hitData));
                this.r.newlines = 0;
                vector.addElement(this.r);
            }
            this.r = new Report(3400);
            this.r.subject = this.subjectId;
            this.r.indent(2);
            int n5 = Compute.d6(2);
            this.r.add(n5);
            this.r.choose(true);
            this.r.newlines = 0;
            vector.addElement(this.r);
            entity.heatFromExternal += n5;
        } else {
            super.handleEntityDamage(entity, vector, building, n, n2, n3, n4);
        }
    }

    @Override
    protected int calcDamagePerHit() {
        if (this.target instanceof Mech) {
            return 0;
        }
        int n = 1;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            n = Compute.d6(3);
        }
        if (this.target instanceof Infantry && ((Entity)this.target).getCrew().getOptions().booleanOption("pain_shunt")) {
            n = Math.max(n / 2, 1);
        }
        if (this.bGlancing) {
            n = (int)Math.floor((double)n / 2.0);
        }
        return n;
    }

    @Override
    protected int calcnCluster() {
        if (this.target instanceof Mech) {
            this.bSalvo = false;
            return 1;
        }
        this.bSalvo = true;
        return 5;
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            return 1;
        }
        if (this.target instanceof Mech) {
            return 1;
        }
        if (this.target instanceof BattleArmor && ((BattleArmor)this.target).hasFireresistantArmor()) {
            return 0;
        }
        return Compute.d6(3);
    }
}

