/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.SRMHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRMAntiTSMHandler
extends SRMHandler {
    private static final long serialVersionUID = 6380017303917455020L;

    public SRMAntiTSMHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.sSalvoType = " anti-TSM missile(s) ";
        this.damageType = Server.DamageType.ANTI_TSM;
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            if (this.ae instanceof BattleArmor) {
                this.bSalvo = true;
                return ((BattleArmor)this.ae).getShootingStrength();
            }
            return 1;
        }
        int n2 = this.nSalvoBonus;
        boolean bl = false;
        boolean bl2 = this.game.getOptions().booleanOption("maxtech_mslhitpen");
        if (bl2) {
            n2 = this.nRange <= 1 ? ++n2 : (this.nRange <= this.wtype.getShortRange() ? (n2 += 0) : (this.nRange <= this.wtype.getMediumRange() ? --n2 : (n2 -= 2)));
        }
        if (this.bGlancing) {
            n2 -= 4;
        }
        if (this.game.getOptions().booleanOption("blizzard") && this.wtype.hasFlag(262144L)) {
            n2 -= 4;
            bl = true;
        }
        if (this.game.getOptions().booleanOption("moderate_winds") && this.wtype.hasFlag(262144L)) {
            n2 -= 2;
            bl = true;
        }
        if (this.game.getOptions().booleanOption("high_winds") && this.wtype.hasFlag(262144L)) {
            n2 -= 4;
            bl = true;
        }
        n2 += this.getAMSHitsMod(vector);
        if (this.allShotsHit()) {
            n = this.wtype.getRackSize();
        } else {
            n = Compute.missilesHit(this.wtype.getRackSize(), n2, bl || this.bGlancing || bl2);
            n = (int)Math.ceil((double)n / 2.0);
        }
        this.r = new Report(3325);
        this.r.subject = this.subjectId;
        this.r.add(n);
        this.r.add(this.sSalvoType);
        this.r.add(this.toHit.getTableDesc());
        this.r.newlines = 0;
        vector.addElement(this.r);
        if (n2 != 0) {
            this.r = n2 > 0 ? new Report(3340) : new Report(3341);
            this.r.subject = this.subjectId;
            this.r.add(n2);
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        this.r = new Report(3345);
        this.r.subject = this.subjectId;
        this.r.newlines = 0;
        vector.addElement(this.r);
        this.bSalvo = true;
        return n;
    }
}

