/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.BuildingTarget;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.SRMHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRMInfernoHandler
extends SRMHandler {
    private static final long serialVersionUID = 826674238068613732L;

    public SRMInfernoHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.sSalvoType = " inferno missile(s) ";
        this.bSalvo = false;
    }

    @Override
    protected void reportMiss(Vector<Report> vector) {
        super.reportMiss(vector);
        this.server.tryIgniteHex(this.target.getPosition(), this.ae.getId(), true, 11, vector);
    }

    @Override
    protected int calcDamagePerHit() {
        return 0;
    }

    @Override
    protected void handleAccidentalBuildingDamage(Vector<Report> vector, Building building, int n, int n2) {
        if (n > 0) {
            vector.addAll(this.server.deliverInfernoMissiles(this.ae, new BuildingTarget(this.waa.getTarget(this.game).getPosition(), this.game.getBoard(), false), n));
        }
    }

    @Override
    public boolean handle(IGame.Phase phase, Vector<Report> vector) {
        if (!this.cares(phase)) {
            return true;
        }
        Entity entity = this.target.getTargetType() == 0 ? (Entity)this.target : null;
        boolean bl = Compute.isInBuilding(this.game, entity);
        Building building = this.game.getBoard().getBuildingAt(this.target.getPosition());
        this.r = new Report(3115);
        this.r.indent();
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.wtype.getName());
        if (entity != null) {
            this.r.addDesc(entity);
        } else {
            this.r.messageId = 3120;
            this.r.add(this.target.getDisplayName(), true);
        }
        vector.addElement(this.r);
        if (this.toHit.getValue() == Integer.MAX_VALUE) {
            this.r = new Report(3135);
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
            return false;
        }
        if (this.toHit.getValue() == 0x7FFFFFFE) {
            this.r = new Report(3140);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else if (this.toHit.getValue() == Integer.MIN_VALUE) {
            this.r = new Report(3145);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getDesc());
            vector.addElement(this.r);
        } else {
            this.r = new Report(3150);
            this.r.newlines = 0;
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getValue());
            vector.addElement(this.r);
        }
        this.r = new Report(3155);
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        this.r.add(this.roll);
        vector.addElement(this.r);
        boolean bl2 = this.bMissed = this.roll < this.toHit.getValue();
        if (this.game.getOptions().booleanOption("maxtech_glancing_blows")) {
            if (this.roll == this.toHit.getValue()) {
                this.bGlancing = true;
                this.r = new Report(3186);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                this.bGlancing = false;
            }
        } else {
            this.bGlancing = false;
        }
        this.addHeat();
        boolean bl3 = this.doChecks(vector);
        if (bl3) {
            this.bMissed = true;
        }
        if (this.bMissed && !bl3) {
            this.reportMiss(vector);
            if (!this.handleSpecialMiss(entity, bl, building, vector)) {
                return false;
            }
        }
        int n = this.calcHits(vector);
        Report.addNewline(vector);
        if (this.bMissed) {
            if (bl && building != null) {
                this.handleAccidentalBuildingDamage(vector, building, n, this.nDamPerHit);
            }
            return false;
        }
        if (!this.bMissed) {
            vector.addAll(this.server.deliverInfernoMissiles(this.ae, this.target, n));
        }
        return false;
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            if (this.ae instanceof BattleArmor) {
                this.bSalvo = true;
                this.r = new Report(3325);
                this.r.subject = this.subjectId;
                this.r.add(this.wtype.getRackSize() * ((BattleArmor)this.ae).getShootingStrength());
                this.r.add(this.sSalvoType);
                this.r.add(this.toHit.getTableDesc());
                this.r.newlines = 0;
                vector.add(this.r);
                return ((BattleArmor)this.ae).getShootingStrength() * this.wtype.getRackSize();
            }
            this.r = new Report(3325);
            this.r.subject = this.subjectId;
            this.r.add(this.wtype.getRackSize());
            this.r.add(this.sSalvoType);
            this.r.add(this.toHit.getTableDesc());
            this.r.newlines = 0;
            vector.add(this.r);
            return this.wtype.getRackSize();
        }
        Entity entity = this.target.getTargetType() == 0 ? (Entity)this.target : null;
        int n2 = this.nSalvoBonus;
        boolean bl = false;
        boolean bl2 = this.game.getOptions().booleanOption("maxtech_mslhitpen");
        if (bl2) {
            n2 = this.nRange <= 1 ? ++n2 : (this.nRange <= this.wtype.getShortRange() ? (n2 += 0) : (this.nRange <= this.wtype.getMediumRange() ? --n2 : (n2 -= 2)));
        }
        boolean bl3 = false;
        if (this.ae instanceof Mech) {
            bl3 = this.ae.isStealthActive();
        }
        Mounted mounted = this.weapon.getLinkedBy();
        AmmoType ammoType = (AmmoType)this.ammo.getType();
        boolean bl4 = false;
        if (Compute.isAffectedByECM(this.ae, this.ae.getPosition(), this.target.getPosition())) {
            bl4 = true;
        }
        if (mounted != null && mounted.getType() instanceof MiscType && !mounted.isDestroyed() && !mounted.isMissing() && !mounted.isBreached() && mounted.getType().hasFlag(512L) && ammoType.getMunitionType() == 4096L) {
            if (bl4) {
                this.r = new Report(3330);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else if (bl3) {
                this.r = new Report(3335);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                n2 += 2;
            }
        } else if (ammoType.getAmmoType() == 28) {
            if (bl4) {
                this.r = new Report(3330);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else if (bl3) {
                this.r = new Report(3335);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            } else {
                n2 += 2;
            }
        } else if (entity != null && (entity.isNarcedBy(this.ae.getOwner().getTeam()) || entity.isINarcedBy(this.ae.getOwner().getTeam()))) {
            boolean bl5 = false;
            bl5 = Compute.isAffectedByECM(this.ae, this.target.getPosition(), this.target.getPosition());
            if (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 45 && ammoType.getMunitionType() == 2048L && (this.weapon.curMode() == null || !this.weapon.curMode().equals("Indirect"))) {
                if (bl5) {
                    this.r = new Report(3330);
                    this.r.subject = this.subjectId;
                    this.r.newlines = 0;
                    vector.addElement(this.r);
                } else {
                    n2 += 2;
                }
            }
        }
        if (this.bGlancing) {
            n2 -= 4;
        }
        if (this.game.getOptions().booleanOption("blizzard") && this.wtype.hasFlag(262144L)) {
            n2 -= 4;
            bl = true;
        }
        if (this.game.getOptions().booleanOption("moderate_winds") && this.wtype.hasFlag(262144L)) {
            n2 -= 2;
            bl = true;
        }
        if (this.game.getOptions().booleanOption("high_winds") && this.wtype.hasFlag(262144L)) {
            n2 -= 4;
            bl = true;
        }
        if ((n = this.allShotsHit() ? this.wtype.getRackSize() : (this.ae instanceof BattleArmor ? Compute.missilesHit(this.wtype.getRackSize() * ((BattleArmor)this.ae).getShootingStrength(), n2, bl || this.bGlancing || bl2, this.weapon.isHotLoaded()) : Compute.missilesHit(this.wtype.getRackSize(), n2 += this.getAMSHitsMod(vector), bl || this.bGlancing || bl2, this.weapon.isHotLoaded()))) > 0) {
            this.r = new Report(3325);
            this.r.subject = this.subjectId;
            this.r.add(n);
            this.r.add(this.sSalvoType);
            this.r.add(this.toHit.getTableDesc());
            this.r.newlines = 0;
            vector.addElement(this.r);
            if (n2 != 0) {
                this.r = n2 > 0 ? new Report(3340) : new Report(3341);
                this.r.subject = this.subjectId;
                this.r.add(n2);
                this.r.newlines = 0;
                vector.addElement(this.r);
            }
        }
        this.r = new Report(3345);
        this.r.newlines = 0;
        this.r.subject = this.subjectId;
        vector.addElement(this.r);
        this.bSalvo = true;
        return n;
    }
}

