/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.HitData;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.SRMHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRMTandemChargeHandler
extends SRMHandler {
    private static final long serialVersionUID = 6292692766500970690L;

    public SRMTandemChargeHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
        this.sSalvoType = " tandem charge missile(s) ";
    }

    @Override
    protected void handleEntityDamage(Entity entity, Vector<Report> vector, Building building, int n, int n2, int n3, int n4) {
        this.missed = false;
        HitData hitData = entity.rollHitLocation(this.toHit.getHitTable(), this.toHit.getSideTable(), this.waa.getAimedLocation(), this.waa.getAimingMode());
        hitData.setGeneralDamageType(this.generalDamageType);
        if (entity.removePartialCoverHits(hitData.getLocation(), this.toHit.getCover(), Compute.targetSideTable(this.ae, (Targetable)entity))) {
            this.r = new Report(3460);
            this.r.subject = this.subjectId;
            this.r.add(entity.getShortName());
            this.r.add(entity.getLocationAbbr(hitData));
            this.r.newlines = 0;
            this.r.indent(2);
            vector.addElement(this.r);
            boolean bl = false;
            this.missed = true;
            return;
        }
        if (!this.bSalvo) {
            this.r = new Report(3405);
            this.r.subject = this.subjectId;
            this.r.add(this.toHit.getTableDesc());
            this.r.add(entity.getLocationAbbr(hitData));
            this.r.newlines = 0;
            vector.addElement(this.r);
        }
        int n5 = n3 * Math.min(n2, n);
        if (n4 > 0) {
            int n6 = Math.min(n4, n5);
            n5 -= n6;
            Report.addNewline(vector);
            Vector<Report> vector2 = this.server.damageBuilding(building, n6);
            for (Report report : vector2) {
                report.subject = this.subjectId;
            }
            vector.addAll(vector2);
        }
        if (n5 == 0) {
            this.r = new Report(3415);
            this.r.subject = this.subjectId;
            this.r.indent(2);
            this.r.addDesc(entity);
            this.r.newlines = 0;
            vector.addElement(this.r);
            this.missed = true;
        } else {
            if (this.bGlancing) {
                hitData.makeGlancingBlow();
            }
            if (entity.hasActiveShield(hitData.getLocation(), hitData.isRear()) || entity.hasPassiveShield(hitData.getLocation(), hitData.isRear()) || entity.hasNoDefenseShield(hitData.getLocation())) {
                vector.addAll(this.server.damageEntity(entity, hitData, n5, false, this.ae.getSwarmTargetId() == entity.getId() ? Server.DamageType.IGNORE_PASSENGER : Server.DamageType.NONE, false, false, this.throughFront));
                hitData = hitData.getLocation() == 4 || hitData.getLocation() == 6 || hitData.getLocation() == 2 ? new HitData(4) : (hitData.getLocation() == 5 || hitData.getLocation() == 7 || hitData.getLocation() == 3 ? new HitData(5) : (entity.hasActiveShield(5) || entity.hasPassiveShield(5) || entity.hasNoDefenseShield(5) ? new HitData(5) : new HitData(4)));
                hitData.setEffect(32);
                vector.addAll(this.server.damageEntity(entity, hitData, n5, false, this.ae.getSwarmTargetId() == entity.getId() ? Server.DamageType.IGNORE_PASSENGER : this.damageType, false, false, this.throughFront));
            } else if (entity.getArmor(hitData.getLocation(), hitData.isRear()) > 0) {
                vector.addAll(this.server.damageEntity(entity, hitData, n5, false, this.ae.getSwarmTargetId() == entity.getId() ? Server.DamageType.IGNORE_PASSENGER : this.damageType, false, false, this.throughFront));
                hitData.setEffect(32);
                Report.addNewline(vector);
                vector.addAll(this.server.damageEntity(entity, hitData, n5, false, this.ae.getSwarmTargetId() == entity.getId() ? Server.DamageType.IGNORE_PASSENGER : this.damageType, true, false, this.throughFront));
            } else {
                vector.addAll(this.server.damageEntity(entity, hitData, n5, false, this.ae.getSwarmTargetId() == entity.getId() ? Server.DamageType.IGNORE_PASSENGER : Server.DamageType.NONE, true, false, this.throughFront));
            }
        }
    }

    @Override
    protected int calcDamagePerHit() {
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            int n = (int)Math.ceil((float)this.wtype.getRackSize() / 5.0f);
            if (this.bGlancing) {
                n = (int)Math.floor((double)n / 2.0);
            }
            return n;
        }
        return 1;
    }
}

