/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.AmmoWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UltraWeaponHandler
extends AmmoWeaponHandler {
    private static final long serialVersionUID = 7551194199079004134L;
    int howManyShots;

    public UltraWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected void useAmmo() {
        this.setDone();
        this.checkAmmo();
        int n = this.ae.getTotalAmmoOfType(this.ammo.getType());
        if (n > 1) {
            this.howManyShots = 2;
        }
        if (n == 1) {
            this.howManyShots = 1;
        }
        if (n == 0) {
            // empty if block
        }
        if (this.ammo.getShotsLeft() == 0) {
            this.ae.loadWeapon(this.weapon);
            this.ammo = this.weapon.getLinked();
        }
        if (this.ammo.getShotsLeft() == 1) {
            this.ammo.setShotsLeft(0);
            this.ae.loadWeapon(this.weapon);
            this.ammo = this.weapon.getLinked();
            this.ammo.setShotsLeft(this.ammo.getShotsLeft() - (this.howManyShots == 2 ? 1 : 0));
        } else {
            this.ammo.setShotsLeft(this.ammo.getShotsLeft() - this.howManyShots);
        }
    }

    @Override
    protected int calcHits(Vector<Report> vector) {
        int n;
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            return 1;
        }
        switch (this.howManyShots) {
            case 1: {
                n = 1;
                break;
            }
            default: {
                int n2 = n = this.allShotsHit() ? this.howManyShots : Compute.missilesHit(this.howManyShots);
                if (this.weapon.isJammed()) break;
                this.r = new Report(3325);
                this.r.subject = this.subjectId;
                this.r.add(n);
                this.r.add(" shot(s) ");
                this.r.add(this.toHit.getTableDesc());
                this.r.newlines = 0;
                vector.addElement(this.r);
                this.r = new Report(3345);
                this.r.subject = this.subjectId;
                this.r.newlines = 0;
                vector.addElement(this.r);
            }
        }
        this.bSalvo = true;
        return n;
    }

    @Override
    protected void addHeat() {
        for (int i = 0; i < this.howManyShots; ++i) {
            super.addHeat();
        }
    }

    @Override
    protected boolean doChecks(Vector<Report> vector) {
        if (this.roll == 2 && this.howManyShots == 2) {
            this.r = new Report();
            this.r.subject = this.subjectId;
            this.weapon.setJammed(true);
            if (this.wtype.getAmmoType() == 20) {
                this.r.messageId = 3160;
                this.weapon.setHit(true);
            } else {
                this.r.messageId = 3170;
            }
            vector.addElement(this.r);
            return false;
        }
        return false;
    }
}

