/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IBoard;
import megamek.common.IHex;
import megamek.common.ITerrainFactory;
import megamek.common.Report;
import megamek.common.Terrains;
import megamek.server.DynamicTerrainProcessor;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeyserProcessor
extends DynamicTerrainProcessor {
    private Vector<GeyserInfo> geysers = null;

    public GeyserProcessor(Server server) {
        super(server);
    }

    @Override
    public void DoEndPhaseChanges(Vector<Report> vector) {
        if (this.geysers == null || this.server.getGame().getRoundCount() == 1) {
            this.geysers = new Vector();
            this.findGeysers();
        }
        ITerrainFactory iTerrainFactory = Terrains.getTerrainFactory();
        Iterator<GeyserInfo> iterator = this.geysers.iterator();
        while (iterator.hasNext()) {
            Report report;
            GeyserInfo geyserInfo = iterator.next();
            if (geyserInfo.turnsToGo > 0) {
                --geyserInfo.turnsToGo;
                continue;
            }
            IHex iHex = this.server.getGame().getBoard().getHex(geyserInfo.position);
            if (iHex.terrainLevel(22) == 2) {
                report = new Report(5275);
                report.add(geyserInfo.position.getBoardNum());
                vector.add(report);
                iHex.removeTerrain(22);
                iHex.addTerrain(iTerrainFactory.createTerrain(22, 1));
                this.server.sendChangedHex(geyserInfo.position);
                continue;
            }
            if (Compute.d6() != 1) continue;
            if (iHex.terrainLevel(22) == 3) {
                report = new Report(5285);
                report.add(geyserInfo.position.getBoardNum());
                vector.add(report);
                iHex.removeAllTerrains();
                iHex.addTerrain(iTerrainFactory.createTerrain(24, 2));
                this.server.sendChangedHex(geyserInfo.position);
                iterator.remove();
                Enumeration<Entity> enumeration = this.server.getGame().getEntities(geyserInfo.position);
                while (enumeration.hasMoreElements()) {
                    this.server.doMagmaDamage(enumeration.nextElement(), true);
                }
                continue;
            }
            report = new Report(5280);
            report.add(geyserInfo.position.getBoardNum());
            vector.add(report);
            iHex.removeTerrain(22);
            iHex.addTerrain(iTerrainFactory.createTerrain(22, 2));
            this.server.sendChangedHex(geyserInfo.position);
            geyserInfo.turnsToGo = Compute.d6() - 1;
        }
    }

    private void findGeysers() {
        IBoard iBoard = this.server.getGame().getBoard();
        int n = iBoard.getHeight();
        int n2 = iBoard.getWidth();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!iBoard.getHex(i, j).containsTerrain(22)) continue;
                this.geysers.add(new GeyserInfo(new Coords(i, j)));
            }
        }
    }

    private class GeyserInfo {
        Coords position;
        int turnsToGo;

        GeyserInfo(Coords coords) {
            this.position = coords;
            this.turnsToGo = 0;
        }
    }
}

