/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import megamek.MegaMek;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.BipedMech;
import megamek.common.Board;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.EquipmentMode;
import megamek.common.EquipmentType;
import megamek.common.Flare;
import megamek.common.FuelTank;
import megamek.common.Game;
import megamek.common.GameTurn;
import megamek.common.GunEmplacement;
import megamek.common.HexTarget;
import megamek.common.HitData;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.INarcPod;
import megamek.common.ITerrain;
import megamek.common.Infantry;
import megamek.common.InfernoTracker;
import megamek.common.LocationFullException;
import megamek.common.LosEffects;
import megamek.common.MapSettings;
import megamek.common.Mech;
import megamek.common.MechWarrior;
import megamek.common.Minefield;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.MoveStep;
import megamek.common.PhysicalResult;
import megamek.common.Pilot;
import megamek.common.PilotingRollData;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Report;
import megamek.common.RoundUpdated;
import megamek.common.SpecialHexDisplay;
import megamek.common.SupportTank;
import megamek.common.SupportVTOL;
import megamek.common.Tank;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.Team;
import megamek.common.Terrain;
import megamek.common.Terrains;
import megamek.common.ToHitData;
import megamek.common.TurnOrdered;
import megamek.common.TurnVectors;
import megamek.common.UnitLocation;
import megamek.common.VTOL;
import megamek.common.WeaponComparator;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.AbstractEntityAction;
import megamek.common.actions.ArtilleryAttackAction;
import megamek.common.actions.AttackAction;
import megamek.common.actions.BreakGrappleAttackAction;
import megamek.common.actions.BrushOffAttackAction;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.ClearMinefieldAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.actions.DisplacementAttackAction;
import megamek.common.actions.DodgeAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.FindClubAction;
import megamek.common.actions.FlipArmsAction;
import megamek.common.actions.GrappleAttackAction;
import megamek.common.actions.JumpJetAttackAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.LayExplosivesAttackAction;
import megamek.common.actions.LayMinefieldAction;
import megamek.common.actions.ProtomechPhysicalAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.RepairWeaponMalfunctionAction;
import megamek.common.actions.SearchlightAttackAction;
import megamek.common.actions.SpotAction;
import megamek.common.actions.ThrashAttackAction;
import megamek.common.actions.TorsoTwistAction;
import megamek.common.actions.TriggerAPPodAction;
import megamek.common.actions.TripAttackAction;
import megamek.common.actions.UnjamAction;
import megamek.common.actions.UnjamTurretAction;
import megamek.common.actions.UnloadStrandedAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.containers.PlayerIDandList;
import megamek.common.net.ConnectionFactory;
import megamek.common.net.ConnectionListenerAdapter;
import megamek.common.net.DisconnectedEvent;
import megamek.common.net.IConnection;
import megamek.common.net.Packet;
import megamek.common.net.PacketReceivedEvent;
import megamek.common.options.IBasicOption;
import megamek.common.options.IOption;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.BoardUtilities;
import megamek.common.util.StringUtil;
import megamek.common.verifier.EntityVerifier;
import megamek.common.verifier.TestEntity;
import megamek.common.verifier.TestMech;
import megamek.common.verifier.TestTank;
import megamek.common.weapons.AttackHandler;
import megamek.common.weapons.TAGHandler;
import megamek.common.weapons.Weapon;
import megamek.common.weapons.WeaponHandler;
import megamek.server.DynamicTerrainProcessor;
import megamek.server.ElevatorProcessor;
import megamek.server.FireProcessor;
import megamek.server.GeyserProcessor;
import megamek.server.UnitStatusFormatter;
import megamek.server.commands.AddBotCommand;
import megamek.server.commands.CheckBVCommand;
import megamek.server.commands.DefeatCommand;
import megamek.server.commands.ExportListCommand;
import megamek.server.commands.FixElevationCommand;
import megamek.server.commands.HelpCommand;
import megamek.server.commands.KickCommand;
import megamek.server.commands.LocalSaveGameCommand;
import megamek.server.commands.NukeCommand;
import megamek.server.commands.ResetCommand;
import megamek.server.commands.RollCommand;
import megamek.server.commands.RulerCommand;
import megamek.server.commands.SaveGameCommand;
import megamek.server.commands.SeeAllCommand;
import megamek.server.commands.ServerCommand;
import megamek.server.commands.ShowEntityCommand;
import megamek.server.commands.ShowTileCommand;
import megamek.server.commands.ShowValidTargetsCommand;
import megamek.server.commands.SkipCommand;
import megamek.server.commands.TeamCommand;
import megamek.server.commands.VictoryCommand;
import megamek.server.commands.WhoCommand;
import megamek.server.victory.Victory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements Runnable {
    public static final String DEFAULT_BOARD = "[SURPRISE]";
    private static final String VERIFIER_CONFIG_FILENAME = "data/mechfiles/UnitVerifierOptions.xml";
    private String password;
    private ServerSocket serverSocket;
    private String motd;
    Vector<IConnection> connections = new Vector(4);
    Vector<IConnection> connectionsPending = new Vector(4);
    Hashtable<Integer, IConnection> connectionIds = new Hashtable();
    private int connectionCounter;
    IGame game = new Game();
    private Vector<Report> vPhaseReport = new Vector();
    private MapSettings mapSettings = new MapSettings();
    private Hashtable<String, ServerCommand> commandsHash = new Hashtable();
    private Thread connector;
    private Hashtable<Building, Boolean> affectedBldgs = new Hashtable();
    private Vector<PhysicalResult> physicalResults = new Vector();
    private Vector<DynamicTerrainProcessor> terrainProcessors = new Vector();
    private Timer timer = new Timer();
    private static EntityVerifier entityVerifier;
    private ArrayList<int[]> scheduledNukes = new ArrayList();
    private static Server serverInstance;
    private ConnectionListenerAdapter connectionListener = new ConnectionListenerAdapter(){

        public void disconnected(DisconnectedEvent disconnectedEvent) {
            IConnection iConnection = disconnectedEvent.getConnection();
            System.out.println("s: connection " + iConnection.getId() + " disconnected");
            Server.this.connections.removeElement(iConnection);
            Server.this.connectionsPending.removeElement(iConnection);
            Server.this.connectionIds.remove(new Integer(iConnection.getId()));
            Player player = Server.this.getPlayer(iConnection.getId());
            if (null != player) {
                Server.this.disconnected(player);
            }
        }

        public void packetReceived(PacketReceivedEvent packetReceivedEvent) {
            Server.this.handle(packetReceivedEvent.getConnection().getId(), packetReceivedEvent.getPacket());
        }
    };
    private static final String DUNE_CALL = "They tried and failed?";
    private static final String DUNE_RESPONSE = "They tried and died!";
    private static final String STAR_WARS_CALL = "I'd just as soon kiss a Wookiee.";
    private static final String STAR_WARS_RESPONSE = "I can arrange that!";

    public Server(String string, int n) throws IOException {
        serverInstance = this;
        this.password = string.length() > 0 ? string : null;
        this.serverSocket = new ServerSocket(n);
        this.serverSocket.setSoTimeout(50);
        this.motd = this.createMotd();
        this.game.getOptions().initialize();
        this.game.getOptions().loadOptions();
        this.changePhase(IGame.Phase.PHASE_LOUNGE);
        System.out.println("s: starting a new server...");
        try {
            String string2 = InetAddress.getLocalHost().getHostName();
            System.out.print("s: hostname = '");
            System.out.print(string2);
            System.out.print("' port = ");
            System.out.println(this.serverSocket.getLocalPort());
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string2);
            for (int i = 0; i < inetAddressArray.length; ++i) {
                System.out.println("s: hosting on address = " + inetAddressArray[i].getHostAddress());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        System.out.println("s: password = " + this.password);
        this.registerCommand(new DefeatCommand(this));
        this.registerCommand(new ExportListCommand(this));
        this.registerCommand(new FixElevationCommand(this));
        this.registerCommand(new HelpCommand(this));
        this.registerCommand(new KickCommand(this));
        this.registerCommand(new LocalSaveGameCommand(this));
        this.registerCommand(new ResetCommand(this));
        this.registerCommand(new RollCommand(this));
        this.registerCommand(new SaveGameCommand(this));
        this.registerCommand(new SeeAllCommand(this));
        this.registerCommand(new SkipCommand(this));
        this.registerCommand(new VictoryCommand(this));
        this.registerCommand(new WhoCommand(this));
        this.registerCommand(new TeamCommand(this));
        this.registerCommand(new ShowTileCommand(this));
        this.registerCommand(new ShowEntityCommand(this));
        this.registerCommand(new RulerCommand(this));
        this.registerCommand(new ShowValidTargetsCommand(this));
        this.registerCommand(new AddBotCommand(this));
        this.registerCommand(new CheckBVCommand(this));
        this.registerCommand(new NukeCommand(this));
        this.terrainProcessors.add(new FireProcessor(this));
        this.terrainProcessors.add(new GeyserProcessor(this));
        this.terrainProcessors.add(new ElevatorProcessor(this));
        this.connector = new Thread((Runnable)this, "Connection Listener");
        this.connector.start();
    }

    public void setGame(IGame iGame) {
        TurnOrdered turnOrdered;
        this.game = iGame;
        Enumeration<TurnOrdered> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            turnOrdered = enumeration.nextElement();
            ((Entity)turnOrdered).setGame(this.game);
        }
        this.game.setOutOfGameEntitiesVector(this.game.getOutOfGameEntitiesVector());
        enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            turnOrdered = (Player)enumeration.nextElement();
            ((Player)turnOrdered).setGame(this.game);
            ((Player)turnOrdered).setGhost(true);
        }
    }

    public IGame getGame() {
        return this.game;
    }

    private String createMotd() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Welcome to MegaMek.  Server is running version ");
        stringBuffer.append(MegaMek.VERSION);
        stringBuffer.append(", build date ");
        if (MegaMek.TIMESTAMP > 0L) {
            stringBuffer.append(new Date(MegaMek.TIMESTAMP).toString());
        } else {
            stringBuffer.append("unknown");
        }
        stringBuffer.append('.');
        return stringBuffer.toString();
    }

    public boolean isPassworded() {
        return this.password != null;
    }

    public boolean isPassword(Object object) {
        return this.password.equals(object);
    }

    private void registerCommand(ServerCommand serverCommand) {
        this.commandsHash.put(serverCommand.getName(), serverCommand);
    }

    public ServerCommand getCommand(String string) {
        return this.commandsHash.get(string);
    }

    public void die() {
        IConnection iConnection;
        this.timer.cancel();
        this.connector = null;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Enumeration<IConnection> enumeration = this.connectionsPending.elements();
        while (enumeration.hasMoreElements()) {
            iConnection = enumeration.nextElement();
            iConnection.close();
        }
        this.connectionsPending.removeAllElements();
        enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            iConnection = enumeration.nextElement();
            this.send(iConnection.getId(), new Packet(0));
        }
        enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            iConnection = enumeration.nextElement();
            iConnection.close();
        }
        this.connections.removeAllElements();
        this.connectionIds.clear();
        System.out.flush();
    }

    public Enumeration<String> getAllCommandNames() {
        return this.commandsHash.keys();
    }

    void greeting(int n) {
        this.sendToPending(n, new Packet(10));
    }

    public int getFreeConnectionId() {
        while (this.getPendingConnection(this.connectionCounter) != null || this.getConnection(this.connectionCounter) != null || this.getPlayer(this.connectionCounter) != null) {
            ++this.connectionCounter;
        }
        return this.connectionCounter;
    }

    public int getFreeEntityId() {
        return this.game.getNextEntityId();
    }

    private void receivePlayerInfo(Packet packet, int n) {
        Player player = (Player)packet.getObject(0);
        Player player2 = this.game.getPlayer(n);
        if (null != player2) {
            player2.setColorIndex(player.getColorIndex());
            player2.setStartingPos(player.getStartingPos());
            player2.setTeam(player.getTeam());
            player2.setCamoCategory(player.getCamoCategory());
            player2.setCamoFileName(player.getCamoFileName());
            player2.setNbrMFConventional(player.getNbrMFConventional());
            player2.setNbrMFCommand(player.getNbrMFCommand());
            player2.setNbrMFVibra(player.getNbrMFVibra());
            player2.setConstantInitBonus(player.getConstantInitBonus());
        }
    }

    private String correctDupeName(String string) {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            if (!player.getName().equals(string)) continue;
            String string2 = string;
            int n = 2;
            try {
                n = Integer.parseInt(string.substring(string.lastIndexOf(".") + 1));
                ++n;
                string2 = string.substring(0, string.lastIndexOf("."));
            }
            catch (Exception exception) {
                n = 2;
            }
            string2 = string2.concat(".").concat(Integer.toString(n));
            return this.correctDupeName(string2);
        }
        return string;
    }

    private void receivePlayerName(Packet packet, int n) {
        Object object;
        IConnection iConnection = this.getPendingConnection(n);
        String string = (String)packet.getObject(0);
        boolean bl = false;
        if (iConnection == null) {
            System.out.println("server: got a client name from a non-pending connection");
            return;
        }
        Object object2 = this.game.getPlayers();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            if (!((Player)object).getName().equals(string) || !((Player)object).isGhost()) continue;
            bl = true;
            ((Player)object).setGhost(false);
            n = ((Player)object).getId();
            iConnection.setId(n);
        }
        if (!bl) {
            string = this.correctDupeName(string);
            this.send(n, new Packet(480, string));
        }
        this.connectionsPending.removeElement(iConnection);
        this.connections.addElement(iConnection);
        this.connectionIds.put(new Integer(iConnection.getId()), iConnection);
        if (!bl) {
            this.game.addPlayer(n, new Player(n, string));
            this.validatePlayerInfo(n);
        }
        object2 = this.getPlayer(n);
        if (this.game.getPhase() != IGame.Phase.PHASE_LOUNGE && null != object2 && this.game.getEntitiesOwnedBy((Player)object2) < 1) {
            ((Player)object2).setObserver(true);
        }
        this.sendServerChat(n, this.motd);
        this.send(this.createPlayerConnectPacket(n));
        this.send(n, new Packet(30, new Integer(n)));
        this.sendCurrentInfo(n);
        try {
            object = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            for (int i = 0; i < ((InetAddress[])object).length; ++i) {
                this.sendServerChat(n, "Machine IP is " + object[i].getHostAddress());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.sendServerChat(n, "Listening on port " + this.serverSocket.getLocalPort());
        object2 = this.getPlayer(n);
        if (null != object2) {
            object = new StringBuffer();
            ((StringBuffer)object).append(((Player)object2).getName()).append(" connected from ").append(this.getClient(n).getInetAddress());
            String string2 = ((StringBuffer)object).toString();
            System.out.print("s: player #");
            System.out.print(n);
            System.out.print(", ");
            System.out.println(string2);
            this.sendServerChat(string2);
        }
    }

    private void sendCurrentInfo(int n) {
        this.transmitAllPlayerConnects(n);
        this.send(n, this.createGameSettingsPacket());
        Player player = this.game.getPlayer(n);
        if (null != player) {
            this.send(n, new Packet(420, player.getMinefields()));
            switch (this.game.getPhase()) {
                case PHASE_LOUNGE: {
                    this.send(n, this.createMapSettingsPacket());
                    this.send(n, new Packet(240, (Object)this.game.getPhase()));
                    if (this.doBlind()) {
                        this.send(n, this.createFilteredFullEntitiesPacket(player));
                        break;
                    }
                    this.send(n, this.createFullEntitiesPacket());
                    break;
                }
                default: {
                    this.send(n, new Packet(260, new Integer(this.game.getRoundCount())));
                    this.send(n, this.createAllReportsPacket(player));
                    if (this.doBlind()) {
                        this.send(n, this.createFilteredFullEntitiesPacket(player));
                    } else {
                        this.send(n, this.createFullEntitiesPacket());
                    }
                    player.setDone(this.game.getEntitiesOwnedBy(player) <= 0);
                    this.send(n, this.createBoardPacket());
                    this.send(n, new Packet(240, (Object)this.game.getPhase()));
                }
            }
            if (this.game.getPhase() == IGame.Phase.PHASE_FIRING || this.game.getPhase() == IGame.Phase.PHASE_TARGETING || this.game.getPhase() == IGame.Phase.PHASE_OFFBOARD || this.game.getPhase() == IGame.Phase.PHASE_PHYSICAL) {
                this.send(n, this.createAttackPacket(this.game.getActionsVector(), 0));
                this.send(n, this.createAttackPacket(this.game.getChargesVector(), 1));
                this.send(n, this.createAttackPacket(this.game.getLayMinefieldActionsVector(), 2));
            }
            if (this.game.phaseHasTurns(this.game.getPhase())) {
                this.send(n, this.createTurnVectorPacket());
                this.send(n, this.createTurnIndexPacket());
            }
            this.send(n, this.createArtilleryPacket(player));
            this.send(n, this.createFlarePacket());
            this.send(n, this.createSpecialHexDisplayPacket(n));
        }
    }

    public void sendEntities(int n) {
        if (this.doBlind()) {
            this.send(n, this.createFilteredEntitiesPacket(this.getPlayer(n)));
        } else {
            this.send(n, this.createEntitiesPacket());
        }
    }

    public void validatePlayerInfo(int n) {
        Player player = this.getPlayer(n);
        boolean[] blArray = new boolean[Player.colorNames.length];
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player2 = enumeration.nextElement();
            if (player2.getId() == n) continue;
            blArray[player2.getColorIndex()] = true;
        }
        if (null != player && blArray[player.getColorIndex()]) {
            for (int i = 0; i < blArray.length; ++i) {
                if (blArray[i]) continue;
                player.setColorIndex(i);
                break;
            }
        }
    }

    void disconnected(Player player) {
        IGame.Phase phase = this.game.getPhase();
        if (phase == IGame.Phase.PHASE_LOUNGE) {
            this.removeAllEntitesOwnedBy(player);
        }
        if (this.game.getEntitiesOwnedBy(player) > 0 && phase != IGame.Phase.PHASE_VICTORY) {
            player.setGhost(true);
            player.setDone(true);
            this.send(this.createPlayerUpdatePacket(player.getId()));
        } else {
            this.game.removePlayer(player.getId());
            this.send(new Packet(50, new Integer(player.getId())));
        }
        if (this.game.phaseHasTurns(this.game.getPhase()) && null != this.game.getTurn()) {
            if (this.game.getTurn().isValid(player.getId(), this.game)) {
                this.sendGhostSkipMessage(player);
            }
        } else {
            this.checkReady();
        }
        this.sendServerChat(player.getName() + " disconnected.");
        System.out.println("s: removed player " + player.getName());
        if (0 == this.game.getNoOfPlayers()) {
            this.resetGame();
        }
    }

    public void checkForObservers() {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player;
            player.setObserver(this.game.getEntitiesOwnedBy(player = enumeration.nextElement()) < 1 && this.game.getPhase() != IGame.Phase.PHASE_LOUNGE);
        }
    }

    public void resetGame() {
        this.game.reset();
        this.send(this.createEntitiesPacket());
        this.send(new Packet(420, new Vector()));
        ArrayList<Player> arrayList = new ArrayList<Player>();
        Object object = this.game.getPlayers();
        while (object.hasMoreElements()) {
            Player player = object.nextElement();
            if (player.isGhost()) {
                arrayList.add(player);
                continue;
            }
            player.setStartingPos(0);
            this.send(this.createPlayerUpdatePacket(player.getId()));
        }
        for (Player player : arrayList) {
            this.game.removePlayer(player.getId());
            this.send(new Packet(50, new Integer(player.getId())));
        }
        this.resetPlayersDone();
        this.transmitAllPlayerDones();
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        System.out.print(((DateFormat)object).format(new Date()));
        System.out.println(" END OF GAME");
        this.changePhase(IGame.Phase.PHASE_LOUNGE);
    }

    public void autoSave() {
        String string = "autosave";
        if (PreferenceManager.getClientPreferences().stampFilenames()) {
            string = StringUtil.addDateTimeStamp(string);
        }
        this.saveGame(string, this.game.getOptions().booleanOption("autosave_msg"));
    }

    public void sendSaveGame(int n, String string) {
        this.saveGame(string, false);
        String string2 = string;
        if (!string2.endsWith(".sav")) {
            string2 = string + ".sav";
        }
        String string3 = "savegames" + File.separator + string2;
        File file = new File(string3);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.send(n, new Packet(490, new Object[]{string2, objectInputStream.readObject()}));
            this.sendChat(n, "***Server", "Savegame has been sent to you.");
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Unable to load file: " + file);
            exception.printStackTrace();
        }
    }

    public void saveGame(String string, boolean bl) {
        String string2 = string;
        if (!string2.endsWith(".sav")) {
            string2 = string + ".sav";
        }
        try {
            File file = new File("savegames");
            if (!file.exists()) {
                file.mkdir();
            }
            string2 = file + File.separator + string2;
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string2));
            objectOutputStream.writeObject(this.game);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Unable to save file: " + string2);
            exception.printStackTrace();
        }
        if (bl) {
            this.sendChat("MegaMek", "Game saved to " + string2);
        }
    }

    public void saveGame(String string) {
        this.saveGame(string, true);
    }

    public boolean loadGame(File file) {
        System.out.println("s: loading saved game file '" + file + '\'');
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.game = (IGame)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Unable to load file: " + file);
            exception.printStackTrace();
            return false;
        }
        this.setGame(this.game);
        return true;
    }

    public Player getPlayer(int n) {
        return this.game.getPlayer(n);
    }

    private void removeAllEntitesOwnedBy(Player player) {
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!entity.getOwner().equals(player)) continue;
            vector.addElement(entity);
        }
        for (Entity entity : vector) {
            int n = entity.getId();
            this.game.removeEntity(n, 2048);
            this.send(this.createRemoveEntityPacket(n, 2048));
        }
    }

    private IConnection getClient(int n) {
        return this.getConnection(n);
    }

    public Enumeration<IConnection> getConnections() {
        return this.connections.elements();
    }

    public IConnection getConnection(int n) {
        return this.connectionIds.get(new Integer(n));
    }

    IConnection getPendingConnection(int n) {
        Enumeration<IConnection> enumeration = this.connectionsPending.elements();
        while (enumeration.hasMoreElements()) {
            IConnection iConnection = enumeration.nextElement();
            if (iConnection.getId() != n) continue;
            return iConnection;
        }
        return null;
    }

    private void resetEntityRound() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            entity.newRound(this.game.getRoundCount());
        }
    }

    private void resetEntityPhase(IGame.Phase phase) {
        int n;
        Entity entity3;
        Vector<Entity> vector = new Vector<Entity>(0, 10);
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity3 = enumeration.nextElement();
            if (entity3.crew.isDoomed()) {
                entity3.crew.setDoomed(false);
                entity3.crew.setDead(true);
                if (entity3 instanceof Tank) {
                    entity3.setCarcass(true);
                    ((Tank)entity3).immobilize();
                } else {
                    entity3.setDestroyed(true);
                }
            }
            if (entity3.isDoomed()) {
                entity3.setDestroyed(true);
                n = entity3.getSwarmTargetId();
                if (-1 != n) {
                    Entity entity2 = this.game.getEntity(n);
                    entity2.setSwarmAttackerId(-1);
                    entity3.setSwarmTargetId(-1);
                    Report report = new Report(5165);
                    report.subject = n;
                    report.addDesc(entity2);
                    this.addReport(report);
                    this.entityUpdate(n);
                }
            }
            if (!entity3.isDestroyed()) continue;
            vector.addElement(entity3);
        }
        for (Entity entity3 : vector) {
            n = 512;
            if (!entity3.isSalvage()) {
                n = 1024;
            }
            this.entityUpdate(entity3.getId());
            this.game.removeEntity(entity3.getId(), n);
            this.send(this.createRemoveEntityPacket(entity3.getId(), n));
        }
        enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity3 = enumeration.nextElement();
            entity3.applyDamage();
            entity3.reloadEmptyWeapons();
            entity3.damageThisPhase = 0;
            entity3.engineHitsThisRound = 0;
            entity3.rolledForEngineExplosion = false;
            entity3.dodging = false;
            if (phase == IGame.Phase.PHASE_DEPLOYMENT) {
                entity3.setDone(!entity3.shouldDeploy(this.game.getRoundCount()));
            } else {
                entity3.setDone(false);
            }
            entity3.setIlluminated(false);
            entity3.setUsedSearchlight(false);
        }
    }

    private boolean isReportingPhase() {
        return this.game.getPhase() == IGame.Phase.PHASE_FIRING_REPORT || this.game.getPhase() == IGame.Phase.PHASE_INITIATIVE_REPORT || this.game.getPhase() == IGame.Phase.PHASE_MOVEMENT_REPORT || this.game.getPhase() == IGame.Phase.PHASE_OFFBOARD_REPORT || this.game.getPhase() == IGame.Phase.PHASE_PHYSICAL_REPORT;
    }

    private void resetPlayersDone() {
        if (this.isReportingPhase()) {
            return;
        }
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            player.setDone(false);
        }
        this.transmitAllPlayerDones();
    }

    private void resetActivePlayersDone() {
        if (this.isReportingPhase()) {
            return;
        }
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player;
            player.setDone(this.game.getEntitiesOwnedBy(player = enumeration.nextElement()) <= 0);
        }
        this.transmitAllPlayerDones();
    }

    private void prepareVictoryReport() {
        Object object;
        Enumeration<Entity> enumeration;
        Object object2;
        Object object3;
        Object object4;
        Vector<Entity> vector = new Vector<Entity>();
        for (Entity enumeration22 : this.game.getEntitiesVector()) {
            if (!enumeration22.isCarcass() || enumeration22.isDestroyed()) continue;
            vector.add(enumeration22);
        }
        for (Entity entity : vector) {
            this.destroyEntity(entity, "crew death", false, true);
            this.game.removeEntity(entity.getId(), 512);
            entity.setDestroyed(true);
        }
        this.addReport(new Report(7000, 0));
        Report report = new Report(1210);
        report.type = 0;
        if (this.game.getVictoryTeam() == 0) {
            object4 = this.getPlayer(this.game.getVictoryPlayerId());
            if (null == object4) {
                report.messageId = 7005;
            } else {
                report.messageId = 7010;
                report.add(((Player)object4).getName());
            }
        } else {
            report.messageId = 7015;
            report.add(this.game.getVictoryTeam());
        }
        this.addReport(report);
        object4 = this.game.getPlayers();
        while (object4.hasMoreElements()) {
            Player player = object4.nextElement();
            report = new Report();
            report.type = 0;
            report.messageId = 7016;
            report.add(player.getName());
            report.add(player.getBV());
            report.add(player.getInitialBV());
            this.addReport(report);
        }
        Enumeration<Entity> enumeration2 = this.game.getEntities();
        if (enumeration2.hasMoreElements()) {
            this.addReport(new Report(7020, 0));
            while (enumeration2.hasMoreElements()) {
                object3 = enumeration2.nextElement();
                if (!((Entity)object3).isDeployed()) continue;
                this.addReport(((Entity)object3).victoryReport());
            }
        }
        if ((object3 = this.game.getEntities()).hasMoreElements()) {
            boolean bl = false;
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                if (((Entity)object2).isDeployed()) continue;
                if (!bl) {
                    this.addReport(new Report(7075, 0));
                    bl = true;
                }
                this.addReport(((Entity)object2).victoryReport());
            }
        }
        if ((enumeration = this.game.getRetreatedEntities()).hasMoreElements()) {
            this.addReport(new Report(7080, 0));
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                this.addReport(((Entity)object2).victoryReport());
            }
        }
        if ((object2 = this.game.getGraveyardEntities()).hasMoreElements()) {
            this.addReport(new Report(7085, 0));
            while (object2.hasMoreElements()) {
                object = (Entity)object2.nextElement();
                this.addReport(((Entity)object).victoryReport());
            }
        }
        if ((object = this.game.getDevastatedEntities()).hasMoreElements()) {
            this.addReport(new Report(7090, 0));
            while (object.hasMoreElements()) {
                Entity entity = (Entity)object.nextElement();
                this.addReport(entity.victoryReport());
            }
        }
        this.addReport(new Report(7095, 0));
    }

    private String getDetailedVictoryReport() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration<TurnOrdered> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.game.getRetreatedEntities();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.game.getGraveyardEntities();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Entity entity;
            Player player = (Player)enumeration.nextElement();
            stringBuffer.append("++++++++++ ").append(player.getName()).append(" ++++++++++");
            stringBuffer.append("\r\n");
            for (int i = 0; i < vector.size(); ++i) {
                entity = (Entity)vector.elementAt(i);
                if (entity.getOwner() != player) continue;
                stringBuffer.append(UnitStatusFormatter.format(entity));
            }
            Enumeration<Entity> enumeration2 = this.game.getDevastatedEntities();
            if (!enumeration2.hasMoreElements()) continue;
            stringBuffer.append("=============================================================");
            stringBuffer.append("\r\n");
            stringBuffer.append("The following utterly destroyed units are not available for salvage:");
            stringBuffer.append("\r\n");
            while (enumeration2.hasMoreElements()) {
                entity = enumeration2.nextElement();
                if (entity.getOwner() != player) continue;
                stringBuffer.append(entity.getShortName()).append(", Pilot: ").append(entity.getCrew().getName()).append(" (").append(entity.getCrew().getGunnery()).append('/').append(entity.getCrew().getPiloting()).append(')');
                stringBuffer.append("\r\n");
            }
            stringBuffer.append("=============================================================");
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    public void forceVictory(Player player) {
        this.game.setForceVictory(true);
        if (player.getTeam() == 0) {
            this.game.setVictoryPlayerId(player.getId());
            this.game.setVictoryTeam(0);
        } else {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(player.getTeam());
        }
        Vector<Player> vector = this.game.getPlayersVector();
        for (int i = 0; i < vector.size(); ++i) {
            Player player2 = vector.elementAt(i);
            player2.setAdmitsDefeat(false);
        }
    }

    public void cancelVictory() {
        this.game.setForceVictory(false);
        this.game.setVictoryPlayerId(-1);
        this.game.setVictoryTeam(0);
    }

    private void checkReady() {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            if (player.isGhost() || player.isObserver() || player.isDone()) continue;
            return;
        }
        if (this.game.getNoOfInitiativeRerollRequests() > 0) {
            this.resetActivePlayersDone();
            this.game.rollInitAndResolveTies();
            this.determineTurnOrder(IGame.Phase.PHASE_INITIATIVE);
            this.clearReports();
            this.writeInitiativeReport(true);
            this.sendReport(true);
            return;
        }
        if (!(this.game.phaseHasTurns(this.game.getPhase()) || this.game.getPhase() == IGame.Phase.PHASE_LOUNGE && this.game.getNoOfEntities() <= 0)) {
            this.endCurrentPhase();
        }
    }

    private void endCurrentTurn(Entity entity) {
        boolean bl;
        boolean bl2 = false;
        GameTurn gameTurn = this.game.getTurn();
        final int n = null == entity ? -1 : entity.getOwnerId();
        boolean bl3 = entity instanceof Infantry;
        boolean bl4 = this.game.getOptions().booleanOption("inf_move_multi") && (this.game.getPhase() == IGame.Phase.PHASE_MOVEMENT || this.game.getPhase() == IGame.Phase.PHASE_INITIATIVE);
        boolean bl5 = entity instanceof Protomech;
        boolean bl6 = this.game.getOptions().booleanOption("protos_move_multi");
        int n2 = 0;
        if (bl4) {
            ++n2;
        }
        if (bl6) {
            n2 += 2;
        } else if (bl5 && this.game.getPhase() == IGame.Phase.PHASE_FIRING) {
            n2 = 0;
        }
        boolean bl7 = bl = !(gameTurn instanceof GameTurn.SpecificEntityTurn) && !(gameTurn instanceof GameTurn.UnitNumberTurn) && !(gameTurn instanceof GameTurn.UnloadStrandedTurn) && (!(gameTurn instanceof GameTurn.EntityClassTurn) || gameTurn instanceof GameTurn.EntityClassTurn && ((GameTurn.EntityClassTurn)gameTurn).isValidClass(~n2));
        if (bl5 && !bl6 && bl && entity != null) {
            final char c = entity.getUnitNumber();
            final int n3 = entity.getId();
            int n4 = this.game.getSelectedEntityCount(new EntitySelector(){
                private final int ownerId;
                private final int entityId;
                private final char unitNum;
                {
                    this.ownerId = n;
                    this.entityId = n3;
                    this.unitNum = c;
                }

                public boolean accept(Entity entity) {
                    return entity instanceof Protomech && entity.isSelectableThisTurn() && this.ownerId == entity.getOwnerId() && this.entityId != entity.getId() && this.unitNum == entity.getUnitNumber();
                }
            });
            for (int i = 0; i < n4; ++i) {
                GameTurn.UnitNumberTurn unitNumberTurn = new GameTurn.UnitNumberTurn(n, c);
                this.game.insertNextTurn(unitNumberTurn);
                bl2 = true;
            }
        } else if ((bl3 && bl4 || bl5 && bl6) && bl) {
            int n5 = 0;
            if (bl4) {
                n5 += this.game.getInfantryLeft(n);
            }
            if (bl6) {
                n5 += this.game.getProtomechsLeft(n);
            }
            int n6 = Math.min(this.game.getOptions().intOption("inf_proto_move_multi") - 1, n5);
            for (int i = 0; i < n6; ++i) {
                GameTurn.EntityClassTurn entityClassTurn = new GameTurn.EntityClassTurn(n, n2);
                this.game.insertNextTurn(entityClassTurn);
                bl2 = true;
            }
        }
        if (bl2) {
            this.send(this.createTurnVectorPacket());
        }
        this.changeToNextTurn();
    }

    private void changePhase(IGame.Phase phase) {
        this.game.setLastPhase(this.game.getPhase());
        this.game.setPhase(phase);
        this.prepareForPhase(phase);
        if (this.isPhasePlayable(phase)) {
            this.send(new Packet(240, (Object)phase));
            this.executePhase(phase);
        } else {
            this.endCurrentPhase();
        }
    }

    private void prepareForPhase(IGame.Phase phase) {
        switch (phase) {
            case PHASE_LOUNGE: {
                this.clearReports();
                this.mapSettings.setBoardsAvailableVector(this.scanForBoards(this.mapSettings.getBoardWidth(), this.mapSettings.getBoardHeight()));
                this.mapSettings.setNullBoards(DEFAULT_BOARD);
                this.send(this.createMapSettingsPacket());
                break;
            }
            case PHASE_INITIATIVE: {
                this.game.resetActions();
                this.game.resetTagInfo();
                this.clearReports();
                this.resetEntityRound();
                this.resetEntityPhase(phase);
                this.checkForObservers();
                this.resetActivePlayersDone();
                this.rollInitiative();
                if (!this.game.shouldDeployThisRound()) {
                    this.incrementAndSendGameRound();
                }
                this.determineTurnOrder(phase);
                this.writeInitiativeReport(false);
                System.out.println("Round " + this.game.getRoundCount() + " memory usage: " + MegaMek.getMemoryUsed());
                break;
            }
            case PHASE_DEPLOY_MINEFIELDS: {
                this.checkForObservers();
                this.resetActivePlayersDone();
                this.setIneligible(phase);
                Enumeration<Player> enumeration = this.game.getPlayers();
                Vector<GameTurn> vector = new Vector<GameTurn>();
                while (enumeration.hasMoreElements()) {
                    Player player = enumeration.nextElement();
                    if (!player.hasMinefields()) continue;
                    GameTurn gameTurn = new GameTurn(player.getId());
                    vector.addElement(gameTurn);
                }
                this.game.setTurnVector(vector);
                this.game.resetTurnIndex();
                this.send(this.createTurnVectorPacket());
                break;
            }
            case PHASE_SET_ARTYAUTOHITHEXES: {
                Object object;
                Enumeration<Entity> enumeration = this.game.getEntities();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    ((Entity)object).deployOffBoard();
                }
                this.checkForObservers();
                this.resetActivePlayersDone();
                this.setIneligible(phase);
                object = this.game.getPlayers();
                Vector<GameTurn> vector = new Vector<GameTurn>();
                while (object.hasMoreElements()) {
                    final Player player = (Player)object.nextElement();
                    EntitySelector entitySelector = new EntitySelector(){
                        private Player owner;
                        {
                            this.owner = player;
                        }

                        public boolean accept(Entity entity) {
                            return this.owner.equals(entity.getOwner()) && entity.isEligibleForTargetingPhase();
                        }
                    };
                    if (!this.game.getSelectedEntities(entitySelector).hasMoreElements()) continue;
                    GameTurn gameTurn = new GameTurn(player.getId());
                    vector.addElement(gameTurn);
                }
                this.game.setTurnVector(vector);
                this.game.resetTurnIndex();
                this.send(this.createTurnVectorPacket());
                break;
            }
            case PHASE_MOVEMENT: 
            case PHASE_DEPLOYMENT: 
            case PHASE_FIRING: 
            case PHASE_PHYSICAL: 
            case PHASE_TARGETING: 
            case PHASE_OFFBOARD: {
                this.resetEntityPhase(phase);
                this.checkForObservers();
                this.setIneligible(phase);
                this.determineTurnOrder(phase);
                this.resetActivePlayersDone();
                this.entityAllUpdate();
                this.clearReports();
                this.doTryUnstuck();
                break;
            }
            case PHASE_END: {
                this.resetEntityPhase(phase);
                this.clearReports();
                this.resolveHeat();
                this.addReport(new Report(5005, 0));
                this.checkForSuffocation();
                if (this.game.getOptions().booleanOption("vacuum")) {
                    this.checkForVacuumDeath();
                }
                if (this.game.getBoard().inAtmosphere()) {
                    this.checkForAtmosphereDeath();
                }
                if (this.game.getBoard().inSpace()) {
                    this.checkForSpaceDeath();
                }
                for (DynamicTerrainProcessor dynamicTerrainProcessor : this.terrainProcessors) {
                    dynamicTerrainProcessor.DoEndPhaseChanges(this.vPhaseReport);
                }
                this.addReport(this.game.ageFlares());
                this.send(this.createFlarePacket());
                this.resolveExtremeTempInfantryDeath();
                this.resolveAmmoDumps();
                this.resolveCrewWakeUp();
                this.resolveMechWarriorPickUp();
                this.resolveVeeINarcPodRemoval();
                this.resolveFortify();
                this.checkForObservers();
                this.entityAllUpdate();
                break;
            }
            case PHASE_INITIATIVE_REPORT: {
                this.autoSave();
                Enumeration<Player> enumeration = this.game.getPlayers();
                while (enumeration.hasMoreElements()) {
                    Player player = enumeration.nextElement();
                    Report report = new Report();
                    report.type = 0;
                    if (this.doBlind()) {
                        report.type = 4;
                        report.player = player.getId();
                    }
                    report.messageId = 7016;
                    report.add(player.getName());
                    report.add(player.getBV());
                    report.add(player.getInitialBV());
                    this.addReport(report);
                }
            }
            case PHASE_TARGETING_REPORT: 
            case PHASE_MOVEMENT_REPORT: 
            case PHASE_OFFBOARD_REPORT: 
            case PHASE_FIRING_REPORT: 
            case PHASE_PHYSICAL_REPORT: 
            case PHASE_END_REPORT: {
                this.resetActivePlayersDone();
                this.sendReport();
                if (!this.game.getOptions().booleanOption("paranoid_autosave")) break;
                this.autoSave();
                break;
            }
            case PHASE_VICTORY: {
                this.resetPlayersDone();
                this.clearReports();
                this.prepareVictoryReport();
                this.game.addReports(this.vPhaseReport);
                this.send(this.createFullEntitiesPacket());
                this.send(this.createReportPacket(null));
                this.send(this.createEndOfGamePacket());
            }
        }
    }

    private boolean isPhasePlayable(IGame.Phase phase) {
        switch (phase) {
            case PHASE_INITIATIVE: 
            case PHASE_END: {
                return false;
            }
            case PHASE_DEPLOY_MINEFIELDS: 
            case PHASE_SET_ARTYAUTOHITHEXES: 
            case PHASE_MOVEMENT: 
            case PHASE_DEPLOYMENT: 
            case PHASE_FIRING: 
            case PHASE_PHYSICAL: 
            case PHASE_TARGETING: {
                return this.game.hasMoreTurns();
            }
            case PHASE_OFFBOARD: {
                return this.isOffboardPlayable();
            }
        }
        return true;
    }

    private boolean isOffboardPlayable() {
        Object object;
        if (!this.game.hasMoreTurns()) {
            return false;
        }
        Enumeration<Object> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            for (Mounted object2 : ((Entity)object).getAmmo()) {
                AmmoType ammoType = (AmmoType)object2.getType();
                if ((ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 45) && ammoType.getMunitionType() == 262144L) {
                    return true;
                }
                if (ammoType.getAmmoType() != 15 && ammoType.getAmmoType() != 16 && ammoType.getAmmoType() != 17 || ammoType.getMunitionType() != 0x1000000000L) continue;
                return true;
            }
        }
        enumeration = this.game.getAttacks();
        while (enumeration.hasMoreElements()) {
            AmmoType ammoType;
            object = (AttackHandler)enumeration.nextElement();
            Mounted mounted = object.getWaa().getEntity(this.game).getEquipment(object.getWaa().getAmmoId());
            if (mounted == null || (ammoType = (AmmoType)mounted.getType()).getMunitionType() != 0x1000000000L) continue;
            return true;
        }
        return false;
    }

    private void executePhase(IGame.Phase phase) {
        switch (phase) {
            case PHASE_EXCHANGE: {
                this.resetPlayersDone();
                this.calculatePlayerBVs();
                this.game.setupTeams();
                this.applyBoardSettings();
                this.game.setupRoundDeployment();
                this.game.determineWind();
                this.game.setVictoryContext(new HashMap<String, Object>());
                this.game.createVictoryConditions();
                if (this.game.checkForMagneticClamp()) {
                    this.entityAllUpdate();
                }
                this.send(this.createBoardPacket());
                break;
            }
            case PHASE_MOVEMENT: {
                this.addReport(new Report(2000, 0));
            }
            case PHASE_DEPLOY_MINEFIELDS: 
            case PHASE_SET_ARTYAUTOHITHEXES: 
            case PHASE_DEPLOYMENT: 
            case PHASE_FIRING: 
            case PHASE_PHYSICAL: 
            case PHASE_TARGETING: 
            case PHASE_OFFBOARD: {
                this.changeToNextTurn();
                if (!this.game.getOptions().booleanOption("paranoid_autosave")) break;
                this.autoSave();
            }
        }
    }

    public void calculatePlayerBVs() {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setInitialBV();
        }
    }

    private void endCurrentPhase() {
        switch (this.game.getPhase()) {
            case PHASE_LOUNGE: {
                this.changePhase(IGame.Phase.PHASE_EXCHANGE);
                break;
            }
            case PHASE_EXCHANGE: {
                this.changePhase(IGame.Phase.PHASE_SET_ARTYAUTOHITHEXES);
                break;
            }
            case PHASE_STARTING_SCENARIO: {
                this.changePhase(IGame.Phase.PHASE_SET_ARTYAUTOHITHEXES);
                break;
            }
            case PHASE_SET_ARTYAUTOHITHEXES: {
                this.sendSpecialHexDisplayPackets();
                Enumeration<Player> enumeration = this.game.getPlayers();
                boolean bl = false;
                while (enumeration.hasMoreElements() && !bl) {
                    Player player = enumeration.nextElement();
                    if (!player.hasMinefields()) continue;
                    bl = true;
                }
                if (bl) {
                    this.changePhase(IGame.Phase.PHASE_DEPLOY_MINEFIELDS);
                    break;
                }
                this.changePhase(IGame.Phase.PHASE_INITIATIVE);
                break;
            }
            case PHASE_DEPLOY_MINEFIELDS: {
                this.changePhase(IGame.Phase.PHASE_INITIATIVE);
                break;
            }
            case PHASE_DEPLOYMENT: {
                this.game.clearDeploymentThisRound();
                this.game.checkForCompleteDeployment();
                Enumeration<Player> enumeration = this.game.getPlayers();
                while (enumeration.hasMoreElements()) {
                    Player player = enumeration.nextElement();
                    player.adjustStartingPosForReinforcements();
                }
                if (this.game.getRoundCount() < 1) {
                    this.changePhase(IGame.Phase.PHASE_INITIATIVE);
                    break;
                }
                this.changePhase(IGame.Phase.PHASE_TARGETING);
                break;
            }
            case PHASE_INITIATIVE: {
                this.game.addReports(this.vPhaseReport);
                this.changePhase(IGame.Phase.PHASE_INITIATIVE_REPORT);
                break;
            }
            case PHASE_INITIATIVE_REPORT: {
                if (this.game.shouldDeployThisRound()) {
                    this.changePhase(IGame.Phase.PHASE_DEPLOYMENT);
                    break;
                }
                this.changePhase(IGame.Phase.PHASE_TARGETING);
                break;
            }
            case PHASE_MOVEMENT: {
                this.doAllAssaultDrops();
                this.addMovementHeat();
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.addReport(this.resolvePilotingRolls());
                this.checkForFlamingDeath();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(IGame.Phase.PHASE_MOVEMENT_REPORT);
                    break;
                }
                this.addReport(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                this.changePhase(IGame.Phase.PHASE_OFFBOARD);
                break;
            }
            case PHASE_MOVEMENT_REPORT: {
                this.changePhase(IGame.Phase.PHASE_OFFBOARD);
                break;
            }
            case PHASE_FIRING: {
                this.resolveAllButWeaponAttacks();
                this.resolveOnlyWeaponAttacks();
                this.assignAMS();
                this.handleAttacks();
                this.resolveScheduledNukes();
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.addReport(this.resolvePilotingRolls());
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(IGame.Phase.PHASE_FIRING_REPORT);
                    break;
                }
                this.addReport(new Report(1205, 0));
                this.sendReport();
                this.game.addReports(this.vPhaseReport);
                this.changePhase(IGame.Phase.PHASE_PHYSICAL);
                break;
            }
            case PHASE_FIRING_REPORT: {
                this.changePhase(IGame.Phase.PHASE_PHYSICAL);
                break;
            }
            case PHASE_PHYSICAL: {
                this.resolvePhysicalAttacks();
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.addReport(this.resolvePilotingRolls());
                this.resolveSinkVees();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(IGame.Phase.PHASE_PHYSICAL_REPORT);
                    break;
                }
                this.addReport(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                this.changePhase(IGame.Phase.PHASE_END);
                break;
            }
            case PHASE_PHYSICAL_REPORT: {
                this.changePhase(IGame.Phase.PHASE_END);
                break;
            }
            case PHASE_TARGETING: {
                this.vPhaseReport.addElement(new Report(1035, 0));
                this.resolveOnlyWeaponAttacks();
                this.handleAttacks();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(IGame.Phase.PHASE_TARGETING_REPORT);
                } else {
                    this.vPhaseReport.addElement(new Report(1205, 0));
                    this.game.addReports(this.vPhaseReport);
                    this.sendReport();
                    this.changePhase(IGame.Phase.PHASE_MOVEMENT);
                }
                this.sendSpecialHexDisplayPackets();
                break;
            }
            case PHASE_OFFBOARD: {
                this.addReport(new Report(1100, 0));
                this.resolveAllButWeaponAttacks();
                this.resolveOnlyWeaponAttacks();
                this.handleAttacks();
                Enumeration<Player> enumeration = this.game.getPlayers();
                while (enumeration.hasMoreElements()) {
                    Player player = enumeration.nextElement();
                    int n = player.getId();
                    this.send(n, this.createArtilleryPacket(player));
                }
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.addReport(this.resolvePilotingRolls());
                this.sendSpecialHexDisplayPackets();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(IGame.Phase.PHASE_OFFBOARD_REPORT);
                    break;
                }
                this.addReport(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                this.changePhase(IGame.Phase.PHASE_FIRING);
                break;
            }
            case PHASE_OFFBOARD_REPORT: {
                this.sendSpecialHexDisplayPackets();
                this.changePhase(IGame.Phase.PHASE_FIRING);
                break;
            }
            case PHASE_TARGETING_REPORT: {
                this.changePhase(IGame.Phase.PHASE_MOVEMENT);
                break;
            }
            case PHASE_END: {
                this.resetEntityPhase(IGame.Phase.PHASE_END);
                boolean bl = this.victory();
                if (this.vPhaseReport.size() > 3 || this.vPhaseReport.elementAt((int)1).messageId != 1205) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(IGame.Phase.PHASE_END_REPORT);
                    break;
                }
                this.addReport(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                if (bl) {
                    this.changePhase(IGame.Phase.PHASE_VICTORY);
                    break;
                }
                this.changePhase(IGame.Phase.PHASE_INITIATIVE);
                break;
            }
            case PHASE_END_REPORT: {
                if (this.victory()) {
                    this.changePhase(IGame.Phase.PHASE_VICTORY);
                    break;
                }
                this.changePhase(IGame.Phase.PHASE_INITIATIVE);
                break;
            }
            case PHASE_VICTORY: {
                this.resetGame();
            }
        }
    }

    private void sendSpecialHexDisplayPackets() {
        if (this.connections == null) {
            return;
        }
        for (int i = 0; i < this.connections.size(); ++i) {
            if (this.connections.get(i) == null) continue;
            this.connections.get(i).send(this.createSpecialHexDisplayPacket(i));
        }
    }

    private void incrementAndSendGameRound() {
        this.game.incrementRoundCount();
        this.send(new Packet(260, new Integer(this.game.getRoundCount())));
    }

    private void changeToNextTurn() {
        if (!this.game.hasMoreTurns()) {
            this.endCurrentPhase();
            return;
        }
        GameTurn gameTurn = this.game.changeToNextTurn();
        Player player = this.getPlayer(gameTurn.getPlayerNum());
        if (player != null && this.game.getEntitiesOwnedBy(player) == 0) {
            this.endCurrentTurn(null);
            return;
        }
        this.send(this.createTurnIndexPacket());
        if (null != player && player.isGhost()) {
            this.sendGhostSkipMessage(player);
        } else if (null == this.game.getFirstEntity() && null != player && this.game.getPhase() != IGame.Phase.PHASE_DEPLOY_MINEFIELDS && this.game.getPhase() != IGame.Phase.PHASE_SET_ARTYAUTOHITHEXES) {
            this.sendTurnErrorSkipMessage(player);
        }
    }

    private void sendGhostSkipMessage(Player player) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Player '").append(player.getName()).append("' is disconnected.  You may skip his/her current turn with the /skip command.");
        this.sendServerChat(stringBuffer.toString());
    }

    private void sendTurnErrorSkipMessage(Player player) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Player '").append(player.getName()).append("' has no units to move.  You should skip his/her/your current turn with the /skip command. You may want to report this error.  See the MegaMek homepage (http://megamek.sf.net/) for details.");
        this.sendServerChat(stringBuffer.toString());
    }

    public void skipCurrentTurn() {
        Entity entity = this.game.getFirstEntity();
        switch (this.game.getPhase()) {
            case PHASE_DEPLOYMENT: {
                this.endCurrentTurn(null);
                break;
            }
            case PHASE_MOVEMENT: {
                if (entity != null) {
                    this.processMovement(entity, new MovePath(this.game, entity));
                }
                this.endCurrentTurn(entity);
                break;
            }
            case PHASE_FIRING: 
            case PHASE_PHYSICAL: 
            case PHASE_TARGETING: 
            case PHASE_OFFBOARD: {
                if (entity != null) {
                    this.processAttack(entity, new Vector<EntityAction>(0));
                }
                this.endCurrentTurn(entity);
                break;
            }
        }
    }

    public boolean isTurnSkippable() {
        GameTurn gameTurn = this.game.getTurn();
        if (null == gameTurn) {
            return false;
        }
        Player player = this.getPlayer(gameTurn.getPlayerNum());
        return null == player || player.isGhost() || this.game.getFirstEntity() == null;
    }

    public boolean victory() {
        Victory.Result result = this.game.getVictory().victory(this.game, this.game.getVictoryContext());
        for (Report report : result.getReports()) {
            this.addReport(report);
        }
        if (result.victory()) {
            Report report;
            boolean bl = result.isDraw();
            int n = result.getWinningPlayer();
            int n2 = result.getWinningTeam();
            if (n != -1) {
                report = new Report(7200, 0);
                report.add(this.game.getPlayer(n).getName());
                this.addReport(report);
            }
            if (n2 != 0) {
                report = new Report(7200, 0);
                report.add("Team " + n2);
                this.addReport(report);
            }
            if (bl) {
                this.game.setVictoryPlayerId(-1);
                this.game.setVictoryTeam(0);
            } else {
                this.game.setVictoryPlayerId(n);
                this.game.setVictoryTeam(n2);
            }
        } else {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(0);
            if (this.game.isForceVictory()) {
                this.cancelVictory();
            }
        }
        return result.victory();
    }

    public void applyBoardSettings() {
        this.mapSettings.replaceBoardWithRandom("[RANDOM]");
        this.mapSettings.replaceBoardWithRandom(DEFAULT_BOARD);
        IBoard[] iBoardArray = new IBoard[this.mapSettings.getMapWidth() * this.mapSettings.getMapHeight()];
        for (int i = 0; i < this.mapSettings.getMapWidth() * this.mapSettings.getMapHeight(); ++i) {
            iBoardArray[i] = new Board();
            String string = this.mapSettings.getBoardsSelectedVector().get(i);
            boolean bl = false;
            if (string.startsWith("rotate:")) {
                if (this.mapSettings.getBoardWidth() % 2 == 0) {
                    bl = true;
                }
                string = string.substring("rotate:".length());
            }
            if (string.startsWith("[GENERATED]") || this.mapSettings.getMedium() == 2) {
                iBoardArray[i] = BoardUtilities.generateRandom(this.mapSettings);
                continue;
            }
            iBoardArray[i].load(string + ".board");
            BoardUtilities.flip(iBoardArray[i], bl, bl);
        }
        IBoard iBoard = BoardUtilities.combine(this.mapSettings.getBoardWidth(), this.mapSettings.getBoardHeight(), this.mapSettings.getMapWidth(), this.mapSettings.getMapHeight(), iBoardArray, this.mapSettings.getMedium());
        if (this.game.getOptions().getOption("bridgeCF").intValue() > 0) {
            iBoard.setBridgeCF(this.game.getOptions().getOption("bridgeCF").intValue());
        }
        this.game.setBoard(iBoard);
    }

    private void rollInitiative() {
        if (this.game.getOptions().booleanOption("individual_initiative")) {
            TurnOrdered.rollInitiative(this.game.getEntitiesVector());
        } else {
            TurnOrdered.rollInitiative(this.game.getTeamsVector());
        }
        this.transmitAllPlayerUpdates();
    }

    private void determineTurnOrderIUI(IGame.Phase phase) {
        Vector<GameTurn> vector;
        Enumeration<Entity> enumeration;
        TurnVectors turnVectors = this.game.getEntities();
        while (turnVectors.hasMoreElements()) {
            enumeration = turnVectors.nextElement();
            ((TurnOrdered)((Object)enumeration)).resetOtherTurns();
            if (!((Entity)((Object)enumeration)).isSelectableThisTurn()) continue;
            ((TurnOrdered)((Object)enumeration)).incrementOtherTurns();
        }
        turnVectors = TurnOrdered.generateTurnOrder(this.game.getEntitiesVector(), this.game);
        enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return Server.this.game.isEntityStranded(entity);
            }
        });
        if (enumeration.hasMoreElements() && this.game.getPhase() == IGame.Phase.PHASE_MOVEMENT) {
            vector = new Vector(turnVectors.getNormalTurns() + turnVectors.getEvenTurns() + 1);
            vector.addElement(new GameTurn.UnloadStrandedTurn(enumeration));
        } else {
            vector = new Vector<GameTurn>(turnVectors.getNormalTurns() + turnVectors.getEvenTurns());
        }
        while (turnVectors.hasMoreElements()) {
            Entity entity = (Entity)turnVectors.nextElement();
            if (!entity.isSelectableThisTurn()) continue;
            vector.addElement(new GameTurn.SpecificEntityTurn(entity.getOwnerId(), entity.getId()));
        }
        this.game.setTurnVector(vector);
        this.game.resetTurnIndex();
        this.send(this.createTurnVectorPacket());
    }

    private void determineTurnOrder(IGame.Phase phase) {
        Vector<GameTurn> vector;
        Hashtable<Team, int[]> hashtable;
        Serializable serializable;
        if (this.game.getOptions().booleanOption("individual_initiative")) {
            this.determineTurnOrderIUI(phase);
            return;
        }
        boolean bl = this.game.getOptions().booleanOption("inf_move_even") && (this.game.getPhase() == IGame.Phase.PHASE_INITIATIVE || this.game.getPhase() == IGame.Phase.PHASE_MOVEMENT) || this.game.getOptions().booleanOption("inf_deploy_even") && this.game.getPhase() == IGame.Phase.PHASE_DEPLOYMENT;
        boolean bl2 = this.game.getOptions().booleanOption("inf_move_multi") && (this.game.getPhase() == IGame.Phase.PHASE_INITIATIVE || this.game.getPhase() == IGame.Phase.PHASE_MOVEMENT);
        boolean bl3 = this.game.getOptions().booleanOption("protos_move_even") && (this.game.getPhase() == IGame.Phase.PHASE_INITIATIVE || this.game.getPhase() == IGame.Phase.PHASE_MOVEMENT) || this.game.getOptions().booleanOption("protos_deploy_even") && this.game.getPhase() == IGame.Phase.PHASE_DEPLOYMENT;
        boolean bl4 = this.game.getOptions().booleanOption("protos_move_multi");
        boolean bl5 = !bl4;
        int n = 0;
        if (bl) {
            ++n;
        }
        if (bl3) {
            n += 2;
        }
        Enumeration<TurnOrdered> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            ((TurnOrdered)serializable).resetEvenTurns();
            ((TurnOrdered)serializable).resetMultiTurns();
            ((TurnOrdered)serializable).resetOtherTurns();
            if (!bl5) continue;
            hashtable = this.game.getSelectedEntities(new EntitySelector((Player)serializable){
                private final int ownerId;
                final /* synthetic */ Player val$player;
                {
                    this.val$player = player;
                    this.ownerId = this.val$player.getId();
                }

                public boolean accept(Entity entity) {
                    return entity instanceof Protomech && this.ownerId == entity.getOwnerId() && entity.isSelectableThisTurn();
                }
            });
            HashSet<Integer> hashSet = new HashSet<Integer>();
            int n2 = 0;
            while (hashtable.hasMoreElements()) {
                Entity entity = (Entity)hashtable.nextElement();
                ++n2;
                hashSet.add(new Integer(entity.getUnitNumber()));
            }
            int n3 = (int)Math.ceil((double)n2 / 5.0);
            if (!bl3) {
                n3 = hashSet.size();
            }
            for (int i = 0; i < n3; ++i) {
                if (bl3) {
                    ((TurnOrdered)serializable).incrementEvenTurns();
                    continue;
                }
                ((TurnOrdered)serializable).incrementOtherTurns();
            }
        }
        enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            serializable = (Entity)enumeration.nextElement();
            if (!((Entity)serializable).isSelectableThisTurn()) continue;
            hashtable = ((Entity)serializable).getOwner();
            if (serializable instanceof Infantry) {
                if (bl) {
                    ((TurnOrdered)((Object)hashtable)).incrementEvenTurns();
                    continue;
                }
                if (bl2) {
                    ((TurnOrdered)((Object)hashtable)).incrementMultiTurns();
                    continue;
                }
                ((TurnOrdered)((Object)hashtable)).incrementOtherTurns();
                continue;
            }
            if (serializable instanceof Protomech) {
                if (bl5) continue;
                if (bl3) {
                    ((TurnOrdered)((Object)hashtable)).incrementEvenTurns();
                    continue;
                }
                if (bl4) {
                    ((TurnOrdered)((Object)hashtable)).incrementMultiTurns();
                    continue;
                }
                ((TurnOrdered)((Object)hashtable)).incrementOtherTurns();
                continue;
            }
            ((TurnOrdered)((Object)hashtable)).incrementOtherTurns();
        }
        int n4 = this.game.getNoOfTeams();
        serializable = new Hashtable(n4);
        hashtable = new Hashtable<Team, int[]>(n4);
        int n5 = 0;
        TurnVectors turnVectors = this.game.getTeams();
        while (turnVectors.hasMoreElements()) {
            Team team = turnVectors.nextElement();
            ((Hashtable)serializable).put(team, team.determineTeamOrder(this.game));
            int[] nArray = new int[]{0, 0};
            hashtable.put(team, nArray);
            if (team.getNormalTurns(this.game) <= 0) continue;
            ++n5;
        }
        turnVectors = TurnOrdered.generateTurnOrder(this.game.getTeamsVector(), this.game);
        Enumeration<Entity> enumeration2 = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return Server.this.game.isEntityStranded(entity);
            }
        });
        if (enumeration2.hasMoreElements() && this.game.getPhase() == IGame.Phase.PHASE_MOVEMENT) {
            vector = new Vector(turnVectors.getNormalTurns() + turnVectors.getEvenTurns() + 1);
            vector.addElement(new GameTurn.UnloadStrandedTurn(enumeration2));
        } else {
            vector = new Vector<GameTurn>(turnVectors.getNormalTurns() + turnVectors.getEvenTurns());
        }
        Team team = null;
        int n6 = turnVectors.getMin();
        int n7 = 0;
        while (turnVectors.hasMoreElements()) {
            Player player;
            Team team2 = (Team)turnVectors.nextElement();
            TurnVectors turnVectors2 = (TurnVectors)((Hashtable)serializable).get(team2);
            int[] nArray = (int[])hashtable.get(team2);
            float f = team2.getEvenTurns();
            int n8 = 0;
            if (1 == n5) {
                n8 = (int)((float)n8 + f);
            } else if (team == null) {
                nArray[0] = nArray[0] + 1;
                n8 = (int)((float)n8 + f / (float)n6);
            } else if (!team2.equals(team)) {
                nArray[0] = nArray[0] + 1;
                n8 = (int)((double)n8 + (Math.ceil((double)((float)nArray[0] * (f % (float)n6) / (float)n6) - 0.5) - (double)nArray[1]));
                nArray[1] = nArray[1] + n8;
                n8 = (int)((float)n8 + f / (float)n6);
            }
            team = team2;
            if (turnVectors2.hasMoreElements()) {
                player = (Player)turnVectors2.nextElement();
                GameTurn gameTurn = null;
                gameTurn = n7 >= turnVectors.getNormalTurns() ? new GameTurn.EntityClassTurn(player.getId(), n) : (bl || bl3 ? new GameTurn.EntityClassTurn(player.getId(), ~n) : new GameTurn(player.getId()));
                vector.addElement(gameTurn);
            }
            while (n8 > 0 && turnVectors2.hasMoreEvenElements()) {
                player = (Player)turnVectors2.nextEvenElement();
                vector.addElement(new GameTurn.EntityClassTurn(player.getId(), n));
                --n8;
            }
            ++n7;
        }
        this.game.setTurnVector(vector);
        this.game.resetTurnIndex();
        this.send(this.createTurnVectorPacket());
    }

    private void writeInitiativeReport(boolean bl) {
        Report report;
        boolean bl2 = false;
        if (!bl) {
            report = new Report(1210);
            report.type = 0;
            if (this.game.getLastPhase() == IGame.Phase.PHASE_DEPLOYMENT || this.game.isDeploymentComplete() || !this.game.shouldDeployThisRound()) {
                report.messageId = 1000;
                report.add(this.game.getRoundCount());
            } else {
                bl2 = true;
                if (this.game.getRoundCount() == 0) {
                    report.messageId = 1005;
                } else {
                    report.messageId = 1010;
                    report.add(this.game.getRoundCount());
                }
            }
            this.addReport(report);
            this.addReport(new Report(1200, 0));
        } else {
            this.addReport(new Report(1210, 0));
        }
        if (this.game.getOptions().booleanOption("individual_initiative")) {
            report = new Report(1040, 0);
            this.addReport(report);
            Enumeration<GameTurn> enumeration = this.game.getTurns();
            while (enumeration.hasMoreElements()) {
                TurnOrdered turnOrdered;
                GameTurn gameTurn = enumeration.nextElement();
                if (gameTurn instanceof GameTurn.SpecificEntityTurn) {
                    turnOrdered = this.game.getEntity(((GameTurn.SpecificEntityTurn)gameTurn).getEntityNum());
                    report = new Report(1045);
                    report.subject = ((Entity)turnOrdered).getId();
                    report.addDesc((Entity)turnOrdered);
                    report.add(turnOrdered.getInitiative().toString());
                    int n = this.game.getTeamForPlayer(((Entity)turnOrdered).getOwner()).getTotalInitBonus();
                    String string = "";
                    string = n >= 0 ? string + "+" + n : string + n;
                    report.add(string);
                    this.addReport(report);
                    continue;
                }
                turnOrdered = this.getPlayer(gameTurn.getPlayerNum());
                if (null == turnOrdered) continue;
                report = new Report(1050, 0);
                report.add(((Player)turnOrdered).getName());
                this.addReport(report);
            }
        } else {
            Object object;
            Enumeration<Team> enumeration = this.game.getTeams();
            while (enumeration.hasMoreElements()) {
                Object object2;
                object = enumeration.nextElement();
                if (((Team)object).getSize() == 1) {
                    Player player = ((Team)object).getPlayers().nextElement();
                    report = new Report(1015, 0);
                    report.add(player.getName());
                    report.add(((TurnOrdered)object).getInitiative().toString());
                    int n = ((Team)object).getTotalInitBonus();
                    object2 = "";
                    object2 = n >= 0 ? (String)object2 + "+" + n : (String)object2 + n;
                    report.add((String)object2);
                    this.addReport(report);
                    continue;
                }
                report = new Report(1015, 0);
                report.add(Player.teamNames[((Team)object).getId()]);
                report.add(((TurnOrdered)object).getInitiative().toString());
                int n = ((Team)object).getTotalInitBonus();
                String string = "";
                string = n >= 0 ? string + "+" + n : string + n;
                report.add(string);
                this.addReport(report);
                object2 = ((Team)object).getPlayers();
                while (object2.hasMoreElements()) {
                    Player player = (Player)object2.nextElement();
                    report = new Report(1016, 0);
                    report.indent();
                    report.add(player.getName());
                    report.add(player.getInitiative().toString());
                    this.addReport(report);
                }
            }
            if (!this.doBlind()) {
                report = new Report(1020, 0);
                boolean bl3 = false;
                object = this.game.getTurns();
                while (object.hasMoreElements()) {
                    GameTurn gameTurn = (GameTurn)object.nextElement();
                    Player player = this.getPlayer(gameTurn.getPlayerNum());
                    if (null == player) continue;
                    report.add(player.getName());
                    if (player.getEvenTurns() <= 0) continue;
                    bl3 = true;
                }
                report.newlines = 2;
                this.addReport(report);
                if (bl3) {
                    report = new Report(1021, 0);
                    if ((this.game.getOptions().booleanOption("inf_deploy_even") || this.game.getOptions().booleanOption("protos_deploy_even")) && this.game.getLastPhase() != IGame.Phase.PHASE_END_REPORT) {
                        report.choose(true);
                    } else {
                        report.choose(false);
                    }
                    report.indent();
                    report.newlines = 2;
                    this.addReport(report);
                }
            }
        }
        if (!bl) {
            report = new Report(1025, 0);
            report.add(this.game.getStringWindDirection());
            if (this.game.getWindStrength() != -1) {
                Report report2 = new Report(1030, 0);
                report2.add(this.game.getStringWindStrength());
                report.newlines = 0;
                this.addReport(report);
                this.addReport(report2);
            } else {
                this.addReport(report);
            }
            if (bl2) {
                this.addNewLines();
            }
        }
    }

    private void setIneligible(IGame.Phase phase) {
        Vector<Entity> vector = new Vector<Entity>();
        boolean bl = false;
        for (Entity entity : this.game.getEntitiesVector()) {
            if (entity.isEligibleFor(phase)) {
                bl = true;
                continue;
            }
            vector.addElement(entity);
        }
        for (Entity entity : vector) {
            if (bl && entity.canAssist(phase)) continue;
            entity.setDone(true);
        }
    }

    private void loadUnit(Entity entity, Entity entity2) {
        if (!entity2.isDone()) {
            this.game.removeTurnFor(entity2);
            this.send(this.createTurnVectorPacket());
        }
        entity.load(entity2);
        entity2.setTransportId(entity.getId());
        entity2.setPosition(null);
        this.entityUpdate(entity2.getId());
    }

    private boolean unloadUnit(Entity entity, Targetable targetable, Coords coords, int n, int n2) {
        Entity entity2 = null;
        if (!(targetable instanceof Entity)) {
            return false;
        }
        entity2 = (Entity)targetable;
        if (!entity.unload(entity2)) {
            return false;
        }
        entity2.setTransportId(-1);
        entity2.setPosition(coords);
        if (coords != null) {
            entity2.setDeployed(true);
        }
        entity2.setFacing(n);
        entity2.setSecondaryFacing(n);
        IHex iHex = this.game.getBoard().getHex(coords);
        boolean bl = iHex.containsTerrain(5);
        if (entity.getMovementMode() == 6) {
            if (entity2.getMovementMode() == 6) {
                entity2.setElevation(n2);
            } else if (this.game.getBoard().getBuildingAt(coords) != null) {
                entity2.setElevation(iHex.terrainLevel(12));
            } else {
                while (n2 >= -iHex.depth()) {
                    if (entity2.isElevationValid(n2, iHex)) {
                        entity2.setElevation(n2);
                        break;
                    }
                    --n2;
                    entity2.moved = 3;
                }
                if (!entity2.isElevationValid(n2, iHex)) {
                    return false;
                }
            }
        } else if (this.game.getBoard().getBuildingAt(coords) != null) {
            entity2.setElevation(n2);
        } else if (iHex.terrainLevel(4) > 0) {
            if (entity2.getMovementMode() == 5 || entity2.getMovementMode() == 15 || entity2.getMovementMode() == 8 || entity2.getMovementMode() == 7 || entity2.getMovementMode() == 9 || entity2.getMovementMode() == 18 || iHex.containsTerrain(20) || bl) {
                entity2.setElevation(0);
            }
        } else {
            entity2.setElevation(iHex.floor() - iHex.surface());
        }
        this.addReport(this.doSetLocationsExposure(entity2, iHex, false, entity2.getElevation()));
        this.entityUpdate(entity2.getId());
        return true;
    }

    private void addAffectedBldg(Building building, boolean bl) {
        if (bl) {
            System.err.print("Removing building from a list of " + this.affectedBldgs.size() + '\n');
            this.affectedBldgs.remove(building);
            System.err.print("... now list of " + this.affectedBldgs.size() + '\n');
        } else {
            this.affectedBldgs.put(building, Boolean.FALSE);
        }
    }

    private void applyAffectedBldgs() {
        Vector<Building> vector = new Vector<Building>();
        boolean bl = false;
        Enumeration<Building> enumeration = this.affectedBldgs.keys();
        while (enumeration.hasMoreElements()) {
            Building building = enumeration.nextElement();
            Enumeration<Coords> enumeration2 = building.getCoords();
            while (enumeration2.hasMoreElements()) {
                Coords coords = enumeration2.nextElement();
                Enumeration<Entity> enumeration3 = this.game.getEntities(coords);
                while (enumeration3.hasMoreElements()) {
                    Entity entity = enumeration3.nextElement();
                    if (!(entity instanceof Infantry)) continue;
                    if (entity.isDoomed() || entity.isDestroyed()) {
                        if (!entity.isDone()) {
                            this.game.removeTurnFor(entity);
                            bl = true;
                        }
                        entity.setDestroyed(true);
                        this.game.moveToGraveyard(entity.getId());
                        this.send(this.createRemoveEntityPacket(entity.getId()));
                        continue;
                    }
                    this.entityUpdate(entity.getId());
                }
            }
            vector.addElement(building);
        }
        if (bl) {
            this.send(this.createTurnVectorPacket());
        }
        if (!vector.isEmpty()) {
            this.sendChangedCFBuildings(vector);
            this.affectedBldgs.clear();
        }
    }

    private void receiveMovement(Packet packet, int n) {
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        MovePath movePath = (MovePath)packet.getObject(1);
        if (this.game.getPhase() != IGame.Phase.PHASE_MOVEMENT) {
            System.err.println("error: server got movement packet in wrong phase");
            return;
        }
        if (!this.game.getTurn().isValid(n, entity, this.game)) {
            System.err.println("error: server got invalid movement packet");
            return;
        }
        this.processMovement(entity, movePath);
        this.applyAffectedBldgs();
        if (this.doBlind()) {
            this.updateVisibilityIndicator();
        }
        this.endCurrentTurn(entity);
    }

    private boolean processSkid(Entity entity, Coords coords, int n, int n2, int n3, MoveStep moveStep) {
        int n4;
        int n5;
        Object object;
        Report report;
        Coords coords2;
        Coords coords3 = coords2 = coords;
        Object object2 = this.game.getBoard().getHex(coords);
        int n6 = 0;
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        while (!entity.isDoomed() && n3 > 0) {
            Object object3;
            Serializable serializable;
            int n7;
            int n8;
            Building building;
            boolean bl;
            int n9;
            coords2 = coords3.translated(n2);
            if (!this.game.getBoard().contains(coords2)) {
                if (this.game.getOptions().booleanOption("push_off_board")) {
                    this.game.removeEntity(entity.getId(), 272);
                    this.send(this.createRemoveEntityPacket(entity.getId(), 272));
                    report = new Report(2030, 0);
                    report.addDesc(entity);
                    this.addReport(report);
                    for (Entity entity2 : entity.getLoadedUnits()) {
                        this.game.removeEntity(entity2.getId(), 272);
                        this.send(this.createRemoveEntityPacket(entity2.getId(), 272));
                    }
                    object = this.game.getEntity(entity.getSwarmAttackerId());
                    if (object != null) {
                        if (!((Entity)object).isDone()) {
                            ((Entity)object).setDone(true);
                            this.game.removeTurnFor((Entity)object);
                            this.send(this.createTurnVectorPacket());
                        }
                        this.game.removeEntity(((Entity)object).getId(), 272);
                        this.send(this.createRemoveEntityPacket(((Entity)object).getId(), 272));
                    }
                    return true;
                }
                report = new Report(2035);
                report.subject = entity.getId();
                report.indent();
                this.addReport(report);
                break;
            }
            object = this.game.getBoard().getHex(coords2);
            n3 -= object.movementCost(entity.getMovementMode()) + 1;
            n5 = entity.getElevation() + object2.getElevation();
            n4 = object.floor();
            if (entity.getMovementMode() == 6) {
                n4 = Math.max(n4, n5);
            } else {
                if (object.containsTerrain(12)) {
                    n4 = Math.min(n5, object.getElevation() + object.terrainLevel(12));
                }
                if (object.containsTerrain(14)) {
                    n9 = (n2 + 3) % 6;
                    n9 = 1 << n9;
                    if ((object.getTerrain(14).getExits() & n9) == n9) {
                        n4 = Math.min(n5, Math.max(n4, object.getElevation() + object.terrainLevel(16)));
                    }
                }
                if (n4 <= object.surface() && n5 >= object2.surface()) {
                    if (entity instanceof Tank && (entity.getMovementMode() == 5 || entity.getMovementMode() == 15)) {
                        if (object.containsTerrain(4)) {
                            n4 = object.surface();
                        }
                    } else if (object.containsTerrain(20)) {
                        n4 = object.surface();
                    }
                }
            }
            n9 = n4 - object.surface();
            boolean bl2 = bl = n5 < n4;
            if (entity.getMovementMode() == 6 && (n9 == 0 || n9 == 1 && (object.containsTerrain(1) || object.containsTerrain(23)))) {
                bl = true;
            }
            if (object.containsTerrain(12) && (building = this.game.getBoard().getBuildingAt(coords2)).getType() == 5) {
                bl = true;
            }
            if (entity.getMovementMode() == 15) {
                if (n9 == 0 && !object.containsTerrain(1) && !object.containsTerrain(23)) {
                    n9 = 1;
                    bl = false;
                } else if (n9 == 1 && (object.containsTerrain(1) || object.containsTerrain(23))) {
                    n9 = 2;
                    bl = false;
                }
            }
            if (bl) {
                report = object.containsTerrain(12) ? ((building = this.game.getBoard().getBuildingAt(coords2)).getType() == 5 ? new Report(2047) : new Report(2045)) : new Report(2045);
                report.subject = entity.getId();
                report.indent();
                report.add(coords2.getBoardNum(), true);
                this.addReport(report);
                if (entity.getMovementMode() == 15 || entity.getMovementMode() == 6) {
                    int n10 = moveStep.getFacing() - n2 + 6;
                    n8 = 0;
                    switch (n10 %= 6) {
                        case 0: {
                            n8 = 0;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n8 = 2;
                            break;
                        }
                        case 3: {
                            n8 = 1;
                            break;
                        }
                        case 4: 
                        case 5: {
                            n8 = 3;
                        }
                    }
                    n = n9;
                    this.addReport(this.crashVTOLorWiGE((VTOL)entity, true, n3, coords3, n, n8));
                    if (object.containsTerrain(4) && !object.containsTerrain(20) || object.containsTerrain(1) || object.containsTerrain(23)) {
                        this.addReport(this.destroyEntity(entity, "could not land in crash site"));
                    } else if (n < object.terrainLevel(12)) {
                        Building building2 = this.game.getBoard().getBuildingAt(coords2);
                        if (building2.getType() == 5) {
                            this.addReport(this.destroyEntity(entity, "crashed into a wall"));
                            break;
                        }
                        this.addReport(this.destroyEntity(entity, "crashed into building"));
                    } else {
                        entity.setPosition(coords2);
                        entity.setElevation(0);
                        this.addReport(this.doEntityDisplacementMinefieldCheck(entity, coords3, coords2));
                    }
                    coords3 = coords2;
                    break;
                }
                for (int i = ((int)entity.getWeight() + 19) / 20; i > 0; i -= 5) {
                    this.addReport(this.damageEntity(entity, entity.rollHitLocation(0, 0), Math.min(5, i)));
                }
                break;
            }
            if (n5 > n4 + entity.getMaxElevationChange()) {
                if (entity.getMovementMode() == 15 && entity.getRunMP() - 2 >= entity.mpUsed) {
                    entity.mpUsed += 2;
                    n4 = n5;
                } else {
                    this.addReport(this.doEntityFallsInto(entity, coords3, coords2, entity.getBasePilotingRoll()));
                    this.addReport(this.doEntityDisplacementMinefieldCheck(entity, coords3, coords2));
                    break;
                }
            }
            building = null;
            if (n9 < object.terrainLevel(12)) {
                building = this.game.getBoard().getBuildingAt(coords2);
            }
            n8 = 0;
            boolean bl3 = false;
            Enumeration<Entity> enumeration = this.game.getEntities(coords2);
            if (enumeration.hasMoreElements()) {
                n7 = 0;
                while (enumeration.hasMoreElements()) {
                    serializable = enumeration.nextElement();
                    if (((Entity)serializable).getElevation() > n9 + entity.getHeight() || ((Entity)serializable).absHeight() < n9) continue;
                    if (!((Entity)serializable).isDone()) {
                        if (serializable instanceof Infantry) {
                            report = new Report(2420);
                            report.subject = ((Entity)serializable).getId();
                            report.addDesc((Entity)serializable);
                            this.addReport(report);
                            continue;
                        }
                        if (serializable instanceof Protomech) {
                            if (serializable != Compute.stackingViolation(this.game, entity, coords2, null)) {
                                report = new Report(2420);
                                report.subject = ((Entity)serializable).getId();
                                report.addDesc((Entity)serializable);
                                this.addReport(report);
                                continue;
                            }
                        } else {
                            object3 = ((Entity)serializable).getBasePilotingRoll();
                            ((TargetRoll)object3).addModifier(0, "avoiding collision");
                            int n11 = Compute.d6(2);
                            report = new Report(2425);
                            report.subject = ((Entity)serializable).getId();
                            report.addDesc((Entity)serializable);
                            report.add(((TargetRoll)object3).getValue());
                            report.add(((TargetRoll)object3).getDesc());
                            report.add(n11);
                            this.addReport(report);
                            if (n11 >= ((TargetRoll)object3).getValue()) {
                                this.game.removeTurnFor((Entity)serializable);
                                arrayList.add(serializable);
                                continue;
                            }
                        }
                    }
                    if (serializable instanceof Mech || serializable instanceof Tank) {
                        object3 = new ChargeAttackAction(entity.getId(), ((Entity)serializable).getTargetType(), ((Entity)serializable).getTargetId(), ((Entity)serializable).getPosition());
                        ToHitData toHitData = ((ChargeAttackAction)object3).toHit(this.game, true);
                        int n12 = Compute.d6(2);
                        report = new Report(2050);
                        report.subject = entity.getId();
                        report.indent();
                        report.add(((Entity)serializable).getShortName(), true);
                        report.add(coords2.getBoardNum(), true);
                        report.newlines = 0;
                        this.addReport(report);
                        if (toHitData.getValue() == Integer.MAX_VALUE) {
                            n12 = -12;
                            report = new Report(2055);
                            report.subject = entity.getId();
                            report.add(toHitData.getDesc());
                            report.newlines = 0;
                            this.addReport(report);
                        } else if (toHitData.getValue() == Integer.MIN_VALUE) {
                            report = new Report(2060);
                            report.subject = entity.getId();
                            report.add(toHitData.getDesc());
                            report.newlines = 0;
                            this.addReport(report);
                            n12 = Integer.MAX_VALUE;
                        } else {
                            report = new Report(2065);
                            report.subject = entity.getId();
                            report.add(toHitData.getValue());
                            report.add(n12);
                            report.newlines = 0;
                            this.addReport(report);
                        }
                        if (n12 < toHitData.getValue()) {
                            report = new Report(2070);
                            report.subject = entity.getId();
                            this.addReport(report);
                        } else {
                            this.resolveChargeDamage(entity, (Entity)serializable, toHitData, n2);
                            if (enumeration.hasMoreElements()) {
                                entity.setPosition(coords3);
                            }
                            n8 = 1;
                            n7 = 1;
                            if (!(((Entity)serializable).isDoomed() || ((Entity)serializable).isDestroyed() || this.game.isOutOfGame((Entity)serializable))) {
                                bl3 = true;
                            }
                        }
                        if (!((Entity)serializable).isDone()) {
                            this.addReport(this.resolvePilotingRolls((Entity)serializable));
                            this.game.resetPSRs((Entity)serializable);
                            ((Entity)serializable).applyDamage();
                            this.addNewLines();
                        }
                    } else if (serializable instanceof Infantry && building != null) {
                        report = new Report(2075);
                        report.subject = entity.getId();
                        report.indent();
                        report.add(((Entity)serializable).getShortName(), true);
                        report.add(coords2.getBoardNum(), true);
                        report.newlines = 0;
                        this.addReport(report);
                        object3 = ((Entity)serializable).rollHitLocation(0, Compute.targetSideTable(entity, (Targetable)serializable));
                        ((HitData)object3).setGeneralDamageType(-2);
                        this.addReport(this.damageEntity((Entity)serializable, (HitData)object3, Math.round(entity.getWeight() / 5.0f)));
                        this.addNewLines();
                    }
                    if (((Entity)serializable).isDoomed()) {
                        if (!((Entity)serializable).isDone()) {
                            this.game.removeTurnFor((Entity)serializable);
                            this.send(this.createTurnVectorPacket());
                        }
                        ((Entity)serializable).setDestroyed(true);
                        this.game.moveToGraveyard(((Entity)serializable).getId());
                        this.send(this.createRemoveEntityPacket(((Entity)serializable).getId()));
                    }
                    if (this.game.isOutOfGame((Entity)serializable)) continue;
                    this.entityUpdate(((Entity)serializable).getId());
                }
                if (n7 != 0) {
                    entity.setPosition(coords2);
                }
                serializable = arrayList.iterator();
                while (serializable.hasNext()) {
                    object3 = (Entity)serializable.next();
                    GameTurn.SpecificEntityTurn specificEntityTurn = new GameTurn.SpecificEntityTurn(((Entity)object3).getOwner().getId(), ((Entity)object3).getId());
                    this.game.insertNextTurn(specificEntityTurn);
                    this.send(this.createTurnVectorPacket());
                }
            }
            if (building != null) {
                report = new Report(2080);
                report.subject = entity.getId();
                report.indent();
                report.add(building.getName());
                report.add(coords2.getBoardNum(), true);
                this.addReport(report);
                n7 = ChargeAttackAction.getDamageFor(entity);
                if (n8 == 0) {
                    serializable = this.damageBuilding(building, n7);
                    object3 = ((Vector)serializable).iterator();
                    while (object3.hasNext()) {
                        Report report2 = (Report)object3.next();
                        report2.subject = entity.getId();
                    }
                    this.addReport((Vector<Report>)serializable);
                    int n13 = ChargeAttackAction.getDamageTakenBy(entity, building);
                    HitData hitData = entity.rollHitLocation(0, entity.sideTable(coords2));
                    hitData.setGeneralDamageType(-2);
                    this.addReport(this.damageEntity(entity, hitData, n13));
                    this.addNewLines();
                    entity.setPosition(coords2);
                    entity.setElevation(n9);
                    this.addReport(this.doEntityDisplacementMinefieldCheck(entity, coords3, coords2));
                    coords3 = coords2;
                }
                this.damageInfantryIn(building, n7);
                if (building.getCurrentCF() > 0) {
                    bl3 = true;
                    this.addAffectedBldg(building, false);
                } else {
                    this.checkForCollapse(building, this.game.getPositionMap());
                }
            }
            if (bl3) break;
            entity.setPosition(coords2);
            entity.setElevation(n9);
            this.addReport(this.doEntityDisplacementMinefieldCheck(entity, coords3, coords2));
            ++n6;
            Building building3 = this.game.getBoard().getBuildingAt(coords2);
            if (building3 != null && this.checkForCollapse(building3, this.game.getPositionMap())) break;
            if ((entity.isHexProhibited((IHex)object2) || entity.isHexProhibited((IHex)object)) && !Compute.canMoveOnPavement(this.game, coords3, coords2, moveStep.getParentUpToThisStep())) {
                report = new Report(2040);
                report.subject = entity.getId();
                report.indent();
                report.add(coords2.getBoardNum(), true);
                this.addReport(report);
                if (object.terrainLevel(4) > 0 && entity instanceof Tank && entity.getMovementMode() != 5 && entity.getMovementMode() != 15) {
                    this.addReport(this.destroyEntity(entity, "skidded into a watery grave", false, true));
                }
                for (int i = ((int)entity.getWeight() + 4) / 5; i > 0; i -= 5) {
                    this.addReport(this.damageEntity(entity, entity.rollHitLocation(0, 0), Math.min(5, i)));
                }
                if (!(entity instanceof Tank)) break;
                ((Tank)entity).immobilize();
                break;
            }
            if (object.terrainLevel(4) > 0 && entity.getMovementMode() != 5 && entity.getMovementMode() != 15) break;
            if (object.terrainLevel(24) == 1 && n9 == 0) {
                int n14 = Compute.d6(1);
                report = new Report(2395);
                report.addDesc(entity);
                report.add(n14);
                report.subject = entity.getId();
                this.addReport(report);
                if (n14 == 6) {
                    object.removeTerrain(24);
                    object.addTerrain(Terrains.getTerrainFactory().createTerrain(24, 2));
                    this.sendChangedHex(coords3);
                    Enumeration<Entity> enumeration2 = this.game.getEntities(coords3);
                    while (enumeration2.hasMoreElements()) {
                        Entity entity3 = enumeration2.nextElement();
                        if (entity3 == entity) continue;
                        this.doMagmaDamage(entity3, false);
                    }
                }
            }
            if (object.terrainLevel(24) == 2 && n9 == 0) {
                this.doMagmaDamage(entity, false);
            }
            if (((TargetRoll)(serializable = entity.checkSwampMove(moveStep, (IHex)object, coords3, coords2, Compute.canMoveOnPavement(this.game, coords3, coords2, moveStep.getParentUpToThisStep())))).getValue() != -2147483647 && 0 < this.doSkillCheckWhileMoving(entity, coords3, coords2, (PilotingRollData)serializable, false)) {
                entity.setStuck(true);
                report = new Report(2081);
                report.subject = entity.getId();
                report.add(entity.getDisplayName(), true);
                this.addReport(report);
                Entity entity4 = Compute.stackingViolation(this.game, entity.getId(), coords3);
                if (entity4 == null) break;
                Coords coords4 = Compute.getValidDisplacement(this.game, entity.getId(), coords3, n2);
                this.addReport(this.doEntityDisplacement(entity4, coords3, coords4, new PilotingRollData(entity4.getId(), 0, "domino effect")));
                this.entityUpdate(entity4.getId());
                break;
            }
            coords3 = coords2;
            object2 = object;
            report = new Report(2085);
            report.subject = entity.getId();
            report.indent();
            report.add(coords3.getBoardNum(), true);
            this.addReport(report);
        }
        coords3 = entity.getPosition();
        object = Compute.stackingViolation(this.game, entity.getId(), coords3);
        while (object != null) {
            coords2 = Compute.getValidDisplacement(this.game, ((Entity)object).getId(), ((Entity)object).getPosition(), n2);
            if (null == coords2) {
                System.err.println("The skid of " + entity.getShortName() + " should displace " + ((Entity)object).getShortName() + " in hex " + coords3.getBoardNum() + " but there is nowhere to go.");
                break;
            }
            report = new Report(1210, 0);
            report.indent();
            report.newlines = 0;
            this.addReport(report);
            this.addReport(this.doEntityDisplacement((Entity)object, coords3, coords2, null));
            this.addReport(this.doEntityDisplacementMinefieldCheck(entity, coords3, coords2));
            object = Compute.stackingViolation(this.game, entity.getId(), coords3);
        }
        if (entity instanceof Mech) {
            report = new Report(2090);
            report.subject = entity.getId();
            report.indent();
            report.addDesc(entity);
            report.add(n5);
            this.addReport(report);
            for (n5 = n6 * (int)Math.ceil((double)Math.round((double)entity.getWeight() / 10.0) / 2.0); n5 > 0; n5 -= n4) {
                n4 = Math.min(5, n5);
                HitData hitData = entity.rollHitLocation(0, 0);
                hitData.setGeneralDamageType(-2);
                this.addReport(this.damageEntity(entity, hitData, n4));
            }
            this.addNewLines();
        }
        if (entity.isDoomed()) {
            entity.setDestroyed(true);
            this.game.moveToGraveyard(entity.getId());
            this.send(this.createRemoveEntityPacket(entity.getId()));
            return true;
        }
        report = new Report(2095);
        report.subject = entity.getId();
        report.indent();
        this.addReport(report);
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    private void processMovement(Entity entity, MovePath movePath) {
        int n;
        Object object;
        Report report;
        PilotingRollData pilotingRollData;
        Object object2;
        int n2;
        boolean bl;
        Object object3;
        Object object4;
        boolean bl2 = false;
        if (movePath.contains(10)) {
            Report report2 = new Report(2005, 0);
            report2.addDesc(entity);
            this.addReport(report2);
            Coords coords = entity.getPosition();
            int n3 = coords.x == 0 ? 3 : (coords.y == 0 ? 1 : (coords.x == this.game.getBoard().getWidth() ? 2 : 0));
            Vector<Entity> vector = entity.getLoadedUnits();
            if (!vector.isEmpty()) {
                for (Serializable serializable : vector) {
                    report2 = new Report(2010, 0);
                    report2.indent();
                    report2.addDesc((Entity)serializable);
                    this.addReport(report2);
                    ((Entity)serializable).setRetreatedDirection(n3);
                    this.game.removeEntity(((Entity)serializable).getId(), 256);
                    this.send(this.createRemoveEntityPacket(((Entity)serializable).getId(), 256));
                }
            }
            for (Serializable serializable : entity.getPickedUpMechWarriors()) {
                Entity entity2 = this.game.getEntity((Integer)serializable);
                int n4 = 256;
                report2 = new Report(2010);
                if (entity2.isCaptured()) {
                    report2 = new Report(2015);
                    n4 = 288;
                } else {
                    entity2.setRetreatedDirection(n3);
                }
                this.game.removeEntity(entity2.getId(), n4);
                this.send(this.createRemoveEntityPacket(entity2.getId(), n4));
                report2.addDesc(entity2);
                report2.indent();
                this.addReport(report2);
            }
            int n5 = entity.getSwarmAttackerId();
            if (-1 != n5) {
                Serializable serializable;
                serializable = this.game.getEntity(n5);
                if (!((Entity)serializable).isDone()) {
                    this.game.removeTurnFor((Entity)serializable);
                    this.send(this.createTurnVectorPacket());
                }
                ((Entity)serializable).setSwarmTargetId(-1);
                entity.setSwarmAttackerId(-1);
                report2 = new Report(2015, 0);
                report2.indent();
                report2.addDesc((Entity)serializable);
                this.addReport(report2);
                this.game.removeEntity(n5, 288);
                this.send(this.createRemoveEntityPacket(n5, 288));
            }
            entity.setRetreatedDirection(n3);
            this.game.removeEntity(entity.getId(), 256);
            this.send(this.createRemoveEntityPacket(entity.getId(), 256));
            return;
        }
        if (movePath.contains(18)) {
            if (entity instanceof Mech) {
                Report report3 = new Report(2020);
                report3.subject = entity.getId();
                report3.add(entity.getCrew().getName());
                report3.addDesc(entity);
                this.addReport(report3);
            } else if (entity instanceof Tank && !entity.isCarcass()) {
                Report report4 = new Report(2025);
                report4.subject = entity.getId();
                report4.addDesc(entity);
                this.addReport(report4);
            }
            this.addReport(this.ejectEntity(entity, false));
            return;
        }
        Coords coords = entity.getPosition();
        Coords coords2 = entity.getPosition();
        int n6 = entity.getFacing();
        int n7 = entity.getElevation();
        int n8 = entity.delta_distance;
        int n9 = entity.mpUsed;
        int n10 = entity.moved;
        int n11 = entity.moved;
        boolean bl3 = false;
        boolean bl4 = false;
        int n12 = n6;
        Object object5 = null;
        boolean bl5 = entity instanceof Infantry;
        Enumeration<Entity> enumeration = null;
        int n13 = -1;
        movePath.compile(this.game, entity);
        if (movePath.contains(19)) {
            object4 = new ClearMinefieldAction(entity.getId());
            entity.setClearingMinefield(true);
            this.game.addAction((EntityAction)object4);
        }
        n11 = movePath.getLastStepMovementType();
        if (this.game.getBoard().getHex(entity.getPosition()).terrainLevel(24) == 2 && entity.getElevation() == 0) {
            this.doMagmaDamage(entity, false);
        }
        boolean bl6 = true;
        boolean bl7 = false;
        object4 = null;
        Vector<UnitLocation> vector = new Vector<UnitLocation>();
        Enumeration<MoveStep> enumeration2 = movePath.getSteps();
        while (enumeration2.hasMoreElements()) {
            Targetable targetable;
            int n14;
            int n15;
            Object object62;
            Serializable serializable;
            object3 = enumeration2.nextElement();
            boolean bl8 = entity.isProne();
            bl = ((MoveStep)object3).isPavementStep();
            n2 = 0;
            if (((MoveStep)object3).getMovementType() == -1 || entity.isDestroyed() || entity.isDoomed()) break;
            if (bl6 && entity.getMovementMode() == 15 && entity.getElevation() == 0) {
                bl4 = true;
            }
            if (bl6 && entity instanceof Mech) {
                object2 = new Vector<Report>();
                serializable = new HashMap<Integer, CriticalSlot>();
                if (((Mech)entity).checkForMASCFailure(movePath, (Vector<Report>)object2, (HashMap<Integer, CriticalSlot>)serializable)) {
                    this.addReport((Vector<Report>)object2);
                    for (Integer n16 : ((HashMap)serializable).keySet()) {
                        object62 = (CriticalSlot)((HashMap)serializable).get(n16);
                        this.addReport(this.applyCriticalHit(entity, n16, (CriticalSlot)object62, true));
                    }
                    this.addReport(this.resolvePilotingRolls(entity));
                    this.game.resetPSRs(entity);
                    movePath.clear();
                    bl3 = true;
                } else {
                    this.addReport((Vector<Report>)object2);
                }
            }
            if ((pilotingRollData = entity.checkGetUp((MoveStep)object3)).getValue() != -2147483647) {
                ++entity.heatBuildup;
                entity.setProne(false);
                entity.setHullDown(false);
                bl8 = false;
                this.game.resetPSRs(entity);
                int n17 = n2 = !this.doSkillCheckInPlace(entity, pilotingRollData) ? 1 : 0;
            }
            if (n2 != 0) {
                n10 = ((MoveStep)object3).getMovementType();
                n6 = entity.getFacing();
                coords2 = entity.getPosition();
                n9 = ((MoveStep)object3).getMpUsed();
                bl3 = true;
                break;
            }
            if (((MoveStep)object3).getType() == 15) {
                entity.setUnjammingRAC(true);
                this.game.addAction(new UnjamAction(entity.getId()));
                break;
            }
            if (((MoveStep)object3).getType() == 23) {
                serializable = new LayMinefieldAction(entity.getId(), ((MoveStep)object3).getMineToLay());
                this.game.addLayMinefieldAction((LayMinefieldAction)serializable);
                entity.setLayingMines(true);
                break;
            }
            if (((MoveStep)object3).getType() == 22 && entity.hasSpotlight()) {
                boolean bl9 = !entity.isUsingSpotlight();
                entity.setSpotlightState(bl9);
                this.sendServerChat(entity.getDisplayName() + " switched searchlight " + (bl9 ? "on" : "off") + '.');
            }
            n10 = ((MoveStep)object3).getMovementType();
            n8 = ((MoveStep)object3).getDistance();
            n9 = ((MoveStep)object3).getMpUsed();
            if (n13 < 0) {
                int n18 = n13 = 3 == n10 ? entity.getOriginalJumpMP() : entity.getRunMP(false, false);
            }
            if (((MoveStep)object3).getType() == 8) {
                if (entity.canCharge()) {
                    this.checkExtremeGravityMovement(entity, (MoveStep)object3, coords2, n13);
                    serializable = ((MoveStep)object3).getTarget(this.game);
                    object2 = new ChargeAttackAction(entity.getId(), serializable.getTargetType(), serializable.getTargetId(), serializable.getPosition());
                    entity.setDisplacementAttack((DisplacementAttackAction)object2);
                    this.game.addCharge((AttackAction)object2);
                    enumeration = object2;
                    break;
                }
                this.sendServerChat("Illegal charge!! I don't think " + entity.getDisplayName() + " should be allowed to charge," + " but the client of " + entity.getOwner().getName() + " disagrees.");
                this.sendServerChat("Please make sure " + entity.getOwner().getName() + " is running MegaMek " + MegaMek.VERSION + ", or if that is already the case, submit a bug report at http://megamek.sf.net/");
                return;
            }
            if (((MoveStep)object3).getType() == 9) {
                if (entity.canDFA()) {
                    this.checkExtremeGravityMovement(entity, (MoveStep)object3, coords2, n13);
                    serializable = ((MoveStep)object3).getTarget(this.game);
                    object2 = new DfaAttackAction(entity.getId(), serializable.getTargetType(), serializable.getTargetId(), serializable.getPosition());
                    entity.setDisplacementAttack((DisplacementAttackAction)object2);
                    this.game.addCharge((AttackAction)object2);
                    enumeration = object2;
                    break;
                }
                this.sendServerChat("Illegal DFA!! I don't think " + entity.getDisplayName() + " should be allowed to DFA," + " but the client of " + entity.getOwner().getName() + " disagrees.");
                this.sendServerChat("Please make sure " + entity.getOwner().getName() + " is running MegaMek " + MegaMek.VERSION + ", or if that is already the case, submit a bug report at http://megamek.sf.net/");
                return;
            }
            if (entity instanceof Infantry) {
                serializable = (Infantry)entity;
                if (((MoveStep)object3).getType() == 28) {
                    ((Infantry)serializable).setDugIn(1);
                    continue;
                }
                if (((MoveStep)object3).getType() == 29) {
                    if (!entity.hasWorkingMisc(0x100000L, 1)) {
                        this.sendServerChat(entity.getDisplayName() + " failed to fortify because it is missing suitable equipment");
                    }
                    ((Infantry)serializable).setDugIn(3);
                    continue;
                }
                if (((MoveStep)object3).getType() != 3 && ((MoveStep)object3).getType() != 4) {
                    ((Infantry)serializable).setDugIn(0);
                }
            }
            coords2 = ((MoveStep)object3).getPosition();
            if (n10 != 3 || entity.getJumpType() != 3) {
                n6 = ((MoveStep)object3).getFacing();
            }
            int n19 = entity.checkMovementInBuilding((MoveStep)object3, (MoveStep)object4, coords2, coords);
            n7 = ((MoveStep)object3).getElevation();
            entity.setElevation(((MoveStep)object3).getElevation());
            object2 = this.game.getBoard().getHex(coords2);
            if (entity.canUnstickByJumping() && entity.isStuck() && n10 == 3) {
                entity.setStuck(false);
                entity.setCanUnstickByJumping(false);
            }
            if ((pilotingRollData = entity.checkSkid(n10, (IHex)object5, n11, (MoveStep)object4, n12, n6, coords, coords2, bl5, n8)).getValue() != -2147483647) {
                boolean bl10 = true;
                if (entity instanceof Mech) {
                    bl10 = 0 < this.doSkillCheckWhileMoving(entity, coords, coords, pilotingRollData, true);
                } else {
                    boolean bl11 = bl10 = 0 < this.doSkillCheckWhileMoving(entity, coords, coords, pilotingRollData, false);
                }
                if (bl10) {
                    if (entity instanceof Tank) {
                        this.addReport(this.vehicleMotiveDamage((Tank)entity, 0));
                    }
                    coords2 = coords;
                    int n20 = (n8 + 1) / 2;
                    int n21 = n12;
                    entity.delta_distance = n8 - 1;
                    n10 = -2;
                    if (((MoveStep)object3).isThisStepBackwards()) {
                        n21 = (n21 + 3) % 6;
                    }
                    if (this.processSkid(entity, coords2, ((MoveStep)object3).getElevation(), n21, n20, (MoveStep)object3)) {
                        return;
                    }
                    n6 = entity.getFacing();
                    coords2 = entity.getPosition();
                    entity.setSecondaryFacing(n6);
                    n9 = movePath.hasActiveMASC() ? entity.getRunMP() : entity.getRunMPwithoutMASC();
                    entity.moved = n10;
                    bl3 = true;
                    bl7 = true;
                    n8 = entity.delta_distance;
                    break;
                }
            }
            if ((entity instanceof VTOL || entity.getMovementMode() == 5 || entity.getMovementMode() == 15) && (pilotingRollData = entity.checkSideSlip(n10, (IHex)object5, n11, (MoveStep)object4, n12, n6, coords, coords2, n8)).getValue() != -2147483647 && (n15 = this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, false)) > 0 && (n14 = Math.min(n15, n8 - 1)) > 0) {
                int n22 = n12;
                bl2 = true;
                report = new Report(2100);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n14);
                this.addReport(report);
                if (this.processSkid(entity, coords, ((MoveStep)object3).getElevation(), n22, n14, (MoveStep)object3)) {
                    return;
                }
                if (!entity.isDestroyed() && !entity.isDoomed()) {
                    bl3 = true;
                }
                if (entity.getElevation() == 0 && (entity.getMovementMode() == 6 || entity.getMovementMode() == 15)) {
                    bl7 = true;
                }
                n6 = entity.getFacing();
                coords2 = entity.getPosition();
                entity.setSecondaryFacing(n6);
                break;
            }
            pilotingRollData = entity.checkRubbleMove((MoveStep)object3, (IHex)object2, coords, coords2);
            if (pilotingRollData.getValue() != -2147483647) {
                this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, true);
            }
            if (object2.terrainLevel(24) == 1 && ((MoveStep)object3).getElevation() == 0 && ((MoveStep)object3).getMovementType() != 3) {
                int n23 = Compute.d6(1);
                report = new Report(2395);
                report.addDesc(entity);
                report.add(n23);
                report.subject = entity.getId();
                this.addReport(report);
                if (n23 == 6) {
                    object2.removeTerrain(24);
                    object2.addTerrain(Terrains.getTerrainFactory().createTerrain(24, 2));
                    this.sendChangedHex(coords2);
                    Enumeration<Entity> enumeration3 = this.game.getEntities(coords2);
                    while (enumeration3.hasMoreElements()) {
                        object62 = enumeration3.nextElement();
                        if (object62 == entity) continue;
                        this.doMagmaDamage((Entity)object62, false);
                    }
                }
            }
            if (object2.terrainLevel(24) == 2 && ((MoveStep)object3).getElevation() == 0 && ((MoveStep)object3).getMovementType() != 3) {
                this.doMagmaDamage(entity, false);
            }
            if ((pilotingRollData = entity.checkSwampMove((MoveStep)object3, (IHex)object2, coords, coords2, bl)).getValue() != -2147483647 && 0 < this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, false)) {
                entity.setStuck(true);
                entity.setCanUnstickByJumping(true);
                report = new Report(2081);
                report.add(entity.getDisplayName());
                report.subject = entity.getId();
                this.addReport(report);
                object = Compute.stackingViolation(this.game, entity.getId(), coords2);
                if (object == null) break;
                int n24 = coords.direction(coords2);
                object62 = Compute.getValidDisplacement(this.game, entity.getId(), coords2, n24);
                this.addReport(this.doEntityDisplacement((Entity)object, coords2, (Coords)object62, new PilotingRollData(((Entity)object).getId(), 0, "domino effect")));
                this.entityUpdate(((Entity)object).getId());
                break;
            }
            object = this.game.getBoard().getHex(coords);
            if (entity instanceof Mech && !coords.equals(coords2) && object4 != null && (object.containsTerrain(7) && ((MoveStep)object4).getElevation() <= 1 || object.containsTerrain(24) && ((MoveStep)object4).getElevation() == 0) && (((MoveStep)object3).getMovementType() != 3 || 0 == ((MoveStep)object3).getMpUsed() - ((MoveStep)object3).getMp())) {
                int n25 = 0;
                if (object.containsTerrain(7)) {
                    n25 += 2;
                }
                if (object.terrainLevel(24) == 1) {
                    n25 += 2;
                } else if (object.terrainLevel(24) == 2) {
                    n25 += 5;
                }
                entity.heatFromExternal += n25;
                report = new Report(2115);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n25);
                this.addReport(report);
            }
            if (!(entity instanceof Mech) && this.game.getBoard().getHex(coords2).containsTerrain(7) && !coords.equals(coords2) && ((MoveStep)object3).getMovementType() != 3 && ((MoveStep)object3).getElevation() <= 1) {
                if (this.game.getOptions().booleanOption("vehicle_fires") && entity instanceof Tank) {
                    this.checkForVehicleFire((Tank)entity, false);
                } else {
                    this.doFlamingDeath(entity);
                }
            }
            if (!enumeration2.hasMoreElements() && !bl6) {
                this.checkExtremeGravityMovement(entity, (MoveStep)object3, coords2, n13);
            }
            if (!coords.equals(coords2) && ((MoveStep)object3).getMovementType() != 3 || n11 == 3 && !enumeration2.hasMoreElements()) {
                this.addReport(this.checkVibrabombs(entity, coords2, false, coords, coords2));
                if (this.game.containsMinefield(coords2)) {
                    for (Object object62 : this.game.getMinefields(coords2)) {
                        boolean bl12 = !enumeration2.hasMoreElements();
                        bl12 |= ((MoveStep)object3).getMovementType() != 3;
                        boolean bl13 = ((MoveStep)object3).getElevation() == 0;
                        entity.setPosition(coords2);
                        if (bl12 &= bl13) {
                            this.addReport(this.enterMinefield(entity, (Minefield)object62, coords2, coords2, true));
                        } else if (((Minefield)object62).getType() == 5) {
                            this.addReport(this.enterMinefield(entity, (Minefield)object62, coords2, coords2, true, 2));
                        }
                        entity.setPosition(coords);
                    }
                }
            }
            if (!coords.equals(coords2) && !enumeration2.hasMoreElements() && bl5 && this.game.containsMinefield(coords2)) {
                Player player = entity.getOwner();
                object62 = this.game.getMinefields(coords2).iterator();
                while (object62.hasNext()) {
                    Minefield minefield = (Minefield)object62.next();
                    if (player.containsMinefield(minefield)) continue;
                    report = new Report(2120);
                    report.subject = entity.getId();
                    report.add(entity.getShortName(), true);
                    this.addReport(report);
                    this.revealMinefield(player, minefield);
                }
            }
            if ((pilotingRollData = entity.checkWaterMove((MoveStep)object3, (IHex)object2, coords, coords2, bl)).getValue() != -2147483647) {
                int n26 = entity.getSwarmAttackerId();
                boolean bl14 = true;
                Entity entity3 = null;
                if (-1 != n26) {
                    entity3 = this.game.getEntity(n26);
                    bl14 = entity3.isDone();
                }
                this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, true);
                if (object2.terrainLevel(4) > 1) {
                    this.drownSwarmer(entity, coords2);
                }
                if (!bl14 && entity3 != null && (entity3.isDoomed() || entity3.isDestroyed())) {
                    entity3.setDone(false);
                    entity3.setUnloaded(false);
                    this.game.removeTurnFor(entity3);
                    this.send(this.createTurnVectorPacket());
                    entity3.setDone(true);
                    entity3.setUnloaded(true);
                }
                this.checkForWashedInfernos(entity, coords2);
            }
            this.addReport(this.doSetLocationsExposure(entity, (IHex)object2, ((MoveStep)object3).getMovementType() == 3, ((MoveStep)object3).getElevation()));
            if (object5 != null && object4 != null && ((MoveStep)object4).getElevation() < 0 && ((MoveStep)object3).getElevation() == 0 && object5.containsTerrain(20) && object5.containsTerrain(4) && ((MoveStep)object3).getMovementType() != 3 && !coords.equals(coords2)) {
                report = new Report(2410);
                report.addDesc(entity);
                this.addReport(report);
                this.addReport(this.resolveIceBroken(coords));
            }
            if (object2.containsTerrain(20) && object2.containsTerrain(4) && ((MoveStep)object3).getMovementType() != 3 && !coords.equals(coords2)) {
                if (((MoveStep)object3).getElevation() == 0) {
                    int n27 = Compute.d6(1);
                    report = new Report(2118);
                    report.addDesc(entity);
                    report.add(n27);
                    report.subject = entity.getId();
                    this.addReport(report);
                    if (n27 == 6) {
                        entity.setPosition(coords2);
                        this.addReport(this.resolveIceBroken(coords2));
                        coords2 = entity.getPosition();
                    }
                } else if (((MoveStep)object3).getElevation() + entity.height() == 0) {
                    report = new Report(2410);
                    report.addDesc(entity);
                    this.addReport(report);
                    this.addReport(this.resolveIceBroken(coords2));
                }
            }
            if (((MoveStep)object3).getType() == 16) {
                Entity entity4 = null;
                Enumeration<Entity> enumeration4 = this.game.getEntities(coords2);
                while (enumeration4.hasMoreElements()) {
                    entity4 = enumeration4.nextElement();
                    if (!entity.isEnemyOf(entity4) && !entity.equals(entity4)) {
                        if (!entity.canLoad(entity4) || !entity4.isLoadableThisTurn()) {
                            System.err.println(entity.getShortName() + " can not load " + entity4.getShortName());
                            entity4 = null;
                            continue;
                        }
                        this.loadUnit(entity, entity4);
                        break;
                    }
                    entity4 = null;
                }
                if (entity4 == null) {
                    System.err.println("Could not find unit for " + entity.getShortName() + " to load in " + coords2);
                }
            }
            if (((MoveStep)object3).getType() == 17 && !this.unloadUnit(entity, targetable = ((MoveStep)object3).getTarget(this.game), coords2, n6, ((MoveStep)object3).getElevation())) {
                System.err.println("Error! Server was told to unload " + targetable.getDisplayName() + " from " + entity.getDisplayName() + " into " + coords2.getBoardNum());
            }
            if (!(((MoveStep)object3).getType() != 2 && ((MoveStep)object3).getType() != 13 && ((MoveStep)object3).getType() != 14 || this.game.getBoard().getHex(coords).getElevation() == object2.getElevation() || entity instanceof VTOL)) {
                PilotingRollData pilotingRollData2 = entity.getBasePilotingRoll();
                int n28 = Compute.d6(2);
                report = entity instanceof Tank ? new Report(2435) : new Report(2430);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(pilotingRollData2.getValue());
                report.add(n28);
                this.addReport(report);
                if (n28 < pilotingRollData2.getValue()) {
                    if (entity instanceof Mech) {
                        if (object2.getElevation() < this.game.getBoard().getHex(coords).getElevation()) {
                            this.addReport(this.doEntityFallsInto(entity, coords, coords2, entity.getBasePilotingRoll(), false));
                        } else {
                            this.addReport(this.doEntityFallsInto(entity, coords2, coords, entity.getBasePilotingRoll(), false));
                        }
                    } else if (entity instanceof Tank) {
                        coords2 = coords;
                    }
                }
            }
            if (n19 > 0) {
                Building building = null;
                if ((n19 & 1) == 1) {
                    building = this.game.getBoard().getBuildingAt(coords);
                }
                Building building2 = null;
                if ((n19 & 2) == 2) {
                    building2 = this.game.getBoard().getBuildingAt(coords2);
                }
                Building building3 = null;
                if ((n19 & 4) == 4) {
                    building3 = this.game.getBoard().getBuildingAt(coords2);
                }
                boolean bl15 = false;
                if (building2 != null || building != null) {
                    if (building == null) {
                        bl15 = this.passBuildingWall(entity, building2, coords, coords2, n8, "entering", ((MoveStep)object3).isThisStepBackwards());
                        this.addAffectedBldg(building2, bl15);
                    } else if (building.equals(building2)) {
                        bl15 = this.passBuildingWall(entity, building2, coords, coords2, n8, "moving in", ((MoveStep)object3).isThisStepBackwards());
                        this.addAffectedBldg(building2, bl15);
                    } else if (building2 != null) {
                        if (entity instanceof Protomech) {
                            Vector<Report> vector2 = this.damageBuilding(building2, 1);
                            for (Report report5 : vector2) {
                                report5.subject = entity.getId();
                            }
                            this.addReport(vector2);
                        }
                        bl15 = this.passBuildingWall(entity, building, coords, coords2, n8, "exiting", ((MoveStep)object3).isThisStepBackwards());
                        this.addAffectedBldg(building, bl15);
                        bl15 = this.passBuildingWall(entity, building2, coords, coords2, n8, "entering", ((MoveStep)object3).isThisStepBackwards());
                        this.addAffectedBldg(building2, bl15);
                    } else {
                        bl15 = this.passBuildingWall(entity, building, coords, coords2, n8, "exiting", ((MoveStep)object3).isThisStepBackwards());
                        this.addAffectedBldg(building, bl15);
                    }
                }
                if (building3 != null) {
                    bl15 = this.checkBuildingCollapseWhileMoving(building3, entity, coords2);
                    this.addAffectedBldg(building3, bl15);
                }
                if (entity.isDoomed()) {
                    entity.setDestroyed(true);
                    this.game.moveToGraveyard(entity.getId());
                    this.send(this.createRemoveEntityPacket(entity.getId()));
                    return;
                }
            }
            if (!bl8 && entity.isProne()) {
                n6 = entity.getFacing();
                coords2 = entity.getPosition();
                n9 = ((MoveStep)object3).getMpUsed();
                bl3 = true;
                break;
            }
            if (((MoveStep)object3).getType() == 6) {
                n9 = ((MoveStep)object3).getMpUsed();
                pilotingRollData = entity.checkDislodgeSwarmers((MoveStep)object3);
                if (pilotingRollData.getValue() == -2147483647) {
                    entity.setProne(true);
                    this.checkForWashedInfernos(entity, coords2);
                } else {
                    entity.setPosition(coords2);
                    if (this.doDislodgeSwarmerSkillCheck(entity, pilotingRollData, coords2)) {
                        n6 = entity.getFacing();
                        coords2 = entity.getPosition();
                        bl3 = true;
                        break;
                    }
                    entity.setProne(true);
                    this.checkForWashedInfernos(entity, coords2);
                    break;
                }
            }
            if (((MoveStep)object3).getType() == 24) {
                n9 = ((MoveStep)object3).getMpUsed();
                entity.setHullDown(true);
            }
            vector.addElement(new UnitLocation(entity.getId(), coords2, n6));
            coords = new Coords(coords2);
            object4 = object3;
            if (!object2.equals(object5)) {
                n12 = n6;
            }
            object5 = object2;
            bl6 = false;
        }
        entity.setPosition(coords2);
        entity.setFacing(n6);
        entity.setSecondaryFacing(n6);
        entity.delta_distance = n8;
        entity.moved = n10;
        entity.mpUsed = n9;
        if (!bl2 && !bl3) {
            entity.setElevation(n7);
        }
        entity.setClimbMode(movePath.getFinalClimbMode());
        pilotingRollData = entity.checkRunningWithDamage(n11);
        if (pilotingRollData.getValue() != -2147483647) {
            this.doSkillCheckInPlace(entity, pilotingRollData);
        }
        if (-1 != (n = entity.getSwarmAttackerId()) && movePath.contains(30)) {
            object3 = this.game.getEntity(n);
            PilotingRollData pilotingRollData3 = entity.getBasePilotingRoll();
            entity.addPilotingModifierForTerrain(pilotingRollData3);
            if (movePath.getLastStepMovementType() == 5) {
                pilotingRollData3.addModifier(2, "dislodge swarming infantry with VTOL movement");
            } else {
                pilotingRollData3.addModifier(4, "dislodge swarming infantry");
            }
            for (Mounted mounted : ((Entity)object3).getMisc()) {
                object2 = mounted.getType();
                if ("BA-Assault Claws".equals(((EquipmentType)object2).getInternalName())) {
                    pilotingRollData3.addModifier(1, "swarmer has assault claws");
                    break;
                }
                if (!((EquipmentType)object2).hasFlag(0x200000L)) continue;
                pilotingRollData3.addModifier(1, "swarmer has magnetic claw");
                break;
            }
            report = new Report(2125);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
            n2 = Compute.d6(2);
            report = new Report(2130);
            report.subject = entity.getId();
            report.add(pilotingRollData3.getValueAsString());
            report.add(pilotingRollData3.getDesc());
            report.add(n2);
            if (n2 < pilotingRollData3.getValue()) {
                report.choose(false);
                this.addReport(report);
            } else {
                this.game.removeTurnFor((Entity)object3);
                this.send(this.createTurnVectorPacket());
                report.choose(true);
                this.addReport(report);
                entity.setSwarmAttackerId(-1);
                ((Entity)object3).setSwarmTargetId(-1);
                IHex iHex = this.game.getBoard().getHex(coords2);
                if (iHex.terrainLevel(4) > 0) {
                    ((Entity)object3).setPosition(coords2);
                    report = new Report(2135);
                    report.subject = entity.getId();
                    report.indent();
                    report.addDesc((Entity)object3);
                    this.addReport(report);
                    this.addReport(this.destroyEntity((Entity)object3, "a watery grave", false));
                } else {
                    report = new Report(2140);
                    report.subject = entity.getId();
                    report.indent();
                    report.addDesc((Entity)object3);
                    report.add("3d6");
                    this.addReport(report);
                    this.addReport(this.damageEntity((Entity)object3, ((Entity)object3).rollHitLocation(0, 0), Compute.d6(3)));
                    this.addNewLines();
                    ((Entity)object3).setPosition(coords2);
                }
                this.entityUpdate(n);
            }
        }
        if (n11 == 3 && !entity.isMakingDfa()) {
            object3 = this.game.getBoard().getHex(coords2);
            pilotingRollData = entity.checkLandingWithDamage();
            if (pilotingRollData.getValue() != -2147483647) {
                this.doSkillCheckInPlace(entity, pilotingRollData);
            }
            bl = object3.terrainLevel(4);
            if (object3.containsTerrain(20) && bl > false) {
                bl = false;
                n2 = Compute.d6(1);
                report = new Report(2122);
                report.add(entity.getDisplayName(), true);
                report.add(n2);
                report.subject = entity.getId();
                this.addReport(report);
                if (n2 >= 4) {
                    this.addReport(this.resolveIceBroken(coords2));
                }
            } else if (!((MoveStep)object4).climbMode() || !object3.containsTerrain(14)) {
                pilotingRollData = entity.checkWaterMove(bl ? 1 : 0);
                if (pilotingRollData.getValue() != -2147483647) {
                    this.doSkillCheckInPlace(entity, pilotingRollData);
                }
                if (bl > true) {
                    this.drownSwarmer(entity, coords2);
                }
            }
            Building building = this.game.getBoard().getBuildingAt(coords2);
            if (building != null) {
                this.checkForCollapse(building, this.game.getPositionMap());
            }
            if (object3.terrainLevel(24) == 1) {
                int n29 = Compute.d6(1);
                report = new Report(2395);
                report.addDesc(entity);
                report.add(n29);
                report.subject = entity.getId();
                this.addReport(report);
                if (n29 == 6) {
                    object3.removeTerrain(24);
                    object3.addTerrain(Terrains.getTerrainFactory().createTerrain(24, 2));
                    this.sendChangedHex(coords2);
                    object2 = this.game.getEntities(coords2);
                    while (object2.hasMoreElements()) {
                        object = object2.nextElement();
                        if (object == entity) continue;
                        this.doMagmaDamage((Entity)object, false);
                    }
                }
            }
            if (object3.terrainLevel(24) == 2) {
                this.doMagmaDamage(entity, false);
            }
            if (object3.containsTerrain(9) || object3.containsTerrain(24) || object3.containsTerrain(28) || object3.containsTerrain(25) || object3.containsTerrain(29)) {
                if (entity instanceof Mech) {
                    entity.setStuck(true);
                    report = new Report(2121);
                    report.add(entity.getDisplayName(), true);
                    report.subject = entity.getId();
                    this.addReport(report);
                } else if (entity instanceof Infantry) {
                    PilotingRollData pilotingRollData4 = new PilotingRollData(entity.getId(), 5, "entering boggy terrain");
                    if (object3.containsTerrain(24) || object3.containsTerrain(25) || object3.containsTerrain(28) || object3.containsTerrain(29)) {
                        pilotingRollData4.append(new PilotingRollData(entity.getId(), -1, "avoid bogging down"));
                    }
                    if (0 < this.doSkillCheckWhileMoving(entity, coords2, coords2, pilotingRollData4, false)) {
                        entity.setStuck(true);
                        report = new Report(2081);
                        report.add(entity.getDisplayName());
                        report.subject = entity.getId();
                        this.addReport(report);
                    }
                }
            }
            if (-1 != n) {
                Entity entity5 = this.game.getEntity(n);
                object2 = entity.getBasePilotingRoll();
                entity.addPilotingModifierForTerrain((PilotingRollData)object2);
                ((TargetRoll)object2).addModifier(4, "dislodge swarming infantry");
                for (Mounted mounted : entity5.getMisc()) {
                    EquipmentType equipmentType = mounted.getType();
                    if ("BA-Assault Claws".equals(equipmentType.getInternalName())) {
                        ((TargetRoll)object2).addModifier(1, "swarmer has assault claws");
                        break;
                    }
                    if (!equipmentType.hasFlag(0x200000L)) continue;
                    ((TargetRoll)object2).addModifier(1, "swarmer has magnetic claw");
                    break;
                }
                report = new Report(2125);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
                int n30 = Compute.d6(2);
                report = new Report(2130);
                report.subject = entity.getId();
                report.add(((TargetRoll)object2).getValueAsString());
                report.add(((TargetRoll)object2).getDesc());
                report.add(n30);
                if (n30 < ((TargetRoll)object2).getValue()) {
                    report.choose(false);
                    this.addReport(report);
                } else {
                    this.game.removeTurnFor(entity5);
                    this.send(this.createTurnVectorPacket());
                    report.choose(true);
                    this.addReport(report);
                    entity.setSwarmAttackerId(-1);
                    entity5.setSwarmTargetId(-1);
                    if (object3.terrainLevel(4) > 0) {
                        entity5.setPosition(coords2);
                        report = new Report(2135);
                        report.subject = entity.getId();
                        report.indent();
                        report.addDesc(entity5);
                        this.addReport(report);
                        this.addReport(this.destroyEntity(entity5, "a watery grave", false));
                    } else {
                        report = new Report(2140);
                        report.subject = entity.getId();
                        report.indent();
                        report.addDesc(entity5);
                        report.add("3d6");
                        this.addReport(report);
                        this.addReport(this.damageEntity(entity5, entity5.rollHitLocation(0, 0), Compute.d6(3)));
                        this.addNewLines();
                        entity5.setPosition(coords2);
                    }
                    this.entityUpdate(n);
                }
            }
            this.checkForWashedInfernos(entity, coords2);
        }
        this.doSetLocationsExposure(entity, this.game.getBoard().getHex(coords2), false, entity.getElevation());
        if (!(this.game.getOptions().booleanOption("falls_end_movement") && entity instanceof Mech || !bl3 || bl7 || entity.mpUsed >= entity.getRunMP() || !entity.isSelectableThisTurn() || entity.isDoomed())) {
            entity.applyDamage();
            entity.setDone(false);
            object3 = new GameTurn.SpecificEntityTurn(entity.getOwner().getId(), entity.getId());
            this.game.insertNextTurn((GameTurn)object3);
            this.send(this.createTurnVectorPacket());
            this.send(entity.getOwner().getId(), this.createSpecialReportPacket());
        } else {
            if (entity.getMovementMode() == 15 && entity.getElevation() > 0) {
                if (!bl4 && entity.delta_distance < 5) {
                    report = new Report(2123);
                    report.addDesc(entity);
                    report.subject = entity.getId();
                    this.vPhaseReport.add(report);
                    object3 = this.game.getBoard().getHex(coords2);
                    if (!object3.hasPavement() && object3.terrainsPresent() > 0) {
                        report = new Report(2124);
                        report.addDesc(entity);
                        report.subject = entity.getId();
                        this.vPhaseReport.add(report);
                        this.vPhaseReport.addAll(this.crashVTOLorWiGE((Tank)entity));
                    } else {
                        entity.setElevation(0);
                    }
                } else {
                    entity.setElevation(1);
                }
            }
            entity.setDone(true);
        }
        if (-1 != n) {
            object3 = this.game.getEntity(n);
            ((Entity)object3).setPosition(coords2);
            if (!(object3 instanceof BattleArmor) && this.game.getBoard().getHex(coords2).containsTerrain(7)) {
                ((Entity)object3).setSwarmTargetId(-1);
                entity.setSwarmAttackerId(-1);
                report = new Report(2145);
                report.subject = entity.getId();
                report.indent();
                report.add(((Entity)object3).getShortName(), true);
                this.addReport(report);
            }
            this.entityUpdate(n);
        }
        if (!this.game.isOutOfGame(entity)) {
            this.entityUpdate(entity.getId(), vector);
            if (entity.isDoomed()) {
                this.send(this.createRemoveEntityPacket(entity.getId(), entity.getRemovalCondition()));
            }
        }
        if (this.doBlind()) {
            this.send(entity.getOwner().getId(), this.createFilteredEntitiesPacket(entity.getOwner()));
        }
        if (enumeration != null) {
            this.send(this.createAttackPacket((EntityAction)((Object)enumeration), 1));
        }
    }

    public void deliverThunderAugMinefield(Coords coords, int n, int n2) {
        Coords coords2 = null;
        for (int i = 0; i < 7; ++i) {
            switch (i) {
                case 6: {
                    coords2 = new Coords(coords);
                    break;
                }
                default: {
                    coords2 = coords.translated(i);
                }
            }
            if (!this.game.getBoard().contains(coords2)) continue;
            Minefield minefield = null;
            Enumeration<Minefield> enumeration = this.game.getMinefields(coords2).elements();
            while (enumeration.hasMoreElements()) {
                Minefield minefield2 = enumeration.nextElement();
                if (minefield2.getType() != 3) continue;
                minefield = minefield2;
                break;
            }
            if (minefield == null) {
                minefield = Minefield.createThunderMF(coords2, n, n2 / 2 + n2 % 2);
                this.game.addMinefield(minefield);
                this.revealMinefield(minefield);
                continue;
            }
            if (minefield.getDamage() >= 20) continue;
            this.removeMinefield(minefield);
            int n3 = n2 / 2 + n2 % 2;
            if ((n3 += minefield.getDamage()) > 20) {
                n3 = 20;
            }
            minefield.setDamage(n3);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    public void deliverThunderMinefield(Coords coords, int n, int n2) {
        Minefield minefield = null;
        Enumeration<Minefield> enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = enumeration.nextElement();
            if (minefield2.getType() != 3) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderMF(coords, n, n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n3 = minefield.getDamage();
            n2 = (n2 += n3) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    public void deliverThunderInfernoMinefield(Coords coords, int n, int n2) {
        Minefield minefield = null;
        Enumeration<Minefield> enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = enumeration.nextElement();
            if (minefield2.getType() != 4) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderInfernoMF(coords, n, n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n3 = minefield.getDamage();
            n2 = (n2 += n3) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    public void deliverFASCAMMinefield(Coords coords, int n) {
        if (this.game.getBoard().contains(coords)) {
            Minefield minefield = null;
            Enumeration<Minefield> enumeration = this.game.getMinefields(coords).elements();
            while (enumeration.hasMoreElements()) {
                Minefield minefield2 = enumeration.nextElement();
                if (minefield2.getType() != 3) continue;
                minefield = minefield2;
                break;
            }
            if (minefield == null) {
                minefield = Minefield.createThunderMF(coords, n, 30);
            }
            this.removeMinefield(minefield);
            minefield.setDamage(30);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    public void deliverThunderActiveMinefield(Coords coords, int n, int n2) {
        Minefield minefield = null;
        Enumeration<Minefield> enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = enumeration.nextElement();
            if (minefield2.getType() != 5) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderActiveMF(coords, n, n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n3 = minefield.getDamage();
            n2 = (n2 += n3) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    public void deliverThunderVibraMinefield(Coords coords, int n, int n2, int n3) {
        Minefield minefield = null;
        Enumeration<Minefield> enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = enumeration.nextElement();
            if (minefield2.getType() != 6) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderVibrabombMF(coords, n, n2, n3);
            this.game.addVibrabomb(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n4 = minefield.getDamage();
            n2 = (n2 += n4) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addVibrabomb(minefield);
            this.revealMinefield(minefield);
        }
    }

    public void deliverFlare(Coords coords, int n) {
        Flare flare = new Flare(coords, Math.max(1, n / 5), 3, 0);
        this.game.addFlare(flare);
    }

    public void deliverArtilleryFlare(Coords coords, int n) {
        Flare flare = new Flare(coords, 12, n, Flare.F_DRIFTING);
        this.game.addFlare(flare);
    }

    public void deliverArtillerySmoke(Coords coords, Vector<Report> vector) {
        IHex iHex;
        if (this.game.getOptions().booleanOption("maxtech_fire") && (iHex = this.game.getBoard().getHex(coords)).terrainLevel(8) < 2) {
            Report report = new Report(5185, 0);
            report.indent(2);
            report.add(coords.getBoardNum());
            vector.add(report);
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 2));
            this.sendChangedHex(coords);
        }
    }

    public void deliverArtilleryInferno(Coords coords, int n, Vector<Report> vector) {
        Serializable serializable;
        Report report;
        IHex iHex = this.game.getBoard().getHex(coords);
        if (!iHex.containsTerrain(7) && this.game.getOptions().booleanOption("fire")) {
            report = new Report(3005);
            report.subject = n;
            report.indent(2);
            report.add(coords.getBoardNum());
            vector.add(report);
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
        }
        this.game.getBoard().addInfernoTo(coords, InfernoTracker.INFERNO_IV_ROUND, 1);
        this.sendChangedHex(coords);
        Enumeration<Entity> enumeration = this.game.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            ((Entity)serializable).infernos.add(InfernoTracker.INFERNO_IV_ROUND, 1);
            report = new Report(3205);
            report.indent(2);
            report.subject = ((Entity)serializable).getId();
            report.addDesc((Entity)serializable);
            report.add(((Entity)serializable).infernos.getTurnsLeftToBurn());
            vector.add(report);
        }
        for (int i = 0; i <= 5; ++i) {
            serializable = coords.translated(i);
            if (!this.game.getBoard().contains((Coords)serializable) || coords.equals(serializable)) continue;
            iHex = this.game.getBoard().getHex((Coords)serializable);
            if (!iHex.containsTerrain(7) && this.game.getOptions().booleanOption("fire")) {
                report = new Report(3005);
                report.subject = n;
                report.indent(2);
                report.add(((Coords)serializable).getBoardNum());
                vector.add(report);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
            }
            this.game.getBoard().addInfernoTo((Coords)serializable, InfernoTracker.INFERNO_IV_ROUND, 1);
            this.sendChangedHex((Coords)serializable);
            Enumeration<Entity> enumeration2 = this.game.getEntities((Coords)serializable);
            while (enumeration2.hasMoreElements()) {
                Entity entity = enumeration2.nextElement();
                entity.infernos.add(InfernoTracker.INFERNO_IV_ROUND, 1);
                report = new Report(3205);
                report.indent(2);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(entity.infernos.getTurnsLeftToBurn());
                vector.add(report);
            }
        }
    }

    public Vector<Report> deliverInfernoMissiles(Entity entity, Targetable targetable, int n) {
        IHex iHex = this.game.getBoard().getHex(targetable.getPosition());
        Vector<Report> vector = new Vector<Report>();
        switch (targetable.getTargetType()) {
            case 7: {
                Object object;
                Object object2 = this.game.getEntities(targetable.getPosition());
                while (object2.hasMoreElements()) {
                    Report report;
                    object = object2.nextElement();
                    if (((Entity)object).getElevation() > iHex.terrainLevel(12)) {
                        report = new Report(6685);
                        report.subject = ((Entity)object).getId();
                        report.addDesc((Entity)object);
                        vector.add(report);
                        vector.addAll(this.deliverInfernoMissiles(entity, (Targetable)object, n));
                        continue;
                    }
                    int n2 = Compute.d6();
                    report = new Report(3570);
                    report.subject = ((Entity)object).getId();
                    report.addDesc((Entity)object);
                    report.add(n2);
                    vector.add(report);
                    if (n2 < 5) continue;
                    vector.addAll(this.deliverInfernoMissiles(entity, (Targetable)object, n));
                }
                if (this.game.getBoard().getBuildingAt(targetable.getPosition()) != null) {
                    object2 = this.damageBuilding(this.game.getBoard().getBuildingAt(targetable.getPosition()), 2 * n);
                    object = ((Vector)object2).iterator();
                    while (object.hasNext()) {
                        Report report = (Report)object.next();
                        report.subject = entity.getId();
                    }
                    vector.addAll((Collection<Report>)object2);
                }
            }
            case 1: 
            case 2: {
                vector.addAll(this.tryClearHex(targetable.getPosition(), n * 4, entity.getId()));
                this.tryIgniteHex(targetable.getPosition(), entity.getId(), true, 0, vector);
                break;
            }
            case 3: 
            case 4: {
                Object object;
                Object object3 = this.game.getEntities(targetable.getPosition());
                while (object3.hasMoreElements()) {
                    object = object3.nextElement();
                    if (((Entity)object).getElevation() > iHex.terrainLevel(12)) continue;
                    int n3 = Compute.d6();
                    Report report = new Report(3570);
                    report.subject = ((Entity)object).getId();
                    report.addDesc((Entity)object);
                    report.add(n3);
                    vector.add(report);
                    if (n3 < 5) continue;
                    vector.addAll(this.deliverInfernoMissiles(entity, (Targetable)object, n));
                }
                object3 = this.damageBuilding(this.game.getBoard().getBuildingAt(targetable.getPosition()), 2 * n);
                object = ((Vector)object3).iterator();
                while (object.hasNext()) {
                    Report report = (Report)object.next();
                    report.subject = entity.getId();
                }
                vector.addAll((Collection<Report>)object3);
                break;
            }
            case 0: {
                Entity entity2 = (Entity)targetable;
                if (entity2 instanceof Mech) {
                    Report report;
                    int n4 = n;
                    for (int i = 0; i < n4; ++i) {
                        LosEffects losEffects;
                        int n5 = Compute.d6(2);
                        if (!entity2.removePartialCoverHits(n5, (losEffects = LosEffects.calculateLos(this.game, entity.getId(), targetable)).getTargetCover(), Compute.targetSideTable(entity, targetable))) continue;
                        --n;
                    }
                    if (n != n4) {
                        report = new Report(3403);
                        report.add(n4 - n);
                        report.indent(2);
                        report.subject = entity2.getId();
                        vector.add(report);
                    }
                    report = new Report(3400);
                    report.add(2 * n);
                    report.subject = entity2.getId();
                    report.indent(2);
                    report.choose(true);
                    vector.add(report);
                    entity2.heatFromExternal += 2 * n;
                    break;
                }
                if (entity2 instanceof Tank) {
                    if (this.game.getOptions().booleanOption("vehicle_fires") && entity2 instanceof Tank) {
                        vector.addAll(this.checkForVehicleFire((Tank)entity2, true));
                    }
                    int n6 = Compute.targetSideTable(entity, (Targetable)entity2);
                    while (n-- > 0) {
                        HitData hitData = entity2.rollHitLocation(0, n6);
                        vector.addAll(this.criticalEntity(entity2, hitData.getLocation(), -2));
                    }
                } else if (entity2 instanceof Protomech) {
                    entity2.heatFromExternal += n;
                    while (entity2.heatFromExternal >= 3) {
                        Report report;
                        entity2.heatFromExternal -= 3;
                        HitData hitData = entity2.rollHitLocation(0, 0);
                        if (hitData.getLocation() == 6) {
                            report = new Report(6035);
                            report.subject = entity2.getId();
                            report.newlines = 0;
                            vector.add(report);
                            continue;
                        }
                        report = new Report(6690);
                        report.subject = entity2.getId();
                        report.newlines = 0;
                        report.add(entity2.getLocationName(hitData));
                        vector.add(report);
                        entity2.destroyLocation(hitData.getLocation());
                        int n7 = Protomech.POSSIBLE_PILOT_DAMAGE[hitData.getLocation()] - ((Protomech)entity2).getPilotDamageTaken(hitData.getLocation());
                        if (n7 > 0) {
                            vector.addAll(this.damageCrew(entity2, n7));
                            ((Protomech)entity2).setPilotDamageTaken(hitData.getLocation(), Protomech.POSSIBLE_PILOT_DAMAGE[hitData.getLocation()]);
                        }
                        if (entity2.getTransferLocation(hitData).getLocation() != -2) continue;
                        vector.addAll(this.destroyEntity(entity2, "flaming inferno death", false, true));
                    }
                } else if (entity2 instanceof BattleArmor) {
                    for (Mounted mounted : entity2.getMisc()) {
                        if (!"BA-Fire Resistant Armor".equals(mounted.getType().getInternalName())) continue;
                        Report report = new Report(3395);
                        report.indent(2);
                        report.subject = entity2.getId();
                        report.addDesc(entity2);
                        vector.add(report);
                        return vector;
                    }
                    entity2.heatFromExternal += n;
                    while (entity2.heatFromExternal >= 3) {
                        entity2.heatFromExternal -= 3;
                        HitData hitData = entity2.rollHitLocation(0, 0);
                        hitData.setEffect(1);
                        vector.addAll(this.damageEntity(entity2, hitData, 1));
                    }
                } else {
                    if (entity2 instanceof Infantry) {
                        HitData hitData = new HitData(0);
                        if (entity2.getInternal(hitData) > 3 * n) {
                            entity2.setInternal(entity2.getInternal(hitData) - 3 * n, hitData);
                            Report report = new Report(6065);
                            report.addDesc(entity2);
                            report.add(3 * n);
                            report.indent(2);
                            report.add(entity2.getLocationAbbr(hitData));
                            report.newlines = 0;
                            report.subject = entity2.getId();
                            vector.add(report);
                            report = new Report(6095);
                            report.add(entity2.getInternal(hitData));
                            report.subject = entity2.getId();
                            report.indent(2);
                            vector.add(report);
                            break;
                        }
                        vector.addAll(this.destroyEntity(entity2, "damage", false));
                        Report.addNewline(vector);
                        break;
                    }
                    int n8 = Compute.targetSideTable(entity, (Targetable)entity2);
                    while (n-- > 0) {
                        HitData hitData = entity2.rollHitLocation(0, n8);
                        vector.addAll(this.damageEntity(entity2, hitData, 2));
                    }
                }
                break;
            }
        }
        return vector;
    }

    private Vector<Report> enterMinefield(Entity entity, Minefield minefield, Coords coords, Coords coords2, boolean bl) {
        return this.enterMinefield(entity, minefield, coords, coords2, bl, 0);
    }

    private Vector<Report> enterMinefield(Entity entity, Minefield minefield, Coords coords, Coords coords2, boolean bl, int n) {
        Vector<Report> vector = new Vector<Report>();
        if (!this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(4) || this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(5) || this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(20)) {
            switch (minefield.getType()) {
                case 0: 
                case 3: 
                case 5: {
                    if (minefield.getTrigger() != 0 && Compute.d6(2) < minefield.getTrigger() + n) {
                        return vector;
                    }
                    Report report = new Report(2150);
                    report.subject = entity.getId();
                    report.add(entity.getShortName(), true);
                    report.add(minefield.getCoords().getBoardNum(), true);
                    vector.add(report);
                    HitData hitData = entity.rollHitLocation(2, 0);
                    vector.addAll(this.damageEntity(entity, hitData, minefield.getDamage()));
                    if (bl) {
                        vector.addAll(this.resolvePilotingRolls(entity, true, coords, coords2));
                        this.game.resetPSRs(entity);
                    }
                    if (!minefield.isOneUse()) {
                        this.revealMinefield(minefield);
                        break;
                    }
                    this.removeMinefield(minefield);
                    break;
                }
                case 4: {
                    if (minefield.getTrigger() != 0 && Compute.d6(2) < minefield.getTrigger() + n) {
                        return vector;
                    }
                    Report report = new Report(2155);
                    report.subject = entity.getId();
                    report.add(entity.getShortName(), true);
                    report.add(minefield.getCoords().getBoardNum(), true);
                    vector.add(report);
                    vector.addAll(this.deliverInfernoMissiles(entity, entity, minefield.getDamage()));
                    if (!this.game.getOptions().booleanOption("fire")) break;
                    IHex iHex = this.game.getBoard().getHex(coords2);
                    if (!iHex.containsTerrain(7)) {
                        report = new Report(3005);
                        report.subject = entity.getId();
                        report.add(coords2.getBoardNum(), true);
                        vector.add(report);
                        iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                    }
                    this.game.getBoard().addInfernoTo(coords2, InfernoTracker.STANDARD_ROUND, 1);
                    this.sendChangedHex(coords2);
                }
            }
        }
        return vector;
    }

    private Vector<Report> checkVibrabombs(Entity entity, Coords coords, boolean bl) {
        return this.checkVibrabombs(entity, coords, bl, null, null);
    }

    private Vector<Report> checkVibrabombs(Entity entity, Coords coords, boolean bl, Coords coords2, Coords coords3) {
        Vector<Report> vector = new Vector<Report>();
        if (!(entity instanceof Mech)) {
            return vector;
        }
        int n = (int)entity.getWeight();
        Enumeration<Minefield> enumeration = this.game.getVibrabombs().elements();
        while (enumeration.hasMoreElements()) {
            Report report;
            Minefield minefield = enumeration.nextElement();
            if (this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(4) && !this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(5) && !this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(20) || n <= minefield.getSetting() - 10) continue;
            int n2 = (n - minefield.getSetting()) / 10;
            int n3 = coords.distance(minefield.getCoords());
            if (n3 <= n2) {
                report = new Report(2156);
                report.subject = entity.getId();
                report.add(entity.getShortName(), true);
                report.add(minefield.getCoords().getBoardNum(), true);
                vector.add(report);
                this.explodeVibrabomb(minefield);
            }
            if (bl || n3 != 0) continue;
            report = new Report(2160);
            report.subject = entity.getId();
            report.add(entity.getShortName(), true);
            vector.add(report);
            HitData hitData = entity.rollHitLocation(2, 0);
            vector.addAll(this.damageEntity(entity, hitData, minefield.getDamage()));
            vector.addAll(this.resolvePilotingRolls(entity, true, coords2, coords3));
            entity.applyDamage();
        }
        return vector;
    }

    public void removeMinefieldsFrom(Coords coords) {
        Vector<Minefield> vector = this.game.getMinefields(coords);
        while (vector.elements().hasMoreElements()) {
            Minefield minefield = vector.elements().nextElement();
            this.removeMinefield(minefield);
        }
    }

    public void removeMinefield(Minefield minefield) {
        if (this.game.containsVibrabomb(minefield)) {
            this.game.removeVibrabomb(minefield);
        }
        this.game.removeMinefield(minefield);
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            this.removeMinefield(player, minefield);
        }
    }

    private void removeMinefield(Player player, Minefield minefield) {
        if (player.containsMinefield(minefield)) {
            player.removeMinefield(minefield);
            this.send(player.getId(), new Packet(410, minefield));
        }
    }

    private void revealMinefield(Minefield minefield) {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            this.revealMinefield(player, minefield);
        }
    }

    private void revealMinefield(Player player, Minefield minefield) {
        if (!player.containsMinefield(minefield)) {
            player.addMinefield(minefield);
            this.send(player.getId(), new Packet(400, minefield));
        }
    }

    private void explodeVibrabomb(Minefield minefield) {
        Enumeration<Entity> enumeration = this.game.getEntities(minefield.getCoords());
        while (enumeration.hasMoreElements()) {
            Report report;
            Entity entity = enumeration.nextElement();
            if (!entity.isDone() && this.game.getOptions().booleanOption("no_premove_vibra")) {
                report = new Report(2157);
                report.subject = entity.getId();
                report.add(entity.getShortName(), true);
                this.addReport(report);
                continue;
            }
            report = new Report(2160);
            report.subject = entity.getId();
            report.add(entity.getShortName(), true);
            this.addReport(report);
            if (minefield.getType() == 2) {
                HitData hitData = entity.rollHitLocation(2, 0);
                this.addReport(this.damageEntity(entity, hitData, minefield.getDamage()));
                this.addNewLines();
            } else if (minefield.getType() == 6) {
                int n = minefield.getDamage();
                HitData hitData = entity.rollHitLocation(2, 0);
                this.addReport(this.damageEntity(entity, hitData, n));
            }
            this.addReport(this.resolvePilotingRolls(entity, true, entity.getPosition(), entity.getPosition()));
            this.game.resetPSRs(entity);
            entity.applyDamage();
            this.addNewLines();
            this.entityUpdate(entity.getId());
        }
        if (!minefield.isOneUse()) {
            this.revealMinefield(minefield);
        } else {
            this.removeMinefield(minefield);
        }
    }

    private void drownSwarmer(Entity entity, Coords coords) {
        Entity entity2;
        int n = entity.getSwarmAttackerId();
        if (-1 != n && !((entity2 = this.game.getEntity(n)) instanceof BattleArmor)) {
            entity2.setSwarmTargetId(-1);
            entity.setSwarmAttackerId(-1);
            entity2.setPosition(coords);
            Report report = new Report(2165);
            report.subject = entity.getId();
            report.indent();
            report.add(entity.getShortName(), true);
            this.addReport(report);
            this.addReport(this.destroyEntity(entity2, "a watery grave", false));
            this.entityUpdate(n);
        }
    }

    void checkForWashedInfernos(Entity entity, Coords coords) {
        IHex iHex = this.game.getBoard().getHex(coords);
        int n = iHex.terrainLevel(4);
        if (!(entity instanceof Mech) || !entity.infernos.isStillBurning()) {
            return;
        }
        if (n > 0 && entity.absHeight() < 0) {
            this.washInferno(entity, coords);
        }
    }

    void washInferno(Entity entity, Coords coords) {
        this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, 1);
        entity.infernos.clear();
        IHex iHex = this.game.getBoard().getHex(coords);
        Report report = new Report(2170);
        report.subject = entity.getId();
        report.addDesc(entity);
        if (!iHex.containsTerrain(7) && this.game.getOptions().booleanOption("fire")) {
            report.messageId = 2175;
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
        }
        this.addReport(report);
        this.sendChangedHex(coords);
    }

    public void addMovementHeat() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (entity.getMovementMode() == 13 || entity.getMovementMode() == 14) {
                return;
            }
            if (entity.moved == 0) {
                entity.heatBuildup += entity.getStandingHeat();
                continue;
            }
            if (entity.moved == 1 || entity.moved == 4) {
                entity.heatBuildup += entity.getWalkHeat();
                continue;
            }
            if (entity.moved == 2 || entity.moved == 5 || entity.moved == -2) {
                entity.heatBuildup += entity.getRunHeat();
                continue;
            }
            if (entity.moved != 3) continue;
            entity.heatBuildup += entity.getJumpHeat(entity.delta_distance);
        }
    }

    public Vector<Report> doSetLocationsExposure(Entity entity, IHex iHex, boolean bl, int n) {
        Vector<Report> vector;
        block7: {
            block5: {
                block6: {
                    vector = new Vector<Report>();
                    if (iHex.terrainLevel(4) <= 0 || bl || n >= 0) break block5;
                    if (!(entity instanceof Mech) || entity.isProne() || iHex.terrainLevel(4) != 1) break block6;
                    for (int i = 0; i < entity.locations(); ++i) {
                        if (this.game.getOptions().booleanOption("vacuum")) {
                            entity.setLocationStatus(i, 1);
                            continue;
                        }
                        entity.setLocationStatus(i, 0);
                    }
                    entity.setLocationStatus(6, 2);
                    entity.setLocationStatus(7, 2);
                    vector.addAll(this.breachCheck(entity, 6, iHex));
                    vector.addAll(this.breachCheck(entity, 7, iHex));
                    if (!(entity instanceof QuadMech)) break block7;
                    entity.setLocationStatus(4, 2);
                    entity.setLocationStatus(5, 2);
                    vector.addAll(this.breachCheck(entity, 4, iHex));
                    vector.addAll(this.breachCheck(entity, 5, iHex));
                    break block7;
                }
                for (int i = 0; i < entity.locations(); ++i) {
                    entity.setLocationStatus(i, 2);
                    vector.addAll(this.breachCheck(entity, i, iHex));
                }
                break block7;
            }
            for (int i = 0; i < entity.locations(); ++i) {
                if (this.game.getOptions().booleanOption("vacuum")) {
                    entity.setLocationStatus(i, 1);
                    continue;
                }
                entity.setLocationStatus(i, 0);
            }
        }
        return vector;
    }

    private boolean doSkillCheckInPlace(Entity entity, PilotingRollData pilotingRollData) {
        boolean bl;
        if (pilotingRollData.getValue() == Integer.MIN_VALUE) {
            return true;
        }
        if (entity.isProne()) {
            return true;
        }
        Report report = new Report(2180);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(pilotingRollData.getLastPlainDesc(), true);
        this.addReport(report);
        int n = Compute.d6(2);
        report = new Report(2185);
        report.subject = entity.getId();
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n);
        if (n < pilotingRollData.getValue()) {
            report.choose(false);
            this.addReport(report);
            this.addReport(this.doEntityFall(entity, pilotingRollData));
            bl = false;
        } else {
            report.choose(true);
            this.addReport(report);
            bl = true;
        }
        return bl;
    }

    private boolean doDislodgeSwarmerSkillCheck(Entity entity, PilotingRollData pilotingRollData, Coords coords) {
        Report report = new Report(2180);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(pilotingRollData.getLastPlainDesc(), true);
        this.addReport(report);
        int n = Compute.d6(2);
        report = new Report(2190);
        report.subject = entity.getId();
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n);
        if (n < pilotingRollData.getValue()) {
            report.choose(false);
            this.addReport(report);
            return false;
        }
        int n2 = entity.getSwarmAttackerId();
        Entity entity2 = this.game.getEntity(n2);
        if (!entity2.isDone()) {
            entity2.setDone(true);
            this.game.removeTurnFor(entity2);
            this.send(this.createTurnVectorPacket());
        }
        report.choose(true);
        this.addReport(report);
        entity.setPosition(coords);
        this.addReport(this.doEntityFallsInto(entity, coords, coords, pilotingRollData, false));
        return true;
    }

    private int doSkillCheckWhileMoving(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData, boolean bl) {
        boolean bl2;
        Report report = new Report(1210);
        report.subject = entity.getId();
        report.addDesc(entity);
        if (coords.equals(coords2)) {
            bl2 = true;
            report.messageId = 2195;
            report.add(coords.getBoardNum(), true);
        } else {
            bl2 = false;
            report.messageId = 2200;
            report.add(coords.getBoardNum(), true);
            report.add(coords2.getBoardNum(), true);
        }
        report.add(pilotingRollData.getLastPlainDesc(), true);
        this.addReport(report);
        int n = Compute.d6(2);
        report = new Report(2185);
        report.subject = entity.getId();
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n);
        if (n < pilotingRollData.getValue()) {
            if (bl) {
                report.choose(false);
                this.addReport(report);
                this.addReport(this.doEntityFallsInto(entity, bl2 ? coords2 : coords, bl2 ? coords : coords2, pilotingRollData));
            } else {
                report.messageId = 2190;
                report.choose(false);
                this.addReport(report);
                entity.setPosition(bl2 ? coords : coords2);
            }
            return pilotingRollData.getValue() - n;
        }
        report.choose(true);
        this.addReport(report);
        return 0;
    }

    private Vector<Report> doEntityFallsInto(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData) {
        return this.doEntityFallsInto(entity, coords, coords2, pilotingRollData, true);
    }

    private Vector<Report> doEntityFallsInto(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData, boolean bl) {
        Vector<Report> vector = new Vector<Report>();
        IHex iHex = this.game.getBoard().getHex(coords);
        IHex iHex2 = this.game.getBoard().getHex(coords2);
        int n = entity.getElevation() + iHex.depth();
        int n2 = Math.max(0, iHex.floor() + n - (iHex2.containsTerrain(20) ? iHex2.surface() : iHex2.floor()));
        int n3 = coords.equals(coords2) ? Compute.d6() - 1 : coords.direction(coords2);
        Entity entity2 = this.game.getAffaTarget(coords2, entity);
        Report report = new Report(2205);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(n2);
        report.add(coords2.getBoardNum(), true);
        vector.add(report);
        if (entity2 == null) {
            vector.addAll(this.doEntityFall(entity, coords2, n2, pilotingRollData));
            return vector;
        }
        if (n2 >= 2 && bl) {
            report = new Report(2210);
            report.subject = entity.getId();
            report.addDesc(entity2);
            vector.add(report);
            ToHitData toHitData = new ToHitData(7, "base");
            if (entity2 instanceof Tank) {
                toHitData = new ToHitData(Integer.MIN_VALUE, "Target is a Tank");
            } else {
                toHitData.append(Compute.getTargetMovementModifier(this.game, entity2.getId()));
                toHitData.append(Compute.getTargetTerrainModifier(this.game, entity2));
            }
            if (toHitData.getValue() != 0x7FFFFFFE) {
                int n4 = Compute.d6(2);
                if (toHitData.getValue() == Integer.MIN_VALUE) {
                    report = new Report(2212);
                    report.add(toHitData.getValue());
                    report.indent();
                } else {
                    report = new Report(2215);
                    report.subject = entity.getId();
                    report.add(toHitData.getValue());
                    report.add(n4);
                    report.newlines = 0;
                    report.indent();
                }
                vector.add(report);
                if (n4 >= toHitData.getValue()) {
                    Object object;
                    int n5;
                    int n6;
                    report = new Report(2220);
                    report.subject = entity2.getId();
                    report.addDesc(entity2);
                    report.add(n6);
                    vector.add(report);
                    for (n6 = Compute.getAffaDamageFor(entity); n6 > 0; n6 -= n5) {
                        n5 = Math.min(5, n6);
                        object = entity2.rollHitLocation(1, 0);
                        ((HitData)object).setGeneralDamageType(-2);
                        vector.addAll(this.damageEntity(entity2, (HitData)object, n5));
                    }
                    PilotingRollData pilotingRollData2 = entity.getBasePilotingRoll();
                    pilotingRollData2.append(pilotingRollData);
                    entity.addPilotingModifierForTerrain(pilotingRollData2, coords2);
                    vector.addAll(this.doEntityFall(entity, coords2, n2, 3, pilotingRollData2));
                    vector.addAll(this.doEntityDisplacementMinefieldCheck(entity, coords, coords2));
                    object = Compute.stackingViolation(this.game, entity.getId(), coords2);
                    if (object != null) {
                        Coords coords3 = Compute.getValidDisplacement(this.game, ((Entity)object).getId(), coords2, n3);
                        if (coords3 != null) {
                            vector.addAll(this.doEntityDisplacement(entity2, coords2, coords3, new PilotingRollData(((Entity)object).getId(), 2, "fallen on")));
                            this.entityUpdate(entity2.getId());
                        } else {
                            vector.addAll(this.destroyEntity(entity2, "impossible displacement", object instanceof Mech, object instanceof Mech));
                        }
                    }
                    return vector;
                }
            } else {
                report = new Report(2213);
                report.add(toHitData.getDesc());
                vector.add(report);
            }
            Coords coords4 = Compute.getValidDisplacement(this.game, entity.getId(), coords2, n3);
            if (coords4 != null) {
                vector.addAll(this.doEntityFallsInto(entity, coords, coords4, new PilotingRollData(entity.getId(), Integer.MAX_VALUE, "pushed off a cliff"), false));
                this.entityUpdate(entity.getId());
            } else {
                vector.addAll(this.destroyEntity(entity, "impossible displacement", entity instanceof Mech, entity instanceof Mech));
            }
        } else {
            vector.addAll(this.doEntityFall(entity, coords2, n2, pilotingRollData));
            Entity entity3 = Compute.stackingViolation(this.game, entity.getId(), coords2);
            if (entity3 != null) {
                Coords coords5 = Compute.getValidDisplacement(this.game, entity.getId(), coords2, n3);
                vector.addAll(this.doEntityDisplacement(entity3, coords2, coords5, new PilotingRollData(entity3.getId(), 0, "domino effect")));
                this.entityUpdate(entity3.getId());
            }
        }
        return vector;
    }

    private Vector<Report> doEntityDisplacement(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData) {
        Entity entity2;
        Vector<Report> vector = new Vector<Report>();
        if (!this.game.getBoard().contains(coords2)) {
            entity.setPosition(coords2);
            if (!entity.isDoomed()) {
                this.game.removeEntity(entity.getId(), 272);
                this.send(this.createRemoveEntityPacket(entity.getId(), 272));
                Report report = new Report(2230);
                report.subject = entity.getId();
                report.addDesc(entity);
                vector.add(report);
            }
            return vector;
        }
        IHex iHex = this.game.getBoard().getHex(coords);
        IHex iHex2 = this.game.getBoard().getHex(coords2);
        int n = coords.direction(coords2);
        if (iHex == null || iHex2 == null) {
            System.err.println("Can not displace " + entity.getShortName() + " from " + coords + " to " + coords2 + '.');
            return vector;
        }
        int n2 = entity.elevationOccupied(iHex) - entity.elevationOccupied(iHex2);
        if (n2 > 1) {
            if (pilotingRollData == null) {
                pilotingRollData = entity.getBasePilotingRoll();
            }
            vector.addAll(this.doEntityFallsInto(entity, coords, coords2, pilotingRollData));
            return vector;
        }
        entity.setStuck(false);
        entity.setPosition(coords2);
        entity.setElevation(entity.elevationOccupied(iHex2) - iHex2.surface());
        Building building = this.game.getBoard().getBuildingAt(coords2);
        if (building != null) {
            this.passBuildingWall(entity, this.game.getBoard().getBuildingAt(coords2), coords, coords2, 1, "displaced into", Math.abs(entity.getFacing() - coords.direction(coords2)) == 3);
        }
        if ((entity2 = Compute.stackingViolation(this.game, entity.getId(), coords2)) == null) {
            Report report = new Report(2235);
            report.indent();
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(coords2.getBoardNum(), true);
            vector.add(report);
        } else {
            Report report = new Report(2240);
            report.indent();
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(coords2.getBoardNum(), true);
            report.addDesc(entity2);
            vector.add(report);
        }
        vector.addAll(this.doEntityDisplacementMinefieldCheck(entity, coords, coords2));
        vector.addAll(this.doSetLocationsExposure(entity, iHex2, false, entity.getElevation()));
        if (pilotingRollData != null) {
            this.game.addPSR(pilotingRollData);
        }
        this.entityUpdate(entity.getId());
        if (entity2 != null) {
            vector.addAll(this.doEntityDisplacement(entity2, coords2, coords2.translated(n), new PilotingRollData(entity2.getId(), 0, "domino effect")));
            if (!this.game.isOutOfGame(entity2)) {
                this.entityUpdate(entity2.getId());
            }
        }
        return vector;
    }

    private Vector<Report> doEntityDisplacementMinefieldCheck(Entity entity, Coords coords, Coords coords2) {
        Vector<Report> vector = new Vector<Report>();
        if (this.game.containsMinefield(coords2)) {
            Enumeration<Minefield> enumeration = this.game.getMinefields(coords2).elements();
            while (enumeration.hasMoreElements()) {
                Minefield minefield = enumeration.nextElement();
                vector.addAll(this.enterMinefield(entity, minefield, coords, coords2, false));
            }
        }
        vector.addAll(this.checkVibrabombs(entity, coords2, true));
        return vector;
    }

    private void receiveDeployment(Packet packet, int n) {
        int n2;
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        Coords coords = (Coords)packet.getObject(1);
        int n3 = packet.getIntValue(2);
        int n4 = packet.getIntValue(3);
        Vector<Entity> vector = new Vector<Entity>();
        for (n2 = 0; n2 < n4; ++n2) {
            int n5 = packet.getIntValue(5 + n2);
            vector.addElement(this.game.getEntity(n5));
        }
        if (this.game.getPhase() != IGame.Phase.PHASE_DEPLOYMENT) {
            System.err.println("error: server got deployment packet in wrong phase");
            return;
        }
        n2 = packet.getBooleanValue(4) ? 1 : 0;
        if (!(this.game.getTurn().isValid(n, entity, this.game) && (this.game.getBoard().isLegalDeployment(coords, entity.getOwner()) || n2 != 0 && this.game.getOptions().booleanOption("assault_drop") && entity.canAssaultDrop()))) {
            System.err.println("error: server got invalid deployment packet");
            return;
        }
        this.processDeployment(entity, coords, n3, vector, n2 != 0);
        if (this.doBlind()) {
            this.updateVisibilityIndicator();
        }
        this.endCurrentTurn(entity);
    }

    private void processDeployment(Entity entity, Coords coords, int n, Vector<Entity> vector, boolean bl) {
        Serializable serializable;
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            serializable = object.nextElement();
            if (serializable == null || ((Entity)serializable).getPosition() != null || ((Entity)serializable).getTransportId() != -1) {
                System.err.println("error: " + entity + " can not load entity #" + serializable);
                break;
            }
            this.loadUnit(entity, (Entity)serializable);
        }
        entity.setPosition(coords);
        entity.setFacing(n);
        entity.setSecondaryFacing(n);
        object = this.game.getBoard().getHex(coords);
        if (bl) {
            entity.setElevation(object.ceiling() - object.surface() + 100);
            entity.setAssaultDropInProgress(true);
        } else if (entity instanceof VTOL) {
            entity.setElevation(object.ceiling() - object.surface() + 1);
            while (Compute.stackingViolation(this.game, entity, coords, null) != null && entity.getElevation() <= 50) {
                entity.setElevation(entity.getElevation() + 1);
            }
            if (entity.getElevation() > 50) {
                throw new IllegalStateException("Entity #" + entity.getId() + " appears to be in an infinite loop trying to get a legal elevation.");
            }
        } else if (entity.getMovementMode() == 9) {
            entity.setElevation(0);
        } else if (entity.getMovementMode() == 5 || entity.getMovementMode() == 15 || entity.getMovementMode() == 7 || entity.getMovementMode() == 8) {
            entity.setElevation(0);
        } else if (object.containsTerrain(20)) {
            entity.setElevation(0);
        } else if (object.containsTerrain(14)) {
            entity.setElevation(object.terrainLevel(16));
        } else {
            serializable = this.game.getBoard().getBuildingAt(entity.getPosition());
            if (serializable != null && ((Building)serializable).getType() == 5) {
                entity.setElevation(object.terrainLevel(12));
            } else {
                entity.setElevation(object.floor() - object.surface());
            }
        }
        entity.setDone(true);
        entity.setDeployed(true);
        this.entityUpdate(entity.getId());
    }

    private void receiveArtyAutoHitHexes(Packet packet, int n) {
        PlayerIDandList playerIDandList = (PlayerIDandList)packet.getObject(0);
        int n2 = playerIDandList.getPlayerID();
        if (this.game.getPhase() != IGame.Phase.PHASE_SET_ARTYAUTOHITHEXES) {
            System.err.println("error: server got set artyautohithexespacket in wrong phase");
            return;
        }
        this.game.getPlayer(n2).setArtyAutoHitHexes(playerIDandList);
        for (Coords coords : playerIDandList) {
            this.game.getBoard().addSpecialHexDisplay(coords, new SpecialHexDisplay(SpecialHexDisplay.Type.ARTILLERY_AUTOHIT, SpecialHexDisplay.NO_ROUND, this.getPlayer(n2).getName(), "ArtyAutoHit Hex, better text later"));
        }
        this.endCurrentTurn(null);
    }

    private void receiveDeployMinefields(Packet packet, int n) {
        Vector vector = (Vector)packet.getObject(0);
        if (this.game.getPhase() != IGame.Phase.PHASE_DEPLOY_MINEFIELDS) {
            System.err.println("error: server got deploy minefields packet in wrong phase");
            return;
        }
        this.processDeployMinefields(vector);
        this.endCurrentTurn(null);
    }

    private void processDeployMinefields(Vector<Minefield> vector) {
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            Minefield minefield = vector.elementAt(i);
            n = minefield.getPlayerId();
            this.game.addMinefield(minefield);
            if (minefield.getType() != 2) continue;
            this.game.addVibrabomb(minefield);
        }
        Player player = this.game.getPlayer(n);
        if (null != player) {
            int n2 = player.getTeam();
            if (n2 != 0) {
                Enumeration<Team> enumeration = this.game.getTeams();
                while (enumeration.hasMoreElements()) {
                    Team team = enumeration.nextElement();
                    if (team.getId() != n2) continue;
                    Enumeration<Player> enumeration2 = team.getPlayers();
                    while (enumeration2.hasMoreElements()) {
                        Player player2 = enumeration2.nextElement();
                        if (player2.getId() != player.getId()) {
                            this.send(player2.getId(), new Packet(390, vector));
                        }
                        player2.addMinefields(vector);
                    }
                    break;
                }
            } else {
                player.addMinefields(vector);
            }
        }
    }

    private void receiveAttack(Packet packet, int n) {
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        Vector vector = (Vector)packet.getObject(1);
        if (this.game.getPhase() != IGame.Phase.PHASE_FIRING && this.game.getPhase() != IGame.Phase.PHASE_PHYSICAL && this.game.getPhase() != IGame.Phase.PHASE_TARGETING && this.game.getPhase() != IGame.Phase.PHASE_OFFBOARD) {
            System.err.println("error: server got attack packet in wrong phase");
            return;
        }
        if (!this.game.getTurn().isValid(n, entity, this.game)) {
            System.err.println("error: server got invalid attack packet");
            return;
        }
        this.processAttack(entity, vector);
        if (this.doBlind()) {
            this.updateVisibilityIndicator();
        }
        this.endCurrentTurn(entity);
    }

    private void processAttack(Entity entity, Vector<EntityAction> vector) {
        boolean bl = !(this.game.getTurn() instanceof GameTurn.TriggerAPPodTurn);
        Enumeration<EntityAction> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity2;
            AbstractAttackAction abstractAttackAction;
            Object object;
            EntityAction entityAction = enumeration.nextElement();
            if (entityAction.getEntityId() != entity.getId()) {
                System.err.println("error: attack packet has wrong attacker");
                continue;
            }
            if (entityAction instanceof WeaponAttackAction && ("SwarmMek".equals(object = entity.getEquipment(((WeaponAttackAction)(abstractAttackAction = (WeaponAttackAction)entityAction)).getWeaponId()).getType().getInternalName()) || "LegAttack".equals(object))) {
                entity2 = this.game.getEntity(abstractAttackAction.getTargetId());
                for (Mounted mounted : entity2.getMisc()) {
                    if (!mounted.getType().hasFlag(0x2000000L) || !mounted.canFire()) continue;
                    this.game.insertNextTurn(new GameTurn.TriggerAPPodTurn(entity2.getOwnerId(), entity2.getId()));
                    this.send(this.createTurnVectorPacket());
                    break;
                }
            }
            if (entityAction instanceof BreakGrappleAttackAction && ((Mech)(object = (Mech)this.game.getEntity((abstractAttackAction = (BreakGrappleAttackAction)entityAction).getEntityId()))).isGrappleAttacker()) {
                entity2 = (Mech)this.game.getEntity(abstractAttackAction.getTargetId());
                if (entity2.isDone()) {
                    this.game.removeActionsFor(entity2.getId());
                } else {
                    this.game.removeTurnFor(entity2);
                    entity2.setDone(true);
                }
                this.game.insertNextTurn(new GameTurn.CounterGrappleTurn(entity2.getOwnerId(), entity2.getId()));
                this.send(this.createTurnVectorPacket());
            }
            if (entityAction instanceof ArtilleryAttackAction) {
                boolean bl2 = false;
                object = (ArtilleryAttackAction)entityAction;
                entity2 = this.game.getEntity(((AbstractEntityAction)object).getEntityId());
                Enumeration<AttackHandler> enumeration2 = this.game.getAttacks();
                while (!bl2 && enumeration2.hasMoreElements()) {
                    Object object2;
                    WeaponHandler weaponHandler = (WeaponHandler)enumeration2.nextElement();
                    if (weaponHandler.waa instanceof ArtilleryAttackAction && ((AbstractEntityAction)(object2 = (ArtilleryAttackAction)weaponHandler.waa)).getEntityId() == ((AbstractEntityAction)object).getEntityId() && !((AbstractAttackAction)object2).getTarget(this.game).getPosition().equals(((AbstractAttackAction)object).getTarget(this.game).getPosition())) {
                        bl2 = true;
                    }
                    if (bl2) {
                        this.clearArtillerySpotters(entity2.getId(), ((WeaponAttackAction)object).getWeaponId());
                    }
                    object2 = this.game.getSelectedEntities(new EntitySelector((ArtilleryAttackAction)object){
                        public int player;
                        public Targetable target;
                        final /* synthetic */ ArtilleryAttackAction val$aaa;
                        {
                            this.val$aaa = artilleryAttackAction;
                            this.player = entity2.getOwnerId();
                            this.target = this.val$aaa.getTarget(Server.this.game);
                        }

                        public boolean accept(Entity entity) {
                            return this.player == entity.getOwnerId() && !LosEffects.calculateLos(Server.this.game, entity.getId(), this.target).isBlocked() && entity.isActive();
                        }
                    });
                    Vector<Integer> vector2 = new Vector<Integer>();
                    while (object2.hasMoreElements()) {
                        Integer n = new Integer(((Entity)object2.nextElement()).getId());
                        vector2.addElement(n);
                    }
                    ((ArtilleryAttackAction)object).setSpotterIds(vector2);
                }
            }
            if (entityAction instanceof ClubAttackAction) {
                ClubAttackAction clubAttackAction = (ClubAttackAction)entityAction;
                object = clubAttackAction.getClub();
                ((Mounted)object).restore();
            }
            if (entityAction instanceof PushAttackAction) {
                PushAttackAction pushAttackAction = (PushAttackAction)entityAction;
                entity.setDisplacementAttack(pushAttackAction);
                this.game.addCharge(pushAttackAction);
            } else if (entityAction instanceof DodgeAction) {
                entity.dodging = true;
            } else if (entityAction instanceof SpotAction) {
                entity.setSpotting(true);
                entity.setSpotTargetId(((SpotAction)entityAction).getTargetId());
            } else {
                this.game.addAction(entityAction);
            }
            if (!(entityAction instanceof TriggerAPPodAction)) continue;
            TriggerAPPodAction triggerAPPodAction = (TriggerAPPodAction)entityAction;
            object = entity.getEquipment(triggerAPPodAction.getPodId());
            ((Mounted)object).setUsedThisRound(true);
        }
        if (bl) {
            entity.setDone(true);
        }
        this.entityUpdate(entity.getId());
        this.send(this.createAttackPacket(vector, 0));
    }

    private void assignAMS() {
        Serializable serializable;
        Hashtable<Entity, Vector<WeaponHandler>> hashtable = new Hashtable<Entity, Vector<WeaponHandler>>();
        for (AttackHandler object : this.game.getAttacksVector()) {
            serializable = (WeaponHandler)object;
            WeaponAttackAction weaponAttackAction = serializable.waa;
            if (weaponAttackAction instanceof ArtilleryAttackAction) continue;
            Mounted mounted = this.game.getEntity(weaponAttackAction.getEntityId()).getEquipment(weaponAttackAction.getWeaponId());
            if (0 != weaponAttackAction.getTargetType() || serializable.roll < serializable.toHit.getValue() || ((WeaponType)mounted.getType()).getDamage() != -2) continue;
            Entity entity = this.game.getEntity(weaponAttackAction.getTargetId());
            Vector<WeaponHandler> vector = (Vector<WeaponHandler>)hashtable.get(entity);
            if (vector == null) {
                vector = new Vector<WeaponHandler>();
                hashtable.put(entity, vector);
            }
            vector.addElement((WeaponHandler)serializable);
        }
        for (Entity entity : hashtable.keySet()) {
            serializable = (Vector)hashtable.get(entity);
            entity.assignAMS((Vector<WeaponHandler>)serializable);
        }
    }

    private void resolveAllButWeaponAttacks() {
        Serializable serializable;
        RoundUpdated roundUpdated;
        Object object;
        Object object2;
        Object object3;
        if (this.game.getPhase() == IGame.Phase.PHASE_FIRING) {
            this.addReport(new Report(3000, 0));
            object3 = this.game.getLayMinefieldActions();
            while (object3.hasMoreElements()) {
                object2 = (LayMinefieldAction)object3.nextElement();
                object = this.game.getEntity(((AbstractEntityAction)object2).getEntityId());
                roundUpdated = ((Entity)object).getEquipment(((LayMinefieldAction)object2).getMineId());
                if (((Mounted)roundUpdated).isMissing()) continue;
                switch (((Mounted)roundUpdated).getMineType()) {
                    case 0: {
                        this.deliverThunderMinefield(((Entity)object).getPosition(), ((Entity)object).getOwnerId(), 10);
                        ((Mounted)roundUpdated).setMissing(true);
                        serializable = new Report(3500);
                        ((Report)serializable).subject = ((Entity)object).getId();
                        ((Report)serializable).addDesc((Entity)object);
                        ((Report)serializable).add(((Entity)object).getPosition().getBoardNum());
                        this.addReport((Report)serializable);
                        break;
                    }
                    case 1: {
                        this.deliverThunderVibraMinefield(((Entity)object).getPosition(), ((Entity)object).getOwnerId(), 10, ((Mounted)roundUpdated).getVibraSetting());
                        ((Mounted)roundUpdated).setMissing(true);
                        serializable = new Report(3505);
                        ((Report)serializable).subject = ((Entity)object).getId();
                        ((Report)serializable).addDesc((Entity)object);
                        ((Report)serializable).add(((Entity)object).getPosition().getBoardNum());
                        this.addReport((Report)serializable);
                    }
                }
            }
            this.game.resetLayMinefieldActions();
        }
        serializable = new Vector<Entity>();
        object3 = new Vector();
        object2 = this.game.getActions();
        while (object2.hasMoreElements()) {
            Serializable serializable2;
            object = object2.nextElement();
            roundUpdated = this.game.getEntity(object.getEntityId());
            if (object instanceof TorsoTwistAction) {
                serializable2 = (TorsoTwistAction)object;
                if (!((Entity)roundUpdated).canChangeSecondaryFacing()) continue;
                ((Entity)roundUpdated).setSecondaryFacing(((TorsoTwistAction)serializable2).getFacing());
                continue;
            }
            if (object instanceof FlipArmsAction) {
                serializable2 = (FlipArmsAction)object;
                ((Entity)roundUpdated).setArmsFlipped(((FlipArmsAction)serializable2).getIsFlipped());
                continue;
            }
            if (object instanceof FindClubAction) {
                this.resolveFindClub((Entity)roundUpdated);
                continue;
            }
            if (object instanceof UnjamAction) {
                this.resolveUnjam((Entity)roundUpdated);
                continue;
            }
            if (object instanceof ClearMinefieldAction) {
                ((Vector)serializable).addElement((Entity)roundUpdated);
                continue;
            }
            if (object instanceof TriggerAPPodAction) {
                serializable2 = (TriggerAPPodAction)object;
                if (!((Vector)object3).contains(serializable2)) {
                    this.triggerAPPod((Entity)roundUpdated, ((TriggerAPPodAction)serializable2).getPodId());
                    ((Vector)object3).addElement(serializable2);
                    continue;
                }
                System.err.print("AP Pod #");
                System.err.print(((TriggerAPPodAction)serializable2).getPodId());
                System.err.print(" on ");
                System.err.print(((Entity)roundUpdated).getDisplayName());
                System.err.println(" was already triggered this round!!");
                continue;
            }
            if (object instanceof SearchlightAttackAction) {
                serializable2 = (SearchlightAttackAction)object;
                this.addReport(((SearchlightAttackAction)serializable2).resolveAction(this.game));
                continue;
            }
            if (object instanceof UnjamTurretAction) {
                if (roundUpdated instanceof Tank) {
                    ((Tank)roundUpdated).unjamTurret();
                    serializable2 = new Report(3033);
                    ((Report)serializable2).addDesc((Entity)roundUpdated);
                    this.addReport((Report)serializable2);
                    continue;
                }
                System.err.println("Non-Tank tried to unjam turret");
                continue;
            }
            if (!(object instanceof RepairWeaponMalfunctionAction)) continue;
            if (roundUpdated instanceof Tank) {
                serializable2 = ((Entity)roundUpdated).getEquipment(((RepairWeaponMalfunctionAction)object).getWeaponId());
                ((Mounted)serializable2).setJammed(false);
                ((Tank)roundUpdated).getJammedWeapons().remove(serializable2);
                Report report = new Report(3034);
                report.addDesc((Entity)roundUpdated);
                report.add(((Mounted)serializable2).getName());
                this.addReport(report);
                continue;
            }
            System.err.println("Non-Tank tried to repair weapon malfunction");
        }
        this.resolveClearMinefieldAttempts((Vector<Entity>)serializable);
    }

    private void resolveClearMinefieldAttempts(Vector<Entity> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            int n;
            Serializable serializable;
            int n2;
            Vector<Entity> vector2 = new Vector<Entity>();
            Entity entity = vector.elementAt(i);
            Coords coords = entity.getPosition();
            vector2.addElement(entity);
            for (n2 = i + 1; n2 < vector.size(); ++n2) {
                Entity entity2 = vector.elementAt(n2);
                if (!entity2.getPosition().equals(coords)) continue;
                vector2.addElement(entity2);
                vector.removeElement(entity2);
            }
            n2 = 0;
            boolean bl = false;
            for (int j = 0; j < vector2.size(); ++j) {
                serializable = (Entity)vector2.elementAt(j);
                n = Compute.d6(2);
                int n3 = 10;
                int n4 = 5;
                for (Mounted mounted : ((Entity)serializable).getMisc()) {
                    if (!mounted.getType().hasFlag(0x100000L) || !mounted.getType().hasSubType(8)) continue;
                    int n5 = mounted.getType().getToHitModifier();
                    n3 = Minefield.CLEAR_NUMBER_SWEEPER[n5];
                    n4 = Minefield.CLEAR_NUMBER_SWEEPER_ACCIDENT[n5];
                    break;
                }
                object = new Report(2245);
                ((Report)object).subject = ((Entity)serializable).getId();
                ((Report)object).add(((Entity)serializable).getShortName(), true);
                ((Report)object).add(coords.getBoardNum(), true);
                ((Report)object).add(n3);
                ((Report)object).add(n);
                ((Report)object).newlines = 0;
                this.addReport((Report)object);
                if (n >= n3) {
                    object = new Report(2250);
                    ((Report)object).subject = ((Entity)serializable).getId();
                    this.addReport((Report)object);
                    bl = true;
                    continue;
                }
                if (n <= n4) {
                    object = new Report(2255);
                    ((Report)object).subject = ((Entity)serializable).getId();
                    this.addReport((Report)object);
                    n2 = 1;
                    continue;
                }
                object = new Report(2260);
                ((Report)object).subject = ((Entity)serializable).getId();
                this.addReport((Report)object);
            }
            if (n2 != 0) {
                Enumeration<Minefield> enumeration = this.game.getMinefields(coords).elements();
                block8: while (enumeration.hasMoreElements()) {
                    serializable = enumeration.nextElement();
                    switch (((Minefield)serializable).getType()) {
                        case 0: 
                        case 3: {
                            for (n = 0; n < vector2.size(); ++n) {
                                Entity entity3 = (Entity)vector2.elementAt(n);
                                Report report = new Report(2265);
                                report.subject = entity3.getId();
                                report.add(entity3.getShortName(), true);
                                this.addReport(report);
                                object = entity3.rollHitLocation(2, 0);
                                this.addReport(this.damageEntity(entity3, (HitData)object, ((Minefield)serializable).getDamage()));
                                this.addNewLines();
                            }
                            continue block8;
                        }
                        case 2: {
                            this.explodeVibrabomb((Minefield)serializable);
                        }
                    }
                }
            }
            if (!bl) continue;
            this.removeMinefieldsFrom(coords);
        }
    }

    private void resolveOnlyWeaponAttacks() {
        Enumeration<EntityAction> enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            WeaponAttackAction weaponAttackAction;
            Entity entity;
            Mounted mounted;
            Weapon weapon;
            AttackHandler attackHandler;
            EntityAction entityAction = enumeration.nextElement();
            if (!(entityAction instanceof WeaponAttackAction) || (attackHandler = (weapon = (Weapon)(mounted = (entity = this.game.getEntity((weaponAttackAction = (WeaponAttackAction)entityAction).getEntityId())).getEquipment(weaponAttackAction.getWeaponId())).getType()).fire(weaponAttackAction, this.game, this)) == null) continue;
            this.game.addAttack(attackHandler);
        }
        this.game.resetActions();
    }

    private void triggerAPPod(Entity entity, int n) {
        Mounted mounted = entity.getEquipment(n);
        if (null == mounted) {
            System.err.print("Expecting to find an AP Pod at ");
            System.err.print(n);
            System.err.print(" on the unit, ");
            System.err.print(entity.getDisplayName());
            System.err.println(" but found NO equipment at all!!!");
            return;
        }
        EquipmentType equipmentType = mounted.getType();
        if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x2000000L)) {
            System.err.print("Expecting to find an AP Pod at ");
            System.err.print(n);
            System.err.print(" on the unit, ");
            System.err.print(entity.getDisplayName());
            System.err.print(" but found ");
            System.err.print(equipmentType.getName());
            System.err.println(" instead!!!");
            return;
        }
        boolean bl = mounted.isUsedThisRound();
        mounted.setUsedThisRound(false);
        boolean bl2 = mounted.canFire();
        mounted.setUsedThisRound(bl);
        if (!bl2) {
            System.err.print("Can not trigger the AP Pod at ");
            System.err.print(n);
            System.err.print(" on the unit, ");
            System.err.print(entity.getDisplayName());
            System.err.println("!!!");
            return;
        }
        mounted.setFired(true);
        Report report = new Report(3010);
        report.newlines = 0;
        report.subject = entity.getId();
        report.addDesc(entity);
        this.addReport(report);
        Enumeration<Entity> enumeration = this.game.getEntities(entity.getPosition());
        while (enumeration.hasMoreElements()) {
            Entity entity2 = enumeration.nextElement();
            if (entity2 instanceof Infantry && !(entity2 instanceof BattleArmor)) {
                int n2 = Math.min(1, Compute.d6() - 1);
                this.addReport(this.damageEntity(entity2, new HitData(0), n2));
                entity2.applyDamage();
                continue;
            }
            if (entity.equals(entity2)) continue;
            report = new Report(3020);
            report.indent(2);
            report.subject = entity2.getId();
            report.addDesc(entity2);
            this.addReport(report);
        }
    }

    private void resolveUnjam(Entity entity) {
        int n = entity.getCrew().getGunnery() + 3;
        Report report = new Report(3025);
        report.subject = entity.getId();
        report.addDesc(entity);
        this.addReport(report);
        for (Mounted mounted : entity.getWeaponList()) {
            WeaponType weaponType;
            if (!mounted.isJammed() || (weaponType = (WeaponType)mounted.getType()).getAmmoType() != 23) continue;
            int n2 = Compute.d6(2);
            report = new Report(3030);
            report.indent();
            report.subject = entity.getId();
            report.add(weaponType.getName());
            report.add(n);
            report.add(n2);
            if (n2 >= n) {
                report.choose(true);
                mounted.setJammed(false);
            } else {
                report.choose(false);
            }
            this.addReport(report);
        }
    }

    private void resolveFindClub(Entity entity) {
        Report report;
        EquipmentType equipmentType = null;
        entity.setFindingClub(true);
        Coords coords = entity.getPosition();
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex.terrainLevel(18) > 0) {
            equipmentType = EquipmentType.get("Limb Club");
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(18, iHex.terrainLevel(18) - 1));
            this.sendChangedHex(entity.getPosition());
            report = new Report(3035);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        } else if (iHex.terrainLevel(19) > 0) {
            equipmentType = EquipmentType.get("Limb Club");
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(19, iHex.terrainLevel(19) - 1));
            this.sendChangedHex(entity.getPosition());
            report = new Report(3040);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        } else if (1 < iHex.terrainLevel(3)) {
            boolean bl = false;
            int n = Compute.d6(2);
            switch (iHex.terrainLevel(3)) {
                case 2: {
                    if (n < 7) break;
                    bl = true;
                    break;
                }
                case 3: {
                    if (n < 6) break;
                    bl = true;
                    break;
                }
                case 4: {
                    if (n < 5) break;
                    bl = true;
                    break;
                }
                case 5: {
                    if (n < 13) break;
                    bl = true;
                }
            }
            if (bl) {
                equipmentType = EquipmentType.get("Girder Club");
                report = new Report(3045);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
            } else {
                report = new Report(3050);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
            }
        } else if (iHex.containsTerrain(1) || iHex.containsTerrain(23)) {
            equipmentType = EquipmentType.get("Tree Club");
            report = new Report(3055);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        try {
            if (equipmentType != null) {
                entity.addEquipment(equipmentType, -1);
            }
        }
        catch (LocationFullException locationFullException) {
            report = new Report(3060);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
    }

    public boolean tryIgniteHex(Coords coords, int n, boolean bl, int n2, boolean bl2, Vector<Report> vector) {
        IHex iHex = this.game.getBoard().getHex(coords);
        boolean bl3 = false;
        if (iHex == null) {
            return false;
        }
        if (!this.game.getOptions().booleanOption("fire")) {
            return false;
        }
        if (bl && !this.game.getOptions().booleanOption("no_ignite_clear")) {
            this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, 1);
            n2 = 0;
            bl3 = true;
        }
        if (iHex.containsTerrain(7)) {
            if (bl2) {
                Report report = new Report(3065);
                report.indent(2);
                report.subject = n;
                vector.add(report);
            }
            return true;
        }
        if (this.ignite(iHex, n2, bl3, n)) {
            Report report = new Report(3070);
            report.indent(2);
            report.subject = n;
            vector.add(report);
            this.sendChangedHex(coords);
            return true;
        }
        return false;
    }

    public boolean tryIgniteHex(Coords coords, int n, boolean bl, int n2, Vector<Report> vector) {
        return this.tryIgniteHex(coords, n, bl, n2, false, vector);
    }

    public Vector<Report> tryClearHex(Coords coords, int n, int n2) {
        Report report;
        int n3;
        int n4;
        Vector<Report> vector = new Vector<Report>();
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex == null) {
            return vector;
        }
        ITerrain iTerrain = iHex.getTerrain(1);
        ITerrain iTerrain2 = iHex.getTerrain(23);
        ITerrain iTerrain3 = iHex.getTerrain(20);
        if (iTerrain != null) {
            n4 = iTerrain.getTerrainFactor() - n;
            n3 = iTerrain.getLevel();
            if (n4 <= 0) {
                iHex.removeTerrain(1);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(2, 1));
                report = new Report(3090);
                report.subject = n2;
                vector.add(report);
            } else if (n4 <= 50 && n3 > 1) {
                iHex.removeTerrain(1);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(1, 1));
                iTerrain = iHex.getTerrain(1);
                report = new Report(3085);
                report.subject = n2;
                vector.add(report);
            } else if (n4 <= 90 && n3 > 2) {
                iHex.removeTerrain(1);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(1, 2));
                iTerrain = iHex.getTerrain(1);
                report = new Report(3082);
                report.subject = n2;
                vector.add(report);
            }
            iTerrain.setTerrainFactor(n4);
        }
        if (iTerrain2 != null) {
            n4 = iTerrain2.getTerrainFactor() - n;
            n3 = iTerrain2.getLevel();
            if (n4 < 0) {
                iHex.removeTerrain(23);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(2, 1));
                report = new Report(3091);
                report.subject = n2;
                vector.add(report);
            } else if (n4 <= 50 && n3 > 1) {
                iHex.removeTerrain(23);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(23, 1));
                iTerrain2 = iHex.getTerrain(23);
                report = new Report(3086);
                report.subject = n2;
                vector.add(report);
            } else if (n4 <= 90 && n3 > 2) {
                iHex.removeTerrain(23);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(23, 2));
                iTerrain2 = iHex.getTerrain(23);
                report = new Report(3083);
                report.subject = n2;
                vector.add(report);
            }
            iTerrain2.setTerrainFactor(n4);
        }
        if (iTerrain3 != null) {
            n4 = iTerrain3.getTerrainFactor() - n;
            if (n4 <= 0) {
                report = new Report(3092);
                report.subject = n2;
                vector.add(report);
                vector.addAll(this.resolveIceBroken(coords));
            } else {
                iTerrain3.setTerrainFactor(n4);
            }
        }
        this.sendChangedHex(coords);
        return vector;
    }

    private void resolvePhysicalAttacks() {
        Object object;
        Object object2;
        this.addReport(new Report(4000, 0));
        Enumeration<EntityAction> enumeration = this.game.getCharges();
        while (enumeration.hasMoreElements()) {
            this.game.addAction(enumeration.nextElement());
        }
        this.game.resetCharges();
        this.cleanupPhysicalAttacks();
        enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = (AttackAction)object2;
            if (!this.game.getEntity(object.getEntityId()).isActive() && !(object2 instanceof DfaAttackAction)) continue;
            AbstractAttackAction abstractAttackAction = (AbstractAttackAction)object2;
            if (abstractAttackAction instanceof SearchlightAttackAction) {
                SearchlightAttackAction searchlightAttackAction = (SearchlightAttackAction)abstractAttackAction;
                this.addReport(searchlightAttackAction.resolveAction(this.game));
                continue;
            }
            this.physicalResults.addElement(this.preTreatPhysicalAttack(abstractAttackAction));
        }
        int n = -1;
        object2 = this.physicalResults.elements();
        while (object2.hasMoreElements()) {
            object = (PhysicalResult)object2.nextElement();
            this.resolvePhysicalAttack((PhysicalResult)object, n);
            n = ((PhysicalResult)object).aaa.getEntityId();
        }
        this.physicalResults.removeAllElements();
    }

    private void cleanupPhysicalAttacks() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            this.removeDuplicateAttacks(entity.getId());
        }
        this.removeDeadAttacks();
    }

    private void removeDuplicateAttacks(int n) {
        boolean bl = false;
        Vector<EntityAction> vector = new Vector<EntityAction>();
        Enumeration<EntityAction> enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            EntityAction entityAction = enumeration.nextElement();
            if (entityAction.getEntityId() != n) {
                vector.addElement(entityAction);
                continue;
            }
            if (!bl) {
                vector.addElement(entityAction);
                if (entityAction instanceof SearchlightAttackAction) continue;
                bl = true;
                continue;
            }
            System.err.println("server: removing duplicate phys attack for id#" + n);
            System.err.println("        action was " + entityAction.toString());
        }
        this.game.resetActions();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.game.addAction(enumeration.nextElement());
        }
    }

    private void removeDeadAttacks() {
        Vector<EntityAction> vector = new Vector<EntityAction>(this.game.actionsSize());
        Enumeration<EntityAction> enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            EntityAction entityAction = enumeration.nextElement();
            Entity entity = this.game.getEntity(entityAction.getEntityId());
            if (entity == null || entity.isDestroyed() || !entity.isActive() && !(entityAction instanceof DfaAttackAction)) continue;
            vector.addElement(entityAction);
        }
        this.game.resetActions();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.game.addAction(enumeration.nextElement());
        }
    }

    private void resolvePunchAttack(PhysicalResult physicalResult, int n) {
        Report report;
        PunchAttackAction punchAttackAction = (PunchAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(punchAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(punchAttackAction.getTargetType(), punchAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, entity.getPosition(), entity2);
        }
        String string = punchAttackAction.getArm() == 1 ? "Left Arm" : "Right Arm";
        int n2 = punchAttackAction.getArm() == 1 ? physicalResult.damage : physicalResult.damageRight;
        ToHitData toHitData = punchAttackAction.getArm() == 1 ? physicalResult.toHit : physicalResult.toHitRight;
        int n3 = punchAttackAction.getArm() == 1 ? physicalResult.roll : physicalResult.rollRight;
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        if (n != punchAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4010);
        report.subject = entity.getId();
        report.indent();
        report.add(string);
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4015);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4020);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.addReport(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            if (bl2 && building != null && n2 > 0) {
                Vector<Report> vector = this.damageBuilding(building, n2);
                for (Report report2 : vector) {
                    report2.subject = entity.getId();
                }
                this.addReport(vector);
            }
            return;
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Vector<Report> vector = this.damageBuilding(building, n2);
            for (Report report3 : vector) {
                report3.subject = entity.getId();
            }
            this.addReport(vector);
            this.damageInfantryIn(building, n2);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        hitData.setGeneralDamageType(-2);
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.addReport(report);
        if (bl2 && building != null) {
            int n4 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n4, n2);
            n2 -= n5;
            this.addNewLines();
            Vector<Report> vector = this.damageBuilding(building, n5);
            for (Report report4 : vector) {
                report4.subject = entity.getId();
            }
            this.addReport(vector);
        }
        if (n2 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.addReport(report);
        } else {
            if (bl3) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            if (n2 >= 1 && entity2.hasWorkingMisc(0x400000000L, -1, hitData.getLocation())) {
                report = new Report(4330);
                report.indent(2);
                report.newlines = 0;
                report.subject = entity.getId();
                this.addReport(report);
                this.checkBreakSpikes(entity2, hitData.getLocation());
                n2 = Math.max(1, n2 - 4);
                HitData hitData2 = punchAttackAction.getArm() == 1 ? new HitData(5) : new HitData(4);
                this.addReport(this.damageEntity(entity, hitData2, 2, false, DamageType.NONE, false, false, false));
            }
            DamageType damageType = DamageType.NONE;
            this.addReport(this.damageEntity(entity2, hitData, n2, false, damageType, false, false, bl));
            if (targetable instanceof VTOL) {
                this.addReport(this.applyCriticalHit(entity2, 5, new CriticalSlot(0, 18), false));
            }
        }
        this.addNewLines();
    }

    private void resolveKickAttack(PhysicalResult physicalResult, int n) {
        Report report;
        String string;
        KickAttackAction kickAttackAction = (KickAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(kickAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(kickAttackAction.getTargetType(), kickAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, entity.getPosition(), entity2);
        }
        String string2 = string = kickAttackAction.getLeg() == 1 || kickAttackAction.getLeg() == 3 ? "Left " : "Right ";
        if (kickAttackAction.getLeg() == 3 || kickAttackAction.getLeg() == 4) {
            string.concat(" rear ");
        } else {
            string.concat(" front ");
        }
        string.concat("leg");
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        if (n != entity.getId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4055);
        report.subject = entity.getId();
        report.indent();
        report.add(string);
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4060);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a kick"));
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4065);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.addReport(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a kick"));
            if (bl2 && building != null && n2 > 0) {
                Vector<Report> vector = this.damageBuilding(building, n2);
                for (Report report2 : vector) {
                    report2.subject = entity.getId();
                }
                this.addReport(vector);
            }
            return;
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Vector<Report> vector = this.damageBuilding(building, n2);
            for (Report report3 : vector) {
                report3.subject = entity.getId();
            }
            this.addReport(vector);
            this.damageInfantryIn(building, n2);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        hitData.setGeneralDamageType(-2);
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.addReport(report);
        if (bl2 && building != null) {
            int n4 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n4, n2);
            this.addNewLines();
            Vector<Report> vector = this.damageBuilding(building, n2 -= n5);
            for (Report report4 : vector) {
                report4.subject = entity.getId();
            }
            this.addReport(vector);
        }
        if (n2 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.addReport(report);
        } else {
            if (bl3) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            if (n2 >= 1 && entity2.hasWorkingMisc(0x400000000L, -1, hitData.getLocation())) {
                HitData hitData2;
                report = new Report(4330);
                report.indent(2);
                report.newlines = 0;
                report.subject = entity.getId();
                this.addReport(report);
                this.checkBreakSpikes(entity2, hitData.getLocation());
                n2 = Math.max(1, n2 - 4);
                switch (kickAttackAction.getLeg()) {
                    case 1: {
                        if (entity instanceof QuadMech) {
                            hitData2 = new HitData(5);
                            break;
                        }
                        hitData2 = new HitData(7);
                        break;
                    }
                    case 2: {
                        if (entity instanceof QuadMech) {
                            hitData2 = new HitData(4);
                            break;
                        }
                        hitData2 = new HitData(6);
                        break;
                    }
                    case 3: {
                        hitData2 = new HitData(7);
                        break;
                    }
                    default: {
                        hitData2 = new HitData(6);
                    }
                }
                this.addReport(this.damageEntity(entity, hitData2, 2, false, DamageType.NONE, false, false, false));
            }
            DamageType damageType = DamageType.NONE;
            this.addReport(this.damageEntity(entity2, hitData, n2, false, damageType, false, false, bl));
            if (targetable instanceof VTOL) {
                this.addReport(this.applyCriticalHit(entity2, 5, new CriticalSlot(0, 18), false));
            }
        }
        if (entity2.getMovementMode() == 1 || entity2.getMovementMode() == 2) {
            PilotingRollData pilotingRollData = this.getKickPushPSR(entity2, entity, entity2, "was kicked");
            pilotingRollData.setCumulative(false);
            this.game.addPSR(pilotingRollData);
        }
        this.addNewLines();
    }

    private void resolveJumpJetAttack(PhysicalResult physicalResult, int n) {
        Report report;
        JumpJetAttackAction jumpJetAttackAction = (JumpJetAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(jumpJetAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(jumpJetAttackAction.getTargetType(), jumpJetAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, entity.getPosition(), entity2);
        }
        String string = null;
        switch (jumpJetAttackAction.getLeg()) {
            case 1: {
                string = "Left leg";
                break;
            }
            case 2: {
                string = "Right leg";
                break;
            }
            default: {
                string = "Both legs";
            }
        }
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        if (n != entity.getId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4290);
        report.subject = entity.getId();
        report.indent();
        report.add(string);
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4075);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4080);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.addReport(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            if (bl2 && building != null && (n2 += physicalResult.damageRight) > 0) {
                Vector<Report> vector = this.damageBuilding(building, n2);
                for (Report report2 : vector) {
                    report2.subject = entity.getId();
                }
                this.addReport(vector);
            }
            return;
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Vector<Report> vector = this.damageBuilding(building, n2 += physicalResult.damageRight);
            for (Report report3 : vector) {
                report3.subject = entity.getId();
            }
            this.addReport(vector);
            this.damageInfantryIn(building, n2);
            return;
        }
        report = new Report(4040);
        report.subject = entity.getId();
        report.newlines = 0;
        this.addReport(report);
        for (int i = 0; i < 2 && (i != 1 || (n2 = physicalResult.damageRight) != 0); ++i) {
            HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            hitData.setGeneralDamageType(-3);
            if (bl2 && building != null) {
                int n4 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
                int n5 = Math.min(n4, n2);
                this.addNewLines();
                Vector<Report> vector = this.damageBuilding(building, n2 -= n5);
                for (Report report4 : vector) {
                    report4.subject = entity.getId();
                }
                this.addReport(vector);
            }
            if (n2 == 0) {
                report = new Report(4050);
                report.subject = entity.getId();
                report.add(entity2.getShortName());
                report.add(entity2.getOwner().getName());
                report.newlines = 0;
                this.addReport(report);
                continue;
            }
            if (bl3) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            this.addReport(this.damageEntity(entity2, hitData, n2, false, DamageType.NONE, false, false, bl));
        }
        this.addNewLines();
    }

    private void resolveProtoAttack(PhysicalResult physicalResult, int n) {
        Report report;
        ProtomechPhysicalAttackAction protomechPhysicalAttackAction = (ProtomechPhysicalAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(protomechPhysicalAttackAction.getEntityId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        Targetable targetable = this.game.getTarget(protomechPhysicalAttackAction.getTargetType(), protomechPhysicalAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, entity.getPosition(), entity2);
        }
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        if (n != entity.getId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4070);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4075);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4080);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.addReport(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            if (bl2 && building != null && n2 > 0) {
                Vector<Report> vector = this.damageBuilding(building, n2);
                for (Report report2 : vector) {
                    report2.subject = entity.getId();
                }
                this.addReport(vector);
            }
            return;
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Vector<Report> vector = this.damageBuilding(building, n2);
            for (Report report3 : vector) {
                report3.subject = entity.getId();
            }
            this.addReport(vector);
            this.damageInfantryIn(building, n2);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        hitData.setGeneralDamageType(-2);
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.addReport(report);
        if (bl2 && building != null) {
            int n4 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n4, n2);
            this.addNewLines();
            Vector<Report> vector = this.damageBuilding(building, n2 -= n5);
            for (Report report4 : vector) {
                report4.subject = entity.getId();
            }
            this.addReport(vector);
        }
        if (n2 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.addReport(report);
        } else {
            if (bl3) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            this.addReport(this.damageEntity(entity2, hitData, n2, false, DamageType.NONE, false, false, bl));
        }
        this.addNewLines();
    }

    private void resolveBrushOffAttack(PhysicalResult physicalResult, int n) {
        Report report;
        int n2;
        String string;
        BrushOffAttackAction brushOffAttackAction = (BrushOffAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(brushOffAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(brushOffAttackAction.getTargetType(), brushOffAttackAction.getTargetId());
        Entity entity2 = null;
        String string2 = string = brushOffAttackAction.getArm() == 1 ? "Left Arm" : "Right Arm";
        if (targetable.getTargetType() == 0) {
            entity2 = this.game.getEntity(brushOffAttackAction.getTargetId());
        }
        int n3 = brushOffAttackAction.getArm() == 1 ? physicalResult.damage : physicalResult.damageRight;
        ToHitData toHitData = brushOffAttackAction.getArm() == 1 ? physicalResult.toHit : physicalResult.toHitRight;
        int n4 = n2 = brushOffAttackAction.getArm() == 1 ? physicalResult.roll : physicalResult.rollRight;
        if (n != brushOffAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4085);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.add(string);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4090);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        report = new Report(4025);
        report.subject = entity.getId();
        report.add(toHitData.getValue());
        report.add(n2);
        report.newlines = 0;
        this.addReport(report);
        if (n2 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            toHitData.setHitTable(1);
            toHitData.setSideTable(0);
            HitData hitData = entity.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            hitData.setGeneralDamageType(-2);
            report = new Report(4095);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.getLocationAbbr(hitData));
            report.newlines = 0;
            this.addReport(report);
            this.addReport(this.damageEntity(entity, hitData, n3));
            this.addNewLines();
            return;
        }
        switch (targetable.getTargetType()) {
            case 0: {
                HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
                hitData.setGeneralDamageType(-2);
                report = new Report(4045);
                report.subject = entity.getId();
                report.add(toHitData.getTableDesc());
                report.add(entity2.getLocationAbbr(hitData));
                report.newlines = 0;
                this.addReport(report);
                this.addReport(this.damageEntity(entity2, hitData, n3));
                this.addNewLines();
                entity.setSwarmAttackerId(-1);
                entity2.setSwarmTargetId(-1);
                report = new Report(4100);
                report.subject = entity.getId();
                report.add(entity2.getDisplayName());
                this.addReport(report);
                break;
            }
            case 11: {
                entity.removeINarcPod((INarcPod)targetable);
                report = new Report(4105);
                report.subject = entity.getId();
                report.add(targetable.getDisplayName());
                this.addReport(report);
            }
        }
    }

    private void resolveThrashAttack(PhysicalResult physicalResult, int n) {
        Report report;
        ThrashAttackAction thrashAttackAction = (ThrashAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(thrashAttackAction.getEntityId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        boolean bl = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Entity entity2 = this.game.getEntity(thrashAttackAction.getTargetId());
        if (n != thrashAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4110);
        report.subject = entity.getId();
        report.indent();
        report.addDesc(entity2);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4115);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4120);
            report.subject = entity.getId();
            report.newlines = 0;
            this.addReport(report);
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (n3 < toHitData.getValue()) {
                report = new Report(4035);
                report.subject = entity.getId();
                this.addReport(report);
                return;
            }
            report = new Report(4125);
            report.subject = entity.getId();
            report.newlines = 0;
            this.addReport(report);
        }
        if (bl) {
            n2 = (int)Math.floor((double)n2 / 2.0);
        }
        report = new Report(4130);
        report.subject = entity.getId();
        report.add(n2);
        report.newlines = 0;
        this.addReport(report);
        if (bl) {
            report = new Report(4030);
            report.subject = entity.getId();
            report.newlines = 0;
            this.addReport(report);
        }
        while (n2 > 0) {
            int n4 = Math.min(5, n2);
            n2 -= n4;
            HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            hitData.setGeneralDamageType(-2);
            report = new Report(4135);
            report.subject = entity.getId();
            report.add(entity2.getLocationAbbr(hitData));
            report.newlines = 0;
            this.addReport(report);
            this.addReport(this.damageEntity(entity2, hitData, n4));
        }
        this.addNewLines();
        PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
        entity.addPilotingModifierForTerrain(pilotingRollData);
        pilotingRollData.addModifier(0, "thrashing at infantry");
        report = new Report(4140);
        report.subject = entity.getId();
        report.addDesc(entity);
        this.addReport(report);
        int n5 = Compute.d6(2);
        report = new Report(2190);
        report.subject = entity.getId();
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n5);
        if (n5 < pilotingRollData.getValue()) {
            report.choose(false);
            this.addReport(report);
            this.addReport(this.doEntityFall(entity, pilotingRollData));
        } else {
            report.choose(true);
            this.addReport(report);
        }
    }

    private void resolveClubAttack(PhysicalResult physicalResult, int n) {
        int n2;
        Report report;
        ClubAttackAction clubAttackAction = (ClubAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(clubAttackAction.getEntityId());
        int n3 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n4 = physicalResult.roll;
        Targetable targetable = this.game.getTarget(clubAttackAction.getTargetType(), clubAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, entity.getPosition(), entity2);
        }
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n4 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        clubAttackAction.getClub().restore();
        if (((MiscType)clubAttackAction.getClub().getType()).isShield()) {
            ((Mech)entity).shieldAbsorptionDamage(1, clubAttackAction.getClub().getLocation(), false);
        }
        if (n != clubAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4145);
        report.subject = entity.getId();
        report.indent();
        report.add(clubAttackAction.getClub().getName());
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if ((((MiscType)clubAttackAction.getClub().getType()).hasSubType(256) || ((MiscType)clubAttackAction.getClub().getType()).hasSubType(131072)) && n4 == 2) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            ToHitData toHitData2 = new ToHitData(Integer.MIN_VALUE, "hit with own flail/wrecking ball");
            physicalResult.damage /= 2;
            toHitData2.setHitTable(0);
            toHitData2.setSideTable(0);
            physicalResult.toHit = toHitData2;
            physicalResult.aaa.setTargetId(entity.getId());
            physicalResult.aaa.setTargetType(0);
            physicalResult.roll = Integer.MAX_VALUE;
            this.resolveClubAttack(physicalResult, entity.getId());
            this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a flail/wrecking ball attack"));
            return;
        }
        if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(0x400000)) {
            n3 = Compute.d6(2);
            entity.heatBuildup += 3;
            if (n4 == 2) {
                Mounted mounted = clubAttackAction.getClub();
                for (Mounted mounted2 : entity.getWeaponList()) {
                    if (mounted2.getLocation() != mounted.getLocation() || !(mounted2.getType() instanceof MiscType) || !((MiscType)mounted2.getType()).hasFlag(0x8000000L) || !((MiscType)mounted2.getType()).hasSubType(0x400000)) continue;
                    mounted2.setDestroyed(true);
                    break;
                }
                report = new Report(4037);
                report.subject = entity.getId();
                this.addReport(report);
                n3 = 0;
                return;
            }
        }
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4075);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(16)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a mace attack"));
            }
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(64)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 2, "missed a mace attack"));
            }
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4080);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.addReport(report);
            n4 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n4);
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n4 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(16)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a mace attack"));
            }
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(64)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 2, "missed a mace attack"));
            }
            if (bl2 && building != null && n3 > 0) {
                Vector<Report> vector = this.damageBuilding(building, n3);
                for (Report report2 : vector) {
                    report2.subject = entity.getId();
                }
                this.addReport(vector);
            }
            return;
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Vector<Report> vector = this.damageBuilding(building, n3);
            for (Report report3 : vector) {
                report3.subject = entity.getId();
            }
            this.addReport(vector);
            this.damageInfantryIn(building, n3);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        hitData.setGeneralDamageType(-2);
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.addReport(report);
        if (bl2 && building != null) {
            n2 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n2, n3);
            this.addNewLines();
            Vector<Report> vector = this.damageBuilding(building, n3 -= n5);
            for (Report report4 : vector) {
                report4.subject = entity.getId();
            }
            this.addReport(vector);
        }
        if (n3 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.addReport(report);
        } else {
            if (bl3) {
                n3 = (int)Math.floor((double)n3 / 2.0);
            }
            if (n3 >= 1 && entity2.hasWorkingMisc(0x400000000L, -1, hitData.getLocation())) {
                report = new Report(4330);
                report.indent(2);
                report.newlines = 0;
                report.subject = entity.getId();
                this.addReport(report);
                this.checkBreakSpikes(entity2, hitData.getLocation());
                n3 = Math.max(1, n3 - 4);
                n2 = clubAttackAction.getClub().getLocation();
                if (n2 == -1) {
                    this.addReport(this.damageEntity(entity, new HitData(5), 1, false, DamageType.NONE, false, false, false));
                    this.addReport(this.damageEntity(entity, new HitData(4), 1, false, DamageType.NONE, false, false, false));
                } else {
                    this.addReport(this.damageEntity(entity, new HitData(n2), 2, false, DamageType.NONE, false, false, false));
                }
            }
            DamageType damageType = DamageType.NONE;
            this.addReport(this.damageEntity(entity2, hitData, n3, false, damageType, false, false, bl));
            if (targetable instanceof VTOL) {
                this.addReport(this.applyCriticalHit(entity2, 5, new CriticalSlot(0, 18), false));
            }
        }
        if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(8192) && entity2.getArmor(hitData) > 0 && entity2.getArmorType() != 4) {
            n4 = Compute.d6(2);
            report = new Report(4021);
            report.indent(2);
            report.subject = entity.getId();
            report.add(entity2.getLocationAbbr(hitData));
            report.add(n4);
            report.newlines = 1;
            this.addReport(report);
            if (n4 >= 10) {
                hitData.makeGlancingBlow();
                this.addReport(this.damageEntity(entity2, hitData, 1, false, DamageType.NONE, true, false, bl));
            }
        }
        this.addNewLines();
        if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(2)) {
            report = new Report(4150);
            report.subject = entity.getId();
            report.add(clubAttackAction.getClub().getName());
            this.addReport(report);
            entity.removeMisc(clubAttackAction.getClub().getName());
        }
    }

    private void resolvePushAttack(PhysicalResult physicalResult, int n) {
        Serializable serializable;
        Report report;
        PushAttackAction pushAttackAction = (PushAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(pushAttackAction.getEntityId());
        Entity entity2 = this.game.getEntity(pushAttackAction.getTargetId());
        int n2 = physicalResult.roll;
        ToHitData toHitData = physicalResult.toHit;
        if (physicalResult.pushBackResolved) {
            return;
        }
        physicalResult.pushBackResolved = true;
        if (n != pushAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4155);
        report.subject = entity.getId();
        report.indent();
        report.addDesc(entity2);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4160);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        report = new Report(4025);
        report.subject = entity.getId();
        report.add(toHitData.getValue());
        report.add(n2);
        report.newlines = 0;
        this.addReport(report);
        Serializable serializable2 = null;
        Object object = this.physicalResults.elements();
        while (object.hasMoreElements()) {
            serializable = object.nextElement();
            if (((PhysicalResult)serializable).aaa.getEntityId() != entity2.getId() || !(((PhysicalResult)serializable).aaa instanceof PushAttackAction) || ((PhysicalResult)serializable).aaa.getTargetId() != entity.getId()) continue;
            serializable2 = serializable;
        }
        if (serializable2 != null && !((PhysicalResult)serializable2).pushBackResolved && n2 >= toHitData.getValue()) {
            ((PhysicalResult)serializable2).pushBackResolved = true;
            if (((PhysicalResult)serializable2).roll >= ((PhysicalResult)serializable2).toHit.getValue()) {
                report = new Report(4165);
                report.subject = entity.getId();
                report.addDesc(entity2);
                report.addDesc(entity2);
                report.addDesc(entity);
                report.add(((PhysicalResult)serializable2).toHit.getValue());
                report.add(((PhysicalResult)serializable2).roll);
                report.addDesc(entity);
                this.addReport(report);
                object = this.getKickPushPSR(entity2, entity, entity2, "was pushed");
                ((PilotingRollData)object).setCumulative(false);
                serializable = this.getKickPushPSR(entity, entity, entity2, "was pushed");
                ((PilotingRollData)serializable).setCumulative(false);
                this.game.addPSR((PilotingRollData)serializable);
                this.game.addPSR((PilotingRollData)object);
                return;
            }
            report = new Report(4166);
            report.subject = entity.getId();
            report.addDesc(entity2);
            report.addDesc(entity);
            report.add(((PhysicalResult)serializable2).toHit.getValue());
            report.add(((PhysicalResult)serializable2).roll);
            this.addReport(report);
        }
        if (n2 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            return;
        }
        int n3 = entity.getFacing();
        serializable = entity2.getPosition();
        Coords coords = ((Coords)serializable).translated(n3);
        PilotingRollData pilotingRollData = this.getKickPushPSR(entity2, entity, entity2, "was pushed");
        pilotingRollData.setCumulative(false);
        if (Compute.isValidDisplacement(this.game, entity2.getId(), entity2.getPosition(), n3)) {
            report = new Report(4170);
            report.subject = entity.getId();
            report.newlines = 0;
            this.addReport(report);
            if (this.game.getBoard().contains(coords)) {
                report = new Report(4175);
                report.subject = entity.getId();
                report.add(coords.getBoardNum(), true);
                this.addReport(report);
            } else {
                report = new Report(4180);
                report.subject = entity.getId();
                this.addReport(report);
            }
            this.addReport(this.doEntityDisplacement(entity2, (Coords)serializable, coords, pilotingRollData));
            if (!entity2.getPosition().equals(serializable)) {
                entity.setPosition((Coords)serializable);
            }
        } else {
            report = new Report(4185);
            report.subject = entity.getId();
            this.addReport(report);
            this.game.addPSR(pilotingRollData);
        }
        this.addNewLines();
    }

    private void resolveTripAttack(PhysicalResult physicalResult, int n) {
        Report report;
        TripAttackAction tripAttackAction = (TripAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(tripAttackAction.getEntityId());
        Entity entity2 = this.game.getEntity(tripAttackAction.getTargetId());
        int n2 = physicalResult.roll;
        ToHitData toHitData = physicalResult.toHit;
        if (n != tripAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4280);
        report.subject = entity.getId();
        report.indent();
        report.addDesc(entity2);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4285);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        report = new Report(4025);
        report.subject = entity.getId();
        report.add(toHitData.getValue());
        report.add(n2);
        report.newlines = 0;
        this.addReport(report);
        if (n2 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            return;
        }
        PilotingRollData pilotingRollData = this.getKickPushPSR(entity2, entity, entity2, "was tripped");
        pilotingRollData.setCumulative(false);
        this.game.addPSR(pilotingRollData);
        report = new Report(4040);
        report.subject = entity.getId();
        this.addReport(report);
        this.addNewLines();
    }

    private void resolveGrappleAttack(PhysicalResult physicalResult, int n) {
        Report report;
        GrappleAttackAction grappleAttackAction = (GrappleAttackAction)physicalResult.aaa;
        Mech mech = (Mech)this.game.getEntity(grappleAttackAction.getEntityId());
        Mech mech2 = (Mech)this.game.getEntity(grappleAttackAction.getTargetId());
        int n2 = physicalResult.roll;
        ToHitData toHitData = physicalResult.toHit;
        if (physicalResult.pushBackResolved) {
            return;
        }
        if (mech2.getGrappled() != -1 || mech.getGrappled() != -1) {
            toHitData.addModifier(Integer.MAX_VALUE, "Already Grappled");
        }
        if (n != grappleAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = mech.getId();
            report.addDesc(mech);
            this.addReport(report);
        }
        report = new Report(4295);
        report.subject = mech.getId();
        report.indent();
        report.addDesc(mech2);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4300);
            report.subject = mech.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        report = new Report(4025);
        report.subject = mech.getId();
        report.add(toHitData.getValue());
        report.add(n2);
        report.newlines = 0;
        this.addReport(report);
        if (n2 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = mech.getId();
            this.addReport(report);
            return;
        }
        mech.setGrappled(mech2.getId(), true);
        mech2.setGrappled(mech.getId(), false);
        Coords coords = mech2.getPosition();
        mech.setPosition(coords);
        mech.setElevation(mech2.getElevation());
        mech2.setFacing((mech.getFacing() + 3) % 6);
        this.addReport(this.doSetLocationsExposure(mech, this.game.getBoard().getHex(coords), false, mech.getElevation()));
        report = new Report(4040);
        report.subject = mech.getId();
        this.addReport(report);
        this.addNewLines();
    }

    private void resolveBreakGrappleAttack(PhysicalResult physicalResult, int n) {
        Object object;
        Object object2;
        Report report;
        BreakGrappleAttackAction breakGrappleAttackAction = (BreakGrappleAttackAction)physicalResult.aaa;
        Mech mech = (Mech)this.game.getEntity(breakGrappleAttackAction.getEntityId());
        Mech mech2 = (Mech)this.game.getEntity(breakGrappleAttackAction.getTargetId());
        int n2 = physicalResult.roll;
        ToHitData toHitData = physicalResult.toHit;
        if (n != breakGrappleAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = mech.getId();
            report.addDesc(mech);
            this.addReport(report);
        }
        report = new Report(4305);
        report.subject = mech.getId();
        report.indent();
        report.addDesc(mech2);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4310);
            report.subject = mech.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4320);
            report.subject = mech.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else {
            report = new Report(4025);
            report.subject = mech.getId();
            report.add(toHitData.getValue());
            report.add(n2);
            report.newlines = 0;
            this.addReport(report);
            if (n2 < toHitData.getValue()) {
                report = new Report(4035);
                report.subject = mech.getId();
                this.addReport(report);
                return;
            }
            report = new Report(4040);
            report.subject = mech.getId();
            this.addReport(report);
        }
        Object object3 = null;
        Coords[] coordsArray = this.physicalResults.elements();
        while (coordsArray.hasMoreElements()) {
            object2 = coordsArray.nextElement();
            if (((PhysicalResult)object2).aaa.getEntityId() != mech2.getId() || !(((PhysicalResult)object2).aaa instanceof GrappleAttackAction) || ((PhysicalResult)object2).aaa.getTargetId() != mech.getId()) continue;
            object3 = object2;
            break;
        }
        if (object3 != null) {
            ((PhysicalResult)object3).pushBackResolved = true;
            report = new Report(4315);
            report.subject = mech2.getId();
            report.newlines = 0;
            report.addDesc(mech2);
            this.addReport(report);
            report = new Report(4025);
            report.subject = mech2.getId();
            report.add(((PhysicalResult)object3).toHit.getValue());
            report.add(((PhysicalResult)object3).roll);
            report.newlines = 0;
            this.addReport(report);
            if (n2 < toHitData.getValue()) {
                report = new Report(4035);
                report.subject = mech.getId();
                this.addReport(report);
            } else {
                report = new Report(4040);
                report.subject = mech.getId();
                this.addReport(report);
                mech.setGrappled(mech2.getId(), false);
                mech2.setGrappled(mech.getId(), true);
                return;
            }
        }
        coordsArray = new Coords[6];
        object2 = new int[6];
        IHex iHex = this.game.getBoard().getHex(mech.getPosition());
        for (object = 0; object < 6; ++object) {
            coordsArray[object] = mech.getPosition().translated((int)object);
            object2[object] = false;
            IHex iHex2 = this.game.getBoard().getHex(coordsArray[object]);
            if (iHex2.containsTerrain(24)) {
                Object object4 = object2;
                Object object5 = object;
                object4[object5] = object4[object5] + 10;
            }
            if (iHex2.containsTerrain(4)) {
                Object object6 = object2;
                Object object7 = object;
                object6[object7] = object6[object7] + iHex2.terrainLevel(4);
            }
            if (iHex.surface() - iHex2.surface() < 2) continue;
            Object object8 = object2;
            Object object9 = object;
            object8[object9] = object8[object9] + 2 * (iHex.surface() - iHex2.surface());
        }
        object = 99999;
        int n3 = 0;
        Object object10 = -99999;
        int n4 = 0;
        for (int i = 0; i < 6; ++i) {
            if (object > object2[i]) {
                n3 = i;
                object = object2[i];
            }
            if (object10 >= object2[i]) continue;
            n4 = i;
            object10 = object2[i];
        }
        if (mech.isGrappleAttacker()) {
            PilotingRollData pilotingRollData = mech.getBasePilotingRoll();
            pilotingRollData.addModifier(Integer.MIN_VALUE, "break grapple");
            this.addReport(this.doEntityDisplacement(mech, mech.getPosition(), coordsArray[n3], pilotingRollData));
            mech.setFacing(coordsArray[n3].direction(mech2.getPosition()));
        } else {
            PilotingRollData pilotingRollData = mech2.getBasePilotingRoll();
            pilotingRollData.addModifier(Integer.MIN_VALUE, "break grapple");
            this.addReport(this.doEntityDisplacement(mech2, mech2.getPosition(), coordsArray[n4], pilotingRollData));
            mech2.setFacing(coordsArray[n4].direction(mech.getPosition()));
        }
        mech.setGrappled(-1, false);
        mech2.setGrappled(-1, false);
        this.addNewLines();
    }

    private void resolveChargeAttack(PhysicalResult physicalResult, int n) {
        Report report;
        ChargeAttackAction chargeAttackAction = (ChargeAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(chargeAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(chargeAttackAction.getTargetType(), chargeAttackAction.getTargetId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        Entity entity2 = null;
        if (targetable != null && targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, entity.getPosition(), entity2);
        }
        boolean bl2 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(chargeAttackAction.getTargetPos());
        if (entity == null) {
            return;
        }
        int n4 = entity.getFacing();
        entity.setDisplacementAttack(null);
        if (n != chargeAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        if (targetable == null || targetable.getTargetType() == 0 && (entity2.isDestroyed() || entity2.isDoomed() || entity2.crew.isDead())) {
            report = new Report(4190);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            return;
        }
        if (entity.isProne()) {
            report = new Report(4195);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            return;
        }
        if (entity.isImmobile()) {
            report = new Report(4200);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            return;
        }
        if (entity2 != null && entity2.isProne() && entity instanceof Mech) {
            report = new Report(4205);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            return;
        }
        report = new Report(4210);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (!targetable.getPosition().equals(chargeAttackAction.getTargetPos())) {
            report = new Report(4215);
            report.subject = entity.getId();
            this.addReport(report);
            this.addReport(this.doEntityDisplacement(entity, entity.getPosition(), chargeAttackAction.getTargetPos(), null));
            return;
        }
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            n3 = -12;
            report = new Report(4220);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else if (toHitData.getValue() == Integer.MIN_VALUE) {
            n3 = Integer.MAX_VALUE;
            report = new Report(4225);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (bl2) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            Coords coords = entity.getPosition();
            Coords coords2 = Compute.getMissedChargeDisplacement(this.game, entity.getId(), coords, n4);
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            this.addReport(this.doEntityDisplacement(entity, coords, coords2, null));
        } else if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Vector<Report> vector = this.damageBuilding(building, n2);
            for (Report object2 : vector) {
                object2.subject = entity.getId();
            }
            this.addReport(vector);
            this.damageInfantryIn(building, n2);
            int n5 = ChargeAttackAction.getDamageTakenBy(entity, building);
            HitData hitData = entity.rollHitLocation(0, entity.sideTable(targetable.getPosition()));
            hitData.setGeneralDamageType(-2);
            this.addReport(this.damageEntity(entity, hitData, n5, false, DamageType.NONE, false, false, bl));
            this.addNewLines();
            this.entityUpdate(entity.getId());
        } else {
            this.resolveChargeDamage(entity, entity2, toHitData, n4, bl2, bl);
        }
    }

    private void resolveChargeDamage(Entity entity, Entity entity2, ToHitData toHitData, int n) {
        this.resolveChargeDamage(entity, entity2, toHitData, n, false, true);
    }

    private void resolveChargeDamage(Entity entity, Entity entity2, ToHitData toHitData, int n, boolean bl, boolean bl2) {
        int n2 = ChargeAttackAction.getDamageFor(entity);
        int n3 = ChargeAttackAction.getDamageTakenBy(entity, entity2, this.game.getOptions().booleanOption("maxtech_charge_damage"));
        PilotingRollData pilotingRollData = null;
        if (bl) {
            n2 = (int)Math.floor((double)n2 / 2.0);
            n3 = (int)Math.floor((double)n3 / 2.0);
        }
        boolean bl3 = Compute.isInBuilding(this.game, entity2);
        Building building = this.game.getBoard().getBuildingAt(entity2.getPosition());
        int n4 = 0;
        if (bl3 && building != null) {
            n4 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
        }
        if (!entity.isProne()) {
            pilotingRollData = new PilotingRollData(entity.getId(), 2, "charging");
        }
        Report report = new Report(4240);
        report.subject = entity.getId();
        report.add(n3);
        report.newlines = 0;
        this.addReport(report);
        int[] nArray = new int[entity.locations()];
        for (int i = 0; i < entity.locations(); ++i) {
            nArray[i] = 0;
        }
        for (Mounted mounted : entity.getMisc()) {
            if (mounted.getLocation() == -1 || !mounted.getType().hasFlag(0x400000000L)) continue;
            nArray[mounted.getLocation()] = 1;
        }
        int n5 = 0;
        while (n3 > 0) {
            int n6 = Math.min(5, n3);
            HitData object = entity.rollHitLocation(toHitData.getHitTable(), entity.sideTable(entity2.getPosition()));
            object.setGeneralDamageType(-2);
            if (nArray[object.getLocation()] == 1) {
                report = new Report(4335);
                report.indent(2);
                report.newlines = 0;
                report.subject = entity.getId();
                this.addReport(report);
                nArray[object.getLocation()] = 0;
                this.checkBreakSpikes(entity, object.getLocation());
                n5 += 2;
            }
            this.addReport(this.damageEntity(entity, object, n6, false, DamageType.NONE, false, false, bl2));
            n3 -= n6;
        }
        report = new Report(4230);
        report.subject = entity.getId();
        report.add(n2 += n5);
        report.add(toHitData.getTableDesc());
        report.newlines = 0;
        this.addReport(report);
        nArray = new int[entity2.locations()];
        for (int i = 0; i < entity2.locations(); ++i) {
            nArray[i] = 0;
        }
        for (Mounted hitData : entity2.getMisc()) {
            if (hitData.getLocation() == -1 || !hitData.getType().hasFlag(0x400000000L)) continue;
            nArray[hitData.getLocation()] = 1;
        }
        n5 = 0;
        while (n2 > 0) {
            int n7 = Math.min(5, n2);
            n2 -= n7;
            if (n4 > 0) {
                int coords2 = Math.min(n4, n7);
                n7 -= coords2;
                this.addNewLines();
                Vector<Report> vector = this.damageBuilding(building, n2);
                for (Report report2 : vector) {
                    report2.subject = entity.getId();
                }
                this.addReport(vector);
            }
            if (n7 == 0) {
                report = new Report(4235);
                report.subject = entity.getId();
                report.addDesc(entity2);
                report.newlines = 0;
                this.addReport(report);
                continue;
            }
            HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            hitData.setGeneralDamageType(-2);
            if (nArray[hitData.getLocation()] == 1) {
                report = new Report(4330);
                report.indent(2);
                report.newlines = 0;
                report.subject = entity.getId();
                this.addReport(report);
                nArray[hitData.getLocation()] = 0;
                this.checkBreakSpikes(entity2, hitData.getLocation());
                n7 = 1;
                n5 += 2;
            }
            this.addReport(this.damageEntity(entity2, hitData, n7, false, DamageType.NONE, false, false, bl2));
        }
        if (entity instanceof Mech) {
            this.addReport(this.damageEntity(entity, new HitData(1), n5, false, DamageType.NONE, false, false, bl2));
        } else if (entity instanceof Tank) {
            this.addReport(this.damageEntity(entity, new HitData(1), n5, false, DamageType.NONE, false, false, bl2));
        }
        Coords coords = entity2.getPosition();
        Coords coords2 = coords.translated(n);
        if (Compute.isValidDisplacement(this.game, entity2.getId(), entity2.getPosition(), n)) {
            this.addNewLines();
            this.addReport(this.doEntityDisplacement(entity2, coords, coords2, new PilotingRollData(entity2.getId(), 2, "was charged")));
            this.addReport(this.doEntityDisplacement(entity, entity.getPosition(), coords, pilotingRollData));
        }
        this.addNewLines();
    }

    private void resolveLayExplosivesAttack(PhysicalResult physicalResult, int n) {
        LayExplosivesAttackAction layExplosivesAttackAction = (LayExplosivesAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(layExplosivesAttackAction.getEntityId());
        if (entity instanceof Infantry) {
            Infantry infantry = (Infantry)entity;
            if (infantry.turnsLayingExplosives < 0) {
                infantry.turnsLayingExplosives = 0;
                Report report = new Report(4270);
                report.subject = infantry.getId();
                report.addDesc(infantry);
                this.addReport(report);
            } else {
                Building building = this.game.getBoard().getBuildingAt(entity.getPosition());
                if (building != null) {
                    building.addDemolitionCharge(entity.getOwner().getId(), physicalResult.damage);
                    Report report = new Report(4275);
                    report.subject = infantry.getId();
                    report.addDesc(infantry);
                    report.add(physicalResult.damage);
                    this.addReport(report);
                }
                infantry.turnsLayingExplosives = -1;
            }
        }
    }

    private void resolveDfaAttack(PhysicalResult physicalResult, int n) {
        Object object;
        Object object2;
        Report report;
        DfaAttackAction dfaAttackAction = (DfaAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(dfaAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(dfaAttackAction.getTargetType(), dfaAttackAction.getTargetId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        Entity entity2 = null;
        if (targetable != null && targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
            IHex iHex = this.game.getBoard().getHex(entity2.getPosition());
            if (iHex.containsTerrain(4) && entity2.absHeight() < iHex.getElevation()) {
                n2 = (int)Math.ceil((float)n2 * 0.5f);
            }
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, entity.getPosition(), entity2);
        }
        boolean bl2 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(dfaAttackAction.getTargetPos());
        if (entity == null) {
            return;
        }
        int n4 = entity.getFacing();
        if (n != dfaAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        entity.setDisplacementAttack(null);
        if (targetable == null || targetable.getTargetType() == 0 && (entity2.isDestroyed() || entity2.isDoomed() || entity2.crew.isDead())) {
            report = new Report(4245);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            if (entity.isProne()) {
                this.addReport(this.doEntityFall(entity, dfaAttackAction.getTargetPos(), 2, 3, entity.getBasePilotingRoll()));
            } else {
                this.addReport(this.doEntityDisplacement(entity, entity.getPosition(), dfaAttackAction.getTargetPos(), new PilotingRollData(entity.getId(), 4, "executed death from above")));
            }
            return;
        }
        report = new Report(4246);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (!targetable.getPosition().equals(dfaAttackAction.getTargetPos())) {
            report = new Report(4215);
            report.subject = entity.getId();
            this.addReport(report);
            this.addReport(this.doEntityFallsInto(entity, entity.getPosition(), dfaAttackAction.getTargetPos(), entity.getBasePilotingRoll()));
            return;
        }
        if (entity.isProne() || !entity.isActive()) {
            n3 = -12;
            report = new Report(4250);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else if (toHitData.getValue() == Integer.MAX_VALUE) {
            n3 = -12;
            report = new Report(4255);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4260);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (bl2) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            Coords coords = entity2.getPosition();
            Coords coords2 = Compute.getPreferredDisplacement(this.game, entity2.getId(), coords, n4);
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            if (coords2 != null) {
                report = new Report(4265);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(coords.getBoardNum(), true);
                this.addReport(report);
                this.addReport(this.doEntityFall(entity, coords, 2, 3, entity.getBasePilotingRoll()));
                this.addReport(this.doEntityDisplacement(entity2, coords, coords2, null));
            } else {
                this.addReport(this.destroyEntity(entity, "impossible displacement", entity instanceof Mech, entity instanceof Mech));
            }
            return;
        }
        int n5 = DfaAttackAction.getDamageTakenBy(entity);
        report = new Report(4040);
        report.subject = entity.getId();
        this.addReport(report);
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            object2 = this.damageBuilding(building, n2);
            object = ((Vector)object2).iterator();
            while (object.hasNext()) {
                Report report2 = object.next();
                report2.subject = entity.getId();
            }
            this.addReport((Vector<Report>)object2);
            this.damageInfantryIn(building, n2);
        } else {
            if (bl2) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            report = new Report(4230);
            report.subject = entity.getId();
            report.add(n2);
            report.add(toHitData.getTableDesc());
            report.newlines = 0;
            this.addReport(report);
            object2 = new int[entity2.locations()];
            for (int i = 0; i < entity2.locations(); ++i) {
                object2[i] = false;
            }
            for (Mounted mounted : entity2.getMisc()) {
                if (mounted.getLocation() == -1 || !mounted.getType().hasFlag(0x400000000L)) continue;
                object2[mounted.getLocation()] = true;
            }
            int n6 = 0;
            while (n2 > 0) {
                int n7 = Math.min(5, n2);
                HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
                hitData.setGeneralDamageType(-2);
                if (object2[hitData.getLocation()] == true) {
                    report = new Report(4330);
                    report.indent(2);
                    report.newlines = 0;
                    report.subject = entity.getId();
                    this.addReport(report);
                    n7 = 1;
                    object2[hitData.getLocation()] = false;
                    this.checkBreakSpikes(entity2, hitData.getLocation());
                    n6 += 2;
                }
                this.addReport(this.damageEntity(entity2, hitData, n7, false, DamageType.NONE, false, false, bl));
                n2 -= 5;
            }
            if (n6 > 0) {
                if (entity instanceof QuadMech) {
                    this.addReport(this.damageEntity(entity, new HitData(5), (n6 + 2) / 4, false, DamageType.NONE, false, false, false));
                    this.addReport(this.damageEntity(entity, new HitData(4), (n6 + 2) / 4, false, DamageType.NONE, false, false, false));
                    if (n6 > 2) {
                        this.addReport(this.damageEntity(entity, new HitData(7), n6 / 4, false, DamageType.NONE, false, false, false));
                        this.addReport(this.damageEntity(entity, new HitData(6), n6 / 4, false, DamageType.NONE, false, false, false));
                    }
                } else {
                    this.addReport(this.damageEntity(entity, new HitData(7), n6 / 2, false, DamageType.NONE, false, false, false));
                    this.addReport(this.damageEntity(entity, new HitData(6), n6 / 2, false, DamageType.NONE, false, false, false));
                }
            }
            if (targetable instanceof VTOL) {
                this.addReport(this.applyCriticalHit(entity2, 5, new CriticalSlot(0, 18), false));
            }
        }
        if (bl2) {
            n5 = (int)Math.floor((double)n5 / 2.0);
        }
        report = new Report(4240);
        report.subject = entity.getId();
        report.add(n5);
        report.newlines = 0;
        this.addReport(report);
        while (n5 > 0) {
            int n8 = Math.min(5, n5);
            object = entity.rollHitLocation(2, 0);
            ((HitData)object).setGeneralDamageType(-2);
            this.addReport(this.damageEntity(entity, (HitData)object, n8));
            n5 -= n8;
        }
        this.addNewLines();
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            return;
        }
        Coords coords = entity2.getPosition();
        object = Compute.getValidDisplacement(this.game, entity2.getId(), coords, n4);
        if (object != null) {
            this.addReport(this.doEntityDisplacement(entity2, coords, (Coords)object, new PilotingRollData(entity2.getId(), 2, "hit by death from above")));
        } else {
            this.addReport(this.destroyEntity(entity2, "impossible displacement", entity2 instanceof Mech, entity2 instanceof Mech));
        }
        this.addReport(this.doEntityDisplacement(entity, coords, coords, new PilotingRollData(entity.getId(), 4, "executed death from above")));
    }

    private PilotingRollData getKickPushPSR(Entity entity, Entity entity2, Entity entity3, String string) {
        int n = 0;
        if (this.game.getOptions().booleanOption("maxtech_physical_psr")) {
            int n2 = 0;
            int n3 = 0;
            switch (entity2.getWeightClass()) {
                case 0: {
                    n2 = 1;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 4;
                }
            }
            switch (entity3.getWeightClass()) {
                case 0: {
                    n3 = 1;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
                case 2: {
                    n3 = 3;
                    break;
                }
                case 3: {
                    n3 = 4;
                }
            }
            n = n2 - n3;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (n > 0) {
            stringBuffer.append(", weight class modifier +").append(n);
        } else {
            stringBuffer.append(", weight class modifier ").append(n);
        }
        return new PilotingRollData(entity.getId(), n, stringBuffer.toString());
    }

    private void resolveHeat() {
        this.addReport(new Report(5000, 0));
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            int n;
            int n2;
            boolean bl;
            boolean bl2;
            int n3;
            Report report;
            int n4;
            Entity entity = enumeration.nextElement();
            if (null == entity.getPosition()) continue;
            IHex iHex = this.game.getBoard().getHex(entity.getPosition());
            if (!(entity instanceof Mech)) {
                entity.heatBuildup = 0;
                entity.heatFromExternal = 0;
                if (this.game.getOptions().booleanOption("vehicle_fires") && entity instanceof Tank) {
                    this.addReport(this.resolveVehicleFire((Tank)entity, true));
                    continue;
                }
                if (!entity.infernos.isStillBurning()) continue;
                this.doFlamingDeath(entity);
                continue;
            }
            if (entity.infernos.isStillBurning()) {
                n4 = entity.infernos.getHeat();
                entity.heatFromExternal += n4;
                report = new Report(5010);
                report.subject = entity.getId();
                report.add(n4);
                this.addReport(report);
            }
            if (entity.isDestroyed() || entity.isDoomed() || entity.crew.isDoomed() || entity.crew.isDead()) continue;
            entity.heatBuildup += entity.getEngineCritHeat();
            if (entity instanceof Mech && entity.isStealthActive()) {
                entity.heatBuildup += 10;
                report = new Report(5015);
                report.subject = entity.getId();
                this.addReport(report);
            }
            if (entity instanceof Mech && this.game.getTemperatureDifference() != 0 && !((Mech)entity).hasLaserHeatSinks()) {
                if (this.game.getOptions().intOption("temperature") > 50) {
                    entity.heatFromExternal += this.game.getTemperatureDifference();
                    report = new Report(5020);
                    report.subject = entity.getId();
                    report.add(this.game.getTemperatureDifference());
                    this.addReport(report);
                } else {
                    entity.heatFromExternal -= this.game.getTemperatureDifference();
                    report = new Report(5025);
                    report.subject = entity.getId();
                    report.add(this.game.getTemperatureDifference());
                    this.addReport(report);
                }
            }
            if (this.game.getOptions().booleanOption("blizzard")) {
                entity.heatFromExternal -= 2;
                report = new Report(5026);
                report.subject = entity.getId();
                this.addReport(report);
            }
            if (this.game.getOptions().booleanOption("heavy_rainfall")) {
                entity.heatFromExternal -= 2;
                report = new Report(5027);
                report.subject = entity.getId();
                this.addReport(report);
            }
            if (this.game.getOptions().booleanOption("heavy_snowfall")) {
                --entity.heatFromExternal;
                report = new Report(5028);
                report.subject = entity.getId();
                this.addReport(report);
            }
            if (this.game.getOptions().booleanOption("light_rainfall")) {
                --entity.heatFromExternal;
                report = new Report(5029);
                report.subject = entity.getId();
                this.addReport(report);
            }
            if (iHex != null) {
                if (iHex.terrainLevel(7) == 2 && entity.getElevation() <= 1) {
                    entity.heatFromExternal += 5;
                    report = new Report(5030);
                    report.subject = entity.getId();
                    this.addReport(report);
                }
                if ((n4 = iHex.terrainLevel(24)) > 0 && entity.getElevation() == 0) {
                    entity.heatFromExternal += 5 * n4;
                    report = new Report(5032);
                    report.subject = entity.getId();
                    report.add(5 * n4);
                    this.addReport(report);
                }
            }
            if (entity.hasVibroblades()) {
                n4 = 0;
                n4 = entity.getActiveVibrobladeHeat(4);
                if ((n4 += entity.getActiveVibrobladeHeat(5)) > 0) {
                    report = new Report(5017);
                    report.subject = entity.getId();
                    report.add(n4);
                    this.addReport(report);
                    entity.heatBuildup += n4;
                }
            }
            n4 = 0;
            for (Mounted mounted : entity.getEquipment()) {
                if (!mounted.hasChargedCapacitor() || mounted.isUsedThisRound()) continue;
                n4 += 5;
            }
            if (n4 > 0) {
                report = new Report(5019);
                report.subject = entity.getId();
                report.add(n4);
                this.addReport(report);
                entity.heatBuildup += n4;
            }
            entity.heatBuildup += Math.min(15, entity.heatFromExternal);
            entity.heatFromExternal = 0;
            if (entity.heatBuildup < 0) {
                entity.heatBuildup = 0;
            }
            entity.heat += entity.heatBuildup;
            int n5 = entity.getHeatCapacityWithWater();
            int n6 = entity.hasInfernoAmmo() ? 9 : 13;
            int n7 = ((Mech)entity).getNumberOfSinks();
            for (Mounted mounted : entity.getEquipment()) {
                AmmoType ammoType;
                if (!(mounted.getType() instanceof AmmoType) || (ammoType = (AmmoType)mounted.getType()).getAmmoType() != 36 || !mounted.isAmmoUsable()) continue;
                EquipmentMode equipmentMode = mounted.curMode();
                if (equipmentMode.equals("dump")) {
                    report = new Report(5260);
                    report.subject = entity.getId();
                    this.addReport(report);
                    mounted.setShotsLeft(0);
                    n5 += n7;
                    break;
                }
                if (equipmentMode.equals("safe") && entity.heat - n5 > n6) {
                    report = new Report(5265);
                    report.subject = entity.getId();
                    this.addReport(report);
                    mounted.setShotsLeft(0);
                    n5 += n7;
                    break;
                }
                if (!equipmentMode.equals("efficient") || entity.heat - n5 < n7) continue;
                report = new Report(5270);
                report.subject = entity.getId();
                this.addReport(report);
                mounted.setShotsLeft(0);
                n5 += n7;
                break;
            }
            n5 = Math.min(n5, entity.heat);
            entity.heat -= n5;
            report = new Report(5035);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.heatBuildup);
            report.add(n5);
            report.add(entity.heat);
            this.addReport(report);
            entity.heatBuildup = 0;
            if (entity.hasInfernoAmmo() && entity.heat >= 10) {
                int n8 = 4 + (entity.heat >= 14 ? 2 : 0) + (entity.heat >= 19 ? 2 : 0) + (entity.heat >= 23 ? 2 : 0) + (entity.heat >= 28 ? 2 : 0);
                int n9 = Compute.d6(2);
                report = new Report(5040);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n8);
                report.add(n9);
                if (n9 >= n8) {
                    report.choose(true);
                    this.addReport(report);
                } else {
                    report.choose(false);
                    this.addReport(report);
                    this.addReport(this.explodeInfernoAmmoFromHeat(entity));
                }
            }
            if (this.game.getOptions().booleanOption("maxtech_heat")) {
                n3 = 50;
                bl2 = true;
            } else {
                n3 = 30;
                bl2 = false;
            }
            if (entity.heat < n3 && entity.isShutDown()) {
                if (entity.heat < 14) {
                    entity.setShutDown(false);
                    report = new Report(5045);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    this.addReport(report);
                } else {
                    int n10 = 4 + (entity.heat - 14) / 4 * 2;
                    if (bl2) {
                        n10 = entity.crew.getPiloting() + n10 - 8;
                    }
                    int n11 = Compute.d6(2);
                    report = new Report(5050);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    report.add(n10);
                    report.add(n11);
                    if (n11 >= n10) {
                        entity.setShutDown(false);
                        report.choose(true);
                    } else {
                        report.choose(false);
                    }
                    this.addReport(report);
                }
            } else if (entity.heat >= 14 && !entity.isShutDown()) {
                if (entity.heat >= n3) {
                    report = new Report(5055);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    this.addReport(report);
                    this.game.addPSR(new PilotingRollData(entity.getId(), 3, "reactor shutdown"));
                    this.addReport(this.resolvePilotingRolls());
                    entity.setShutDown(true);
                } else if (entity.heat >= 14) {
                    int n12 = 4 + (entity.heat - 14) / 4 * 2;
                    if (bl2) {
                        n12 = entity.crew.getPiloting() + n12 - 8;
                    }
                    int n13 = Compute.d6(2);
                    report = new Report(5060);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    report.add(n12);
                    report.add(n13);
                    if (n13 >= n12) {
                        report.choose(true);
                        this.addReport(report);
                    } else {
                        report.choose(false);
                        this.addReport(report);
                        this.game.addPSR(new PilotingRollData(entity.getId(), 3, "reactor shutdown"));
                        this.addReport(this.resolvePilotingRolls());
                        entity.setShutDown(true);
                    }
                }
            }
            if (entity.heat >= 19) {
                int n14 = 4 + (entity.heat >= 23 ? 2 : 0) + (entity.heat >= 28 ? 2 : 0);
                if (bl2) {
                    n14 += (entity.heat >= 35 ? 2 : 0) + (entity.heat >= 40 ? 2 : 0) + (entity.heat >= 45 ? 2 : 0);
                }
                if (entity instanceof Mech && ((Mech)entity).hasLaserHeatSinks()) {
                    --n14;
                }
                int n15 = Compute.d6(2);
                report = new Report(5065);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n14);
                report.add(n15);
                if (n15 >= n14) {
                    report.choose(true);
                    this.addReport(report);
                } else {
                    report.choose(false);
                    this.addReport(report);
                    this.addReport(this.explodeAmmoFromHeat(entity));
                }
            }
            int n16 = 0;
            boolean bl3 = bl = ((Mech)entity).getCockpitType() == 1;
            if (entity instanceof Mech && bl) {
                n16 = entity.getHitCriticals(0, 0, 2);
                n16 += entity.getHitCriticals(0, 0, 3);
            } else {
                n16 = entity.getHitCriticals(0, 0, 0);
            }
            if (n16 > 0 && (entity.heat >= 15 || bl && entity.heat >= 0) && !entity.crew.isDead() && !entity.crew.isDoomed() && !entity.crew.isEjected()) {
                n2 = 1;
                n = 0;
                if (entity.heat >= 47 && bl2) {
                    n2 = 47;
                    n = 5;
                } else if (entity.heat >= 39 && bl2) {
                    n2 = 39;
                    n = 4;
                } else if (entity.heat >= 32 && bl2) {
                    n2 = 32;
                    n = 3;
                } else if (entity.heat >= 25) {
                    n2 = 25;
                    n = 2;
                } else if (entity.heat >= 15) {
                    n2 = 15;
                    n = 1;
                }
                if (entity.heat > 0 && entity instanceof Mech && ((Mech)entity).getCockpitType() == 1 && !entity.crew.getOptions().booleanOption("pain_shunt")) {
                    ++n;
                }
                report = new Report(5070);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n2);
                report.add(n);
                this.addReport(report);
                this.addReport(this.damageCrew(entity, n));
            } else if (bl2 && entity.heat >= 32 && !entity.crew.isDead() && !entity.crew.isDoomed() && !entity.crew.getOptions().booleanOption("pain_shunt")) {
                n2 = Compute.d6(2);
                n = -1;
                if (entity.heat >= 47) {
                    n = 12;
                } else if (entity.heat >= 39) {
                    n = 10;
                } else if (entity.heat >= 32) {
                    n = 8;
                }
                report = new Report(5075);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n);
                report.add(n2);
                if (n2 >= n) {
                    report.choose(true);
                    this.addReport(report);
                } else {
                    report.choose(false);
                    this.addReport(report);
                    this.addReport(this.damageCrew(entity, 1));
                }
            }
            if ((entity.crew.isDead() || entity.crew.isDoomed()) && !entity.crew.isEjected()) {
                report = new Report(5080);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
                this.addReport(this.destroyEntity(entity, "crew death", true));
            }
            if (!bl2 || entity.heat < 36) continue;
            n2 = Compute.d6(2);
            n = -1;
            if (entity.heat >= 44) {
                n = 10;
            } else if (entity.heat >= 36) {
                n = 8;
            }
            report = new Report(5085);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(n);
            report.add(n2);
            report.newlines = 0;
            if (n2 >= n) {
                report.choose(true);
                this.addReport(report);
                continue;
            }
            report.choose(false);
            this.addReport(report);
            this.addReport(this.oneCriticalEntity(entity, Compute.randomInt(8)));
            report = new Report(1210);
            this.addReport(report);
        }
        if (this.vPhaseReport.size() == 1) {
            this.addReport(new Report(1205, 0));
        }
    }

    private void resolveExtremeTempInfantryDeath() {
        int n = this.game.getTemperatureDifference();
        if (n > 0) {
            Enumeration<Entity> enumeration = this.game.getEntities();
            while (enumeration.hasMoreElements()) {
                Report report;
                Entity entity = enumeration.nextElement();
                if (null == entity.getPosition()) continue;
                IHex iHex = this.game.getBoard().getHex(entity.getPosition());
                if (!(entity instanceof Infantry) || entity instanceof BattleArmor || iHex.containsTerrain(10) || entity.getTransportId() != -1) continue;
                if (this.game.getOptions().booleanOption("extreme_temperature_survival")) {
                    report = new Report(5310);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    report.add(n);
                    int n2 = Compute.d6();
                    report.add(n2);
                    this.addReport(report);
                    if (n2 > n) continue;
                    if (entity instanceof MechWarrior) {
                        this.addReport(this.damageCrew(entity, 1));
                    } else {
                        this.addReport(this.damageEntity(entity, entity.rollHitLocation(0, 0), Compute.d6() + n));
                    }
                    report = new Report(1210, 0);
                    this.addReport(report);
                    continue;
                }
                report = new Report(5090);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
                this.addReport(this.destroyEntity(entity, "heat/cold", false, false));
            }
        }
    }

    private void doFlamingDeath(Entity entity) {
        int n = Compute.d6(2);
        if (-1 != entity.getSwarmTargetId()) {
            return;
        }
        if (entity.getMovementMode() == 6 && !entity.infernos.isStillBurning() && entity.getElevation() > 1) {
            return;
        }
        for (Mounted mounted : entity.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!"BA-Fire Resistant Armor".equals(equipmentType.getInternalName())) continue;
            Report report = new Report(5095);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
            return;
        }
        Report report = new Report(5100);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(n);
        if (n >= 8) {
            report.choose(true);
            this.addReport(report);
        } else {
            report.choose(false);
            this.addReport(report);
            this.addReport(this.destroyEntity(entity, "fire", false, false));
        }
    }

    private void checkFor20Damage() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!(entity instanceof Mech) || entity.damageThisPhase < 20) continue;
            if (this.game.getOptions().booleanOption("maxtech_round_damage")) {
                int n = entity.damageThisPhase / 20;
                int n2 = 0;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(entity.damageThisPhase).append(" damage +").append(n);
                switch (entity.getWeightClass()) {
                    case 0: {
                        n2 = 1;
                        break;
                    }
                    case 1: {
                        n2 = 0;
                        break;
                    }
                    case 2: {
                        n2 = -1;
                        break;
                    }
                    case 3: {
                        n2 = -2;
                    }
                }
                if (n2 > 0) {
                    stringBuffer.append(", weight class modifier +").append(n2);
                } else {
                    stringBuffer.append(", weight class modifier ").append(n2);
                }
                PilotingRollData pilotingRollData = new PilotingRollData(entity.getId(), n + n2, stringBuffer.toString());
                pilotingRollData.setCumulative(false);
                this.game.addPSR(pilotingRollData);
                continue;
            }
            this.game.addPSR(new PilotingRollData(entity.getId(), 1, "20+ damage"));
        }
    }

    public void checkForFlamingDeath() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            IHex iHex;
            Entity entity = enumeration.nextElement();
            if (null == entity.getPosition() || entity instanceof Mech || entity.isDoomed() || entity.isDestroyed() || entity.isOffBoard() || !(iHex = this.game.getBoard().getHex(entity.getPosition())).containsTerrain(7) || entity.getElevation() > 1) continue;
            if (this.game.getOptions().booleanOption("vehicle_fires") && entity instanceof Tank) {
                this.addReport(this.checkForVehicleFire((Tank)entity, false));
                continue;
            }
            this.doFlamingDeath(entity);
        }
    }

    private void checkForVacuumDeath() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (null == entity.getPosition() || entity.isOffBoard() || !entity.doomedInVacuum()) continue;
            Report report = new Report(6015);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
            this.addReport(this.destroyEntity(entity, "being in a vacuum where it can't survive", true, true));
        }
    }

    private void checkForAtmosphereDeath() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (null == entity.getPosition() || entity.isOffBoard() || !entity.doomedInAtmosphere()) continue;
            Report report = new Report(6016);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
            this.addReport(this.destroyEntity(entity, "being in atmosphere where it can't survive", true, true));
        }
    }

    private void checkForSpaceDeath() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (null == entity.getPosition() || entity.isOffBoard() || !entity.doomedInSpace()) continue;
            Report report = new Report(6017);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
            this.addReport(this.destroyEntity(entity, "being in space where it can't survive", true, true));
        }
    }

    private void checkForSuffocation() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (null == entity.getPosition() || entity.isOffBoard()) continue;
            IHex iHex = this.game.getBoard().getHex(entity.getPosition());
            if (entity.getElevation() >= 0 || iHex.terrainLevel(4) <= 1 && (iHex.terrainLevel(4) != 1 || !entity.isProne()) || entity.getHitCriticals(0, 0, 0) <= 0) continue;
            Report report = new Report(6020);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
            this.addReport(this.damageCrew(entity, 1));
        }
    }

    private Vector<Report> resolvePilotingRolls() {
        Vector<Report> vector = new Vector<Report>();
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            vector.addAll(this.resolvePilotingRolls(enumeration.nextElement()));
        }
        this.game.resetPSRs();
        return vector;
    }

    private Vector<Report> resolvePilotingRolls(Entity entity) {
        return this.resolvePilotingRolls(entity, false, entity.getPosition(), entity.getPosition());
    }

    private Vector<Report> resolvePilotingRolls(Entity entity, boolean bl, Coords coords, Coords coords2) {
        PilotingRollData pilotingRollData;
        int n;
        Report report;
        Vector<Report> vector = new Vector<Report>();
        if (entity.isDoomed() || entity.isDestroyed() || entity.isOffBoard() || !entity.isDeployed()) {
            return vector;
        }
        TargetRoll targetRoll = null;
        Object object = this.game.getExtremeGravityPSRs();
        while (object.hasMoreElements()) {
            PilotingRollData pilotingRollData2 = object.nextElement();
            if (pilotingRollData2.getEntityId() != entity.getId()) continue;
            targetRoll = pilotingRollData2;
            this.game.resetExtremeGravityPSRs(entity);
        }
        if (targetRoll != null && targetRoll.getValue() != -2147483647) {
            report = new Report(2180);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(targetRoll.getLastPlainDesc());
            vector.add(report);
            int n2 = Compute.d6(2);
            report = new Report(2190);
            report.subject = entity.getId();
            report.add(targetRoll.getValueAsString());
            report.add(targetRoll.getDesc());
            report.add(n2);
            if (n2 < targetRoll.getValue()) {
                int n3;
                report.choose(false);
                vector.add(report);
                if (entity.moved == 1 || entity.moved == 4 || entity.moved == 2 || entity.moved == 5) {
                    if (entity instanceof Mech) {
                        int n4 = entity.mpUsed;
                        n3 = 0;
                        while (n4 > entity.getRunMP(false, false)) {
                            --n4;
                            ++n3;
                        }
                        vector.addAll(this.doExtremeGravityDamage(entity, n3));
                    } else if (entity instanceof Tank) {
                        int n5;
                        int n6 = n5 = entity.gotPavementBonus ? 1 : 0;
                        if (!entity.gotPavementBonus) {
                            n3 = entity.mpUsed;
                            int n7 = 0;
                            while (n3 > entity.getRunMP(false, false) + n5) {
                                --n3;
                                ++n7;
                            }
                            vector.addAll(this.doExtremeGravityDamage(entity, n7));
                        }
                    }
                }
                if (entity.moved == 3 && entity instanceof Mech) {
                    if (this.game.getOptions().floatOption("gravity") < 1.0f) {
                        int n8 = entity.mpUsed;
                        n3 = 0;
                        while (n8 > entity.getOriginalJumpMP()) {
                            --n8;
                            ++n3;
                        }
                        vector.addAll(this.doExtremeGravityDamage(entity, n3));
                    } else if (this.game.getOptions().floatOption("gravity") > 1.0f) {
                        int n9 = entity.getWalkMP(false, false) - entity.getWalkMP();
                        vector.addAll(this.doExtremeGravityDamage(entity, n9));
                    }
                }
            } else {
                report.choose(true);
                vector.add(report);
            }
        }
        if (!(entity instanceof Mech) || entity.isProne()) {
            return vector;
        }
        if (entity instanceof Mech && (n = (object = this.game.getBoard().getHex(coords2)).terrainLevel(4)) > 0 && entity.getElevation() != -object.depth() && (entity.getElevation() < 0 || entity.getElevation() == 0 && object.terrainLevel(16) != 0 && !object.containsTerrain(20)) && !entity.isMakingDfa()) {
            if (entity.hasUMU()) {
                return vector;
            }
            this.game.addPSR(new PilotingRollData(entity.getId(), 0x7FFFFFFE, "lost buoyancy"));
        }
        object = new Vector();
        StringBuffer stringBuffer = new StringBuffer();
        PilotingRollData pilotingRollData3 = entity.getBasePilotingRoll();
        entity.addPilotingModifierForTerrain(pilotingRollData3);
        Enumeration<PilotingRollData> enumeration = this.game.getPSRs();
        while (enumeration.hasMoreElements()) {
            pilotingRollData = enumeration.nextElement();
            if (pilotingRollData.getEntityId() != entity.getId()) continue;
            ((Vector)object).addElement(pilotingRollData);
            if (stringBuffer.length() > 0) {
                stringBuffer.append("; ");
            }
            stringBuffer.append(pilotingRollData.getPlainDesc());
            if (!pilotingRollData.isCumulative()) continue;
            pilotingRollData3.append(pilotingRollData);
        }
        if (((Vector)object).size() == 0) {
            return vector;
        }
        if (pilotingRollData3.getValue() == 0x7FFFFFFE || pilotingRollData3.getValue() == Integer.MAX_VALUE) {
            report = new Report(2275);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(((Vector)object).size());
            report.add(stringBuffer.toString());
            report.add(pilotingRollData3.getDesc());
            vector.add(report);
            if (bl) {
                vector.addAll(this.doEntityFallsInto(entity, coords, coords2, pilotingRollData3));
            } else {
                vector.addAll(this.doEntityFall(entity, pilotingRollData3));
            }
            return vector;
        }
        report = new Report(2280);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(((Vector)object).size());
        report.add(stringBuffer.toString());
        vector.add(report);
        report = new Report(2285);
        report.subject = entity.getId();
        report.add(pilotingRollData3.getValueAsString());
        report.add(pilotingRollData3.getDesc());
        vector.add(report);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            pilotingRollData = (PilotingRollData)((Vector)object).elementAt(i);
            PilotingRollData pilotingRollData4 = pilotingRollData3;
            report = new Report(2290);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.add(i + 1);
            report.add(pilotingRollData.getPlainDesc());
            vector.add(report);
            if (!pilotingRollData.isCumulative()) {
                report = new Report(2295);
                report.subject = entity.getId();
                report.newlines = 0;
                report.add(pilotingRollData.getValueAsString());
                pilotingRollData4 = new PilotingRollData(entity.getId());
                pilotingRollData4.append(pilotingRollData3);
                pilotingRollData4.append(pilotingRollData);
            }
            int n10 = Compute.d6(2);
            report = new Report(2300);
            report.subject = entity.getId();
            report.add(pilotingRollData4.getValueAsString());
            report.add(n10);
            if (n10 < pilotingRollData4.getValue()) {
                report.choose(false);
                vector.add(report);
                if (bl) {
                    vector.addAll(this.doEntityFallsInto(entity, coords, coords2, pilotingRollData3));
                } else {
                    vector.addAll(this.doEntityFall(entity, pilotingRollData3));
                }
                return vector;
            }
            report.choose(true);
            vector.add(report);
        }
        return vector;
    }

    private Vector<Report> damageCrew(Entity entity, int n) {
        Vector<Report> vector = new Vector<Report>();
        Pilot pilot = entity.getCrew();
        if (!(pilot.isDead() || pilot.isEjected() || pilot.isDoomed())) {
            pilot.setHits(pilot.getHits() + n);
            Report report = new Report(6025);
            report.subject = entity.getId();
            report.indent(2);
            report.addDesc(entity);
            report.add(pilot.getName());
            report.add(n);
            report.newlines = 0;
            vector.addElement(report);
            if (6 > pilot.getHits()) {
                vector.addAll(this.resolveCrewDamage(entity, n));
            } else if (!pilot.isDoomed()) {
                pilot.setDoomed(true);
                vector.addAll(this.destroyEntity(entity, "pilot death", true));
            }
        }
        return vector;
    }

    private Vector<Report> resolveCrewDamage(Entity entity, int n) {
        Vector<Report> vector = new Vector<Report>();
        int n2 = entity.getCrew().getHits();
        if (entity instanceof MechWarrior || !entity.isTargetable() || !entity.getCrew().isActive() || n == 0) {
            return vector;
        }
        if (entity.crew.getOptions().booleanOption("pain_shunt")) {
            return vector;
        }
        for (int i = n2 - n + 1; i <= n2; ++i) {
            int n3 = Compute.getConsciousnessNumber(i);
            boolean bl = false;
            do {
                if (bl) {
                    entity.crew.decreaseEdge();
                }
                int n4 = Compute.d6(2);
                if (entity.getCrew().getOptions().booleanOption("pain_resistance")) {
                    n4 = Math.min(12, n4 + 1);
                }
                Report report = new Report(6030);
                report.indent(2);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(entity.getCrew().getName());
                report.add(n3);
                report.add(n4);
                if (n4 >= n3) {
                    entity.crew.setKoThisRound(false);
                    report.choose(true);
                } else {
                    entity.crew.setKoThisRound(true);
                    report.choose(false);
                    if (entity.crew.hasEdgeRemaining() && entity.crew.getOptions().booleanOption("edge_when_ko")) {
                        bl = true;
                        vector.add(report);
                        report = new Report(6520);
                        report.subject = entity.getId();
                        report.addDesc(entity);
                        report.add(entity.getCrew().getName());
                        report.add(entity.crew.getOptions().intOption("edge"));
                    }
                }
                vector.add(report);
            } while (entity.crew.hasEdgeRemaining() && entity.crew.isKoThisRound() && entity.crew.getOptions().booleanOption("edge_when_ko"));
            if (!entity.crew.isKoThisRound()) continue;
            entity.crew.setUnconscious(true);
            return vector;
        }
        return vector;
    }

    private void resolveCrewWakeUp() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!entity.isTargetable() || !entity.crew.isUnconscious() || entity.crew.isKoThisRound() || !(entity instanceof Mech) && !(entity instanceof Protomech) && !(entity instanceof MechWarrior)) continue;
            int n = Compute.d6(2);
            if (entity.getCrew().getOptions().booleanOption("pain_resistance")) {
                n = Math.min(12, n + 1);
            }
            int n2 = Compute.getConsciousnessNumber(entity.crew.getHits());
            Report report = new Report(6029);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.getCrew().getName());
            report.add(n2);
            report.add(n);
            if (n >= n2) {
                report.choose(true);
                entity.crew.setUnconscious(false);
            } else {
                report.choose(false);
            }
            this.addReport(report);
        }
    }

    private Vector<Report> damageEntity(Entity entity, HitData hitData, int n, boolean bl) {
        return this.damageEntity(entity, hitData, n, bl, DamageType.NONE, false, false);
    }

    public Vector<Report> damageEntity(Entity entity, HitData hitData, int n) {
        return this.damageEntity(entity, hitData, n, false, DamageType.NONE, false, false);
    }

    public Vector<Report> damageEntity(Entity entity, HitData hitData, int n, boolean bl, DamageType damageType, boolean bl2) {
        return this.damageEntity(entity, hitData, n, bl, damageType, bl2, false);
    }

    private Vector<Report> damageEntity(Entity entity, HitData hitData, int n, boolean bl, DamageType damageType, boolean bl2, boolean bl3) {
        return this.damageEntity(entity, hitData, n, bl, damageType, bl2, bl3, true);
    }

    /*
     * WARNING - void declaration
     */
    public Vector<Report> damageEntity(Entity entity, HitData hitData, int n, boolean bl, DamageType damageType, boolean bl2, boolean bl3, boolean bl4) {
        int n2;
        boolean bl5;
        Mech mech;
        Report report;
        Vector<Report> vector = new Vector<Report>();
        int n3 = entity.getId();
        boolean bl6 = entity instanceof Mech && ((Mech)entity).getCockpitType() != 1 && hitData.getLocation() == 0 && (hitData.getEffect() & 0x20) != 32;
        for (HitData hitData2 = hitData.getUndoneLocation(); hitData2 != null; hitData2 = hitData2.getUndoneLocation()) {
            report = new Report(6500);
            report.subject = n3;
            report.indent(2);
            report.newlines = 0;
            report.addDesc(entity);
            report.add(entity.getLocationAbbr(hitData2));
            vector.addElement(report);
        }
        if (hitData.getUndoneLocation() != null) {
            report = new Report(6510);
            report.subject = n3;
            report.indent(2);
            report.newlines = 0;
            report.addDesc(entity);
            report.add(entity.crew.getOptions().intOption("edge"));
            vector.addElement(report);
        }
        boolean bl7 = false;
        if (bl && entity instanceof Mech && (mech = (Mech)entity).isAutoEject()) {
            bl7 = true;
            vector.addAll(this.ejectEntity(entity, true));
        }
        boolean bl8 = !(bl5 = entity instanceof BattleArmor) && entity instanceof Infantry;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = bl2;
        IHex iHex = null;
        boolean bl12 = false;
        boolean bl13 = false;
        boolean bl14 = false;
        if (entity instanceof Mech && entity.getArmorType() == 4) {
            bl12 = true;
        }
        if ((entity instanceof Mech || entity instanceof Tank) && entity.getArmorType() == 3) {
            bl13 = true;
        }
        if ((entity instanceof Mech || entity instanceof Tank) && entity.getArmorType() == 2) {
            bl14 = true;
        }
        int n4 = (hitData.getEffect() & 1) == 1 && !bl12 ? 1 : 0;
        int n5 = (hitData.getEffect() & 1) == 1 && bl12 ? 1 : 0;
        HitData hitData3 = null;
        if (entity instanceof Protomech && hitData.getLocation() == 6) {
            report = new Report(6035);
            report.subject = n3;
            report.indent(2);
            report.newlines = 0;
            vector.addElement(report);
            return vector;
        }
        if (n4 > 0 && entity instanceof BattleArmor) {
            if (hitData.getLocation() >= entity.locations() || entity.getInternal(hitData.getLocation()) <= 0) {
                report = new Report(6037);
                report.add(hitData.getLocation());
                report.subject = n3;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                return vector;
            }
            report = new Report(6225);
            report.add(entity.getLocationAbbr(hitData));
            report.subject = n3;
            report.indent(2);
            report.newlines = 0;
            vector.addElement(report);
            n4 = 0;
            n = Math.max(entity.getInternal(hitData.getLocation()) + entity.getArmor(hitData.getLocation()), n);
        }
        if (entity.getArmor(hitData) > 0 && (entity.getArmorType() == 1 || entity.getArmorType() == 5 || entity.getArmorType() == 6)) {
            bl9 = true;
        }
        if (!(!bl8 || entity.isDestroyed() || entity.isDoomed() || ((Infantry)entity).getDugIn() == 2 || (iHex = this.game.getBoard().getHex(entity.getPosition())) == null || iHex.containsTerrain(1) || iHex.containsTerrain(23) || iHex.containsTerrain(2) || iHex.containsTerrain(3) || iHex.containsTerrain(9) || iHex.containsTerrain(10) || iHex.containsTerrain(33) || iHex.containsTerrain(21) || bl)) {
            n *= 2;
            report = new Report(6040);
            report.subject = n3;
            report.indent(2);
            report.newlines = 0;
            vector.addElement(report);
        }
        if ((bl8 || bl5) && !entity.isDestroyed() && !entity.isDoomed() && this.game.getOptions().booleanOption("vacuum")) {
            n *= 2;
            report = new Report(6041);
            report.subject = n3;
            report.indent(2);
            report.newlines = 0;
            vector.addElement(report);
        }
        switch (damageType) {
            case FRAGMENTATION: {
                if (bl8) break;
                n = 0;
                report = new Report(6050);
                report.subject = n3;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                break;
            }
            case FLECHETTE: {
                if (!bl8 && !bl5) {
                    n /= 2;
                    report = new Report(6060);
                    report.subject = n3;
                    report.indent(2);
                    report.newlines = 0;
                    vector.addElement(report);
                    break;
                }
                if (!bl8 || bl5) break;
                report = new Report(6055);
                report.subject = n3;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                break;
            }
            case ACID: {
                if (bl9) {
                    n = entity.getArmor(hitData) >= 3 ? 3 : entity.getArmor(hitData);
                    report = new Report(6061);
                    report.subject = n3;
                    report.indent(2);
                    report.newlines = 0;
                    report.add(n);
                    vector.addElement(report);
                    break;
                }
                report = new Report(6062);
                report.subject = n3;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                break;
            }
            case INCENDIARY: {
                if (!bl8) break;
                n += 2;
                report = new Report(6064);
                report.subject = n3;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                break;
            }
            case FIREDRAKE: {
                if (!bl8) {
                    n = 0;
                    report = new Report(6540);
                    report.subject = n3;
                    report.indent(2);
                    report.newlines = 0;
                    vector.addElement(report);
                }
            }
            case ANTI_TSM: {
                entity.hitThisRoundByAntiTSM = true;
            }
        }
        if (entity instanceof VTOL && hitData.getLocation() == 5) {
            n = (n + 9) / 10;
        }
        boolean bl15 = entity.hasActiveEiCockpit();
        if (!(entity instanceof Mech) && !(entity instanceof Protomech) && bl15) {
            ++n;
        }
        while (n > 0) {
            int n6;
            int n7;
            Mech mech2;
            int n8;
            report = new Report(6065);
            report.subject = n3;
            report.indent(2);
            report.newlines = 0;
            report.addDesc(entity);
            report.add(n);
            if (bl2) {
                report.messageId = 6070;
            }
            report.add(entity.getLocationAbbr(hitData));
            vector.addElement(report);
            if (entity.getInternal(hitData) == -2) {
                n4 = 0;
            }
            if (!bl && !hitData.isFallDamage() && !bl2 && entity.hasShield() && (hitData.getEffect() & 0x20) != 32 && (n8 = (mech2 = (Mech)entity).shieldAbsorptionDamage(n, hitData.getLocation(), hitData.isRear())) != n) {
                n7 = n - n8;
                entity.damageThisPhase += n7;
                n = n8;
                report = new Report(3530);
                report.subject = n3;
                report.indent(3);
                report.newlines = 0;
                report.add(n7);
                vector.addElement(report);
                if (n <= 0) {
                    n4 = 0;
                    n5 = 0;
                    bl6 = false;
                }
            }
            if (entity instanceof Mech && (mech2 = (Mech)entity).hasCowl() && hitData.getLocation() == 0 && !bl4) {
                n8 = mech2.damageCowl(n);
                n7 = n - n8;
                mech2.damageThisPhase += n7;
                n = n8;
                report = new Report(3520);
                report.subject = n3;
                report.indent(3);
                report.newlines = 0;
                report.add(n7);
                vector.addElement(report);
            }
            n2 = 0;
            if (entity.hasSpotlight()) {
                n2 = 1;
                n8 = hitData.getLocation();
                if (entity instanceof Mech) {
                    if (n8 != 1 && n8 != 3 && n8 != 2) {
                        n2 = 0;
                    }
                } else if (entity instanceof Tank && n8 != 1 && n8 != 2 && n8 != 3) {
                    n2 = 0;
                }
                if (n2 != 0) {
                    n7 = Compute.d6(2);
                    report = new Report(6072);
                    report.indent(2);
                    report.subject = n3;
                    report.add(n7);
                    vector.addElement(report);
                    if (n7 >= 7) {
                        report = new Report(6071);
                        report.subject = n3;
                        report.indent(2);
                        vector.addElement(report);
                        entity.setSpotlightState(false);
                        entity.setSpotlight(false);
                    }
                }
            }
            if (!bl2) {
                n8 = hitData.getLocation();
                Entity entity2 = entity.getExteriorUnitAt(n8, hitData.isRear());
                if (!bl && null != entity2 && Compute.d6() >= 5 && !entity2.isDoomed() && damageType != DamageType.IGNORE_PASSENGER) {
                    HitData hitData2;
                    report = new Report(6075);
                    report.subject = entity2.getId();
                    report.indent(3);
                    report.addDesc(entity2);
                    vector.addElement(report);
                    HitData hitData4 = entity2.getTrooperAtLocation(hitData, entity);
                    n6 = 0;
                    HitData hitData5 = hitData4;
                    do {
                        void var33_65;
                        if (0 < entity2.getArmor((HitData)var33_65)) {
                            n6 += entity2.getArmor((HitData)var33_65);
                        }
                        if (0 < entity2.getInternal((HitData)var33_65)) {
                            n6 += entity2.getInternal((HitData)var33_65);
                        }
                        hitData2 = entity2.getTransferLocation((HitData)var33_65);
                    } while (n > n6 && hitData2.getLocation() >= 0);
                    vector.addAll(this.damageEntity(entity2, hitData4, n));
                    if (n > n6) {
                        report = new Report(6080);
                        report.subject = n3;
                        report.indent(1);
                        report.add(n -= n6);
                        report.addDesc(entity);
                        vector.addElement(report);
                    } else {
                        return vector;
                    }
                }
                boolean bl16 = n8 == 1 || n8 == 2 || n8 == 3;
                n6 = entity.getSwarmAttackerId();
                if ((!(entity instanceof Mech) || bl16) && n6 != -1 && (hitData.getEffect() & 1) == 0 && Compute.d6() >= 5 && damageType != DamageType.IGNORE_PASSENGER) {
                    Entity entity3 = this.game.getEntity(n6);
                    report = new Report(6076);
                    report.subject = n6;
                    report.indent(3);
                    report.addDesc(entity3);
                    vector.addElement(report);
                    HitData hitData6 = entity3.rollHitLocation(0, 0);
                    int n9 = 0;
                    HitData hitData7 = hitData6;
                    do {
                        if (0 < entity3.getArmor(hitData7)) {
                            n9 += entity3.getArmor(hitData7);
                        }
                        if (0 < entity3.getInternal(hitData7)) {
                            n9 += entity3.getInternal(hitData7);
                        }
                        hitData7 = entity3.getTransferLocation(hitData7);
                    } while (n > n9 && hitData7.getLocation() >= 0);
                    vector.addAll(this.damageEntity(entity3, hitData6, n));
                    if (n > n9) {
                        report = new Report(6080);
                        report.subject = n3;
                        report.indent(1);
                        report.add(n -= n9);
                        report.addDesc(entity);
                        vector.addElement(report);
                    } else {
                        return vector;
                    }
                }
                if (entity instanceof Mech && hitData.isRear() && bl16 || entity instanceof Tank && hitData.getLocation() == 4) {
                    for (Mounted mounted : entity.getAmmo()) {
                        if (!mounted.isDumping() || mounted.isDestroyed() || mounted.isHit()) continue;
                        vector.addAll(this.explodeEquipment(entity, mounted.getLocation(), mounted));
                        mounted.setHit(true);
                    }
                }
            }
            if (!bl && entity.getArmor(hitData) > 0 && !bl2) {
                n8 = -1;
                int n10 = n;
                if (bl12) {
                    n8 = n;
                    n = (int)Math.ceil((double)n / 2.0);
                    report = new Report(6069);
                    report.subject = n3;
                    report.indent(2);
                    report.newlines = 0;
                    report.add(n);
                    vector.addElement(report);
                } else if (bl8) {
                    int n11 = entity.getArmor(hitData);
                    n6 = entity.getInternal(hitData);
                    n8 = n % 2;
                    n /= 2;
                    n8 = n8 == 1 && n11 >= n6 ? n++ : (n8 += n);
                } else if (bl13 && hitData.getGeneralDamageType() == -2) {
                    n8 = n;
                    report = new Report(6066);
                    report.subject = n3;
                    report.indent(2);
                    report.newlines = 0;
                    report.add(n *= 2);
                    vector.addElement(report);
                } else if (bl13 && hitData.getGeneralDamageType() == -3) {
                    n8 = n;
                    n = (int)Math.ceil((double)n / 2.0);
                    report = new Report(6067);
                    report.subject = n3;
                    report.indent(2);
                    report.newlines = 0;
                    report.add(n);
                    vector.addElement(report);
                } else if (bl14 && hitData.getGeneralDamageType() == -4) {
                    n8 = n;
                    n = (int)Math.ceil((double)n / 2.0);
                    report = new Report(6068);
                    report.subject = n3;
                    report.indent(2);
                    report.newlines = 0;
                    report.add(n);
                    vector.addElement(report);
                }
                if (entity.getArmor(hitData) >= n) {
                    entity.setArmor(entity.getArmor(hitData) - n, hitData);
                    entity.damageThisPhase = n8 >= 0 ? (entity.damageThisPhase += n8) : (entity.damageThisPhase += n);
                    n = 0;
                    report = new Report(6085);
                    report.subject = n3;
                    report.newlines = 0;
                    if (n2 != 0) {
                        report.indent(3);
                    }
                    report.add(entity.getArmor(hitData));
                    vector.addElement(report);
                } else {
                    int n12 = Math.max(entity.getArmor(hitData), 0);
                    if (bl13 && hitData.getGeneralDamageType() == -2) {
                        n12 = (int)Math.round(Math.ceil(n12 / 2));
                        n = n8;
                        n8 = 0;
                    }
                    entity.setArmor(-3, hitData);
                    entity.damageThisPhase = n8 >= 0 ? (entity.damageThisPhase += 2 * n12) : (entity.damageThisPhase += n12);
                    n -= n12;
                    report = new Report(6090);
                    report.subject = n3;
                    report.newlines = 0;
                    if (n2 != 0) {
                        report.indent(3);
                    }
                    vector.addElement(report);
                    if (entity instanceof GunEmplacement) {
                        entity.destroyLocation(hitData.getLocation());
                        report = new Report(6115);
                        report.subject = n3;
                        report.newlines = 0;
                        vector.addElement(report);
                        if (entity.getTransferLocation(hitData).getLocation() == -2) {
                            vector.addAll(this.destroyEntity(entity, "damage", false));
                        }
                    }
                }
                if (entity instanceof SupportTank || entity instanceof SupportVTOL) {
                    if (entity instanceof SupportTank) {
                        SupportTank supportTank = (SupportTank)entity;
                        if (n10 > supportTank.getBARRating()) {
                            if (hitData.getSpecCritMod() < 0) {
                                if (supportTank.getBARRating() < 10) {
                                    Report.addNewline(vector);
                                    vector.addAll(this.criticalTank(supportTank, hitData.getLocation(), 2 + hitData.getSpecCritMod()));
                                } else {
                                    Report.addNewline(vector);
                                    vector.addAll(this.criticalTank(supportTank, hitData.getLocation(), 0 + hitData.getSpecCritMod()));
                                }
                            }
                            if (supportTank.hasArmoredChassis()) {
                                if (supportTank.getBARRating() < 10) {
                                    Report.addNewline(vector);
                                    vector.addAll(this.criticalTank(supportTank, hitData.getLocation(), 1));
                                }
                            } else {
                                Report.addNewline(vector);
                                vector.addAll(this.criticalTank(supportTank, hitData.getLocation(), 0));
                            }
                        }
                    } else {
                        SupportVTOL supportVTOL = (SupportVTOL)entity;
                        if (n10 > supportVTOL.getBARRating()) {
                            if (hitData.getSpecCritMod() < 0) {
                                if (supportVTOL.getBARRating() < 10) {
                                    vector.addAll(this.criticalTank(supportVTOL, hitData.getLocation(), 2 + hitData.getSpecCritMod()));
                                } else {
                                    vector.addAll(this.criticalTank(supportVTOL, hitData.getLocation(), 0 + hitData.getSpecCritMod()));
                                }
                            }
                            if (supportVTOL.hasArmoredChassisAndControl()) {
                                if (supportVTOL.getBARRating() < 10) {
                                    vector.addAll(this.criticalTank(supportVTOL, hitData.getLocation(), 1));
                                }
                            } else {
                                vector.addAll(this.criticalTank(supportVTOL, hitData.getLocation(), 0));
                            }
                        }
                    }
                }
                if (n8 > 0) {
                    if (bl12) {
                        n *= 2;
                        n -= n8 % 2;
                    } else if (bl8) {
                        n = n8;
                    }
                }
            }
            if (n > 0) {
                if (bl && entity.hasCASEII(hitData.getLocation())) {
                    entity.damageThisPhase += n;
                    report = new Report(6126);
                    report.subject = n3;
                    report.add(--n);
                    report.indent(3);
                    report.newlines = 0;
                    vector.addElement(report);
                    n8 = entity.hasRearArmor(hitData.getLocation()) ? 1 : 0;
                    if (n > entity.getArmor(hitData.getLocation(), n8 != 0)) {
                        entity.setArmor(-3, hitData.getLocation(), n8 != 0);
                    } else {
                        entity.setArmor(entity.getArmor(hitData.getLocation(), n8 != 0) - n, hitData.getLocation(), n8 != 0);
                    }
                    n = entity.getInternal(hitData) > 0 ? 1 : 0;
                    int n13 = Compute.d6(2);
                    report = new Report(6127);
                    report.subject = entity.getId();
                    report.add(n13);
                    report.newlines = 0;
                    vector.add(report);
                    if (n13 >= 8) {
                        hitData.setEffect(32);
                    }
                }
                if (bl && entity instanceof Tank && entity.locationHasCase(0)) {
                    entity.damageThisPhase += n;
                    report = new Report(6124);
                    report.subject = n3;
                    report.indent(2);
                    report.add(n);
                    vector.add(report);
                    if (n > entity.getArmor(4)) {
                        entity.setArmor(-3, 4);
                        report = new Report(6090);
                    } else {
                        entity.setArmor(entity.getArmor(4) - n, 4);
                        report = new Report(6085);
                        report.add(entity.getArmor(4));
                    }
                    report.subject = n3;
                    report.newlines = 0;
                    report.indent(2);
                    vector.add(report);
                    n = 0;
                    n8 = ((Tank)entity).isCommanderHit() && ((Tank)entity).isDriverHit() ? 6 : 7;
                    vector.addAll(this.applyCriticalHit(entity, -1, new CriticalSlot(0, n8), true));
                }
                if (entity.getInternal(hitData) > 0) {
                    n8 = -1;
                    if (entity instanceof Mech && ((Mech)entity).hasCompositeStructure()) {
                        n8 = n;
                        n *= 2;
                    }
                    if (entity instanceof Mech && ((Mech)entity).hasReinforcedStructure()) {
                        n8 = n;
                        n /= 2;
                        n += n8 % 2;
                    }
                    if (entity.getInternal(hitData) > n && n > 0) {
                        entity.setInternal(entity.getInternal(hitData) - n, hitData);
                        if (!bl8 && !bl5) {
                            ++n4;
                        }
                        bl11 = true;
                        entity.damageThisPhase += n;
                        n = 0;
                        report = new Report(1210);
                        report.subject = n3;
                        report.newlines = 0;
                        report.messageId = bl8 ? 6095 : 6100;
                        report.add(entity.getInternal(hitData));
                        vector.addElement(report);
                    } else if (n > 0) {
                        Entity entity3;
                        int n14;
                        if (!bl8 && !bl5) {
                            ++n4;
                        }
                        int n15 = Math.max(entity.getInternal(hitData), 0);
                        if (entity instanceof Protomech && (n14 = Protomech.POSSIBLE_PILOT_DAMAGE[hitData.getLocation()] - ((Protomech)entity).getPilotDamageTaken(hitData.getLocation())) > 0) {
                            vector.addAll(this.damageCrew(entity, n14));
                            ((Protomech)entity).setPilotDamageTaken(hitData.getLocation(), Protomech.POSSIBLE_PILOT_DAMAGE[hitData.getLocation()]);
                        }
                        report = new Report(1210);
                        report.subject = n3;
                        report.newlines = 0;
                        report.messageId = bl8 ? 6105 : (bl5 ? 6110 : 6115);
                        vector.addElement(report);
                        if (entity instanceof Mech && (hitData.getLocation() == 2 && entity.getInternal(4) > 0 || hitData.getLocation() == 3 && entity.getInternal(5) > 0)) {
                            int n16 = -1;
                            n16 = hitData.getLocation() == 2 ? 4 : 5;
                            report = new Report(6120);
                            report.subject = n3;
                            report.add(entity.getLocationName(n16));
                            report.newlines = 0;
                            vector.addElement(report);
                            IHex iHex2 = this.game.getBoard().getHex(entity.getPosition());
                            if (entity instanceof BipedMech) {
                                if (!iHex2.containsTerrain(18)) {
                                    iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(18, 1));
                                } else {
                                    iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(18, iHex2.terrainLevel(18) + 1));
                                }
                            } else if (!iHex2.containsTerrain(19)) {
                                iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(19, 1));
                            } else {
                                iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(19, iHex2.terrainLevel(19) + 1));
                            }
                            this.sendChangedHex(entity.getPosition());
                        }
                        if ((entity instanceof Mech || entity instanceof Tank) && null != (entity3 = entity.getExteriorUnitAt(hitData.getLocation(), hitData.isRear())) && !entity3.isDoomed()) {
                            HitData hitData5 = entity3.getTrooperAtLocation(hitData, entity);
                            hitData5.setEffect(1);
                            if (entity3.getInternal(hitData5) > 0) {
                                vector.addAll(this.damageEntity(entity3, hitData5, n));
                            }
                            hitData5 = new HitData(hitData.getLocation(), !hitData.isRear());
                            hitData5 = entity3.getTrooperAtLocation(hitData5, entity);
                            hitData5.setEffect(1);
                            if (entity3.getInternal(hitData5) > 0) {
                                vector.addAll(this.damageEntity(entity3, hitData5, n));
                            }
                        }
                        if (entity instanceof BattleArmor) {
                            int n17 = 0;
                            for (Mounted mounted : entity.getEquipment()) {
                                if (mounted.getType() instanceof AmmoType) {
                                    AmmoType ammoType = (AmmoType)mounted.getType();
                                    if (ammoType.getAmmoType() != 9 && ammoType.getAmmoType() != 45 || ammoType.getMunitionType() != 0x10000000L) continue;
                                    n17 += ammoType.getRackSize() * mounted.getShotsLeft();
                                    continue;
                                }
                                if (!"BA-Fire Resistant Armor".equals(mounted.getType().getInternalName())) continue;
                                n17 = 0;
                                break;
                            }
                            if (n17 > 0) {
                                int n18 = Compute.d6(2);
                                report = new Report(6680);
                                report.add(n18);
                                vector.add(report);
                                if (n18 >= 8) {
                                    void var33_72;
                                    Coords coords = entity.getPosition();
                                    if (coords == null) {
                                        Entity entity4 = this.game.getEntity(entity.getTransportId());
                                        if (entity4 != null) {
                                            Coords coords2 = entity4.getPosition();
                                        }
                                        this.vPhaseReport.addAll(this.deliverInfernoMissiles(entity, entity, n17));
                                    }
                                    if (var33_72 != null) {
                                        this.vPhaseReport.addAll(this.deliverInfernoMissiles(entity, new HexTarget((Coords)var33_72, this.game.getBoard(), 7), n17));
                                    }
                                }
                            }
                        }
                        entity.destroyLocation(hitData.getLocation());
                        entity.damageThisPhase += n15;
                        n -= n15;
                        if (n8 > 0) {
                            if (((Mech)entity).hasCompositeStructure()) {
                                n /= 2;
                            } else if (((Mech)entity).hasReinforcedStructure()) {
                                n *= 2;
                                n -= n8 % 2;
                            }
                        }
                        if (entity instanceof Mech && (hitData.getLocation() == 2 || hitData.getLocation() == 3)) {
                            boolean bl17 = false;
                            int n19 = 0;
                            n19 += entity.getHitCriticals(0, 3, 1);
                            n19 += entity.getHitCriticals(0, 3, 2);
                            bl17 = this.checkEngineExplosion(entity, vector, n19 += entity.getHitCriticals(0, 3, 3));
                            if (!bl17 && n19 > 2) {
                                vector.addAll(this.destroyEntity(entity, "engine destruction"));
                                if (this.game.getOptions().booleanOption("auto_abandon_unit")) {
                                    vector.addAll(this.abandonEntity(entity));
                                }
                            }
                        }
                        if (entity instanceof VTOL && hitData.getLocation() == 5) {
                            entity.setOriginalWalkMP(0);
                            vector.addAll(this.crashVTOLorWiGE((VTOL)entity));
                        }
                    }
                }
                if (entity.getInternal(hitData) <= 0) {
                    hitData3 = entity.getTransferLocation(hitData);
                    if (hitData3.getLocation() == -2) {
                        if (entity instanceof Mech) {
                            entity.engineHitsThisRound += entity.getGoodCriticals(0, 3, hitData.getLocation());
                            entity.engineHitsThisRound -= entity.getHitCriticals(0, 3, hitData.getLocation());
                        }
                        n8 = 0;
                        n8 = this.checkEngineExplosion(entity, vector, entity.engineHitsThisRound) ? 1 : 0;
                        if (!(n8 != 0 || entity instanceof VTOL && hitData.getLocation() == 5)) {
                            vector.addAll(this.destroyEntity(entity, "damage", !bl, !bl && !bl3 || !(entity instanceof Tank) && (!(entity instanceof Mech) || hitData.getLocation() != 1)));
                            if (hitData.getLocation() == 0 || hitData.getLocation() == 1 && (bl && !bl7 || bl3)) {
                                entity.getCrew().setDoomed(true);
                            }
                            if (this.game.getOptions().booleanOption("auto_abandon_unit")) {
                                vector.addAll(this.abandonEntity(entity));
                            }
                        }
                        n = 0;
                    } else if (hitData3.getLocation() == -1) {
                        n = 0;
                    } else if (bl && entity.locationHasCase(hitData.getLocation())) {
                        report = new Report(6125);
                        report.subject = n3;
                        report.add(n);
                        report.indent(3);
                        report.newlines = 0;
                        vector.addElement(report);
                        entity.damageThisPhase += n;
                        n = 0;
                    } else if (n > 0) {
                        report = new Report(6130);
                        report.subject = n3;
                        report.indent(2);
                        report.newlines = 0;
                        report.add(n);
                        report.add(entity.getLocationAbbr(hitData3));
                        vector.addElement(report);
                        for (Mounted mounted : entity.getWeaponList()) {
                            if (!mounted.isSplit() || mounted.getLocation() != hitData.getLocation() && mounted.getLocation() != hitData3.getLocation()) continue;
                            entity.setWeaponDestroyed(mounted);
                        }
                    }
                }
            } else if (hitData.getSpecCritMod() < 0) {
                ++n5;
            }
            vector.addAll(this.breachCheck(entity, hitData.getLocation(), null));
            if ((hitData.getEffect() & 2) == 2) {
                vector.addAll(this.vehicleMotiveDamage((Tank)entity, hitData.getMotiveMod()));
            } else if ((hitData.getEffect() & 4) == 4) {
                report = new Report(6146);
                report.subject = n3;
                report.indent(3);
                vector.addElement(report);
                for (Mounted mounted : entity.getWeaponList()) {
                    mounted.setDestroyed(true);
                }
            } else if ((hitData.getEffect() & 8) == 8) {
                report = new Report(6145);
                report.subject = n3;
                report.indent(3);
                vector.addElement(report);
                ((GunEmplacement)entity).setTurretLocked(true);
            } else if ((hitData.getEffect() & 0x10) == 16) {
                report = new Report(6148);
                report.subject = n3;
                report.indent(3);
                vector.addElement(report);
                ((GunEmplacement)entity).getCrew().setDoomed(true);
            }
            if (entity.getInternal(hitData) != -3 && (hitData.getEffect() & 0x20) != 32) {
                int n20;
                for (n20 = 0; n20 < n4; ++n20) {
                    ++vector.elementAt((int)(vector.size() - 1)).newlines;
                    vector.addAll(this.criticalEntity(entity, hitData.getLocation(), hitData.glancingMod()));
                }
                n4 = 0;
                for (n20 = 0; n20 < n5; ++n20) {
                    ++vector.elementAt((int)(vector.size() - 1)).newlines;
                    vector.addAll(this.criticalEntity(entity, hitData.getLocation(), (bl12 ? -2 : hitData.getSpecCritMod()) + hitData.glancingMod()));
                }
                n5 = 0;
            }
            if (bl6) {
                Report.addNewline(vector);
                vector.addAll(this.damageCrew(entity, 1));
            }
            hitData = hitData3;
            if (!bl2) continue;
            bl10 = true;
            bl2 = false;
        }
        if (bl11 && (entity instanceof Mech || entity instanceof Protomech) && entity.hasActiveEiCockpit()) {
            Report.addNewline(vector);
            n2 = Compute.d6(2);
            report = new Report(5075);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(7);
            report.add(n2);
            report.choose(n2 >= 7);
            report.indent(2);
            vector.add(report);
            if (n2 < 7) {
                vector.addAll(this.damageCrew(entity, 1));
            }
        }
        if (bl11 && entity.crew.getOptions().booleanOption("vdni") && !entity.crew.getOptions().booleanOption("bvdni") && !entity.crew.getOptions().booleanOption("pain_shunt")) {
            Report.addNewline(vector);
            n2 = Compute.d6(2);
            report = new Report(3580);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(7);
            report.add(n2);
            report.choose(n2 >= 8);
            report.indent(2);
            vector.add(report);
            if (n2 >= 8) {
                vector.addAll(this.damageCrew(entity, 1));
            }
        }
        if (bl8) {
            float f = 0.0f;
            for (Mounted mounted : entity.getWeaponList()) {
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (weaponType.hasFlag(2048L) || !((f += weaponType.getTonnage(entity)) > (float)entity.getInternal(0))) continue;
                mounted.setDestroyed(true);
            }
        }
        if (bl10) {
            Report.addNewline(vector);
        }
        return vector;
    }

    private boolean checkEngineExplosion(Entity entity, Vector<Report> vector, int n) {
        int n2;
        if (!(entity instanceof Mech || entity instanceof QuadMech || entity instanceof BipedMech)) {
            return false;
        }
        if (entity.isDestroyed()) {
            return false;
        }
        Mech mech = (Mech)entity;
        if (entity.rolledForEngineExplosion) {
            return false;
        }
        if (mech.getEngine().isFusion() && (!this.game.getOptions().booleanOption("engine_explosions") || entity.engineHitsThisRound < 2)) {
            return false;
        }
        int n3 = 12;
        if (!mech.getEngine().isFusion()) {
            switch (n) {
                case 0: {
                    return false;
                }
                case 1: {
                    n3 = 10;
                    break;
                }
                case 2: {
                    n3 = 7;
                    break;
                }
                default: {
                    n3 = 4;
                }
            }
        }
        boolean bl = (n2 = Compute.d6(2)) >= n3;
        Report report = new Report(6150);
        report.subject = entity.getId();
        report.indent(2);
        report.addDesc(entity);
        report.add(entity.engineHitsThisRound);
        vector.addElement(report);
        report = new Report(6155);
        report.subject = entity.getId();
        report.indent(2);
        report.add(n3);
        report.add(n2);
        vector.addElement(report);
        if (!bl) {
            if (mech.getEngine().isFusion()) {
                entity.rolledForEngineExplosion = true;
            }
            report = new Report(6160);
            report.subject = entity.getId();
            report.indent(2);
            vector.addElement(report);
        } else {
            IHex iHex;
            entity.rolledForEngineExplosion = true;
            report = new Report(6165, 0);
            report.subject = entity.getId();
            report.indent(2);
            vector.addElement(report);
            vector.addAll(this.destroyEntity(entity, "engine explosion", false, false));
            entity.getCrew().setDoomed(true);
            if (entity instanceof Mech) {
                entity.destroyLocation(1);
            }
            if (this.game.getOptions().booleanOption("fire") && null != (iHex = this.game.getBoard().getHex(entity.getPosition())) && !iHex.containsTerrain(7) && (iHex.containsTerrain(1) || iHex.containsTerrain(23))) {
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                report = new Report(6170, 0);
                report.subject = entity.getId();
                report.indent(2);
                report.add(entity.getPosition().getBoardNum());
                vector.addElement(report);
                this.sendChangedHex(entity.getPosition());
            }
            if (mech.getEngine().isFusion()) {
                int n4 = entity.getEngine().getRating();
                this.doFusionEngineExplosion(n4, entity.getPosition(), vector, null);
            }
        }
        return bl;
    }

    public void doFusionEngineExplosion(int n, Coords coords, Vector<Report> vector, Vector<Integer> vector2) {
        int[] nArray = new int[]{n, n / 10, n / 20, n / 40};
        this.doExplosion(nArray, true, coords, false, vector, vector2);
    }

    public void doExplosion(int n, int n2, boolean bl, Coords coords, boolean bl2, Vector<Report> vector, Vector<Integer> vector2) {
        if (n2 < 1) {
            return;
        }
        int[] nArray = new int[n / n2];
        if (nArray.length < 1) {
            return;
        }
        nArray[0] = n;
        for (int i = 1; i < nArray.length; ++i) {
            nArray[i] = nArray[i - 1] - n2;
        }
        this.doExplosion(nArray, bl, coords, bl2, vector, vector2);
    }

    /*
     * WARNING - void declaration
     */
    public void doExplosion(int[] nArray, boolean bl, Coords coords, boolean bl2, Vector<Report> vector, Vector<Integer> vector2) {
        Report report;
        Serializable serializable;
        Iterator iterator;
        Serializable serializable3;
        if (vector == null) {
            vector = new Vector();
        }
        if (vector2 == null) {
            vector2 = new Vector();
        }
        HashSet<Entity> hashSet = new HashSet<Entity>();
        Enumeration<Building> enumeration = this.game.getBoard().getBuildings();
        while (enumeration.hasMoreElements()) {
            Serializable serializable2;
            Coords coords2;
            serializable3 = enumeration.nextElement();
            iterator = ((Building)serializable3).getCoords();
            try {
                coords2 = iterator.nextElement();
            }
            catch (Exception exception) {
                continue;
            }
            int n = coords.distance(coords2);
            while (iterator.hasMoreElements()) {
                void serializable22;
                serializable2 = (Coords)iterator.nextElement();
                if (coords.distance((Coords)serializable22) >= n) continue;
                n = coords.distance((Coords)serializable22);
                Serializable serializable4 = serializable2;
            }
            if (n >= nArray.length) continue;
            serializable2 = this.damageBuilding((Building)serializable3, nArray[n]);
            Iterator iterator2 = ((Vector)serializable2).iterator();
            while (iterator2.hasNext()) {
                Report report2 = (Report)iterator2.next();
                report2.type = 0;
            }
            vector.addAll((Collection<Report>)((Object)serializable2));
        }
        this.applyBuildingDamage();
        serializable3 = new ArrayList();
        for (Entity entity : this.game.getEntitiesVector()) {
            if (hashSet.contains(entity) || entity.isDestroyed() || !entity.isDeployed()) continue;
            serializable = entity.getPosition();
            if (serializable == null) {
                Entity entity2 = this.game.getEntity(entity.getTransportId());
                if (entity2 == null) continue;
                ((ArrayList)serializable3).add(entity);
                continue;
            }
            int n = coords.distance((Coords)serializable);
            if (n >= nArray.length) continue;
            if (n == 0 && bl) {
                vector.addAll(this.destroyEntity(entity, "explosion proximity", false, false));
                vector2.add(entity.getId());
                entity.getCrew().setDoomed(true);
                hashSet.add(entity);
                continue;
            }
            int n2 = nArray[n];
            if (bl2 && this.canShelter((Coords)serializable, coords, entity.absHeight())) {
                if (this.isSheltered()) {
                    report = new Report(6545);
                    report.addDesc(entity);
                    report.subject = entity.getId();
                    vector.addElement(report);
                    continue;
                }
                report = new Report(6546);
                report.subject = entity.getId();
                report.addDesc(entity);
                vector.addElement(report);
            }
            vector2.add(entity.getId());
            report = new Report(6175);
            report.subject = entity.getId();
            report.indent(2);
            report.addDesc(entity);
            report.add(n2);
            report.newlines = 0;
            vector.addElement(report);
            while (n2 > 0) {
                int n3 = Math.min(5, n2);
                HitData hitData = entity.rollHitLocation(0, Compute.targetSideTable(coords, (Targetable)entity));
                vector.addAll(this.damageEntity(entity, hitData, n3, false, DamageType.IGNORE_PASSENGER, false, true));
                n2 -= n3;
            }
            Report.addNewline(vector);
        }
        iterator = ((ArrayList)serializable3).iterator();
        while (iterator.hasNext()) {
            int n;
            Coords coords3;
            int n4;
            Entity entity = (Entity)iterator.next();
            serializable = this.game.getEntity(entity.getTransportId());
            if (serializable != null && !((ArrayList)((Entity)serializable).getExternalUnits()).contains(entity) || (n4 = coords.distance(coords3 = serializable == null ? entity.getPosition() : ((Entity)serializable).getPosition())) >= nArray.length) continue;
            int n5 = nArray[n4];
            if (bl2) {
                int n6 = n = serializable == null ? entity.absHeight() : ((Entity)serializable).absHeight();
                if (coords3 != null && this.canShelter(coords3, coords, n)) {
                    if (this.isSheltered()) {
                        report = new Report(6545);
                        report.addDesc(entity);
                        report.subject = entity.getId();
                        vector.addElement(report);
                        continue;
                    }
                    report = new Report(6546);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    vector.addElement(report);
                }
            }
            vector2.add(entity.getId());
            report = new Report(6175);
            report.subject = entity.getId();
            report.indent(2);
            report.addDesc(entity);
            report.add(n5);
            report.newlines = 0;
            vector.addElement(report);
            while (n5 > 0) {
                n = Math.min(5, n5);
                HitData hitData = entity.rollHitLocation(0, 0);
                vector.addAll(this.damageEntity(entity, hitData, n, false, DamageType.IGNORE_PASSENGER, false, true));
                n5 -= n;
            }
            Report.addNewline(vector);
        }
    }

    public boolean canShelter(Coords coords, Coords coords2, int n) {
        Coords coords3 = Coords.nextHex(coords, coords2);
        IHex iHex = this.game.getBoard().getHex(coords3);
        if (iHex == null) {
            return false;
        }
        int n2 = iHex.floor();
        if (iHex.containsTerrain(10)) {
            n2 = iHex.ceiling();
        }
        return (n += this.game.getBoard().getHex(coords).surface()) < n2;
    }

    private boolean isSheltered() {
        return Compute.d6(2) >= 9;
    }

    public void addScheduledNuke(int[] nArray) {
        this.scheduledNukes.add(nArray);
    }

    private void resolveScheduledNukes() {
        for (int[] nArray : this.scheduledNukes) {
            if (nArray.length == 3) {
                this.doNuclearExplosion(new Coords(nArray[0], nArray[1]), nArray[2], this.vPhaseReport);
            }
            if (nArray.length != 6) continue;
            this.doNuclearExplosion(new Coords(nArray[0], nArray[1]), nArray[2], nArray[3], nArray[4], nArray[5], this.vPhaseReport);
        }
        this.scheduledNukes.clear();
    }

    public void doNuclearExplosion(Coords coords, int n, Vector<Report> vector) {
        switch (n) {
            case 0: 
            case 1: {
                this.doNuclearExplosion(coords, 100, 5, 40, 0, vector);
                break;
            }
            case 2: {
                this.doNuclearExplosion(coords, 1000, 23, 86, 1, vector);
                break;
            }
            case 3: {
                this.doNuclearExplosion(coords, 10000, 109, 184, 3, vector);
                break;
            }
            case 4: {
                this.doNuclearExplosion(coords, 100000, 505, 396, 5, vector);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void doNuclearExplosion(Coords coords, int n, int n2, int n3, int n4, Vector<Report> vector) {
        Object object;
        Object object2;
        Cloneable cloneable;
        Serializable serializable;
        Enumeration<Serializable> enumeration;
        if (vector == null) {
            vector = new Vector();
        }
        Report report = new Report(1215, 0);
        report.indent();
        report.add(coords.getBoardNum(), true);
        vector.add(report);
        int n5 = this.game.getBoard().getHex(coords).floor() - n4;
        int n6 = 0;
        while (n6 < 2 * n4) {
            enumeration = this.game.getBoard().getHexesAtDistance(coords, n6);
            while (enumeration.hasMoreElements()) {
                serializable = (Coords)enumeration.nextElement();
                cloneable = this.game.getBoard().getHex((Coords)serializable);
                cloneable.setElevation(cloneable.getElevation() - n4 + n6 / 2);
                if (cloneable.containsTerrain(4)) {
                    cloneable.setElevation(cloneable.floor());
                }
                cloneable.removeAllTerrains();
                cloneable.clearExits();
                this.sendChangedHex((Coords)serializable);
            }
            if (++n6 <= 0 || n6 % 2 != 0) continue;
            ++n5;
        }
        enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            serializable = (Entity)enumeration.nextElement();
            if (((Entity)serializable).getTransportId() != -1 || ((Entity)serializable).getPosition() == null || coords.distance(((Entity)serializable).getPosition()) >= n6 || ((Entity)serializable).isDestroyed()) continue;
            vector.addAll(this.destroyEntity((Entity)serializable, "nuclear explosion proximity", false, false));
            ((Entity)serializable).getCrew().setDoomed(true);
        }
        enumeration = null;
        serializable = new Vector();
        cloneable = new Vector();
        this.doExplosion(n, n2, true, coords, true, (Vector<Report>)serializable, (Vector<Integer>)cloneable);
        Report.indentAll((Vector<Report>)serializable, 2);
        vector.addAll((Collection<Report>)((Object)serializable));
        Object object3 = ((Vector)cloneable).iterator();
        while (object3.hasNext()) {
            Entity entity;
            object2 = (Integer)object3.next();
            Entity entity2 = this.game.getEntity((Integer)object2);
            if (entity2 instanceof Mech) {
                entity = (Mech)entity2;
                if (entity.isProne()) continue;
                this.game.addPSR(new PilotingRollData(entity.getId(), 6, "hit by nuclear blast"));
                continue;
            }
            if (entity2 instanceof VTOL) {
                entity = (VTOL)entity2;
                if (entity.getElevation() <= 0) continue;
                this.game.addPSR(new PilotingRollData(entity.getId(), 6, "hit by nuclear blast"));
                continue;
            }
            if (!(entity2 instanceof Tank)) continue;
        }
        serializable = null;
        object3 = this.game.getBoard().getBuildingAt(coords);
        if (object3 != null) {
            report = new Report(2415);
            report.add(((Building)object3).getName());
            this.addReport(report);
            this.collapseBuilding((Building)object3, this.game.getPositionMap());
        }
        if ((object2 = this.game.getBoard().getHex(coords)).containsTerrain(4)) {
            object2.setElevation(object2.floor());
        }
        object2.removeAllTerrains();
        boolean bl = true;
        int n7 = n - n2 * n6;
        if (n7 > 0) {
            int n8 = n6;
            while (bl) {
                object = this.game.getBoard().getHexesAtDistance(coords, n8);
                while (object.hasMoreElements()) {
                    int n9;
                    int n10;
                    Coords coords2 = (Coords)object.nextElement();
                    IHex iHex = this.game.getBoard().getHex(coords2);
                    if (n7 >= 3000 && iHex.containsTerrain(4)) {
                        n10 = n7 / 3000;
                        n9 = iHex.terrainLevel(4);
                        iHex.removeTerrain(4);
                        if (n9 > n10) {
                            iHex.addTerrain(new Terrain(4, n9 - n10));
                        }
                    }
                    if (n7 >= 200 && !iHex.containsTerrain(4)) {
                        iHex.removeAllTerrains();
                        iHex.clearExits();
                        iHex.addTerrain(new Terrain(2, 1));
                    } else if (n7 >= 20 && (iHex.containsTerrain(1) || iHex.containsTerrain(23))) {
                        n10 = n7 / 20;
                        n9 = iHex.containsTerrain(1) ? 1 : 23;
                        int n11 = iHex.terrainLevel(n9);
                        iHex.removeTerrain(n9);
                        if (n11 > n10) {
                            iHex.addTerrain(new Terrain(n9, n11 - n10));
                        }
                    }
                    this.sendChangedHex(coords2);
                }
                n7 = n - (n2 * n8 + 1);
                if (n7 < 20) {
                    bl = false;
                }
                ++n8;
            }
        }
        Enumeration<Entity> enumeration2 = this.game.getEntities();
        while (enumeration2.hasMoreElements()) {
            object = enumeration2.nextElement();
            if (((Entity)object).getTransportId() != -1 || ((Entity)object).getPosition() == null || ((Entity)object).isDoomed() || ((Entity)object).isDestroyed() || coords.distance(((Entity)object).getPosition()) > n3) continue;
            this.applySecondaryNuclearEffects((Entity)object, coords, vector);
        }
        report = new Report(1216, 0);
        report.indent();
        report.newlines = 2;
        vector.add(report);
    }

    public void applySecondaryNuclearEffects(Entity entity, Coords coords, Vector<Report> vector) {
        if (entity.isDestroyed()) {
            return;
        }
        boolean bl = Compute.isInBuilding(this.game, entity) && this.game.getBoard().getHex(entity.getPosition()).terrainLevel(10) == 4;
        int n = Compute.d6(2);
        Report report = new Report(6555);
        report.subject = entity.getId();
        report.add(entity.getDisplayName());
        report.add(n);
        if (bl) {
            n += 2;
            report.add(" + 2 (unit is in hardened building)");
        } else {
            report.add("");
        }
        if (entity.isNuclearHardened()) {
            n += 2;
            report.add(" + 2 (unit is hardened against EMI)");
        } else {
            report.add("");
        }
        report.indent(2);
        vector.add(report);
        if (n <= 4) {
            vector.addAll(this.destroyEntity(entity, "nuclear explosion secondary effects", false, false));
            entity.getCrew().setDoomed(true);
        } else if (n <= 6) {
            if (entity instanceof BattleArmor) {
                BattleArmor battleArmor = (BattleArmor)entity;
                int n2 = (int)(Math.ceil(battleArmor.getNumberActiverTroopers()) / 2.0);
                for (int i = 0; i < n2; ++i) {
                    vector.addAll(this.applyCriticalHit(entity, 0, null, false));
                }
            } else if (entity instanceof Infantry) {
                if (this.game.getBoard().getHex(entity.getPosition()).containsTerrain(10)) {
                    int n3 = (int)Math.ceil((double)((Infantry)entity).getInternal(0) / 2.0);
                    vector.addAll(this.damageEntity(entity, new HitData(0), n3, true));
                } else {
                    vector.addAll(this.destroyEntity(entity, "nuclear explosion secondary effects", false, false));
                    entity.getCrew().setDoomed(true);
                }
            } else if (entity instanceof Tank) {
                HitData hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                vector.addAll(this.applyCriticalHit(entity, 0, new CriticalSlot(0, 6), false));
            } else if (entity instanceof Mech || entity instanceof Protomech) {
                HitData hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                vector.addAll(this.damageCrew(entity, 4));
            }
        } else if (n <= 10) {
            if (entity instanceof BattleArmor) {
                BattleArmor battleArmor = (BattleArmor)entity;
                int n4 = (int)Math.ceil((double)battleArmor.getNumberActiverTroopers() / 4.0);
                for (int i = 0; i < n4; ++i) {
                    vector.addAll(this.applyCriticalHit(entity, 0, null, false));
                }
            } else if (entity instanceof Infantry) {
                if (this.game.getBoard().getHex(entity.getPosition()).containsTerrain(10)) {
                    int n5 = (int)Math.ceil((double)((Infantry)entity).getInternal(0) / 4.0);
                    vector.addAll(this.damageEntity(entity, new HitData(0), n5, true));
                } else {
                    int n6 = (int)Math.ceil((double)((Infantry)entity).getInternal(0) / 2.0);
                    vector.addAll(this.damageEntity(entity, new HitData(0), n6, true));
                }
            } else if (entity instanceof Tank) {
                HitData hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                vector.addAll(this.applyCriticalHit(entity, 0, new CriticalSlot(0, 7), false));
            } else if (entity instanceof Mech || entity instanceof Protomech) {
                HitData hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                vector.addAll(this.damageCrew(entity, 2));
            }
        }
        entity.setEMI(true);
    }

    /*
     * Unable to fully structure code
     */
    public Vector<Report> applyCriticalHit(Entity var1_1, int var2_2, CriticalSlot var3_3, boolean var4_4) {
        block85: {
            block84: {
                var5_5 = new Vector<Report>();
                if (!(var1_1 instanceof Tank)) break block84;
                var7_6 = (Tank)var1_1;
                switch (var3_3.getIndex()) {
                    case -1: {
                        var6_13 = new Report(6005);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        break;
                    }
                    case 11: {
                        var6_13 = new Report(6610);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var9_14 = 0;
                        for (Mounted var11_23 : var7_6.getAmmo()) {
                            var11_23.setHit(true);
                            var12_25 = var11_23.getShotsLeft() * ((AmmoType)var11_23.getType()).getDamagePerShot() * ((AmmoType)var11_23.getType()).getRackSize();
                            var11_23.setShotsLeft(0);
                            if (!var11_23.getType().isExplosive()) continue;
                            var9_14 += var12_25;
                            var6_13 = new Report(6390);
                            var6_13.subject = var7_6.getId();
                            var6_13.add(var11_23.getName());
                            var6_13.add(var12_25);
                            var6_13.newlines = 0;
                            var5_5.add(var6_13);
                        }
                        var8_30 = new HitData(var2_2);
                        var5_5.addAll(this.damageEntity(var7_6, var8_30, var9_14, true));
                        break;
                    }
                    case 8: {
                        var6_13 = new Report(6615);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var10_21 = var7_6.getLoadedUnits();
                        var11_24 = var10_21.get(Compute.randomInt(var10_21.size()));
                        var8_31 = var11_24.rollHitLocation(0, 0);
                        var5_5.addAll(this.damageEntity(var11_24, var8_31, 5));
                        break;
                    }
                    case 5: {
                        if (!var1_1.crew.getOptions().booleanOption("vdni") && !var1_1.crew.getOptions().booleanOption("bvdni")) ** GOTO lbl55
                        var6_13 = new Report(6191);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var5_5.addAll(this.damageCrew(var1_1, 1));
                        ** GOTO lbl67
lbl55:
                        // 1 sources

                        if (var1_1.crew.getOptions().booleanOption("pain_shunt") && !var7_6.isCommanderHitPS()) {
                            var6_13 = new Report(6606);
                            var6_13.subject = var7_6.getId();
                            var5_5.add(var6_13);
                            var7_6.setCommanderHitPS(true);
                        } else {
                            var6_13 = new Report(6605);
                            var6_13.subject = var7_6.getId();
                            var5_5.add(var6_13);
                            var7_6.setCommanderHit(true);
                        }
                    }
lbl67:
                    // 4 sources

                    case 7: {
                        if (var1_1.crew.getOptions().booleanOption("vdni") || var1_1.crew.getOptions().booleanOption("bvdni")) {
                            var6_13 = new Report(6191);
                            var6_13.subject = var7_6.getId();
                            var5_5.add(var6_13);
                            var5_5.addAll(this.damageCrew(var1_1, 1));
                            break;
                        }
                        if (var1_1.crew.getOptions().booleanOption("pain_shunt")) {
                            var6_13 = new Report(6186);
                            var6_13.subject = var7_6.getId();
                            var5_5.add(var6_13);
                            break;
                        }
                        var7_6.stunCrew();
                        var6_13 = new Report(6185);
                        var6_13.add(var7_6.getStunnedTurns() - 1);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        break;
                    }
                    case 0: {
                        if (var1_1.crew.getOptions().booleanOption("vdni") || var1_1.crew.getOptions().booleanOption("bvdni")) {
                            var6_13 = new Report(6191);
                            var6_13.subject = var7_6.getId();
                            var5_5.add(var6_13);
                            var5_5.addAll(this.damageCrew(var1_1, 1));
                            break;
                        }
                        if (var1_1.crew.getOptions().booleanOption("pain_shunt") && !var7_6.isDriverHitPS()) {
                            var6_13 = new Report(6601);
                            var6_13.subject = var7_6.getId();
                            var5_5.add(var6_13);
                            var7_6.setDriverHitPS(true);
                            break;
                        }
                        var6_13 = new Report(6600);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var7_6.setDriverHit(true);
                        break;
                    }
                    case 6: {
                        if (var1_1.crew.getOptions().booleanOption("vdni") || var1_1.crew.getOptions().booleanOption("bvdni")) {
                            var6_13 = new Report(6191);
                            var6_13.subject = var7_6.getId();
                            var5_5.add(var6_13);
                            var5_5.addAll(this.damageCrew(var1_1, 1));
                            break;
                        }
                        if (var1_1.crew.getOptions().booleanOption("pain_shunt") && !var7_6.isCrewHitPS()) {
                            var6_13 = new Report(6191);
                            var6_13.subject = var7_6.getId();
                            var5_5.add(var6_13);
                            var7_6.setCrewHitPS(true);
                            break;
                        }
                        var6_13 = new Report(6190);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var7_6.getCrew().setDoomed(true);
                        break;
                    }
                    case 9: {
                        var6_13 = new Report(6210);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var7_6.engineHit();
                        if (!(var7_6 instanceof VTOL)) break;
                        var12_26 = var7_6.getBasePilotingRoll();
                        var13_38 = this.game.getBoard().getHex(var7_6.getPosition());
                        var12_26.addModifier(4, "forced landing");
                        var14_44 = Math.max(var13_38.terrainLevel(12), var13_38.terrainLevel(16));
                        var14_44 = Math.max(var14_44, 0);
                        var14_44 = Math.min(var14_44, var7_6.getElevation());
                        if (var7_6.getElevation() > var14_44) {
                            if (!(var13_38.containsTerrain(33) || var13_38.containsTerrain(23) || var13_38.containsTerrain(24) || var13_38.containsTerrain(25) || var13_38.containsTerrain(3) || var13_38.containsTerrain(4) || var13_38.containsTerrain(1))) {
                                var6_13 = new Report(2180);
                                var6_13.subject = var7_6.getId();
                                var6_13.addDesc(var7_6);
                                var6_13.add(var12_26.getLastPlainDesc(), true);
                                var5_5.add(var6_13);
                                var15_47 = Compute.d6(2);
                                var6_13 = new Report(2185);
                                var6_13.subject = var7_6.getId();
                                var6_13.add(var12_26.getValueAsString());
                                var6_13.add(var12_26.getDesc());
                                var6_13.add(var15_47);
                                if (var15_47 < var12_26.getValue()) {
                                    var6_13.choose(false);
                                    var5_5.add(var6_13);
                                    var5_5.addAll(this.crashVTOLorWiGE(var7_6));
                                    break;
                                }
                                var6_13.choose(true);
                                var5_5.add(var6_13);
                                var7_6.setElevation(var14_44);
                                break;
                            }
                            var5_5.addAll(this.crashVTOLorWiGE(var7_6));
                            break;
                        }
                        break block85;
                    }
                    case 10: {
                        var6_13 = new Report(6215);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var5_5.addAll(this.destroyEntity(var7_6, "fuel explosion", false, false));
                        break;
                    }
                    case 4: {
                        var6_13 = new Report(6620);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var7_6.setSensorHits(var7_6.getSensorHits() + 1);
                        break;
                    }
                    case 3: {
                        var6_13 = new Report(6625);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var7_6.setStabiliserHit(var2_2);
                        break;
                    }
                    case 14: {
                        var6_13 = new Report(6630);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var7_6.destroyLocation(5);
                        var5_5.addAll(this.destroyEntity(var7_6, "turret blown off", true, true));
                        break;
                    }
                    case 12: {
                        if (var7_6.isTurretEverJammed()) {
                            var6_13 = new Report(6640);
                            var6_13.subject = var7_6.getId();
                            var5_5.add(var6_13);
                            var7_6.lockTurret();
                            break;
                        }
                        var6_13 = new Report(6635);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var7_6.jamTurret();
                        break;
                    }
                    case 13: {
                        var6_13 = new Report(6640);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var7_6.lockTurret();
                        break;
                    }
                    case 2: {
                        var6_13 = new Report(6305);
                        var6_13.subject = var7_6.getId();
                        var12_27 = new ArrayList<Mounted>();
                        for (Mounted var14_45 : var7_6.getWeaponList()) {
                            if (var14_45.getLocation() != var2_2 || var14_45.isHit() || var14_45.isDestroyed()) continue;
                            var12_27.add(var14_45);
                        }
                        Collections.sort(var12_27, new WeaponComparator());
                        var13_40 = Compute.d6();
                        var14_45 = var13_40 < 4 ? (Mounted)var12_27.get(var12_27.size() - 1) : (Mounted)var12_27.get(0);
                        var14_45.setHit(true);
                        var6_13.add(var14_45.getName());
                        var5_5.add(var6_13);
                        var5_5.addAll(this.explodeEquipment((Entity)var7_6, var2_2, var14_45));
                        var14_45.setDestroyed(true);
                        break;
                    }
                    case 1: {
                        var6_13 = new Report(6645);
                        var6_13.subject = var7_6.getId();
                        var12_28 = new ArrayList<Mounted>();
                        for (Mounted var14_46 : var7_6.getWeaponList()) {
                            if (var14_46.getLocation() != var2_2 || var14_46.isJammed() || var14_46.isHit() || var14_46.isDestroyed()) continue;
                            var12_28.add(var14_46);
                        }
                        var13_41 = (Mounted)var12_28.get(Compute.randomInt(var12_28.size()));
                        var13_41.setJammed(true);
                        var7_6.addJammedWeapon(var13_41);
                        var6_13.add(var13_41.getName());
                        var5_5.add(var6_13);
                        break;
                    }
                    case 16: {
                        var6_13 = new Report(6650);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var7_6.setDriverHit(true);
                        var12_29 = var7_6.getBasePilotingRoll();
                        var12_29.addModifier(0, "pilot injury");
                        if (this.doSkillCheckInPlace(var7_6, var12_29)) break;
                        var6_13 = new Report(6675);
                        var6_13.subject = var7_6.getId();
                        var6_13.addDesc(var7_6);
                        var5_5.add(var6_13);
                        var13_42 = true;
                        if (var7_6.canGoDown()) {
                            var7_6.setElevation(var7_6.getElevation() - 1);
                            v0 = var13_42 = var7_6.canGoDown() == false;
                        }
                        if (var13_42) {
                            var5_5.addAll(this.crashVTOLorWiGE(var7_6));
                            break;
                        }
                        break block85;
                    }
                    case 15: {
                        var6_13 = new Report(6655);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var7_6.setCommanderHit(true);
                        break;
                    }
                    case 17: {
                        var6_13 = new Report(6660);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var13_43 = var7_6.getOriginalWalkMP();
                        if (var13_43 > 1) {
                            var7_6.setOriginalWalkMP(var13_43 - 1);
                            break;
                        }
                        if (var13_43 != 1) break;
                        var7_6.setOriginalWalkMP(0);
                        var5_5.addAll(this.crashVTOLorWiGE(var7_6));
                        break;
                    }
                    case 18: {
                        var6_13 = new Report(6670);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var7_6.immobilize();
                        var7_6.destroyLocation(5);
                        var5_5.addAll(this.crashVTOLorWiGE(var7_6));
                        break;
                    }
                    case 19: {
                        var6_13 = new Report(6665);
                        var6_13.subject = var7_6.getId();
                        var5_5.add(var6_13);
                        var7_6.setStabiliserHit(5);
                    }
                }
                break block85;
            }
            if (var1_1 instanceof BattleArmor) {
                var7_7 = (BattleArmor)var1_1;
                var6_13 = new Report(6111);
                var8_32 = var7_7.getRandomTrooper();
                var7_7.destroyLocation(var8_32);
                var6_13.add(var8_32);
                var6_13.newlines = 1;
                var5_5.add(var6_13);
            } else if (0 == var3_3.getType()) {
                var3_3.setHit(true);
                if (var1_1 instanceof Protomech) {
                    var7_8 = ((Protomech)var1_1).getCritsHit(var2_2);
                    if (var3_3.getIndex() != 4 && var3_3.getIndex() != 5) {
                        var6_13 = new Report(6225);
                        var6_13.subject = var1_1.getId();
                        var6_13.indent(3);
                        var6_13.newlines = 0;
                        var6_13.add(Protomech.systemNames[var3_3.getIndex()]);
                        var5_5.addElement(var6_13);
                    }
                    block23 : switch (var3_3.getIndex()) {
                        case 2: {
                            if (2 != var7_8) break;
                            var6_13 = new Report(6230);
                            var6_13.subject = var1_1.getId();
                            var6_13.newlines = 0;
                            var5_5.addElement(var6_13);
                            var1_1.destroyLocation(var2_2);
                            break;
                        }
                        case 0: {
                            if (2 != var7_8) break;
                            var6_13 = new Report(6235);
                            var6_13.subject = var1_1.getId();
                            var6_13.newlines = 0;
                            var5_5.addElement(var6_13);
                            var1_1.destroyLocation(var2_2);
                            break;
                        }
                        case 1: {
                            if (3 != var7_8) break;
                            var6_13 = new Report(6240);
                            var6_13.subject = var1_1.getId();
                            var6_13.newlines = 0;
                            var5_5.addElement(var6_13);
                            var1_1.destroyLocation(var2_2);
                            break;
                        }
                        case 3: {
                            if (3 == var7_8) {
                                var5_5.addAll(this.destroyEntity(var1_1, "torso destruction"));
                                break;
                            }
                            if (!var4_4) break;
                            var8_33 = Compute.d6(1);
                            var9_15 = null;
                            switch (var8_33) {
                                case 1: 
                                case 2: {
                                    var9_15 = new CriticalSlot(0, 4);
                                    var5_5.addAll(this.applyCriticalHit(var1_1, -1, var9_15, var4_4));
                                    break block23;
                                }
                                case 3: 
                                case 4: {
                                    var9_15 = new CriticalSlot(0, 5);
                                    var5_5.addAll(this.applyCriticalHit(var1_1, -1, var9_15, var4_4));
                                    break block23;
                                }
                            }
                            break;
                        }
                        case 4: {
                            var8_34 = ((Protomech)var1_1).getTorsoWeapon(true);
                            if (null == var8_34) break;
                            var8_34.setHit(true);
                            var6_13 = new Report(6245);
                            var6_13.subject = var1_1.getId();
                            var6_13.newlines = 0;
                            var5_5.addElement(var6_13);
                            break;
                        }
                        case 5: {
                            var9_16 = ((Protomech)var1_1).getTorsoWeapon(false);
                            if (null == var9_16) break;
                            var9_16.setHit(true);
                            var6_13 = new Report(6250);
                            var6_13.subject = var1_1.getId();
                            var6_13.newlines = 0;
                            var5_5.addElement(var6_13);
                        }
                    }
                    if (((Protomech)var1_1).shaded(var2_2, var7_8) && Math.min(1, var8_35 = Protomech.POSSIBLE_PILOT_DAMAGE[var2_2] - ((Protomech)var1_1).getPilotDamageTaken(var2_2)) > 0) {
                        Report.addNewline(var5_5);
                        var5_5.addAll(this.damageCrew(var1_1, 1));
                        var8_35 = 1 + ((Protomech)var1_1).getPilotDamageTaken(var2_2);
                        ((Protomech)var1_1).setPilotDamageTaken(var2_2, var8_35);
                    }
                } else {
                    var6_13 = new Report(6225);
                    var6_13.subject = var1_1.getId();
                    var6_13.indent(3);
                    var6_13.add(((Mech)var1_1).getSystemName(var3_3.getIndex()));
                    var6_13.newlines = 0;
                    var5_5.addElement(var6_13);
                    switch (var3_3.getIndex()) {
                        case 2: {
                            if (6 <= var1_1.getCrew().getHits()) break;
                            var1_1.getCrew().setDoomed(true);
                            Report.addNewline(var5_5);
                            var5_5.addAll(this.destroyEntity(var1_1, "pilot death", true));
                            break;
                        }
                        case 3: {
                            ++var1_1.engineHitsThisRound;
                            var7_9 = false;
                            var8_36 = 0;
                            var8_36 += var1_1.getHitCriticals(0, 3, 1);
                            var8_36 += var1_1.getHitCriticals(0, 3, 2);
                            var7_9 = this.checkEngineExplosion(var1_1, var5_5, var8_36 += var1_1.getHitCriticals(0, 3, 3));
                            if (var7_9 || var8_36 <= 2) break;
                            var5_5.addAll(this.destroyEntity(var1_1, "engine destruction"));
                            if (!this.game.getOptions().booleanOption("auto_abandon_unit")) break;
                            var5_5.addAll(this.abandonEntity(var1_1));
                            break;
                        }
                        case 4: {
                            if (var1_1.getGyroType() != 3) {
                                var9_17 = var1_1.getHitCriticals(0, 4, var2_2);
                                if (var9_17 > 1 && var9_17 < 3) {
                                    this.game.addPSR(new PilotingRollData(var1_1.getId(), 0x7FFFFFFE, 3, "gyro destroyed"));
                                    break;
                                }
                                this.game.addPSR(new PilotingRollData(var1_1.getId(), 3, "gyro hit"));
                                break;
                            }
                            var9_18 = var1_1.getHitCriticals(0, 4, var2_2);
                            if (var9_18 > 2 && var9_18 < 4) {
                                this.game.addPSR(new PilotingRollData(var1_1.getId(), 0x7FFFFFFE, 1, "gyro destroyed"));
                                break;
                            }
                            if (var9_18 == 1) {
                                this.game.addPSR(new PilotingRollData(var1_1.getId(), 2, "gyro hit"));
                                break;
                            }
                            this.game.addPSR(new PilotingRollData(var1_1.getId(), 3, "gyro hit"));
                            break;
                        }
                        case 12: 
                        case 13: 
                        case 14: {
                            this.game.addPSR(new PilotingRollData(var1_1.getId(), 1, "leg/foot actuator hit"));
                            break;
                        }
                        case 11: {
                            this.game.addPSR(new PilotingRollData(var1_1.getId(), 2, "hip actuator hit"));
                        }
                    }
                }
            } else if (1 == var3_3.getType()) {
                var3_3.setHit(true);
                var7_10 = var1_1.getEquipment(var3_3.getIndex());
                var8_37 = var7_10.getType();
                var9_19 = var7_10.isHit();
                var6_13 = new Report(6225);
                var6_13.subject = var1_1.getId();
                var6_13.indent(3);
                var6_13.add(var7_10.getDesc());
                var6_13.newlines = 0;
                var5_5.addElement(var6_13);
                if (var8_37 instanceof MiscType && ((MiscType)var8_37).isShield()) {
                    var7_10.setHit(false);
                } else {
                    var7_10.setHit(true);
                }
                if (var8_37 instanceof MiscType && var8_37.hasFlag(0x80000000L)) {
                    var6_13 = new Report(6254);
                    var6_13.subject = var1_1.getId();
                    var6_13.indent(2);
                    var5_5.add(var6_13);
                    var5_5.addAll(this.breachLocation(var1_1, var2_2, null, true));
                }
                if (!var9_19 && var8_37 instanceof MiscType && var8_37.hasFlag(1024L) && var7_10.getLinkedBy() != null) {
                    var10_22 = var7_10.getLinkedBy();
                    var6_13 = new Report(6255);
                    var6_13.subject = var1_1.getId();
                    var6_13.indent(2);
                    var6_13.add(var10_22.getType().getName());
                    var6_13.newlines = 0;
                    var5_5.addElement(var6_13);
                    var10_22.setMode("Off");
                }
                if ((var4_4 && var8_37.isExplosive() || var7_10.isHotLoaded() || var7_10.hasChargedCapacitor()) && !var9_19) {
                    var5_5.addAll(this.explodeEquipment(var1_1, var2_2, var7_10));
                }
                if (var7_10.getShotsLeft() > 0) {
                    var7_10.setShotsLeft(0);
                }
            }
        }
        if (var1_1 instanceof Mech && var1_1.hitThisRoundByAntiTSM) {
            var7_11 = (Mech)var1_1;
            if (var7_11.hasTSM()) {
                var6_13 = new Report(6430);
                var6_13.subject = var1_1.getId();
                var6_13.indent(2);
                var6_13.addDesc(var1_1);
                var6_13.newlines = 0;
                var5_5.addElement(var6_13);
                var5_5.addAll(this.oneCriticalEntity(var1_1, Compute.d6(2)));
            }
            var1_1.hitThisRoundByAntiTSM = false;
        }
        if (var1_1.crew.getOptions().booleanOption("bvdni") && !var1_1.crew.getOptions().booleanOption("pain_shunt")) {
            Report.addNewline(var5_5);
            var7_12 = Compute.d6(2);
            var6_13 = new Report(3580);
            var6_13.subject = var1_1.getId();
            var6_13.addDesc(var1_1);
            var6_13.add(7);
            var6_13.add(var7_12);
            var6_13.choose(var7_12 >= 8);
            var6_13.indent(2);
            var5_5.add(var6_13);
            if (var7_12 >= 7) {
                var5_5.addAll(this.damageCrew(var1_1, 1));
            }
        }
        return var5_5;
    }

    public Vector<Report> criticalEntity(Entity entity, int n, int n2) {
        return this.criticalEntity(entity, n, n2, true);
    }

    private Vector<Report> oneCriticalEntity(Entity entity, int n) {
        return this.criticalEntity(entity, n, 0, false);
    }

    private Vector<Report> crashVTOLorWiGE(Tank tank) {
        return this.crashVTOLorWiGE(tank, false, 0, tank.getPosition(), tank.getElevation(), 0);
    }

    private Vector<Report> crashVTOLorWiGE(Tank tank, boolean bl, int n, Coords coords, int n2, int n3) {
        Vector<Report> vector = new Vector<Report>();
        if (!bl) {
            int n4;
            int n5;
            int n6;
            int n7;
            String string;
            Report report = new Report(6260);
            report.subject = tank.getId();
            report.newlines = 0;
            report.addDesc(tank);
            vector.addElement(report);
            int n8 = 0;
            IHex iHex = this.game.getBoard().getHex(coords);
            if (iHex.containsTerrain(12)) {
                n8 = iHex.terrainLevel(12);
            } else if (iHex.containsTerrain(16) && (n8 = iHex.terrainLevel(16)) > n2) {
                n8 = 0;
            }
            int n9 = n2 - n8;
            if (n9 == 0) {
                report = new Report(6265);
                report.subject = tank.getId();
                vector.addElement(report);
                return vector;
            }
            tank.setElevation(n8);
            report = new Report(6270);
            report.subject = tank.getId();
            report.add(n9);
            vector.addElement(report);
            int n10 = Compute.d6();
            switch (n10) {
                case 1: 
                case 2: {
                    string = "right side";
                    n7 = 3;
                    break;
                }
                case 3: {
                    string = "rear";
                    n7 = 1;
                    break;
                }
                case 4: 
                case 5: {
                    string = "left side";
                    n7 = 2;
                    break;
                }
                default: {
                    string = "front";
                    n7 = 0;
                }
            }
            if (n8 <= 0) {
                n6 = iHex.containsTerrain(4);
                if (n6 != 0 && iHex.containsTerrain(20)) {
                    n5 = Compute.d6(1);
                    report = new Report(2118);
                    report.subject = tank.getId();
                    report.add(tank.getDisplayName(), true);
                    report.add(n5);
                    report.subject = tank.getId();
                    vector.add(report);
                    if (n5 == 6) {
                        vector.addAll(this.resolveIceBroken(coords));
                    } else {
                        n6 = 0;
                    }
                }
                if (n6 != 0) {
                    report = new Report(6275);
                    report.subject = tank.getId();
                    vector.addElement(report);
                    vector.addAll(this.destroyEntity(tank, "Fell into water", false, false));
                }
            }
            n6 = (int)Math.round((double)tank.getWeight() / 10.0) * (n9 + 1);
            report = new Report(6280);
            report.subject = tank.getId();
            report.indent();
            report.addDesc(tank);
            report.add(string);
            report.add(n6);
            report.newlines = 0;
            vector.addElement(report);
            tank.setFacing((tank.getFacing() + (n10 - 1)) % 6);
            n5 = 0;
            for (n6 = Math.round((float)n6 * this.game.getOptions().floatOption("gravity")); n6 > 0; n6 -= n4) {
                n4 = Math.min(5, n6);
                HitData hitData = tank.rollHitLocation(0, n7);
                hitData.setGeneralDamageType(-2);
                int[] nArray = new int[]{tank.getInternal(1), tank.getInternal(2), tank.getInternal(3), tank.getInternal(4)};
                vector.addAll(this.damageEntity(tank, hitData, n4));
                int[] nArray2 = new int[]{tank.getInternal(1), tank.getInternal(2), tank.getInternal(3), tank.getInternal(4)};
                for (int i = 0; i <= 3; ++i) {
                    if (nArray[i] == nArray2[i]) continue;
                    n5 = 1;
                }
            }
            if (n5 != 0) {
                report = new Report(6285);
                report.subject = tank.getId();
                report.addDesc(tank);
                vector.addElement(report);
                vector.addAll(this.explodeVTOLorWiGE(tank));
            }
            vector.addAll(this.doSetLocationsExposure(tank, iHex, false, n8));
        } else {
            int n11;
            tank.setElevation(0);
            Report report = new Report(6290);
            report.subject = tank.getId();
            report.addDesc(tank);
            vector.addElement(report);
            boolean bl2 = false;
            for (int i = (int)Math.round((double)tank.getWeight() / 10.0) * (n + 1); i > 0; i -= n11) {
                n11 = Math.min(5, i);
                HitData hitData = tank.rollHitLocation(0, n3);
                hitData.setGeneralDamageType(-2);
                int[] nArray = new int[]{tank.getInternal(1), tank.getInternal(2), tank.getInternal(3), tank.getInternal(4)};
                vector.addAll(this.damageEntity(tank, hitData, n11));
                int[] nArray3 = new int[]{tank.getInternal(1), tank.getInternal(2), tank.getInternal(3), tank.getInternal(4)};
                for (int j = 0; j <= 3; ++j) {
                    if (nArray[j] == nArray3[j]) continue;
                    bl2 = true;
                }
            }
            if (bl2) {
                report = new Report(6295);
                report.subject = tank.getId();
                report.addDesc(tank);
                vector.addElement(report);
                vector.addAll(this.explodeVTOLorWiGE(tank));
            }
        }
        return vector;
    }

    private Vector<Report> explodeVTOLorWiGE(Tank tank) {
        Vector<Report> vector = new Vector<Report>();
        if (tank.getEngine().isFusion()) {
            Report report = new Report(6300);
            report.subject = tank.getId();
            vector.addElement(report);
        } else {
            Coords coords = tank.getPosition();
            if (this.game.getOptions().booleanOption("fire")) {
                IHex iHex = this.game.getBoard().getHex(coords);
                if (iHex.containsTerrain(1) || iHex.containsTerrain(23)) {
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                } else {
                    this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, 1);
                    this.game.getBoard().getInfernos().get(coords).setTurnsLeftToBurn(this.game.getBoard().getInfernoBurnTurns(coords) - 2);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                    this.sendChangedHex(coords);
                }
            }
            vector.addAll(this.destroyEntity(tank, "crashed and burned", false, false));
        }
        return vector;
    }

    private Vector<Report> criticalTank(Tank tank, int n, int n2) {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(6305);
        report.subject = tank.getId();
        report.indent(2);
        report.add(tank.getLocationAbbr(n));
        report.newlines = 0;
        vector.add(report);
        int n3 = Compute.d6(2);
        report = new Report(6310);
        report.subject = tank.getId();
        String string = "";
        if (n2 != 0) {
            string = "(" + n3;
            if (n2 > 0) {
                string = string + "+";
            }
            string = string + n2 + ") = ";
            n3 += n2;
        }
        string = string + n3;
        report.add(string);
        report.newlines = 0;
        vector.add(report);
        int n4 = tank.getCriticalEffect(n3, n);
        vector.addAll(this.applyCriticalHit(tank, n, new CriticalSlot(0, n4), true));
        return vector;
    }

    public Vector<Report> criticalEntity(Entity entity, int n, int n2, boolean bl) {
        Object object;
        int n3;
        int n4;
        Report report;
        if (entity instanceof Tank) {
            return this.criticalTank((Tank)entity, n, n2);
        }
        CriticalSlot criticalSlot = null;
        Vector<Report> vector = new Vector<Report>();
        Coords coords = entity.getPosition();
        IHex iHex = null;
        if (bl) {
            if (null != coords) {
                iHex = this.game.getBoard().getHex(coords);
            }
            report = new Report(6305);
            report.subject = entity.getId();
            report.indent(2);
            report.add(entity.getLocationAbbr(n));
            report.newlines = 0;
            vector.addElement(report);
            n4 = 0;
            n3 = Compute.d6(2);
            report = new Report(6310);
            report.subject = entity.getId();
            object = "";
            if (n2 != 0) {
                object = "(" + n3;
                if (n2 > 0) {
                    object = (String)object + "+";
                }
                object = (String)object + n2 + ") = ";
                n3 += n2;
            }
            object = (String)object + n3;
            report.add((String)object);
            report.newlines = 0;
            vector.addElement(report);
            if (n3 <= 7) {
                report = new Report(6005);
                report.subject = entity.getId();
                report.newlines = 0;
                vector.addElement(report);
                return vector;
            }
            if (n3 >= 8 && n3 <= 9) {
                n4 = 1;
                report = new Report(6315);
                report.subject = entity.getId();
                report.newlines = 0;
                vector.addElement(report);
            } else if (n3 >= 10 && n3 <= 11) {
                n4 = 2;
                report = new Report(6320);
                report.subject = entity.getId();
                report.newlines = 0;
                vector.addElement(report);
            } else if (n3 == 12) {
                if (entity instanceof Protomech) {
                    n4 = 3;
                    report = new Report(6325);
                    report.subject = entity.getId();
                    report.newlines = 0;
                    vector.addElement(report);
                } else {
                    if (entity.locationIsLeg(n)) {
                        report = new Report(6120);
                        report.subject = entity.getId();
                        report.add(entity.getLocationName(n));
                        report.newlines = 0;
                        vector.addElement(report);
                        if (entity.getInternal(n) > 0) {
                            entity.destroyLocation(n);
                        }
                        if (null != iHex) {
                            if (!iHex.containsTerrain(19)) {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(19, 1));
                            } else {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(19, iHex.terrainLevel(19) + 1));
                            }
                        }
                        this.sendChangedHex(entity.getPosition());
                        return vector;
                    }
                    if (n == 4 || n == 5) {
                        report = new Report(6120);
                        report.subject = entity.getId();
                        report.add(entity.getLocationName(n));
                        report.newlines = 0;
                        vector.addElement(report);
                        entity.destroyLocation(n);
                        if (null != iHex) {
                            if (!iHex.containsTerrain(18)) {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(18, 1));
                            } else {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(18, iHex.terrainLevel(18) + 1));
                            }
                        }
                        this.sendChangedHex(entity.getPosition());
                        return vector;
                    }
                    if (n == 0) {
                        report = new Report(6330);
                        report.subject = entity.getId();
                        report.add(entity.getLocationName(n));
                        report.newlines = 0;
                        vector.addElement(report);
                        entity.destroyLocation(n);
                        if (((Mech)entity).getCockpitType() != 1 && 6 > entity.getCrew().getHits()) {
                            entity.crew.setDoomed(true);
                            Report.addNewline(vector);
                            vector.addAll(this.destroyEntity(entity, "pilot death", true));
                        }
                        return vector;
                    }
                    n4 = 3;
                    report = new Report(6325);
                    report.subject = entity.getId();
                    report.newlines = 0;
                    vector.addElement(report);
                }
            }
        } else {
            n4 = 1;
        }
        while (n4 > 0 && entity.canTransferCriticals(n) && entity.getTransferLocation(n) != -2 && entity.getTransferLocation(n) != -1) {
            n = entity.getTransferLocation(n);
            report = new Report(6335);
            report.subject = entity.getId();
            report.indent(3);
            report.add(entity.getLocationAbbr(n));
            report.newlines = 0;
            vector.addElement(report);
        }
        while (n4 > 0) {
            if (entity.getHittableCriticals(n) <= 0) {
                report = new Report(6340);
                report.subject = entity.getId();
                report.indent(3);
                report.newlines = 0;
                vector.addElement(report);
                break;
            }
            n3 = Compute.randomInt(entity.getNumberOfCriticals(n));
            criticalSlot = entity.getCritical(n, n3);
            if (criticalSlot == null || !criticalSlot.isHittable()) continue;
            if (entity instanceof Mech && entity.crew.hasEdgeRemaining() && entity.crew.getOptions().booleanOption("edge_when_explosion") && criticalSlot.getType() == 1 && entity.getEquipment(criticalSlot.getIndex()).getType().isExplosive()) {
                entity.crew.decreaseEdge();
                report = new Report(6530);
                report.subject = entity.getId();
                report.indent(3);
                report.newlines = 0;
                report.add(entity.crew.getOptions().intOption("edge"));
                vector.addElement(report);
                continue;
            }
            if (entity.getArmorType() == 2 && (object = entity.getEquipment(criticalSlot.getIndex())) != null && ((Mounted)object).getType() instanceof MiscType && ((MiscType)((Mounted)object).getType()).hasFlag(0x4000000000L)) {
                int n5 = Compute.d6(2);
                report = new Report(6082);
                report.subject = entity.getId();
                report.indent(3);
                report.newlines = 0;
                report.add(n5);
                vector.addElement(report);
                if (n5 != 2) continue;
                report = new Report(6083);
                report.subject = entity.getId();
                report.indent(3);
                report.newlines = 0;
                vector.addElement(report);
                vector.addElement(report);
                vector.addAll(this.damageEntity(entity, new HitData(n), entity.getArmor(n)));
                if (entity.hasRearArmor(n)) {
                    vector.addAll(this.damageEntity(entity, new HitData(n, true), entity.getArmor(n, true)));
                }
                vector.addAll(this.damageEntity(entity, new HitData(n), 1));
            }
            vector.addAll(this.applyCriticalHit(entity, n, criticalSlot, true));
            --n4;
        }
        return vector;
    }

    private Vector<Report> breachCheck(Entity entity, int n, IHex iHex) {
        Vector<Report> vector = new Vector<Report>();
        if (entity instanceof Infantry) {
            return vector;
        }
        if (entity instanceof VTOL) {
            return vector;
        }
        boolean bl = false;
        for (Mounted mounted : entity.getAmmo()) {
            if (!mounted.isDumping()) continue;
            bl = true;
            break;
        }
        if (entity.getLocationStatus(n) > 0) {
            Report report;
            int n2 = 0;
            if (!(entity.getArmor(n) <= 0 || entity instanceof Mech && entity.getArmor(n, true) <= 0 || null != iHex)) {
                if (entity instanceof Mech && ((Mech)entity).hasHarJelIn(n)) {
                    Report report2 = new Report(6342);
                    report2.subject = entity.getId();
                    report2.indent(3);
                    vector.addElement(report2);
                    return vector;
                }
                n2 = Compute.d6(2);
                report = new Report(6345);
                report.subject = entity.getId();
                report.indent(3);
                report.add(entity.getLocationAbbr(n));
                report.add(n2);
                report.newlines = 0;
                if (n2 >= 10) {
                    report.choose(false);
                } else {
                    report.choose(true);
                }
                vector.addElement(report);
            }
            if (n2 >= 10 || entity.getArmor(n) <= 0 || bl && (!(entity instanceof Mech) || n == 1 || n == 2 || n == 3) || entity instanceof Mech && entity.getArmor(n, true) <= 0) {
                if (entity instanceof Mech && ((Mech)entity).hasHarJelIn(n)) {
                    report = new Report(6342);
                    report.subject = entity.getId();
                    report.indent(3);
                    vector.addElement(report);
                    return vector;
                }
                vector.addAll(this.breachLocation(entity, n, iHex, false));
            }
        }
        return vector;
    }

    private Vector<Report> breachLocation(Entity entity, int n, IHex iHex, boolean bl) {
        Vector<Report> vector = new Vector<Report>();
        if (entity.getInternal(n) < 0 || entity.getLocationStatus(n) < 0) {
            return vector;
        }
        Report report = new Report(6350);
        if (bl) {
            report.messageId = 6351;
        }
        report.subject = entity.getId();
        report.add(entity.getShortName());
        report.add(entity.getLocationAbbr(n));
        report.newlines = 0;
        vector.addElement(report);
        if (entity instanceof Tank) {
            vector.addAll(this.destroyEntity(entity, "hull breach", true, true));
            return vector;
        }
        for (Mounted serializable : entity.getEquipment()) {
            if (serializable.getLocation() != n) continue;
            serializable.setBreached(true);
        }
        for (int i = 0; i < entity.getNumberOfCriticals(n); ++i) {
            CriticalSlot criticalSlot = entity.getCritical(n, i);
            if (criticalSlot == null) continue;
            if (entity.locationIsLeg(n) && criticalSlot.isHittable()) {
                switch (criticalSlot.getIndex()) {
                    case 12: 
                    case 13: 
                    case 14: {
                        this.game.addPSR(new PilotingRollData(entity.getId(), 1, "leg/foot actuator hit"));
                        break;
                    }
                    case 11: {
                        this.game.addPSR(new PilotingRollData(entity.getId(), 0, "hip actuator hit"));
                    }
                }
            }
            criticalSlot.setBreached(true);
        }
        if (n == 1) {
            vector.addAll(this.destroyEntity(entity, "hull breach"));
            if (this.game.getOptions().booleanOption("auto_abandon_unit")) {
                vector.addAll(this.abandonEntity(entity));
            }
        }
        if (n == 0) {
            entity.crew.setDoomed(true);
            vector.addAll(this.destroyEntity(entity, "hull breach"));
            if (entity.getLocationStatus(n) == 2) {
                report = new Report(6355);
                report.subject = entity.getId();
                report.addDesc(entity);
                vector.addElement(report);
            } else {
                report = new Report(6360);
                report.subject = entity.getId();
                report.addDesc(entity);
                vector.addElement(report);
            }
        }
        entity.setLocationStatus(n, -1);
        if (entity.getHitCriticals(0, 3, 3) + entity.getHitCriticals(0, 3, 1) + entity.getHitCriticals(0, 3, 2) >= 3) {
            vector.addAll(this.destroyEntity(entity, "engine destruction"));
            if (this.game.getOptions().booleanOption("auto_abandon_unit")) {
                vector.addAll(this.abandonEntity(entity));
            }
        }
        return vector;
    }

    private Vector<Report> destroyEntity(Entity entity, String string) {
        return this.destroyEntity(entity, string, true);
    }

    private Vector<Report> destroyEntity(Entity entity, String string, boolean bl) {
        return this.destroyEntity(entity, string, bl, true);
    }

    private Vector<Report> destroyEntity(Entity entity, String string, boolean bl, boolean bl2) {
        Vector<Report> vector = new Vector<Report>();
        int n = 512;
        if (!bl2) {
            entity.setSalvage(bl2);
            n = 1024;
        }
        if (!entity.isDoomed() && !entity.isDestroyed()) {
            int n2;
            int n3;
            int n4;
            Object object;
            Serializable serializable;
            Entity entity2;
            Enumeration<Entity> enumeration;
            Report report = new Report(6365);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(string);
            report.newlines = 0;
            vector.addElement(report);
            entity.setDoomed(true);
            Enumeration<Integer> enumeration2 = entity.getPickedUpMechWarriors().elements();
            while (enumeration2.hasMoreElements()) {
                int n5 = enumeration2.nextElement();
                enumeration = this.game.getEntity(n5);
                ((Entity)((Object)enumeration)).setDestroyed(true);
                this.game.removeEntity(((Entity)((Object)enumeration)).getId(), n);
                this.entityUpdate(((Entity)((Object)enumeration)).getId());
                this.send(this.createRemoveEntityPacket(((Entity)((Object)enumeration)).getId(), n));
                report = new Report(6370);
                report.subject = ((Entity)((Object)enumeration)).getId();
                report.addDesc((Entity)((Object)enumeration));
                vector.addElement(report);
            }
            List list = entity.getExternalUnits();
            enumeration = entity.getLoadedUnits().elements();
            if (enumeration.hasMoreElements()) {
                entity2 = null;
                serializable = entity.getPosition();
                object = this.game.getBoard().getHex((Coords)serializable);
                n4 = entity.getFacing();
                while (enumeration.hasMoreElements()) {
                    entity2 = (Entity)enumeration.nextElement();
                    if (!bl || ((ArrayList)list).contains(entity2) && Compute.d6() >= 3) {
                        entity2.setDestroyed(true);
                        this.game.moveToGraveyard(entity2.getId());
                        this.entityUpdate(entity2.getId());
                        this.send(this.createRemoveEntityPacket(entity2.getId(), n));
                        report = new Report(6370);
                        report.subject = entity2.getId();
                        report.addDesc(entity2);
                        vector.addElement(report);
                        continue;
                    }
                    if (null != Compute.stackingViolation(this.game, entity2.getId(), (Coords)serializable) || entity2.isHexProhibited((IHex)object)) {
                        entity2.setDestroyed(true);
                        this.game.moveToGraveyard(entity2.getId());
                        this.entityUpdate(entity2.getId());
                        this.send(this.createRemoveEntityPacket(entity2.getId(), n));
                        report = new Report(6375);
                        report.subject = entity2.getId();
                        report.addDesc(entity2);
                        vector.addElement(report);
                        continue;
                    }
                    this.unloadUnit(entity, entity2, (Coords)serializable, n4, entity.getElevation());
                }
            }
            if (-1 != entity.getTransportId()) {
                entity2 = this.game.getEntity(entity.getTransportId());
                serializable = entity2.getPosition();
                int n6 = entity2.getFacing();
                this.unloadUnit(entity2, entity, (Coords)serializable, n6, entity2.getElevation());
                this.entityUpdate(entity2.getId());
            }
            if (-1 != (n3 = entity.getSwarmAttackerId())) {
                serializable = this.game.getEntity(n3);
                this.game.removeTurnFor((Entity)serializable);
                this.send(this.createTurnVectorPacket());
                ((Entity)serializable).setSwarmTargetId(-1);
                entity.setSwarmAttackerId(-1);
                report = new Report(6380);
                report.subject = n3;
                report.addDesc((Entity)serializable);
                vector.addElement(report);
                this.entityUpdate(n3);
            }
            if (-1 != (n2 = entity.getSwarmTargetId())) {
                object = this.game.getEntity(n2);
                ((Entity)object).setSwarmAttackerId(-1);
                entity.setSwarmTargetId(-1);
                report = new Report(6385);
                report.subject = ((Entity)object).getId();
                report.addDesc((Entity)object);
                vector.addElement(report);
                this.entityUpdate(n2);
            }
            if (entity instanceof Mech && (n4 = ((Mech)(object = (Mech)entity)).getGrappled()) != -1) {
                ((Mech)object).setGrappled(-1, false);
                Entity entity3 = this.game.getEntity(n4);
                if (entity3 != null && entity3 instanceof Mech) {
                    ((Mech)entity3).setGrappled(-1, false);
                }
                this.entityUpdate(n4);
            }
        }
        this.entityUpdate(entity.getId());
        return vector;
    }

    private Vector<Report> explodeEquipment(Entity entity, int n, int n2) {
        return this.explodeEquipment(entity, n, entity.getEquipment(entity.getCritical(n, n2).getIndex()));
    }

    private Vector<Report> explodeEquipment(Entity entity, int n, Mounted mounted) {
        int n2;
        int n3;
        Object object;
        Vector<Report> vector = new Vector<Report>();
        if (mounted.isDestroyed()) {
            System.err.println("server: explodeEquipment called on destroyed equipment (" + mounted.getName() + ')');
            return vector;
        }
        if (mounted.getType() instanceof WeaponType && ((WeaponType)mounted.getType()).getAmmoType() == 23 && !mounted.isJammed()) {
            return vector;
        }
        if (mounted.getType() instanceof WeaponType && (((WeaponType)mounted.getType()).getAmmoType() == 1 || ((WeaponType)mounted.getType()).getAmmoType() == 34)) {
            if (!mounted.isUsedThisRound()) {
                return vector;
            }
            Mounted mounted2 = mounted.getLinked();
            if (mounted2 == null || !(mounted2.getType() instanceof AmmoType) || ((AmmoType)mounted2.getType()).getMunitionType() != 8L) {
                return vector;
            }
            object = (WeaponType)mounted.getType();
            if (((WeaponType)object).getAmmoType() == 7 || ((WeaponType)object).getAmmoType() == 31 || ((WeaponType)object).getAmmoType() == 8 || ((WeaponType)object).getAmmoType() == 26) {
                return vector;
            }
        }
        if (mounted.getType() instanceof AmmoType && (((AmmoType)mounted.getType()).getAmmoType() == 9 || ((AmmoType)mounted.getType()).getAmmoType() == 45) && ((AmmoType)mounted.getType()).getMunitionType() == 0x10000000L && mounted.getShotsLeft() > 0) {
            entity.heatBuildup += Math.min(mounted.getExplosionDamage(), 30);
        }
        if ((n3 = mounted.getExplosionDamage()) <= 0) {
            return vector;
        }
        object = new Report(6390);
        ((Report)object).subject = entity.getId();
        ((Report)object).add(mounted.getName());
        ((Report)object).add(n3);
        ((Report)object).indent(3);
        ((Report)object).newlines = 0;
        vector.addElement((Report)object);
        if (mounted.getType() instanceof WeaponType && mounted.isHotLoaded()) {
            n2 = Compute.d6(2);
            int n4 = 0;
            object = new Report(6077);
            ((Report)object).subject = entity.getId();
            ((Report)object).add(n2);
            ((Report)object).indent(2);
            vector.addElement((Report)object);
            if (n2 < 6) {
                for (Mounted mounted3 : entity.getAmmo()) {
                    if (mounted3.getLocation() != n || mounted3.getExplosionDamage() <= 0 || ((AmmoType)mounted3.getType()).getMunitionType() == 8192L) continue;
                    ++n4;
                    vector.addAll(this.explodeEquipment(entity, n, mounted3));
                }
                if (n4 == 0) {
                    object = new Report(6078);
                    ((Report)object).subject = entity.getId();
                    ((Report)object).indent(2);
                    vector.addElement((Report)object);
                }
            } else {
                object = new Report(6079);
                ((Report)object).subject = entity.getId();
                ((Report)object).indent(2);
                vector.addElement((Report)object);
            }
        }
        mounted.setShotsLeft(0);
        vector.addAll(this.damageEntity(entity, new HitData(n), n3, true));
        Report.addNewline(vector);
        n2 = 2;
        if (entity.getCrew().getOptions().booleanOption("pain_resistance")) {
            n2 = 1;
        }
        if (entity.getCrew().getOptions().booleanOption("iron_man")) {
            n2 = 1;
        }
        if (!entity.crew.getOptions().booleanOption("pain_shunt")) {
            vector.addAll(this.damageCrew(entity, n2));
        }
        if (entity.crew.isDoomed() || entity.crew.isDead()) {
            vector.addAll(this.destroyEntity(entity, "crew death", true));
        } else {
            Report.addNewline(vector);
        }
        return vector;
    }

    private Vector<Report> explodeAmmoFromHeat(Entity entity) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        Vector<Report> vector = new Vector<Report>();
        for (int i = 0; i < entity.locations(); ++i) {
            for (int j = 0; j < entity.getNumberOfCriticals(i); ++j) {
                AmmoType ammoType;
                Mounted mounted;
                CriticalSlot criticalSlot = entity.getCritical(i, j);
                if (criticalSlot == null || criticalSlot.isDestroyed() || criticalSlot.isHit() || criticalSlot.getType() != 1 || !((mounted = entity.getEquipment(entity.getCritical(i, j).getIndex())).getType() instanceof AmmoType) || !(ammoType = (AmmoType)mounted.getType()).isExplosive() || mounted.getShotsLeft() == 0) continue;
                int n5 = ammoType.getDamagePerShot() * ammoType.getRackSize();
                int n6 = mounted.getExplosionDamage();
                if (mounted.isHit() || n2 >= n5 && (n2 != n5 || n >= n6)) continue;
                n2 = n5;
                n = n6;
                n3 = i;
                n4 = j;
            }
        }
        if (n3 != -1 && n4 != -1) {
            CriticalSlot criticalSlot = entity.getCritical(n3, n4);
            criticalSlot.setHit(true);
            entity.getEquipment(criticalSlot.getIndex()).setHit(true);
            vector.addAll(this.explodeEquipment(entity, n3, n4));
        } else {
            Report report = new Report(5105);
            report.subject = entity.getId();
            report.indent();
            vector.addElement(report);
        }
        return vector;
    }

    private Vector<Report> doEntityFall(Entity entity, Coords coords, int n, int n2, PilotingRollData pilotingRollData) {
        int n3;
        Report report;
        int n4;
        int n5;
        String string;
        Vector<Report> vector = new Vector<Report>();
        IHex iHex = this.game.getBoard().getHex(coords);
        if (entity.isMakingDfa()) {
            Report report2 = new Report(2305);
            report2.subject = entity.getId();
            vector.add(report2);
            entity.setProne(true);
            return vector;
        }
        switch (n2) {
            case 1: 
            case 2: {
                string = "right side";
                n5 = 3;
                break;
            }
            case 3: {
                string = "rear";
                n5 = 1;
                break;
            }
            case 4: 
            case 5: {
                string = "left side";
                n5 = 2;
                break;
            }
            default: {
                string = "front";
                n5 = 0;
            }
        }
        int n6 = iHex.terrainLevel(4);
        int n7 = iHex.terrainLevel(16) + iHex.depth();
        int n8 = iHex.terrainLevel(12);
        int n9 = n;
        if (n >= n8 && n8 >= 0) {
            n9 -= n8;
            n4 = n8;
        } else if (n >= n7 && n7 >= 0) {
            n9 -= n7;
            n6 = 0;
            n4 = iHex.terrainLevel(16);
        } else if (iHex.containsTerrain(20) && entity.getElevation() == 0) {
            n6 = 0;
            n4 = 0;
        } else if (n6 > 0) {
            n9 = n - n6;
            n4 = -n6;
        } else if (iHex.containsTerrain(12)) {
            Building building = this.game.getBoard().getBuildingAt(coords);
            n4 = building.getType() == 5 ? Math.max(iHex.getElevation(), iHex.terrainLevel(12)) : 0;
            n6 = 0;
        } else {
            n6 = 0;
            n4 = 0;
        }
        if (n6 > 0 && !(entity instanceof Mech) && !(entity instanceof Protomech) && entity.getRunMP() > 0 && entity.getMovementMode() != 5 && entity.getMovementMode() != 8 && entity.getMovementMode() != 7 && entity.getMovementMode() != 9 && entity.getMovementMode() != 18) {
            vector.addAll(this.destroyEntity(entity, "a watery grave", false));
            return vector;
        }
        int n10 = (int)Math.round((double)entity.getWeight() / 10.0) * (n9 + 1);
        int n11 = 0;
        if (n6 > 0) {
            n10 /= 2;
            n11 = (int)Math.round((double)entity.getWeight() / 10.0) * (n6 + 1) / 2;
        }
        if (n6 > n) {
            n10 = 0;
            n11 = (int)Math.round((double)entity.getWeight() / 10.0) * (n + 1) / 2;
        }
        n10 = Math.round((float)n10 * this.game.getOptions().floatOption("gravity"));
        if ((n11 = Math.round((float)n11 * this.game.getOptions().floatOption("gravity"))) == 0) {
            report = new Report(2310);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.addDesc(entity);
            report.add(string);
            report.add(n10);
        } else if (n10 > 0) {
            report = new Report(2315);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.addDesc(entity);
            report.add(string);
            report.add(n10);
            report.add(n11);
        } else {
            report = new Report(2310);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.addDesc(entity);
            report.add(string);
            report.add(n11);
        }
        vector.add(report);
        n10 += n11;
        int n12 = entity.getSwarmAttackerId();
        if (entity instanceof Mech) {
            entity.setProne(true);
        }
        entity.setPosition(coords);
        entity.setFacing((entity.getFacing() + (n2 - 1)) % 6);
        entity.setSecondaryFacing(entity.getFacing());
        entity.setElevation(n4);
        if (n6 > 0) {
            for (n3 = 0; n3 < entity.locations(); ++n3) {
                entity.setLocationStatus(n3, 2);
            }
        }
        while (n10 > 0) {
            n3 = Math.min(5, n10);
            HitData hitData = entity.rollHitLocation(0, n5);
            hitData.makeFallDamage(true);
            vector.addAll(this.damageEntity(entity, hitData, n3));
            n10 -= n3;
        }
        vector.addAll(this.doSetLocationsExposure(entity, iHex, false, -n6));
        pilotingRollData.removeAutos();
        if (n > 1) {
            pilotingRollData.addModifier(n - 1, "height of fall");
        }
        entity.addPilotingModifierForTerrain(pilotingRollData, coords);
        if (pilotingRollData.getValue() == Integer.MAX_VALUE) {
            report = new Report(2320);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.crew.getName());
            report.indent();
            vector.add(report);
            vector.addAll(this.damageCrew(entity, 1));
            Report.addNewline(vector);
        } else {
            n3 = Compute.d6(2);
            report = new Report(2325);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.crew.getName());
            report.add(pilotingRollData.getValueAsString());
            report.add(n3);
            if (n3 >= pilotingRollData.getValue()) {
                report.choose(true);
                vector.add(report);
            } else {
                report.choose(false);
                vector.add(report);
                vector.addAll(this.damageCrew(entity, 1));
                Report.addNewline(vector);
            }
        }
        if (-1 != n12) {
            Entity entity2 = this.game.getEntity(n12);
            entity.setSwarmAttackerId(-1);
            entity2.setSwarmTargetId(-1);
            if (n6 > 0 && entity2.getMovementMode() != 18) {
                entity2.setPosition(coords);
                report = new Report(2330);
                report.newlines = 0;
                report.subject = entity2.getId();
                report.addDesc(entity2);
                vector.add(report);
                vector.addAll(this.destroyEntity(entity2, "a watery grave", false));
            } else {
                report = new Report(2335);
                report.newlines = 0;
                report.subject = entity2.getId();
                report.addDesc(entity2);
                vector.add(report);
                vector.addAll(this.damageEntity(entity2, entity2.rollHitLocation(0, 0), Compute.d6(2)));
                Report.addNewline(vector);
            }
            entity2.setPosition(coords);
            this.entityUpdate(n12);
            if (!entity2.isDone()) {
                entity2.setDone(true);
                this.game.removeTurnFor(entity2);
                this.send(this.createTurnVectorPacket());
            }
        }
        this.game.resetPSRs(entity);
        return vector;
    }

    private Vector<Report> doEntityFall(Entity entity, Coords coords, int n, PilotingRollData pilotingRollData) {
        return this.doEntityFall(entity, coords, n, Compute.d6(1), pilotingRollData);
    }

    private Vector<Report> doEntityFall(Entity entity, PilotingRollData pilotingRollData) {
        return this.doEntityFall(entity, entity.getPosition(), entity.getElevation() + this.game.getBoard().getHex(entity.getPosition()).depth(), pilotingRollData);
    }

    private void resolveAmmoDumps() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            for (Mounted mounted : entity.getAmmo()) {
                Report report;
                if (mounted.isPendingDump()) {
                    report = new Report(5110);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    report.add(mounted.getName());
                    this.addReport(report);
                    mounted.setPendingDump(false);
                    mounted.setDumping(true);
                    continue;
                }
                if (!mounted.isDumping()) continue;
                report = new Report(5115);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(mounted.getName());
                this.addReport(report);
                mounted.setDumping(false);
                mounted.setShotsLeft(0);
            }
            entity.reloadEmptyWeapons();
        }
    }

    public boolean ignite(IHex iHex, int n, boolean bl, int n2) {
        if (!this.game.getOptions().booleanOption("fire") || null == iHex) {
            return false;
        }
        if (iHex.containsTerrain(7)) {
            return true;
        }
        if (!(bl || iHex.containsTerrain(1) || iHex.containsTerrain(23) || iHex.containsTerrain(33) || iHex.containsTerrain(10))) {
            return false;
        }
        int n3 = Compute.d6(2);
        if (n2 != -1) {
            Report report = new Report(3430);
            report.indent(3);
            report.subject = n2;
            report.add(n);
            report.add(n3);
            this.addReport(report);
        }
        if (n3 >= n) {
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
            return true;
        }
        return false;
    }

    public boolean ignite(IHex iHex, int n, boolean bl) {
        return this.ignite(iHex, n, bl, -1);
    }

    public boolean ignite(IHex iHex, int n) {
        return this.ignite(iHex, n, false, -1);
    }

    public void removeFire(int n, int n2, IHex iHex) {
        Coords coords = new Coords(n, n2);
        iHex.removeTerrain(7);
        this.sendChangedHex(coords);
        if (!this.game.getOptions().booleanOption("maxtech_fire")) {
            int n3 = this.game.getWindDirection();
            this.removeSmoke(n, n2, n3);
            this.removeSmoke(n, n2, (n3 + 1) % 6);
            this.removeSmoke(n, n2, (n3 + 5) % 6);
        }
        Report report = new Report(5170, 0);
        report.add(coords.getBoardNum());
        this.addReport(report);
    }

    public void addSmoke(int n, int n2, int n3) {
        Coords coords = new Coords(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex != null && !iHex.containsTerrain(8)) {
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 1));
            this.sendChangedHex(coords);
            Report report = new Report(5175, 0);
            report.add(coords.getBoardNum());
            this.addReport(report);
        }
    }

    public void addL3Smoke(int n, int n2) {
        IBoard iBoard = this.game.getBoard();
        Coords coords = new Coords(n, n2);
        IHex iHex = this.game.getBoard().getHex(coords);
        boolean bl = iBoard.isInfernoBurning(coords);
        if (iHex == null) {
            return;
        }
        if (bl || 2 < iHex.terrainLevel(33) || 2 < iHex.terrainLevel(10)) {
            if (iHex.terrainLevel(8) == 2) {
                Report report = new Report(5180, 0);
                report.add(coords.getBoardNum());
                this.addReport(report);
            } else {
                if (iHex.terrainLevel(8) == 1) {
                    iHex.removeTerrain(8);
                }
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 2));
                this.sendChangedHex(coords);
                Report report = new Report(5185, 0);
                report.add(coords.getBoardNum());
                this.addReport(report);
            }
        } else if (iHex.terrainLevel(8) == 2) {
            Report report = new Report(5190, 0);
            report.add(coords.getBoardNum());
            this.addReport(report);
        } else if (iHex.terrainLevel(8) == 1) {
            Report report = new Report(5195, 0);
            report.add(coords.getBoardNum());
            this.addReport(report);
        } else {
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 1));
            this.sendChangedHex(coords);
            Report report = new Report(5200, 0);
            report.add(coords.getBoardNum());
            this.addReport(report);
        }
    }

    public void removeSmoke(int n, int n2, int n3) {
        Coords coords = new Coords(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex != null && iHex.containsTerrain(8)) {
            iHex.removeTerrain(8);
            this.sendChangedHex(coords);
            Report report = new Report(5205, 0);
            report.add(coords.getBoardNum());
            this.addReport(report);
        }
    }

    private ArrayList<String> scanForBoardsInDir(String string, String string2, int n, int n2) {
        File file = new File(string);
        String[] stringArray = file.list();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(string.concat("/").concat(stringArray[i]));
            if (file2.isDirectory()) {
                arrayList.addAll(this.scanForBoardsInDir(string.concat("/").concat(stringArray[i]), string2.concat("/").concat(stringArray[i]), n, n2));
                continue;
            }
            if (stringArray[i].indexOf(".svn") != -1 || stringArray[i].indexOf(".board") == -1 || !Board.boardIsSize(string2.concat("/").concat(stringArray[i]), n, n2)) continue;
            arrayList.add(string2.concat("/").concat(stringArray[i].substring(0, stringArray[i].lastIndexOf(".board"))));
        }
        return arrayList;
    }

    private ArrayList<String> scanForBoards(int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File("data/boards");
        arrayList.add("[GENERATED]");
        if (!file.isDirectory()) {
            return arrayList;
        }
        ArrayList<Object> arrayList2 = new ArrayList();
        Comparator<String> comparator = StringUtil.stringComparator();
        arrayList2 = this.scanForBoardsInDir("data/boards", "", n, n2);
        if (arrayList2.size() > 0) {
            arrayList.add("[RANDOM]");
            arrayList.add(DEFAULT_BOARD);
            Collections.sort(arrayList2, comparator);
            for (int i = 0; i < arrayList2.size(); ++i) {
                arrayList.add((String)arrayList2.get(i));
            }
        }
        return arrayList;
    }

    private boolean doBlind() {
        return this.game.getOptions().booleanOption("double_blind") && this.game.getPhase().isDuringOrAfter(IGame.Phase.PHASE_DEPLOYMENT);
    }

    private void entityUpdate(int n) {
        this.entityUpdate(n, new Vector<UnitLocation>());
    }

    private void entityUpdate(int n, Vector<UnitLocation> vector) {
        Entity entity = this.game.getEntity(n);
        if (entity == null) {
            if (this.game.getOutOfGameEntity(n) != null) {
                System.err.print("S: attempted to send entity update for out of game entity, id was ");
                System.err.println(n);
            } else {
                System.err.print("S: attempted to send entity update for null entity, id was ");
                System.err.println(n);
            }
            return;
        }
        if (this.doBlind()) {
            Player player;
            int n2;
            Vector<Player> vector2 = this.game.getPlayersVector();
            Vector<Player> vector3 = this.whoCanSee(entity);
            Packet packet = this.createEntityPacket(n, vector);
            for (n2 = 0; n2 < vector3.size(); ++n2) {
                player = vector3.elementAt(n2);
                this.send(player.getId(), packet);
            }
            packet = this.createRemoveEntityPacket(n, entity.getRemovalCondition());
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                if (vector3.contains(vector2.elementAt(n2))) continue;
                player = vector2.elementAt(n2);
                this.send(player.getId(), packet);
            }
        } else {
            this.send(this.createEntityPacket(n, vector));
        }
    }

    private Vector<Player> whoCanSee(Entity entity) {
        TurnOrdered turnOrdered;
        if (entity == null) {
            return new Vector<Player>();
        }
        boolean bl = this.game.getOptions().booleanOption("team_vision");
        Vector<Entity> vector = this.game.getEntitiesVector();
        Vector<Player> vector2 = new Vector<Player>();
        vector2.addElement(entity.getOwner());
        if (bl) {
            this.addTeammates(vector2, entity.getOwner());
        }
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            turnOrdered = enumeration.nextElement();
            if (!((Player)turnOrdered).canSeeAll() || vector2.contains(enumeration)) continue;
            vector2.addElement((Player)turnOrdered);
        }
        if (!entity.isHidden()) {
            for (int i = 0; i < vector.size(); ++i) {
                turnOrdered = vector.elementAt(i);
                if (vector2.contains(((Entity)turnOrdered).getOwner()) || !((Entity)turnOrdered).isActive() || ((Entity)turnOrdered).isOffBoard() || !Compute.canSee(this.game, (Entity)turnOrdered, entity)) continue;
                vector2.addElement(((Entity)turnOrdered).getOwner());
                if (bl) {
                    this.addTeammates(vector2, ((Entity)turnOrdered).getOwner());
                }
                this.addObservers(vector2);
            }
        }
        return vector2;
    }

    private boolean canSee(Player player, Entity entity) {
        if (entity.getOwner().getId() == player.getId()) {
            return true;
        }
        Vector<Player> vector = this.whoCanSee(entity);
        for (int i = 0; i < vector.size(); ++i) {
            Player player2 = vector.elementAt(i);
            if (!player2.equals(player)) continue;
            return true;
        }
        return false;
    }

    private void addTeammates(Vector<Player> vector, Player player) {
        Vector<Player> vector2 = this.game.getPlayersVector();
        for (int i = 0; i < vector2.size(); ++i) {
            Player player2 = vector2.elementAt(i);
            if (player.isEnemyOf(player2) || vector.contains(player2)) continue;
            vector.addElement(player2);
        }
    }

    private void addObservers(Vector<Player> vector) {
        Vector<Player> vector2 = this.game.getPlayersVector();
        for (int i = 0; i < vector2.size(); ++i) {
            Player player = vector2.elementAt(i);
            if (!player.isObserver() || vector.contains(player)) continue;
            vector.addElement(player);
        }
    }

    private void entityAllUpdate() {
        if (this.doBlind()) {
            Vector<Player> vector = this.game.getPlayersVector();
            for (int i = 0; i < vector.size(); ++i) {
                Player player = vector.elementAt(i);
                this.send(player.getId(), this.createFilteredEntitiesPacket(player));
            }
            return;
        }
        this.send(this.createEntitiesPacket());
    }

    private Vector<Entity> filterEntities(Player player, Vector<Entity> vector) {
        Entity entity;
        int n;
        Vector<Entity> vector2 = new Vector<Entity>();
        Vector<Entity> vector3 = new Vector<Entity>();
        Vector<Entity> vector4 = this.game.getEntitiesVector();
        boolean bl = this.game.getOptions().booleanOption("team_vision");
        if (player.canSeeAll()) {
            return vector;
        }
        if (player.isObserver()) {
            vector3.addAll(vector4);
            block0: for (Entity entity2 : vector3) {
                for (Entity entity3 : vector3) {
                    if (!entity2.isEnemyOf(entity3) || !Compute.canSee(this.game, entity3, entity2)) continue;
                    vector2.add(entity2);
                    continue block0;
                }
            }
            return vector2;
        }
        for (n = 0; n < vector4.size(); ++n) {
            entity = vector4.elementAt(n);
            if (entity.getOwner() != player && (!bl || entity.getOwner().isEnemyOf(player))) continue;
            vector3.addElement(entity);
        }
        block3: for (n = 0; n < vector.size(); ++n) {
            entity = vector.elementAt(n);
            if (vector3.contains(entity)) {
                vector2.addElement(entity);
                continue;
            }
            if (entity.isHidden()) continue;
            for (int i = 0; i < vector3.size(); ++i) {
                Entity entity4 = (Entity)vector3.elementAt(i);
                if (entity4.isOffBoard() || !Compute.canSee(this.game, entity4, entity)) continue;
                vector2.addElement(entity);
                continue block3;
            }
        }
        return vector2;
    }

    private Vector<Report> filterReportVector(Vector<Report> vector, Player player) {
        if (!this.doBlind()) {
            return new Vector<Report>(vector);
        }
        Vector<Report> vector2 = new Vector<Report>();
        for (int i = 0; i < vector.size(); ++i) {
            Report report = vector.elementAt(i);
            vector2.addElement(this.filterReport(report, player, false));
        }
        return vector2;
    }

    private Report filterReport(Report report, Player player, boolean bl) {
        if (report.subject == -1 && report.type != 4 && report.type != 0) {
            System.err.println("Error: Attempting to filter a Report object that is not public yet has no subject.\n\t\tmessageId: " + report.messageId);
            return report;
        }
        if (report.type == 0 || player == null && !bl) {
            return report;
        }
        Entity entity = this.game.getEntity(report.subject);
        Player player2 = null;
        if (entity != null) {
            player2 = entity.getOwner();
            if (entity.isOffBoard()) {
                return report;
            }
        }
        if (!(report.type == 4 || bl || entity != null && player2 != null)) {
            System.err.println("Error: Attempting to filter a Report object that is not public but has a subject (" + entity + ") with owner (" + player2 + ").\n\tmessageId: " + report.messageId);
            return report;
        }
        Report report2 = new Report(report);
        for (int i = 0; i < report2.dataCount(); ++i) {
            if ((report.type != 4 || player.getId() == report.player) && !bl && (entity == null || this.canSee(player, entity)) || !report.isValueObscured(i)) continue;
            report2.hideData(i);
            if (player == null) continue;
            report.addObscuredRecipient(player.getName());
        }
        return report2;
    }

    private Vector<Vector<Report>> filterPastReports(Vector<Vector<Report>> vector, Player player) {
        if (this.doBlind()) {
            Vector<Vector<Report>> vector2 = new Vector<Vector<Report>>();
            Vector<Object> vector3 = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                Vector<Report> vector4 = new Vector<Report>();
                vector3 = vector.elementAt(i);
                for (int j = 0; j < vector3.size(); ++j) {
                    Report report = (Report)vector3.elementAt(j);
                    if (report.isObscuredRecipient(player.getName())) {
                        vector4.addElement(this.filterReport(report, null, true));
                        continue;
                    }
                    vector4.addElement(report);
                }
                vector2.addElement(vector4);
            }
            return vector2;
        }
        return vector;
    }

    private void updateVisibilityIndicator() {
        Vector<Entity> vector = this.game.getEntitiesVector();
        for (int i = 0; i < vector.size(); ++i) {
            Entity entity = vector.elementAt(i);
            boolean bl = entity.isVisibleToEnemy();
            boolean bl2 = entity.isSeenByEnemy();
            entity.setVisibleToEnemy(false);
            Vector<Player> vector2 = this.whoCanSee(entity);
            for (int j = 0; j < vector2.size(); ++j) {
                Player player = vector2.elementAt(j);
                if (!entity.getOwner().isEnemyOf(player) || player.isObserver()) continue;
                entity.setVisibleToEnemy(true);
                entity.setSeenByEnemy(true);
            }
            if (bl == entity.isVisibleToEnemy() && bl2 == entity.isSeenByEnemy()) continue;
            this.sendVisibilityIndicator(entity);
        }
    }

    private void receiveEntityAdd(Packet packet, int n) {
        final Entity entity = (Entity)packet.getObject(0);
        if (entityVerifier == null) {
            entityVerifier = new EntityVerifier(new File(VERIFIER_CONFIG_FILENAME));
        }
        if (entity instanceof Mech || entity instanceof Tank) {
            StringBuffer stringBuffer;
            TestEntity testEntity = null;
            entity.restore();
            if (entity instanceof Mech) {
                testEntity = new TestMech((Mech)entity, Server.entityVerifier.mechOption, null);
            }
            if (entity instanceof VTOL) {
                testEntity = new TestTank((Tank)entity, Server.entityVerifier.tankOption, null);
            }
            if (entity instanceof Tank) {
                testEntity = new TestTank((Tank)entity, Server.entityVerifier.tankOption, null);
            }
            if (((TestEntity)testEntity).correctEntity(stringBuffer = new StringBuffer(), !this.game.getOptions().booleanOption("is_eq_limits"))) {
                entity.setDesignValid(true);
            } else {
                System.err.println(stringBuffer);
                if (this.game.getOptions().booleanOption("allow_illegal_units")) {
                    entity.setDesignValid(false);
                } else {
                    Player player = this.game.getPlayer(n);
                    this.sendServerChat("Player " + player.getName() + " attempted to add an illegal unit design (" + entity.getShortNameRaw() + "), the unit was rejected.");
                    return;
                }
            }
        }
        if (entity instanceof Protomech) {
            int n2 = this.game.getSelectedEntityCount(new EntitySelector(){
                private final int ownerId;
                {
                    this.ownerId = entity.getOwnerId();
                }

                public boolean accept(Entity entity2) {
                    return entity2 instanceof Protomech && this.ownerId == entity2.getOwnerId();
                }
            });
            entity.setUnitNumber((char)(n2 / 5));
        }
        if (-1 == entity.getId()) {
            entity.setId(this.getFreeEntityId());
        }
        this.game.addEntity(entity.getId(), entity);
        this.send(this.createAddEntityPacket(entity.getId()));
    }

    private void receiveEntityUpdate(Packet packet, int n) {
        Entity entity = (Entity)packet.getObject(0);
        Entity entity2 = this.game.getEntity(entity.getId());
        if (entity2 != null && entity2.getOwner() == this.getPlayer(n)) {
            this.game.setEntity(entity.getId(), entity);
            this.entityUpdate(entity.getId());
            if (this.game.getPhase() == IGame.Phase.PHASE_LOUNGE) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Unit ");
                if (this.game.getOptions().booleanOption("blind_drop") || this.game.getOptions().booleanOption("real_blind_drop")) {
                    if (-1 != entity.getExternalId()) {
                        stringBuffer.append('[').append(entity.getExternalId()).append("] ");
                    }
                    stringBuffer.append(entity.getId()).append('(').append(entity.getOwner().getName()).append(')');
                } else {
                    stringBuffer.append(entity.getDisplayName());
                }
                stringBuffer.append(" has been customized.");
                this.sendServerChat(stringBuffer.toString());
            }
        }
    }

    private void receiveCustomInit(Packet packet, int n) {
        if (this.game.getPhase() == IGame.Phase.PHASE_LOUNGE) {
            Player player = (Player)packet.getObject(0);
            this.sendServerChat("" + player.getName() + " has customized initiative.");
        }
    }

    private void receiveEntityModeChange(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        int n3 = packet.getIntValue(1);
        int n4 = packet.getIntValue(2);
        Entity entity = this.game.getEntity(n2);
        if (entity.getOwner() != this.getPlayer(n)) {
            return;
        }
        Mounted mounted = entity.getEquipment(n3);
        if (mounted.getType() instanceof AmmoType && !mounted.getType().hasInstantModeSwitch() && n4 <= 0) {
            mounted.setPendingDump(n4 == -1);
        } else {
            mounted.setMode(n4);
        }
    }

    private void receiveEntitySystemModeChange(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        int n3 = packet.getIntValue(1);
        int n4 = packet.getIntValue(2);
        Entity entity = this.game.getEntity(n2);
        if (entity.getOwner() != this.getPlayer(n)) {
            return;
        }
        if (entity instanceof Mech && n3 == 2) {
            ((Mech)entity).setCockpitStatus(n4);
        }
    }

    private void receiveEntityAmmoChange(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        int n3 = packet.getIntValue(1);
        int n4 = packet.getIntValue(2);
        Entity entity = this.game.getEntity(n2);
        if (null == entity) {
            System.err.print("Server.receiveEntityAmmoChange: could not find entity #");
            System.err.println(n2);
            return;
        }
        Player player = this.getPlayer(n);
        if (null != player && entity.getOwner() != player) {
            System.err.print("Server.receiveEntityAmmoChange: player ");
            System.err.print(player.getName());
            System.err.print(" does not own the entity ");
            System.err.println(entity.getDisplayName());
            return;
        }
        Mounted mounted = entity.getEquipment(n3);
        Mounted mounted2 = entity.getEquipment(n4);
        if (null == mounted2) {
            System.err.print("Server.receiveEntityAmmoChange: entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" does not have ammo #");
            System.err.println(n4);
            return;
        }
        if (!(mounted2.getType() instanceof AmmoType)) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n4);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted2.getName());
            System.err.println(" and not ammo.");
            return;
        }
        if (null == mounted) {
            System.err.print("Server.receiveEntityAmmoChange: entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" does not have weapon #");
            System.err.println(n3);
            return;
        }
        if (!(mounted.getType() instanceof WeaponType)) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n3);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted.getName());
            System.err.println(" and not a weapon.");
            return;
        }
        if (((WeaponType)mounted.getType()).getAmmoType() == -1) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n3);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted.getName());
            System.err.println(" and does not use ammo.");
            return;
        }
        if (((WeaponType)mounted.getType()).hasFlag(16384L)) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n3);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted.getName());
            System.err.println(" and cannot use external ammo.");
            return;
        }
        entity.loadWeapon(mounted, mounted2);
    }

    private void receiveEntityDelete(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        final Entity entity = this.game.getEntity(n2);
        if (entity != null && entity.getOwner() == this.getPlayer(n)) {
            if (entity instanceof Protomech) {
                int n3 = this.game.getSelectedEntityCount(new EntitySelector(){
                    private final int ownerId;
                    {
                        this.ownerId = entity.getOwnerId();
                    }

                    public boolean accept(Entity entity2) {
                        return entity2 instanceof Protomech && this.ownerId == entity2.getOwnerId();
                    }
                });
                final char c = (char)(Math.ceil((double)n3 / 5.0) - 1.0);
                char c2 = (char)(Math.ceil((double)(n3 - 1) / 5.0) - 1.0);
                char c3 = entity.getUnitNumber();
                if (c != c3 && c != c2) {
                    Enumeration<Entity> enumeration = this.game.getSelectedEntities(new EntitySelector(){
                        private final int ownerId;
                        private final char lastUnitNum;
                        {
                            this.ownerId = entity.getOwnerId();
                            this.lastUnitNum = c;
                        }

                        public boolean accept(Entity entity2) {
                            return entity2 instanceof Protomech && this.ownerId == entity2.getOwnerId() && this.lastUnitNum == entity2.getUnitNumber();
                        }
                    });
                    Entity entity2 = enumeration.nextElement();
                    entity2.setUnitNumber(c3);
                    this.entityUpdate(entity2.getId());
                }
            }
            this.game.removeEntity(n2, 2048);
            this.send(this.createRemoveEntityPacket(n2, 2048));
        }
    }

    private void receivePlayerDone(Packet packet, int n) {
        boolean bl = packet.getBooleanValue(0);
        Player player = this.getPlayer(n);
        if (null != player) {
            player.setDone(bl);
        }
    }

    private void receiveInitiativeRerollRequest(Packet packet, int n) {
        Player player = this.getPlayer(n);
        if (IGame.Phase.PHASE_INITIATIVE_REPORT != this.game.getPhase()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (null == player) {
                stringBuffer.append("Player #").append(n);
            } else {
                stringBuffer.append(player.getName());
            }
            stringBuffer.append(" is not allowed to ask for a reroll at this time.");
            System.err.println(stringBuffer.toString());
            this.sendServerChat(stringBuffer.toString());
            return;
        }
        if (this.game.hasTacticalGenius(player)) {
            this.game.addInitiativeRerollRequest(this.game.getTeamForPlayer(player));
        }
        if (null != player) {
            player.setDone(true);
        }
        this.checkReady();
    }

    private boolean receiveGameOptions(Packet packet, int n) {
        Player player = this.game.getPlayer(n);
        if (null == player) {
            System.err.print("Server does not recognize player at connection ");
            System.err.println(n);
            return false;
        }
        if (this.password != null && this.password.length() > 0 && !this.password.equals(packet.getObject(0))) {
            this.sendServerChat(n, "The password you specified to change game options is incorrect.");
            return false;
        }
        int n2 = 0;
        Enumeration enumeration = ((Vector)packet.getObject(1)).elements();
        while (enumeration.hasMoreElements()) {
            IBasicOption iBasicOption = (IBasicOption)enumeration.nextElement();
            IOption iOption = this.game.getOptions().getOption(iBasicOption.getName());
            if (iOption == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Player ").append(player.getName()).append(" changed option \"").append(iOption.getDisplayableName()).append("\" to ").append(iBasicOption.getValue().toString()).append('.');
            this.sendServerChat(stringBuffer.toString());
            iOption.setValue(iBasicOption.getValue());
            ++n2;
        }
        Compute.setRNG(this.game.getOptions().intOption("rng_type"));
        return n2 > 0;
    }

    private void receiveGameOptionsAux(Packet packet, int n) {
        Enumeration enumeration = ((Vector)packet.getObject(1)).elements();
        while (enumeration.hasMoreElements()) {
            IBasicOption iBasicOption = (IBasicOption)enumeration.nextElement();
            IOption iOption = this.game.getOptions().getOption(iBasicOption.getName());
            if (iOption == null || !"maps_include_subdir".equals(iOption.getName())) continue;
            this.mapSettings.setBoardsAvailableVector(this.scanForBoards(this.mapSettings.getBoardWidth(), this.mapSettings.getBoardHeight()));
            this.mapSettings.removeUnavailable();
            this.mapSettings.setNullBoards(DEFAULT_BOARD);
            this.send(this.createMapSettingsPacket());
        }
    }

    private void transmitAllPlayerConnects(int n) {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            this.send(n, this.createPlayerConnectPacket(player.getId()));
        }
    }

    private Packet createPlayerConnectPacket(int n) {
        Object[] objectArray = new Object[]{new Integer(n), this.getPlayer(n)};
        return new Packet(40, objectArray);
    }

    private Packet createPlayerUpdatePacket(int n) {
        Object[] objectArray = new Object[]{new Integer(n), this.getPlayer(n)};
        return new Packet(60, objectArray);
    }

    private void transmitAllPlayerUpdates() {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            if (null == player) continue;
            this.send(this.createPlayerUpdatePacket(player.getId()));
        }
    }

    private void transmitAllPlayerDones() {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            this.send(this.createPlayerDonePacket(player.getId()));
        }
    }

    private Packet createPlayerDonePacket(int n) {
        Object[] objectArray = new Object[]{new Integer(n), this.getPlayer(n).isDone()};
        return new Packet(70, objectArray);
    }

    private Packet createTurnVectorPacket() {
        return new Packet(300, this.game.getTurnVector());
    }

    private Packet createTurnIndexPacket() {
        return new Packet(250, new Integer(this.game.getTurnIndex()));
    }

    private Packet createMapSettingsPacket() {
        return new Packet(360, this.mapSettings);
    }

    private Packet createMapQueryPacket(MapSettings mapSettings) {
        return new Packet(370, mapSettings);
    }

    private Packet createGameSettingsPacket() {
        return new Packet(350, this.game.getOptions());
    }

    private Packet createBoardPacket() {
        return new Packet(270, this.game.getBoard());
    }

    private Packet createEntityPacket(int n, Vector<UnitLocation> vector) {
        Entity entity = this.game.getEntity(n);
        Object[] objectArray = new Object[]{new Integer(n), entity, vector};
        return new Packet(140, objectArray);
    }

    private Packet createReportPacket(Player player) {
        if (player == null || !this.doBlind()) {
            return new Packet(310, this.vPhaseReport);
        }
        return new Packet(310, player.getTurnReport());
    }

    private Packet createSpecialReportPacket() {
        return new Packet(320, this.vPhaseReport.clone());
    }

    private Packet createTacticalGeniusReportPacket() {
        return new Packet(330, this.vPhaseReport.clone());
    }

    private Packet createAllReportsPacket(Player player) {
        return new Packet(340, this.filterPastReports(this.game.getAllReports(), player));
    }

    private Packet createEntitiesPacket() {
        return new Packet(280, this.game.getEntitiesVector());
    }

    private Packet createFullEntitiesPacket() {
        Object[] objectArray = new Object[]{this.game.getEntitiesVector(), this.game.getOutOfGameEntitiesVector()};
        return new Packet(280, objectArray);
    }

    private Packet createFilteredEntitiesPacket(Player player) {
        return new Packet(280, this.filterEntities(player, this.game.getEntitiesVector()));
    }

    private Packet createFilteredFullEntitiesPacket(Player player) {
        Object[] objectArray = new Object[]{this.filterEntities(player, this.game.getEntitiesVector()), this.game.getOutOfGameEntitiesVector()};
        return new Packet(280, objectArray);
    }

    private Packet createAddEntityPacket(int n) {
        Entity entity = this.game.getEntity(n);
        Object[] objectArray = new Object[]{new Integer(n), entity};
        return new Packet(90, objectArray);
    }

    private Packet createRemoveEntityPacket(int n) {
        return this.createRemoveEntityPacket(n, 512);
    }

    private Packet createRemoveEntityPacket(int n, int n2) {
        if (n2 != 0 && n2 != 256 && n2 != 272 && n2 != 512 && n2 != 528 && n2 != 288 && n2 != 1024 && n2 != 2048) {
            throw new IllegalArgumentException("Unknown unit condition: " + n2);
        }
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        return new Packet(100, objectArray);
    }

    private Packet createEndOfGamePacket() {
        Object[] objectArray = new Object[]{this.getDetailedVictoryReport(), new Integer(this.game.getVictoryPlayerId()), new Integer(this.game.getVictoryTeam())};
        return new Packet(380, objectArray);
    }

    public void sendChat(int n, String string, String string2) {
        this.send(n, new Packet(80, string + ": " + string2));
    }

    private void sendChat(String string, String string2) {
        String string3 = string + ": " + string2;
        this.send(new Packet(80, string3));
    }

    public void sendServerChat(int n, String string) {
        this.sendChat(n, "***Server", string);
    }

    public void sendServerChat(String string) {
        this.sendChat("***Server", string);
    }

    private Packet createHexChangePacket(Coords coords, IHex iHex) {
        Object[] objectArray = new Object[]{coords, iHex};
        return new Packet(190, objectArray);
    }

    public void sendChangedHex(Coords coords) {
        this.send(this.createHexChangePacket(coords, this.game.getBoard().getHex(coords)));
    }

    public void sendVisibilityIndicator(Entity entity) {
        Object[] objectArray = new Object[]{new Integer(entity.getId()), entity.isSeenByEnemy(), entity.isVisibleToEnemy()};
        this.send(new Packet(180, objectArray));
    }

    private Packet createAttackPacket(Vector<?> vector, int n) {
        Object[] objectArray = new Object[]{vector, new Integer(n)};
        return new Packet(130, objectArray);
    }

    private Packet createAttackPacket(EntityAction entityAction, int n) {
        Vector<EntityAction> vector = new Vector<EntityAction>(1);
        vector.addElement(entityAction);
        Object[] objectArray = new Object[]{vector, new Integer(n)};
        return new Packet(130, objectArray);
    }

    private Packet createSpecialHexDisplayPacket(int n) {
        Hashtable<Coords, Collection<SpecialHexDisplay>> hashtable = this.game.getBoard().getSpecialHexDisplayTable();
        Hashtable hashtable2 = new Hashtable();
        LinkedList<SpecialHexDisplay> linkedList = null;
        Player player = this.getPlayer(n);
        if (player != null) {
            String string = this.getPlayer(n).getName();
            for (Coords coords : hashtable.keySet()) {
                linkedList = new LinkedList<SpecialHexDisplay>();
                for (SpecialHexDisplay specialHexDisplay : hashtable.get(coords)) {
                    if (specialHexDisplay.isObscured() && !specialHexDisplay.isOwner(string)) continue;
                    linkedList.add(0, specialHexDisplay);
                }
                if (linkedList.isEmpty()) continue;
                hashtable2.put(coords, linkedList);
            }
        }
        return new Packet(500, hashtable2);
    }

    private Packet createArtilleryPacket(Player player) {
        Vector<ArtilleryAttackAction> vector = new Vector<ArtilleryAttackAction>();
        int n = player.getTeam();
        Enumeration<AttackHandler> enumeration = this.game.getAttacks();
        while (enumeration.hasMoreElements()) {
            ArtilleryAttackAction artilleryAttackAction;
            WeaponHandler weaponHandler = (WeaponHandler)enumeration.nextElement();
            if (!(weaponHandler.waa instanceof ArtilleryAttackAction) || (artilleryAttackAction = (ArtilleryAttackAction)weaponHandler.waa).getPlayerId() != player.getId() && (n == 0 || n != this.game.getPlayer(artilleryAttackAction.getPlayerId()).getTeam()) && !player.getSeeAll()) continue;
            vector.addElement(artilleryAttackAction);
        }
        return new Packet(460, vector);
    }

    private Packet createFlarePacket() {
        return new Packet(470, this.game.getFlares());
    }

    private void send(Packet packet) {
        if (this.connections == null) {
            return;
        }
        Enumeration<IConnection> enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            IConnection iConnection = enumeration.nextElement();
            iConnection.send(packet);
        }
    }

    private void sendReport() {
        this.sendReport(false);
    }

    private void sendReport(boolean bl) {
        if (this.connections == null) {
            return;
        }
        Enumeration<IConnection> enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            IConnection iConnection = enumeration.nextElement();
            Player player = this.game.getPlayer(iConnection.getId());
            Packet packet = bl ? this.createTacticalGeniusReportPacket() : this.createReportPacket(player);
            iConnection.send(packet);
        }
    }

    private void send(int n, Packet packet) {
        if (this.getClient(n) != null) {
            this.getClient(n).send(packet);
        }
    }

    private void sendToPending(int n, Packet packet) {
        if (this.getPendingConnection(n) != null) {
            this.getPendingConnection(n).send(packet);
        }
    }

    private void processCommand(int n, String string) {
        String[] stringArray = string.split("\\s+");
        String string2 = stringArray[0].substring(1);
        ServerCommand serverCommand = this.getCommand(string2);
        if (serverCommand != null) {
            serverCommand.run(n, stringArray);
        } else {
            this.sendServerChat(n, "Command not recognized.  Type /help for a list of commands.");
        }
    }

    protected synchronized void handle(int n, Packet packet) {
        Player player = this.game.getPlayer(n);
        if (null == player && null == this.getPendingConnection(n)) {
            System.err.print("Server does not recognize player at connection ");
            System.err.println(n);
            return;
        }
        if (packet == null) {
            System.out.println("server.connection.handle: got null packet");
            return;
        }
        switch (packet.getCommand()) {
            case 0: {
                IConnection iConnection = this.getConnection(n);
                if (iConnection == null) break;
                iConnection.close();
                break;
            }
            case 20: {
                this.receivePlayerName(packet, n);
                break;
            }
            case 60: {
                this.receivePlayerInfo(packet, n);
                this.validatePlayerInfo(n);
                this.send(this.createPlayerUpdatePacket(n));
                break;
            }
            case 70: {
                this.receivePlayerDone(packet, n);
                this.send(this.createPlayerDonePacket(n));
                this.checkReady();
                break;
            }
            case 430: {
                this.receiveInitiativeRerollRequest(packet, n);
                this.send(this.createPlayerDonePacket(n));
                break;
            }
            case 80: {
                String string = (String)packet.getObject(0);
                if (string.startsWith("/")) {
                    this.processCommand(n, string);
                } else {
                    this.sendChat(player.getName(), string);
                }
                if (DUNE_CALL.equals(string)) {
                    this.sendServerChat(DUNE_RESPONSE);
                    break;
                }
                if (!STAR_WARS_CALL.equals(string)) break;
                this.sendServerChat(STAR_WARS_RESPONSE);
                break;
            }
            case 110: {
                this.receiveMovement(packet, n);
                break;
            }
            case 120: {
                this.receiveDeployment(packet, n);
                break;
            }
            case 390: {
                this.receiveDeployMinefields(packet, n);
                break;
            }
            case 130: {
                this.receiveAttack(packet, n);
                break;
            }
            case 90: {
                this.receiveEntityAdd(packet, n);
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                break;
            }
            case 140: {
                this.receiveEntityUpdate(packet, n);
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                break;
            }
            case 150: {
                this.receiveEntityModeChange(packet, n);
                break;
            }
            case 170: {
                this.receiveEntitySystemModeChange(packet, n);
                break;
            }
            case 160: {
                this.receiveEntityAmmoChange(packet, n);
                break;
            }
            case 100: {
                this.receiveEntityDelete(packet, n);
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                break;
            }
            case 350: {
                if (!this.receiveGameOptions(packet, n)) break;
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                this.send(this.createGameSettingsPacket());
                this.receiveGameOptionsAux(packet, n);
                break;
            }
            case 360: {
                MapSettings mapSettings = (MapSettings)packet.getObject(0);
                if (!this.mapSettings.equalMapGenParameters(mapSettings)) {
                    this.sendServerChat("Player " + player.getName() + " changed mapsettings");
                }
                this.mapSettings = mapSettings;
                mapSettings = null;
                this.mapSettings.replaceBoardWithRandom("[RANDOM]");
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                this.send(this.createMapSettingsPacket());
                break;
            }
            case 370: {
                MapSettings mapSettings = (MapSettings)packet.getObject(0);
                mapSettings.setBoardsAvailableVector(this.scanForBoards(mapSettings.getBoardWidth(), mapSettings.getBoardHeight()));
                mapSettings.removeUnavailable();
                mapSettings.setNullBoards(DEFAULT_BOARD);
                mapSettings.replaceBoardWithRandom("[RANDOM]");
                mapSettings.removeUnavailable();
                this.send(n, this.createMapQueryPacket(mapSettings));
                break;
            }
            case 440: {
                this.receiveUnloadStranded(packet, n);
                break;
            }
            case 450: {
                this.receiveArtyAutoHitHexes(packet, n);
            }
            case 510: {
                this.receiveCustomInit(packet, n);
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
            }
        }
    }

    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        System.out.println("s: listening for clients...");
        HashSet<IConnection> hashSet = new HashSet<IConnection>();
        while (this.connector == thread) {
            Iterator iterator;
            try {
                iterator = this.serverSocket.accept();
                int n = this.getFreeConnectionId();
                System.out.println("s: accepting player connection #" + n + " ...");
                IConnection iConnection = ConnectionFactory.getInstance().createServerConnection((Socket)((Object)iterator), n);
                iConnection.addConnectionListener(this.connectionListener);
                iConnection.open();
                this.connectionsPending.addElement(iConnection);
                this.greeting(n);
                ConnectionWatchdog connectionWatchdog = new ConnectionWatchdog(this, n);
                this.timer.schedule((TimerTask)connectionWatchdog, 1000L, 500L);
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            hashSet.clear();
            hashSet.addAll(this.connections);
            hashSet.addAll(this.connectionsPending);
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((IConnection)iterator.next()).update();
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ((IConnection)iterator.next()).flush();
            }
        }
    }

    private Vector<Report> explodeInfernoAmmoFromHeat(Entity entity) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        Vector<Report> vector = new Vector<Report>();
        for (int i = 0; i < entity.locations(); ++i) {
            for (int j = 0; j < entity.getNumberOfCriticals(i); ++j) {
                AmmoType ammoType;
                Mounted mounted;
                CriticalSlot criticalSlot = entity.getCritical(i, j);
                if (criticalSlot == null || criticalSlot.isDestroyed() || criticalSlot.isHit() || criticalSlot.getType() != 1 || !((mounted = entity.getEquipment(entity.getCritical(i, j).getIndex())).getType() instanceof AmmoType) || !(ammoType = (AmmoType)mounted.getType()).isExplosive() || ammoType.getMunitionType() != 0x10000000L) continue;
                int n5 = ammoType.getDamagePerShot() * ammoType.getRackSize();
                int n6 = mounted.getExplosionDamage();
                if (mounted.isHit() || n2 >= n5 && (n2 != n5 || n >= n6)) continue;
                n2 = n5;
                n = n6;
                n3 = i;
                n4 = j;
            }
        }
        if (n3 != -1 && n4 != -1) {
            CriticalSlot criticalSlot = entity.getCritical(n3, n4);
            criticalSlot.setHit(true);
            Mounted mounted = entity.getEquipment(criticalSlot.getIndex());
            mounted.setHit(true);
            entity.heat += Math.min(mounted.getExplosionDamage(), 30);
            vector.addAll(this.explodeEquipment(entity, n3, n4));
            Report report = new Report(5155);
            report.indent();
            report.subject = entity.getId();
            report.add(entity.heat);
            vector.addElement(report);
            entity.heatBuildup = 0;
        } else {
            Report report = new Report(5160);
            report.indent();
            report.subject = entity.getId();
            vector.addElement(report);
        }
        return vector;
    }

    private boolean passBuildingWall(Entity entity, Building building, Coords coords, Coords coords2, int n, String string, boolean bl) {
        int n2;
        int n3;
        PilotingRollData pilotingRollData = entity.rollMovementInBuilding(building, n, string);
        if (0 < this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, false)) {
            n3 = (int)Math.ceil((double)building.getCurrentCF() / 10.0);
            if (n3 == 0) {
                Report report = new Report(6440);
                report.add(entity.getDisplayName());
                report.subject = entity.getId();
                report.indent(2);
                this.addReport(report);
            } else {
                n2 = 0;
                if (bl) {
                    n2 = 1;
                }
                HitData hitData = entity.rollHitLocation(0, n2);
                hitData.setGeneralDamageType(-2);
                this.addReport(this.damageEntity(entity, hitData, n3));
            }
        }
        n3 = (int)Math.ceil((double)entity.getWeight() / 10.0);
        n2 = building.getCurrentCF();
        n2 -= Math.min(n2, n3);
        building.setCurrentCF(n2);
        this.damageInfantryIn(building, n3);
        return this.checkBuildingCollapseWhileMoving(building, entity, coords2);
    }

    private boolean checkBuildingCollapseWhileMoving(Building building, Entity entity, Coords coords) {
        Coords coords2 = entity.getPosition();
        entity.setPosition(coords);
        Hashtable<Coords, Vector<Entity>> hashtable = this.game.getPositionMap();
        boolean bl = this.checkForCollapse(building, hashtable);
        if (coords.equals(entity.getPosition()) && !entity.isProne()) {
            entity.setPosition(coords2);
        }
        return bl;
    }

    public void damageInfantryIn(Building building, int n) {
        float f = 0.0f;
        switch (building.getType()) {
            case 1: {
                f = 0.75f;
                break;
            }
            case 2: {
                f = 0.5f;
                break;
            }
            case 3: {
                f = 0.25f;
            }
        }
        int n2 = Math.round((float)n * f);
        boolean bl = false;
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Report report;
            Entity entity = enumeration.nextElement();
            Coords coords = entity.getPosition();
            if (!(entity instanceof Infantry) || !building.isIn(coords) || !Compute.isInBuilding(this.game, entity, coords)) continue;
            if (n2 == 0) {
                report = new Report(6445);
                report.subject = entity.getId();
                this.addReport(report);
                continue;
            }
            report = new Report(6450);
            report.indent(2);
            report.subject = entity.getId();
            report.add(entity.getDisplayName());
            report.add(n2);
            this.addReport(report);
            int n3 = n2;
            int n4 = n2;
            if (entity instanceof BattleArmor) {
                n4 = 5;
            }
            while (n3 > 0) {
                int n5 = Math.min(n4, n3);
                HitData hitData = entity.rollHitLocation(0, 0);
                this.addReport(this.damageEntity(entity, hitData, n5));
                n3 -= n5;
            }
            this.addReport(new Report(1210));
        }
        if (bl) {
            this.addReport(new Report(1210));
        }
    }

    public boolean checkForCollapse(Building building, Hashtable<Coords, Vector<Entity>> hashtable) {
        Serializable serializable;
        if (building == null || hashtable == null || hashtable.isEmpty()) {
            return false;
        }
        int n = building.getCurrentCF();
        Hashtable hashtable2 = new Hashtable();
        Enumeration<Coords> enumeration = building.getCoords();
        boolean bl = false;
        while (!bl && enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            Vector<Entity> vector = hashtable.get(serializable);
            if (vector == null) continue;
            IHex iHex = this.game.getBoard().getHex((Coords)serializable);
            int n2 = Math.max(0, iHex.terrainLevel(12));
            int n3 = iHex.terrainLevel(16);
            int n4 = n2;
            if (n3 != Integer.MIN_VALUE) {
                ++n4;
            }
            if (n4 < 1) {
                System.err.println("Check for collapse: hex " + ((Coords)serializable).toString() + " has no bridge or building");
                continue;
            }
            int[] nArray = new int[n4];
            Vector<Entity> vector2 = new Vector<Entity>();
            for (int i = 0; i < n4; ++i) {
                nArray[i] = 0;
            }
            Enumeration<Entity> enumeration2 = vector.elements();
            while (!bl && enumeration2.hasMoreElements()) {
                Entity entity = enumeration2.nextElement();
                int n5 = entity.getElevation();
                if (n5 != n3 && n5 > n2 || entity.getMovementMode() == 8 || entity.getMovementMode() == 7 || entity.getMovementMode() == 9 || entity.getMovementMode() == 18 || !(entity instanceof Mech) && !(entity instanceof Tank)) continue;
                int n6 = (int)entity.getWeight();
                int n7 = n5;
                if (n7 == n3) {
                    n7 = n4;
                }
                if (n2 > 0 && n7 == 0 && n6 > n) {
                    vector2.addElement(entity);
                    continue;
                }
                if (n7 <= 0) continue;
                int n8 = --n7;
                nArray[n8] = nArray[n8] + n6;
                if (nArray[n7] <= n) continue;
                bl = true;
            }
            if (vector2.isEmpty()) continue;
            hashtable2.put(serializable, vector2);
        }
        if (bl) {
            serializable = new Report(2375);
            ((Report)serializable).add(building.getName());
            this.addReport((Report)serializable);
            this.collapseBuilding(building, hashtable);
        } else if (!hashtable2.isEmpty()) {
            // empty if block
        }
        return bl;
    }

    public void collapseBuilding(Building building, Hashtable<Coords, Vector<Entity>> hashtable) {
        int n = building.getPhaseCF();
        Enumeration<Coords> enumeration = building.getCoords();
        while (enumeration.hasMoreElements()) {
            Coords coords = enumeration.nextElement();
            Vector<Entity> vector = hashtable.get(coords);
            if (vector == null) continue;
            IHex iHex = this.game.getBoard().getHex(coords);
            int n2 = iHex.terrainLevel(16);
            int n3 = Math.max(n2, iHex.terrainLevel(12));
            this.game.getBoard().collapseBuilding(coords);
            Collections.sort(vector, new Comparator<Entity>(){

                @Override
                public int compare(Entity entity, Entity entity2) {
                    if (entity.getElevation() > entity2.getElevation()) {
                        return -1;
                    }
                    if (entity.getElevation() > entity2.getElevation()) {
                        return 1;
                    }
                    return 0;
                }
            });
            Enumeration<Entity> enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Entity entity = enumeration2.nextElement();
                int n4 = entity.getElevation();
                if (n4 > n3) continue;
                if (n4 == n3) {
                    --n4;
                }
                int n5 = (int)Math.ceil((double)(n * (n3 - n4)) / 10.0);
                if (entity instanceof Infantry) {
                    n5 *= 3;
                }
                Report report = new Report(6455);
                report.indent();
                report.subject = entity.getId();
                report.add(entity.getDisplayName());
                report.add(n5);
                this.addReport(report);
                int n6 = n5;
                int n7 = n5;
                if (entity instanceof BattleArmor || entity instanceof Mech || entity instanceof Tank) {
                    n7 = 5;
                }
                while (n6 > 0) {
                    int n8 = Math.min(n7, n6);
                    HitData hitData = entity.rollHitLocation(0, 0);
                    hitData.setGeneralDamageType(-2);
                    this.addReport(this.damageEntity(entity, hitData, n8));
                    n6 -= n8;
                }
                this.addReport(new Report(1210));
                n4 = entity.getElevation();
                if (n4 > 0 || n4 == n2) {
                    PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
                    entity.addPilotingModifierForTerrain(pilotingRollData, coords);
                    if (n5 >= 20) {
                        pilotingRollData.addModifier(1, "20+ damage");
                    }
                    this.addReport(this.doEntityFallsInto(entity, coords, coords, pilotingRollData));
                }
                this.entityUpdate(entity.getId());
            }
        }
        building.setCurrentCF(0);
        building.setPhaseCF(0);
        this.send(this.createCollapseBuildingPacket(building));
        this.game.getBoard().collapseBuilding(building);
    }

    private Packet createCollapseBuildingPacket(Building building) {
        Vector<Building> vector = new Vector<Building>();
        vector.addElement(building);
        return this.createCollapseBuildingPacket(vector);
    }

    private Packet createCollapseBuildingPacket(Vector<Building> vector) {
        return new Packet(230, vector);
    }

    private Packet createUpdateBuildingCFPacket(Vector<Building> vector) {
        return new Packet(220, vector);
    }

    private void applyBuildingDamage() {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<Building> vector2 = new Vector<Building>();
        Enumeration<Building> enumeration = this.game.getBoard().getBuildings();
        while (enumeration.hasMoreElements()) {
            serializable2 = enumeration.nextElement();
            if (((Building)serializable2).getCurrentCF() == 0) {
                vector.addElement(serializable2);
                continue;
            }
            if (((Building)serializable2).getPhaseCF() == ((Building)serializable2).getCurrentCF()) continue;
            ((Building)serializable2).setPhaseCF(((Building)serializable2).getCurrentCF());
            vector2.addElement((Building)serializable2);
        }
        if (!vector.isEmpty()) {
            serializable2 = this.game.getPositionMap();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                serializable = new Report(6460, 0);
                ((Report)serializable).add(((Building)object).getName());
                this.addReport((Report)serializable);
                this.collapseBuilding((Building)object, (Hashtable<Coords, Vector<Entity>>)serializable2);
            }
        }
        if (!vector2.isEmpty()) {
            serializable2 = this.game.getPositionMap();
            object = vector2.iterator();
            while (object.hasNext()) {
                serializable = (Building)object.next();
                if (!this.checkForCollapse((Building)serializable, (Hashtable<Coords, Vector<Entity>>)serializable2)) continue;
                object.remove();
            }
        }
        if (!vector2.isEmpty()) {
            this.sendChangedCFBuildings(vector2);
        }
    }

    public Vector<Report> damageBuilding(Building building, int n) {
        return this.damageBuilding(building, n, " absorbs ");
    }

    public Vector<Report> damageBuilding(Building building, int n, String string) {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(1210);
        report.newlines = 0;
        if (building != null && n > 0) {
            int n2;
            int n3 = n2 = building.getCurrentCF();
            n2 -= Math.min(n2, n);
            building.setCurrentCF(n2);
            report.messageId = 3435;
            report.add(building.getName());
            report.add(string);
            report.add(n);
            report.newlines = 1;
            if (n2 == 0 && n3 != 0) {
                if (building instanceof FuelTank) {
                    report.messageId = 3441;
                    report.type = 0;
                    vector.add(report);
                    report = new Report(3560);
                    report.type = 0;
                    report.newlines = 1;
                    vector.add(report);
                    Vector<Report> vector2 = new Vector<Report>();
                    this.doExplosion(((FuelTank)building).getMagnitude(), 10, false, building.getCoords().nextElement(), true, vector2, null);
                    Report.indentAll(vector2, 2);
                    vector.addAll(vector2);
                    return vector;
                }
                report.messageId = building.getType() == 5 ? 3442 : 3440;
            }
        }
        Report.indentAll(vector, 2);
        return vector;
    }

    public void sendChangedCFBuildings(Vector<Building> vector) {
        this.send(this.createUpdateBuildingCFPacket(vector));
    }

    private void receiveUnloadStranded(Packet packet, int n) {
        int n2;
        GameTurn.UnloadStrandedTurn unloadStrandedTurn = null;
        Player player = this.game.getPlayer(n);
        int[] nArray = (int[])packet.getObject(0);
        Vector<Player> vector = null;
        Player player2 = null;
        Enumeration<EntityAction> enumeration = null;
        UnloadStrandedAction unloadStrandedAction = null;
        Entity entity = null;
        if (this.game.getPhase() != IGame.Phase.PHASE_MOVEMENT) {
            System.err.println("error: server got unload stranded packet in wrong phase");
            return;
        }
        if (!(this.game.getTurn() instanceof GameTurn.UnloadStrandedTurn)) {
            System.err.println("error: server got unload stranded packet out of sequence");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(player.getName()).append(" should not be sending 'unload stranded entity' packets at this time.");
            this.sendServerChat(stringBuffer.toString());
            return;
        }
        unloadStrandedTurn = (GameTurn.UnloadStrandedTurn)this.game.getTurn();
        if (!unloadStrandedTurn.isValid(n, this.game)) {
            System.err.println("error: server got unload stranded packet from invalid player");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(player.getName()).append(" should not be sending 'unload stranded entity' packets.");
            this.sendServerChat(stringBuffer.toString());
            return;
        }
        vector = new Vector<Player>();
        enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            unloadStrandedAction = (UnloadStrandedAction)enumeration.nextElement();
            if (unloadStrandedAction.getPlayerId() == n) {
                System.err.println("error: server got multiple unload stranded packets from player");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(player.getName()).append(" should not send multiple 'unload stranded entity' packets.");
                this.sendServerChat(stringBuffer.toString());
                return;
            }
            player2 = this.game.getPlayer(unloadStrandedAction.getPlayerId());
            if (vector.contains(player2)) continue;
            vector.addElement(player2);
        }
        boolean bl = false;
        for (n2 = 0; null != nArray && n2 < nArray.length; ++n2) {
            entity = this.game.getEntity(nArray[n2]);
            if (!this.game.getTurn().isValid(n, entity, this.game)) {
                System.err.println("error: server got unload stranded packet for invalid entity");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(player.getName()).append(" can not unload stranded entity ");
                if (null == entity) {
                    stringBuffer.append('#').append(nArray[n2]);
                } else {
                    stringBuffer.append(entity.getDisplayName());
                }
                stringBuffer.append(" at this time.");
                this.sendServerChat(stringBuffer.toString());
                continue;
            }
            bl = true;
            this.game.addAction(new UnloadStrandedAction(n, nArray[n2]));
        }
        if (!bl) {
            this.game.addAction(new UnloadStrandedAction(n, -1));
        }
        vector.addElement(player);
        nArray = unloadStrandedTurn.getEntityIds();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            entity = this.game.getEntity(nArray[n2]);
            player2 = entity.getOwner();
            if (vector.contains(player2)) continue;
            return;
        }
        enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            unloadStrandedAction = (UnloadStrandedAction)enumeration.nextElement();
            if (-1 == unloadStrandedAction.getEntityId()) continue;
            entity = this.game.getEntity(unloadStrandedAction.getEntityId());
            if (null == entity) {
                System.err.print("error: server could not find stranded entity #");
                System.err.print(unloadStrandedAction.getEntityId());
                System.err.println(" to unload!!!");
                continue;
            }
            Entity entity2 = this.game.getEntity(entity.getTransportId());
            this.unloadUnit(entity2, entity, entity2.getPosition(), entity2.getFacing(), entity2.getElevation());
        }
        this.game.resetActions();
        this.changeToNextTurn();
    }

    private void clearArtillerySpotters(int n, int n2) {
        Enumeration<AttackHandler> enumeration = this.game.getAttacks();
        while (enumeration.hasMoreElements()) {
            WeaponHandler weaponHandler = (WeaponHandler)enumeration.nextElement();
            if (!(weaponHandler.waa instanceof ArtilleryAttackAction) || weaponHandler.waa.getEntityId() != n || weaponHandler.waa.getWeaponId() != n2) continue;
            ArtilleryAttackAction artilleryAttackAction = (ArtilleryAttackAction)weaponHandler.waa;
            artilleryAttackAction.setSpotterIds(null);
        }
    }

    public void creditKill(Entity entity, Entity entity2) {
        if ((entity.isDoomed() || entity.getCrew().isDoomed()) && !entity.getGaveKillCredit()) {
            entity2.addKill(entity);
        }
    }

    private PhysicalResult preTreatPhysicalAttack(AbstractAttackAction abstractAttackAction) {
        Entity entity = this.game.getEntity(abstractAttackAction.getEntityId());
        int n = 0;
        PhysicalResult physicalResult = new PhysicalResult();
        ToHitData toHitData = new ToHitData();
        physicalResult.roll = Compute.d6(2);
        physicalResult.aaa = abstractAttackAction;
        if (abstractAttackAction instanceof BrushOffAttackAction) {
            BrushOffAttackAction brushOffAttackAction = (BrushOffAttackAction)abstractAttackAction;
            int n2 = brushOffAttackAction.getArm();
            brushOffAttackAction.setArm(1);
            toHitData = BrushOffAttackAction.toHit(this.game, abstractAttackAction.getEntityId(), abstractAttackAction.getTarget(this.game), 1);
            brushOffAttackAction.setArm(2);
            physicalResult.toHitRight = BrushOffAttackAction.toHit(this.game, abstractAttackAction.getEntityId(), abstractAttackAction.getTarget(this.game), 2);
            n = BrushOffAttackAction.getDamageFor(entity, 1);
            physicalResult.damageRight = BrushOffAttackAction.getDamageFor(entity, 2);
            brushOffAttackAction.setArm(n2);
            physicalResult.rollRight = Compute.d6(2);
        } else if (abstractAttackAction instanceof ChargeAttackAction) {
            ChargeAttackAction chargeAttackAction = (ChargeAttackAction)abstractAttackAction;
            toHitData = chargeAttackAction.toHit(this.game);
            n = ChargeAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof ClubAttackAction) {
            ClubAttackAction clubAttackAction = (ClubAttackAction)abstractAttackAction;
            toHitData = clubAttackAction.toHit(this.game);
            n = ClubAttackAction.getDamageFor(entity, clubAttackAction.getClub(), clubAttackAction.getTarget(this.game) instanceof Infantry && !(clubAttackAction.getTarget(this.game) instanceof BattleArmor));
        } else if (abstractAttackAction instanceof DfaAttackAction) {
            DfaAttackAction dfaAttackAction = (DfaAttackAction)abstractAttackAction;
            toHitData = dfaAttackAction.toHit(this.game);
            n = DfaAttackAction.getDamageFor(entity, dfaAttackAction.getTarget(this.game) instanceof Infantry && !(dfaAttackAction.getTarget(this.game) instanceof BattleArmor));
        } else if (abstractAttackAction instanceof KickAttackAction) {
            KickAttackAction kickAttackAction = (KickAttackAction)abstractAttackAction;
            toHitData = kickAttackAction.toHit(this.game);
            n = KickAttackAction.getDamageFor(entity, kickAttackAction.getLeg(), kickAttackAction.getTarget(this.game) instanceof Infantry && !(kickAttackAction.getTarget(this.game) instanceof BattleArmor));
        } else if (abstractAttackAction instanceof ProtomechPhysicalAttackAction) {
            ProtomechPhysicalAttackAction protomechPhysicalAttackAction = (ProtomechPhysicalAttackAction)abstractAttackAction;
            toHitData = protomechPhysicalAttackAction.toHit(this.game);
            n = ProtomechPhysicalAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof PunchAttackAction) {
            PunchAttackAction punchAttackAction = (PunchAttackAction)abstractAttackAction;
            int n3 = punchAttackAction.getArm();
            int n4 = 0;
            punchAttackAction.setArm(1);
            toHitData = punchAttackAction.toHit(this.game);
            punchAttackAction.setArm(2);
            ToHitData toHitData2 = punchAttackAction.toHit(this.game);
            n = PunchAttackAction.getDamageFor(entity, 1, punchAttackAction.getTarget(this.game) instanceof Infantry && !(punchAttackAction.getTarget(this.game) instanceof BattleArmor));
            n4 = PunchAttackAction.getDamageFor(entity, 2, punchAttackAction.getTarget(this.game) instanceof Infantry && !(punchAttackAction.getTarget(this.game) instanceof BattleArmor));
            punchAttackAction.setArm(n3);
            if (entity.isProne()) {
                double d;
                double d2 = Compute.oddsAbove(toHitData.getValue());
                if (d2 * (double)n > (d = Compute.oddsAbove(toHitData2.getValue())) * (double)n4) {
                    punchAttackAction.setArm(1);
                } else {
                    punchAttackAction.setArm(2);
                }
            }
            physicalResult.damageRight = n4;
            physicalResult.toHitRight = toHitData2;
            physicalResult.rollRight = Compute.d6(2);
        } else if (abstractAttackAction instanceof PushAttackAction) {
            PushAttackAction pushAttackAction = (PushAttackAction)abstractAttackAction;
            toHitData = pushAttackAction.toHit(this.game);
        } else if (abstractAttackAction instanceof TripAttackAction) {
            TripAttackAction tripAttackAction = (TripAttackAction)abstractAttackAction;
            toHitData = tripAttackAction.toHit(this.game);
        } else if (abstractAttackAction instanceof LayExplosivesAttackAction) {
            LayExplosivesAttackAction layExplosivesAttackAction = (LayExplosivesAttackAction)abstractAttackAction;
            toHitData = layExplosivesAttackAction.toHit(this.game);
            n = LayExplosivesAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof ThrashAttackAction) {
            ThrashAttackAction thrashAttackAction = (ThrashAttackAction)abstractAttackAction;
            toHitData = thrashAttackAction.toHit(this.game);
            n = ThrashAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof JumpJetAttackAction) {
            JumpJetAttackAction jumpJetAttackAction = (JumpJetAttackAction)abstractAttackAction;
            toHitData = jumpJetAttackAction.toHit(this.game);
            if (jumpJetAttackAction.getLeg() == 0) {
                n = JumpJetAttackAction.getDamageFor(entity, 1);
                physicalResult.damageRight = JumpJetAttackAction.getDamageFor(entity, 1);
            } else {
                n = JumpJetAttackAction.getDamageFor(entity, jumpJetAttackAction.getLeg());
                physicalResult.damageRight = 0;
            }
            entity.heatBuildup += (n + physicalResult.damageRight) / 3;
        } else if (abstractAttackAction instanceof GrappleAttackAction) {
            GrappleAttackAction grappleAttackAction = (GrappleAttackAction)abstractAttackAction;
            toHitData = grappleAttackAction.toHit(this.game);
        } else if (abstractAttackAction instanceof BreakGrappleAttackAction) {
            BreakGrappleAttackAction breakGrappleAttackAction = (BreakGrappleAttackAction)abstractAttackAction;
            toHitData = breakGrappleAttackAction.toHit(this.game);
        }
        physicalResult.toHit = toHitData;
        physicalResult.damage = n;
        return physicalResult;
    }

    private void resolvePhysicalAttack(PhysicalResult physicalResult, int n) {
        Serializable serializable;
        AbstractAttackAction abstractAttackAction = physicalResult.aaa;
        if (abstractAttackAction instanceof PunchAttackAction) {
            serializable = (PunchAttackAction)abstractAttackAction;
            if (((PunchAttackAction)serializable).getArm() == 0) {
                ((PunchAttackAction)serializable).setArm(1);
                physicalResult.aaa = serializable;
                this.resolvePunchAttack(physicalResult, n);
                n = ((AbstractEntityAction)serializable).getEntityId();
                ((PunchAttackAction)serializable).setArm(2);
                physicalResult.aaa = serializable;
                this.resolvePunchAttack(physicalResult, n);
            } else {
                this.resolvePunchAttack(physicalResult, n);
                n = ((AbstractEntityAction)serializable).getEntityId();
            }
        } else if (abstractAttackAction instanceof KickAttackAction) {
            this.resolveKickAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof BrushOffAttackAction) {
            serializable = (BrushOffAttackAction)abstractAttackAction;
            if (((BrushOffAttackAction)serializable).getArm() == 0) {
                ((BrushOffAttackAction)serializable).setArm(1);
                physicalResult.aaa = serializable;
                this.resolveBrushOffAttack(physicalResult, n);
                n = ((AbstractEntityAction)serializable).getEntityId();
                ((BrushOffAttackAction)serializable).setArm(2);
                physicalResult.aaa = serializable;
                this.resolveBrushOffAttack(physicalResult, n);
            } else {
                this.resolveBrushOffAttack(physicalResult, n);
                n = ((AbstractEntityAction)serializable).getEntityId();
            }
        } else if (abstractAttackAction instanceof ThrashAttackAction) {
            this.resolveThrashAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof ProtomechPhysicalAttackAction) {
            this.resolveProtoAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof ClubAttackAction) {
            this.resolveClubAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof PushAttackAction) {
            this.resolvePushAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof ChargeAttackAction) {
            this.resolveChargeAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof DfaAttackAction) {
            this.resolveDfaAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof LayExplosivesAttackAction) {
            this.resolveLayExplosivesAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof TripAttackAction) {
            this.resolveTripAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof JumpJetAttackAction) {
            this.resolveJumpJetAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof GrappleAttackAction) {
            this.resolveGrappleAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof BreakGrappleAttackAction) {
            this.resolveBreakGrappleAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        }
        serializable = this.game.getTarget(abstractAttackAction.getTargetType(), abstractAttackAction.getTargetId());
        if (serializable instanceof Entity) {
            this.creditKill((Entity)serializable, this.game.getEntity(n));
        }
    }

    private void checkExtremeGravityMovement(Entity entity, MoveStep moveStep, Coords coords, int n) {
        if (this.game.getOptions().floatOption("gravity") != 1.0f) {
            if (entity instanceof Mech) {
                if (moveStep.getMovementType() == 1 || moveStep.getMovementType() == 4 || moveStep.getMovementType() == 2 || moveStep.getMovementType() == 5) {
                    if (moveStep.getMpUsed() > n) {
                        this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                    }
                } else if (moveStep.getMovementType() == 3) {
                    System.err.println("gravity move check jump: " + moveStep.getMpUsed() + "/" + n);
                    System.err.flush();
                    if (moveStep.getMpUsed() > n) {
                        this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                    } else if (this.game.getOptions().floatOption("gravity") > 1.0f) {
                        PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
                        entity.addPilotingModifierForTerrain(pilotingRollData, moveStep);
                        pilotingRollData.append(new PilotingRollData(entity.getId(), 0, "jumped in high gravity"));
                        this.game.addExtremeGravityPSR(pilotingRollData);
                    }
                }
            } else if (entity instanceof Tank && (moveStep.getMovementType() == 1 || moveStep.getMovementType() == 4 || moveStep.getMovementType() == 2 || moveStep.getMovementType() == 5)) {
                if (moveStep.getMpUsed() > n && !moveStep.isOnlyPavement()) {
                    this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                } else if (moveStep.getMpUsed() > n + 1) {
                    this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                }
            }
        }
    }

    private Vector<Report> doExtremeGravityDamage(Entity entity, int n) {
        HitData hitData;
        int n2;
        Vector<Report> vector = new Vector<Report>();
        if (entity instanceof BipedMech) {
            for (n2 = 6; n2 <= 7; ++n2) {
                hitData = new HitData(n2);
                vector.addAll(this.damageEntity(entity, hitData, n, false, DamageType.NONE, true));
            }
        }
        if (entity instanceof QuadMech) {
            for (n2 = 4; n2 <= 7; ++n2) {
                hitData = new HitData(n2);
                vector.addAll(this.damageEntity(entity, hitData, n, false, DamageType.NONE, true));
            }
        } else if (entity instanceof Tank) {
            hitData = new HitData(1);
            vector.addAll(this.damageEntity(entity, hitData, n, false, DamageType.NONE, true));
        }
        return vector;
    }

    public Vector<Report> ejectEntity(Entity entity, boolean bl) {
        Vector<Report> vector = new Vector<Report>();
        if (entity.getCrew().isEjected()) {
            return vector;
        }
        if (entity.isCarcass()) {
            return vector;
        }
        if (entity instanceof Mech) {
            Report report;
            PilotingRollData pilotingRollData = new PilotingRollData(entity.getId(), entity.getCrew().getPiloting(), "ejecting");
            if (entity.isProne()) {
                pilotingRollData.addModifier(5, "Mech is prone");
            }
            if (entity.getCrew().isUnconscious()) {
                pilotingRollData.addModifier(3, "pilot unconscious");
            }
            if (bl) {
                pilotingRollData.addModifier(1, "automatic ejection");
            }
            if (entity.getInternal(0) < 3) {
                pilotingRollData.addModifier(Math.min(3 - entity.getInternal(0), 2), "Head Internal Structure Damage");
            }
            int n = entity.getFacing();
            Coords coords = entity.getPosition().translated((n + 3) % 6);
            IHex iHex = this.game.getBoard().getHex(coords);
            if (iHex != null) {
                if (iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20)) {
                    pilotingRollData.addModifier(-1, "landing in water");
                } else if (iHex.containsTerrain(2)) {
                    pilotingRollData.addModifier(0, "landing in rough");
                } else if (iHex.containsTerrain(3)) {
                    pilotingRollData.addModifier(0, "landing in rubble");
                } else if (iHex.terrainLevel(1) == 1) {
                    pilotingRollData.addModifier(2, "landing in light woods");
                } else if (iHex.terrainLevel(1) == 2) {
                    pilotingRollData.addModifier(3, "landing in heavy woods");
                } else if (iHex.terrainLevel(1) == 3) {
                    pilotingRollData.addModifier(4, "landing in ultra heavy woods");
                } else if (iHex.terrainLevel(23) == 1) {
                    pilotingRollData.addModifier(3, "landing in light jungle");
                } else if (iHex.terrainLevel(23) == 2) {
                    pilotingRollData.addModifier(5, "landing in heavy jungle");
                } else if (iHex.terrainLevel(23) == 3) {
                    pilotingRollData.addModifier(7, "landing in ultra heavy jungle");
                } else if (iHex.terrainLevel(12) > 0) {
                    pilotingRollData.addModifier(iHex.terrainLevel(12), "landing in a building");
                } else {
                    pilotingRollData.addModifier(-2, "landing in clear terrain");
                }
            } else {
                pilotingRollData.addModifier(-2, "landing off the board");
            }
            if (bl) {
                report = new Report(6395);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
            }
            report = new Report(2180);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(pilotingRollData.getLastPlainDesc(), true);
            report.indent(3);
            vector.addElement(report);
            int n2 = Compute.d6(2);
            report = new Report(2190);
            report.subject = entity.getId();
            report.add(pilotingRollData.getValueAsString());
            report.add(pilotingRollData.getDesc());
            report.add(n2);
            report.indent(4);
            report.newlines = 0;
            MechWarrior mechWarrior = new MechWarrior(entity);
            mechWarrior.setDeployed(true);
            mechWarrior.setId(this.getFreeEntityId());
            this.game.addEntity(mechWarrior.getId(), mechWarrior);
            this.send(this.createAddEntityPacket(mechWarrior.getId()));
            mechWarrior.setDone(true);
            if (n2 < pilotingRollData.getValue()) {
                report.choose(false);
                vector.addElement(report);
                Report.addNewline(vector);
                vector.addAll(this.damageCrew(mechWarrior, 1));
            } else {
                report.choose(true);
                vector.addElement(report);
            }
            if (entity.getCrew().isDoomed()) {
                vector.addAll(this.destroyEntity(mechWarrior, "deadly ejection", false, false));
            } else {
                if (this.game.getBoard().contains(coords)) {
                    mechWarrior.setPosition(coords);
                    report = new Report(6400);
                    report.subject = entity.getId();
                    report.indent(5);
                    vector.addElement(report);
                    if (this.game.getOptions().booleanOption("vacuum")) {
                        report = new Report(6405);
                        report.subject = entity.getId();
                        report.indent(3);
                        vector.addElement(report);
                        vector.addAll(this.destroyEntity(mechWarrior, "explosive decompression", false, false));
                    }
                    this.entityUpdate(mechWarrior.getId());
                    vector.addAll(this.doEntityDisplacementMinefieldCheck(mechWarrior, entity.getPosition(), coords));
                } else {
                    report = new Report(6410);
                    report.subject = entity.getId();
                    report.indent(3);
                    vector.addElement(report);
                    if (this.game.getOptions().booleanOption("vacuum")) {
                        report = new Report(6405);
                        report.subject = entity.getId();
                        report.indent(3);
                        vector.addElement(report);
                        vector.addAll(this.destroyEntity(mechWarrior, "explosive decompression", false, false));
                    } else {
                        this.game.removeEntity(mechWarrior.getId(), 256);
                        this.send(this.createRemoveEntityPacket(mechWarrior.getId(), 256));
                    }
                }
                if (this.game.getOptions().booleanOption("ejected_pilots_flee")) {
                    this.game.removeEntity(mechWarrior.getId(), 256);
                    this.send(this.createRemoveEntityPacket(mechWarrior.getId(), 256));
                }
            }
        } else if (this.game.getBoard().contains(entity.getPosition()) && !this.game.getOptions().booleanOption("ejected_pilots_flee") && entity instanceof Tank) {
            int n = Math.max(1, (int)(14.0f + entity.getWeight()) / 15);
            MechWarrior mechWarrior = new MechWarrior(entity);
            mechWarrior.setChassis("Vehicle Crew");
            mechWarrior.setDeployed(true);
            mechWarrior.setId(this.getFreeEntityId());
            mechWarrior.initializeInternal(n, 0);
            this.game.addEntity(mechWarrior.getId(), mechWarrior);
            this.send(this.createAddEntityPacket(mechWarrior.getId()));
            mechWarrior.setDone(true);
            mechWarrior.setPosition(entity.getPosition());
            this.entityUpdate(mechWarrior.getId());
            vector.addAll(this.doEntityDisplacementMinefieldCheck(mechWarrior, entity.getPosition(), entity.getPosition()));
        }
        entity.getCrew().setEjected(true);
        if (entity instanceof VTOL) {
            vector.addAll(this.crashVTOLorWiGE((VTOL)entity));
        }
        vector.addAll(this.destroyEntity(entity, "ejection", true, true));
        if (!bl) {
            this.game.removeEntity(entity.getId(), 528);
            this.send(this.createRemoveEntityPacket(entity.getId(), 528));
        }
        return vector;
    }

    public Vector<Report> abandonEntity(Entity entity) {
        Vector<Report> vector = new Vector<Report>();
        if (entity.getCrew().isEjected()) {
            return vector;
        }
        if (entity.getCrew().isDoomed()) {
            return vector;
        }
        if (this.game.getOptions().booleanOption("vacuum")) {
            return vector;
        }
        Coords coords = entity.getPosition();
        if (entity instanceof Mech) {
            Report report = new Report(2027);
            report.subject = entity.getId();
            report.add(entity.getCrew().getName());
            report.addDesc(entity);
            report.indent(3);
            vector.addElement(report);
            MechWarrior mechWarrior = new MechWarrior(entity);
            mechWarrior.getCrew().setUnconscious(entity.getCrew().isUnconscious());
            mechWarrior.setDeployed(true);
            mechWarrior.setId(this.getFreeEntityId());
            this.game.addEntity(mechWarrior.getId(), mechWarrior);
            this.send(this.createAddEntityPacket(mechWarrior.getId()));
            mechWarrior.setDone(true);
            if (this.game.getBoard().contains(coords)) {
                mechWarrior.setPosition(coords);
            }
            this.entityUpdate(mechWarrior.getId());
            vector.addAll(this.doEntityDisplacementMinefieldCheck(mechWarrior, entity.getPosition(), coords));
            if (this.game.getOptions().booleanOption("ejected_pilots_flee")) {
                this.game.removeEntity(mechWarrior.getId(), 256);
                this.send(this.createRemoveEntityPacket(mechWarrior.getId(), 256));
            }
        } else if (this.game.getBoard().contains(entity.getPosition()) && !this.game.getOptions().booleanOption("ejected_pilots_flee") && this.game.getOptions().booleanOption("vehicles_can_eject") && entity instanceof Tank) {
            int n = Math.max(1, (int)(14.0f + entity.getWeight()) / 15);
            MechWarrior mechWarrior = new MechWarrior(entity);
            mechWarrior.setChassis("Vehicle Crew");
            mechWarrior.setDeployed(true);
            mechWarrior.setId(this.getFreeEntityId());
            mechWarrior.initializeInternal(n, 0);
            this.game.addEntity(mechWarrior.getId(), mechWarrior);
            this.send(this.createAddEntityPacket(mechWarrior.getId()));
            mechWarrior.setDone(true);
            mechWarrior.setPosition(entity.getPosition());
            this.entityUpdate(mechWarrior.getId());
            vector.addAll(this.doEntityDisplacementMinefieldCheck(mechWarrior, entity.getPosition(), entity.getPosition()));
        }
        entity.getCrew().setEjected(true);
        return vector;
    }

    private void resolveMechWarriorPickUp() {
        Enumeration<Entity> enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                MechWarrior mechWarrior;
                return entity instanceof MechWarrior && (mechWarrior = (MechWarrior)entity).getPickedUpById() == -1 && !mechWarrior.isDoomed() && mechWarrior.getTransportId() == -1;
            }
        });
        while (enumeration.hasMoreElements()) {
            Report report;
            Object object;
            boolean bl = false;
            MechWarrior mechWarrior = (MechWarrior)enumeration.nextElement();
            Enumeration<Entity> enumeration2 = this.game.getEntities(mechWarrior.getPosition());
            while (enumeration2.hasMoreElements()) {
                object = enumeration2.nextElement();
                if (((Entity)object).isDoomed() || ((Entity)object).isShutDown() || ((Entity)object).getCrew().isUnconscious() || bl || ((Entity)object).getOwnerId() != mechWarrior.getOwnerId() || ((Entity)object).getId() == mechWarrior.getId()) continue;
                if (object instanceof MechWarrior) {
                    report = new Report(6415, 0);
                    report.add(((Entity)object).getDisplayName());
                    this.addReport(report);
                    continue;
                }
                ((Entity)object).pickUp(mechWarrior);
                mechWarrior.setPickedUpById(((Entity)object).getId());
                mechWarrior.setPickedUpByExternalId(((Entity)object).getExternalId());
                bl = true;
                report = new Report(6420, 0);
                report.add(mechWarrior.getDisplayName());
                report.addDesc((Entity)object);
                this.addReport(report);
                break;
            }
            if (!bl) {
                object = this.game.getEnemyEntities(mechWarrior.getPosition(), mechWarrior);
                while (object.hasMoreElements()) {
                    Entity entity = (Entity)object.nextElement();
                    if (entity.isDoomed() || entity.isShutDown() || entity.getCrew().isUnconscious()) continue;
                    if (entity instanceof MechWarrior) {
                        report = new Report(6415, 0);
                        report.add(entity.getDisplayName());
                        this.addReport(report);
                        continue;
                    }
                    entity.pickUp(mechWarrior);
                    mechWarrior.setCaptured(true);
                    mechWarrior.setPickedUpById(entity.getId());
                    mechWarrior.setPickedUpByExternalId(entity.getExternalId());
                    bl = true;
                    report = new Report(6420, 0);
                    report.add(mechWarrior.getDisplayName());
                    report.addDesc(entity);
                    this.addReport(report);
                    break;
                }
            }
            if (!bl) continue;
            mechWarrior.setPosition(null);
            this.entityUpdate(mechWarrior.getId());
        }
    }

    private void resolveSinkVees() {
        Enumeration<Entity> enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                if (entity.isOffBoard()) {
                    return false;
                }
                return entity instanceof Tank && entity.getPosition() != null && (entity.getMovementMode() == 3 || entity.getMovementMode() == 4) && Server.this.game.getBoard().getHex(entity.getPosition()).terrainLevel(4) > 0 && entity.getElevation() < 0;
            }
        });
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            this.addReport(this.destroyEntity(entity, "a watery grave", false));
        }
    }

    private void doTryUnstuck() {
        if (this.game.getPhase() != IGame.Phase.PHASE_MOVEMENT) {
            return;
        }
        Enumeration<Entity> enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return entity.isStuck();
            }
        });
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
            entity.addPilotingModifierForTerrain(pilotingRollData);
            IHex iHex = this.game.getBoard().getHex(entity.getPosition());
            if (!iHex.containsTerrain(9) && iHex.terrainLevel(24) != 2) {
                pilotingRollData.addModifier(-1, "bogged down");
            }
            Report report = new Report(2340);
            report.addDesc(entity);
            this.addReport(report);
            int n = Compute.d6(2);
            report = new Report(2190);
            report.subject = entity.getId();
            report.add(pilotingRollData.getValueAsString());
            report.add(pilotingRollData.getDesc());
            report.add(n);
            if (n < pilotingRollData.getValue()) {
                report.choose(false);
            } else {
                report.choose(true);
                entity.setStuck(false);
                entity.setCanUnstickByJumping(false);
                this.entityUpdate(entity.getId());
            }
            this.addReport(report);
        }
    }

    private void resolveVeeINarcPodRemoval() {
        Enumeration<Entity> enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return entity instanceof Tank && entity.mpUsed == 0;
            }
        });
        while (enumeration.hasMoreElements()) {
            boolean bl = true;
            Entity entity = enumeration.nextElement();
            for (int i = 0; i <= 5; ++i) {
                if (!entity.weaponFiredFrom(i)) continue;
                bl = false;
            }
            if (((Tank)entity).getStunnedTurns() > 0) {
                bl = false;
            }
            if (!bl || !entity.hasINarcPodsAttached() || !entity.getCrew().isActive()) continue;
            entity.removeAllINarcPods();
            Report report = new Report(2345);
            report.addDesc(entity);
            this.addReport(report);
        }
    }

    private Vector<Report> resolveIceBroken(Coords coords) {
        Vector<Report> vector = new Vector<Report>();
        IHex iHex = this.game.getBoard().getHex(coords);
        iHex.removeTerrain(20);
        this.sendChangedHex(coords);
        if (iHex.terrainLevel(4) > 0) {
            Enumeration<Entity> enumeration = this.game.getEntities(coords);
            while (enumeration.hasMoreElements()) {
                Entity entity = enumeration.nextElement();
                if (entity.getElevation() != 0 || entity.getMovementMode() == 5 || entity.getMovementMode() == 15 || entity.getMovementMode() == 18 || entity.hasUMU()) continue;
                vector.addAll(this.doEntityFallsInto(entity, coords, coords, new PilotingRollData(0x7FFFFFFE)));
            }
        }
        return vector;
    }

    public Vector<Report> checkForVehicleFire(Tank tank, boolean bl) {
        Vector<Report> vector = new Vector<Report>();
        int n = Compute.d6(2);
        int n2 = 0;
        switch (tank.getMovementMode()) {
            case 5: {
                n2 = 4;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
            }
        }
        if (bl) {
            n = 12;
        }
        Report report = new Report(5250);
        report.subject = tank.getId();
        report.addDesc(tank);
        report.add(8 - n2);
        report.add(n);
        if (n + n2 < 8) {
            report.choose(true);
            vector.add(report);
        } else {
            if (!bl) {
                report.choose(false);
                vector.add(report);
            }
            if (n + n2 < 10) {
                this.addReport(this.vehicleMotiveDamage(tank, n2 - 1));
            } else {
                vector.addAll(this.resolveVehicleFire(tank, false));
                if (n + n2 >= 12) {
                    report = new Report(5255);
                    report.subject = tank.getId();
                    report.indent(3);
                    vector.add(report);
                    tank.setOnFire(bl);
                }
            }
        }
        return vector;
    }

    private Vector<Report> resolveVehicleFire(Tank tank, boolean bl) {
        Vector<Report> vector = new Vector<Report>();
        if (bl && !tank.isOnFire()) {
            return vector;
        }
        for (int i = 0; i < tank.locations(); ++i) {
            if (i == 0 || tank instanceof VTOL && i == 5 || bl && !tank.isLocationBurning(i)) continue;
            HitData hitData = new HitData(i);
            int n = Compute.d6(1);
            vector.addAll(this.damageEntity(tank, hitData, n));
            if (n != 1 || !bl) continue;
            tank.extinguishLocation(i);
        }
        return vector;
    }

    private Vector<Report> vehicleMotiveDamage(Tank tank, int n) {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(1210, 0);
        vector.add(report);
        switch (tank.getMovementMode()) {
            case 5: 
            case 8: {
                n += 3;
                break;
            }
            case 4: {
                n += 2;
                break;
            }
            case 15: {
                n += 4;
                break;
            }
            case 6: {
                int n2 = tank.getOriginalWalkMP();
                if (n2 > 0) {
                    tank.setOriginalWalkMP(n2 - 1);
                }
                if (n2 > 1) {
                    report = new Report(6660);
                    report.subject = tank.getId();
                    vector.add(report);
                } else {
                    report = new Report(6670);
                    report.subject = tank.getId();
                    vector.add(report);
                    vector.addAll(this.crashVTOLorWiGE(tank));
                }
                return vector;
            }
        }
        int n3 = Compute.d6(2) + n;
        report = new Report(6305);
        report.subject = tank.getId();
        report.add("movement system");
        report.newlines = 0;
        report.indent(3);
        vector.add(report);
        report = new Report(6310);
        report.subject = tank.getId();
        report.add(n3);
        report.newlines = 0;
        vector.add(report);
        report = new Report(3340);
        report.add(n);
        report.subject = tank.getId();
        vector.add(report);
        if (n3 <= 5) {
            report = new Report(6005);
            report.subject = tank.getId();
            report.indent(3);
            vector.add(report);
        } else if (n3 <= 7) {
            report = new Report(6470);
            report.subject = tank.getId();
            report.indent(3);
            vector.add(report);
            tank.addMovementDamage(1);
        } else if (n3 <= 9) {
            report = new Report(6471);
            report.subject = tank.getId();
            report.indent(3);
            vector.add(report);
            tank.addMovementDamage(2);
            int n4 = tank.getOriginalWalkMP();
            if (n4 > 0) {
                tank.setOriginalWalkMP(n4 - 1);
            }
        } else if (n3 <= 11) {
            report = new Report(6472);
            report.subject = tank.getId();
            report.indent(3);
            vector.add(report);
            tank.addMovementDamage(3);
            int n5 = tank.getOriginalWalkMP();
            if (n5 > 0) {
                tank.setOriginalWalkMP(n5 / 2);
            }
        } else {
            report = new Report(6473);
            report.subject = tank.getId();
            report.indent(3);
            vector.add(report);
            tank.immobilize();
        }
        if (tank.getOriginalWalkMP() == 0 || tank.isImmobile()) {
            if ((tank.getMovementMode() == 5 || tank.getMovementMode() == 15 && tank.getElevation() == 0) && this.game.getBoard().getHex(tank.getPosition()).terrainLevel(4) > 0 && !this.game.getBoard().getHex(tank.getPosition()).containsTerrain(20)) {
                vector.addAll(this.destroyEntity(tank, "a watery grave", false));
            }
            if (tank instanceof VTOL || tank.getMovementMode() == 15 && tank.getElevation() > 0) {
                vector.addAll(this.crashVTOLorWiGE(tank));
            }
        }
        return vector;
    }

    private void addReport(Vector<Report> vector) {
        if (this.doBlind()) {
            Enumeration<IConnection> enumeration = this.connections.elements();
            while (enumeration.hasMoreElements()) {
                IConnection iConnection = enumeration.nextElement();
                Player player = this.game.getPlayer(iConnection.getId());
                player.getTurnReport().addAll(this.filterReportVector(vector, player));
            }
        }
        this.vPhaseReport.addAll(vector);
    }

    private void addReport(Report report) {
        if (this.doBlind()) {
            Enumeration<IConnection> enumeration = this.connections.elements();
            while (enumeration.hasMoreElements()) {
                IConnection iConnection = enumeration.nextElement();
                Player player = this.game.getPlayer(iConnection.getId());
                player.getTurnReport().addElement(this.filterReport(report, player, false));
            }
        }
        this.vPhaseReport.addElement(report);
    }

    private void clearReports() {
        if (this.doBlind()) {
            Enumeration<IConnection> enumeration = this.connections.elements();
            while (enumeration.hasMoreElements()) {
                IConnection iConnection = enumeration.nextElement();
                Player player = this.game.getPlayer(iConnection.getId());
                player.getTurnReport().removeAllElements();
            }
        }
        this.vPhaseReport.removeAllElements();
    }

    private void addNewLines() {
        if (this.doBlind()) {
            Enumeration<IConnection> enumeration = this.connections.elements();
            while (enumeration.hasMoreElements()) {
                IConnection iConnection = enumeration.nextElement();
                Player player = this.game.getPlayer(iConnection.getId());
                Report.addNewline(player.getTurnReport());
            }
        }
        Report.addNewline(this.vPhaseReport);
    }

    public void doAssaultDrop(Entity entity) {
        PilotingRollData pilotingRollData = entity instanceof Mech ? entity.getBasePilotingRoll() : new PilotingRollData(entity.getId(), 4, "landing assault drop");
        int n = Compute.d6(2);
        Report report = new Report(2380);
        report.subject = entity.getId();
        report.add(entity.getDisplayName(), true);
        report.add(pilotingRollData.getValueAsString());
        report.add(n);
        report.choose(n >= pilotingRollData.getValue());
        this.addReport(report);
        if (n < pilotingRollData.getValue()) {
            int n2 = pilotingRollData.getValue() - n;
            int n3 = Compute.d6(n2);
            Coords coords = Compute.scatter(entity.getPosition(), n3);
            report = new Report(2385);
            report.subject = entity.getId();
            report.add(n3);
            report.indent(3);
            report.newlines = 0;
            this.addReport(report);
            if (n2 >= 5 || !this.game.getBoard().contains(coords)) {
                report = new Report(2386);
                this.addReport(report);
                this.game.removeEntity(entity.getId(), 2048);
                return;
            }
            entity.setPosition(coords);
            if (entity instanceof Mech || entity instanceof Protomech) {
                entity.setElevation(n2);
                this.addReport(this.doEntityFallsInto(entity, coords, coords, pilotingRollData, true));
            } else if (entity instanceof BattleArmor) {
                for (int i = 1; i < entity.locations(); ++i) {
                    HitData hitData = new HitData(i);
                    this.addReport(this.damageEntity(entity, hitData, Compute.d6(n2)));
                    this.addNewLines();
                }
            } else if (entity instanceof Infantry) {
                HitData hitData = new HitData(0);
                this.addReport(this.damageEntity(entity, hitData, 1));
                this.addNewLines();
            }
        }
        IHex iHex = this.game.getBoard().getHex(entity.getPosition());
        entity.setElevation(entity.elevationOccupied(iHex) - iHex.floor());
        Entity entity2 = Compute.stackingViolation(this.game, entity, entity.getPosition(), null);
        if (entity2 != null) {
            entity.setElevation(entity2.getElevation() + 2);
            report = new Report(2390);
            report.subject = entity.getId();
            report.add(entity.getDisplayName(), true);
            report.add(entity2.getDisplayName(), true);
            this.addReport(report);
            this.addReport(this.doEntityFallsInto(entity, entity.getPosition(), entity.getPosition(), pilotingRollData));
        }
    }

    void doAllAssaultDrops() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!entity.isAssaultDropInProgress()) continue;
            this.doAssaultDrop(entity);
            entity.setLandedAssaultDrop();
        }
    }

    void doMagmaDamage(Entity entity, boolean bl) {
        if ((entity.getMovementMode() == 6 || entity.getMovementMode() == 5 || entity.getMovementMode() == 15 && entity.getOriginalWalkMP() > 0 && !bl) && !entity.isImmobile()) {
            return;
        }
        boolean bl2 = entity instanceof Mech;
        Report report = bl2 ? new Report(2405) : new Report(2400);
        report.addDesc(entity);
        report.subject = entity.getId();
        this.addReport(report);
        if (bl2) {
            for (int i = 0; i < entity.locations(); ++i) {
                if (!bl && !entity.locationIsLeg(i) && !entity.isProne()) continue;
                HitData hitData = new HitData(i);
                this.addReport(this.damageEntity(entity, hitData, Compute.d6(2)));
            }
        } else {
            this.addReport(this.destroyEntity(entity, "fell into magma", false, false));
        }
        this.addNewLines();
    }

    void artilleryDamageHex(Coords coords, Coords coords2, int n, AmmoType ammoType, int n2, Entity entity, Entity entity2, boolean bl, int n3, Vector<Report> vector) {
        Object object;
        Object object2;
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex == null) {
            return;
        }
        int n4 = n3 - iHex.surface();
        if (!bl) {
            vector.addAll(this.tryClearHex(coords, n * 2, n2));
        }
        Building building = this.game.getBoard().getBuildingAt(coords);
        int n5 = 0;
        if (!(building == null || bl && n4 > iHex.terrainLevel(12))) {
            n5 = building.getPhaseCF() / 10;
            if (ammoType == null || ammoType.getMunitionType() != 4L) {
                object2 = this.damageBuilding(building, n);
                object = ((Vector)object2).iterator();
                while (object.hasNext()) {
                    Report report = (Report)object.next();
                    report.subject = n2;
                }
                vector.addAll((Collection<Report>)object2);
                this.addNewLines();
            }
        }
        if (bl && (n4 <= 0 || n4 <= iHex.terrainLevel(12) || n4 == iHex.terrainLevel(16))) {
            return;
        }
        object2 = this.game.getEntities(coords);
        while (object2.hasMoreElements()) {
            Report report;
            object = object2.nextElement();
            int n6 = n;
            ToHitData toHitData = new ToHitData();
            int n7 = 5;
            if (object == entity2) continue;
            if (building != null && n5 > 0 && ((Entity)object).getElevation() < iHex.terrainLevel(12)) {
                n7 -= n5;
                if (object instanceof Infantry) continue;
                if (n7 <= 0) {
                    report = new Report(6426);
                    report.subject = n2;
                    report.addDesc((Entity)object);
                    vector.add(report);
                    continue;
                }
                report = new Report(6425);
                report.subject = n2;
                report.add(n5);
                vector.add(report);
            }
            if (!bl ? (object instanceof VTOL || ((Entity)object).getMovementMode() == 6) && ((Entity)object).getElevation() != 0 && ((Entity)object).getElevation() != iHex.terrainLevel(12) && ((Entity)object).getElevation() != iHex.terrainLevel(16) : !(object instanceof VTOL) && ((Entity)object).getMovementMode() != 6 || ((Entity)object).getElevation() != n4) continue;
            if (coords2 != null) {
                toHitData.setSideTable(((Entity)object).sideTable(coords2));
                if (ammoType != null && object instanceof Mech && ammoType.getMunitionType() == 1L && coords2.equals(coords)) {
                    toHitData.setHitTable(4);
                }
            }
            if (object instanceof Infantry && !(object instanceof BattleArmor)) {
                n6 *= 2;
            }
            if (ammoType != null) {
                if (ammoType.getMunitionType() == 1L) {
                    if (iHex.containsTerrain(21) && object instanceof Infantry && !(object instanceof BattleArmor)) {
                        n6 *= 2;
                    }
                    if (iHex.containsTerrain(1) || iHex.containsTerrain(23)) {
                        n6 = (n6 + 1) / 2;
                    }
                } else if (ammoType.getMunitionType() == 4L) {
                    if (object instanceof Tank && (((Entity)object).getMovementMode() == 4 || ((Entity)object).getMovementMode() == 5)) {
                        report = new Report(6480);
                        report.subject = ((Entity)object).getId();
                        report.addDesc((Entity)object);
                        report.add(toHitData.getTableDesc());
                        report.add(0);
                        vector.add(report);
                        vector.addAll(this.vehicleMotiveDamage((Tank)object, 0));
                        continue;
                    }
                    if (object instanceof BattleArmor || !(object instanceof Infantry)) continue;
                    if (iHex.containsTerrain(1) || iHex.containsTerrain(23)) {
                        n6 = (n6 + 1) / 2;
                    }
                }
            }
            report = new Report(6480);
            report.subject = ((Entity)object).getId();
            report.addDesc((Entity)object);
            report.add(toHitData.getTableDesc());
            report.add(n6);
            vector.add(report);
            if (object instanceof BattleArmor) {
                for (int i = 0; i < ((Entity)object).locations(); ++i) {
                    if (((Entity)object).getInternal(i) <= 0) continue;
                    HitData hitData = new HitData(i);
                    vector.addAll(this.damageEntity((Entity)object, hitData, n6, false, DamageType.NONE, false, true, false));
                }
            } else {
                while (n6 > 0) {
                    HitData hitData = ((Entity)object).rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
                    vector.addAll(this.damageEntity((Entity)object, hitData, Math.min(n7, n6), false, DamageType.NONE, false, true, false));
                    n6 -= Math.min(5, n6);
                }
            }
            if (entity == null) continue;
            this.creditKill((Entity)object, entity);
        }
    }

    public void artilleryDamageArea(Coords coords, Coords coords2, AmmoType ammoType, int n, Entity entity, boolean bl, int n2, Vector<Report> vector) {
        int n3;
        int n4 = 5;
        if (ammoType.getMunitionType() == 4L) {
            n3 = ammoType.getRackSize() + 10;
        } else if (ammoType.getMunitionType() == 1L) {
            n3 = ammoType.getAmmoType() == 17 ? 15 : ammoType.getRackSize();
            coords2 = coords;
        } else if (this.game.getOptions().booleanOption("maxtech_artillery")) {
            n3 = ammoType.getAmmoType() == 16 ? 25 : ammoType.getRackSize() + 10;
            n4 = 10;
        } else {
            n3 = ammoType.getRackSize();
            n4 = (n3 + 1) / 2;
        }
        this.artilleryDamageArea(coords, coords2, ammoType, n, entity, n3, n4, bl, n2, vector);
    }

    public void artilleryDamageArea(Coords coords, Coords coords2, AmmoType ammoType, int n, Entity entity, int n2, int n3, boolean bl, int n4, Vector<Report> vector) {
        int n5 = 0;
        while (n2 > 0) {
            ArrayList<Coords> arrayList = Compute.coordsAtRange(coords, n5);
            for (Coords coords3 : arrayList) {
                this.artilleryDamageHex(coords3, coords2, n2, ammoType, n, entity, null, bl, n4, vector);
            }
            coords2 = coords;
            ++n5;
            n2 -= n3;
        }
    }

    void resolveFortify() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Report report;
            Entity entity = enumeration.nextElement();
            if (!(entity instanceof Infantry)) continue;
            Infantry infantry = (Infantry)entity;
            int n = infantry.getDugIn();
            if (n == 1) {
                report = new Report(5300);
                report.addDesc(infantry);
                report.subject = infantry.getId();
                this.addReport(report);
                continue;
            }
            if (n != 4) continue;
            Coords coords = infantry.getPosition();
            report = new Report(5305);
            report.addDesc(infantry);
            report.add(coords.getBoardNum());
            report.subject = infantry.getId();
            this.addReport(report);
            IHex iHex = this.game.getBoard().getHex(coords);
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(21, 1));
            this.sendChangedHex(coords);
            Enumeration<Entity> enumeration2 = this.game.getEntities(coords);
            while (enumeration2.hasMoreElements()) {
                Entity entity2 = enumeration2.nextElement();
                if (!(entity2 instanceof Infantry)) continue;
                Infantry infantry2 = (Infantry)entity;
                infantry2.setDugIn(0);
            }
        }
    }

    private void checkBreakSpikes(Entity entity, int n) {
        int n2 = Compute.d6(2);
        if (n2 < 9) {
            Report report = new Report(4445);
            report.newlines = 0;
            report.add(n2);
            report.subject = entity.getId();
            this.addReport(report);
            return;
        }
        Report report = new Report(4440);
        report.newlines = 0;
        report.add(n2);
        report.subject = entity.getId();
        this.addReport(report);
        for (Mounted mounted : entity.getMisc()) {
            if (!mounted.getType().hasFlag(0x400000000L) || mounted.getLocation() != n) continue;
            mounted.setHit(true);
        }
    }

    public String getHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            return "";
        }
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    private void handleAttacks() {
        boolean bl;
        Report report;
        int n;
        int n2 = -1;
        Vector<AttackHandler> vector = this.game.getAttacksVector();
        Vector<AttackHandler> vector2 = new Vector<AttackHandler>();
        Vector<Report> vector3 = new Vector<Report>();
        for (AttackHandler attackHandler : vector) {
            if (!(attackHandler instanceof TAGHandler) || !attackHandler.cares(this.game.getPhase())) continue;
            n = attackHandler.getAttackerId();
            if (n != n2 && !attackHandler.announcedEntityFiring()) {
                report = new Report(3100);
                report.subject = n;
                Entity entity = this.game.getEntity(n);
                if (entity == null) {
                    System.err.println("ae null in handleattacks, entityId " + n);
                }
                report.addDesc(this.game.getEntity(n));
                vector3.addElement(report);
                attackHandler.setAnnouncedEntityFiring(true);
            }
            n2 = n;
            bl = attackHandler.handle(this.game.getPhase(), vector3);
            if (!bl) continue;
            vector2.add(attackHandler);
        }
        for (AttackHandler attackHandler : vector) {
            if (attackHandler instanceof TAGHandler) continue;
            if (attackHandler.cares(this.game.getPhase())) {
                n = attackHandler.getAttackerId();
                if (n != n2 && !attackHandler.announcedEntityFiring()) {
                    report = new Report(3100);
                    report.subject = n;
                    Entity entity = this.game.getEntity(n);
                    if (entity == null) {
                        entity = this.game.getOutOfGameEntity(n);
                    }
                    if (entity == null) {
                        System.err.println("ae null in handleattacks, entityId " + n);
                    }
                    report.addDesc(this.game.getEntity(n));
                    vector3.addElement(report);
                    attackHandler.setAnnouncedEntityFiring(true);
                }
                n2 = n;
                bl = attackHandler.handle(this.game.getPhase(), vector3);
                if (!bl) continue;
                vector2.add(attackHandler);
                continue;
            }
            vector2.add(attackHandler);
        }
        this.addReport(vector3);
        this.game.setAttacksVector(vector2);
    }

    public static Server getServerInstance() {
        return serverInstance;
    }

    static {
        serverInstance = null;
    }

    class ConnectionWatchdog
    extends TimerTask {
        private Server server;
        private int id;
        private int failCount;

        public ConnectionWatchdog(Server server2, int n) {
            this.server = server2;
            this.id = n;
            this.failCount = 0;
        }

        public void run() {
            if (this.server.getPlayer(this.id) != null) {
                this.cancel();
                return;
            }
            if (this.server.getPendingConnection(this.id) == null) {
                this.cancel();
                return;
            }
            System.err.println("Bark Bark");
            if (this.failCount > 10) {
                this.server.getPendingConnection(this.id).close();
                this.cancel();
                System.err.println("Growl");
                System.err.println("\n\n\n\n\n");
                return;
            }
            this.server.greeting(this.id);
            ++this.failCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DamageType {
        NONE,
        FRAGMENTATION,
        FLECHETTE,
        ACID,
        INCENDIARY,
        FIREDRAKE,
        IGNORE_PASSENGER,
        ANTI_TSM;

    }
}

