/* MegaMek - Copyright (C) 2004,2005 Ben Mazur (bmazur@sev.org)
 * 
 *  This program is free software; you can redistribute it and/or modify it 
 *  under the terms of the GNU General Public License as published by the Free 
 *  Software Foundation; either version 2 of the License, or (at your option) 
 *  any later version.
 * 
 *  This program is distributed in the hope that it will be useful, but 
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 *  for more details.
 */
/*
 * Created on Sep 25, 2004
 *
 */
package megamek.common.weapons;

import megamek.common.AmmoType;
import megamek.common.TechConstants;

/**
 * @author Jay Lawson
 */
public class NAC40Weapon extends NavalACWeapon {
    /**
     * 
     */
    private static final long serialVersionUID = 8756042527483383101L;

    /**
     * 
     */
    public NAC40Weapon() {
        super();
        this.techLevel = TechConstants.T_IS_LEVEL_2;
        this.name = "Naval AC 40";
        this.setInternalName(this.name);
        this.addLookupName("NAC40");
        this.heat = 135;
        this.damage = 40;
        this.rackSize = 40;
        this.shortRange = 6;
        this.mediumRange = 12;
        this.longRange = 18;
        this.extremeRange = 24;
        this.tonnage = 4500.0f;
        this.bv = 5668;
        this.cost = 18000000;      
        this.shortAV = 40;
        this.medAV = 40;
        this.maxRange = RANGE_MED;
    
    }
}
