/*
 * MegaMek - Copyright (C) 2000-2002 Ben Mazur (bmazur@sev.org)
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 2 of the License, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *  for more details.
 */

package megamek.server.commands;

import megamek.server.Server;

/**
 *
 * @author  fastsammy
 * @version 
 */
public class NukeCommand extends ServerCommand {

    /** Creates new NukeCommand */
    public NukeCommand(Server server) {
        super(server, "nuke", "Drops a nuke onto the board, to be exploded at" +
        		"the end of the next weapons attack phase.");
    }

    /**
     * Run this command with the arguments supplied
     */
    public void run(int connId, String[] args) {

        // Check to make sure nuking is allowed by game options!
        if (!(server.getGame().getOptions().booleanOption("really_allow_nukes") && server.getGame().getOptions().booleanOption("allow_nukes"))) {
            server.sendServerChat(connId, "Command-line nukes are not enabled in this game.");
            return;
        }

        // Check argument integrity.
        if (args.length == 4) {
            // Check command type 1
            try {
                int[] nuke = new int[3];
                for (int i = 1; i < 4; i++) {
                    nuke[i-1] = Integer.parseInt(args[i]);
                }
                server.addScheduledNuke(nuke);
                server.sendServerChat(connId, "A nuke is incoming!  Take cover!");
            } catch (Exception e) {
                server.sendServerChat(connId, "Nuke command failed (1).  Proper format is \"/nuke <x> <y> <type>\" or \"/nuke <x> <y> <damage> <degredation> <secondary radius> <craterdepth>\"");
            }
        } else if (args.length == 7) {
            // Check command type 2.
            try {
                int[] nuke = new int[6];
                for (int i = 1; i < 7; i++) {
                    nuke[i-1] = Integer.parseInt(args[i]);
                }
                server.addScheduledNuke(nuke);
                server.sendServerChat(connId, "A nuke is incoming!  Take cover!");
            } catch (Exception e) {
                server.sendServerChat(connId, "Nuke command failed (2).  Proper format is \"/nuke <x> <y> <type>\" or \"/nuke <x> <y> <damage> <degredation> <secondary radius> <craterdepth>\"");
            }
        } else {
            // Error out; it's not a valid call.
            server.sendServerChat(connId, "Nuke command failed (3).  Proper format is \"/nuke <x> <y> <type>\" or \"/nuke <x> <y> <damage> <degredation> <secondary radius> <craterdepth>\"");
        }
    }
}
