/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import com.sun.j3d.utils.pickfast.PickCanvas;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PickInfo;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Color3f;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import megamek.client.event.BoardViewEvent;
import megamek.client.event.BoardViewListener;
import megamek.client.event.MechDisplayEvent;
import megamek.client.event.MechDisplayListener;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.IBoardView;
import megamek.client.ui.AWT.TilesetManager;
import megamek.client.ui.AWT.boardview3d.AttackGroup;
import megamek.client.ui.AWT.boardview3d.BoardModel;
import megamek.client.ui.AWT.boardview3d.C;
import megamek.client.ui.AWT.boardview3d.ConnectionModel;
import megamek.client.ui.AWT.boardview3d.CursorModel;
import megamek.client.ui.AWT.boardview3d.EntityGroup;
import megamek.client.ui.AWT.boardview3d.HoverInfo;
import megamek.client.ui.AWT.boardview3d.MoveGroup;
import megamek.client.ui.AWT.boardview3d.TileTextureManager;
import megamek.client.ui.AWT.boardview3d.ViewTransform;
import megamek.client.ui.IDisplayable;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.MovePath;
import megamek.common.Player;
import megamek.common.UnitLocation;
import megamek.common.actions.AttackAction;
import megamek.common.event.BoardEvent;
import megamek.common.event.BoardListener;
import megamek.common.event.GameBoardChangeEvent;
import megamek.common.event.GameBoardNewEvent;
import megamek.common.event.GameEndEvent;
import megamek.common.event.GameEntityChangeEvent;
import megamek.common.event.GameEntityNewEvent;
import megamek.common.event.GameEntityNewOffboardEvent;
import megamek.common.event.GameEntityRemoveEvent;
import megamek.common.event.GameListener;
import megamek.common.event.GameMapQueryEvent;
import megamek.common.event.GameNewActionEvent;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GamePlayerChangeEvent;
import megamek.common.event.GamePlayerChatEvent;
import megamek.common.event.GamePlayerConnectedEvent;
import megamek.common.event.GamePlayerDisconnectedEvent;
import megamek.common.event.GameReportEvent;
import megamek.common.event.GameSettingsChangeEvent;
import megamek.common.event.GameTurnChangeEvent;
import megamek.common.preference.IPreferenceChangeListener;
import megamek.common.preference.PreferenceChangeEvent;
import megamek.common.preference.PreferenceManager;

public class BoardView3D
extends Canvas3D
implements IBoardView,
megamek.client.ui.swing.IBoardView,
BoardListener,
MouseListener,
MouseMotionListener,
MechDisplayListener,
IPreferenceChangeListener,
GameListener {
    static final long serialVersionUID = 475073852535962574L;
    private SimpleUniverse universe;
    private BoardModel board;
    private AttackGroup attacks;
    private EntityGroup entities;
    private BranchGroup cursors;
    private MoveGroup moves;
    private CursorModel cursor;
    private CursorModel selectCursor;
    private CursorModel highlightCursor;
    private CursorModel firstLOSCursor;
    private CursorModel secondLOSCursor;
    private ViewTransform currentView;
    private HoverInfo hoverInfo;
    private Vector<IDisplayable> displayables = new Vector();
    private BufferedImage bi1;
    private BufferedImage bi2;
    private PickCanvas pickBoard;
    private PickCanvas pickEntities;
    boolean dragged;
    private Coords lastCursor;
    private Coords selected;
    private Coords firstLOS;
    private ConnectionModel ruler;
    private static final Color3f LOS_COLOR = C.red;
    private IGame game;
    private TileTextureManager tileManager;
    private Player localPlayer;
    private Vector<BoardViewListener> boardListeners = new Vector();

    public BoardView3D(IGame iGame) throws IOException {
        super(SimpleUniverse.getPreferredConfiguration());
        this.game = iGame;
        this.universe = new SimpleUniverse((Canvas3D)this, 7);
        ViewingPlatform viewingPlatform = this.universe.getViewingPlatform();
        viewingPlatform.setNominalViewingTransform();
        View view = this.universe.getViewer().getView();
        view.setMinimumFrameCycleTime(40L);
        view.setSceneAntialiasingEnable(false);
        view.setBackClipDistance(30000.0);
        view.setBackClipPolicy(2);
        view.setFrontClipDistance(10.0);
        view.setFrontClipPolicy(2);
        view.setTransparencySortingPolicy(1);
        this.tileManager = new TileTextureManager((Component)((Object)this), iGame);
        this.cursors = new BranchGroup();
        this.cursors.setPickable(false);
        this.cursor = new CursorModel(C.cyan);
        this.cursors.addChild((Node)this.cursor);
        this.highlightCursor = new CursorModel(C.white);
        this.cursors.addChild((Node)this.highlightCursor);
        this.selectCursor = new CursorModel(C.blue);
        this.cursors.addChild((Node)this.selectCursor);
        this.firstLOSCursor = new CursorModel(LOS_COLOR);
        this.cursors.addChild((Node)this.firstLOSCursor);
        this.secondLOSCursor = new CursorModel(LOS_COLOR);
        this.cursors.addChild((Node)this.secondLOSCursor);
        this.cursors.setCapability(13);
        this.cursors.setCapability(14);
        this.cursors.compile();
        this.universe.addBranchGraph(this.cursors);
        this.attacks = new AttackGroup(iGame, this.tileManager, this.currentView);
        this.universe.addBranchGraph((BranchGroup)this.attacks);
        this.entities = new EntityGroup(iGame, this.tileManager, this.currentView);
        this.universe.addBranchGraph((BranchGroup)this.entities);
        this.board = new BoardModel(this.tileManager, this.universe, iGame);
        this.universe.addBranchGraph((BranchGroup)this.board);
        this.moves = new MoveGroup(iGame, this.currentView);
        this.universe.addBranchGraph((BranchGroup)this.moves);
        this.pickBoard = new PickCanvas((Canvas3D)this, (BranchGroup)this.board);
        this.pickBoard.setMode(1);
        this.pickBoard.setTolerance(0.0f);
        this.pickBoard.setFlags(6);
        this.pickEntities = new PickCanvas((Canvas3D)this, (BranchGroup)this.entities);
        this.pickEntities.setMode(1);
        this.pickEntities.setTolerance(0.0f);
        this.pickEntities.setFlags(6);
        this.bi1 = new BufferedImage(1, 1, 6);
        this.bi2 = new BufferedImage(1, 1, 6);
        this.hoverInfo = new HoverInfo(iGame, this);
        this.addDisplayable(this.hoverInfo);
        this.setView(Integer.parseInt(System.getProperty("megamek.client.ui.AWT.boardview3d.view", "0")));
        iGame.addGameListener(this);
        iGame.getBoard().addBoardListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        PreferenceManager.getClientPreferences().addPreferenceChangeListener(this);
        this.setBackground(Color.DARK_GRAY);
    }

    String setView(int n) {
        if (this.currentView != null) {
            this.currentView.remove();
        }
        this.currentView = ViewTransform.create(n, this.universe);
        this.entities.setView(this.currentView);
        this.moves.setView(this.currentView);
        this.attacks.setView(this.currentView);
        return this.currentView.getName();
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getName().equals("MapTileset")) {
            this.updateBoard();
        } else {
            this.entities.update();
        }
    }

    public void addBoardViewListener(BoardViewListener boardViewListener) {
        if (!this.boardListeners.contains(boardViewListener)) {
            this.boardListeners.addElement(boardViewListener);
        }
    }

    public void removeBoardViewListener(BoardViewListener boardViewListener) {
        this.boardListeners.removeElement(boardViewListener);
    }

    public void processBoardViewEvent(BoardViewEvent boardViewEvent) {
        if (this.boardListeners == null) {
            return;
        }
        Enumeration<BoardViewListener> enumeration = this.boardListeners.elements();
        while (enumeration.hasMoreElements()) {
            BoardViewListener boardViewListener = enumeration.nextElement();
            switch (boardViewEvent.getType()) {
                case 0: 
                case 1: 
                case 2: 
                case 10: {
                    boardViewListener.hexMoused(boardViewEvent);
                    break;
                }
                case 3: {
                    boardViewListener.hexCursor(boardViewEvent);
                    break;
                }
                case 4: {
                    boardViewListener.boardHexHighlighted(boardViewEvent);
                    break;
                }
                case 5: {
                    boardViewListener.hexSelected(boardViewEvent);
                    break;
                }
                case 6: {
                    boardViewListener.firstLOSHex(boardViewEvent);
                    break;
                }
                case 7: {
                    boardViewListener.secondLOSHex(boardViewEvent, this.firstLOS);
                    break;
                }
                case 8: {
                    boardViewListener.finishedMovingUnits(boardViewEvent);
                    break;
                }
                case 9: {
                    boardViewListener.unitSelected(boardViewEvent);
                }
            }
        }
    }

    public void addDisplayable(IDisplayable iDisplayable) {
        this.displayables.addElement(iDisplayable);
        this.repaint();
    }

    public void postRender() {
        try {
            this.getGraphics2D().drawAndFlushImage(this.bi1, 0, 0, null);
            this.getGraphics2D().drawAndFlushImage(this.bi2, this.getWidth() - this.bi2.getWidth(), 0, null);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void showPopup(PopupMenu popupMenu, Coords coords) {
        Object object;
        if (popupMenu.getParent() == null) {
            this.add(popupMenu);
        }
        IHex iHex = this.game.getBoard().getHex(coords);
        int n = 0;
        try {
            n = iHex.getElevation();
            object = this.game.getEntities(coords).nextElement();
            n += ((Entity)object).getElevation();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new Transform3D();
        this.getVworldToImagePlate((Transform3D)object);
        Point3d point3d = BoardModel.getHexLocation(coords, n);
        object.transform(point3d);
        Point2d point2d = new Point2d();
        this.getPixelLocationFromImagePlate(point3d, point2d);
        popupMenu.show((Component)((Object)this), (int)point2d.x, (int)point2d.y);
    }

    private Object pickSomething(MouseEvent mouseEvent) {
        try {
            Node node;
            if (this.pickEntities == null || this.pickBoard == null) {
                return null;
            }
            this.pickEntities.setShapeLocation(mouseEvent);
            PickInfo pickInfo = this.pickEntities.pickClosest();
            if (pickInfo == null) {
                this.pickBoard.setShapeLocation(mouseEvent);
                pickInfo = this.pickBoard.pickClosest();
            }
            if (pickInfo == null) {
                return null;
            }
            for (node = pickInfo.getNode(); node != null && node.getUserData() == null; node = node.getParent()) {
            }
            if (node == null) {
                return null;
            }
            return node.getUserData();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    private Coords pickCoords(MouseEvent mouseEvent) {
        Object object = this.pickSomething(mouseEvent);
        if (object instanceof Coords) {
            return (Coords)object;
        }
        if (object instanceof Entity) {
            return ((Entity)object).getPosition();
        }
        return null;
    }

    public void hideTooltip() {
    }

    public boolean isMovingUnits() {
        return this.entities.isMoving();
    }

    public void redrawEntity(Entity entity) {
        this.entities.update(entity);
    }

    public void centerOnHex(Coords coords) {
        if (coords == null || this.currentView == null || !this.game.getBoard().contains(coords)) {
            return;
        }
        this.currentView.centerOnHex(coords, this.game.getBoard().getHex(coords));
    }

    public void drawMovementData(Entity entity, MovePath movePath) {
        this.moves.set(movePath);
    }

    public void clearMovementData() {
        this.moves.clear();
    }

    public void setLocalPlayer(Player player) {
        this.localPlayer = player;
        this.hoverInfo.setSelected(null, null, player);
        this.refreshDisplayables();
    }

    public Player getLocalPlayer() {
        return this.localPlayer;
    }

    public void markDeploymentHexesFor(Player player) {
        this.board.showDeployment(player);
    }

    public void addAttack(AttackAction attackAction) {
        this.attacks.add(attackAction);
        this.hoverInfo.add(attackAction);
        this.refreshDisplayables();
    }

    public void removeAttacksFor(Entity entity) {
        this.attacks.remove(entity);
        this.hoverInfo.remove(entity);
        this.refreshDisplayables();
    }

    public void refreshAttacks() {
        this.attacks.update();
        this.hoverInfo.update();
        this.refreshDisplayables();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Coords coords = this.pickCoords(mouseEvent);
        if (coords == null) {
            return;
        }
        this.dragged = false;
        if (mouseEvent.isPopupTrigger() && !mouseEvent.isControlDown()) {
            this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 10, mouseEvent.getModifiers()));
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Coords coords = this.pickCoords(mouseEvent);
        if (coords == null) {
            return;
        }
        if (mouseEvent.isPopupTrigger() && !mouseEvent.isControlDown() && !this.dragged) {
            this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 10, mouseEvent.getModifiers()));
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        for (int i = 0; i < this.displayables.size(); ++i) {
            IDisplayable iDisplayable = this.displayables.elementAt(i);
            if (!iDisplayable.isHit(mouseEvent.getPoint(), this.getSize())) continue;
            iDisplayable.isReleased();
            return;
        }
        Coords coords = this.pickCoords(mouseEvent);
        if (coords == null) {
            return;
        }
        if (mouseEvent.isPopupTrigger() && !mouseEvent.isControlDown()) {
            this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 10, mouseEvent.getModifiers()));
        } else if (mouseEvent.getClickCount() == 1 && mouseEvent.isControlDown()) {
            if (coords.equals(this.hoverInfo.getLOS())) {
                this.firstLOSCursor.hide();
                this.hoverInfo.setLOS(null);
            } else {
                this.firstLOSCursor.move(coords, this.game.getBoard().getHex(coords));
                this.firstLOSCursor.setColor(LOS_COLOR);
                this.hoverInfo.setLOS(coords);
            }
            this.secondLOSCursor.hide();
            this.hoverInfo.setPosition(coords);
            this.refreshDisplayables();
        } else if (mouseEvent.getClickCount() == 1) {
            this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 2, mouseEvent.getModifiers()));
            this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 0, mouseEvent.getModifiers()));
        } else {
            this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 1, mouseEvent.getModifiers()));
        }
    }

    public void drawRuler(Coords coords, Coords coords2, Color color, Color color2) {
        if (this.ruler != null) {
            this.ruler.detach();
        }
        this.ruler = null;
        this.firstLOSCursor.hide();
        this.secondLOSCursor.hide();
        if (coords == null) {
            return;
        }
        IBoard iBoard = this.game.getBoard();
        IHex iHex = iBoard.getHex(coords);
        this.firstLOSCursor.move(coords, iHex);
        this.firstLOSCursor.setColor(new Color3f(color));
        if (coords2 == null) {
            return;
        }
        IHex iHex2 = iBoard.getHex(coords2);
        this.ruler = new ConnectionModel(coords, coords2, iHex.surface() + 1, iHex2.surface() + 1, null, new Color3f(color2), 0.5f);
        this.secondLOSCursor.move(coords2, iHex2);
        this.secondLOSCursor.setColor(new Color3f(color2));
        this.cursors.addChild((Node)this.ruler);
    }

    public Coords getLastCursor() {
        return this.lastCursor;
    }

    public Coords getSelected() {
        return this.selected;
    }

    public void setFirstLOS(Coords coords) {
        this.firstLOS = coords;
    }

    public void select(Coords coords) {
        if (coords != null && !this.game.getBoard().contains(coords)) {
            return;
        }
        this.selected = coords;
        this.selectCursor.move(coords, this.game.getBoard().getHex(coords));
        this.firstLOSCursor.hide();
        this.secondLOSCursor.hide();
        this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 5, 0));
    }

    public void highlight(Coords coords) {
        if (coords != null && !this.game.getBoard().contains(coords)) {
            return;
        }
        this.highlightCursor.move(coords, this.game.getBoard().getHex(coords));
        this.firstLOSCursor.hide();
        this.secondLOSCursor.hide();
        this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 4, 0));
    }

    public void cursor(Coords coords) {
        if (coords != null && !this.game.getBoard().contains(coords)) {
            return;
        }
        if (this.lastCursor == null || coords == null || !coords.equals(this.lastCursor)) {
            this.lastCursor = coords;
            this.cursor.move(coords, this.game.getBoard().getHex(coords));
            this.firstLOSCursor.hide();
            this.secondLOSCursor.hide();
            this.processBoardViewEvent(new BoardViewEvent(this, coords, null, 3, 0));
        } else {
            this.lastCursor = coords;
        }
    }

    public void checkLOS(Coords coords) {
        if (coords != null && !this.game.getBoard().contains(coords)) {
            return;
        }
        if (this.hoverInfo.getLOS() == null) {
            this.hoverInfo.setLOS(coords);
            this.firstLOSCursor.move(coords, this.game.getBoard().getHex(coords));
            this.firstLOSCursor.setColor(LOS_COLOR);
            this.secondLOSCursor.hide();
        } else {
            this.secondLOSCursor.move(coords, this.game.getBoard().getHex(coords));
            this.secondLOSCursor.setColor(LOS_COLOR);
            this.hoverInfo.setPosition(coords);
            this.refreshDisplayables();
        }
    }

    public void boardNewBoard(BoardEvent boardEvent) {
        this.updateBoard();
    }

    public void boardChangedHex(BoardEvent boardEvent) {
        IHex iHex = this.game.getBoard().getHex(boardEvent.getCoords());
        this.tileManager.hexChanged(iHex);
        this.board.update(boardEvent.getCoords(), iHex, this.localPlayer);
    }

    public void gameEntityNew(GameEntityNewEvent gameEntityNewEvent) {
        for (Entity entity : gameEntityNewEvent.GetEntities()) {
            this.redrawEntity(entity);
        }
        this.refreshDisplayables();
    }

    public void gameEntityRemove(GameEntityRemoveEvent gameEntityRemoveEvent) {
        this.entities.remove(gameEntityRemoveEvent.getEntity());
        this.refreshDisplayables();
    }

    public void gameEntityChange(GameEntityChangeEvent gameEntityChangeEvent) {
        Vector<UnitLocation> vector = gameEntityChangeEvent.getMovePath();
        if (vector != null && vector.size() > 0 && GUIPreferences.getInstance().getShowMoveStep()) {
            this.entities.move(gameEntityChangeEvent.getEntity(), vector);
        } else {
            this.entities.update(gameEntityChangeEvent.getEntity());
        }
        this.refreshDisplayables();
    }

    public void gameNewAction(GameNewActionEvent gameNewActionEvent) {
    }

    public void gameBoardNew(GameBoardNewEvent gameBoardNewEvent) {
        IBoard iBoard = gameBoardNewEvent.getOldBoard();
        if (iBoard != null) {
            iBoard.removeBoardListener(this);
        }
        if ((iBoard = gameBoardNewEvent.getNewBoard()) != null) {
            iBoard.addBoardListener(this);
        }
        this.updateBoard();
        if (iBoard != null) {
            this.centerOnHex(new Coords(0, 0));
        }
    }

    public void gameBoardChanged(GameBoardChangeEvent gameBoardChangeEvent) {
        this.updateBoard();
    }

    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        this.refreshAttacks();
        switch (gamePhaseChangeEvent.getNewPhase()) {
            case PHASE_MOVEMENT: 
            case PHASE_FIRING: 
            case PHASE_PHYSICAL: {
                this.refreshAttacks();
                break;
            }
            case PHASE_INITIATIVE: {
                this.attacks.clear();
                this.hoverInfo.clear();
                break;
            }
            case PHASE_END: 
            case PHASE_VICTORY: {
                this.attacks.clear();
                this.hoverInfo.clear();
                this.clearMovementData();
            }
        }
        this.refreshDisplayables();
    }

    private void updateBoard() {
        this.board.update(this.localPlayer);
        this.entities.update();
        this.refreshDisplayables();
    }

    public void WeaponSelected(MechDisplayEvent mechDisplayEvent) {
        this.attacks.setSelected(mechDisplayEvent.getEntity(), mechDisplayEvent.getEquip(), this.localPlayer);
        this.hoverInfo.setSelected(mechDisplayEvent.getEntity(), mechDisplayEvent.getEquip(), this.localPlayer);
        this.refreshDisplayables();
    }

    public void zoomIn() {
        this.currentView.zoom(1);
    }

    public void zoomOut() {
        this.currentView.zoom(-1);
    }

    public Component getComponent() {
        return this;
    }

    public TilesetManager getTilesetManager() {
        return this.tileManager.getTilesetManager();
    }

    public void refreshMinefields() {
        this.updateBoard();
    }

    public void refreshDisplayables() {
        Dimension dimension = this.getSize();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        if (dimension.width > 2048) {
            dimension.width = 2048;
        }
        if (dimension.height > 1024) {
            dimension.height = 1024;
        }
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 6);
        Graphics graphics = bufferedImage.getGraphics();
        for (int i = 0; i < this.displayables.size(); ++i) {
            this.displayables.elementAt(i).draw(graphics, dimension);
        }
        BufferedImage bufferedImage2 = new BufferedImage(dimension.width / 2, dimension.height, 6);
        bufferedImage2.getGraphics().drawImage(bufferedImage, 0, 0, null);
        BufferedImage bufferedImage3 = new BufferedImage(dimension.width / 2, dimension.height, 6);
        bufferedImage3.getGraphics().drawImage(bufferedImage, -dimension.width / 2, 0, null);
        this.bi1 = bufferedImage2;
        this.bi2 = bufferedImage3;
    }

    public void gamePlayerConnected(GamePlayerConnectedEvent gamePlayerConnectedEvent) {
    }

    public void gamePlayerDisconnected(GamePlayerDisconnectedEvent gamePlayerDisconnectedEvent) {
    }

    public void gamePlayerChange(GamePlayerChangeEvent gamePlayerChangeEvent) {
    }

    public void gamePlayerChat(GamePlayerChatEvent gamePlayerChatEvent) {
    }

    public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
    }

    public void gameReport(GameReportEvent gameReportEvent) {
    }

    public void gameEnd(GameEndEvent gameEndEvent) {
    }

    public void gameSettingsChange(GameSettingsChangeEvent gameSettingsChangeEvent) {
    }

    public void gameMapQuery(GameMapQueryEvent gameMapQueryEvent) {
    }

    public void gameEntityNewOffboard(GameEntityNewOffboardEvent gameEntityNewOffboardEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.dragged = true;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Coords coords = this.pickCoords(mouseEvent);
        if (coords == null ? coords != this.hoverInfo.coords : !coords.equals(this.hoverInfo.coords)) {
            if (this.hoverInfo.getLOS() != null) {
                this.secondLOSCursor.move(coords, this.game.getBoard().getHex(coords));
                this.secondLOSCursor.setColor(LOS_COLOR);
            }
            this.hoverInfo.setPosition(coords);
            this.refreshDisplayables();
        }
    }

    static {
        System.setProperty("j3d.implicitAntialiasing", "true");
    }
}

