/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Vector;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImageModel
extends Shape3D {
    private static final int UP = 0;
    private static final int RIGHT = 1;
    private static final int DOWN = 2;
    private static final int LEFT = 3;
    private static final int ALPHA_THRESHOLD = 128;
    private static final double MODEL_SIZE_CORRECTION = 1.5;
    private static final int[][] next = new int[][]{{0, -1}, {1, 0}, {0, 1}, {-1, 0}};
    private static final int RUP = 1;
    private static final int RDOWN = 2;
    private static final byte[] remove = new byte[]{1, 0, 2, 0};

    public ImageModel(BufferedImage bufferedImage, boolean bl) {
        GeometryArray[] geometryArrayArray;
        for (GeometryArray geometryArray : geometryArrayArray = ImageModel.tracePixels(bufferedImage, bl)) {
            this.addGeometry((Geometry)geometryArray);
        }
        double d = 0.5;
        if (bl) {
            d *= 1.5;
        }
        this.setBounds((Bounds)new BoundingBox(new Point3d(-d, -d, -d), new Point3d(d, d, d)));
    }

    private static final GeometryArray[] tracePixels(BufferedImage bufferedImage, boolean bl) {
        int[] nArray;
        int n;
        Vector vector;
        int n2;
        int[] nArray2;
        Vector vector2;
        Object object;
        Object object2;
        int n3;
        WritableRaster writableRaster = bufferedImage.getAlphaRaster();
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        int[] nArray3 = new int[n4 * n5];
        writableRaster.getPixels(0, 0, n4, n5, nArray3);
        boolean[][][] blArray = new boolean[n5 + 1][n4 + 1][4];
        boolean[] blArray2 = new boolean[4];
        for (int i = 0; i <= n5; ++i) {
            for (int j = 0; j <= n4; ++j) {
                blArray2[0] = j > 0 && i > 0 && nArray3[(i - 1) * n4 + (j - 1)] > 128;
                blArray2[1] = j < n4 && i > 0 && nArray3[(i - 1) * n4 + j] > 128;
                blArray2[2] = j > 0 && i < n5 && nArray3[i * n4 + (j - 1)] > 128;
                blArray2[3] = j < n4 && i < n5 && nArray3[i * n4 + j] > 128;
                blArray[i][j][0] = !blArray2[0] && blArray2[1];
                blArray[i][j][1] = blArray2[3] && !blArray2[1];
                blArray[i][j][2] = !blArray2[3] && blArray2[2];
                blArray[i][j][3] = blArray2[0] && !blArray2[2];
            }
        }
        Vector<Object> vector3 = new Vector<Object>();
        Vector<Integer> vector4 = new Vector<Integer>();
        int n6 = 0;
        for (int i = 0; i <= n5; ++i) {
            for (n3 = 0; n3 <= n4; ++n3) {
                if (!blArray[i][n3][0]) continue;
                int n7 = 1;
                byte[][] byArray = new byte[n5 + 1][n4 + 1];
                object2 = ImageModel.getContour(blArray, n3, i, 0, byArray);
                ImageModel.simplify((Vector<int[]>)object2);
                while (true) {
                    Vector<int[]> vector5 = ImageModel.getInterior(blArray, n3, i, byArray);
                    object = vector5;
                    if (vector5 == null) break;
                    ImageModel.simplify((Vector<int[]>)object);
                    n6 += object.size();
                    vector3.add(object);
                    ++n7;
                }
                n6 += object2.size();
                vector3.add(object2);
                vector4.add(new Integer(n7));
            }
        }
        GeometryArray[] geometryArrayArray = new GeometryArray[3];
        n3 = vector3.size();
        object2 = new int[n3];
        object = new double[n6 * 3 * 2];
        float[] fArray = new float[n6 * 2 * 2];
        double d = n4 * 2;
        double d2 = n5 * 2;
        double d3 = 0.5;
        if (bl) {
            d /= 1.5;
            d2 /= 1.5;
            d3 *= 1.5;
        }
        float f = n4 * 2;
        float f2 = n5 * 2;
        int n8 = 0;
        int n9 = 0;
        for (int i = 0; i < n3; ++i) {
            vector2 = (Vector)vector3.elementAt(i);
            object2[i] = vector2.size() * 2;
            for (int j = 0; j < object2[i] / 2; ++j) {
                nArray2 = (int[])vector2.elementAt(j);
                object[n8++] = (double)nArray2[0] / d - d3;
                object[n8++] = (double)(-nArray2[1]) / d2 + d3;
                object[n8++] = -0.5;
                object[n8++] = (double)nArray2[0] / d - d3;
                object[n8++] = (double)(-nArray2[1]) / d2 + d3;
                object[n8++] = 0.5;
                fArray[n9++] = (float)nArray2[0] / f;
                fArray[n9++] = 1.0f - (float)nArray2[1] / f2;
                fArray[n9++] = (float)nArray2[0] / f;
                fArray[n9++] = 1.0f - (float)nArray2[1] / f2;
            }
        }
        GeometryInfo geometryInfo = new GeometryInfo(4);
        geometryInfo.setCoordinates(object);
        geometryInfo.setStripCounts(object2);
        geometryInfo.setTextureCoordinateParams(1, 2);
        geometryInfo.setTextureCoordinates(0, fArray);
        vector2 = new NormalGenerator();
        vector2.generateNormals(geometryInfo);
        Stripifier stripifier = new Stripifier();
        stripifier.stripify(geometryInfo);
        geometryArrayArray[0] = geometryInfo.getGeometryArray();
        nArray2 = new int[vector4.size()];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = (Integer)vector4.elementAt(i);
        }
        object2 = new int[n3];
        object = new double[n6 * 3];
        fArray = new float[n6 * 2];
        float[] fArray2 = new float[n6 * 3];
        n8 = 0;
        n9 = 0;
        int n10 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            vector = (Vector)vector3.elementAt(n2);
            object2[n2] = vector.size();
            for (n = object2[n2] - 1; n >= 0; --n) {
                nArray = (int[])vector.elementAt(n);
                object[n8++] = (double)nArray[0] / d - d3;
                object[n8++] = (double)(-nArray[1]) / d2 + d3;
                object[n8++] = 0.5;
                fArray2[n10++] = 0.0f;
                fArray2[n10++] = 0.0f;
                fArray2[n10++] = 1.0f;
                fArray[n9++] = (float)nArray[0] / f;
                fArray[n9++] = 1.0f - (float)nArray[1] / f2;
            }
        }
        geometryInfo = new GeometryInfo(5);
        geometryInfo.setCoordinates(object);
        geometryInfo.setNormals(fArray2);
        geometryInfo.setContourCounts(nArray2);
        geometryInfo.setStripCounts(object2);
        geometryInfo.setTextureCoordinateParams(1, 2);
        geometryInfo.setTextureCoordinates(0, fArray);
        stripifier.stripify(geometryInfo);
        geometryArrayArray[1] = geometryInfo.getIndexedGeometryArray(false);
        n10 = 0;
        n9 = 0;
        n8 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            vector = (Vector)vector3.elementAt(n2);
            object2[n2] = vector.size();
            for (n = 0; n < object2[n2]; ++n) {
                nArray = (int[])vector.elementAt(n);
                object[n8++] = (double)nArray[0] / d - d3;
                object[n8++] = (double)(-nArray[1]) / d2 + d3;
                object[n8++] = -0.5;
                fArray2[n10++] = 0.0f;
                fArray2[n10++] = 0.0f;
                fArray2[n10++] = -1.0f;
                fArray[n9++] = (float)nArray[0] / f;
                fArray[n9++] = 1.0f - (float)nArray[1] / f2;
            }
        }
        geometryInfo = new GeometryInfo(5);
        geometryInfo.setCoordinates(object);
        geometryInfo.setNormals(fArray2);
        geometryInfo.setContourCounts(nArray2);
        geometryInfo.setStripCounts(object2);
        geometryInfo.setTextureCoordinateParams(1, 2);
        geometryInfo.setTextureCoordinates(0, fArray);
        stripifier.stripify(geometryInfo);
        geometryArrayArray[2] = geometryInfo.getIndexedGeometryArray(false);
        return geometryArrayArray;
    }

    private static final void simplify(Vector<int[]> vector) {
        vector.removeElementAt(0);
        int[] nArray = vector.elementAt(vector.size() - 2);
        int[] nArray2 = vector.elementAt(vector.size() - 1);
        int n = nArray2[0] - nArray[0];
        int n2 = nArray2[1] - nArray[1];
        int n3 = 0;
        while (n3 < vector.size()) {
            nArray = nArray2;
            nArray2 = vector.elementAt(n3);
            int n4 = nArray2[0] - nArray[0];
            int n5 = nArray2[1] - nArray[1];
            if (n == n4 && n2 == n5) {
                vector.removeElementAt(n3 > 0 ? n3 - 1 : vector.size() - 1);
            } else {
                ++n3;
            }
            n = n4;
            n2 = n5;
        }
        vector.add(vector.elementAt(0));
    }

    private static final Vector<int[]> getContour(boolean[][][] blArray, int n, int n2, int n3, byte[][] byArray) {
        int n4;
        Vector<int[]> vector = new Vector<int[]>();
        int n5 = n3;
        int n6 = n;
        int n7 = n2;
        int n8 = n - next[n5][0];
        for (n4 = n2 - next[n5][1]; n8 >= 0 && n4 >= 0 && n4 < blArray.length && n8 < blArray[n4].length && blArray[n4][n8][n5]; n8 -= next[n5][0], n4 -= next[n5][1]) {
            n = n8;
            n2 = n4;
        }
        int n9 = n5 - 1 & 3;
        n8 = n + next[n9][0];
        n4 = n2 + next[n9][1];
        if (n8 >= 0 && n4 >= 0 && n4 < blArray.length && n8 < blArray[n4].length && blArray[n4][n8][n5 + 1 & 3]) {
            if ((n8 -= next[n5][0]) >= 0 && (n4 -= next[n5][1]) >= 0 && n4 < blArray.length && n8 < blArray[n4].length && blArray[n4][n8][n5]) {
                n += next[n9][0];
                n2 += next[n9][1];
            } else {
                n5 = n9;
            }
        } else {
            n5 = n9;
        }
        vector.add(new int[]{2 * n, 2 * n2});
        while (true) {
            int n10 = 0;
            boolean bl = false;
            int[] nArray = new int[]{0, 0};
            if (blArray[n2][n][n5 + 1 & 3]) {
                n5 = n5 + 1 & 3;
            } else {
                if (!blArray[n2][n][n9]) break;
                n5 = n9;
            }
            n9 = n5 - 1 & 3;
            while (blArray[n2][n][n5]) {
                blArray[n2][n][n5] = false;
                if (byArray != null) {
                    byte[] byArray2 = byArray[n2];
                    int n11 = n;
                    byArray2[n11] = (byte)(byArray2[n11] | remove[n5]);
                }
                n += next[n5][0];
                n2 += next[n5][1];
                ++n10;
            }
            if (n10 == 1 && blArray[n2][n][n9]) {
                bl = true;
                n5 = n9;
                n9 = n5 - 1 & 3;
                int[] nArray2 = vector.lastElement();
                nArray2[0] = nArray2[0] - next[n5][0];
                int[] nArray3 = vector.lastElement();
                nArray3[1] = nArray3[1] - next[n5][1];
                n10 = 0;
                while (blArray[n2][n][n5]) {
                    blArray[n2][n][n5] = false;
                    if (byArray != null) {
                        byte[] byArray3 = byArray[n2];
                        int n12 = n;
                        byArray3[n12] = (byte)(byArray3[n12] | remove[n5]);
                    }
                    n += next[n5][0];
                    n2 += next[n5][1];
                    ++n10;
                }
            }
            if (blArray[n2][n][n9] && !blArray[n4 = n2 + next[n9][1]][n8 = n + next[n9][0]][n9] && !blArray[n4][n8][n9 - 1 & 3] && (blArray[n4][n8][n5] || n3 == n5)) {
                if (bl) {
                    vector.add(new int[]{2 * n - n10 * next[n5][0], 2 * n2 - n10 * next[n5][1]});
                }
                blArray[n2][n][n9] = false;
                if (byArray != null) {
                    byte[] byArray4 = byArray[n2];
                    int n13 = n;
                    byArray4[n13] = (byte)(byArray4[n13] | remove[n9]);
                }
                n = n8;
                n2 = n4;
                nArray = next[n5];
                n5 = n9;
            }
            vector.add(new int[]{2 * n + nArray[0], 2 * n2 + nArray[1]});
        }
        return vector;
    }

    private static final Vector<int[]> getInterior(boolean[][][] blArray, int n, int n2, byte[][] byArray) {
        int n3 = 0;
        while (n2 < byArray.length) {
            while (n < byArray[n2].length) {
                if (n3 == 1 && blArray[n2 - 1][n][2]) {
                    return ImageModel.getContour(blArray, n, n2 - 1, 2, null);
                }
                if (n3 > 0) {
                    if (blArray[n2][n][0]) {
                        ++n3;
                    } else if (blArray[n2 - 1][n][2]) {
                        --n3;
                    }
                }
                if ((byArray[n2][n] & 1) == 1) {
                    n3 = 1;
                } else if ((byArray[n2 - 1][n] & 2) == 2) {
                    n3 = 0;
                }
                ++n;
            }
            n = 0;
            ++n2;
        }
        return null;
    }
}

