/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.boardview3d;

import com.sun.j3d.utils.universe.MultiTransformGroup;
import com.sun.j3d.utils.universe.SimpleUniverse;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import megamek.client.ui.AWT.boardview3d.MapViewTransform;
import megamek.client.ui.AWT.boardview3d.PlayerViewTransform;
import megamek.common.Coords;
import megamek.common.IHex;

abstract class ViewTransform {
    static final int MAX_TRANSFORMS = 7;
    protected SimpleUniverse universe;
    protected BranchGroup controllers;
    private static final Transform3D identity = new Transform3D();
    private static final Class[] transforms = new Class[]{PlayerViewTransform.class, MapViewTransform.class};

    ViewTransform() {
    }

    abstract String getName();

    abstract void reset();

    abstract void centerOnHex(Coords var1, IHex var2);

    abstract Node makeViewRelative(Node var1, double var2);

    abstract void zoom(int var1);

    void remove() {
        if (this.controllers != null) {
            this.controllers.detach();
        }
    }

    static ViewTransform create(int n, SimpleUniverse simpleUniverse) {
        try {
            ViewTransform viewTransform = (ViewTransform)transforms[n].getConstructor(new Class[0]).newInstance(new Object[0]);
            viewTransform.universe = simpleUniverse;
            viewTransform.controllers = new BranchGroup();
            viewTransform.controllers.setCapability(17);
            MultiTransformGroup multiTransformGroup = simpleUniverse.getViewingPlatform().getMultiTransformGroup();
            for (int i = 0; i < multiTransformGroup.getNumTransforms(); ++i) {
                multiTransformGroup.getTransformGroup(i).setTransform(identity);
            }
            viewTransform.setup();
            viewTransform.controllers.compile();
            simpleUniverse.addBranchGraph(viewTransform.controllers);
            return viewTransform;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    protected abstract void setup();
}

