/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Polygon;
import java.util.Vector;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.DisplayMapSet;
import megamek.client.ui.AWT.widget.PMAreasGroup;
import megamek.client.ui.AWT.widget.PMSimpleLabel;
import megamek.client.ui.AWT.widget.PMSimplePolygonArea;
import megamek.client.ui.AWT.widget.PMUtil;
import megamek.client.ui.AWT.widget.PMValueLabel;
import megamek.client.ui.AWT.widget.WidgetUtils;
import megamek.common.Entity;
import megamek.common.LargeSupportTank;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LargeSupportTankMapSet
implements DisplayMapSet {
    private static final String IMAGE_DIR = "data/images/widgets";
    private Component comp;
    private PMSimplePolygonArea[] areas = new PMSimplePolygonArea[14];
    private PMSimpleLabel[] labels = new PMSimpleLabel[15];
    private PMValueLabel[] vLabels = new PMValueLabel[15];
    private Vector<BackGroundDrawer> bgDrawers = new Vector();
    private PMAreasGroup content = new PMAreasGroup();
    private static final int INT_STR_OFFSET = 6;
    private Polygon frontArmor = new Polygon(new int[]{0, 19, 149, 168, 145, 132, 57, 23}, new int[]{55, 27, 27, 55, 68, 49, 49, 68}, 8);
    private Polygon frontIS = new Polygon(new int[]{87, 87, 145, 132, 57, 23, 81, 81}, new int[]{40, 77, 39, 20, 20, 39, 77, 40}, 8);
    private Polygon leftFrontArmor = new Polygon(new int[]{0, 0, 23, 23}, new int[]{26, 120, 120, 39}, 4);
    private Polygon leftFrontIS = new Polygon(new int[]{81, 23, 23, 53, 66, 74, 78, 81}, new int[]{77, 39, 120, 120, 94, 94, 85, 85}, 8);
    private Polygon leftRearArmor = new Polygon(new int[]{0, 0, 23, 23}, new int[]{120, 214, 200, 120}, 4);
    private Polygon leftRearIS = new Polygon(new int[]{23, 23, 60, 53, 53}, new int[]{120, 200, 183, 168, 120}, 5);
    private Polygon rightFrontArmor = new Polygon(new int[]{168, 145, 145, 168}, new int[]{26, 120, 120, 39}, 4);
    private Polygon rightFrontIS = new Polygon(new int[]{103, 116, 116, 108, 145, 145, 145, 87, 87, 91, 95}, new int[]{94, 120, 168, 183, 200, 200, 39, 77, 85, 85, 94}, 11);
    private Polygon rightRearArmor = new Polygon(new int[]{168, 145, 145, 168}, new int[]{120, 214, 200, 120}, 4);
    private Polygon rightRearIS = new Polygon(new int[]{103, 116, 116, 108, 145, 145, 145, 87, 87, 91, 95}, new int[]{94, 120, 168, 183, 200, 200, 39, 77, 85, 85, 94}, 11);
    private Polygon rearArmor = new Polygon(new int[]{168, 145, 112, 55, 23, 0, 11, 166}, new int[]{214, 200, 220, 220, 200, 214, 239, 239}, 8);
    private Polygon rearIS = new Polygon(new int[]{145, 108, 99, 70, 60, 23, 55, 112}, new int[]{200, 183, 202, 202, 183, 200, 220, 220}, 8);
    private Polygon turretArmor = new Polygon(new int[]{84, 94, 109, 109, 59, 59, 74, 84, 84, 84, 84, 70, 53, 53, 56, 74, 78, 81, 81, 87, 87, 91, 95, 103, 116, 116, 108, 109, 84}, new int[]{187, 187, 160, 139, 139, 160, 187, 187, 202, 187, 202, 202, 168, 120, 94, 94, 85, 85, 40, 40, 85, 85, 94, 94, 120, 168, 183, 202, 202}, 29);
    private Polygon turretIS = new Polygon(new int[]{59, 59, 74, 94, 109, 109}, new int[]{139, 160, 187, 187, 160, 139}, 6);
    private static final Font FONT_LABEL = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorSmallFontSize"));
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorLargeFontSize"));

    public LargeSupportTankMapSet(Component component) {
        this.comp = component;
        this.setAreas();
        this.setLabels();
        this.setBackGround();
        this.translateAreas();
        this.setContent();
    }

    public void setRest() {
    }

    @Override
    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    @Override
    public Vector<BackGroundDrawer> getBackgroundDrawers() {
        return this.bgDrawers;
    }

    @Override
    public void setEntity(Entity entity) {
        int n;
        LargeSupportTank largeSupportTank = (LargeSupportTank)entity;
        int n2 = 1;
        int n3 = 1;
        for (n = 1; n < 8; ++n) {
            n2 = largeSupportTank.getArmor(n);
            n3 = largeSupportTank.getOArmor(n);
            this.vLabels[n].setValue(largeSupportTank.getArmorString(n));
            WidgetUtils.setAreaColor(this.areas[n], this.vLabels[n], (double)n2 / (double)n3);
        }
        for (n = 8; n < 14; ++n) {
            n2 = largeSupportTank.getInternal(n - 8);
            n3 = largeSupportTank.getOInternal(n - 8);
            this.vLabels[n].setValue(largeSupportTank.getInternalString(n - 8));
            WidgetUtils.setAreaColor(this.areas[n], this.vLabels[n], (double)n2 / (double)n3);
        }
        this.vLabels[14].setValue(String.valueOf(largeSupportTank.getBARRating()));
    }

    private void setContent() {
        int n;
        for (n = 1; n < 8; ++n) {
            this.content.addArea(this.areas[n]);
            this.content.addArea(this.labels[n]);
            this.content.addArea(this.vLabels[n]);
        }
        for (n = 1; n < 8; ++n) {
            this.content.addArea(this.areas[n + 6]);
            this.content.addArea(this.labels[n + 6]);
            this.content.addArea(this.vLabels[n + 6]);
        }
        this.content.addArea(this.labels[14]);
        this.content.addArea(this.vLabels[14]);
    }

    private void setAreas() {
        this.areas[1] = new PMSimplePolygonArea(this.frontArmor);
        this.areas[2] = new PMSimplePolygonArea(this.rightFrontArmor);
        this.areas[3] = new PMSimplePolygonArea(this.leftFrontArmor);
        this.areas[5] = new PMSimplePolygonArea(this.leftRearArmor);
        this.areas[4] = new PMSimplePolygonArea(this.rightRearArmor);
        this.areas[6] = new PMSimplePolygonArea(this.rearArmor);
        this.areas[7] = new PMSimplePolygonArea(this.turretArmor);
        this.areas[7] = new PMSimplePolygonArea(this.frontIS);
        this.areas[8] = new PMSimplePolygonArea(this.rightFrontIS);
        this.areas[9] = new PMSimplePolygonArea(this.leftFrontIS);
        this.areas[11] = new PMSimplePolygonArea(this.leftRearIS);
        this.areas[10] = new PMSimplePolygonArea(this.rightRearIS);
        this.areas[12] = new PMSimplePolygonArea(this.rearIS);
        this.areas[13] = new PMSimplePolygonArea(this.turretIS);
    }

    private void setLabels() {
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_LABEL);
        this.labels[1] = WidgetUtils.createLabel(Messages.getString("TankMapSet.FrontArmor"), fontMetrics, Color.black, 85, 35);
        this.labels[7] = WidgetUtils.createLabel(Messages.getString("TankMapSet.FrontIS"), fontMetrics, Color.black, 83, 57);
        this.labels[3] = WidgetUtils.createLabel(Messages.getString("TankMapSet.LS"), fontMetrics, Color.black, 18, 125);
        this.labels[9] = WidgetUtils.createLabel(Messages.getString("TankMapSet.LIS"), fontMetrics, Color.black, 48, 96);
        this.labels[2] = WidgetUtils.createLabel(Messages.getString("TankMapSet.RS"), fontMetrics, Color.black, 165, 125);
        this.labels[8] = WidgetUtils.createLabel(Messages.getString("TankMapSet.RIS"), fontMetrics, Color.black, 136, 96);
        this.labels[5] = WidgetUtils.createLabel(Messages.getString("TankMapSet.LS"), fontMetrics, Color.black, 18, 165);
        this.labels[11] = WidgetUtils.createLabel(Messages.getString("TankMapSet.LIS"), fontMetrics, Color.black, 48, 136);
        this.labels[4] = WidgetUtils.createLabel(Messages.getString("TankMapSet.RS"), fontMetrics, Color.black, 165, 165);
        this.labels[10] = WidgetUtils.createLabel(Messages.getString("TankMapSet.RIS"), fontMetrics, Color.black, 136, 136);
        this.labels[6] = WidgetUtils.createLabel(Messages.getString("TankMapSet.RearArmor"), fontMetrics, Color.black, 85, 257);
        this.labels[12] = WidgetUtils.createLabel(Messages.getString("TankMapSet.RearIS"), fontMetrics, Color.black, 83, 239);
        this.labels[7] = WidgetUtils.createLabel(Messages.getString("TankMapSet.TurretArmor"), fontMetrics, Color.black, 93, 145);
        this.labels[13] = WidgetUtils.createLabel(Messages.getString("TankMapSet.TurretIS"), fontMetrics, Color.black, 93, 173);
        this.labels[14] = WidgetUtils.createLabel(Messages.getString("TankMapSet.BARRating"), fontMetrics, Color.white, 65, 270);
        fontMetrics = this.comp.getFontMetrics(FONT_VALUE);
        this.vLabels[1] = WidgetUtils.createValueLabel(121, 37, "", fontMetrics);
        this.vLabels[7] = WidgetUtils.createValueLabel(111, 58, "", fontMetrics);
        this.vLabels[3] = WidgetUtils.createValueLabel(20, 150, "", fontMetrics);
        this.vLabels[9] = WidgetUtils.createValueLabel(44, 121, "", fontMetrics);
        this.vLabels[2] = WidgetUtils.createValueLabel(165, 150, "", fontMetrics);
        this.vLabels[8] = WidgetUtils.createValueLabel(142, 121, "", fontMetrics);
        this.vLabels[5] = WidgetUtils.createValueLabel(20, 150, "", fontMetrics);
        this.vLabels[11] = WidgetUtils.createValueLabel(44, 121, "", fontMetrics);
        this.vLabels[4] = WidgetUtils.createValueLabel(165, 150, "", fontMetrics);
        this.vLabels[10] = WidgetUtils.createValueLabel(142, 121, "", fontMetrics);
        this.vLabels[6] = WidgetUtils.createValueLabel(119, 258, "", fontMetrics);
        this.vLabels[12] = WidgetUtils.createValueLabel(111, 241, "", fontMetrics);
        this.vLabels[7] = WidgetUtils.createValueLabel(93, 159, "", fontMetrics);
        this.vLabels[13] = WidgetUtils.createValueLabel(93, 193, "", fontMetrics);
        this.vLabels[14] = WidgetUtils.createValueLabel(120, 280, "", fontMetrics);
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 20;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 68;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 258;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 273;
        image = this.comp.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 321;
        image = this.comp.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.comp.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.comp.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
    }

    private void translateAreas() {
        this.areas[1].translate(8, 0);
        this.areas[7].translate(8, 29);
        this.areas[3].translate(8, 29);
        this.areas[9].translate(8, 29);
        this.areas[2].translate(8, 29);
        this.areas[8].translate(8, 29);
        this.areas[5].translate(8, 29);
        this.areas[11].translate(8, 29);
        this.areas[4].translate(8, 29);
        this.areas[10].translate(8, 29);
        this.areas[6].translate(8, 29);
        this.areas[12].translate(8, 29);
        this.areas[7].translate(8, 29);
        this.areas[13].translate(8, 29);
    }
}

