/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;

public class ChoiceDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 3093043054221558221L;
    private boolean confirm;
    private JPanel panButtons = new JPanel();
    private JButton butSelectAll = new JButton(Messages.getString("ChoiceDialog.SelectAll"));
    private JButton butClearAll = new JButton(Messages.getString("ChoiceDialog.ClearAll"));
    private JButton butOK = new JButton(Messages.getString("Okay"));
    private JButton butCancel = new JButton(Messages.getString("Cancel"));
    private AbstractButton[] checkboxes;

    private void initialize(JFrame jFrame, String string, String[] stringArray, boolean bl) {
        Serializable serializable;
        super.setResizable(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        JTextArea jTextArea = new JTextArea(string, 5, 50);
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)new JScrollPane(jTextArea), gridBagConstraints);
        if (stringArray != null && stringArray.length > 0) {
            JPanel jPanel;
            int n;
            serializable = new JPanel(new GridLayout(0, 1));
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 10;
            if (stringArray.length > 5) {
                n = gridBagConstraints.fill;
                gridBagConstraints.fill = 2;
                jPanel = new JPanel(new GridBagLayout());
                jPanel.add((Component)serializable, gridBagConstraints2);
                JScrollPane jScrollPane = new JScrollPane(jPanel);
                this.getContentPane().add((Component)jScrollPane, gridBagConstraints);
                gridBagConstraints.fill = n;
            } else {
                this.getContentPane().add((Component)serializable, gridBagConstraints);
            }
            if (bl) {
                this.checkboxes = new JRadioButton[stringArray.length];
                ButtonGroup buttonGroup = new ButtonGroup();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.checkboxes[i] = new JRadioButton(stringArray[i], i == 0);
                    buttonGroup.add(this.checkboxes[i]);
                    ((Container)serializable).add(this.checkboxes[i]);
                }
            } else {
                this.checkboxes = new JCheckBox[stringArray.length];
                for (n = 0; n < stringArray.length; ++n) {
                    this.checkboxes[n] = new JCheckBox(stringArray[n], n == 0);
                    ((Container)serializable).add(this.checkboxes[n]);
                }
                GridLayout gridLayout = new GridLayout(1, 0);
                gridLayout.setHgap(20);
                jPanel = new JPanel(gridLayout);
                jPanel.add(this.butSelectAll);
                this.butSelectAll.addActionListener(this);
                jPanel.add(this.butClearAll);
                this.butClearAll.addActionListener(this);
                this.getContentPane().add((Component)jPanel, gridBagConstraints2);
            }
        }
        this.setupButtons();
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.panButtons, gridBagConstraints);
        this.butOK.requestFocus();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ChoiceDialog.this.setVisible(false);
            }
        });
        this.pack();
        serializable = this.getSize();
        boolean bl2 = false;
        if (((Dimension)serializable).width < GUIPreferences.getInstance().getMinimumSizeWidth()) {
            ((Dimension)serializable).width = GUIPreferences.getInstance().getMinimumSizeWidth();
        }
        if (((Dimension)serializable).height < GUIPreferences.getInstance().getMinimumSizeHeight()) {
            ((Dimension)serializable).height = GUIPreferences.getInstance().getMinimumSizeHeight();
        }
        if (bl2) {
            this.setSize((Dimension)serializable);
            serializable = this.getSize();
        }
        this.setLocation(jFrame.getLocation().x + jFrame.getSize().width / 2 - ((Dimension)serializable).width / 2, jFrame.getLocation().y + jFrame.getSize().height / 2 - ((Dimension)serializable).height / 2);
    }

    private void setupButtons() {
        this.butOK.addActionListener(this);
        this.butCancel.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.butOK, gridBagConstraints);
        this.panButtons.add(this.butOK);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.butCancel, gridBagConstraints);
        this.panButtons.add(this.butCancel);
    }

    ChoiceDialog(JFrame jFrame, String string, String string2, String[] stringArray, boolean bl) {
        super(jFrame, string, true);
        this.initialize(jFrame, string2, stringArray, bl);
    }

    public ChoiceDialog(JFrame jFrame, String string, String string2, String[] stringArray) {
        super(jFrame, string, true);
        this.initialize(jFrame, string2, stringArray, false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.checkboxes == null) {
            this.confirm = false;
            this.setVisible(false);
        } else if (actionEvent.getSource().equals(this.butSelectAll)) {
            for (AbstractButton abstractButton : this.checkboxes) {
                abstractButton.setSelected(true);
            }
        } else if (actionEvent.getSource().equals(this.butClearAll)) {
            for (AbstractButton abstractButton : this.checkboxes) {
                abstractButton.setSelected(false);
            }
        } else if (actionEvent.getSource().equals(this.butOK)) {
            this.confirm = true;
            this.setVisible(false);
        } else {
            this.confirm = false;
            this.setVisible(false);
        }
    }

    public boolean getAnswer() {
        return this.getChoices() != null;
    }

    public int[] getChoices() {
        int[] nArray = null;
        if (this.checkboxes != null && this.confirm) {
            int[] nArray2 = new int[this.checkboxes.length];
            int n = 0;
            for (int i = 0; i < this.checkboxes.length; ++i) {
                if (!this.checkboxes[i].isSelected()) continue;
                nArray2[n] = i;
                ++n;
            }
            if (this.checkboxes.length == n) {
                nArray = nArray2;
            } else if (n > 0) {
                nArray = new int[n];
                System.arraycopy(nArray2, 0, nArray, 0, n);
            }
        }
        return nArray;
    }
}

