/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import megamek.client.event.MechDisplayEvent;
import megamek.client.event.MechDisplayListener;
import megamek.client.ui.AWT.Messages;
import megamek.client.ui.swing.BombPayloadDialog;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.FiringDisplay;
import megamek.client.ui.swing.HeatEffects;
import megamek.client.ui.swing.Slider;
import megamek.client.ui.swing.TargetingPhaseDisplay;
import megamek.client.ui.swing.widget.AeroMapSet;
import megamek.client.ui.swing.widget.ArmlessMechMapSet;
import megamek.client.ui.swing.widget.BackGroundDrawer;
import megamek.client.ui.swing.widget.BattleArmorMapSet;
import megamek.client.ui.swing.widget.DisplayMapSet;
import megamek.client.ui.swing.widget.GeneralInfoMapSet;
import megamek.client.ui.swing.widget.GunEmplacementMapSet;
import megamek.client.ui.swing.widget.InfantryMapSet;
import megamek.client.ui.swing.widget.JumpshipMapSet;
import megamek.client.ui.swing.widget.LargeSupportTankMapSet;
import megamek.client.ui.swing.widget.MechMapSet;
import megamek.client.ui.swing.widget.MechPanelTabStrip;
import megamek.client.ui.swing.widget.PMUtil;
import megamek.client.ui.swing.widget.PicMap;
import megamek.client.ui.swing.widget.ProtomechMapSet;
import megamek.client.ui.swing.widget.QuadMapSet;
import megamek.client.ui.swing.widget.SpheroidMapSet;
import megamek.client.ui.swing.widget.SquadronMapSet;
import megamek.client.ui.swing.widget.TankMapSet;
import megamek.client.ui.swing.widget.VTOLMapSet;
import megamek.client.ui.swing.widget.WarshipMapSet;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.ArmlessMech;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentMode;
import megamek.common.EquipmentType;
import megamek.common.FighterSquadron;
import megamek.common.GunEmplacement;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Jumpship;
import megamek.common.LargeSupportTank;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.RoundUpdated;
import megamek.common.SmallCraft;
import megamek.common.Tank;
import megamek.common.VTOL;
import megamek.common.Warship;
import megamek.common.WeaponType;
import megamek.common.weapons.BayWeapon;

public class MechDisplay
extends JPanel {
    private static final long serialVersionUID = -2060993542227677984L;
    private MechPanelTabStrip tabStrip;
    private JPanel displayP;
    private MovementPanel mPan;
    private ArmorPanel aPan;
    public WeaponPanel wPan;
    private SystemPanel sPan;
    private ExtraPanel ePan;
    private ClientGUI clientgui;
    private Entity currentlyDisplaying;
    private ArrayList<MechDisplayListener> eventListeners = new ArrayList();

    public MechDisplay(ClientGUI clientGUI) {
        super(new GridBagLayout());
        this.clientgui = clientGUI;
        this.tabStrip = new MechPanelTabStrip(this);
        this.displayP = new JPanel(new CardLayout());
        this.mPan = new MovementPanel();
        this.displayP.add("movement", this.mPan);
        this.aPan = new ArmorPanel();
        this.displayP.add("armor", this.aPan);
        this.wPan = new WeaponPanel();
        this.displayP.add("weapons", this.wPan);
        this.sPan = new SystemPanel();
        this.displayP.add("systems", this.sPan);
        this.ePan = new ExtraPanel();
        this.displayP.add("extras", this.ePan);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 1, 0, 1);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.addBag(this.tabStrip, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 1, 1, 1);
        gridBagConstraints.weighty = 1.0;
        this.addBag(this.displayP, gridBagConstraints);
        ((CardLayout)this.displayP.getLayout()).show(this.displayP, "movement");
    }

    private void addBag(JComponent jComponent, GridBagConstraints gridBagConstraints) {
        ((GridBagLayout)this.getLayout()).setConstraints(jComponent, gridBagConstraints);
        this.add(jComponent);
    }

    public void displayEntity(Entity entity) {
        this.clientgui.mechW.setTitle(entity.getShortName());
        this.currentlyDisplaying = entity;
        this.mPan.displayMech(entity);
        this.aPan.displayMech(entity);
        this.wPan.displayMech(entity);
        this.sPan.displayMech(entity);
        this.ePan.displayMech(entity);
        this.processMechDisplayEvent(new MechDisplayEvent(this, entity, null));
    }

    public Entity getCurrentEntity() {
        return this.currentlyDisplaying;
    }

    public void showPanel(String string) {
        ((CardLayout)this.displayP.getLayout()).show(this.displayP, string);
        if ("movement".equals(string)) {
            this.tabStrip.setTab(0);
        } else if ("armor".equals(string)) {
            this.tabStrip.setTab(1);
        } else if ("weapons".equals(string)) {
            this.tabStrip.setTab(3);
        } else if ("systems".equals(string)) {
            this.tabStrip.setTab(2);
        } else if ("extras".equals(string)) {
            this.tabStrip.setTab(4);
        }
    }

    public void addMechDisplayListener(MechDisplayListener mechDisplayListener) {
        this.eventListeners.add(mechDisplayListener);
    }

    private void processMechDisplayEvent(MechDisplayEvent mechDisplayEvent) {
        block3: for (int i = 0; i < this.eventListeners.size(); ++i) {
            MechDisplayListener mechDisplayListener = this.eventListeners.get(i);
            switch (mechDisplayEvent.getType()) {
                case 0: {
                    mechDisplayListener.WeaponSelected(mechDisplayEvent);
                    continue block3;
                }
                default: {
                    System.err.println("unknown event " + mechDisplayEvent.getType() + " in processMechDisplayEvent");
                }
            }
        }
    }

    private class ExtraPanel
    extends PicMap
    implements ActionListener {
        private static final long serialVersionUID = -4907296187995261075L;
        private static final String IMAGE_DIR = "data/images/widgets";
        private JLabel narcLabel = new JLabel(Messages.getString("MechDisplay.AffectedBy"), 0);
        private JLabel unusedL;
        private JLabel carrysL;
        private JLabel heatL;
        private JLabel sinksL;
        private JLabel targSysL;
        private JTextArea unusedR;
        private JTextArea carrysR;
        private JTextArea heatR;
        private JTextArea sinksR;
        private JButton sinks2B;
        private JButton dumpBombs;
        private JList narcList;
        private int myMechId;
        private Slider prompt = null;
        private int sinks;
        private boolean dontChange;
        private int minTopMargin = 8;
        private int minLeftMargin = 8;

        ExtraPanel() {
            this.narcLabel.setOpaque(false);
            this.narcLabel.setForeground(Color.WHITE);
            this.narcList = new JList(new DefaultListModel());
            this.unusedL = new JLabel(Messages.getString("MechDisplay.UnusedSpace"), 0);
            this.unusedL.setOpaque(false);
            this.unusedL.setForeground(Color.WHITE);
            this.unusedR = new JTextArea("", 2, 25);
            this.unusedR.setEditable(false);
            this.unusedR.setOpaque(false);
            this.unusedR.setForeground(Color.WHITE);
            this.carrysL = new JLabel(Messages.getString("MechDisplay.Carryng"), 0);
            this.carrysL.setOpaque(false);
            this.carrysL.setForeground(Color.WHITE);
            this.carrysR = new JTextArea("", 4, 25);
            this.carrysR.setEditable(false);
            this.carrysR.setOpaque(false);
            this.carrysR.setForeground(Color.WHITE);
            this.sinksL = new JLabel(Messages.getString("MechDisplay.activeSinksLabel"), 0);
            this.sinksL.setOpaque(false);
            this.sinksL.setForeground(Color.WHITE);
            this.sinksR = new JTextArea("", 1, 25);
            this.sinksR.setEditable(false);
            this.sinksR.setOpaque(false);
            this.sinksR.setForeground(Color.WHITE);
            this.sinks2B = new JButton(Messages.getString("MechDisplay.configureActiveSinksLabel"));
            this.sinks2B.setActionCommand("changeSinks");
            this.sinks2B.addActionListener(this);
            this.dumpBombs = new JButton(Messages.getString("MechDisplay.DumpBombsLabel"));
            this.dumpBombs.setActionCommand("dumpBombs");
            this.dumpBombs.addActionListener(this);
            this.heatL = new JLabel(Messages.getString("MechDisplay.HeatEffects"), 0);
            this.heatL.setOpaque(false);
            this.heatL.setForeground(Color.WHITE);
            this.heatR = new JTextArea("", 4, 25);
            this.heatR.setEditable(false);
            this.heatR.setOpaque(false);
            this.heatR.setForeground(Color.WHITE);
            this.targSysL = new JLabel(Messages.getString("MechDisplay.TargSysLabel").concat(" "), 0);
            this.targSysL.setForeground(Color.WHITE);
            this.targSysL.setOpaque(false);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(15, 9, 1, 9);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weighty = 1.0;
            gridBagLayout.setConstraints(this.narcLabel, gridBagConstraints);
            this.add(this.narcLabel);
            gridBagConstraints.insets = new Insets(1, 9, 1, 9);
            JScrollPane jScrollPane = new JScrollPane(this.narcList);
            jScrollPane.setHorizontalScrollBarPolicy(31);
            gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
            this.add(jScrollPane);
            gridBagLayout.setConstraints(this.unusedL, gridBagConstraints);
            this.add(this.unusedL);
            gridBagLayout.setConstraints(this.unusedR, gridBagConstraints);
            this.add(this.unusedR);
            gridBagLayout.setConstraints(this.carrysL, gridBagConstraints);
            this.add(this.carrysL);
            gridBagLayout.setConstraints(this.carrysR, gridBagConstraints);
            this.add(this.carrysR);
            gridBagLayout.setConstraints(this.dumpBombs, gridBagConstraints);
            this.add(this.dumpBombs);
            gridBagLayout.setConstraints(this.sinksL, gridBagConstraints);
            this.add(this.sinksL);
            gridBagLayout.setConstraints(this.sinksR, gridBagConstraints);
            this.add(this.sinksR);
            gridBagLayout.setConstraints(this.sinks2B, gridBagConstraints);
            this.add(this.sinks2B);
            gridBagLayout.setConstraints(this.heatL, gridBagConstraints);
            this.add(this.heatL);
            gridBagConstraints.insets = new Insets(1, 9, 18, 9);
            gridBagLayout.setConstraints(this.heatR, gridBagConstraints);
            this.add(this.heatR);
            gridBagConstraints.insets = new Insets(1, 9, 1, 9);
            gridBagLayout.setConstraints(this.targSysL, gridBagConstraints);
            this.add(this.targSysL);
            this.setBackGround();
            this.onResize();
        }

        public void onResize() {
            int n = this.getSize().width;
            Rectangle rectangle = this.getContentBounds();
            if (rectangle == null) {
                return;
            }
            int n2 = Math.round((n - rectangle.width) / 2);
            if (n2 < this.minLeftMargin) {
                n2 = this.minLeftMargin;
            }
            int n3 = this.minTopMargin;
            this.setContentMargins(n2, n3, n2, n3);
        }

        private void setBackGround() {
            Image image = this.getToolkit().getImage("data/images/widgets/tile.gif");
            PMUtil.setImage(image, this);
            int n = 8;
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 20;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 68;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 258;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1026;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 273;
            image = this.getToolkit().getImage("data/images/widgets/tl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 321;
            image = this.getToolkit().getImage("data/images/widgets/bl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1041;
            image = this.getToolkit().getImage("data/images/widgets/tr_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1089;
            image = this.getToolkit().getImage("data/images/widgets/br_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
        }

        public void displayMech(Entity entity) {
            String string;
            StringBuffer stringBuffer;
            Serializable serializable;
            ((DefaultListModel)this.narcList.getModel()).removeAllElements();
            this.sinks = 0;
            this.myMechId = entity.getId();
            if (MechDisplay.this.clientgui.getClient().getLocalPlayer().getId() != entity.getOwnerId()) {
                this.sinks2B.setEnabled(false);
                this.dumpBombs.setEnabled(false);
                this.dontChange = true;
            } else {
                this.sinks2B.setEnabled(true);
                this.dumpBombs.setEnabled(false);
                this.dontChange = false;
            }
            Enumeration<Player> enumeration = ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPlayers();
            while (enumeration.hasMoreElements()) {
                serializable = enumeration.nextElement();
                int n = ((Player)serializable).getTeam();
                if (entity.isNarcedBy(n) && !((Player)serializable).isObserver()) {
                    stringBuffer = new StringBuffer(Messages.getString("MechDisplay.NARCedBy"));
                    stringBuffer.append(((Player)serializable).getName());
                    stringBuffer.append(" [").append(Player.teamNames[n]).append(']');
                    ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
                }
                if (!entity.isINarcedBy(n) || ((Player)serializable).isObserver()) continue;
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.INarcHoming"));
                stringBuffer.append(((Player)serializable).getName());
                stringBuffer.append(" [").append(Player.teamNames[n]).append("] ").append(Messages.getString("MechDisplay.attached")).append('.');
                ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
            }
            if (entity.isINarcedWith(2L)) {
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.iNarcECMPodAttached"));
                ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
            }
            if (entity.isINarcedWith(4L)) {
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.iNarcHaywirePodAttached"));
                ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
            }
            if (entity.isINarcedWith(8L)) {
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.iNarcNemesisPodAttached"));
                ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
            }
            if (entity.infernos.isStillBurning()) {
                stringBuffer = new StringBuffer(Messages.getString("MechDisplay.InfernoBurnRemaining"));
                stringBuffer.append(entity.infernos.getTurnsLeftToBurn());
                ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
            }
            if (entity instanceof Tank && ((Tank)entity).isOnFire()) {
                ((DefaultListModel)this.narcList.getModel()).addElement(Messages.getString("MechDisplay.OnFire"));
            }
            if (entity.isSufferingEMI()) {
                ((DefaultListModel)this.narcList.getModel()).addElement(Messages.getString("MechDisplay.IsEMId"));
            }
            if (Compute.isAffectedByECM(entity, (Coords)(serializable = entity.getPosition()), (Coords)serializable)) {
                ((DefaultListModel)this.narcList.getModel()).addElement(Messages.getString("MechDisplay.InEnemyECMField"));
            } else if (Compute.isAffectedByAngelECM(entity, (Coords)serializable, (Coords)serializable)) {
                ((DefaultListModel)this.narcList.getModel()).addElement(Messages.getString("MechDisplay.InEnemyAngelECMField"));
            }
            if (entity.isStealthActive()) {
                ((DefaultListModel)this.narcList.getModel()).addElement(Messages.getString("MechDisplay.UnderStealth"));
            }
            if (entity instanceof Tank && !((Tank)entity).hasNoTurret() && !entity.canChangeSecondaryFacing()) {
                ((DefaultListModel)this.narcList.getModel()).addElement(Messages.getString("MechDisplay.Turretlocked"));
            }
            for (Mounted object2 : entity.getWeaponList()) {
                if (!object2.isJammed()) continue;
                stringBuffer = new StringBuffer(object2.getName());
                stringBuffer.append(Messages.getString("MechDisplay.isJammed"));
                ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
            }
            for (int i = 0; i < entity.locations(); ++i) {
                if (entity.getLocationStatus(i) != -1) continue;
                stringBuffer = new StringBuffer(entity.getLocationName(i));
                stringBuffer.append(Messages.getString("MechDisplay.Breached"));
                ((DefaultListModel)this.narcList.getModel()).addElement(stringBuffer.toString());
            }
            if (this.narcList.getModel().getSize() == 0) {
                ((DefaultListModel)this.narcList.getModel()).addElement(" ");
            }
            if ("".equals(string = entity.getUnusedString())) {
                string = Messages.getString("MechDisplay.None");
            }
            this.unusedR.setText(string);
            Enumeration<Entity> enumeration2 = entity.getLoadedUnits().elements();
            this.carrysR.setText(null);
            while (enumeration2.hasMoreElements()) {
                this.carrysR.append(enumeration2.nextElement().getShortName());
                this.carrysR.append("\n");
            }
            for (Mounted bl : entity.getClubs()) {
                this.carrysR.append(bl.getName());
                this.carrysR.append("\n");
            }
            if (entity.hasSpotlight()) {
                if (entity.isUsingSpotlight()) {
                    this.carrysR.append(Messages.getString("MechDisplay.SearchlightOn"));
                } else {
                    this.carrysR.append(Messages.getString("MechDisplay.SearchlightOff"));
                }
            }
            this.heatR.setText("");
            this.sinksR.setText("");
            if (entity instanceof Mech) {
                Mech mech = (Mech)entity;
                this.sinks2B.setEnabled(!this.dontChange);
                this.sinks = mech.getActiveSinksNextRound();
                if (mech.hasDoubleHeatSinks()) {
                    this.sinksR.append(Messages.getString("MechDisplay.activeSinksTextDouble", new Object[]{new Integer(this.sinks), new Integer(this.sinks * 2)}));
                } else {
                    this.sinksR.append(Messages.getString("MechDisplay.activeSinksTextSingle", new Object[]{new Integer(this.sinks)}));
                }
                boolean bl = false;
                boolean bl2 = false;
                if (((Mech)entity).hasTSM()) {
                    bl = true;
                }
                if (((MechDisplay)MechDisplay.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_heat")) {
                    bl2 = true;
                }
                this.heatR.append(HeatEffects.getHeatEffects(entity.heat, bl2, bl));
            } else {
                this.sinks2B.setEnabled(false);
            }
            if (entity instanceof Aero && ((Aero)entity).hasBombs() && IGame.Phase.PHASE_DEPLOYMENT != ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase()) {
                this.dumpBombs.setEnabled(!this.dontChange);
            } else {
                this.dumpBombs.setEnabled(false);
            }
            this.targSysL.setText(Messages.getString("MechDisplay.TargSysLabel").concat(" ").concat(MiscType.getTargetSysName(entity.getTargSysType())));
            this.onResize();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("changeSinks".equals(actionEvent.getActionCommand()) && !this.dontChange) {
                this.prompt = new Slider(((MechDisplay)MechDisplay.this).clientgui.frame, Messages.getString("MechDisplay.changeSinks"), Messages.getString("MechDisplay.changeSinks"), this.sinks, 0, ((Mech)((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId)).getNumberOfSinks());
                if (!this.prompt.showDialog()) {
                    return;
                }
                ((MechDisplay)MechDisplay.this).clientgui.menuBar.actionPerformed(actionEvent);
                int n = this.prompt.getValue();
                ((Mech)((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId)).setActiveSinksNextRound(n);
                MechDisplay.this.clientgui.getClient().sendUpdateEntity(((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId));
                this.displayMech(((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId));
            }
            if (actionEvent.getActionCommand().equals("dumpBombs") && !this.dontChange) {
                Aero aero = (Aero)((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId);
                if (aero.isPendingBombDump()) {
                    String string = Messages.getString("MechDisplay.CancelBombDumping.title");
                    String string2 = Messages.getString("MechDisplay.CancelBombDumping.message");
                    if (MechDisplay.this.clientgui.doYesNoDialog(string, string2)) {
                        aero.setPendingBombDump(false);
                    }
                } else {
                    BombPayloadDialog bombPayloadDialog = new BombPayloadDialog(((MechDisplay)MechDisplay.this).clientgui.frame, Messages.getString("MechDisplay.BombDumpDialog.title"), aero.getBombChoices(), false, true);
                    bombPayloadDialog.setVisible(true);
                    if (bombPayloadDialog.getAnswer()) {
                        aero.setPendingBombDump(true);
                        aero.setPendingBombDumps(bombPayloadDialog.getChoices());
                    }
                }
                MechDisplay.this.clientgui.getClient().sendUpdateEntity(((MechDisplay)MechDisplay.this).clientgui.getClient().game.getEntity(this.myMechId));
            }
        }
    }

    private class SystemPanel
    extends PicMap
    implements ItemListener,
    ActionListener,
    ListSelectionListener {
        private static final long serialVersionUID = 6660316427898323590L;
        private static final String IMAGE_DIR = "data/images/widgets";
        private JLabel locLabel = new JLabel(Messages.getString("MechDisplay.Location"), 0);
        private JLabel slotLabel;
        private JLabel modeLabel;
        private JList slotList;
        private JList locList;
        private JComboBox m_chMode;
        private JButton m_bDumpAmmo;
        private Entity en;
        private int minTopMargin = 8;
        private int minLeftMargin = 8;

        SystemPanel() {
            this.locLabel.setOpaque(false);
            this.locLabel.setForeground(Color.WHITE);
            this.slotLabel = new JLabel(Messages.getString("MechDisplay.Slot"), 0);
            this.slotLabel.setOpaque(false);
            this.slotLabel.setForeground(Color.WHITE);
            this.locList = new JList(new DefaultListModel());
            this.locList.setOpaque(false);
            this.locList.addListSelectionListener(this);
            this.slotList = new JList(new DefaultListModel());
            this.slotList.setOpaque(false);
            this.slotList.addListSelectionListener(this);
            this.m_chMode = new JComboBox();
            this.m_chMode.addItem("   ");
            this.m_chMode.setEnabled(false);
            this.m_chMode.addItemListener(this);
            this.m_bDumpAmmo = new JButton(Messages.getString("MechDisplay.m_bDumpAmmo"));
            this.m_bDumpAmmo.setEnabled(false);
            this.m_bDumpAmmo.setActionCommand("dump");
            this.m_bDumpAmmo.addActionListener(this);
            this.modeLabel = new JLabel(Messages.getString("MechDisplay.modeLabel"), 4);
            this.modeLabel.setOpaque(false);
            this.modeLabel.setForeground(Color.WHITE);
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(15, 9, 1, 1);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagLayout.setConstraints(this.locLabel, gridBagConstraints);
            this.add(this.locLabel);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(15, 1, 1, 9);
            gridBagLayout.setConstraints(this.slotLabel, gridBagConstraints);
            this.add(this.slotLabel);
            gridBagConstraints.weightx = 0.5;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.insets = new Insets(1, 9, 15, 1);
            gridBagConstraints.gridheight = 0;
            gridBagLayout.setConstraints(this.locList, gridBagConstraints);
            this.add(this.locList);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagLayout.setConstraints(this.slotList, gridBagConstraints);
            this.add(this.slotList);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagLayout.setConstraints(this.modeLabel, gridBagConstraints);
            gridBagConstraints.insets = new Insets(1, 1, 1, 1);
            this.add(this.modeLabel);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagLayout.setConstraints(this.m_chMode, gridBagConstraints);
            this.add(this.m_chMode);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(4, 4, 15, 9);
            gridBagLayout.setConstraints(this.m_bDumpAmmo, gridBagConstraints);
            this.add(this.m_bDumpAmmo);
            this.setBackGround();
            this.onResize();
        }

        public void onResize() {
            int n = this.getSize().width;
            Rectangle rectangle = this.getContentBounds();
            if (rectangle == null) {
                return;
            }
            int n2 = Math.round((n - rectangle.width) / 2);
            if (n2 < this.minLeftMargin) {
                n2 = this.minLeftMargin;
            }
            int n3 = this.minTopMargin;
            this.setContentMargins(n2, n3, n2, n3);
        }

        private CriticalSlot getSelectedCritical() {
            int n = this.locList.getSelectedIndex();
            int n2 = this.slotList.getSelectedIndex();
            if (n == -1 || n2 == -1) {
                return null;
            }
            return this.en.getCritical(n, n2);
        }

        private Mounted getSelectedEquipment() {
            CriticalSlot criticalSlot = this.getSelectedCritical();
            if (criticalSlot == null) {
                return null;
            }
            if (criticalSlot.getType() == 0) {
                return null;
            }
            return this.en.getEquipment(criticalSlot.getIndex());
        }

        public void displayMech(Entity entity) {
            this.en = entity;
            ((DefaultListModel)this.locList.getModel()).removeAllElements();
            for (int i = 0; i < entity.locations(); ++i) {
                if (entity.getNumberOfCriticals(i) <= 0) continue;
                ((DefaultListModel)this.locList.getModel()).insertElementAt(entity.getLocationName(i), i);
            }
            this.locList.setSelectedIndex(0);
            this.displaySlots();
        }

        private void displaySlots() {
            int n = this.locList.getSelectedIndex();
            ((DefaultListModel)this.slotList.getModel()).removeAllElements();
            for (int i = 0; i < this.en.getNumberOfCriticals(n); ++i) {
                CriticalSlot criticalSlot = this.en.getCritical(n, i);
                StringBuffer stringBuffer = new StringBuffer(32);
                if (criticalSlot == null) {
                    stringBuffer.append("---");
                } else {
                    switch (criticalSlot.getType()) {
                        case 0: {
                            stringBuffer.append(criticalSlot.isDestroyed() ? "*" : "").append(criticalSlot.isBreached() ? "x" : "");
                            if (this.en instanceof Protomech) {
                                stringBuffer.append(Protomech.systemNames[criticalSlot.getIndex()]);
                                break;
                            }
                            stringBuffer.append(((Mech)this.en).getSystemName(criticalSlot.getIndex()));
                            break;
                        }
                        case 1: {
                            Mounted mounted = this.en.getEquipment(criticalSlot.getIndex());
                            stringBuffer.append(criticalSlot.isDestroyed() ? "*" : "").append(criticalSlot.isBreached() ? "x" : "").append(mounted.getDesc());
                            if (mounted.isHotLoaded()) {
                                stringBuffer.append(Messages.getString("MechDisplay.isHotLoaded"));
                            }
                            if (!mounted.getType().hasModes()) break;
                            stringBuffer.append(" (").append(mounted.curMode().getDisplayableName()).append(')');
                            if (!(mounted.getType() instanceof MiscType) || !((MiscType)mounted.getType()).isShield()) break;
                            stringBuffer.append(" " + mounted.getDamageAbsorption(this.en, n) + '/' + mounted.getCurrentDamageCapacity(this.en, n) + ')');
                            break;
                        }
                    }
                }
                ((DefaultListModel)this.slotList.getModel()).addElement(stringBuffer.toString());
            }
            this.onResize();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getItemSelectable() == this.locList) {
                ((DefaultComboBoxModel)this.m_chMode.getModel()).removeAllElements();
                this.m_chMode.setEnabled(false);
                this.displaySlots();
            } else if (itemEvent.getItemSelectable() == this.slotList) {
                boolean bl;
                this.m_bDumpAmmo.setEnabled(false);
                this.m_chMode.setEnabled(false);
                Mounted mounted = this.getSelectedEquipment();
                boolean bl2 = bl = MechDisplay.this.clientgui.getClient().getLocalPlayer() == this.en.getOwner();
                if (mounted != null && bl && mounted.getType() instanceof AmmoType && !mounted.getType().hasInstantModeSwitch() && IGame.Phase.PHASE_DEPLOYMENT != ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase() && mounted.getShotsLeft() > 0 && !mounted.isDumping() && this.en.isActive() && ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getOptions().intOption("dumping_from_round") <= ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getRoundCount()) {
                    this.m_bDumpAmmo.setEnabled(true);
                    if (((MechDisplay)MechDisplay.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_hotload") && this.en instanceof Tank && mounted.getType().hasFlag(8L)) {
                        this.m_bDumpAmmo.setEnabled(false);
                        this.m_chMode.setEnabled(true);
                        ((DefaultComboBoxModel)this.m_chMode.getModel()).removeAllElements();
                        Enumeration<EquipmentMode> enumeration = mounted.getType().getModes();
                        while (enumeration.hasMoreElements()) {
                            EquipmentMode equipmentMode = enumeration.nextElement();
                            this.m_chMode.addItem(equipmentMode.getDisplayableName());
                        }
                        this.m_chMode.setSelectedItem(mounted.curMode().getDisplayableName());
                    }
                } else if (mounted != null && bl && mounted.getType().hasModes()) {
                    if (!mounted.isDestroyed() && this.en.isActive()) {
                        this.m_chMode.setEnabled(true);
                    }
                    if (!mounted.isDestroyed() && mounted.getType().hasFlag(262144L)) {
                        this.m_chMode.setEnabled(true);
                    }
                    if (mounted.getType().hasFlag(1024L) && !((MechDisplay)MechDisplay.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_eccm")) {
                        ((DefaultComboBoxModel)this.m_chMode.getModel()).removeAllElements();
                        return;
                    }
                    if (mounted.getType() instanceof WeaponType && (((WeaponType)mounted.getType()).getAmmoType() == 1 || ((WeaponType)mounted.getType()).getAmmoType() == 34) && !((MechDisplay)MechDisplay.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_rapid_ac")) {
                        ((DefaultComboBoxModel)this.m_chMode.getModel()).removeAllElements();
                        return;
                    }
                    if (this.en instanceof Aero && mounted.getType() instanceof WeaponType && (((WeaponType)mounted.getType()).getAmmoType() == 23 || ((WeaponType)mounted.getType()).getAmmoType() == 20 || ((WeaponType)mounted.getType()).getAmmoType() == 1 || ((WeaponType)mounted.getType()).getAmmoType() == 33)) {
                        ((DefaultComboBoxModel)this.m_chMode.getModel()).removeAllElements();
                        return;
                    }
                    ((DefaultComboBoxModel)this.m_chMode.getModel()).removeAllElements();
                    Enumeration<EquipmentMode> enumeration = mounted.getType().getModes();
                    while (enumeration.hasMoreElements()) {
                        EquipmentMode equipmentMode = enumeration.nextElement();
                        this.m_chMode.addItem(equipmentMode.getDisplayableName());
                    }
                    this.m_chMode.setSelectedItem(mounted.curMode().getDisplayableName());
                } else {
                    CriticalSlot criticalSlot = this.getSelectedCritical();
                    if (criticalSlot != null && criticalSlot.getType() == 0 && criticalSlot.getIndex() == 2 && this.en.hasEiCockpit() && this.en instanceof Mech) {
                        ((DefaultComboBoxModel)this.m_chMode.getModel()).removeAllElements();
                        this.m_chMode.setEnabled(true);
                        this.m_chMode.addItem("EI Off");
                        this.m_chMode.addItem("EI On");
                        this.m_chMode.addItem("Aimed shot");
                        this.m_chMode.setSelectedItem(((Mech)this.en).getCockpitStatusNextRound());
                    }
                }
            } else if (itemEvent.getItemSelectable() == this.m_chMode) {
                int n;
                Mounted mounted = this.getSelectedEquipment();
                CriticalSlot criticalSlot = this.getSelectedCritical();
                if (mounted != null && mounted.getType().hasModes()) {
                    int n2 = this.m_chMode.getSelectedIndex();
                    if (n2 >= 0) {
                        if (mounted.getType() instanceof MiscType && ((MiscType)mounted.getType()).isShield() && ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase() != IGame.Phase.PHASE_FIRING) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.ShieldModePhase", null));
                            return;
                        }
                        if (mounted.getType() instanceof MiscType && ((MiscType)mounted.getType()).isVibroblade() && ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase() != IGame.Phase.PHASE_PHYSICAL) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.VibrobladeModePhase", null));
                            return;
                        }
                        if (mounted.getType() instanceof MiscType && ((MiscType)mounted.getType()).hasSubType(0x800000) && ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase() != IGame.Phase.PHASE_MOVEMENT) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.RetractableBladeModePhase", null));
                            return;
                        }
                        if (mounted.getType() instanceof MiscType && mounted.getLinked() != null && ((MiscType)mounted.getType()).hasFlag(0x1000000000L) && mounted.getLinked().isUsedThisRound() && n2 == 1) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.CapacitorCharging", null));
                            return;
                        }
                        mounted.setMode(n2);
                        MechDisplay.this.clientgui.getClient().sendModeChange(this.en.getId(), this.en.getEquipmentNum(mounted), n2);
                        if (mounted.getType().hasInstantModeSwitch()) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.switched", new Object[]{mounted.getName(), mounted.curMode().getDisplayableName()}));
                        } else if (IGame.Phase.PHASE_DEPLOYMENT == ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase()) {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.willSwitchAtStart", new Object[]{mounted.getName(), mounted.pendingMode().getDisplayableName()}));
                        } else {
                            MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.willSwitchAtEnd", new Object[]{mounted.getName(), mounted.pendingMode().getDisplayableName()}));
                        }
                    }
                } else if (criticalSlot != null && criticalSlot.getType() == 0 && (n = this.m_chMode.getSelectedIndex()) >= 0 && criticalSlot.getIndex() == 2 && this.en.hasEiCockpit() && this.en instanceof Mech) {
                    Mech mech = (Mech)this.en;
                    mech.setCockpitStatus(n);
                    MechDisplay.this.clientgui.getClient().sendSystemModeChange(this.en.getId(), 2, n);
                    if (mech.getCockpitStatus() == mech.getCockpitStatusNextRound()) {
                        MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.switched", new Object[]{"Cockpit", this.m_chMode.getSelectedItem()}));
                    } else {
                        MechDisplay.this.clientgui.systemMessage(Messages.getString("MechDisplay.willSwitchAtEnd", new Object[]{"Cockpit", this.m_chMode.getSelectedItem()}));
                    }
                }
            }
            this.onResize();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("dump".equals(actionEvent.getActionCommand())) {
                boolean bl;
                boolean bl2;
                Mounted mounted = this.getSelectedEquipment();
                boolean bl3 = MechDisplay.this.clientgui.getClient().getLocalPlayer().equals(this.en.getOwner());
                if (mounted == null || !bl3 || !(mounted.getType() instanceof AmmoType) || mounted.getShotsLeft() <= 0) {
                    return;
                }
                if (mounted.isPendingDump()) {
                    bl2 = false;
                    String string = Messages.getString("MechDisplay.CancelDumping.title");
                    String string2 = Messages.getString("MechDisplay.CancelDumping.message", new Object[]{mounted.getName()});
                    bl = MechDisplay.this.clientgui.doYesNoDialog(string, string2);
                } else {
                    bl2 = true;
                    String string = Messages.getString("MechDisplay.Dump.title");
                    String string3 = Messages.getString("MechDisplay.Dump.message", new Object[]{mounted.getName()});
                    bl = MechDisplay.this.clientgui.doYesNoDialog(string, string3);
                }
                if (bl) {
                    mounted.setPendingDump(bl2);
                    MechDisplay.this.clientgui.getClient().sendModeChange(this.en.getId(), this.en.getEquipmentNum(mounted), bl2 ? -1 : 0);
                }
            }
            this.onResize();
        }

        private void setBackGround() {
            Image image = this.getToolkit().getImage("data/images/widgets/tile.gif");
            PMUtil.setImage(image, this);
            int n = 8;
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 20;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 68;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 258;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1026;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 273;
            image = this.getToolkit().getImage("data/images/widgets/tl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 321;
            image = this.getToolkit().getImage("data/images/widgets/bl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1041;
            image = this.getToolkit().getImage("data/images/widgets/tr_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1089;
            image = this.getToolkit().getImage("data/images/widgets/br_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource().equals(this.locList)) {
                ((DefaultComboBoxModel)this.m_chMode.getModel()).removeAllElements();
                this.m_chMode.setEnabled(false);
                this.displaySlots();
            } else if (listSelectionEvent.getSource().equals(this.slotList)) {
                this.m_bDumpAmmo.setEnabled(false);
                this.m_chMode.setEnabled(false);
                Mounted mounted = this.getSelectedEquipment();
                boolean bl = MechDisplay.this.clientgui.getClient().getLocalPlayer().equals(this.en.getOwner());
                if (mounted != null && bl && mounted.getType() instanceof AmmoType && !mounted.getType().hasInstantModeSwitch() && ((MechDisplay)MechDisplay.this).clientgui.getClient().game.getPhase() != IGame.Phase.PHASE_DEPLOYMENT && mounted.getShotsLeft() > 0 && !mounted.isDumping() && this.en.isActive()) {
                    this.m_bDumpAmmo.setEnabled(true);
                } else if (mounted != null && bl && mounted.getType().hasModes()) {
                    if (!mounted.isDestroyed() && this.en.isActive()) {
                        this.m_chMode.setEnabled(true);
                    }
                    if (!mounted.isDestroyed() && mounted.getType().hasFlag(262144L)) {
                        this.m_chMode.setEnabled(true);
                    }
                    if (mounted.getType().hasFlag(1024L) && !((MechDisplay)MechDisplay.this).clientgui.getClient().game.getOptions().booleanOption("maxtech_eccm")) {
                        ((DefaultComboBoxModel)this.m_chMode.getModel()).removeAllElements();
                        return;
                    }
                    ((DefaultComboBoxModel)this.m_chMode.getModel()).removeAllElements();
                    Enumeration<EquipmentMode> enumeration = mounted.getType().getModes();
                    while (enumeration.hasMoreElements()) {
                        EquipmentMode equipmentMode = enumeration.nextElement();
                        this.m_chMode.addItem(equipmentMode.getDisplayableName());
                    }
                    this.m_chMode.setSelectedItem(mounted.curMode().getDisplayableName());
                } else {
                    CriticalSlot criticalSlot = this.getSelectedCritical();
                    if (criticalSlot != null && criticalSlot.getType() == 0 && criticalSlot.getIndex() == 2 && this.en.hasEiCockpit() && this.en instanceof Mech) {
                        ((DefaultComboBoxModel)this.m_chMode.getModel()).removeAllElements();
                        this.m_chMode.setEnabled(true);
                        this.m_chMode.addItem("EI Off");
                        this.m_chMode.addItem("EI On");
                        this.m_chMode.addItem("Aimed shot");
                        this.m_chMode.setSelectedItem(new Integer(((Mech)this.en).getCockpitStatusNextRound()));
                    }
                }
            }
            this.onResize();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WeaponPanel
    extends PicMap
    implements ItemListener,
    ListSelectionListener {
        private static final long serialVersionUID = -5728839963281503332L;
        private static final String IMAGE_DIR = "data/images/widgets";
        public JList weaponList;
        private JComboBox m_chAmmo;
        public JComboBox m_chBayWeapon;
        private JLabel wAmmo;
        private JLabel wBayWeapon;
        private JLabel wNameL;
        private JLabel wHeatL;
        private JLabel wArcHeatL;
        private JLabel wDamL;
        private JLabel wMinL;
        private JLabel wShortL;
        private JLabel wMedL;
        private JLabel wLongL;
        private JLabel wExtL;
        private JLabel wAVL;
        private JLabel wNameR;
        private JLabel wHeatR;
        private JLabel wArcHeatR;
        private JLabel wDamR;
        private JLabel wMinR;
        private JLabel wShortR;
        private JLabel wMedR;
        private JLabel wLongR;
        private JLabel wExtR;
        private JLabel wShortAVR;
        private JLabel wMedAVR;
        private JLabel wLongAVR;
        private JLabel wExtAVR;
        private JLabel currentHeatBuildupL;
        private JLabel currentHeatBuildupR;
        private JLabel wTargetL;
        private JLabel wRangeL;
        private JLabel wToHitL;
        public JLabel wTargetR;
        public JLabel wRangeR;
        public JLabel wToHitR;
        public JTextArea toHitText;
        private ArrayList<Mounted> vAmmo;
        private Entity entity;
        private int minTopMargin = 8;
        private int minLeftMargin = 8;

        WeaponPanel() {
            GridBagLayout gridBagLayout = new GridBagLayout();
            this.setLayout(gridBagLayout);
            this.weaponList = new JList(new DefaultListModel());
            this.weaponList.addListSelectionListener(this);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(15, 9, 1, 9);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.weaponList, gridBagConstraints);
            this.add(this.weaponList);
            this.wAmmo = new JLabel(Messages.getString("MechDisplay.Ammo"), 2);
            this.wAmmo.setOpaque(false);
            this.wAmmo.setForeground(Color.WHITE);
            this.m_chAmmo = new JComboBox();
            this.m_chAmmo.addItemListener(this);
            this.wBayWeapon = new JLabel(Messages.getString("MechDisplay.Weapon"), 2);
            this.wBayWeapon.setOpaque(false);
            this.wBayWeapon.setForeground(Color.WHITE);
            this.m_chBayWeapon = new JComboBox();
            this.m_chBayWeapon.addItemListener(this);
            gridBagConstraints.insets = new Insets(1, 9, 1, 1);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wBayWeapon, gridBagConstraints);
            this.add(this.wBayWeapon);
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            ((GridBagLayout)this.getLayout()).setConstraints(this.m_chBayWeapon, gridBagConstraints);
            this.add(this.m_chBayWeapon);
            gridBagConstraints.insets = new Insets(1, 9, 1, 1);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(this.wAmmo, gridBagConstraints);
            this.add(this.wAmmo);
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            gridBagLayout.setConstraints(this.m_chAmmo, gridBagConstraints);
            this.add(this.m_chAmmo);
            this.currentHeatBuildupL = new JLabel(Messages.getString("MechDisplay.HeatBuildup"), 4);
            this.currentHeatBuildupL.setOpaque(false);
            this.currentHeatBuildupL.setForeground(Color.WHITE);
            this.currentHeatBuildupR = new JLabel("--", 2);
            this.currentHeatBuildupR.setOpaque(false);
            this.currentHeatBuildupR.setForeground(Color.WHITE);
            gridBagConstraints.insets = new Insets(2, 9, 2, 1);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.currentHeatBuildupL, gridBagConstraints);
            this.add(this.currentHeatBuildupL);
            gridBagConstraints.insets = new Insets(2, 1, 2, 9);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.currentHeatBuildupR, gridBagConstraints);
            this.add(this.currentHeatBuildupR);
            this.wNameL = new JLabel(Messages.getString("MechDisplay.Name"), 0);
            this.wNameL.setOpaque(false);
            this.wNameL.setForeground(Color.WHITE);
            this.wHeatL = new JLabel(Messages.getString("MechDisplay.Heat"), 0);
            this.wHeatL.setOpaque(false);
            this.wHeatL.setForeground(Color.WHITE);
            this.wDamL = new JLabel(Messages.getString("MechDisplay.Damage"), 0);
            this.wDamL.setOpaque(false);
            this.wDamL.setForeground(Color.WHITE);
            this.wArcHeatL = new JLabel(Messages.getString("MechDisplay.ArcHeat"), 0);
            this.wArcHeatL.setOpaque(false);
            this.wArcHeatL.setForeground(Color.WHITE);
            this.wNameR = new JLabel("", 0);
            this.wNameR.setOpaque(false);
            this.wNameR.setForeground(Color.WHITE);
            this.wHeatR = new JLabel("--", 0);
            this.wHeatR.setOpaque(false);
            this.wHeatR.setForeground(Color.WHITE);
            this.wDamR = new JLabel("--", 0);
            this.wDamR.setOpaque(false);
            this.wDamR.setForeground(Color.WHITE);
            this.wArcHeatR = new JLabel("--", 0);
            this.wArcHeatR.setOpaque(false);
            this.wArcHeatR.setForeground(Color.WHITE);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(2, 9, 1, 1);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagLayout.setConstraints(this.wNameL, gridBagConstraints);
            this.add(this.wNameL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 1);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 2;
            gridBagLayout.setConstraints(this.wHeatL, gridBagConstraints);
            this.add(this.wHeatL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 9);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 3;
            gridBagLayout.setConstraints(this.wDamL, gridBagConstraints);
            this.add(this.wDamL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 9);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridx = 4;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wArcHeatL, gridBagConstraints);
            this.add(this.wArcHeatL);
            gridBagConstraints.insets = new Insets(1, 9, 2, 1);
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagLayout.setConstraints(this.wNameR, gridBagConstraints);
            this.add(this.wNameR);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 2;
            gridBagLayout.setConstraints(this.wHeatR, gridBagConstraints);
            this.add(this.wHeatR);
            gridBagConstraints.insets = new Insets(1, 1, 2, 9);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.wDamR, gridBagConstraints);
            this.add(this.wDamR);
            gridBagConstraints.insets = new Insets(1, 1, 2, 9);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridwidth = 0;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wArcHeatR, gridBagConstraints);
            this.add(this.wArcHeatR);
            this.wMinL = new JLabel(Messages.getString("MechDisplay.Min"), 0);
            this.wMinL.setOpaque(false);
            this.wMinL.setForeground(Color.WHITE);
            this.wShortL = new JLabel(Messages.getString("MechDisplay.Short"), 0);
            this.wShortL.setOpaque(false);
            this.wShortL.setForeground(Color.WHITE);
            this.wMedL = new JLabel(Messages.getString("MechDisplay.Med"), 0);
            this.wMedL.setOpaque(false);
            this.wMedL.setForeground(Color.WHITE);
            this.wLongL = new JLabel(Messages.getString("MechDisplay.Long"), 0);
            this.wLongL.setOpaque(false);
            this.wLongL.setForeground(Color.WHITE);
            this.wExtL = new JLabel(Messages.getString("MechDisplay.Ext"), 0);
            this.wExtL.setOpaque(false);
            this.wExtL.setForeground(Color.WHITE);
            this.wMinR = new JLabel("---", 0);
            this.wMinR.setOpaque(false);
            this.wMinR.setForeground(Color.WHITE);
            this.wShortR = new JLabel("---", 0);
            this.wShortR.setOpaque(false);
            this.wShortR.setForeground(Color.WHITE);
            this.wMedR = new JLabel("---", 0);
            this.wMedR.setOpaque(false);
            this.wMedR.setForeground(Color.WHITE);
            this.wLongR = new JLabel("---", 0);
            this.wLongR.setOpaque(false);
            this.wLongR.setForeground(Color.WHITE);
            this.wExtR = new JLabel("---", 0);
            this.wExtR.setOpaque(false);
            this.wExtR.setForeground(Color.WHITE);
            this.wAVL = new JLabel(Messages.getString("MechDisplay.AV"), 0);
            this.wAVL.setOpaque(false);
            this.wAVL.setForeground(Color.WHITE);
            this.wShortAVR = new JLabel("---", 0);
            this.wShortAVR.setOpaque(false);
            this.wShortAVR.setForeground(Color.WHITE);
            this.wMedAVR = new JLabel("---", 0);
            this.wMedAVR.setOpaque(false);
            this.wMedAVR.setForeground(Color.WHITE);
            this.wLongAVR = new JLabel("---", 0);
            this.wLongAVR.setOpaque(false);
            this.wLongAVR.setForeground(Color.WHITE);
            this.wExtAVR = new JLabel("---", 0);
            this.wExtAVR.setOpaque(false);
            this.wExtAVR.setForeground(Color.WHITE);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 9, 1, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.wMinL, gridBagConstraints);
            this.add(this.wMinL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 1);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 6;
            gridBagLayout.setConstraints(this.wShortL, gridBagConstraints);
            this.add(this.wShortL);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 6;
            gridBagLayout.setConstraints(this.wMedL, gridBagConstraints);
            this.add(this.wMedL);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 6;
            gridBagLayout.setConstraints(this.wLongL, gridBagConstraints);
            this.add(this.wLongL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 9);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.wExtL, gridBagConstraints);
            this.add(this.wExtL);
            gridBagConstraints.insets = new Insets(1, 9, 2, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.wMinR, gridBagConstraints);
            this.add(this.wMinR);
            gridBagConstraints.insets = new Insets(1, 1, 2, 1);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 7;
            gridBagLayout.setConstraints(this.wShortR, gridBagConstraints);
            this.add(this.wShortR);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 7;
            gridBagLayout.setConstraints(this.wMedR, gridBagConstraints);
            this.add(this.wMedR);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 7;
            gridBagLayout.setConstraints(this.wLongR, gridBagConstraints);
            this.add(this.wLongR);
            gridBagConstraints.insets = new Insets(1, 1, 2, 9);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 7;
            gridBagLayout.setConstraints(this.wExtR, gridBagConstraints);
            this.add(this.wExtR);
            gridBagConstraints.insets = new Insets(1, 9, 2, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 8;
            gridBagConstraints.gridwidth = 1;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wAVL, gridBagConstraints);
            this.add(this.wAVL);
            gridBagConstraints.insets = new Insets(1, 1, 2, 1);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 8;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wShortAVR, gridBagConstraints);
            this.add(this.wShortAVR);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 8;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wMedAVR, gridBagConstraints);
            this.add(this.wMedAVR);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 8;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wLongAVR, gridBagConstraints);
            this.add(this.wLongAVR);
            gridBagConstraints.insets = new Insets(1, 1, 2, 9);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 8;
            ((GridBagLayout)this.getLayout()).setConstraints(this.wExtAVR, gridBagConstraints);
            this.add(this.wExtAVR);
            this.wTargetL = new JLabel(Messages.getString("MechDisplay.Target"), 0);
            this.wTargetL.setOpaque(false);
            this.wTargetL.setForeground(Color.WHITE);
            this.wRangeL = new JLabel(Messages.getString("MechDisplay.Range"), 0);
            this.wRangeL.setOpaque(false);
            this.wRangeL.setForeground(Color.WHITE);
            this.wToHitL = new JLabel(Messages.getString("MechDisplay.ToHit"), 0);
            this.wToHitL.setOpaque(false);
            this.wToHitL.setForeground(Color.WHITE);
            this.wTargetR = new JLabel("---", 0);
            this.wTargetR.setOpaque(false);
            this.wTargetR.setForeground(Color.WHITE);
            this.wRangeR = new JLabel("---", 0);
            this.wRangeR.setOpaque(false);
            this.wRangeR.setForeground(Color.WHITE);
            this.wToHitR = new JLabel("---", 0);
            this.wToHitR.setOpaque(false);
            this.wToHitR.setForeground(Color.WHITE);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets = new Insets(2, 9, 1, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.wTargetL, gridBagConstraints);
            this.add(this.wTargetL);
            gridBagConstraints.insets = new Insets(2, 1, 1, 9);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 9;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.wTargetR, gridBagConstraints);
            this.add(this.wTargetR);
            gridBagConstraints.insets = new Insets(1, 9, 1, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 10;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.wRangeL, gridBagConstraints);
            this.add(this.wRangeL);
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 10;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.wRangeR, gridBagConstraints);
            this.add(this.wRangeR);
            gridBagConstraints.insets = new Insets(1, 9, 1, 1);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 11;
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.wToHitL, gridBagConstraints);
            this.add(this.wToHitL);
            gridBagConstraints.insets = new Insets(1, 1, 1, 9);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 11;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.wToHitR, gridBagConstraints);
            this.add(this.wToHitR);
            this.toHitText = new JTextArea("", 2, 20);
            this.toHitText.setEditable(false);
            gridBagConstraints.insets = new Insets(1, 9, 15, 9);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 12;
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.toHitText, gridBagConstraints);
            this.add(this.toHitText);
            this.setBackGround();
            this.onResize();
        }

        @Override
        public void onResize() {
            int n = this.getSize().width;
            Rectangle rectangle = this.getContentBounds();
            if (rectangle == null) {
                return;
            }
            int n2 = Math.round((n - rectangle.width) / 2);
            if (n2 < this.minLeftMargin) {
                n2 = this.minLeftMargin;
            }
            int n3 = this.minTopMargin;
            this.setContentMargins(n2, n3, n2, n3);
        }

        private void setBackGround() {
            Image image = this.getToolkit().getImage("data/images/widgets/tile.gif");
            PMUtil.setImage(image, this);
            int n = 8;
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 20;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 68;
            image = this.getToolkit().getImage("data/images/widgets/h_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 258;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1026;
            image = this.getToolkit().getImage("data/images/widgets/v_line.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 273;
            image = this.getToolkit().getImage("data/images/widgets/tl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 321;
            image = this.getToolkit().getImage("data/images/widgets/bl_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1041;
            image = this.getToolkit().getImage("data/images/widgets/tr_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
            n = 1089;
            image = this.getToolkit().getImage("data/images/widgets/br_corner.gif");
            PMUtil.setImage(image, this);
            this.addBgDrawer(new BackGroundDrawer(image, n));
        }

        public void displayMech(Entity entity) {
            CharSequence charSequence;
            Object object;
            int n;
            Object object2;
            IGame iGame = ((MechDisplay)MechDisplay.this).clientgui.getClient().game;
            this.entity = entity;
            int n2 = entity.heat + entity.getEngineCritHeat() + Math.min(15, entity.heatFromExternal) + entity.heatBuildup;
            if (entity instanceof Mech) {
                if (entity.infernos.isStillBurning()) {
                    n2 += entity.infernos.getHeat();
                }
                if (!((Mech)entity).hasLaserHeatSinks()) {
                    n2 = iGame.getOptions().intOption("temperature") > 0 ? (n2 += iGame.getTemperatureDifference()) : (n2 -= iGame.getTemperatureDifference());
                }
            }
            Coords coords = this.entity.getPosition();
            if (!entity.isOffBoard() && coords != null) {
                object2 = iGame.getBoard().getHex(coords);
                if (object2.terrainLevel(7) == 2) {
                    n2 += 5;
                }
                if (object2.terrainLevel(24) == 1) {
                    n2 += 5;
                } else if (object2.terrainLevel(24) == 2) {
                    n2 += 10;
                }
            }
            if (entity instanceof Mech && entity.isStealthActive()) {
                n2 += 10;
            }
            ((DefaultListModel)this.weaponList.getModel()).removeAllElements();
            ((DefaultComboBoxModel)this.m_chAmmo.getModel()).removeAllElements();
            this.m_chAmmo.setEnabled(false);
            this.m_chBayWeapon.removeAllItems();
            this.m_chBayWeapon.setEnabled(false);
            object2 = new boolean[this.entity.locations()];
            boolean[] blArray = new boolean[this.entity.locations()];
            for (n = 0; n < this.entity.locations(); ++n) {
                object2[n] = false;
                blArray[n] = false;
            }
            for (n = 0; n < this.entity.getWeaponList().size(); ++n) {
                int n3;
                Mounted mounted = this.entity.getWeaponList().get(n);
                object = (WeaponType)mounted.getType();
                charSequence = new StringBuffer(mounted.getDesc());
                ((StringBuffer)charSequence).append(" [");
                ((StringBuffer)charSequence).append(entity.getLocationAbbr(mounted.getLocation()));
                if (mounted.isSplit()) {
                    ((StringBuffer)charSequence).append('/');
                    ((StringBuffer)charSequence).append(entity.getLocationAbbr(mounted.getSecondLocation()));
                }
                ((StringBuffer)charSequence).append(']');
                if (((WeaponType)object).getAmmoType() != -1 && !((EquipmentType)object).hasFlag(16384L)) {
                    n3 = 0;
                    if (mounted.getLinked() != null && !mounted.getLinked().isDumping()) {
                        n3 = mounted.getLinked().getShotsLeft();
                    }
                    EquipmentType equipmentType = null;
                    if (mounted.getLinked() != null) {
                        equipmentType = mounted.getLinked().getType();
                    }
                    int n4 = this.entity.getTotalMunitionsOfType(equipmentType);
                    ((StringBuffer)charSequence).append(" (");
                    ((StringBuffer)charSequence).append(n3);
                    ((StringBuffer)charSequence).append('/');
                    ((StringBuffer)charSequence).append(n4);
                    ((StringBuffer)charSequence).append(')');
                }
                if (mounted.isRapidfire()) {
                    ((StringBuffer)charSequence).append(Messages.getString("MechDisplay.rapidFire"));
                }
                if (mounted.isHotLoaded()) {
                    ((StringBuffer)charSequence).append(Messages.getString("MechDisplay.isHotLoaded"));
                }
                if (((EquipmentType)object).hasModes()) {
                    ((StringBuffer)charSequence).append(' ');
                    ((StringBuffer)charSequence).append(mounted.curMode().getDisplayableName());
                }
                ((DefaultListModel)this.weaponList.getModel()).addElement(((StringBuffer)charSequence).toString());
                if (!mounted.isUsedThisRound() || iGame.getPhase() != mounted.usedInPhase() || iGame.getPhase() != IGame.Phase.PHASE_FIRING) continue;
                if (this.entity.usesWeaponBays()) {
                    if (iGame.getOptions().booleanOption("heat_by_bay")) {
                        for (int n5 : mounted.getBayWeapons()) {
                            n2 += this.entity.getEquipment(n5).getCurrentHeat();
                        }
                        continue;
                    }
                    n3 = mounted.getLocation();
                    boolean bl = mounted.isRearMounted();
                    if (!bl) {
                        if (object2[n3] != false) continue;
                        n2 += this.entity.getHeatInArc(n3, bl);
                        object2[n3] = true;
                        continue;
                    }
                    if (blArray[n3]) continue;
                    n2 += this.entity.getHeatInArc(n3, bl);
                    blArray[n3] = true;
                    continue;
                }
                if (mounted.isBombMounted()) continue;
                n2 += mounted.getCurrentHeat();
            }
            n = entity.getHeatCapacity();
            int n6 = entity.getHeatCapacityWithWater();
            object = Integer.toString(n);
            if (n < n6) {
                object = n + " [" + n6 + ']';
            }
            charSequence = Integer.toString(n2);
            if (n2 > entity.getHeatCapacityWithWater()) {
                charSequence = (String)charSequence + "*";
            }
            if (n2 < 0) {
                n2 = 0;
            }
            this.currentHeatBuildupR.setText((String)charSequence + " (" + (String)object + ')');
            if (this.entity.usesWeaponBays()) {
                this.wArcHeatL.setVisible(true);
                this.wArcHeatR.setVisible(true);
                this.m_chBayWeapon.setVisible(true);
                this.wBayWeapon.setVisible(true);
            } else {
                this.wArcHeatL.setVisible(false);
                this.wArcHeatR.setVisible(false);
                this.m_chBayWeapon.setVisible(false);
                this.wBayWeapon.setVisible(false);
            }
            if (this.entity instanceof Aero) {
                this.wAVL.setVisible(true);
                this.wShortAVR.setVisible(true);
                this.wMedAVR.setVisible(true);
                this.wLongAVR.setVisible(true);
                this.wExtAVR.setVisible(true);
                this.wMinL.setVisible(false);
                this.wMinR.setVisible(false);
            } else {
                this.wAVL.setVisible(false);
                this.wShortAVR.setVisible(false);
                this.wMedAVR.setVisible(false);
                this.wLongAVR.setVisible(false);
                this.wExtAVR.setVisible(false);
                this.wMinL.setVisible(true);
                this.wMinR.setVisible(true);
            }
            if (iGame.getOptions().booleanOption("maxtech_range") || this.entity instanceof Aero) {
                this.wExtL.setVisible(true);
                this.wExtR.setVisible(true);
            } else {
                this.wExtL.setVisible(false);
                this.wExtR.setVisible(false);
            }
            this.onResize();
        }

        public void selectWeapon(int n) {
            if (n == -1) {
                this.weaponList.setSelectedIndex(-1);
                return;
            }
            int n2 = this.entity.getWeaponList().indexOf(this.entity.getEquipment(n));
            this.weaponList.setSelectedIndex(n2);
            this.displaySelected();
        }

        public int getSelectedWeaponNum() {
            int n = this.weaponList.getSelectedIndex();
            if (n == -1) {
                return -1;
            }
            return this.entity.getEquipmentNum(this.entity.getWeaponList().get(n));
        }

        private void displaySelected() {
            int n;
            Object object;
            if (this.weaponList.getSelectedIndex() == -1) {
                ((DefaultComboBoxModel)this.m_chAmmo.getModel()).removeAllElements();
                this.m_chAmmo.setEnabled(false);
                this.m_chBayWeapon.removeAllItems();
                this.m_chBayWeapon.setEnabled(false);
                this.wNameR.setText("");
                this.wHeatR.setText("--");
                this.wArcHeatR.setText("---");
                this.wDamR.setText("--");
                this.wMinR.setText("---");
                this.wShortR.setText("---");
                this.wMedR.setText("---");
                this.wLongR.setText("---");
                this.wExtR.setText("---");
                return;
            }
            Mounted mounted = this.entity.getWeaponList().get(this.weaponList.getSelectedIndex());
            WeaponType weaponType = (WeaponType)mounted.getType();
            this.wNameR.setText(mounted.getDesc());
            this.wHeatR.setText(mounted.getCurrentHeat() + "");
            this.wArcHeatR.setText(Integer.toString(this.entity.getHeatInArc(mounted.getLocation(), mounted.isRearMounted())));
            if (weaponType.getDamage() == -2) {
                this.wDamR.setText(Messages.getString("MechDisplay.Missile"));
            } else if (weaponType.getDamage() == -3) {
                this.wDamR.setText(Messages.getString("MechDisplay.Variable"));
            } else if (weaponType.getDamage() == -4) {
                this.wDamR.setText(Messages.getString("MechDisplay.Special"));
            } else if (weaponType.getDamage() == -5) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(Integer.toString(weaponType.getRackSize())).append('/').append(Integer.toString(weaponType.getRackSize() / 2));
                this.wDamR.setText(stringBuffer.toString());
            } else {
                this.wDamR.setText(Integer.toString(weaponType.getDamage()));
            }
            int n2 = weaponType.getShortRange();
            int n3 = weaponType.getMediumRange();
            int n4 = weaponType.getLongRange();
            int n5 = weaponType.getExtremeRange();
            if (this.entity.getLocationStatus(mounted.getLocation()) == 2 || n4 == 0) {
                n2 = weaponType.getWShortRange();
                n3 = weaponType.getWMediumRange();
                n4 = weaponType.getWLongRange();
                n5 = weaponType.getWExtremeRange();
            }
            if (weaponType.getMinimumRange() > 0) {
                this.wMinR.setText(Integer.toString(weaponType.getMinimumRange()));
            } else {
                this.wMinR.setText("---");
            }
            if (n2 > 1) {
                this.wShortR.setText("1 - " + n2);
            } else {
                this.wShortR.setText("" + n2);
            }
            if (n3 - n2 > 1) {
                this.wMedR.setText(n2 + 1 + " - " + n3);
            } else {
                this.wMedR.setText("" + n3);
            }
            if (n4 - n3 > 1) {
                this.wLongR.setText(n3 + 1 + " - " + n4);
            } else {
                this.wLongR.setText("" + n4);
            }
            if (n5 - n4 > 1) {
                this.wExtR.setText(n4 + 1 + " - " + n5);
            } else {
                this.wExtR.setText("" + n5);
            }
            if (mounted.getLinked() != null) {
                this.updateRangeDisplayForAmmo(mounted.getLinked());
            }
            if (this.entity instanceof Aero) {
                if (weaponType.isCapital()) {
                    this.wDamR.setText(Messages.getString("MechDisplay.CapitalD"));
                } else {
                    this.wDamR.setText(Messages.getString("MechDisplay.StandardD"));
                }
                if (weaponType instanceof BayWeapon) {
                    this.compileWeaponBay(mounted.getBayWeapons(), weaponType.isCapital());
                } else {
                    this.updateAttackValues(weaponType, mounted.getLinked());
                }
            }
            boolean bl = MechDisplay.this.clientgui.getClient().getLocalPlayer().equals(this.entity.getOwner());
            int n6 = this.m_chBayWeapon.getSelectedIndex();
            this.m_chBayWeapon.removeAllItems();
            if (!(weaponType instanceof BayWeapon && bl && this.entity.usesWeaponBays())) {
                this.m_chBayWeapon.setEnabled(false);
            } else {
                this.m_chBayWeapon.setEnabled(true);
                object = mounted.getBayWeapons().iterator();
                while (object.hasNext()) {
                    n = (Integer)object.next();
                    Mounted mounted2 = this.entity.getEquipment(n);
                    if (null == mounted2) continue;
                    this.m_chBayWeapon.addItem(this.formatBayWeapon(mounted2));
                }
                if (n6 == -1) {
                    this.m_chBayWeapon.setSelectedIndex(0);
                } else {
                    this.m_chBayWeapon.setSelectedIndex(n6);
                }
            }
            ((DefaultComboBoxModel)this.m_chAmmo.getModel()).removeAllElements();
            object = mounted;
            if (weaponType instanceof BayWeapon) {
                n = this.m_chBayWeapon.getSelectedIndex();
                if (n == -1) {
                    n = 0;
                }
                mounted = this.entity.getEquipment(mounted.getBayWeapons().elementAt(n));
                weaponType = (WeaponType)mounted.getType();
            }
            if (weaponType.getAmmoType() == -1 || !bl) {
                this.m_chAmmo.setEnabled(false);
            } else if (weaponType.hasFlag(16384L)) {
                if (mounted.getLinked().getShotsLeft() == 1) {
                    this.m_chAmmo.addItem(this.formatAmmo(mounted.getLinked()));
                    this.m_chAmmo.setEnabled(true);
                } else {
                    this.m_chAmmo.setEnabled(false);
                }
            } else {
                if (!(this.entity instanceof Infantry)) {
                    this.m_chAmmo.setEnabled(true);
                } else {
                    this.m_chAmmo.setEnabled(false);
                }
                this.vAmmo = new ArrayList();
                n = -1;
                int n7 = 0;
                for (Mounted mounted3 : this.entity.getAmmo()) {
                    AmmoType ammoType = (AmmoType)mounted3.getType();
                    boolean bl2 = true;
                    if (this.entity instanceof SmallCraft || this.entity instanceof Jumpship) {
                        bl2 = mounted.getLocation() == mounted3.getLocation();
                    }
                    boolean bl3 = true;
                    if (this.entity.usesWeaponBays() && !(this.entity instanceof FighterSquadron)) {
                        bl3 = ((Mounted)object).ammoInBay(this.entity.getEquipmentNum(mounted3));
                    }
                    if (!mounted3.isAmmoUsable() || !bl2 || !bl3 || ammoType.getAmmoType() != weaponType.getAmmoType() || ammoType.getRackSize() != weaponType.getRackSize()) continue;
                    this.vAmmo.add(mounted3);
                    this.m_chAmmo.addItem(this.formatAmmo(mounted3));
                    if (mounted.getLinked().equals(mounted3)) {
                        n = n7;
                    }
                    ++n7;
                }
                if (n != -1) {
                    this.m_chAmmo.setSelectedIndex(n);
                }
            }
            MechDisplay.this.processMechDisplayEvent(new MechDisplayEvent(this, this.entity, mounted));
            this.onResize();
        }

        private String formatAmmo(Mounted mounted) {
            StringBuffer stringBuffer = new StringBuffer(64);
            int n = mounted.getDesc().indexOf(Messages.getString("MechDisplay.0"));
            int n2 = mounted.getLocation();
            if (n2 != -1) {
                stringBuffer.append('[').append(this.entity.getLocationAbbr(n2)).append("] ");
            }
            if (n == -1) {
                stringBuffer.append(mounted.getDesc());
            } else {
                stringBuffer.append(mounted.getDesc().substring(0, n));
                stringBuffer.append(mounted.getDesc().substring(n + 4));
            }
            return stringBuffer.toString();
        }

        private String formatBayWeapon(Mounted mounted) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(mounted.getDesc());
            return stringBuffer.toString();
        }

        private void updateRangeDisplayForAmmo(Mounted mounted) {
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (ammoType.getAmmoType() == 28) {
                if (ammoType.getMunitionType() == 64L) {
                    this.wMinR.setText("4");
                    this.wShortR.setText("1 - 9");
                    this.wMedR.setText("10 - 18");
                    this.wLongR.setText("19 - 27");
                    this.wExtR.setText("28 - 36");
                } else if (ammoType.getMunitionType() == 128L) {
                    this.wMinR.setText("---");
                    this.wShortR.setText("1 - 3");
                    this.wMedR.setText("4 - 6");
                    this.wLongR.setText("7 - 9");
                    this.wExtR.setText("10 - 12");
                } else {
                    this.wMinR.setText("4");
                    this.wShortR.setText("1 - 5");
                    this.wMedR.setText("6 - 10");
                    this.wLongR.setText("11 - 15");
                    this.wExtR.setText("16 - 20");
                }
            } else if (ammoType.getAmmoType() == 45) {
                if (ammoType.hasFlag(32L)) {
                    this.wMinR.setText("6");
                    this.wShortR.setText("1 - 7");
                    this.wMedR.setText("8 - 14");
                    this.wLongR.setText("15 - 21");
                    this.wExtR.setText("21 - 28");
                } else {
                    this.wMinR.setText("---");
                    this.wShortR.setText("1 - 3");
                    this.wMedR.setText("4 - 6");
                    this.wLongR.setText("7 - 9");
                    this.wExtR.setText("10 - 12");
                }
            }
            if (mounted.isHotLoaded()) {
                this.wMinR.setText("---");
            }
            this.onResize();
        }

        private void updateAttackValues(WeaponType weaponType, Mounted mounted) {
            int n = weaponType.getRoundShortAV();
            int n2 = weaponType.getRoundMedAV();
            int n3 = weaponType.getRoundLongAV();
            int n4 = weaponType.getRoundExtAV();
            int n5 = weaponType.getMaxRange();
            if (null != mounted) {
                AmmoType ammoType = (AmmoType)mounted.getType();
                double[] dArray = this.changeAttackValues(ammoType, n, n2, n3, n4, n5);
                n = (int)dArray[0];
                n2 = (int)dArray[1];
                n3 = (int)dArray[2];
                n4 = (int)dArray[3];
                n5 = (int)dArray[4];
            }
            this.wShortAVR.setText("---");
            this.wMedAVR.setText("---");
            this.wLongAVR.setText("---");
            this.wExtAVR.setText("---");
            this.wShortR.setText("---");
            this.wMedR.setText("---");
            this.wLongR.setText("---");
            this.wExtR.setText("---");
            this.wShortAVR.setText(Integer.toString(n));
            if (weaponType.isCapital()) {
                this.wShortR.setText("1-12");
            } else {
                this.wShortR.setText("1-6");
            }
            if (n5 > 1) {
                this.wMedAVR.setText(Integer.toString(n2));
                if (weaponType.isCapital()) {
                    this.wMedR.setText("13-24");
                } else {
                    this.wMedR.setText("7-12");
                }
            }
            if (n5 > 2) {
                this.wLongAVR.setText(Integer.toString(n3));
                if (weaponType.isCapital()) {
                    this.wLongR.setText("25-40");
                } else {
                    this.wLongR.setText("13-20");
                }
            }
            if (n5 > 3) {
                this.wExtAVR.setText(Integer.toString(n4));
                if (weaponType.isCapital()) {
                    this.wExtR.setText("41-50");
                } else {
                    this.wExtR.setText("21-25");
                }
            }
            this.onResize();
        }

        private double[] changeAttackValues(AmmoType ammoType, double d, double d2, double d3, double d4, int n) {
            int n2;
            if (28 == ammoType.getAmmoType()) {
                if (ammoType.getMunitionType() == 64L) {
                    n = 4;
                    d /= 2.0;
                    d3 = d2 /= 2.0;
                    d4 = d2;
                } else if (ammoType.getMunitionType() == 128L) {
                    n = 1;
                    d += d / 2.0;
                    d2 = 0.0;
                    d3 = 0.0;
                    d4 = 0.0;
                }
            } else if (ammoType.getAmmoType() == 45) {
                n2 = 0;
                if (ammoType.getMunitionType() == 4096L) {
                    int n3 = ammoType.getRackSize();
                    if (n3 == 5) {
                        ++n2;
                    } else if (n3 >= 7) {
                        n2 += 2;
                    }
                    d += (double)n2;
                    d2 += (double)n2;
                    d3 += (double)n2;
                }
                if (!ammoType.hasFlag(32L)) {
                    n = 1;
                    d *= 2.0;
                    d2 = 0.0;
                    d3 = 0.0;
                    d4 = 0.0;
                }
            } else if (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 9) {
                if (ammoType.getMunitionType() == 4096L) {
                    if (ammoType.getAmmoType() == 7) {
                        n2 = (int)Math.ceil((double)ammoType.getRackSize() / 5.0);
                        d += (double)n2;
                        d2 += (double)n2;
                        d3 += (double)n2;
                    }
                    if (ammoType.getAmmoType() == 9) {
                        d += 2.0;
                    }
                }
            } else if (ammoType.getAmmoType() == 19) {
                if (ammoType.getMunitionType() == 1L) {
                    n2 = (int)Math.floor(0.6 * (double)ammoType.getRackSize());
                    d = n2;
                    if (d2 > 0.0) {
                        d2 = n2;
                    }
                    if (d3 > 0.0) {
                        d3 = n2;
                    }
                    if (d4 > 0.0) {
                        d4 = n2;
                    }
                }
            } else if (ammoType.getAmmoType() == 61) {
                if (ammoType.hasFlag(128L)) {
                    d = 4.0;
                    d2 = 4.0;
                    d3 = 4.0;
                    d4 = 4.0;
                } else if (ammoType.hasFlag(64L)) {
                    d = 3.0;
                    d2 = 3.0;
                    d3 = 3.0;
                    d4 = 3.0;
                } else {
                    d = 2.0;
                    d2 = 2.0;
                    d3 = 2.0;
                    d4 = 2.0;
                }
            }
            double[] dArray = new double[]{d, d2, d3, d4, n};
            return dArray;
        }

        private void compileWeaponBay(Vector<Integer> vector, boolean bl) {
            RoundUpdated roundUpdated;
            this.wShortAVR.setText("---");
            this.wMedAVR.setText("---");
            this.wLongAVR.setText("---");
            this.wExtAVR.setText("---");
            this.wShortR.setText("---");
            this.wMedR.setText("---");
            this.wLongR.setText("---");
            this.wExtR.setText("---");
            int n = 0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            int n2 = 1;
            for (int n3 : vector) {
                roundUpdated = this.entity.getEquipment(n3);
                if (((Mounted)roundUpdated).isBreached() || ((Mounted)roundUpdated).isDestroyed() || ((Mounted)roundUpdated).isJammed() || ((Mounted)roundUpdated).getLinked() != null && ((Mounted)roundUpdated).getLinked().getShotsLeft() <= 0) continue;
                WeaponType weaponType = (WeaponType)((Mounted)roundUpdated).getType();
                n += ((Mounted)roundUpdated).getCurrentHeat();
                double d5 = weaponType.getShortAV();
                double d6 = weaponType.getMedAV();
                double d7 = weaponType.getLongAV();
                double d8 = weaponType.getExtAV();
                int n4 = weaponType.getMaxRange();
                if (null != ((Mounted)roundUpdated).getLinked()) {
                    double[] dArray = this.changeAttackValues((AmmoType)((Mounted)roundUpdated).getLinked().getType(), d5, d6, d7, d8, n4);
                    d5 = dArray[0];
                    d6 = dArray[1];
                    d7 = dArray[2];
                    d8 = dArray[3];
                    n4 = (int)dArray[4];
                }
                d += d5;
                d2 += d6;
                d3 += d7;
                d4 += d8;
                if (n4 <= n2) continue;
                n2 = n4;
            }
            double d9 = 1.0;
            if (this.entity instanceof FighterSquadron) {
                roundUpdated = (FighterSquadron)this.entity;
                d9 = (double)((FighterSquadron)roundUpdated).getNFighters() / (double)((FighterSquadron)roundUpdated).getN0Fighters();
            }
            d = d9 * d;
            d2 = d9 * d2;
            d3 = d9 * d3;
            d4 = d9 * d4;
            this.wHeatR.setText(Integer.toString(n));
            this.wShortAVR.setText(Integer.toString((int)Math.ceil(d)));
            if (bl) {
                this.wShortR.setText("1-12");
            } else {
                this.wShortR.setText("1-6");
            }
            if (n2 > 1) {
                this.wMedAVR.setText(Integer.toString((int)Math.ceil(d2)));
                if (bl) {
                    this.wMedR.setText("13-24");
                } else {
                    this.wMedR.setText("7-12");
                }
            }
            if (n2 > 2) {
                this.wLongAVR.setText(Integer.toString((int)Math.ceil(d3)));
                if (bl) {
                    this.wLongR.setText("25-40");
                } else {
                    this.wLongR.setText("13-20");
                }
            }
            if (n2 > 3) {
                this.wExtAVR.setText(Integer.toString((int)Math.ceil(d4)));
                if (bl) {
                    this.wExtR.setText("41-50");
                } else {
                    this.wExtR.setText("21-25");
                }
            }
            this.onResize();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getItemSelectable().equals(this.m_chAmmo) && this.m_chAmmo.getItemCount() > 0) {
                Mounted mounted;
                int n = this.weaponList.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                Mounted mounted2 = mounted = this.entity.getWeaponList().get(n);
                boolean bl = false;
                if (mounted.getType() instanceof BayWeapon) {
                    bl = true;
                    n = this.m_chBayWeapon.getSelectedIndex();
                    if (n == -1) {
                        return;
                    }
                    mounted = this.entity.getEquipment(mounted.getBayWeapons().elementAt(n));
                }
                Mounted mounted3 = mounted.getLinked();
                Mounted mounted4 = this.vAmmo.get(this.m_chAmmo.getSelectedIndex());
                this.entity.loadWeapon(mounted, mounted4);
                if ((mounted3 == null || !mounted3.isHotLoaded()) && mounted4.isHotLoaded() || mounted3 != null && mounted3.isHotLoaded() && !mounted4.isHotLoaded()) {
                    this.displayMech(this.entity);
                    this.weaponList.setSelectedIndex(n);
                    this.displaySelected();
                }
                this.updateRangeDisplayForAmmo(mounted4);
                if (this.entity instanceof Aero) {
                    WeaponType weaponType = (WeaponType)mounted.getType();
                    if (bl) {
                        this.compileWeaponBay(mounted2.getBayWeapons(), weaponType.isCapital());
                    } else {
                        this.updateAttackValues(weaponType, mounted4);
                    }
                }
                if (((MechDisplay)MechDisplay.this).clientgui.curPanel instanceof FiringDisplay) {
                    ((FiringDisplay)((MechDisplay)MechDisplay.this).clientgui.curPanel).updateTarget();
                } else if (((MechDisplay)MechDisplay.this).clientgui.curPanel instanceof TargetingPhaseDisplay) {
                    ((TargetingPhaseDisplay)((MechDisplay)MechDisplay.this).clientgui.curPanel).updateTarget();
                }
                MechDisplay.this.clientgui.getClient().sendAmmoChange(this.entity.getId(), this.entity.getEquipmentNum(mounted), this.entity.getEquipmentNum(mounted4));
            } else if (itemEvent.getItemSelectable().equals(this.m_chBayWeapon) && this.m_chBayWeapon.getItemCount() > 0) {
                int n = this.weaponList.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                this.displaySelected();
            }
            this.onResize();
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource().equals(this.weaponList)) {
                this.m_chBayWeapon.removeAllItems();
                this.displaySelected();
            }
            this.onResize();
        }
    }

    private class ArmorPanel
    extends PicMap {
        private static final long serialVersionUID = -3612396252172441104L;
        private TankMapSet tank;
        private MechMapSet mech;
        private InfantryMapSet infantry;
        private BattleArmorMapSet battleArmor;
        private ProtomechMapSet proto;
        private VTOLMapSet vtol;
        private QuadMapSet quad;
        private GunEmplacementMapSet gunEmplacement;
        private ArmlessMechMapSet armless;
        private LargeSupportTankMapSet largeSupportTank;
        private AeroMapSet aero;
        private SquadronMapSet squad;
        private JumpshipMapSet jump;
        private SpheroidMapSet sphere;
        private WarshipMapSet warship;
        private int minTopMargin;
        private int minLeftMargin;
        private int minBottomMargin;
        private int minRightMargin;
        private static final int minTankTopMargin = 8;
        private static final int minTankLeftMargin = 8;
        private static final int minVTOLTopMargin = 8;
        private static final int minVTOLLeftMargin = 8;
        private static final int minMechTopMargin = 18;
        private static final int minMechLeftMargin = 7;
        private static final int minMechBottomMargin = 0;
        private static final int minMechRightMargin = 0;
        private static final int minInfTopMargin = 8;
        private static final int minInfLeftMargin = 8;
        private static final int minAeroTopMargin = 8;
        private static final int minAeroLeftMargin = 8;

        private ArmorPanel() {
        }

        public void addNotify() {
            super.addNotify();
            this.tank = new TankMapSet(this);
            this.mech = new MechMapSet(this);
            this.infantry = new InfantryMapSet(this);
            this.battleArmor = new BattleArmorMapSet(this);
            this.proto = new ProtomechMapSet(this);
            this.vtol = new VTOLMapSet(this);
            this.quad = new QuadMapSet(this);
            this.gunEmplacement = new GunEmplacementMapSet(this);
            this.armless = new ArmlessMechMapSet(this);
            this.largeSupportTank = new LargeSupportTankMapSet(this);
            this.aero = new AeroMapSet(this);
            this.sphere = new SpheroidMapSet(this);
            this.jump = new JumpshipMapSet(this);
            this.warship = new WarshipMapSet(this);
            this.squad = new SquadronMapSet(this);
        }

        public void onResize() {
            Rectangle rectangle = this.getContentBounds();
            if (rectangle == null) {
                return;
            }
            int n = Math.round((this.getSize().width - rectangle.width) / 2);
            int n2 = Math.round((this.getSize().height - rectangle.height) / 2);
            int n3 = n < this.minLeftMargin ? this.minLeftMargin : n;
            int n4 = n2 < this.minTopMargin ? this.minTopMargin : n2;
            this.setContentMargins(n3, n4, this.minRightMargin, this.minBottomMargin);
        }

        public void displayMech(Entity entity) {
            Object object;
            if (entity == null) {
                return;
            }
            DisplayMapSet displayMapSet = this.mech;
            this.removeAll();
            if (entity instanceof QuadMech) {
                displayMapSet = this.quad;
                this.minLeftMargin = 7;
                this.minTopMargin = 18;
                this.minBottomMargin = 0;
                this.minRightMargin = 0;
            } else if (entity instanceof ArmlessMech) {
                displayMapSet = this.armless;
                this.minLeftMargin = 7;
                this.minTopMargin = 18;
                this.minBottomMargin = 0;
                this.minRightMargin = 0;
            } else if (entity instanceof Mech) {
                displayMapSet = this.mech;
                this.minLeftMargin = 7;
                this.minTopMargin = 18;
                this.minBottomMargin = 0;
                this.minRightMargin = 0;
            } else if (entity instanceof VTOL) {
                displayMapSet = this.vtol;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof LargeSupportTank) {
                displayMapSet = this.largeSupportTank;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof Tank) {
                displayMapSet = this.tank;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof BattleArmor) {
                displayMapSet = this.battleArmor;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof Infantry) {
                displayMapSet = this.infantry;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof Protomech) {
                displayMapSet = this.proto;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof GunEmplacement) {
                displayMapSet = this.gunEmplacement;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof Warship) {
                displayMapSet = this.warship;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof Jumpship) {
                displayMapSet = this.jump;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof FighterSquadron) {
                displayMapSet = this.squad;
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            } else if (entity instanceof Aero) {
                displayMapSet = this.aero;
                if (entity instanceof SmallCraft && ((Aero)(object = (SmallCraft)entity)).isSpheroid()) {
                    displayMapSet = this.sphere;
                }
                this.minLeftMargin = 8;
                this.minTopMargin = 8;
                this.minBottomMargin = 8;
                this.minRightMargin = 8;
            }
            if (displayMapSet == null) {
                System.err.println("The armor panel is null.");
                return;
            }
            displayMapSet.setEntity(entity);
            this.addElement(displayMapSet.getContentGroup());
            object = displayMapSet.getBackgroundDrawers().elements();
            while (object.hasMoreElements()) {
                this.addBgDrawer(object.nextElement());
            }
            this.onResize();
            this.update();
        }
    }

    private class MovementPanel
    extends PicMap {
        private static final long serialVersionUID = 8284603003897415518L;
        private GeneralInfoMapSet gi = new GeneralInfoMapSet(this);
        private int minTopMargin = 8;
        private int minLeftMargin = 8;

        MovementPanel() {
            this.addElement(this.gi.getContentGroup());
            Enumeration<BackGroundDrawer> enumeration = this.gi.getBackgroundDrawers().elements();
            while (enumeration.hasMoreElements()) {
                this.addBgDrawer(enumeration.nextElement());
            }
            this.onResize();
        }

        public void addNotify() {
            super.addNotify();
            this.update();
        }

        public void onResize() {
            int n = this.getSize().width;
            Rectangle rectangle = this.getContentBounds();
            int n2 = Math.round((n - rectangle.width) / 2);
            if (n2 < this.minLeftMargin) {
                n2 = this.minLeftMargin;
            }
            int n3 = this.minTopMargin;
            this.setContentMargins(n2, n3, n2, n3);
        }

        public void displayMech(Entity entity) {
            this.gi.setEntity(entity);
            this.onResize();
            this.update();
        }
    }
}

