/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import megamek.client.Client;
import megamek.client.ui.swing.ClientGUI;
import megamek.client.ui.swing.Messages;
import megamek.common.Entity;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.TechConstants;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.util.RandomArmyCreator;

public class RandomArmyDialog
extends JDialog
implements ActionListener,
WindowListener {
    private static final long serialVersionUID = 4072453002423681675L;
    private ClientGUI m_clientgui;
    private Client m_client;
    private boolean includeMaxTech;
    private JLabel m_labelPlayer = new JLabel(Messages.getString("RandomArmyDialog.Player"), 4);
    private JComboBox m_chPlayer = new JComboBox();
    private JComboBox m_chType = new JComboBox();
    private JPanel m_pParameters = new JPanel();
    private JPanel m_pPreview = new JPanel();
    private JPanel m_pButtons = new JPanel();
    private JButton m_bOK = new JButton(Messages.getString("Okay"));
    private JButton m_bCancel = new JButton(Messages.getString("Cancel"));
    private JButton m_bRoll = new JButton(Messages.getString("RandomArmyDialog.Roll"));
    private JList m_lMechs = new JList();
    private JLabel m_labBV = new JLabel(Messages.getString("RandomArmyDialog.BV"));
    private JLabel m_labYear = new JLabel(Messages.getString("RandomArmyDialog.Year"));
    private JLabel m_labMechs = new JLabel(Messages.getString("RandomArmyDialog.Mechs"));
    private JLabel m_labVees = new JLabel(Messages.getString("RandomArmyDialog.Vees"));
    private JLabel m_labBA = new JLabel(Messages.getString("RandomArmyDialog.BA"));
    private JLabel m_labInfantry = new JLabel(Messages.getString("RandomArmyDialog.Infantry"));
    private JLabel m_labTech = new JLabel(Messages.getString("RandomArmyDialog.Tech"));
    private JTextField m_tBVmin = new JTextField(6);
    private JTextField m_tBVmax = new JTextField(6);
    private JTextField m_tMinYear = new JTextField(4);
    private JTextField m_tMaxYear = new JTextField(4);
    private JTextField m_tMechs = new JTextField(3);
    private JTextField m_tVees = new JTextField(3);
    private JTextField m_tBA = new JTextField(3);
    private JTextField m_tInfantry = new JTextField(3);
    private JCheckBox m_chkPad = new JCheckBox(Messages.getString("RandomArmyDialog.Pad"));
    private JCheckBox m_chkCanon = new JCheckBox(Messages.getString("RandomArmyDialog.Canon"));
    private ArrayList<MechSummary> army = new ArrayList(0);

    public RandomArmyDialog(ClientGUI clientGUI) {
        super(clientGUI.frame, Messages.getString("RandomArmyDialog.title"), true);
        this.m_clientgui = clientGUI;
        this.m_client = clientGUI.getClient();
        this.updatePlayerChoice();
        this.m_tMechs.setText("4");
        this.m_tBVmin.setText("5800");
        this.m_tBVmax.setText("6000");
        this.m_tVees.setText("0");
        this.m_tBA.setText("0");
        this.m_tMinYear.setText("2500");
        this.m_tMaxYear.setText("3100");
        this.m_tInfantry.setText("0");
        this.m_chkCanon.setSelected(this.m_client.game.getOptions().booleanOption("canon_only"));
        this.updateTechChoice(true);
        this.m_pButtons.setLayout(new FlowLayout(1));
        this.m_pButtons.add(this.m_bOK);
        this.m_bOK.addActionListener(this);
        this.m_pButtons.add(this.m_bRoll);
        this.m_bRoll.addActionListener(this);
        this.m_pButtons.add(this.m_bCancel);
        this.m_bCancel.addActionListener(this);
        this.m_pButtons.add(this.m_labelPlayer);
        this.m_pButtons.add(this.m_chPlayer);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_pParameters.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_labTech, gridBagConstraints);
        this.m_pParameters.add(this.m_labTech);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.m_chType, gridBagConstraints);
        this.m_pParameters.add(this.m_chType);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.m_labBV, gridBagConstraints);
        this.m_pParameters.add(this.m_labBV);
        this.m_pParameters.add(this.m_tBVmin);
        JLabel jLabel = new JLabel("-");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.m_pParameters.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.m_tBVmax, gridBagConstraints);
        this.m_pParameters.add(this.m_tBVmax);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.m_labMechs, gridBagConstraints);
        this.m_pParameters.add(this.m_labMechs);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.m_tMechs, gridBagConstraints);
        this.m_pParameters.add(this.m_tMechs);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.m_labVees, gridBagConstraints);
        this.m_pParameters.add(this.m_labVees);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.m_tVees, gridBagConstraints);
        this.m_pParameters.add(this.m_tVees);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.m_labBA, gridBagConstraints);
        this.m_pParameters.add(this.m_labBA);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.m_tBA, gridBagConstraints);
        this.m_pParameters.add(this.m_tBA);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.m_labInfantry, gridBagConstraints);
        this.m_pParameters.add(this.m_labInfantry);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.m_tInfantry, gridBagConstraints);
        this.m_pParameters.add(this.m_tInfantry);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.m_labYear, gridBagConstraints);
        this.m_pParameters.add(this.m_labYear);
        gridBagLayout.setConstraints(this.m_tMinYear, gridBagConstraints);
        this.m_pParameters.add(this.m_tMinYear);
        jLabel = new JLabel("-");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.m_pParameters.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.m_tMaxYear, gridBagConstraints);
        this.m_pParameters.add(this.m_tMaxYear);
        gridBagLayout.setConstraints(this.m_chkPad, gridBagConstraints);
        this.m_pParameters.add(this.m_chkPad);
        gridBagLayout.setConstraints(this.m_chkCanon, gridBagConstraints);
        this.m_pParameters.add(this.m_chkCanon);
        this.m_pPreview.setLayout(new GridLayout(1, 1));
        JScrollPane jScrollPane = new JScrollPane(this.m_lMechs);
        this.m_pPreview.add(jScrollPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_pButtons, "South");
        this.add((Component)this.m_pParameters, "West");
        this.add((Component)this.m_pPreview, "East");
        this.validate();
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.m_bOK)) {
            for (MechSummary mechSummary : this.army) {
                try {
                    Entity entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
                    Client client = null;
                    if (this.m_chPlayer.getSelectedIndex() > 0) {
                        String string = (String)this.m_chPlayer.getSelectedItem();
                        client = this.m_clientgui.getBots().get(string);
                    }
                    if (client == null) {
                        client = this.m_client;
                    }
                    entity.setOwner(client.getLocalPlayer());
                    client.sendAddEntity(entity);
                }
                catch (EntityLoadingException entityLoadingException) {
                    System.out.println("Unable to load mech: " + mechSummary.getSourceFile() + ": " + mechSummary.getEntryName() + ": " + entityLoadingException.getMessage());
                    entityLoadingException.printStackTrace();
                    return;
                }
            }
            this.setVisible(false);
        } else if (actionEvent.getSource().equals(this.m_bCancel)) {
            this.setVisible(false);
        } else if (actionEvent.getSource().equals(this.m_bRoll)) {
            try {
                RandomArmyCreator.Parameters parameters = new RandomArmyCreator.Parameters();
                parameters.mechs = Integer.parseInt(this.m_tMechs.getText());
                parameters.tanks = Integer.parseInt(this.m_tVees.getText());
                parameters.ba = Integer.parseInt(this.m_tBA.getText());
                parameters.infantry = Integer.parseInt(this.m_tInfantry.getText());
                parameters.canon = this.m_chkCanon.isSelected();
                parameters.maxBV = Integer.parseInt(this.m_tBVmax.getText());
                parameters.minBV = Integer.parseInt(this.m_tBVmin.getText());
                parameters.padWithInfantry = this.m_chkPad.isSelected();
                parameters.tech = this.m_chType.getSelectedIndex();
                parameters.minYear = Integer.parseInt(this.m_tMinYear.getText());
                parameters.maxYear = Integer.parseInt(this.m_tMaxYear.getText());
                this.army = RandomArmyCreator.generateArmy(parameters);
                Vector<String> vector = new Vector<String>();
                for (MechSummary mechSummary : this.army) {
                    vector.add(mechSummary.getName());
                }
                this.m_lMechs.setListData(vector);
                this.m_lMechs.validate();
                this.pack();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private void updatePlayerChoice() {
        String string = (String)this.m_chPlayer.getSelectedItem();
        String string2 = this.m_clientgui.getClient().getName();
        this.m_chPlayer.removeAllItems();
        this.m_chPlayer.setEnabled(true);
        this.m_chPlayer.addItem(string2);
        Iterator<Client> iterator = this.m_clientgui.getBots().values().iterator();
        while (iterator.hasNext()) {
            this.m_chPlayer.addItem(iterator.next().getName());
        }
        if (this.m_chPlayer.getItemCount() == 1) {
            this.m_chPlayer.setEnabled(false);
        }
        this.m_chPlayer.setSelectedItem(string);
        if (this.m_chPlayer.getSelectedIndex() < 0) {
            this.m_chPlayer.setSelectedIndex(0);
        }
    }

    private void updateTechChoice(boolean bl) {
        int n;
        boolean bl2 = this.m_client.game.getOptions().booleanOption("allow_level_3_units");
        int n2 = n = bl2 ? TechConstants.SIZE : 5;
        if (this.includeMaxTech == bl2 && !bl) {
            return;
        }
        this.includeMaxTech = bl2;
        this.m_chType.removeAll();
        for (int i = 0; i < n; ++i) {
            this.m_chType.addItem(TechConstants.getLevelDisplayableName(i));
        }
        if (bl2) {
            this.m_chType.setSelectedItem(5);
        } else {
            this.m_chType.setSelectedItem(1);
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.updatePlayerChoice();
            this.updateTechChoice(false);
        }
        super.setVisible(bl);
    }
}

