/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.common.Entity;
import megamek.common.Mounted;
import megamek.common.actions.TriggerAPPodAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerAPPodDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -9009039614015364943L;
    private JButton butOkay = new JButton(Messages.getString("Okay"));
    private JTextArea labMessage;
    private ArrayList<TriggerPodTracker> trackers = new ArrayList();
    private int entityId = -1;

    public TriggerAPPodDialog(JFrame jFrame, Entity entity) {
        super(jFrame, Messages.getString("TriggerAPPodDialog.title"), true);
        Serializable serializable;
        this.entityId = entity.getId();
        this.labMessage = new JTextArea(Messages.getString("TriggerAPPodDialog.selectPodsToTrigger", new Object[]{entity.getDisplayName()}));
        this.labMessage.setEditable(false);
        this.labMessage.setOpaque(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        for (Mounted serializable22 : entity.getMisc()) {
            if (!serializable22.getType().hasFlag(0x2000000L)) continue;
            serializable = new StringBuffer();
            serializable.append(entity.getLocationName(serializable22.getLocation())).append(' ').append(serializable22.getName());
            JCheckBox bl = new JCheckBox(serializable.toString());
            jPanel.add(bl);
            if (serializable22.canFire()) {
                TriggerPodTracker triggerPodTracker = new TriggerPodTracker(bl, entity.getEquipmentNum(serializable22));
                this.trackers.add(triggerPodTracker);
                continue;
            }
            bl.setEnabled(false);
        }
        this.butOkay.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.labMessage, gridBagConstraints);
        this.getContentPane().add(this.labMessage);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.getContentPane().add(jPanel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagLayout.setConstraints(this.butOkay, gridBagConstraints);
        this.getContentPane().add(this.butOkay);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TriggerAPPodDialog.this.setVisible(false);
            }
        });
        this.pack();
        serializable = this.getSize();
        boolean bl = false;
        if (((Dimension)serializable).width < GUIPreferences.getInstance().getMinimumSizeWidth()) {
            ((Dimension)serializable).width = GUIPreferences.getInstance().getMinimumSizeWidth();
        }
        if (((Dimension)serializable).height < GUIPreferences.getInstance().getMinimumSizeHeight()) {
            ((Dimension)serializable).height = GUIPreferences.getInstance().getMinimumSizeHeight();
        }
        if (bl) {
            this.setSize((Dimension)serializable);
            serializable = this.getSize();
        }
        this.setResizable(false);
        this.setLocation(jFrame.getLocation().x + jFrame.getSize().width / 2 - ((Dimension)serializable).width / 2, jFrame.getLocation().y + jFrame.getSize().height / 2 - ((Dimension)serializable).height / 2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public Enumeration<TriggerAPPodAction> getActions() {
        Vector<TriggerAPPodAction> vector = new Vector<TriggerAPPodAction>();
        for (TriggerPodTracker triggerPodTracker : this.trackers) {
            if (!triggerPodTracker.isTriggered()) continue;
            vector.addElement(new TriggerAPPodAction(this.entityId, triggerPodTracker.getNum()));
        }
        return vector.elements();
    }

    private class TriggerPodTracker {
        private int podNum = -1;
        private JCheckBox checkbox;

        public TriggerPodTracker(JCheckBox jCheckBox, int n) {
            this.podNum = n;
            this.checkbox = jCheckBox;
        }

        public boolean isTriggered() {
            return this.checkbox.isSelected();
        }

        public int getNum() {
            return this.podNum;
        }
    }
}

