/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.util.Vector;
import javax.swing.JComponent;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.widget.BackGroundDrawer;
import megamek.client.ui.swing.widget.DisplayMapSet;
import megamek.client.ui.swing.widget.PMAreasGroup;
import megamek.client.ui.swing.widget.PMPicPolygonalArea;
import megamek.client.ui.swing.widget.PMSimpleLabel;
import megamek.client.ui.swing.widget.PMSimplePolygonArea;
import megamek.client.ui.swing.widget.PMUtil;
import megamek.client.ui.swing.widget.PMValueLabel;
import megamek.client.ui.swing.widget.WidgetUtils;
import megamek.common.Entity;
import megamek.common.Mech;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArmlessMechMapSet
implements DisplayMapSet {
    private static final String IMAGE_DIR = "data/images/widgets";
    private static final int REAR_AREA_OFFSET = 7;
    private static final int INT_STRUCTURE_OFFSET = 11;
    private PMSimplePolygonArea[] areas = new PMSimplePolygonArea[19];
    private PMSimpleLabel[] labels = new PMSimpleLabel[19];
    private PMValueLabel[] vLabels = new PMValueLabel[20];
    private PMPicPolygonalArea heatHotArea;
    private Vector<BackGroundDrawer> bgDrawers = new Vector();
    private PMAreasGroup content = new PMAreasGroup();
    private JComponent comp;
    private Polygon head = new Polygon(new int[]{53, 71, 81, 83, 83, 62, 41, 41, 43}, new int[]{32, 32, 22, 22, 8, 0, 8, 22, 22}, 9);
    private Polygon centralTorso = new Polygon(new int[]{48, 54, 70, 76, 76, 48}, new int[]{45, 85, 85, 45, 36, 36}, 6);
    private Polygon leftTorso = new Polygon(new int[]{54, 48, 48, 62, 62, 53, 43, 41, 41, 31, 29, 27, 25, 26, 47}, new int[]{82, 45, 36, 36, 32, 32, 22, 22, 20, 25, 27, 33, 37, 47, 82}, 15);
    private Polygon rightTorso = new Polygon(new int[]{70, 76, 76, 62, 62, 71, 81, 83, 83, 93, 95, 97, 99, 98, 77}, new int[]{82, 45, 36, 36, 32, 32, 22, 22, 20, 25, 27, 33, 37, 47, 82}, 15);
    private Polygon leftLeg = new Polygon(new int[]{0, 7, 37, 47, 54, 54, 61, 34, 40, 40, 34, 33, 7, 6, 0}, new int[]{104, 104, 65, 82, 82, 85, 85, 102, 104, 121, 123, 129, 129, 122, 122}, 15);
    private Polygon rightLeg = new Polygon(new int[]{125, 118, 88, 77, 70, 70, 64, 91, 85, 85, 91, 92, 118, 119, 125}, new int[]{104, 104, 63, 82, 82, 85, 85, 102, 104, 121, 123, 129, 129, 122, 122}, 15);
    private Polygon rearLeftTorso = new Polygon(new int[]{142, 142, 148, 139, 123, 123, 142}, new int[]{14, 43, 76, 76, 44, 17, 14}, 7);
    private Polygon rearCentralTorso = new Polygon(new int[]{142, 148, 162, 168, 168, 142}, new int[]{44, 76, 76, 44, 14, 14}, 6);
    private Polygon rearRightTorso = new Polygon(new int[]{168, 168, 162, 171, 187, 187, 168}, new int[]{14, 43, 76, 76, 44, 17, 14}, 7);
    private Polygon intStHead = new Polygon(new int[]{78, 48, 48, 78}, new int[]{149, 149, 127, 127}, 4);
    private Polygon inStCentralTorso = new Polygon(new int[]{75, 75, 51, 51}, new int[]{203, 149, 149, 203}, 4);
    private Polygon inStLeftTorso = new Polygon(new int[]{32, 32, 51, 51}, new int[]{188, 160, 160, 193}, 4);
    private Polygon inStRightTorso = new Polygon(new int[]{94, 94, 75, 75}, new int[]{188, 160, 160, 193}, 4);
    private Polygon inStLeftLeg = new Polygon(new int[]{51, 51, 44, 44, 47, 47, 20, 20, 41, 41, 44, 44}, new int[]{195, 199, 199, 206, 206, 230, 230, 206, 206, 192, 192, 195}, 12);
    private Polygon inStRightLeg = new Polygon(new int[]{75, 75, 82, 82, 79, 79, 106, 106, 85, 85, 82, 82}, new int[]{195, 199, 199, 206, 206, 230, 230, 206, 206, 192, 192, 195}, 12);
    private Polygon heatControl = new Polygon(new int[]{149, 159, 159, 149}, new int[]{100, 100, 220, 220}, 4);
    private Image heatImage;
    private static final Font FONT_LABEL = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorSmallFontSize"));
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayArmorLargeFontSize"));

    public ArmlessMechMapSet(JComponent jComponent) {
        this.comp = jComponent;
        this.setAreas();
        this.setLabels();
        this.setGroups();
        this.setBackGround();
    }

    @Override
    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    @Override
    public Vector<BackGroundDrawer> getBackgroundDrawers() {
        return this.bgDrawers;
    }

    @Override
    public void setEntity(Entity entity) {
        Mech mech = (Mech)entity;
        boolean bl = false;
        if (entity.getGame() != null && entity.getGame().getOptions().booleanOption("maxtech_heat")) {
            bl = true;
        }
        int n = 1;
        int n2 = 1;
        for (int i = 0; i < mech.locations(); ++i) {
            if (i == 5 || i == 4) continue;
            n = mech.getArmor(i);
            n2 = mech.getOArmor(i);
            this.vLabels[i].setValue(mech.getArmorString(i));
            WidgetUtils.setAreaColor(this.areas[i], this.vLabels[i], (double)n / (double)n2);
            if (mech.hasRearArmor(i)) {
                n = mech.getArmor(i, true);
                n2 = mech.getOArmor(i, true);
                this.vLabels[i + 7].setValue(mech.getArmorString(i, true));
                WidgetUtils.setAreaColor(this.areas[i + 7], this.vLabels[i + 7], (double)n / (double)n2);
            }
            n = mech.getInternal(i);
            n2 = mech.getOInternal(i);
            this.vLabels[i + 11].setValue(mech.getInternalString(i));
            WidgetUtils.setAreaColor(this.areas[i + 11], this.vLabels[i + 11], (double)n / (double)n2);
        }
        this.vLabels[19].setValue(Integer.toString(mech.heat));
        this.drawHeatControl(mech.heat, bl);
    }

    private void setAreas() {
        this.areas[0] = new PMSimplePolygonArea(this.head);
        this.areas[1] = new PMSimplePolygonArea(this.centralTorso);
        this.areas[2] = new PMSimplePolygonArea(this.rightTorso);
        this.areas[3] = new PMSimplePolygonArea(this.leftTorso);
        this.areas[6] = new PMSimplePolygonArea(this.rightLeg);
        this.areas[7] = new PMSimplePolygonArea(this.leftLeg);
        this.areas[8] = new PMSimplePolygonArea(this.rearCentralTorso);
        this.areas[9] = new PMSimplePolygonArea(this.rearRightTorso);
        this.areas[10] = new PMSimplePolygonArea(this.rearLeftTorso);
        this.areas[11] = new PMSimplePolygonArea(this.intStHead);
        this.areas[12] = new PMSimplePolygonArea(this.inStCentralTorso);
        this.areas[13] = new PMSimplePolygonArea(this.inStRightTorso);
        this.areas[14] = new PMSimplePolygonArea(this.inStLeftTorso);
        this.areas[17] = new PMSimplePolygonArea(this.inStRightLeg);
        this.areas[18] = new PMSimplePolygonArea(this.inStLeftLeg);
        this.heatImage = this.comp.createImage(10, 120);
        this.drawHeatControl(0);
        this.heatHotArea = new PMPicPolygonalArea(this.heatControl, this.heatImage);
    }

    private void setLabels() {
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_LABEL);
        this.labels[0] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_H"), fontMetrics, Color.black, 62, 6);
        this.labels[3] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_LT"), fontMetrics, Color.black, 41, 52);
        this.labels[1] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_CT"), fontMetrics, Color.black, 62, 42);
        this.labels[2] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_RT"), fontMetrics, Color.black, 84, 52);
        this.labels[7] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_LL"), fontMetrics, Color.black, 28, 92);
        this.labels[6] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_RL"), fontMetrics, Color.black, 98, 92);
        this.labels[10] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_LT"), fontMetrics, Color.black, 133, 39);
        this.labels[8] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_CT"), fontMetrics, Color.black, 156, 25);
        this.labels[9] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_RT"), fontMetrics, Color.black, 178, 39);
        this.labels[11] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_H"), fontMetrics, Color.black, 63, 130);
        this.labels[14] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_LT"), fontMetrics, Color.black, 42, 166);
        this.labels[12] = WidgetUtils.createLabel(Messages.getString("MechMapSet.L_CT"), fontMetrics, Color.black, 63, 168);
        this.labels[13] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_RT"), fontMetrics, Color.black, 85, 166);
        this.labels[18] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_LL"), fontMetrics, Color.black, 33, 210);
        this.labels[17] = WidgetUtils.createLabel(Messages.getString("MechMapSet.l_RL"), fontMetrics, Color.black, 93, 210);
        fontMetrics = this.comp.getFontMetrics(FONT_VALUE);
        this.vLabels[0] = WidgetUtils.createValueLabel(62, 22, "", fontMetrics);
        this.vLabels[3] = WidgetUtils.createValueLabel(38, 44, "", fontMetrics);
        this.vLabels[1] = WidgetUtils.createValueLabel(62, 57, "", fontMetrics);
        this.vLabels[2] = WidgetUtils.createValueLabel(86, 44, "", fontMetrics);
        this.vLabels[7] = WidgetUtils.createValueLabel(23, 113, "", fontMetrics);
        this.vLabels[6] = WidgetUtils.createValueLabel(102, 113, "", fontMetrics);
        this.vLabels[10] = WidgetUtils.createValueLabel(132, 28, "", fontMetrics);
        this.vLabels[8] = WidgetUtils.createValueLabel(156, 39, "", fontMetrics);
        this.vLabels[9] = WidgetUtils.createValueLabel(177, 28, "", fontMetrics);
        this.vLabels[11] = WidgetUtils.createValueLabel(63, 142, "", fontMetrics);
        this.vLabels[14] = WidgetUtils.createValueLabel(42, 180, "", fontMetrics);
        this.vLabels[12] = WidgetUtils.createValueLabel(63, 182, "", fontMetrics);
        this.vLabels[13] = WidgetUtils.createValueLabel(85, 180, "", fontMetrics);
        this.vLabels[18] = WidgetUtils.createValueLabel(33, 223, "", fontMetrics);
        this.vLabels[17] = WidgetUtils.createValueLabel(92, 223, "", fontMetrics);
        this.vLabels[19] = WidgetUtils.createValueLabel(155, 90, "", fontMetrics);
    }

    private void setGroups() {
        int n;
        PMAreasGroup pMAreasGroup = new PMAreasGroup();
        PMAreasGroup pMAreasGroup2 = new PMAreasGroup();
        PMAreasGroup pMAreasGroup3 = new PMAreasGroup();
        PMAreasGroup pMAreasGroup4 = new PMAreasGroup();
        for (n = 0; n < 8; ++n) {
            if (n == 5 || n == 4) continue;
            pMAreasGroup.addArea(this.areas[n]);
            pMAreasGroup.addArea(this.labels[n]);
            pMAreasGroup.addArea(this.vLabels[n]);
        }
        for (n = 0; n < 3; ++n) {
            pMAreasGroup2.addArea(this.areas[8 + n]);
            pMAreasGroup2.addArea(this.labels[8 + n]);
            pMAreasGroup2.addArea(this.vLabels[8 + n]);
        }
        for (n = 0; n < 8; ++n) {
            if (n == 5 || n == 4) continue;
            pMAreasGroup3.addArea(this.areas[11 + n]);
            pMAreasGroup3.addArea(this.labels[11 + n]);
            pMAreasGroup3.addArea(this.vLabels[11 + n]);
        }
        pMAreasGroup4.addArea(this.heatHotArea);
        pMAreasGroup4.addArea(this.vLabels[19]);
        pMAreasGroup.translate(7, 18);
        pMAreasGroup2.translate(19, 20);
        pMAreasGroup3.translate(6, 42);
        pMAreasGroup4.translate(20, 52);
        for (n = 0; n < 19; ++n) {
            if (n == 5 || n == 4) continue;
            this.content.addArea(this.areas[n]);
            this.content.addArea(this.labels[n]);
            this.content.addArea(this.vLabels[n]);
        }
        this.content.addArea(this.heatHotArea);
        this.content.addArea(this.vLabels[19]);
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        image = this.comp.getToolkit().getImage("data/images/widgets/bg_mech.gif");
        PMUtil.setImage(image, this.comp);
        n = 545;
        BackGroundDrawer backGroundDrawer = new BackGroundDrawer(image, n);
        this.bgDrawers.addElement(backGroundDrawer);
    }

    private void drawHeatControl(int n) {
        this.drawHeatControl(n, false);
    }

    private void drawHeatControl(int n, boolean bl) {
        int n2;
        int n3;
        int n4 = 0;
        if (bl) {
            n3 = 50;
            n2 = 2;
        } else {
            n3 = 30;
            n2 = 4;
        }
        Graphics graphics = this.heatImage.getGraphics();
        for (int i = 0; i < n3; ++i) {
            n4 = 120 - (i + 1) * n2;
            if (i < n) {
                graphics.setColor(Color.red);
            } else {
                graphics.setColor(Color.lightGray);
            }
            graphics.fillRect(0, n4, 10, n2);
            graphics.setColor(Color.black);
            graphics.drawRect(0, n4, 10, n2);
        }
    }
}

