/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.Dropship;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.IHex;
import megamek.common.LocationFullException;
import megamek.common.ManeuverType;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.MoveStep;
import megamek.common.PilotingRollData;
import megamek.common.Player;
import megamek.common.Report;
import megamek.common.Team;
import megamek.common.WeaponComparator;
import megamek.common.WeaponType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aero
extends Entity
implements Serializable {
    private static final long serialVersionUID = 7196307097459255187L;
    private boolean m_bImmobile = false;
    private boolean m_bImmobileHit = false;
    protected int movementDamage = 0;
    public static final int LOC_NOSE = 0;
    public static final int LOC_LWING = 1;
    public static final int LOC_RWING = 2;
    public static final int LOC_AFT = 3;
    public static final int RAM_TOWARD_DIR = 0;
    public static final int RAM_TOWARD_OBL = 1;
    public static final int RAM_AWAY_OBL = 2;
    public static final int RAM_AWAY_DIR = 3;
    public static final int HEAT_SINGLE = 0;
    public static final int HEAT_DOUBLE = 1;
    public static final int CRIT_NONE = -1;
    public static final int CRIT_CREW = 0;
    public static final int CRIT_FCS = 1;
    public static final int CRIT_WEAPON = 2;
    public static final int CRIT_CONTROL = 3;
    public static final int CRIT_SENSOR = 4;
    public static final int CRIT_BOMB = 5;
    public static final int CRIT_ENGINE = 6;
    public static final int CRIT_FUEL_TANK = 7;
    public static final int CRIT_AVIONICS = 8;
    public static final int CRIT_GEAR = 9;
    public static final int CRIT_HEATSINK = 10;
    public static final int CRIT_CARGO = 11;
    public static final int CRIT_DOCK_COLLAR = 12;
    public static final int CRIT_DOOR = 13;
    public static final int CRIT_KF_BOOM = 14;
    public static final int CRIT_LIFE_SUPPORT = 15;
    public static final int CRIT_LEFT_THRUSTER = 16;
    public static final int CRIT_RIGHT_THRUSTER = 17;
    public static final int CRIT_CIC = 18;
    public static final int CRIT_KF_DRIVE = 19;
    public static final int CRIT_GRAV_DECK = 20;
    private static final int[] NUM_OF_SLOTS = new int[]{100, 100, 100, 100, 100, 100};
    protected static String[] LOCATION_ABBRS = new String[]{"NOS", "LWG", "RWG", "AFT"};
    protected static String[] LOCATION_NAMES = new String[]{"Nose", "Left Wing", "Right Wing", "Aft"};
    private int structureType = 0;
    private int sensorHits = 0;
    private int fcsHits = 0;
    private int engineHits = 0;
    private int avionicsHits = 0;
    private int cicHits = 0;
    private boolean gearHit = false;
    private int structIntegrity;
    private int orig_structIntegrity;
    private int[] damThresh = new int[]{0, 0, 0, 0};
    private int potCrit = -1;
    private int[] standard_damage = new int[]{0, 0, 0, 0};
    private int straightMoves = 0;
    private boolean spheroid = false;
    private int heatSinks;
    private int heatType = 0;
    public static final String SPACE_BOMB_ATTACK = "SpaceBombAttack";
    public static final int BOMB_HE = 0;
    public static final int BOMB_CL = 1;
    public static final int BOMB_LG = 2;
    public static final int BOMB_INF = 3;
    public static final int BOMB_MINE = 4;
    public static final int BOMB_TAG = 5;
    public static final int BOMB_ARROW = 6;
    public static final int BOMB_RL = 7;
    public static final int BOMB_ALAMO = 8;
    public static final int BOMB_NUM = 9;
    public static final String[] bombNames = new String[]{"HE Bomb", "Cluster Bomb", "Laser-guided Bomb", "Inferno Bomb", "Mine Bomb", "TAG", "Arrow IV", "Rocket Launcher", "Alamo Missile"};
    public static final int[] bombCosts = new int[]{1, 1, 1, 1, 1, 1, 5, 1, 10};
    private int bombPoints = 0;
    private int maxBombPoints = 0;
    private int[] bombChoices = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private boolean pendingBombDump = false;
    private boolean dumpingBombs = false;
    private int[] bombDumps = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] pendingBombDumps = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] bombCrits = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int fuel = 0;
    private boolean lifeSupport = true;
    private int leftThrustHits = 0;
    private int rightThrustHits = 0;
    private boolean outControl = false;
    private boolean outCtrlHeat = false;
    private boolean randomMove = false;
    private int currentVelocity;
    private int nextVelocity = this.currentVelocity = 0;
    private boolean evading = false;
    private boolean accLast = false;
    private boolean rolled = false;
    private boolean failedManeuver = false;
    private boolean accDecNow = false;
    boolean vstol = false;
    private int whoFirst = 0;

    @Override
    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    @Override
    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public int getWalkMP(boolean bl) {
        int n = this.getOriginalWalkMP();
        n = Math.max(0, n - this.getCargoMpReduction());
        n = Math.max(0, n - (int)Math.ceil((double)this.getBombPoints() / 5.0));
        return n;
    }

    @Override
    public int locations() {
        return 4;
    }

    @Override
    public boolean canChangeSecondaryFacing() {
        return false;
    }

    @Override
    public boolean isValidSecondaryFacing(int n) {
        return false;
    }

    @Override
    public int clipSecondaryFacing(int n) {
        return n;
    }

    public boolean isOutControlTotal() {
        return this.outControl || this.shutDown || this.crew.isUnconscious();
    }

    public boolean isOutControl() {
        return this.outControl;
    }

    public boolean isOutCtrlHeat() {
        return this.outCtrlHeat;
    }

    public boolean isRandomMove() {
        return this.randomMove;
    }

    public boolean isEvading() {
        return this.evading;
    }

    public boolean didAccLast() {
        return this.accLast;
    }

    public boolean hasLifeSupport() {
        return this.lifeSupport;
    }

    public void setLifeSupport(boolean bl) {
        this.lifeSupport = bl;
    }

    public boolean isRolled() {
        return this.rolled;
    }

    public void setOutControl(boolean bl) {
        this.outControl = bl;
    }

    public void setOutCtrlHeat(boolean bl) {
        this.outCtrlHeat = bl;
    }

    public void setRandomMove(boolean bl) {
        this.randomMove = bl;
    }

    public void setRolled(boolean bl) {
        this.rolled = bl;
    }

    public void setEvading(boolean bl) {
        this.evading = bl;
    }

    public void setAccLast(boolean bl) {
        this.accLast = bl;
    }

    public int getBombPoints() {
        return this.bombPoints;
    }

    public void setBombPoints(int n) {
        this.bombPoints = n;
    }

    public int getMaxBombPoints() {
        return this.maxBombPoints;
    }

    public void setMaxBombPoints(int n) {
        this.maxBombPoints = n;
    }

    public int[] getBombChoices() {
        int n;
        int[] nArray = (int[])this.bombChoices.clone();
        for (n = 0; n < 9; ++n) {
            nArray[n] = Math.max(nArray[n] - this.bombCrits[n], 0);
        }
        if (this.isDumpingBombs()) {
            for (n = 0; n < 9; ++n) {
                nArray[n] = Math.max(nArray[n] - this.bombDumps[n], 0);
            }
        }
        return nArray;
    }

    public void setBombChoices(int[] nArray) {
        if (nArray.length == this.bombChoices.length) {
            this.bombChoices = nArray;
        }
    }

    public void setWhoFirst() {
        this.whoFirst = Compute.randomInt(500);
    }

    public int getWhoFirst() {
        return this.whoFirst;
    }

    public int getCurrentVelocity() {
        if (this.game.useVectorMove()) {
            return this.getVelocity();
        }
        return this.currentVelocity;
    }

    public void setCurrentVelocity(int n) {
        this.currentVelocity = n;
    }

    public int getNextVelocity() {
        return this.nextVelocity;
    }

    public void setNextVelocity(int n) {
        this.nextVelocity = n;
    }

    public int getCurrentVelocityActual() {
        return this.currentVelocity;
    }

    public int getPotCrit() {
        return this.potCrit;
    }

    public void setPotCrit(int n) {
        this.potCrit = n;
    }

    public int getSI() {
        return this.structIntegrity;
    }

    public int get0SI() {
        return this.orig_structIntegrity;
    }

    public void set0SI(int n) {
        this.orig_structIntegrity = n;
        this.structIntegrity = n;
    }

    public void autoSetSI() {
        int n = (int)Math.floor((double)this.weight / 10.0);
        int n2 = this.getOriginalWalkMP();
        this.initializeSI(Math.max(n, n2));
    }

    public void initializeSI(int n) {
        this.orig_structIntegrity = n;
        this.setSI(n);
    }

    public void setSI(int n) {
        this.structIntegrity = n;
    }

    public int getSensorHits() {
        return this.sensorHits;
    }

    public void setSensorHits(int n) {
        this.sensorHits = n;
    }

    public int getFCSHits() {
        return this.fcsHits;
    }

    public void setFCSHits(int n) {
        this.fcsHits = n;
    }

    public void setCICHits(int n) {
        this.cicHits = n;
    }

    public int getCICHits() {
        return this.cicHits;
    }

    public int getEngineHits() {
        return this.engineHits;
    }

    public void setEngineHits(int n) {
        this.engineHits = n;
    }

    public int getAvionicsHits() {
        return this.avionicsHits;
    }

    public void setAvionicsHits(int n) {
        this.avionicsHits = n;
    }

    public boolean isGearHit() {
        return this.gearHit;
    }

    public void setGearHit(boolean bl) {
        this.gearHit = bl;
    }

    public void setHeatSinks(int n) {
        this.heatSinks = n;
    }

    public int getHeatSinks() {
        return this.heatSinks;
    }

    public void setHeatType(int n) {
        this.heatType = n;
    }

    public void setLeftThrustHits(int n) {
        this.leftThrustHits = n;
    }

    public int getLeftThrustHits() {
        return this.leftThrustHits;
    }

    public void setRightThrustHits(int n) {
        this.rightThrustHits = n;
    }

    public int getRightThrustHits() {
        return this.rightThrustHits;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void setFuel(int n) {
        this.fuel = n;
    }

    public int getHeatType() {
        return this.heatType;
    }

    public void immobilize() {
        this.m_bImmobileHit = true;
        this.setOriginalWalkMP(0);
    }

    @Override
    public boolean isImmobile() {
        return false;
    }

    @Override
    public void applyDamage() {
        this.m_bImmobile |= this.m_bImmobileHit;
    }

    @Override
    public void newRound(int n) {
        super.newRound(n);
        this.setEvading(false);
        this.setFailedManeuver(false);
        this.setAccDecNow(false);
        this.updateBays();
        if (this.getRecoveryTurn() > 0) {
            this.setRecoveryTurn(this.getRecoveryTurn() - 1);
        }
        if (this.game.getBoard().inAtmosphere() && this.isDeployed()) {
            this.setNextVelocity((int)Math.floor((double)this.getNextVelocity() / 2.0));
        }
        this.setCurrentVelocity(this.getNextVelocity());
        if (this.game.getOptions().booleanOption("variable_damage_thresh")) {
            this.autoSetThresh();
        }
        this.updateBombLoad();
        if (this.isOutCtrlHeat()) {
            this.setOutControl(true);
            this.setOutCtrlHeat(false);
        }
        this.setWhoFirst();
    }

    @Override
    public String getMovementString(int n) {
        switch (n) {
            case -2: {
                return "Skidded";
            }
            case 0: {
                return "None";
            }
            case 1: {
                return "Cruised";
            }
            case 2: {
                return "Flanked";
            }
            case 3: {
                return "Jumped";
            }
            case 9: {
                return "Safe Thrust";
            }
            case 10: {
                return "Over Thrust";
            }
        }
        return "Unknown!";
    }

    @Override
    public String getMovementAbbr(int n) {
        switch (n) {
            case 0: {
                return "N";
            }
            case 9: {
                return "S";
            }
            case 10: {
                return "O";
            }
        }
        return "?";
    }

    @Override
    public boolean hasRearArmor(int n) {
        return false;
    }

    @Override
    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        if (mounted.getType().getInternalName().equals(SPACE_BOMB_ATTACK)) {
            return 0;
        }
        switch (mounted.getLocation()) {
            case 0: {
                return 11;
            }
            case 2: {
                if (mounted.isRearMounted()) {
                    return 15;
                }
                return 13;
            }
            case 1: {
                if (mounted.isRearMounted()) {
                    return 14;
                }
                return 12;
            }
            case 3: {
                return 16;
            }
        }
        return 0;
    }

    @Override
    public boolean isSecondaryArcWeapon(int n) {
        return true;
    }

    @Override
    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        return this.rollHitLocation(n, n2);
    }

    @Override
    public HitData rollHitLocation(int n, int n2) {
        int n3 = Compute.d6(2);
        if (n == 4 || n == 5) {
            int n4 = 2;
            int n5 = Compute.d6(1);
            if (n5 > 3) {
                n4 = 1;
            }
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(9);
                    return new HitData(n4, false, 0);
                }
                case 4: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 5: {
                    this.setPotCrit(0);
                    return new HitData(0, false, 0);
                }
                case 6: {
                    this.setPotCrit(2);
                    return new HitData(n4, false, 0);
                }
                case 7: {
                    this.setPotCrit(8);
                    return new HitData(0, false, 0);
                }
                case 8: {
                    this.setPotCrit(2);
                    return new HitData(n4, false, 0);
                }
                case 9: {
                    this.setPotCrit(3);
                    return new HitData(3, false, 0);
                }
                case 10: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 11: {
                    this.setPotCrit(9);
                    return new HitData(n4, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
            }
        }
        if (n2 == 0) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 4: {
                    this.setPotCrit(10);
                    return new HitData(2, false, 0);
                }
                case 5: {
                    this.setPotCrit(2);
                    return new HitData(2, false, 0);
                }
                case 6: {
                    this.setPotCrit(8);
                    return new HitData(0, false, 0);
                }
                case 7: {
                    this.setPotCrit(3);
                    return new HitData(0, false, 0);
                }
                case 8: {
                    this.setPotCrit(1);
                    return new HitData(0, false, 0);
                }
                case 9: {
                    this.setPotCrit(2);
                    return new HitData(1, false, 0);
                }
                case 10: {
                    this.setPotCrit(10);
                    return new HitData(1, false, 0);
                }
                case 11: {
                    this.setPotCrit(9);
                    return new HitData(0, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
            }
        } else if (n2 == 2) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(9);
                    return new HitData(1, false, 0);
                }
                case 4: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 5: {
                    this.setPotCrit(0);
                    return new HitData(0, false, 0);
                }
                case 6: {
                    this.setPotCrit(2);
                    return new HitData(1, false, 0);
                }
                case 7: {
                    this.setPotCrit(8);
                    return new HitData(1, false, 0);
                }
                case 8: {
                    this.setPotCrit(5);
                    return new HitData(1, false, 0);
                }
                case 9: {
                    this.setPotCrit(3);
                    return new HitData(3, false, 0);
                }
                case 10: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 11: {
                    this.setPotCrit(9);
                    return new HitData(1, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
            }
        } else if (n2 == 3) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(0, false, 0);
                }
                case 3: {
                    this.setPotCrit(9);
                    return new HitData(2, false, 0);
                }
                case 4: {
                    this.setPotCrit(4);
                    return new HitData(0, false, 0);
                }
                case 5: {
                    this.setPotCrit(0);
                    return new HitData(0, false, 0);
                }
                case 6: {
                    this.setPotCrit(2);
                    return new HitData(2, false, 0);
                }
                case 7: {
                    this.setPotCrit(8);
                    return new HitData(2, false, 0);
                }
                case 8: {
                    this.setPotCrit(5);
                    return new HitData(2, false, 0);
                }
                case 9: {
                    this.setPotCrit(3);
                    return new HitData(3, false, 0);
                }
                case 10: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 11: {
                    this.setPotCrit(9);
                    return new HitData(2, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
            }
        } else if (n2 == 1) {
            switch (n3) {
                case 2: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
                case 3: {
                    this.setPotCrit(10);
                    return new HitData(3, false, 0);
                }
                case 4: {
                    this.setPotCrit(7);
                    return new HitData(2, false, 0);
                }
                case 5: {
                    this.setPotCrit(2);
                    return new HitData(2, false, 0);
                }
                case 6: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 7: {
                    this.setPotCrit(3);
                    return new HitData(3, false, 0);
                }
                case 8: {
                    this.setPotCrit(6);
                    return new HitData(3, false, 0);
                }
                case 9: {
                    this.setPotCrit(2);
                    return new HitData(1, false, 0);
                }
                case 10: {
                    this.setPotCrit(7);
                    return new HitData(1, false, 0);
                }
                case 11: {
                    this.setPotCrit(10);
                    return new HitData(3, false, 0);
                }
                case 12: {
                    this.setPotCrit(2);
                    return new HitData(3, false, 0);
                }
            }
        }
        return new HitData(0, false, 0);
    }

    @Override
    public HitData getTransferLocation(HitData hitData) {
        return new HitData(-2);
    }

    @Override
    public int getDependentLocation(int n) {
        return -1;
    }

    @Override
    public int calculateBattleValue() {
        return this.calculateBattleValue(false);
    }

    public int calculateBattleValue(boolean bl, boolean bl2) {
        int n;
        EquipmentType equipmentType;
        double d = 0.0;
        double d2 = 0.0;
        d += (double)this.getTotalArmor() * 2.5;
        d += (double)this.getSI() * 2.0;
        double d3 = 0.0;
        for (Mounted serializable2 : this.getEquipment()) {
            EquipmentType d4 = serializable2.getType();
            if (serializable2.isDestroyed() || !(d4 instanceof WeaponType && d4.hasFlag(0x800000L) || d4 instanceof AmmoType && ((AmmoType)d4).getAmmoType() == 14) && (!(d4 instanceof MiscType) || !d4.hasFlag(1024L) && !d4.hasFlag(0x2000000L) && !d4.hasFlag(8192L) && !d4.hasFlag(0x800000000L))) continue;
            d3 += d4.getBV(this);
        }
        d += d3;
        d *= 1.2;
        int n2 = 6 + this.getHeatCapacity();
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        double d4 = 0.0;
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType d7 = (WeaponType)mounted.getType();
            double d5 = d7.getHeat();
            if (mounted.isMissing() || mounted.isHit() || mounted.isDestroyed() || mounted.isBreached()) continue;
            if (d7.getAmmoType() == 29 || d7.hasFlag(16384L)) {
                d5 *= 0.25;
            }
            if (d7.getAmmoType() == 20 || d7.getAmmoType() == 33) {
                d5 *= 2.0;
            }
            if (d7.getAmmoType() == 23) {
                d5 *= 6.0;
            }
            if (d7.getAmmoType() == 11 || d7.getAmmoType() == 42 || d7.getAmmoType() == 31) {
                d5 *= 0.5;
            }
            d4 += d5;
            if (d7.hasFlag(131072L) && d7.getAmmoType() != 46 || d7.hasFlag(16384L) || d7.hasFlag(2048L) || d7.getAmmoType() == -1) continue;
            String string = d7.getAmmoType() + ":" + d7.getRackSize();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, d7.getBV(this));
                continue;
            }
            hashMap.put(string, d7.getBV(this) + (Double)hashMap.get(string));
        }
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        boolean bl3 = this.hasTargComp();
        if (d4 <= (double)n2) {
            for (Mounted mounted : this.getWeaponList()) {
                Iterator<Mounted> iterator = (WeaponType)mounted.getType();
                double mounted2 = ((EquipmentType)((Object)iterator)).getBV(this);
                if (mounted.isDestroyed() || ((EquipmentType)((Object)iterator)).hasFlag(0x800000L)) continue;
                if (((EquipmentType)((Object)iterator)).hasFlag(1L) && bl3) {
                    mounted2 *= 1.25;
                }
                if (mounted.getLocation() == 3) {
                    d8 += mounted2;
                    continue;
                }
                d7 += mounted2;
            }
        } else {
            int d12 = 0;
            ArrayList<Mounted> arrayList = this.getWeaponList();
            Collections.sort(arrayList, new WeaponComparator());
            for (Mounted mounted : arrayList) {
                Mounted mounted3;
                equipmentType = (WeaponType)mounted.getType();
                double d9 = equipmentType.getBV(this);
                if (mounted.isDestroyed() || equipmentType.hasFlag(0x800000L)) continue;
                if (equipmentType.hasFlag(0x100000000L)) {
                    double d10 = 0.0;
                    for (Mounted mounted4 : this.getWeaponList()) {
                        if (!mounted4.getType().hasFlag(512L) || mounted4.getLocation() != mounted.getLocation()) continue;
                        d10 += mounted4.getType().getBV(this);
                    }
                    d9 = d10 * 0.67;
                }
                if (equipmentType.hasFlag(1L) && bl3) {
                    d9 *= 1.25;
                }
                if (mounted.getLinkedBy() != null && (mounted3 = mounted.getLinkedBy()).getType() instanceof MiscType && mounted3.getType().hasFlag(512L)) {
                    d9 *= 1.2;
                }
                if (d12 > n2 && ((WeaponType)equipmentType).getHeat() > 0) {
                    d9 /= 2.0;
                }
                if (mounted.getLocation() == 3) {
                    d8 += d9;
                } else {
                    d7 += d9;
                }
                d12 += ((WeaponType)mounted.getType()).getHeat();
            }
        }
        if (d7 > d8) {
            d6 += d7;
            d6 += d8 * 0.5;
        } else {
            d6 += d8;
            d6 += d7 * 0.5;
        }
        double d11 = 0.0;
        for (Mounted mounted : this.getMisc()) {
            equipmentType = (MiscType)mounted.getType();
            if (mounted.isDestroyed() || equipmentType.hasFlag(1024L) || equipmentType.hasFlag(8192L) || equipmentType.hasFlag(0x2000000L) || equipmentType.hasFlag(0x800000000L) || equipmentType.hasFlag(2048L)) continue;
            d11 += ((MiscType)equipmentType).getBV(this);
            if (!equipmentType.hasFlag(0x80000000L)) continue;
            if (this.getArmor(mounted.getLocation(), false) != -3) {
                d11 += (double)this.getArmor(mounted.getLocation());
            }
            if (!this.hasRearArmor(mounted.getLocation()) || this.getArmor(mounted.getLocation(), true) == -3) continue;
            d11 += (double)this.getArmor(mounted.getLocation(), true);
        }
        d6 += d11;
        double d12 = 0.0;
        double d13 = 0.0;
        HashMap<Object, Double> hashMap2 = new HashMap<Object, Double>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Mounted mounted : this.getAmmo()) {
            Object object;
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14 || mounted.getLocation() == -1) continue;
            if (ammoType.getMunitionType() == 262144L && (object = this.getOwner()) != null) {
                if (((Player)object).hasTAG()) {
                    d13 += ammoType.getBV(this);
                } else if (((Player)object).getTeam() != 0 && this.game != null) {
                    Enumeration<Team> enumeration = this.game.getTeams();
                    while (enumeration.hasMoreElements()) {
                        Team team = enumeration.nextElement();
                        if (team.getId() != ((Player)object).getTeam()) continue;
                        if (!team.hasTAG(this.game)) break;
                        d13 += ammoType.getBV(this);
                        break;
                    }
                }
            }
            if (!arrayList.contains(object = ammoType.getAmmoType() + ":" + ammoType.getRackSize())) {
                arrayList.add(object);
            }
            if (!hashMap2.containsKey(object)) {
                hashMap2.put(object, ammoType.getBV(this));
                continue;
            }
            hashMap2.put(object, ammoType.getBV(this) + (Double)hashMap2.get(object));
        }
        for (String string : arrayList) {
            if (hashMap.get(string) != null) {
                if ((Double)hashMap2.get(string) > (Double)hashMap.get(string)) {
                    d12 += ((Double)hashMap.get(string)).doubleValue();
                    continue;
                }
                d12 += ((Double)hashMap2.get(string)).doubleValue();
                continue;
            }
            if (!string.equals(new Integer(36).toString() + "1")) continue;
            d12 += ((Double)hashMap2.get(string)).doubleValue();
        }
        double d14 = this.getOriginalRunMP();
        double d15 = Math.pow(1.0 + (d14 - 5.0) / 10.0, 1.2);
        d15 = (double)Math.round(d15 * 100.0) / 100.0;
        d2 = (d6 += d12) * d15;
        double d16 = 0.0;
        d16 += d13;
        if ((this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.C3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5 || bl) && !bl2 && this.game != null) {
            n = 0;
            n += this.calculateBattleValue(false, true);
            for (Entity entity : this.game.getC3NetworkMembers(this)) {
                if (this.equals(entity) || !this.onSameC3NetworkAs(entity)) continue;
                n += entity.calculateBattleValue(true);
            }
            n = (int)((double)n * 0.05);
            d16 += (double)n;
        }
        n = (int)Math.round(d + d2 + d16);
        double d17 = this.crew.getBVSkillMultiplier();
        int n3 = (int)Math.round((double)n * d17);
        if (bl2) {
            return n;
        }
        return n3;
    }

    @Override
    public int calculateBattleValue(boolean bl) {
        return this.calculateBattleValue(bl, false);
    }

    @Override
    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        int n;
        int n2;
        int n3 = this.getAvionicsHits();
        int n4 = this.getCrew().getHits();
        if (n3 > 0 && n3 < 3) {
            pilotingRollData.addModifier(n3, "Avionics Damage");
        }
        if (n3 >= 3) {
            pilotingRollData.addModifier(5, "Avionics Destroyed");
        }
        if (n4 > 0) {
            pilotingRollData.addModifier(n4, "Pilot Hits");
        }
        if (this.moved == 10) {
            pilotingRollData.addModifier(1, "Used more than safe thrust");
        }
        if ((n2 = (n = this.getCurrentVelocity()) - 2 * this.getWalkMP()) > 0) {
            pilotingRollData.addModifier(n2, "Velocity greater than 2x safe thrust");
        }
        if (this.game.getBoard().inAtmosphere()) {
            pilotingRollData.addModifier(2, "Atmospheric operations");
            if (this instanceof Dropship) {
                if (this.isSpheroid()) {
                    pilotingRollData.addModifier(-1, "spheroid dropship");
                } else {
                    pilotingRollData.addModifier(0, "aerodyne dropship");
                }
            } else {
                pilotingRollData.addModifier(-1, "fighter/small craft");
            }
        }
        if (!this.hasLifeSupport()) {
            pilotingRollData.addModifier(2, "No life support");
        }
        return pilotingRollData;
    }

    @Override
    public Vector<Report> victoryReport() {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(7025);
        report.type = 0;
        report.addDesc(this);
        vector.addElement(report);
        report = new Report(7035);
        report.type = 0;
        report.newlines = 0;
        vector.addElement(report);
        vector.addAll(this.crew.getDescVector(false));
        report = new Report(7070, 0);
        report.add(this.getKillNumber());
        vector.addElement(report);
        if (this.isDestroyed()) {
            Entity entity = this.game.getEntity(this.killerId);
            if (entity == null) {
                entity = this.game.getOutOfGameEntity(this.killerId);
            }
            if (entity != null) {
                report = new Report(7072, 0);
                report.addDesc(entity);
            } else {
                report = new Report(7073, 0);
            }
            vector.addElement(report);
        }
        report.newlines = 2;
        return vector;
    }

    @Override
    public int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    @Override
    public int getRunMPwithoutMASC(boolean bl, boolean bl2) {
        return this.getRunMP(bl, bl2);
    }

    @Override
    public int getHeatCapacity() {
        return this.getHeatSinks() * (this.getHeatType() + 1);
    }

    @Override
    public int getHeatCapacityWithWater() {
        return this.getHeatCapacity();
    }

    @Override
    public int getEngineCritHeat() {
        return 0;
    }

    @Override
    public void autoSetInternal() {
        int n = (int)Math.ceil((double)this.weight / 10.0);
        n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            this.initializeInternal(n, i);
        }
    }

    public void autoSetThresh() {
        for (int i = 0; i < this.locations(); ++i) {
            this.initializeThresh(i);
        }
    }

    public void setThresh(int n, int n2) {
        this.damThresh[n2] = n;
    }

    public void initializeThresh(int n) {
        int n2 = (int)Math.ceil((double)this.getArmor(n) / 10.0);
        this.setThresh(n2, n);
    }

    public int getThresh(int n) {
        return this.damThresh[n];
    }

    @Override
    public boolean isRepairable() {
        return true;
    }

    @Override
    public void restore() {
        super.restore();
    }

    @Override
    public boolean canCharge() {
        return false;
    }

    @Override
    public boolean canDFA() {
        return false;
    }

    @Override
    public boolean canRam() {
        return !this.isImmobile() && this.getWalkMP() > 0;
    }

    @Override
    public int getArmorType() {
        return this.armorType;
    }

    @Override
    public void setArmorType(int n) {
        this.armorType = n;
    }

    @Override
    public int getStructureType() {
        return this.structureType;
    }

    @Override
    public void setStructureType(int n) {
        this.structureType = n;
    }

    public int getSuspensionFactor() {
        return 0;
    }

    @Override
    public double getCost() {
        double d = 0.0;
        d += (double)(250000.0f + 2000.0f * this.weight);
        d += (double)(50000 * this.getSI());
        d += (double)(25000.0f + 10.0f * this.getWeight());
        Engine engine = this.getEngine();
        d += (double)((float)(engine.getBaseCost() * engine.getRating()) * this.weight) / 75.0;
        d += (double)(200 * this.getFuel()) / 80.0;
        d += this.getArmorWeight() * EquipmentType.getArmorCost(this.armorType);
        int n = 2000 + 4000 * this.getHeatType();
        d += (double)(n * this.getHeatSinks());
        d += (double)this.getWeaponsAndEquipmentCost();
        double d2 = 1.0;
        if (this.isOmni()) {
            d2 = 1.25;
        }
        double d3 = 1.0f + this.weight / 200.0f;
        return Math.round(d * d2 * d3);
    }

    @Override
    public boolean doomedInVacuum() {
        return false;
    }

    @Override
    public boolean doomedOnGround() {
        return true;
    }

    @Override
    public boolean doomedInAtmosphere() {
        return false;
    }

    @Override
    public boolean doomedInSpace() {
        return false;
    }

    @Override
    public boolean canGoHullDown() {
        return false;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
        if (engine.engineValid) {
            this.setOriginalWalkMP(this.calculateWalk());
        }
    }

    @Override
    public double getInternalRemainingPercent() {
        return (double)this.getSI() / (double)this.get0SI();
    }

    protected int calculateWalk() {
        return this.getEngine().getRating() / (int)this.weight + 2;
    }

    @Override
    public boolean isNuclearHardened() {
        return true;
    }

    @Override
    protected void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        super.addEquipment(mounted, n, bl);
        this.addCritical(n, new CriticalSlot(1, this.getEquipmentNum(mounted), true));
    }

    public int getCriticalEffect(int n, int n2) {
        if (n < n2) {
            return -1;
        }
        int n3 = this.getPotCrit();
        return n3;
    }

    public PilotingRollData checkThrustSI(int n) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        if (n > this.getSI()) {
            pilotingRollData.append(new PilotingRollData(this.getId(), n - this.getSI(), "Thrust exceeds current SI in a single hex"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not exceeding SI");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkThrustSITotal(int n) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        if (n > this.getSI()) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "Thrust spent this turn exceeds current SI"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not exceeding SI");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkVelocityDouble(int n) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        if (n > 2 * this.getWalkMP() && this.game.getBoard().inAtmosphere()) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "Velocity greater than 2x safe thrust"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not exceeding 2x safe thrust");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkDown(int n) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        if (n > 2) {
            pilotingRollData.append(new PilotingRollData(this.getId(), n, "lost more than two altitudes"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: entity did not drop more than two altitudes");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkHover(MovePath movePath) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        if (movePath.contains(47)) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "hovering"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: entity did not hover");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkStall(int n) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        if (n == 0) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "stalled out"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: entity not stalled out");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkRolls(MoveStep moveStep) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        if ((moveStep.getType() == 38 || moveStep.getType() == 42) && moveStep.getNRolls() > 1) {
            pilotingRollData.append(new PilotingRollData(this.getId(), 0, "More than one roll in the same turn"));
        } else {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not rolling more than once");
        }
        return pilotingRollData;
    }

    public PilotingRollData checkManeuver(MoveStep moveStep) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        if (moveStep == null || moveStep.getType() != 48) {
            pilotingRollData.addModifier(-2147483647, "Check false: Entity is not attempting to get up.");
            return pilotingRollData;
        }
        pilotingRollData.append(new PilotingRollData(this.getId(), ManeuverType.getMod(moveStep.getManeuverType(), this.isVSTOL()), ManeuverType.getTypeName(moveStep.getManeuverType()) + " maneuver"));
        return pilotingRollData;
    }

    @Override
    public void setOmni(boolean bl) {
        super.setOmni(bl);
    }

    public void addClanCase() {
        boolean bl = false;
        EquipmentType equipmentType = EquipmentType.get("CLCASE");
        for (int i = 0; i < this.locations(); ++i) {
            bl = false;
            for (Mounted mounted : this.getEquipment()) {
                if (!mounted.getType().isExplosive() || mounted.getLocation() != i) continue;
                bl = true;
            }
            if (!bl) continue;
            try {
                this.addEquipment(new Mounted(this, equipmentType), i, false);
                continue;
            }
            catch (LocationFullException locationFullException) {
                // empty catch block
            }
        }
    }

    public boolean hasCase() {
        boolean bl = false;
        for (int i = 0; i < this.locations(); ++i) {
            if (bl) continue;
            bl = this.locationHasCase(i);
        }
        return bl;
    }

    public int sideTableRam(Coords coords) {
        int n;
        int n2 = this.sideTableRam(coords, this.facing);
        if (this.game.useVectorMove() && (n = this.chooseSideRam(coords)) != -1) {
            n2 = n;
        }
        return n2;
    }

    public int sideTableRam(Coords coords, int n) {
        int n2 = (this.getPosition().degree(coords) + (6 - n) * 60) % 360;
        if (n2 > 30 && n2 <= 90 || n2 < 330 && n2 >= 270) {
            return 1;
        }
        if (n2 > 150 && n2 < 210) {
            return 3;
        }
        if (n2 > 90 && n2 <= 150 || n2 < 270 && n2 >= 210) {
            return 2;
        }
        return 0;
    }

    public int chooseSideRam(Coords coords) {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        for (int i = 0; i < 6; ++i) {
            int n4;
            n = this.getVector(i);
            if (n == 0) continue;
            if (n > n2) {
                n2 = n;
                n3 = this.sideTableRam(coords, i);
            }
            if (n != n2 || (n4 = this.sideTableRam(coords, i)) <= n3) continue;
            n4 = n3;
        }
        return n3;
    }

    public int getStandardDamage(int n) {
        return this.standard_damage[n];
    }

    public void resetStandardDamage() {
        for (int i = 0; i < this.locations(); ++i) {
            this.standard_damage[i] = 0;
        }
    }

    public void addStandardDamage(int n, HitData hitData) {
        this.standard_damage[hitData.getLocation()] = this.standard_damage[hitData.getLocation()] + n;
    }

    public int getMaxEngineHits() {
        return 3;
    }

    @Override
    public int getMaxElevationChange() {
        return 999;
    }

    @Override
    public boolean isHexProhibited(IHex iHex) {
        return iHex.containsTerrain(32);
    }

    public boolean isSpheroid() {
        return this.spheroid;
    }

    public void setSpheroid(boolean bl) {
        this.spheroid = bl;
    }

    @Override
    public int height() {
        return 0;
    }

    @Override
    public boolean canUnjamRAC() {
        for (Mounted mounted : this.getTotalWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.getAmmoType() != 23 || !mounted.isJammed() || mounted.isDestroyed()) continue;
            return true;
        }
        return false;
    }

    public void applyBombs() {
        String string;
        int n;
        this.updateBombLoad();
        try {
            this.addEquipment(EquipmentType.get(SPACE_BOMB_ATTACK), 0, false);
        }
        catch (LocationFullException locationFullException) {
            // empty catch block
        }
        int n2 = 0;
        if (this.bombChoices[5] > 0) {
            for (n = 0; n < this.bombChoices[5]; ++n) {
                string = "IS";
                if (this.isClan()) {
                    string = "CL";
                }
                try {
                    this.addEquipment(EquipmentType.get(string + "TAG"), n2, false, true, 1);
                    continue;
                }
                catch (LocationFullException locationFullException) {
                    // empty catch block
                }
            }
        }
        if (this.bombChoices[6] > 0) {
            for (n = 0; n < this.bombChoices[6]; ++n) {
                string = "IS";
                if (this.isClan()) {
                    string = "CL";
                }
                try {
                    Mounted mounted = this.addEquipment(EquipmentType.get(string + "ArrowIVSystem"), n2, false, true, 5);
                    Mounted mounted2 = this.addEquipment(EquipmentType.get(string + "ArrowIVHoming Ammo"), n2, false, true, 5);
                    mounted2.setShotsLeft(1);
                    mounted.setLinked(mounted2);
                    continue;
                }
                catch (LocationFullException locationFullException) {
                    // empty catch block
                }
            }
        }
        if (this.bombChoices[7] > 0) {
            for (n = 0; n < this.bombChoices[7]; ++n) {
                try {
                    this.addEquipment(EquipmentType.get("ISRocketLauncher10"), n2, false, true, 1);
                    continue;
                }
                catch (LocationFullException locationFullException) {
                    // empty catch block
                }
            }
        }
        if (this.bombChoices[8] > 0) {
            for (n = 0; n < this.bombChoices[8]; ++n) {
                try {
                    this.addEquipment(EquipmentType.get("Alamo"), n2, false, true, 10);
                    continue;
                }
                catch (LocationFullException locationFullException) {
                    // empty catch block
                }
            }
        }
    }

    public void updateBombLoad() {
        int n = 0;
        for (int i = 0; i < this.bombChoices.length; ++i) {
            n += this.bombChoices[i] * bombCosts[i];
        }
        this.setBombPoints(n);
    }

    public void removeBombs(int n, int n2) {
        if (n2 >= 9) {
            return;
        }
        this.bombChoices[n2] = Math.max(this.bombChoices[n2] - n, 0);
        if (n2 == 5 || n2 == 6 || n2 == 7 || n2 == 8) {
            block0: for (int i = 0; i < n; ++i) {
                for (Mounted mounted : this.getWeaponList()) {
                    boolean bl;
                    WeaponType weaponType = (WeaponType)mounted.getType();
                    Mounted mounted2 = mounted.getLinked();
                    boolean bl2 = bl = weaponType.getAmmoType() != -1;
                    if (bl && weaponType.getAmmoType() == 15 && n2 == 6 && mounted2.getShotsLeft() > 0 && !mounted.isDestroyed()) {
                        mounted2.setShotsLeft(0);
                        continue block0;
                    }
                    if (bl && weaponType.getAmmoType() == 29 && n2 == 7 && mounted2.getShotsLeft() > 0 && !mounted.isDestroyed()) {
                        mounted2.setShotsLeft(0);
                        continue block0;
                    }
                    if (bl && weaponType.getAmmoType() == 63 && n2 == 8 && mounted2.getShotsLeft() > 0 && !mounted.isDestroyed()) {
                        mounted2.setShotsLeft(0);
                        continue block0;
                    }
                    if (!weaponType.hasFlag(0x4000000L) || mounted.isDestroyed()) continue;
                    mounted.setDestroyed(true);
                    continue block0;
                }
            }
        }
    }

    public void critBombs(int n) {
        if (n >= 9) {
            return;
        }
        int n2 = n;
        this.bombCrits[n2] = this.bombCrits[n2] + 1;
        if (n == 5 || n == 6 || n == 7 || n == 8) {
            for (Mounted mounted : this.getWeaponList()) {
                boolean bl;
                WeaponType weaponType = (WeaponType)mounted.getType();
                Mounted mounted2 = mounted.getLinked();
                boolean bl2 = bl = weaponType.getAmmoType() != -1;
                if (bl && weaponType.getAmmoType() == 15 && n == 6 && mounted2.getShotsLeft() > 0 && !mounted.isDestroyed()) {
                    mounted.setDestroyed(true);
                    break;
                }
                if (bl && weaponType.getAmmoType() == 29 && n == 7 && mounted2.getShotsLeft() > 0 && !mounted.isDestroyed()) {
                    mounted.setDestroyed(true);
                    break;
                }
                if (bl && weaponType.getAmmoType() == 63 && n == 8 && mounted2.getShotsLeft() > 0 && !mounted.isDestroyed()) {
                    mounted.setDestroyed(true);
                    break;
                }
                if (!weaponType.hasFlag(0x4000000L) || mounted.isDestroyed()) continue;
                mounted.setDestroyed(true);
                break;
            }
        }
    }

    public boolean hasSpaceBombs() {
        return this.bombChoices[0] > 0 || this.bombChoices[1] > 0 || this.bombChoices[2] > 0;
    }

    public boolean hasBombs() {
        int[] nArray = this.getBombChoices();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean isPendingBombDump() {
        return this.pendingBombDump;
    }

    public void setPendingBombDump(boolean bl) {
        this.pendingBombDump = bl;
    }

    public boolean isDumpingBombs() {
        return this.dumpingBombs;
    }

    public void setDumpingBombs(boolean bl) {
        this.dumpingBombs = bl;
    }

    public void setBombDumps(int[] nArray) {
        this.bombDumps = nArray;
    }

    public int[] getBombDumps() {
        return this.bombDumps;
    }

    public void setPendingBombDumps(int[] nArray) {
        this.pendingBombDumps = nArray;
    }

    public int[] getPendingBombDumps() {
        return this.pendingBombDumps;
    }

    public int[] getBombCrits() {
        return this.bombCrits;
    }

    @Override
    public int getExtremeRangeModifier() {
        return 6;
    }

    public int getStraightMoves() {
        return this.straightMoves;
    }

    public void setStraightMoves(int n) {
        this.straightMoves = n;
    }

    public boolean isVSTOL() {
        return this.vstol;
    }

    public void setVSTOL(boolean bl) {
        this.vstol = bl;
    }

    public int getFuelUsed(int n) {
        return n + Math.max(n - this.getWalkMP(), 0);
    }

    public boolean didFailManeuver() {
        return this.failedManeuver;
    }

    public void setFailedManeuver(boolean bl) {
        this.failedManeuver = bl;
    }

    public void setAccDecNow(boolean bl) {
        this.accDecNow = bl;
    }

    public boolean didAccDecNow() {
        return this.accDecNow;
    }
}

