/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import megamek.common.Building;
import megamek.common.Coords;
import megamek.common.FuelTank;
import megamek.common.Hex;
import megamek.common.IBoard;
import megamek.common.IHex;
import megamek.common.ITerrain;
import megamek.common.IdealHex;
import megamek.common.InfernoTracker;
import megamek.common.Player;
import megamek.common.SpecialHexDisplay;
import megamek.common.Terrains;
import megamek.common.event.BoardEvent;
import megamek.common.event.BoardListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Board
implements Serializable,
IBoard {
    private static final long serialVersionUID = -5744058872091016636L;
    public static final String BOARD_REQUEST_ROTATION = "rotate:";
    public static final int BOARD_MAX_WIDTH = 1048575;
    public static final int BOARD_MAX_HEIGHT = 511;
    protected int width;
    protected int height;
    public static final int T_GROUND = 0;
    public static final int T_ATMOSPHERE = 1;
    public static final int T_SPACE = 2;
    private static final String[] typeNames = new String[]{"Ground", "Low Atmosphere", "Space"};
    private int mapType = 0;
    private IHex[] data;
    private Vector<Building> buildings = new Vector();
    private transient Hashtable<Coords, Building> bldgByCoords = new Hashtable();
    protected transient Vector<BoardListener> boardListeners = new Vector();
    private Hashtable<Coords, InfernoTracker> infernos = new Hashtable();
    private Hashtable<Coords, Collection<SpecialHexDisplay>> specialHexes = new Hashtable();
    private boolean roadsAutoExit = true;

    public Board() {
        this(0, 0);
    }

    public Board(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.data = new IHex[n * n2];
    }

    public Board(int n, int n2, IHex[] iHexArray) {
        this.width = n;
        this.height = n2;
        this.data = new IHex[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.data[i * n + j] = iHexArray[i * n + j];
            }
        }
    }

    public Board(int n, int n2, IHex[] iHexArray, Vector<Building> vector, Hashtable<Coords, InfernoTracker> hashtable) {
        this.width = n;
        this.height = n2;
        this.data = iHexArray;
        this.buildings = vector;
        this.infernos = hashtable;
        this.createBldgByCoords();
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void newData(int n, int n2, IHex[] iHexArray) {
        this.width = n;
        this.height = n2;
        this.data = iHexArray;
        this.initializeAll();
        this.processBoardEvent(new BoardEvent(this, null, 0));
    }

    @Override
    public void newData(int n, int n2) {
        this.newData(n, n2, new IHex[n * n2]);
    }

    @Override
    public Enumeration<Coords> getHexesAtDistance(Coords coords, int n) {
        Vector<Coords> vector = new Vector<Coords>();
        if (n < 0) {
            return vector.elements();
        }
        if (n == 0) {
            vector.add(coords);
            return vector.elements();
        }
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                if (coords.distance(i, j) != n) continue;
                vector.add(new Coords(i, j));
            }
        }
        return vector.elements();
    }

    @Override
    public IHex getHex(int n, int n2) {
        if (this.contains(n, n2)) {
            return this.data[n2 * this.width + n];
        }
        return null;
    }

    @Override
    public IHex getHexInDir(Coords coords, int n) {
        return this.getHexInDir(coords.x, coords.y, n);
    }

    @Override
    public IHex getHexInDir(int n, int n2, int n3) {
        return this.getHex(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
    }

    protected void initializeAll() {
        int n;
        int n2;
        this.buildings.removeAllElements();
        if (this.bldgByCoords == null) {
            this.bldgByCoords = new Hashtable();
        } else {
            this.bldgByCoords.clear();
        }
        for (n2 = 0; n2 < this.height; ++n2) {
            for (n = 0; n < this.width; ++n) {
                Enumeration<Coords> enumeration;
                Coords coords;
                IHex iHex = this.getHex(n, n2);
                if (iHex != null && iHex.containsTerrain(10) && !this.bldgByCoords.containsKey(coords = new Coords(n, n2))) {
                    try {
                        Building building = new Building(coords, this, 10);
                        this.buildings.addElement(building);
                        enumeration = building.getCoords();
                        while (enumeration.hasMoreElements()) {
                            this.bldgByCoords.put(enumeration.nextElement(), building);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.err.println("Unable to create building.");
                        illegalArgumentException.printStackTrace();
                        iHex.removeTerrain(10);
                    }
                }
                if (iHex != null && iHex.containsTerrain(34) && !this.bldgByCoords.containsKey(coords = new Coords(n, n2))) {
                    try {
                        int n3 = iHex.getTerrain(37).getLevel();
                        enumeration = new FuelTank(coords, this, 34, n3);
                        this.buildings.addElement((Building)((Object)enumeration));
                        Enumeration<Coords> enumeration2 = ((Building)((Object)enumeration)).getCoords();
                        while (enumeration2.hasMoreElements()) {
                            this.bldgByCoords.put(enumeration2.nextElement(), (Building)((Object)enumeration));
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.err.println("Unable to create building.");
                        illegalArgumentException.printStackTrace();
                        iHex.removeTerrain(10);
                    }
                }
                if (iHex == null || !iHex.containsTerrain(14) || this.bldgByCoords.containsKey(coords = new Coords(n, n2))) continue;
                try {
                    Building building = new Building(coords, this, 14);
                    this.buildings.addElement(building);
                    enumeration = building.getCoords();
                    while (enumeration.hasMoreElements()) {
                        this.bldgByCoords.put(enumeration.nextElement(), building);
                    }
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("Unable to create bridge.");
                    illegalArgumentException.printStackTrace();
                    iHex.removeTerrain(14);
                }
            }
        }
        for (n2 = 0; n2 < this.height; ++n2) {
            for (n = 0; n < this.width; ++n) {
                this.initializeHex(n, n2);
            }
        }
        IdealHex.ensureCacheSize(this.width + 1, this.height + 1);
    }

    @Override
    public void initializeAround(int n, int n2) {
        this.initializeHex(n, n2);
        for (int i = 0; i < 6; ++i) {
            this.initializeInDir(n, n2, i);
        }
    }

    private void initializeInDir(int n, int n2, int n3) {
        this.initializeHex(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
    }

    private void initializeHex(int n, int n2) {
        IHex iHex = this.getHex(n, n2);
        if (iHex == null) {
            return;
        }
        iHex.clearExits();
        for (int i = 0; i < 6; ++i) {
            IHex iHex2 = this.getHexInDir(n, n2, i);
            iHex.setExits(iHex2, i, this.roadsAutoExit);
        }
        this.processBoardEvent(new BoardEvent(this, new Coords(n, n2), 1));
    }

    @Override
    public boolean contains(int n, int n2) {
        return n >= 0 && n2 >= 0 && n < this.width && n2 < this.height;
    }

    @Override
    public boolean contains(Coords coords) {
        if (coords == null) {
            return false;
        }
        return this.contains(coords.x, coords.y);
    }

    @Override
    public IHex getHex(Coords coords) {
        if (coords == null) {
            return null;
        }
        return this.getHex(coords.x, coords.y);
    }

    @Override
    public void setHex(int n, int n2, IHex iHex) {
        this.data[n2 * this.width + n] = iHex;
        this.initializeAround(n, n2);
    }

    @Override
    public void setHex(Coords coords, IHex iHex) {
        this.setHex(coords.x, coords.y, iHex);
    }

    public static boolean boardIsSize(String string, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("data/boards" + File.separator + string));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.commentChar(35);
            streamTokenizer.quoteChar(34);
            streamTokenizer.wordChars(95, 95);
            while (streamTokenizer.nextToken() != -1) {
                if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase("size")) continue;
                streamTokenizer.nextToken();
                n3 = (int)streamTokenizer.nval;
                streamTokenizer.nextToken();
                n4 = (int)streamTokenizer.nval;
                break;
            }
            ((Reader)bufferedReader).close();
        }
        catch (IOException iOException) {
            return false;
        }
        return n3 == n && n4 == n2;
    }

    @Override
    public boolean isLegalDeployment(Coords coords, Player player) {
        if (coords == null || player == null || !this.contains(coords)) {
            return false;
        }
        int n = 3;
        int n2 = player.getStartingPos();
        int n3 = 0;
        int n4 = this.width;
        int n5 = 0;
        int n6 = this.height;
        if (n2 > 10) {
            n2 -= 10;
            n3 = this.width / 5;
            n5 = this.height / 5;
            if (coords.x < n3 || coords.y < n5 || coords.x >= (n4 -= this.width / 5) || coords.y >= (n6 -= this.height / 5)) {
                return false;
            }
        }
        switch (n2) {
            case 0: {
                return true;
            }
            case 1: {
                return coords.x < n3 + n && coords.x >= n3 && coords.y < this.height / 2 || coords.y < n5 + n && coords.y >= n5 && coords.x < this.width / 2;
            }
            case 2: {
                return coords.y < n5 + n && coords.y >= n5;
            }
            case 3: {
                return coords.x > n4 - n && coords.x < n4 && coords.y < this.height / 2 || coords.y < n5 + n && coords.y >= n5 && coords.x > this.width / 2;
            }
            case 4: {
                return coords.x >= n4 - n && coords.x < n4;
            }
            case 5: {
                return coords.x >= n4 - n && coords.x < n4 && coords.y > this.height / 2 || coords.y >= n6 - n && coords.y < n6 && coords.x > this.width / 2;
            }
            case 6: {
                return coords.y >= n6 - n && coords.y < n6;
            }
            case 7: {
                return coords.x < n3 + n && coords.x >= n3 && coords.y > this.height / 2 || coords.y >= n6 - n && coords.y < n6 && coords.x < this.width / 2;
            }
            case 8: {
                return coords.x < n3 + n && coords.x >= n3;
            }
            case 9: {
                return coords.x < n3 + n && coords.x >= n3 || coords.y < n5 + n && coords.y >= n5 || coords.x >= n4 - n && coords.x < n4 || coords.y >= n6 - n && coords.y < n6;
            }
            case 10: {
                return coords.x >= this.width / 3 && coords.x <= 2 * this.width / 3 && coords.y >= this.height / 3 && coords.y <= 2 * this.height / 3;
            }
        }
        return false;
    }

    @Override
    public void load(String string) {
        try {
            FileInputStream fileInputStream = new FileInputStream(new File("data/boards", string));
            this.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            System.err.println("error opening file to load board!");
            System.err.println(iOException);
        }
    }

    @Override
    public void load(InputStream inputStream) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        IHex[] iHexArray = new IHex[]{};
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.eolIsSignificant(true);
            streamTokenizer.commentChar(35);
            streamTokenizer.quoteChar(34);
            streamTokenizer.wordChars(95, 95);
            int n4 = 1;
            int n5 = 1;
            while (streamTokenizer.nextToken() != -1) {
                int n6;
                String[] stringArray;
                if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("size")) {
                    stringArray = new String[]{"0", "0"};
                    n6 = 0;
                    while (streamTokenizer.nextToken() == -3 || streamTokenizer.ttype == 34 || streamTokenizer.ttype == -2) {
                        stringArray[n6++] = streamTokenizer.ttype == -2 ? (int)streamTokenizer.nval + "" : streamTokenizer.sval;
                    }
                    n = Integer.parseInt(stringArray[0]);
                    n2 = Integer.parseInt(stringArray[1]);
                    iHexArray = new IHex[n * n2];
                    n3 = 0;
                    continue;
                }
                if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("option")) {
                    stringArray = new String[]{"", ""};
                    n6 = 0;
                    while (streamTokenizer.nextToken() == -3 || streamTokenizer.ttype == 34 || streamTokenizer.ttype == -2) {
                        stringArray[n6++] = streamTokenizer.ttype == -2 ? (int)streamTokenizer.nval + "" : streamTokenizer.sval;
                    }
                    if (!stringArray[0].equalsIgnoreCase("exit_roads_to_pavement")) continue;
                    if (stringArray[1].equalsIgnoreCase("false")) {
                        this.roadsAutoExit = false;
                        continue;
                    }
                    this.roadsAutoExit = true;
                    continue;
                }
                if (streamTokenizer.ttype == -3 && streamTokenizer.sval.equalsIgnoreCase("hex")) {
                    stringArray = new String[]{"", "0", "", ""};
                    n6 = 0;
                    while (streamTokenizer.nextToken() == -3 || streamTokenizer.ttype == 34 || streamTokenizer.ttype == -2) {
                        stringArray[n6++] = streamTokenizer.ttype == -2 ? (int)streamTokenizer.nval + "" : streamTokenizer.sval;
                    }
                    int n7 = Integer.parseInt(stringArray[1]);
                    int n8 = this.indexFor(stringArray[0], n, n5);
                    iHexArray[n8] = new Hex(n7, stringArray[2], stringArray[3]);
                    if (++n4 <= n) continue;
                    ++n5;
                    n4 = 1;
                    continue;
                }
                if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equalsIgnoreCase("end")) continue;
                break;
            }
        }
        catch (IOException iOException) {
            System.err.println("i/o error reading board");
            System.err.println(iOException);
        }
        System.out.println("loading board,loaded, processing" + new Date());
        for (int i = 0; i < iHexArray.length; ++i) {
            if (iHexArray[i] != null) continue;
            iHexArray[i] = new Hex();
        }
        if (n > 1 || n2 > 1 || n3 == n * n2) {
            this.newData(n, n2, iHexArray);
        } else {
            System.err.println("board data invalid");
        }
    }

    private int indexFor(String string, int n, int n2) {
        int n3 = 2;
        if (n2 > 99) {
            n3 = Integer.toString(n).length();
        }
        int n4 = Integer.parseInt(string.substring(0, string.length() - n3)) - 1;
        int n5 = Integer.parseInt(string.substring(string.length() - n3)) - 1;
        return n5 * n + n4;
    }

    @Override
    public void save(OutputStream outputStream) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            outputStreamWriter.write("size " + this.width + " " + this.height + "\r\n");
            if (!this.roadsAutoExit) {
                outputStreamWriter.write("option exit_roads_to_pavement false\r\n");
            }
            for (int i = 0; i < this.data.length; ++i) {
                IHex iHex = this.data[i];
                boolean bl = true;
                StringBuffer stringBuffer = new StringBuffer("hex ");
                stringBuffer.append(new Coords(i % this.width, i / this.width).getBoardNum());
                stringBuffer.append(" ");
                stringBuffer.append(iHex.getElevation());
                stringBuffer.append(" \"");
                for (int j = 0; j < Terrains.SIZE; ++j) {
                    ITerrain iTerrain = iHex.getTerrain(j);
                    if (iTerrain == null) continue;
                    if (!bl) {
                        stringBuffer.append(";");
                    }
                    stringBuffer.append(iTerrain.toString());
                    if (!(10 != j && j != 34 || iTerrain.hasExitsSpecified() || iTerrain.getExits() == 0)) {
                        stringBuffer.append(":").append(iTerrain.getExits());
                    }
                    bl = false;
                }
                stringBuffer.append("\" \"");
                if (iHex.getTheme() != null) {
                    stringBuffer.append(iHex.getTheme());
                }
                stringBuffer.append("\"\r\n");
                outputStreamWriter.write(stringBuffer.toString());
            }
            outputStreamWriter.write("end\r\n");
            ((Writer)outputStreamWriter).flush();
        }
        catch (IOException iOException) {
            System.err.println("i/o error writing board");
            System.err.println(iOException);
        }
    }

    public void save2(OutputStream outputStream) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            System.err.println("i/o error writing board");
            System.err.println(iOException);
        }
    }

    @Override
    public void addInfernoTo(Coords coords, InfernoTracker.Inferno inferno, int n) {
        InfernoTracker infernoTracker = null;
        if (n < 0) {
            throw new IllegalArgumentException("Board can't track negative hits. ");
        }
        if (!this.contains(coords)) {
            return;
        }
        infernoTracker = this.infernos.get(coords);
        if (null == infernoTracker) {
            infernoTracker = new InfernoTracker();
            this.infernos.put(coords, infernoTracker);
        }
        infernoTracker.add(inferno, n);
    }

    @Override
    public void removeInfernoFrom(Coords coords) {
        if (!this.contains(coords)) {
            return;
        }
        this.infernos.remove(coords);
    }

    @Override
    public boolean isInfernoBurning(Coords coords) {
        boolean bl = false;
        InfernoTracker infernoTracker = null;
        infernoTracker = this.infernos.get(coords);
        if (null != infernoTracker && infernoTracker.isStillBurning()) {
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean burnInferno(Coords coords) {
        boolean bl = false;
        InfernoTracker infernoTracker = null;
        infernoTracker = this.infernos.get(coords);
        if (null != infernoTracker) {
            infernoTracker.newRound(-1);
            if (infernoTracker.isStillBurning()) {
                bl = true;
            } else {
                this.infernos.remove(coords);
            }
        }
        return bl;
    }

    @Override
    public Enumeration<Coords> getInfernoBurningCoords() {
        Vector<Coords> vector = new Vector<Coords>();
        Enumeration<Coords> enumeration = this.infernos.keys();
        while (enumeration.hasMoreElements()) {
            Coords coords = enumeration.nextElement();
            if (!this.isInfernoBurning(coords)) continue;
            vector.addElement(coords);
        }
        return vector.elements();
    }

    @Override
    public int getInfernoBurnTurns(Coords coords) {
        int n = 0;
        InfernoTracker infernoTracker = null;
        infernoTracker = this.infernos.get(coords);
        if (null != infernoTracker) {
            n = infernoTracker.getTurnsLeftToBurn();
        }
        return n;
    }

    @Override
    public int getInfernoIVBurnTurns(Coords coords) {
        int n = 0;
        InfernoTracker infernoTracker = null;
        infernoTracker = this.infernos.get(coords);
        if (null != infernoTracker) {
            n = infernoTracker.getArrowIVTurnsLeftToBurn();
        }
        return n;
    }

    @Override
    public Enumeration<Building> getBuildings() {
        return this.buildings.elements();
    }

    @Override
    public Building getBuildingAt(Coords coords) {
        return this.bldgByCoords.get(coords);
    }

    private Building getLocalBuilding(Building building) {
        if (building == null) {
            return null;
        }
        Building building2 = null;
        Enumeration<Coords> enumeration = building.getCoords();
        if (enumeration.hasMoreElements() && !building.equals(building2 = this.bldgByCoords.get(enumeration.nextElement()))) {
            building2 = null;
        }
        return building2;
    }

    @Override
    public void collapseBuilding(Vector<Building> vector) {
        Enumeration<Building> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Building building = enumeration.nextElement();
            Building building2 = this.getLocalBuilding(building);
            if (building2 == null) {
                System.err.print("Could not find a match for ");
                System.err.print(building);
                System.err.println(" to collapse.");
                continue;
            }
            this.collapseBuilding(building2);
        }
    }

    @Override
    public void collapseBuilding(Coords coords) {
        IHex iHex = this.getHex(coords);
        int n = iHex.getElevation();
        this.bldgByCoords.remove(coords);
        int n2 = Math.min(iHex.terrainLevel(10), 4);
        n2 = Math.max(n2, iHex.terrainLevel(14));
        n2 = Math.max(n2, iHex.terrainLevel(34));
        iHex.removeTerrain(10);
        iHex.removeTerrain(11);
        iHex.removeTerrain(12);
        iHex.removeTerrain(34);
        iHex.removeTerrain(35);
        iHex.removeTerrain(36);
        iHex.removeTerrain(14);
        iHex.removeTerrain(15);
        iHex.removeTerrain(16);
        if (n2 > 0) {
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(3, n2));
        }
        if (iHex.containsTerrain(13)) {
            iHex.removeTerrain(13);
            iHex.setElevation(n -= iHex.terrainLevel(13));
        }
        this.setHex(coords, iHex);
    }

    @Override
    public void collapseBuilding(Building building) {
        this.buildings.removeElement(building);
        Enumeration<Coords> enumeration = building.getCoords();
        while (enumeration.hasMoreElements()) {
            Coords coords = enumeration.nextElement();
            this.collapseBuilding(coords);
        }
    }

    @Override
    public void updateBuildingCF(Vector<Building> vector) {
        Enumeration<Building> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Building building = enumeration.nextElement();
            Building building2 = this.getLocalBuilding(building);
            if (building2 == null) {
                System.err.print("Could not find a match for ");
                System.err.print(building);
                System.err.println(" to update.");
                continue;
            }
            building2.setCurrentCF(building.getCurrentCF());
            building2.setPhaseCF(building.getPhaseCF());
        }
    }

    @Override
    public boolean getRoadsAutoExit() {
        return this.roadsAutoExit;
    }

    @Override
    public void setRoadsAutoExit(boolean bl) {
        this.roadsAutoExit = bl;
    }

    private void createBldgByCoords() {
        this.bldgByCoords = new Hashtable();
        Enumeration<Building> enumeration = this.buildings.elements();
        while (enumeration.hasMoreElements()) {
            Building building = enumeration.nextElement();
            Enumeration<Coords> enumeration2 = building.getCoords();
            while (enumeration2.hasMoreElements()) {
                this.bldgByCoords.put(enumeration2.nextElement(), building);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.createBldgByCoords();
    }

    @Override
    public void addBoardListener(BoardListener boardListener) {
        if (this.boardListeners == null) {
            this.boardListeners = new Vector();
        }
        this.boardListeners.addElement(boardListener);
    }

    @Override
    public void removeBoardListener(BoardListener boardListener) {
        if (this.boardListeners != null) {
            this.boardListeners.removeElement(boardListener);
        }
    }

    protected void processBoardEvent(BoardEvent boardEvent) {
        if (this.boardListeners == null) {
            return;
        }
        Enumeration<BoardListener> enumeration = this.boardListeners.elements();
        while (enumeration.hasMoreElements()) {
            BoardListener boardListener = enumeration.nextElement();
            switch (boardEvent.getType()) {
                case 1: {
                    boardListener.boardChangedHex(boardEvent);
                    break;
                }
                case 0: {
                    boardListener.boardNewBoard(boardEvent);
                }
            }
        }
    }

    protected Vector<BoardListener> getListeners() {
        if (this.boardListeners == null) {
            this.boardListeners = new Vector();
        }
        return this.boardListeners;
    }

    @Override
    public Hashtable<Coords, InfernoTracker> getInfernos() {
        return this.infernos;
    }

    @Override
    public void setBridgeCF(int n) {
        Enumeration<Building> enumeration = this.buildings.elements();
        while (enumeration.hasMoreElements()) {
            Building building = enumeration.nextElement();
            Enumeration<Coords> enumeration2 = building.getCoords();
            while (enumeration2.hasMoreElements()) {
                Coords coords = enumeration2.nextElement();
                IHex iHex = this.getHex(coords);
                if (!iHex.containsTerrain(14)) continue;
                building.setCurrentCF(n);
            }
        }
    }

    @Override
    public Collection<SpecialHexDisplay> getSpecialHexDisplay(Coords coords) {
        return this.specialHexes.get(coords);
    }

    @Override
    public void addSpecialHexDisplay(Coords coords, SpecialHexDisplay specialHexDisplay) {
        Collection<Object> collection;
        if (!this.specialHexes.containsKey(coords)) {
            collection = new LinkedList();
            this.specialHexes.put(coords, collection);
        } else {
            collection = this.specialHexes.get(coords);
        }
        collection.add(specialHexDisplay);
    }

    @Override
    public Hashtable<Coords, Collection<SpecialHexDisplay>> getSpecialHexDisplayTable() {
        return this.specialHexes;
    }

    @Override
    public void setSpecialHexDisplayTable(Hashtable<Coords, Collection<SpecialHexDisplay>> hashtable) {
        this.specialHexes = hashtable;
    }

    @Override
    public void setType(int n) {
        this.mapType = n;
    }

    @Override
    public int getType() {
        return this.mapType;
    }

    public static String getTypeName(int n) {
        return typeNames[n];
    }

    @Override
    public boolean onGround() {
        return this.mapType == 0;
    }

    @Override
    public boolean inAtmosphere() {
        return this.mapType == 1;
    }

    @Override
    public boolean inSpace() {
        return this.mapType == 2;
    }
}

