/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import megamek.common.Aero;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.FighterSquadron;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.LocationFullException;
import megamek.common.LosEffects;
import megamek.common.MMRandom;
import megamek.common.MMRoll;
import megamek.common.Mech;
import megamek.common.MechWarrior;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.RangeType;
import megamek.common.Roll;
import megamek.common.Tank;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.UnitType;
import megamek.common.VTOL;
import megamek.common.WeaponType;
import megamek.common.actions.BreakGrappleAttackAction;
import megamek.common.actions.BrushOffAttackAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.GrappleAttackAction;
import megamek.common.actions.JumpJetAttackAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.LayExplosivesAttackAction;
import megamek.common.actions.ProtomechPhysicalAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.ThrashAttackAction;
import megamek.common.actions.TripAttackAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.BayWeapon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compute {
    public static final int ARC_360 = 0;
    public static final int ARC_FORWARD = 1;
    public static final int ARC_LEFTARM = 2;
    public static final int ARC_RIGHTARM = 3;
    public static final int ARC_REAR = 4;
    public static final int ARC_LEFTSIDE = 5;
    public static final int ARC_RIGHTSIDE = 6;
    public static final int ARC_MAINGUN = 7;
    public static final int ARC_NORTH = 8;
    public static final int ARC_EAST = 9;
    public static final int ARC_WEST = 10;
    public static final int ARC_NOSE = 11;
    public static final int ARC_LWING = 12;
    public static final int ARC_RWING = 13;
    public static final int ARC_LWINGA = 14;
    public static final int ARC_RWINGA = 15;
    public static final int ARC_AFT = 16;
    public static final int ARC_LEFTSIDE_SPHERE = 17;
    public static final int ARC_RIGHTSIDE_SPHERE = 18;
    public static final int ARC_LEFTSIDEA_SPHERE = 19;
    public static final int ARC_RIGHTSIDEA_SPHERE = 20;
    public static final int ARC_LEFT_BROADSIDE = 21;
    public static final int ARC_RIGHT_BROADSIDE = 22;
    public static final int ARC_LEFT_SPHERE_GROUND = 23;
    public static final int ARC_RIGHT_SPHERE_GROUND = 24;
    public static final int TYPE_IS = 0;
    public static final int TYPE_CLAN = 1;
    public static final int TYPE_MD = 2;
    public static final int LEVEL_GREEN = 0;
    public static final int LEVEL_REGULAR = 1;
    public static final int LEVEL_VETERAN = 2;
    public static final int LEVEL_ELITE = 3;
    public static final int METHOD_TW = 0;
    public static final int METHOD_TAHARQA = 1;
    public static final int METHOD_CONSTANT = 2;
    private static final int[][] skillLevels = new int[][]{{7, 6, 5, 4, 4, 3, 2, 1, 0}, {7, 7, 6, 6, 5, 4, 3, 2, 1}};
    private static MMRandom random = MMRandom.generate(1);
    private static final int[][] clusterHitsTable = new int[][]{{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {2, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2}, {3, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3}, {4, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4}, {5, 1, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5}, {6, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6}, {7, 2, 2, 3, 4, 4, 4, 4, 6, 6, 7, 7}, {8, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 8}, {9, 3, 3, 4, 5, 5, 5, 5, 7, 7, 9, 9}, {10, 3, 3, 4, 6, 6, 6, 6, 8, 8, 10, 10}, {11, 4, 4, 5, 7, 7, 7, 7, 9, 9, 11, 11}, {12, 4, 4, 5, 8, 8, 8, 8, 10, 10, 12, 12}, {13, 4, 4, 5, 8, 8, 8, 8, 11, 11, 13, 13}, {14, 5, 5, 6, 9, 9, 9, 9, 11, 11, 14, 14}, {15, 5, 5, 6, 9, 9, 9, 9, 12, 12, 15, 15}, {16, 5, 5, 7, 10, 10, 10, 10, 13, 13, 16, 16}, {17, 5, 5, 7, 10, 10, 10, 10, 14, 14, 17, 17}, {18, 6, 6, 8, 11, 11, 11, 11, 14, 14, 18, 18}, {19, 6, 6, 8, 11, 11, 11, 11, 15, 15, 19, 19}, {20, 6, 6, 9, 12, 12, 12, 12, 16, 16, 20, 20}, {21, 7, 7, 9, 13, 13, 13, 13, 17, 17, 21, 21}, {22, 7, 7, 9, 14, 14, 14, 14, 18, 18, 22, 22}, {23, 7, 7, 10, 15, 15, 15, 15, 19, 19, 23, 23}, {24, 8, 8, 10, 16, 16, 16, 16, 20, 20, 24, 24}, {25, 8, 8, 10, 16, 16, 16, 16, 21, 21, 25, 25}, {26, 9, 9, 11, 17, 17, 17, 17, 21, 21, 26, 26}, {27, 9, 9, 11, 17, 17, 17, 17, 22, 22, 27, 27}, {28, 9, 9, 11, 17, 17, 17, 17, 23, 23, 28, 28}, {29, 10, 10, 12, 18, 18, 18, 18, 23, 23, 29, 29}, {30, 10, 10, 12, 18, 18, 18, 18, 24, 24, 30, 30}, {40, 12, 12, 18, 24, 24, 24, 24, 32, 32, 40, 40}};
    private static float[] expectedHitsByRackSize = new float[]{0.0f, 1.0f, 1.58f, 2.0f, 2.63f, 3.17f, 4.0f, 4.49f, 4.98f, 5.47f, 6.31f, 7.23f, 8.14f, 8.59f, 9.04f, 9.5f, 10.1f, 10.8f, 11.42f, 12.1f, 12.7f};

    public static int d6(int n) {
        Roll roll = random.d6(n);
        return roll.getIntValue();
    }

    public static int d6() {
        Roll roll = random.d6();
        return roll.getIntValue();
    }

    public static int randomInt(int n) {
        MMRoll mMRoll = new MMRoll(random, n);
        return ((Roll)mMRoll).getIntValue();
    }

    public static void setRNG(int n) {
        random = MMRandom.generate(n);
    }

    public static double oddsAbove(int n) {
        if (n <= 2) {
            return 100.0;
        }
        if (n > 12) {
            return 0.0;
        }
        double[] dArray = new double[]{100.0, 100.0, 100.0, 97.2, 91.6, 83.3, 72.2, 58.3, 41.6, 27.7, 16.6, 8.3, 2.78, 0.0};
        return dArray[n];
    }

    public static Entity stackingViolation(IGame iGame, int n, Coords coords) {
        Entity entity = iGame.getEntity(n);
        return Compute.stackingViolation(iGame, entity, coords, null);
    }

    public static Entity stackingViolation(IGame iGame, Entity entity, Coords coords, Entity entity2) {
        if (!iGame.getBoard().onGround()) {
            return null;
        }
        boolean bl = entity instanceof Mech;
        Entity entity3 = entity2;
        int n = 1;
        int n2 = entity.getElevation();
        if (coords != null && entity.getPosition() != null) {
            n2 = entity.calcElevation(iGame.getBoard().getHex(entity.getPosition()), iGame.getBoard().getHex(coords));
        }
        int n3 = n2 + entity.height();
        Enumeration<Entity> enumeration = iGame.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            Entity entity4 = enumeration.nextElement();
            int n4 = entity4.getElevation();
            int n5 = n4 + entity4.height();
            if (n2 > n5 || n3 < n4 || entity4.equals(entity) || entity4.equals(entity2) || entity4.isMakingDfa()) continue;
            if (bl && entity4 instanceof Mech && ((Mech)entity4).getGrappled() != entity.getId()) {
                return entity4;
            }
            if (++n > 4) {
                return entity4;
            }
            if (entity4.getOwner().isEnemyOf(entity.getOwner())) continue;
            if (entity3 == null) {
                entity3 = entity4;
                continue;
            }
            return Compute.d6() > 3 ? entity3 : entity4;
        }
        return null;
    }

    public static boolean isEnemyIn(IGame iGame, Entity entity, Coords coords, boolean bl, boolean bl2, int n) {
        int n2 = n + entity.getHeight();
        Enumeration<Entity> enumeration = iGame.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            Entity entity2 = enumeration.nextElement();
            int n3 = entity2.getElevation();
            int n4 = n3 + entity2.getHeight();
            if (bl && !(entity2 instanceof Mech) || bl2 && entity2 instanceof Infantry || !entity2.isEnemyOf(entity) || entity2.isMakingDfa() || n > n4 || n2 < n3) continue;
            return true;
        }
        return false;
    }

    public static boolean isPilotingSkillNeeded(IGame iGame, int n, Coords coords, Coords coords2, int n2, boolean bl, boolean bl2, int n3, int n4, MovePath movePath) {
        Entity entity = iGame.getEntity(n);
        IHex iHex = iGame.getBoard().getHex(coords);
        IHex iHex2 = iGame.getBoard().getHex(coords2);
        boolean bl3 = entity instanceof Infantry;
        boolean bl4 = Compute.canMoveOnPavement(iGame, coords, coords2, movePath);
        if (entity == null) {
            throw new IllegalArgumentException("Entity invalid.");
        }
        if (coords.distance(coords2) > 1) {
            throw new IllegalArgumentException("Coordinates must be adjacent.");
        }
        if (coords.equals(coords2)) {
            return false;
        }
        if (n2 != 3 && iHex2.terrainLevel(3) > 0 && entity.getMovementMode() != 6 && !bl3) {
            return true;
        }
        if (iHex2.containsTerrain(9) && entity.getElevation() <= iHex2.getElevation() && entity.getMovementMode() != 5 && entity.getMovementMode() != 6 && n2 != 3 && entity.getMovementMode() != 15) {
            return true;
        }
        if (iHex2.containsTerrain(20) && iHex2.containsTerrain(4) && entity.getElevation() <= iHex2.getElevation() && !bl4 && n2 != 3) {
            return true;
        }
        if (n2 != 3 && entity.getElevation() <= iHex2.surface() && entity.getMovementMode() != 5 && entity.getMovementMode() != 7 && entity.getMovementMode() != 8 && entity.getMovementMode() != 9 && entity.getMovementMode() != 18 && entity.getMovementMode() != 13 && entity.getMovementMode() != 14 && entity.getMovementMode() != 15 && iHex2.terrainLevel(4) > 0 && !bl4) {
            return true;
        }
        if ((bl2 && n2 == 2 || iHex.containsTerrain(20) && n2 != 3) && entity.getMovementMode() != 5 && entity.getMovementMode() != 15 && bl && !bl3) {
            return true;
        }
        if (!(n3 >= iHex.terrainLevel(12) && n4 >= iHex2.terrainLevel(12) || entity instanceof Infantry)) {
            return true;
        }
        return !(!(entity instanceof VTOL) && entity.getMovementMode() != 5 && entity.getMovementMode() != 15 || !bl || n2 != 2 && n2 != 5);
    }

    public static boolean isValidDisplacement(IGame iGame, int n, Coords coords, int n2) {
        return Compute.isValidDisplacement(iGame, n, coords, coords.translated(n2));
    }

    public static boolean isValidDisplacement(IGame iGame, int n, Coords coords, Coords coords2) {
        Entity entity = iGame.getEntity(n);
        IHex iHex = iGame.getBoard().getHex(coords);
        IHex iHex2 = iGame.getBoard().getHex(coords2);
        ArrayList<Coords> arrayList = Coords.intervening(coords, coords2);
        int n2 = coords.direction(coords2);
        if (entity == null) {
            throw new IllegalArgumentException("Entity invalid.");
        }
        if (!iGame.getBoard().contains(coords2)) {
            return iGame.getOptions().booleanOption("push_off_board");
        }
        if (entity.isHexProhibited(iHex2) && (!(entity instanceof Tank) || !iHex2.containsTerrain(4) || entity.movementMode != 3 && entity.movementMode != 4)) {
            return false;
        }
        for (Coords coords3 : arrayList) {
            IHex iHex3 = iGame.getBoard().getHex(coords3);
            int n3 = entity.elevationOccupied(iHex3) - entity.elevationOccupied(iHex);
            if (n3 <= entity.getMaxElevationChange()) continue;
            return false;
        }
        Entity entity2 = Compute.stackingViolation(iGame, n, coords2);
        if (entity2 != null) {
            return Compute.isValidDisplacement(iGame, entity2.getId(), entity2.getPosition(), n2);
        }
        return true;
    }

    public static Coords getValidDisplacement(IGame iGame, int n, Coords coords, int n2) {
        int[] nArray = new int[]{0, 1, 5, 2, 4, 3};
        for (int i = 0; i < nArray.length; ++i) {
            Coords coords2 = coords.translated((n2 + nArray[i]) % 6);
            if (!Compute.isValidDisplacement(iGame, n, coords, coords2)) continue;
            return coords2;
        }
        return null;
    }

    public static Coords getPreferredDisplacement(IGame iGame, int n, Coords coords, int n2) {
        Entity entity = iGame.getEntity(n);
        int n3 = Integer.MIN_VALUE;
        Coords coords2 = null;
        int[] nArray = new int[]{0, 1, 5, 2, 4, 3};
        for (int i = 0; i < nArray.length; ++i) {
            Coords coords3 = coords.translated((n2 + nArray[i]) % 6);
            if (!Compute.isValidDisplacement(iGame, n, coords, coords3) || !iGame.getBoard().contains(coords3)) continue;
            IHex iHex = iGame.getBoard().getHex(coords3);
            int n4 = entity.elevationOccupied(iHex);
            if (n4 > n3) {
                n3 = n4;
                coords2 = coords3;
            }
            if (n4 != entity.getElevation()) continue;
            return coords3;
        }
        return coords2;
    }

    public static Coords getMissedChargeDisplacement(IGame iGame, int n, Coords coords, int n2) {
        Coords coords2 = coords.translated((n2 + 1) % 6);
        Coords coords3 = coords.translated((n2 + 5) % 6);
        IHex iHex = iGame.getBoard().getHex(coords2);
        IHex iHex2 = iGame.getBoard().getHex(coords3);
        Entity entity = iGame.getEntity(n);
        if (iHex != null && iHex2 != null && entity.elevationOccupied(iHex) <= entity.elevationOccupied(iHex2)) {
            if (entity.elevationOccupied(iHex) < entity.elevationOccupied(iHex2)) {
                Coords coords4 = coords2;
                coords2 = coords3;
                coords3 = coords4;
            } else if (Compute.d6() > 3) {
                Coords coords5 = coords2;
                coords2 = coords3;
                coords3 = coords5;
            }
        }
        if (Compute.isValidDisplacement(iGame, n, coords, coords.direction(coords2)) && iGame.getBoard().contains(coords2)) {
            return coords2;
        }
        if (Compute.isValidDisplacement(iGame, n, coords, coords.direction(coords3)) && iGame.getBoard().contains(coords3)) {
            return coords3;
        }
        return coords;
    }

    public static Entity findSpotter(IGame iGame, Entity entity, Targetable targetable) {
        Entity entity2 = null;
        int n = -1;
        if (targetable instanceof Entity) {
            n = ((Entity)targetable).getTaggedBy();
        }
        ToHitData toHitData = new ToHitData(Integer.MAX_VALUE, "");
        Enumeration<Entity> enumeration = iGame.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity3 = enumeration.nextElement();
            if ((!entity3.isSpotting() || entity3.getSpotTargetId() != targetable.getTargetId()) && n != entity3.getId() || entity.isEnemyOf(entity3)) continue;
            LosEffects losEffects = LosEffects.calculateLos(iGame, entity3.getId(), targetable);
            ToHitData toHitData2 = losEffects.losModifiers(iGame);
            losEffects.setTargetCover(0);
            toHitData2.append(Compute.getAttackerMovementModifier(iGame, entity3.getId()));
            if (entity3.isAttackingThisTurn()) {
                toHitData2.addModifier(1, "spotter is making an attack this turn");
            }
            if (entity2 != null && toHitData2.getValue() >= toHitData.getValue()) continue;
            entity2 = entity3;
            toHitData = toHitData2;
        }
        return entity2;
    }

    public static ToHitData getImmobileMod(Targetable targetable) {
        return Compute.getImmobileMod(targetable, -1, 0);
    }

    public static ToHitData getImmobileMod(Targetable targetable, int n, int n2) {
        if (targetable.isImmobile()) {
            if (targetable instanceof Mech && n == 0 && n2 == 1) {
                return new ToHitData(3, "aiming at head");
            }
            return new ToHitData(-4, "target immobile");
        }
        return null;
    }

    public static ToHitData getRangeMods(IGame iGame, Entity entity, int n, Targetable targetable) {
        TargetRoll targetRoll;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        boolean bl;
        Object object2;
        Mounted mounted = entity.getEquipment(n);
        WeaponType weaponType = (WeaponType)mounted.getType();
        int[] nArray = weaponType.getRanges();
        boolean bl2 = entity instanceof Infantry;
        boolean bl3 = weaponType.hasFlag(2048L);
        boolean bl4 = (weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 45 || weaponType.getAmmoType() == 37 || weaponType.getAmmoType() == 49 || weaponType.getAmmoType() == 50 || weaponType.getAmmoType() == 51 || weaponType.getAmmoType() == 52 || weaponType.getAmmoType() == 8) && mounted.curMode().equals("Indirect");
        boolean bl5 = iGame.getOptions().booleanOption("maxtech_range");
        if (entity instanceof Aero) {
            bl5 = true;
        }
        ToHitData toHitData = new ToHitData();
        if (weaponType.getAmmoType() == 28) {
            object2 = (AmmoType)mounted.getLinked().getType();
            if (((AmmoType)object2).getAmmoType() == 28 && ((AmmoType)object2).getMunitionType() == 64L) {
                nArray = new int[]{4, 9, 18, 27, 36};
            } else if (((AmmoType)object2).getAmmoType() == 28 && ((AmmoType)object2).getMunitionType() == 128L) {
                nArray = new int[]{0, 3, 6, 9, 12};
            }
        }
        if (weaponType.getAmmoType() == 45) {
            object2 = (AmmoType)mounted.getLinked().getType();
            if (((EquipmentType)object2).hasFlag(32L) || weaponType.getAmmoType() == 8) {
                weaponType.setRanges(7, 14, 21, 28);
                weaponType.setMinimumRange(6);
            } else {
                weaponType.setRanges(3, 6, 9, 12);
                weaponType.setMinimumRange(0);
            }
            nArray = weaponType.getRanges();
        }
        if (weaponType.hasFlag(8L) && iGame.getOptions().booleanOption("maxtech_ppc_inhibitors") && mounted.curMode() != null && mounted.curMode().equals("Field Inhibitor OFF")) {
            nArray[0] = 0;
        }
        if (mounted.isHotLoaded() && iGame.getOptions().booleanOption("maxtech_hotload")) {
            nArray[0] = 0;
        }
        object2 = iGame.getBoard().getHex(targetable.getPosition());
        int n6 = targetable.absHeight();
        int n7 = targetable.getElevation();
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = bl = entity.getLocationStatus(mounted.getLocation()) == 2;
        if (targetable.getTargetType() == 0 && object2.containsTerrain(4) && n7 < 0) {
            if (n6 >= 0) {
                bl6 = true;
            } else {
                bl7 = true;
            }
        }
        Entity entity2 = null;
        if (targetable instanceof Entity) {
            entity2 = (Entity)targetable;
            if (n7 == 0 && UnitType.determineUnitTypeCode(entity2) == 6) {
                bl6 = true;
            }
        }
        if ((bl7 || weaponType.getAmmoType() == 8 || weaponType.getAmmoType() == 10) && UnitType.determineUnitTypeCode(entity) == 6) {
            bl = true;
            nArray = weaponType.getWRanges();
        }
        if (object2.containsTerrain(4) && targetable.getTargetType() == 1) {
            bl6 = true;
        }
        if (bl) {
            nArray = weaponType.getWRanges();
            n5 = 0;
            if (weaponType.getAmmoType() == 9 || weaponType.getAmmoType() == 12 || weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 45) {
                AmmoType ammoType = (AmmoType)mounted.getLinked().getType();
                if (ammoType.getMunitionType() == 0x40000000L) {
                    nArray = weaponType.getRanges();
                } else if (ammoType.getMunitionType() == 0x8000000L) {
                    nArray = weaponType.getRanges();
                    n5 = 1;
                }
            }
            if (nArray[1] == 0) {
                return new ToHitData(Integer.MAX_VALUE, "Weapon cannot fire underwater.");
            }
            if (!bl7 && !bl6 && n5 == 0) {
                return new ToHitData(Integer.MAX_VALUE, "Weapon underwater, but not target.");
            }
            if (entity2 != null && UnitType.determineUnitTypeCode(entity2) == 6 && entity instanceof Mech && entity.height() > 0 && entity.getElevation() == -1) {
                return new ToHitData(Integer.MAX_VALUE, "Partially submerged mech cannot fire leg weapons at surface naval vessels.");
            }
        } else {
            if (bl7) {
                return new ToHitData(Integer.MAX_VALUE, "Target underwater, but not weapon.");
            }
            if (weaponType.getAmmoType() == 8 || weaponType.getAmmoType() == 10) {
                return new ToHitData(Integer.MAX_VALUE, "Weapon can only fire underwater.");
            }
        }
        if (entity instanceof Aero) {
            nArray = weaponType.getATRanges();
        }
        n5 = Compute.effectiveDistance(iGame, entity, targetable);
        int n8 = RangeType.rangeBracket(n5, nArray, bl5);
        int n9 = weaponType.getMaxRange();
        if (weaponType instanceof BayWeapon) {
            object = mounted.getBayWeapons().iterator();
            while (object.hasNext()) {
                n4 = object.next();
                Mounted mounted2 = entity.getEquipment(n4);
                WeaponType weaponType2 = (WeaponType)mounted2.getType();
                if (weaponType2.getMaxRange() <= n9) continue;
                n9 = weaponType2.getMaxRange();
            }
        }
        if (entity instanceof Aero && n8 > n9) {
            n8 = Integer.MAX_VALUE;
        }
        if (n8 == Integer.MAX_VALUE) {
            return new ToHitData(0x7FFFFFFE, "Target out of range");
        }
        if (!(n5 != 0 || bl2 || entity instanceof Mech && ((Mech)entity).getGrappled() == targetable.getTargetId())) {
            return new ToHitData(0x7FFFFFFE, "Only infantry shoot at zero range");
        }
        if (iGame.getBoard().inAtmosphere() && entity instanceof Aero && targetable instanceof Aero && (n3 = Math.abs(entity.getElevation() - targetable.getElevation())) >= (n4 = n5 - n3)) {
            return new ToHitData(Integer.MAX_VALUE, "Target in dead zone");
        }
        object = Compute.findC3Spotter(iGame, entity, targetable);
        if (bl4) {
            object = entity;
        }
        if (bl4 && iGame.getOptions().booleanOption("indirect_fire") && !iGame.getOptions().booleanOption("indirect_always_possible") && LosEffects.calculateLos(iGame, entity.getId(), targetable).canSee()) {
            return new ToHitData(Integer.MAX_VALUE, "Indirect fire impossible with direct LOS");
        }
        n4 = Compute.effectiveDistance(iGame, (Entity)object, targetable);
        int n10 = RangeType.rangeBracket(n4, nArray, bl5);
        int n11 = Math.min(n8, n10);
        String string = "";
        if (entity.getTargSysType() == 2 && entity.getTargSysType() == 3) {
            string = " (w/" + MiscType.getTargetSysName(entity.getTargSysType()) + ")";
        }
        if (n11 == n8) {
            if ((n8 == 1 || n8 == 0) && entity.getShortRangeModifier() != 0) {
                toHitData.addModifier(entity.getShortRangeModifier(), "short range" + string);
            } else if (n8 == 2) {
                toHitData.addModifier(entity.getMediumRangeModifier(), "medium range");
            } else if (n8 == 3) {
                if (entity instanceof Protomech && 2 == ((Protomech)entity).getCritsHit(0)) {
                    toHitData.addModifier(Integer.MAX_VALUE, "No long range attacks with destroyed head sensors.");
                } else {
                    toHitData.addModifier(entity.getLongRangeModifier(), "long range" + string);
                }
            } else if (n8 == 4) {
                if (entity instanceof Protomech && 2 == ((Protomech)entity).getCritsHit(0)) {
                    toHitData.addModifier(Integer.MAX_VALUE, "No extreme range attacks with destroyed head sensors.");
                } else {
                    toHitData.addModifier(entity.getExtremeRangeModifier(), "extreme range" + string);
                }
            }
        } else if (n10 == 1 || n10 == 0) {
            toHitData.addModifier(entity.getShortRangeModifier(), "short range due to C3 spotter" + string);
        } else if (n10 == 2) {
            toHitData.addModifier(entity.getMediumRangeModifier(), "medium range due to C3 spotter" + string);
        } else if (n10 == 3) {
            toHitData.addModifier(entity.getLongRangeModifier(), "long range due to C3 spotter" + string);
        }
        if (bl3 && n5 == 0) {
            if (weaponType.hasFlag(2L)) {
                toHitData.addModifier(-1, "infantry flamer assault");
            } else if (weaponType.getAmmoType() == 9 || weaponType.getAmmoType() == 7) {
                toHitData.addModifier(-1, "infantry missile assault");
            } else {
                toHitData.addModifier(-2, "infantry assault");
            }
        }
        if ((n2 = nArray[0]) > 0 && n5 <= n2) {
            int n12 = n2 - n5 + 1;
            toHitData.addModifier(n12, "minimum range");
        }
        if (targetable instanceof Entity && (targetRoll = ((Entity)targetable).getStealthModifier(n11, entity)).getValue() != 0) {
            toHitData.append(((Entity)targetable).getStealthModifier(n11, entity));
        }
        return toHitData;
    }

    public static int effectiveDistance(IGame iGame, Entity entity, Targetable targetable) {
        int n = entity.getPosition().distance(targetable.getPosition());
        if (Compute.isInSameBuilding(iGame, entity, targetable) || entity instanceof Aero && targetable instanceof Aero && iGame.getBoard().inAtmosphere()) {
            int n2 = entity.getElevation();
            int n3 = targetable.getElevation();
            n += Math.abs(n2 - n3);
        }
        return n;
    }

    private static Entity findC3Spotter(IGame iGame, Entity entity, Targetable targetable) {
        if (!entity.hasC3() && !entity.hasC3i()) {
            return entity;
        }
        if (entity.hasC3i()) {
            return Compute.findC3iSpotter(iGame, entity, targetable);
        }
        Entity entity2 = entity;
        int n = entity.getPosition().distance(targetable.getPosition());
        Enumeration<Entity> enumeration = iGame.getEntities();
        while (enumeration.hasMoreElements()) {
            int n2;
            Entity entity3 = enumeration.nextElement();
            if (entity.equals(entity3) || !entity3.isActive() || !entity.onSameC3NetworkAs(entity3) || (n2 = Compute.effectiveDistance(iGame, entity3, targetable)) >= n) continue;
            n = n2;
            entity2 = entity3;
        }
        return entity2;
    }

    private static Entity findC3iSpotter(IGame iGame, Entity entity, Targetable targetable) {
        int n;
        if (!entity.hasC3() && !entity.hasC3i()) {
            return entity;
        }
        Entity entity2 = entity;
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        Enumeration<Entity> enumeration = iGame.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity3 = enumeration.nextElement();
            if (entity.equals(entity3) || !entity.onSameC3NetworkAs(entity3, true)) continue;
            int n2 = Compute.effectiveDistance(iGame, entity3, targetable);
            n = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                if (Compute.effectiveDistance(iGame, (Entity)arrayList.get(i), targetable) < n2) continue;
                arrayList.add(i, entity3);
                n = 1;
                break;
            }
            if (n != 0) continue;
            arrayList.add(entity3);
        }
        int n3 = 0;
        for (Entity entity4 : arrayList) {
            if (!Compute.isAffectedByECM(entity4, entity4.getPosition(), entity.getPosition())) {
                return entity4;
            }
            if (Compute.isAffectedByECM(entity4, entity4.getPosition(), targetable.getPosition())) {
                ++n3;
                continue;
            }
            for (n = ++n3; n < arrayList.size(); ++n) {
                if (!Compute.canCompleteNodePath(entity4, entity, arrayList, n)) continue;
                return entity4;
            }
        }
        return entity2;
    }

    private static boolean canCompleteNodePath(Entity entity, Entity entity2, ArrayList<Entity> arrayList, int n) {
        Entity entity3 = arrayList.get(n);
        if (Compute.isAffectedByECM(entity3, entity.getPosition(), entity3.getPosition())) {
            return false;
        }
        if (!Compute.isAffectedByECM(entity3, entity3.getPosition(), entity2.getPosition())) {
            return true;
        }
        ++n;
        while (n < arrayList.size()) {
            if (Compute.canCompleteNodePath(entity3, entity2, arrayList, n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static ToHitData getProneMods(IGame iGame, Entity entity, int n) {
        if (!entity.isProne()) {
            return null;
        }
        ToHitData toHitData = new ToHitData();
        Mounted mounted = entity.getEquipment(n);
        if (entity.entityIsQuad()) {
            int n2 = ((Mech)entity).countBadLegs();
            if (n2 == 0) {
                return null;
            }
            if (n2 >= 3) {
                return new ToHitData(Integer.MAX_VALUE, "Prone with three or more legs destroyed.");
            }
            if (entity.isLocationBad(4) && entity.isLocationBad(5)) {
                return new ToHitData(Integer.MAX_VALUE, "Prone with both front legs destroyed.");
            }
            if (mounted.getLocation() == 4 || mounted.getLocation() == 5) {
                int n3;
                int n4 = n3 = mounted.getLocation() == 4 ? 5 : 4;
                if (Compute.isFiringFromArmAlready(iGame, n, entity, n3)) {
                    return new ToHitData(Integer.MAX_VALUE, "Prone and firing from other front leg already.");
                }
            }
            if (mounted.getLocation() == 7 || mounted.getLocation() == 6) {
                return new ToHitData(Integer.MAX_VALUE, "Can't fire rear leg-mounted weapons while prone with destroyed legs.");
            }
            toHitData.addModifier(2, "attacker prone");
        } else {
            int n5 = -1;
            if (entity.isLocationBad(4) || entity.isLocationBad(5)) {
                if (iGame.getOptions().booleanOption("maxtech_prone_fire")) {
                    if (entity.isLocationBad(4) && entity.isLocationBad(5)) {
                        return new ToHitData(Integer.MAX_VALUE, "Prone with both arms destroyed.");
                    }
                    n5 = entity.isLocationBad(4) ? 5 : 4;
                } else {
                    return new ToHitData(Integer.MAX_VALUE, "Prone with one or both arms destroyed.");
                }
            }
            if (mounted.getLocation() == 4 || mounted.getLocation() == 5) {
                int n6;
                if (n5 == mounted.getLocation()) {
                    return new ToHitData(Integer.MAX_VALUE, "Prone and propping up with this arm.");
                }
                int n7 = n6 = mounted.getLocation() == 4 ? 5 : 4;
                if (Compute.isFiringFromArmAlready(iGame, n, entity, n6)) {
                    return new ToHitData(Integer.MAX_VALUE, "Prone and firing from other arm already.");
                }
            }
            if (mounted.getLocation() == 7 || mounted.getLocation() == 6) {
                return new ToHitData(Integer.MAX_VALUE, "Can't fire leg-mounted weapons while prone.");
            }
            toHitData.addModifier(2, "attacker prone");
            if (n5 != -1) {
                toHitData.addModifier(1, "attacker propping on single arm");
            }
        }
        return toHitData;
    }

    private static boolean isFiringFromArmAlready(IGame iGame, int n, Entity entity, int n2) {
        int n3 = Mech.getInnerLocation(n2);
        Enumeration<EntityAction> enumeration = iGame.getActions();
        while (enumeration.hasMoreElements()) {
            EntityAction entityAction = enumeration.nextElement();
            if (!(entityAction instanceof WeaponAttackAction)) continue;
            WeaponAttackAction weaponAttackAction = (WeaponAttackAction)entityAction;
            if (weaponAttackAction.getEntityId() == entity.getId() && weaponAttackAction.getWeaponId() == n) break;
            if ((weaponAttackAction.getEntityId() != entity.getId() || entity.getEquipment(weaponAttackAction.getWeaponId()).getLocation() != n2) && (weaponAttackAction.getEntityId() != entity.getId() || entity.getEquipment(weaponAttackAction.getWeaponId()).getLocation() != n3 || !entity.getEquipment(weaponAttackAction.getWeaponId()).isSplit())) continue;
            return true;
        }
        return false;
    }

    public static ToHitData getDamageWeaponMods(Entity entity, Mounted mounted) {
        int n;
        ToHitData toHitData = new ToHitData();
        if (entity instanceof Protomech) {
            n = ((Protomech)entity).getCritsHit(0);
            if (n > 0) {
                toHitData.addModifier(n, n + " head critical(s)");
            }
            switch (mounted.getLocation()) {
                case 2: 
                case 3: {
                    n = ((Protomech)entity).getCritsHit(mounted.getLocation());
                    if (n <= 0) break;
                    toHitData.addModifier(n, n + " arm critical(s)");
                    break;
                }
                case 5: {
                    n = ((Protomech)entity).getCritsHit(3);
                    if (4 == (n += ((Protomech)entity).getCritsHit(2))) {
                        toHitData.addModifier(Integer.MAX_VALUE, "Cannot fire main gun with no arms.");
                        break;
                    }
                    if (n <= 0) break;
                    toHitData.addModifier(n, n + " arm critical(s)");
                }
            }
        } else {
            n = mounted.getLocation();
            if (mounted.isSplit()) {
                switch (n) {
                    case 3: {
                        n = 5;
                        break;
                    }
                    case 2: {
                        n = 4;
                        break;
                    }
                }
            }
            if (entity.getBadCriticals(0, 7, n) > 0) {
                toHitData.addModifier(4, "shoulder actuator destroyed");
            } else {
                int n2 = 0;
                if (entity.getBadCriticals(0, 8, n) > 0) {
                    ++n2;
                }
                if (entity.getBadCriticals(0, 9, n) > 0) {
                    ++n2;
                }
                if (n2 > 0) {
                    toHitData.addModifier(n2, n2 + " destroyed arm actuators");
                }
            }
        }
        n = entity.getBadCriticals(0, 1, 0);
        if (entity instanceof Mech && ((Mech)entity).getCockpitType() == 1) {
            if ((n += entity.getBadCriticals(0, 1, 1)) > 1) {
                toHitData.addModifier(4, "attacker sensors badly damaged");
            } else if (n > 0) {
                toHitData.addModifier(2, "attacker sensors damaged");
            }
        } else if (n > 0) {
            toHitData.addModifier(2, "attacker sensors damaged");
        }
        return toHitData;
    }

    public static ToHitData getSecondaryTargetMod(IGame iGame, Entity entity, Targetable targetable) {
        return Compute.getSecondaryTargetMod(iGame, entity, targetable, false);
    }

    public static ToHitData getSecondaryTargetMod(IGame iGame, Entity entity, Targetable targetable, boolean bl) {
        boolean bl2 = Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), targetable.getPosition(), 1);
        int n = -1;
        Enumeration<EntityAction> enumeration = iGame.getActions();
        while (enumeration.hasMoreElements()) {
            Targetable targetable2;
            WeaponAttackAction weaponAttackAction;
            EntityAction entityAction = enumeration.nextElement();
            if (!(entityAction instanceof WeaponAttackAction) || (weaponAttackAction = (WeaponAttackAction)entityAction).getEntityId() != entity.getId() || (targetable2 = iGame.getTarget(weaponAttackAction.getTargetType(), weaponAttackAction.getTargetId())) == null) continue;
            if (targetable2 instanceof Mech && ((Entity)targetable2).isStealthActive() && targetable2 != targetable && !bl) {
                return new ToHitData(Integer.MAX_VALUE, "When targeting a stealthed Mech, can not attack secondary targets");
            }
            if (Compute.isInArc(entity.getPosition(), entity.getSecondaryFacing(), targetable2.getPosition(), 1)) {
                n = weaponAttackAction.getTargetId();
                break;
            }
            if (n != -1 || bl2) continue;
            n = weaponAttackAction.getTargetId();
        }
        if (n == -1 || n == targetable.getTargetId()) {
            return null;
        }
        if (entity instanceof Infantry && !(entity instanceof BattleArmor)) {
            return new ToHitData(Integer.MAX_VALUE, "Can't have multiple targets.");
        }
        if (targetable instanceof Mech && ((Entity)targetable).isStealthActive()) {
            return new ToHitData(Integer.MAX_VALUE, "Can't target Mech with active stealth armor as secondary target");
        }
        if (bl2) {
            return new ToHitData(1, "secondary target modifier");
        }
        return new ToHitData(2, "secondary target modifier");
    }

    public static int getAffaDamageFor(Entity entity) {
        return (int)entity.getWeight() / 10;
    }

    public static ToHitData getAttackerMovementModifier(IGame iGame, int n) {
        return Compute.getAttackerMovementModifier(iGame, n, iGame.getEntity((int)n).moved);
    }

    public static ToHitData getAttackerMovementModifier(IGame iGame, int n, int n2) {
        Entity entity = iGame.getEntity(n);
        ToHitData toHitData = new ToHitData();
        if (entity instanceof Infantry) {
            return toHitData;
        }
        if (entity.getMovementMode() == 13 || entity.getMovementMode() == 14) {
            return toHitData;
        }
        if (n2 == 1 || n2 == 4) {
            toHitData.addModifier(1, "attacker walked");
        } else if (n2 == 2 || n2 == 5) {
            toHitData.addModifier(2, "attacker ran");
        } else if (n2 == -2) {
            toHitData.addModifier(3, "attacker ran and skidded");
        } else if (n2 == 3) {
            toHitData.addModifier(3, "attacker jumped");
        } else if (n2 == 10) {
            toHitData.addModifier(2, "over thrust used");
        }
        return toHitData;
    }

    public static ToHitData getSpotterMovementModifier(IGame iGame, int n) {
        return Compute.getSpotterMovementModifier(iGame, n, iGame.getEntity((int)n).moved);
    }

    public static ToHitData getSpotterMovementModifier(IGame iGame, int n, int n2) {
        ToHitData toHitData = new ToHitData();
        Entity entity = iGame.getEntity(n);
        if (entity != null && entity instanceof Infantry) {
            return toHitData;
        }
        if (n2 == 1 || n2 == 4) {
            toHitData.addModifier(1, "spotter walked");
        } else if (n2 == 2 || n2 == 5 || n2 == -2) {
            toHitData.addModifier(2, "spotter ran");
        } else if (n2 == 3) {
            toHitData.addModifier(3, "spotter jumped");
        }
        return toHitData;
    }

    public static void modifyPhysicalBTHForAdvantages(Entity entity, Entity entity2, ToHitData toHitData, IGame iGame) {
        if (entity.getCrew().getOptions().booleanOption("melee_specialist") && entity instanceof Mech && Compute.getAttackerMovementModifier(iGame, entity.getId()).getValue() > 0) {
            toHitData.addModifier(-1, "melee specialist");
        }
        if (entity.getCrew().getOptions().booleanOption("clan_pilot_training")) {
            toHitData.addModifier(1, "clan pilot training");
        }
        if (entity2 != null && entity2 instanceof Mech && entity2.getCrew().getOptions().booleanOption("dodge_maneuver") && entity2.dodging) {
            toHitData.addModifier(2, "target is dodging");
        }
    }

    public static ToHitData getTargetMovementModifier(IGame iGame, int n) {
        Entity entity = iGame.getEntity(n);
        if (entity instanceof Aero) {
            return new ToHitData();
        }
        ToHitData toHitData = Compute.getTargetMovementModifier(entity.delta_distance, entity.moved == 3 || entity.moved == 5 || entity.moved == 4, entity.moved == 5 || entity.moved == 4 || entity.getMovementMode() == 6);
        if (entity.moved == -2) {
            toHitData.addModifier(2, "target skidded");
        }
        if (entity.getElevation() > 0 && entity.getMovementMode() == 15) {
            toHitData.addModifier(1, "target is a flying WiGE");
        }
        return toHitData;
    }

    public static ToHitData getTargetMovementModifier(int n, boolean bl, boolean bl2) {
        ToHitData toHitData = new ToHitData();
        if (n >= 3 && n <= 4) {
            toHitData.addModifier(1, "target moved 3-4 hexes");
        } else if (n >= 5 && n <= 6) {
            toHitData.addModifier(2, "target moved 5-6 hexes");
        } else if (n >= 7 && n <= 9) {
            toHitData.addModifier(3, "target moved 7-9 hexes");
        } else if (n >= 10 && n <= 17) {
            toHitData.addModifier(4, "target moved 10-17 hexes");
        } else if (n >= 18 && n <= 24) {
            toHitData.addModifier(5, "target moved 18-24 hexes");
        } else if (n >= 25) {
            toHitData.addModifier(6, "target moved 25+ hexes");
        }
        if (bl) {
            if (bl2) {
                toHitData.addModifier(1, "target VTOL used MPs");
            } else {
                toHitData.addModifier(1, "target jumped");
            }
        }
        return toHitData;
    }

    public static ToHitData getAttackerTerrainModifier(IGame iGame, int n) {
        Entity entity = iGame.getEntity(n);
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        ToHitData toHitData = new ToHitData();
        if (iHex.terrainLevel(31) > 0) {
            toHitData.addModifier(iHex.terrainLevel(31) + 1, "attacker in screen(s)");
        }
        return toHitData;
    }

    public static ToHitData getTargetTerrainModifier(IGame iGame, Targetable targetable) {
        return Compute.getTargetTerrainModifier(iGame, targetable, 0);
    }

    public static ToHitData getTargetTerrainModifier(IGame iGame, Targetable targetable, int n) {
        Entity entity = null;
        IHex iHex = iGame.getBoard().getHex(targetable.getPosition());
        if (targetable.getTargetType() == 0) {
            entity = (Entity)targetable;
            if (iHex == null) {
                entity.setPosition(iGame.getEntity(entity.getId()).getPosition());
                iHex = iGame.getBoard().getHex(iGame.getEntity(entity.getId()).getPosition());
            }
        }
        boolean bl = entity != null && iHex != null && entity.absHeight() >= 2;
        ToHitData toHitData = new ToHitData();
        int n2 = iHex.terrainLevel(1);
        int n3 = iHex.terrainLevel(23);
        String string = "woods";
        if (n2 < n3) {
            n2 = n3;
            string = "jungle";
        }
        if (n2 == 1) {
            string = "target in light " + string;
        } else if (n2 == 2) {
            string = "target in heavy " + string;
        } else if (n2 == 3) {
            string = "target in ultra heavy " + string;
        }
        if (!iGame.getOptions().booleanOption("maxtech_fire")) {
            if (iHex.containsTerrain(8)) {
                if (n > 0) {
                    toHitData.addModifier(1, "target in smoke");
                } else {
                    toHitData.addModifier(2, "target in smoke");
                }
            } else if (iHex.terrainLevel(22) == 2) {
                if (n > 0) {
                    toHitData.addModifier(1, "target in erupting geyser");
                } else {
                    toHitData.addModifier(2, "target in erupting geyser");
                }
            } else if (!bl && targetable.getTargetType() != 1 && targetable.getTargetType() != 2 && targetable.getTargetType() != 14 && targetable.getTargetType() != 7 && targetable.getTargetType() != 6) {
                if (n2 == 1 && n != 2) {
                    toHitData.addModifier(1, string);
                } else if (n2 > 1) {
                    if (n > 0) {
                        toHitData.addModifier(n2 - 1, string);
                    } else {
                        toHitData.addModifier(n2, string);
                    }
                }
            }
        } else {
            if (iHex.terrainLevel(8) == 1) {
                toHitData.addModifier(1, "target in light smoke");
            } else if (iHex.terrainLevel(8) > 1) {
                if (n > 0) {
                    toHitData.addModifier(1, "target in heavy smoke");
                } else {
                    toHitData.addModifier(2, "target in heavy smoke");
                }
            }
            if (iHex.terrainLevel(22) == 2) {
                if (n > 0) {
                    toHitData.addModifier(1, "target in erupting geyser");
                } else {
                    toHitData.addModifier(2, "target in erupting geyser");
                }
            }
            if (!bl && targetable.getTargetType() != 1 && targetable.getTargetType() != 2 && targetable.getTargetType() != 14 && targetable.getTargetType() != 7 && targetable.getTargetType() != 6) {
                if (n2 == 1 && n != 2) {
                    toHitData.addModifier(1, string);
                } else if (n2 > 1) {
                    if (n > 0) {
                        toHitData.addModifier(n2 - 1, string);
                    } else {
                        toHitData.addModifier(n2, string);
                    }
                }
            }
        }
        if (iHex.terrainLevel(31) > 0) {
            toHitData.addModifier(iHex.terrainLevel(31) + 1, "target in screen(s)");
        }
        if (entity == null) {
            return toHitData;
        }
        if (entity.isMakingDfa()) {
            return toHitData;
        }
        if (entity.isStuck()) {
            toHitData.addModifier(-2, "target stuck in swamp");
        }
        return toHitData;
    }

    public static WeaponAttackAction getHighestExpectedDamage(IGame iGame, Vector<WeaponAttackAction> vector, boolean bl) {
        float f = -1.0f;
        WeaponAttackAction weaponAttackAction = null;
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            WeaponAttackAction weaponAttackAction2 = vector.elementAt(i);
            float f2 = Compute.getExpectedDamage(iGame, weaponAttackAction2, bl);
            if (!(f2 > f)) continue;
            f = f2;
            weaponAttackAction = weaponAttackAction2;
        }
        return weaponAttackAction;
    }

    public static float getExpectedDamage(IGame iGame, WeaponAttackAction weaponAttackAction, boolean bl) {
        boolean bl2 = false;
        AmmoType ammoType = new AmmoType();
        Entity entity = iGame.getEntity(weaponAttackAction.getEntityId());
        Infantry infantry = new Infantry();
        BattleArmor battleArmor = new BattleArmor();
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        ToHitData toHitData = weaponAttackAction.toHit(iGame);
        if (entity instanceof BattleArmor) {
            battleArmor = (BattleArmor)iGame.getEntity(weaponAttackAction.getEntityId());
        }
        if (entity instanceof Infantry && !(entity instanceof BattleArmor)) {
            infantry = (Infantry)iGame.getEntity(weaponAttackAction.getEntityId());
        }
        WeaponType weaponType = (WeaponType)mounted.getType();
        float f = 0.0f;
        float f2 = 0.0f;
        if (bl) {
            f2 = 1.0f;
        } else {
            if (toHitData.getValue() == Integer.MAX_VALUE || toHitData.getValue() == 0x7FFFFFFE) {
                return 0.0f;
            }
            f2 = toHitData.getValue() == Integer.MIN_VALUE ? 1.0f : (float)Compute.oddsAbove(toHitData.getValue()) / 100.0f;
        }
        if (weaponType.getDamage() == -2) {
            bl2 = true;
        }
        if (!(weaponType.getAmmoType() != 19 && weaponType.getAmmoType() != 32 || (ammoType = (AmmoType)mounted.getLinked().getType()).getAmmoType() != 19 && ammoType.getAmmoType() != 32 || ammoType.getMunitionType() != 1L)) {
            bl2 = true;
        }
        if (!(weaponType.getAmmoType() != 20 && weaponType.getAmmoType() != 33 && weaponType.getAmmoType() != 23 || mounted.curMode().getName() != "Ultra" && mounted.curMode().getName() != "2-shot" && mounted.curMode().getName() != "3-shot" && mounted.curMode().getName() != "4-shot" && mounted.curMode().getName() != "5-shot" && mounted.curMode().getName() != "6-shot")) {
            bl2 = true;
        }
        if (entity instanceof BattleArmor && weaponType.getInternalName() != "SwarmMek" && weaponType.getInternalName() != "LegAttack") {
            bl2 = true;
        }
        if (bl2) {
            ArrayList<Mounted> arrayList;
            if (!(entity instanceof BattleArmor) && mounted.getLinked() == null) {
                return 0.0f;
            }
            AmmoType ammoType2 = null;
            if (mounted.getLinked() != null) {
                ammoType2 = (AmmoType)mounted.getLinked().getType();
                f = ammoType2.getDamagePerShot();
            }
            float f3 = 0.0f;
            f3 = weaponType.getRackSize() != 40 && weaponType.getRackSize() != 30 ? expectedHitsByRackSize[weaponType.getRackSize()] : 2.0f * expectedHitsByRackSize[weaponType.getRackSize() / 2];
            if (!(weaponType.getAmmoType() != 11 && weaponType.getAmmoType() != 42 && weaponType.getAmmoType() != 31 || Compute.isAffectedByAngelECM(entity, entity.getPosition(), weaponAttackAction.getTarget(iGame).getPosition()))) {
                f3 = weaponType.getRackSize();
            }
            if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 33 || weaponType.getAmmoType() == 23) {
                if (mounted.curMode().getName() == "Ultra" || mounted.curMode().getName() == "2-shot") {
                    f3 = expectedHitsByRackSize[2];
                }
                if (mounted.curMode().getName() == "3-shot") {
                    f3 = expectedHitsByRackSize[3];
                }
                if (mounted.curMode().getName() == "4-shot") {
                    f3 = expectedHitsByRackSize[4];
                }
                if (mounted.curMode().getName() == "5-shot") {
                    f3 = expectedHitsByRackSize[5];
                }
                if (mounted.curMode().getName() == "6-shot") {
                    f3 = expectedHitsByRackSize[6];
                }
            }
            if (entity instanceof BattleArmor) {
                f3 = expectedHitsByRackSize[battleArmor.getShootingStrength()];
                if (weaponType.getDamage() == -2) {
                    f3 *= expectedHitsByRackSize[weaponType.getRackSize()];
                }
                if (weaponType.getDamage() != -2) {
                    f = weaponType.getDamage() != -3 ? (float)weaponType.getDamage() : (float)weaponType.getRackSize();
                }
                if (weaponType.hasFlag(8192L)) {
                    f3 *= expectedHitsByRackSize[weaponType.getRackSize()];
                }
            }
            if (!Compute.isAffectedByECM(entity, entity.getPosition(), iGame.getEntity(weaponAttackAction.getTargetId()).getPosition()) && weaponType.getDamage() == -2) {
                Mounted mounted2;
                if (!(weaponType.getAmmoType() != 7 && weaponType.getAmmoType() != 45 && weaponType.getAmmoType() != 9 || (mounted2 = mounted.getLinkedBy()) == null || !(mounted2.getType() instanceof MiscType) || mounted2.isDestroyed() || mounted2.isMissing() || mounted2.isBreached() || !mounted2.getType().hasFlag(512L) || mounted.curMode() != null && mounted.curMode().equals("Indirect") || ammoType2.getMunitionType() != 4096L)) {
                    f3 *= 1.2f;
                }
                if (weaponType.getAmmoType() == 28) {
                    f3 *= 1.2f;
                }
                if ((iGame.getEntity(weaponAttackAction.getTargetId()).isNarcedBy(entity.getOwner().getTeam()) || iGame.getEntity(weaponAttackAction.getTargetId()).isINarcedBy(entity.getOwner().getTeam())) && (ammoType2.getAmmoType() == 7 || ammoType2.getAmmoType() == 45 || ammoType2.getAmmoType() == 9) && ammoType2.getMunitionType() == 2048L) {
                    f3 *= 1.2f;
                }
            }
            if (weaponType.getDamage() == -2 && (arrayList = weaponAttackAction.getCounterEquipment()) != null) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    EquipmentType equipmentType = arrayList.get(i).getType();
                    if (!(equipmentType instanceof WeaponType) || !equipmentType.hasFlag(0x800000L)) continue;
                    f3 = (float)((double)f3 * 0.6);
                }
            }
            f *= f3;
            if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 33 || weaponType.getAmmoType() == 23) {
                f = f3 * (float)weaponType.getDamage();
            }
        } else {
            f = weaponType.getDamage();
            if (entity.getPosition() != null && iGame.getEntity(weaponAttackAction.getTargetId()).getPosition() != null && weaponType.getAmmoType() == 22) {
                f = 25.0f;
                int n = entity.getPosition().distance(iGame.getEntity(weaponAttackAction.getTargetId()).getPosition());
                if (n > 13) {
                    f = 10.0f;
                } else if (n > 6) {
                    f = 20.0f;
                }
            }
            if (entity instanceof Infantry) {
                if (weaponType.getInternalName() == "LegAttack") {
                    f = 10.0f;
                }
                if (infantry.isPlatoon()) {
                    f = weaponType.getInternalName() == "SwarmMek" ? (iGame.getEntity(weaponAttackAction.getTargetId()).getSwarmAttackerId() == -1 && iGame.getEntity(weaponAttackAction.getTargetId()) instanceof Mech ? 4.0f : 0.0f) : 2.0f;
                } else if (weaponType.getInternalName() == "SwarmMek") {
                    f = iGame.getEntity(weaponAttackAction.getTargetId()).getSwarmAttackerId() == -1 && iGame.getEntity(weaponAttackAction.getTargetId()) instanceof Mech ? 5.0f * (float)battleArmor.getShootingStrength() : 0.0f;
                }
            }
        }
        f *= f2;
        if (iGame.getEntity(weaponAttackAction.getTargetId()) instanceof Infantry && !(iGame.getEntity(weaponAttackAction.getTargetId()) instanceof BattleArmor)) {
            IHex iHex = iGame.getBoard().getHex(iGame.getEntity((int)weaponAttackAction.getTargetId()).getPosition().x, iGame.getEntity((int)weaponAttackAction.getTargetId()).getPosition().y);
            if (!(iHex.containsTerrain(1) || iHex.containsTerrain(23) || iHex.containsTerrain(10))) {
                f *= 2.0f;
            }
            f = Math.min((float)infantry.getShootingStrength(), f);
        }
        return f;
    }

    public static double getAmmoAdjDamage(IGame iGame, WeaponAttackAction weaponAttackAction) {
        boolean bl = true;
        boolean bl2 = false;
        AmmoType ammoType = new AmmoType();
        AmmoType ammoType2 = new AmmoType();
        WeaponType weaponType = new WeaponType();
        WeaponType weaponType2 = new WeaponType();
        Entity entity = iGame.getEntity(weaponAttackAction.getTargetId());
        Entity entity2 = weaponAttackAction.getEntity(iGame);
        weaponType = (WeaponType)entity2.getEquipment(weaponAttackAction.getWeaponId()).getType();
        double d = 0.0;
        if (weaponType.hasFlag(131072L) || weaponType.hasFlag(16384L) || weaponType.hasFlag(2048L) || weaponType.getAmmoType() == -1) {
            return Compute.getExpectedDamage(iGame, weaponAttackAction, false);
        }
        Mounted mounted = null;
        Mounted mounted2 = null;
        for (Mounted mounted3 : entity2.getAmmo()) {
            if (!entity2.loadWeapon(entity2.getEquipment(weaponAttackAction.getWeaponId()), mounted3) || mounted3.getShotsLeft() <= 0 || AmmoType.canDeliverMinefield(ammoType = (AmmoType)mounted3.getType())) continue;
            mounted = mounted3;
            ammoType2 = (AmmoType)mounted.getType();
            break;
        }
        for (Mounted mounted3 : entity2.getAmmo()) {
            if (!entity2.loadWeapon(entity2.getEquipment(weaponAttackAction.getWeaponId()), mounted3) || mounted3.getShotsLeft() <= 0 || AmmoType.canDeliverMinefield(ammoType = (AmmoType)mounted3.getType())) continue;
            bl = false;
            if (ammoType.getMunitionType() == ammoType2.getMunitionType()) continue;
            bl2 = true;
            break;
        }
        if (bl) {
            return 0.0;
        }
        if (!bl2) {
            return Compute.getExpectedDamage(iGame, weaponAttackAction, false);
        }
        if (bl2) {
            d = 0.0;
            mounted2 = mounted;
            for (Mounted mounted3 : entity2.getAmmo()) {
                if (!entity2.loadWeapon(entity2.getEquipment(weaponAttackAction.getWeaponId()), mounted3) || mounted3.getShotsLeft() <= 0 || AmmoType.canDeliverMinefield(ammoType = (AmmoType)mounted3.getType())) continue;
                entity2.loadWeapon(entity2.getEquipment(weaponAttackAction.getWeaponId()), mounted3);
                weaponAttackAction.setAmmoId(entity2.getEquipmentNum(mounted3));
                double d2 = Compute.getExpectedDamage(iGame, weaponAttackAction, false);
                double d3 = 1.0;
                if ((ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 45 || ammoType.getAmmoType() == 9) && ammoType.getMunitionType() == 256L || (ammoType.getAmmoType() == 1 || ammoType.getAmmoType() == 34) && ammoType.getMunitionType() == 4L) {
                    d3 = 0.0;
                    if (entity instanceof Infantry && !(entity instanceof BattleArmor)) {
                        d3 = 2.0;
                    }
                }
                if ((ammoType.getAmmoType() == 19 || ammoType.getAmmoType() == 32) && ammoType.getMunitionType() == 1L) {
                    if (entity.getArmorRemainingPercent() <= 0.25) {
                        d3 = 1.0 + (double)(weaponType.getRackSize() / 10);
                    }
                    if (entity instanceof Tank) {
                        d3 += 1.0;
                    }
                }
                if ((ammoType.getAmmoType() == 1 || ammoType.getAmmoType() == 34) && ammoType.getMunitionType() == 2L) {
                    if (entity instanceof Mech || entity instanceof Tank) {
                        d3 = 1.0 + (double)(weaponType.getRackSize() / 10);
                    }
                    if (entity instanceof Infantry) {
                        d3 = 0.6;
                    }
                }
                if ((ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 45) && ammoType.getMunitionType() == 0x10000000L) {
                    d3 = 0.5;
                    if (entity instanceof Mech && entity.infernos.getTurnsLeftToBurn() < 4 && entity.heat >= 5) {
                        d3 = 1.1;
                    }
                    if (entity instanceof Tank && !iGame.getOptions().booleanOption("vehicles_safe_from_infernos")) {
                        d3 = 1.1;
                    }
                    if (entity instanceof Protomech && !iGame.getOptions().booleanOption("protos_safe_from_infernos")) {
                        d3 = 1.1;
                    }
                }
                if (weaponType.getAmmoType() == 13 && ammoType.getMunitionType() == 0L) {
                    d2 = !entity.isNarcedBy(entity2.getOwner().getTeam()) && !(entity instanceof Infantry) ? 5.0 : 0.5;
                }
                if (weaponType.getAmmoType() == 30) {
                    if (ammoType.getMunitionType() == 0L && !(entity instanceof Infantry)) {
                        d2 = !entity.isINarcedBy(entity2.getOwner().getTeam()) ? 7.0 : 1.0;
                    }
                    if (ammoType.getAmmoType() == 30 && ammoType.getMunitionType() == 0x100000000L && !(entity instanceof Infantry) && !entity.isINarcedWith(0x100000000L)) {
                        d2 = entity.getC3MasterId() != -1 || entity.hasC3M() || entity.hasC3MM() || entity.hasC3i() ? 8.0 : 0.5;
                        for (Mounted mounted4 : entity2.getWeaponList()) {
                            weaponType2 = (WeaponType)mounted4.getType();
                            if (weaponType2.getAmmoType() != 7 && weaponType2.getAmmoType() != 45 && weaponType2.getAmmoType() != 9) continue;
                            d2 += (double)(weaponType2.getRackSize() / 2);
                        }
                    }
                    if (ammoType.getAmmoType() == 30 && ammoType.getMunitionType() == 0x400000000L && !(entity instanceof Infantry)) {
                        d2 = !entity.isINarcedWith(0x400000000L) ? (double)(entity.getOriginalWalkMP() + entity.getOriginalJumpMP()) / 2.0 : 0.5;
                    }
                }
                if (!(d2 * d3 > d)) continue;
                d = d2 * d3;
                mounted2 = mounted3;
            }
            entity2.loadWeapon(entity2.getEquipment(weaponAttackAction.getWeaponId()), mounted2);
            weaponAttackAction.setAmmoId(entity2.getEquipmentNum(mounted2));
        }
        return d;
    }

    public static int spinUpCannon(IGame iGame, WeaponAttackAction weaponAttackAction) {
        int n = 12;
        WeaponType weaponType = new WeaponType();
        Entity entity = weaponAttackAction.getEntity(iGame);
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        weaponType = (WeaponType)entity.getEquipment(weaponAttackAction.getWeaponId()).getType();
        if (weaponType.getAmmoType() != 20 && weaponType.getAmmoType() != 33 && weaponType.getAmmoType() != 23) {
            return 0;
        }
        n = weaponAttackAction.toHit(iGame).getValue();
        mounted.setMode("Single");
        int n2 = 0;
        if (n == Integer.MAX_VALUE || n == 0x7FFFFFFE) {
            return n2;
        }
        int n3 = Compute.d6(2);
        if (n3 >= n + 1) {
            n2 = 1;
            if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 33) {
                mounted.setMode("Ultra");
            }
            if (weaponType.getAmmoType() == 23) {
                mounted.setMode("2-shot");
            }
        }
        if (weaponType.getAmmoType() == 23) {
            if (n3 >= n + 2) {
                n2 = 2;
                mounted.setMode("4-shot");
            }
            if (n3 >= n + 3) {
                n2 = 3;
                mounted.setMode("6-shot");
            }
        }
        return n2;
    }

    public static boolean isInArc(IGame iGame, int n, int n2, Targetable targetable) {
        Entity entity = iGame.getEntity(n);
        if (entity instanceof Mech && ((Mech)entity).getGrappled() == targetable.getTargetId()) {
            return true;
        }
        int n3 = entity.isSecondaryArcWeapon(n2) ? entity.getSecondaryFacing() : entity.getFacing();
        return Compute.isInArc(entity.getPosition(), n3, targetable.getPosition(), entity.getWeaponArc(n2));
    }

    public static boolean isThroughFrontHex(IGame iGame, Coords coords, Entity entity) {
        Coords coords2 = entity.getPosition();
        int n = coords2.degree(coords) - entity.getFacing() * 60;
        if (n < 0) {
            n += 360;
        }
        return n > 330 || n < 30;
    }

    public static boolean isInArc(Coords coords, int n, Coords coords2, int n2) {
        if (coords == null || coords2 == null) {
            return true;
        }
        int n3 = coords.degree(coords2) - n * 60;
        if (n3 < 0) {
            n3 += 360;
        }
        switch (n2) {
            case 1: {
                return n3 >= 300 || n3 <= 60;
            }
            case 3: {
                return n3 >= 300 || n3 <= 120;
            }
            case 2: {
                return n3 >= 240 || n3 <= 60;
            }
            case 4: {
                return n3 > 120 && n3 < 240;
            }
            case 6: {
                return n3 > 60 && n3 <= 120;
            }
            case 5: {
                return n3 < 300 && n3 >= 240;
            }
            case 7: {
                return n3 >= 240 || n3 <= 120;
            }
            case 0: {
                return true;
            }
            case 8: {
                return n3 >= 270 || n3 <= 30;
            }
            case 9: {
                return n3 >= 30 && n3 <= 150;
            }
            case 10: {
                return n3 >= 150 && n3 <= 270;
            }
            case 11: {
                return n3 > 300 || n3 < 60;
            }
            case 12: {
                return n3 > 300 || n3 <= 0;
            }
            case 13: {
                return n3 >= 0 && n3 < 60;
            }
            case 14: {
                return n3 >= 180 && n3 < 240;
            }
            case 15: {
                return n3 > 120 && n3 <= 180;
            }
            case 16: {
                return n3 > 120 && n3 < 240;
            }
            case 17: {
                return n3 > 240 || n3 < 0;
            }
            case 18: {
                return n3 > 0 && n3 < 120;
            }
            case 19: {
                return n3 > 180 && n3 < 300;
            }
            case 20: {
                return n3 > 60 && n3 < 180;
            }
            case 21: {
                return n3 >= 240 && n3 <= 300;
            }
            case 22: {
                return n3 >= 60 && n3 <= 120;
            }
            case 23: {
                return n3 >= 180 && n3 < 360;
            }
            case 24: {
                return n3 >= 0 && n3 < 180;
            }
        }
        return false;
    }

    public static boolean canSee(IGame iGame, Entity entity, Targetable targetable) {
        Entity entity2;
        if (targetable.getTargetType() == 0 && (entity2 = (Entity)targetable).isOffBoard()) {
            return false;
        }
        if (iGame.getOptions().intOption("visibility") < 999) {
            int n = iGame.getOptions().intOption("visibility");
            if (entity instanceof MechWarrior && iGame.getOptions().booleanOption("pilots_visual_range_one")) {
                n = 1;
            }
            if (entity.hasBAP()) {
                n = Math.max(entity.getBAPRange(), n);
            }
            if (entity.getPosition() != null && targetable.getPosition() != null && entity.getPosition().distance(targetable.getPosition()) > n) {
                return false;
            }
        }
        return LosEffects.calculateLos(iGame, entity.getId(), targetable).canSee() && entity.getCrew().isActive();
    }

    public static int targetSideTable(Coords coords, Targetable targetable) {
        return targetable.sideTable(coords);
    }

    public static int targetSideTable(Entity entity, Targetable targetable) {
        Coords coords = entity.getPosition();
        boolean bl = Compute.usePrior(entity, targetable);
        if (targetable instanceof Aero && entity instanceof Aero) {
            return ((Entity)targetable).sideTable(coords, bl);
        }
        return targetable.sideTable(coords);
    }

    public static boolean usePrior(Entity entity, Targetable targetable) {
        Coords coords = targetable.getPosition();
        Coords coords2 = entity.getPosition();
        boolean bl = false;
        if (entity instanceof Aero && targetable instanceof Aero && coords2.equals(coords)) {
            int n;
            int n2 = UnitType.determineUnitTypeCode(entity);
            if (n2 < (n = UnitType.determineUnitTypeCode((Entity)targetable))) {
                bl = true;
                coords2 = entity.getPriorPosition();
            } else if (n2 > n) {
                bl = true;
                coords = ((Entity)targetable).getPriorPosition();
            } else {
                int n3;
                int n4 = ((Aero)entity).getCurrentVelocity();
                if (n4 > (n3 = ((Aero)targetable).getCurrentVelocity())) {
                    bl = true;
                    coords2 = entity.getPriorPosition();
                } else if (n3 > n4) {
                    bl = true;
                    coords = ((Entity)targetable).getPriorPosition();
                } else if (((Aero)entity).getWhoFirst() > ((Aero)targetable).getWhoFirst()) {
                    bl = true;
                    coords2 = entity.getPriorPosition();
                } else {
                    bl = true;
                    coords = ((Entity)targetable).getPriorPosition();
                }
            }
        }
        return bl;
    }

    public static int missilesHit(int n) {
        return Compute.missilesHit(n, 0);
    }

    public static int missilesHit(int n, int n2, boolean bl, boolean bl2) {
        return Compute.missilesHit(n, n2, bl, bl2, false);
    }

    public static int missilesHit(int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        int n4;
        int n5 = Compute.d6(2);
        int n6 = n4 = bl ? 1 : 2;
        if (bl2) {
            n3 = Compute.d6();
            int n7 = Compute.d6();
            int n8 = Compute.d6();
            int n9 = 0;
            int n10 = 0;
            if (n3 <= n7 && n3 <= n8) {
                n9 = n3;
                n10 = Math.min(n7, n8);
            } else if (n7 <= n3 && n7 <= n8) {
                n9 = n7;
                n10 = Math.min(n3, n8);
            } else if (n8 <= n3 && n8 <= n7) {
                n9 = n8;
                n10 = Math.min(n7, n3);
            }
            n5 = n9 + n10;
        }
        if (bl3) {
            n5 = 11;
        }
        n5 += n2;
        n5 = Math.min(Math.max(n5, n4), 12);
        if (bl && n5 == 1) {
            return 1;
        }
        if (n5 < 2) {
            n5 = 2;
        }
        for (n3 = 0; n3 < clusterHitsTable.length; ++n3) {
            if (clusterHitsTable[n3][0] != n) continue;
            return clusterHitsTable[n3][n5 - 1];
        }
        for (n3 = clusterHitsTable.length - 1; n3 >= 0; --n3) {
            if (n <= clusterHitsTable[n3][0]) continue;
            return clusterHitsTable[n3][n5 - 1] + Compute.missilesHit(n - clusterHitsTable[n3][0], n2, bl, bl2, bl3);
        }
        throw new RuntimeException("Could not find number of missiles in hit table");
    }

    public static int missilesHit(int n, int n2) {
        return Compute.missilesHit(n, n2, false, false);
    }

    public static int missilesHit(int n, int n2, boolean bl) {
        return Compute.missilesHit(n, n2, bl, false);
    }

    public static int getConsciousnessNumber(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 11;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static boolean isAffectedByECM(Entity entity, Coords coords, Coords coords2) {
        Coords coords3;
        Object object;
        if (coords == null || coords2 == null) {
            return false;
        }
        Vector<Coords> vector = new Vector<Coords>(16);
        Vector<Integer> vector2 = new Vector<Integer>(16);
        Vector<Coords> vector3 = new Vector<Coords>(16);
        Vector<Integer> vector4 = new Vector<Integer>(16);
        Object object2 = entity.game.getEntities();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            coords3 = ((Entity)object).getPosition();
            if (((Entity)object).isEnemyOf(entity) && ((Entity)object).hasActiveECM() && coords3 != null) {
                vector.addElement(coords3);
                vector2.addElement(new Integer(((Entity)object).getECMRange()));
            }
            if (((Entity)object).isEnemyOf(entity) && ((Entity)object).hasActiveAngelECM() && coords3 != null) {
                vector.addElement(coords3);
                vector2.addElement(new Integer(((Entity)object).getECMRange()));
            }
            if (!((Entity)object).isEnemyOf(entity) && ((Entity)object).hasActiveECCM() && coords3 != null) {
                vector3.addElement(coords3);
                vector4.addElement(new Integer(((Entity)object).getECMRange()));
            }
            if (!((Entity)object).isEnemyOf(entity) && ((Entity)object).hasActiveAngelECCM() && coords3 != null) {
                vector3.addElement(coords3);
                vector4.addElement(new Integer(((Entity)object).getECMRange()));
            }
            for (Entity object3 : ((Entity)object).getLoadedUnits()) {
                if (object3.isEnemyOf(entity) && object3.hasActiveECM() && coords3 != null) {
                    vector.addElement(coords3);
                    vector2.addElement(new Integer(object3.getECMRange()));
                }
                if (object3.isEnemyOf(entity) && object3.hasActiveAngelECM() && coords3 != null) {
                    vector.addElement(coords3);
                    vector2.addElement(new Integer(object3.getECMRange()));
                }
                if (!object3.isEnemyOf(entity) && ((Entity)object).hasActiveECCM() && coords3 != null) {
                    vector3.addElement(coords3);
                    vector4.addElement(new Integer(((Entity)object).getECMRange()));
                }
                if (object3.isEnemyOf(entity) || !((Entity)object).hasActiveAngelECCM() || coords3 == null) continue;
                vector3.addElement(coords3);
                vector4.addElement(new Integer(((Entity)object).getECMRange()));
            }
        }
        if (vector.size() == 0) {
            return false;
        }
        object2 = Coords.intervening(coords, coords2);
        object = ((ArrayList)object2).iterator();
        while (object.hasNext()) {
            int n;
            int n2;
            Coords coords4;
            coords3 = (Coords)object.next();
            int n3 = 0;
            if (coords3.equals(entity.getPosition()) && entity.isINarcedWith(2L)) {
                --n3;
            }
            Enumeration enumeration = vector2.elements();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                coords4 = (Coords)enumeration2.nextElement();
                n2 = (Integer)enumeration.nextElement();
                n = coords3.distance(coords4);
                if (n > n2) continue;
                --n3;
            }
            Enumeration enumeration3 = vector4.elements();
            enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                coords4 = (Coords)enumeration2.nextElement();
                n2 = (Integer)enumeration3.nextElement();
                n = coords3.distance(coords4);
                if (n > n2) continue;
                ++n3;
            }
            if (n3 >= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isAffectedByAngelECM(Entity entity, Coords coords, Coords coords2) {
        Coords coords3;
        Object object;
        if (coords == null || coords2 == null) {
            return false;
        }
        Vector<Coords> vector = new Vector<Coords>(16);
        Vector<Integer> vector2 = new Vector<Integer>(16);
        Vector<Coords> vector3 = new Vector<Coords>(16);
        Vector<Integer> vector4 = new Vector<Integer>(16);
        Object object2 = entity.game.getEntities();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            coords3 = ((Entity)object).getPosition();
            if (((Entity)object).isEnemyOf(entity) && ((Entity)object).hasActiveAngelECM() && coords3 != null) {
                vector.addElement(coords3);
                vector2.addElement(new Integer(((Entity)object).getECMRange()));
            }
            if (!((Entity)object).isEnemyOf(entity) && ((Entity)object).hasActiveECCM() && coords3 != null) {
                vector3.addElement(coords3);
                vector4.addElement(new Integer(((Entity)object).getECMRange()));
            }
            if (!((Entity)object).isEnemyOf(entity) && ((Entity)object).hasActiveAngelECCM() && coords3 != null) {
                vector3.addElement(coords3);
                vector4.addElement(new Integer(((Entity)object).getECMRange()));
            }
            for (Entity object3 : ((Entity)object).getLoadedUnits()) {
                if (object3.isEnemyOf(entity) && object3.hasActiveAngelECM() && coords3 != null) {
                    vector.addElement(coords3);
                    vector2.addElement(new Integer(object3.getECMRange()));
                }
                if (!object3.isEnemyOf(entity) && ((Entity)object).hasActiveECCM() && coords3 != null) {
                    vector3.addElement(coords3);
                    vector4.addElement(new Integer(((Entity)object).getECMRange()));
                }
                if (object3.isEnemyOf(entity) || !((Entity)object).hasActiveAngelECCM() || coords3 == null) continue;
                vector3.addElement(coords3);
                vector4.addElement(new Integer(((Entity)object).getECMRange()));
            }
        }
        if (vector.size() == 0) {
            return false;
        }
        object2 = Coords.intervening(coords, coords2);
        object = ((ArrayList)object2).iterator();
        while (object.hasNext()) {
            int n;
            int n2;
            Coords coords4;
            coords3 = (Coords)object.next();
            int n3 = 0;
            Enumeration enumeration = vector2.elements();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                coords4 = (Coords)enumeration2.nextElement();
                n2 = (Integer)enumeration.nextElement();
                n = coords3.distance(coords4);
                if (n > n2) continue;
                --n3;
            }
            Enumeration enumeration3 = vector4.elements();
            enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                coords4 = (Coords)enumeration2.nextElement();
                n2 = (Integer)enumeration3.nextElement();
                n = coords3.distance(coords4);
                if (n > n2) continue;
                ++n3;
            }
            if (n3 >= 0) continue;
            return true;
        }
        return false;
    }

    public static ToHitData getLegAttackBaseToHit(Entity entity, Entity entity2) {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        StringBuffer stringBuffer = new StringBuffer();
        if (!(entity2 instanceof Mech)) {
            stringBuffer.append("Defender is not a Mek.");
        } else if (-1 != entity2.getTransportId()) {
            stringBuffer.append("Target is a passenger.");
        } else if (-1 != entity2.getSwarmTargetId()) {
            stringBuffer.append("Target is swarming a Mek.");
        } else if (-1 != entity.getSwarmTargetId()) {
            stringBuffer.append("Attacker is swarming.");
        } else if (entity instanceof BattleArmor) {
            BattleArmor battleArmor = (BattleArmor)entity;
            if (battleArmor.isBurdened()) {
                stringBuffer.append("Launcher not jettisoned.");
            } else {
                n = battleArmor.getShootingStrength();
                if (n >= 4) {
                    n2 = battleArmor.getCrew().getPiloting();
                } else if (n >= 3) {
                    n2 = battleArmor.getCrew().getPiloting() + 2;
                } else if (n >= 2) {
                    n2 = battleArmor.getCrew().getPiloting() + 5;
                } else if (n >= 1) {
                    n2 = battleArmor.getCrew().getPiloting() + 7;
                }
                stringBuffer.append(n);
                stringBuffer.append(" trooper(s) active");
            }
        } else if (entity instanceof Infantry) {
            Infantry infantry = (Infantry)entity;
            n = infantry.getShootingStrength();
            if (n >= 22) {
                n2 = infantry.getCrew().getPiloting();
            } else if (n >= 16) {
                n2 = infantry.getCrew().getPiloting() + 2;
            } else if (n >= 10) {
                n2 = infantry.getCrew().getPiloting() + 5;
            } else if (n >= 5) {
                n2 = infantry.getCrew().getPiloting() + 7;
            }
            stringBuffer.append(n);
            stringBuffer.append(" men alive");
        } else {
            stringBuffer.append("Attacker is not infantry.");
        }
        return new ToHitData(n2, stringBuffer.toString(), 2, 0);
    }

    public static ToHitData getSwarmMekBaseToHit(Entity entity, Entity entity2) {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        StringBuffer stringBuffer = new StringBuffer();
        if (!(entity2 instanceof Mech) && !(entity2 instanceof Tank)) {
            stringBuffer.append("Defender is not a Mek or vehicle.");
        } else if (-1 != entity2.getTransportId()) {
            stringBuffer.append("Target is a passenger.");
        } else if (-1 != entity.getSwarmTargetId()) {
            stringBuffer.append("Attacker is swarming.");
        } else if (-1 != entity2.getSwarmAttackerId()) {
            stringBuffer.append("Target is already being swarmed.");
        } else if (-1 != entity2.getSwarmTargetId()) {
            stringBuffer.append("Target is swarming a Mek.");
        } else if (!entity.isEnemyOf(entity2)) {
            stringBuffer.append("Can only swarm an enemy.");
        } else if (entity instanceof BattleArmor) {
            BattleArmor battleArmor = (BattleArmor)entity;
            if (battleArmor.isBurdened()) {
                stringBuffer.append("Launcher not jettisoned.");
            } else {
                n = battleArmor.getShootingStrength();
                if (n >= 4) {
                    n2 = battleArmor.getCrew().getPiloting() + 2;
                } else if (n >= 1) {
                    n2 = battleArmor.getCrew().getPiloting() + 5;
                }
                stringBuffer.append(n);
                stringBuffer.append(" trooper(s) active");
            }
        } else if (entity instanceof Infantry) {
            Infantry infantry = (Infantry)entity;
            n = infantry.getShootingStrength();
            if (n >= 22) {
                n2 = infantry.getCrew().getPiloting() + 2;
            } else if (n >= 16) {
                n2 = infantry.getCrew().getPiloting() + 5;
            }
            stringBuffer.append(n);
            stringBuffer.append(" men alive");
        } else {
            stringBuffer.append("Attacker is not infantry.");
        }
        return new ToHitData(n2, stringBuffer.toString());
    }

    public static boolean canPhysicalTarget(IGame iGame, int n, Targetable targetable) {
        if (PunchAttackAction.toHit(iGame, n, targetable, 1).getValue() != Integer.MAX_VALUE) {
            return true;
        }
        if (PunchAttackAction.toHit(iGame, n, targetable, 2).getValue() != Integer.MAX_VALUE) {
            return true;
        }
        if (KickAttackAction.toHit(iGame, n, targetable, 1).getValue() != Integer.MAX_VALUE) {
            return true;
        }
        if (KickAttackAction.toHit(iGame, n, targetable, 2).getValue() != Integer.MAX_VALUE) {
            return true;
        }
        if (iGame.getEntity(n) instanceof QuadMech && (KickAttackAction.toHit(iGame, n, targetable, 3).getValue() != Integer.MAX_VALUE || KickAttackAction.toHit(iGame, n, targetable, 4).getValue() != Integer.MAX_VALUE)) {
            return true;
        }
        if (BrushOffAttackAction.toHit(iGame, n, targetable, 1).getValue() != Integer.MAX_VALUE) {
            return true;
        }
        if (BrushOffAttackAction.toHit(iGame, n, targetable, 2).getValue() != Integer.MAX_VALUE) {
            return true;
        }
        if (new ThrashAttackAction(n, targetable).toHit(iGame).getValue() != Integer.MAX_VALUE) {
            return true;
        }
        if (ProtomechPhysicalAttackAction.toHit(iGame, n, targetable).getValue() != Integer.MAX_VALUE) {
            return true;
        }
        if (PushAttackAction.toHit(iGame, n, targetable).getValue() != Integer.MAX_VALUE) {
            return true;
        }
        if (LayExplosivesAttackAction.toHit(iGame, n, targetable).getValue() != Integer.MAX_VALUE) {
            return true;
        }
        if (TripAttackAction.toHit(iGame, n, targetable).getValue() != Integer.MAX_VALUE) {
            return true;
        }
        if (GrappleAttackAction.toHit(iGame, n, targetable).getValue() != Integer.MAX_VALUE) {
            return true;
        }
        if (BreakGrappleAttackAction.toHit(iGame, n, targetable).getValue() != Integer.MAX_VALUE) {
            return true;
        }
        for (Mounted mounted : iGame.getEntity(n).getClubs()) {
            if (null == mounted || ClubAttackAction.toHit(iGame, n, targetable, mounted, 0).getValue() == Integer.MAX_VALUE) continue;
            return true;
        }
        if (JumpJetAttackAction.toHit(iGame, n, targetable, 0).getValue() != Integer.MAX_VALUE) {
            return true;
        }
        if (JumpJetAttackAction.toHit(iGame, n, targetable, 1).getValue() != Integer.MAX_VALUE) {
            return true;
        }
        return JumpJetAttackAction.toHit(iGame, n, targetable, 2).getValue() != Integer.MAX_VALUE;
    }

    public static boolean canMoveOnPavement(IGame iGame, Coords coords, Coords coords2, MovePath movePath) {
        IHex iHex = iGame.getBoard().getHex(coords);
        IHex iHex2 = iGame.getBoard().getHex(coords2);
        int n = coords.direction(coords2);
        int n2 = (n + 3) % 6;
        boolean bl = false;
        if (coords.equals(coords2) && (iHex.containsTerrain(5) || iHex.containsTerrain(6) || iHex.containsTerrain(14))) {
            bl = true;
        } else if (iHex.containsTerrain(5) && (iHex2.containsTerrain(5) || iHex2.containsTerrainExit(6, n2) || iHex2.containsTerrainExit(14, n2) && movePath.getFinalClimbMode())) {
            bl = true;
        } else if ((iHex.containsTerrainExit(6, n) || iHex.containsTerrainExit(14, n) && movePath.getLastStep().getElevation() == iHex.terrainLevel(16)) && (iHex2.containsTerrainExit(6, n2) || iHex2.containsTerrainExit(14, n2) && movePath.getFinalClimbMode() || iHex2.containsTerrain(5))) {
            bl = true;
        }
        return bl;
    }

    public static boolean isInSameBuilding(IGame iGame, Entity entity, Targetable targetable) {
        if (!(targetable instanceof Entity)) {
            return false;
        }
        Entity entity2 = (Entity)targetable;
        if (!Compute.isInBuilding(iGame, entity) || !Compute.isInBuilding(iGame, entity2)) {
            return false;
        }
        Building building = iGame.getBoard().getBuildingAt(entity.getPosition());
        Building building2 = iGame.getBoard().getBuildingAt(targetable.getPosition());
        return building.equals(building2);
    }

    public static boolean isInBuilding(IGame iGame, Entity entity) {
        if (iGame == null) {
            return false;
        }
        if (entity == null) {
            return false;
        }
        return Compute.isInBuilding(iGame, entity, entity.getPosition());
    }

    public static boolean isInBuilding(IGame iGame, Entity entity, Coords coords) {
        if (iGame == null) {
            return false;
        }
        if (entity == null) {
            return false;
        }
        if (coords == null) {
            return false;
        }
        return Compute.isInBuilding(iGame, entity.getElevation(), coords);
    }

    static boolean isInBuilding(IGame iGame, int n, Coords coords) {
        IHex iHex = iGame.getBoard().getHex(coords);
        if (!iHex.containsTerrain(12)) {
            return false;
        }
        int n2 = iHex.terrainLevel(12);
        int n3 = 0;
        if (iHex.containsTerrain(13)) {
            n3 = iHex.terrainLevel(13);
        }
        return n >= -n3 && n < n2;
    }

    public static Coords scatter(Coords coords, int n) {
        int n2 = Compute.d6(1) - 1;
        int n3 = 0;
        n3 = n > 0 ? n : Compute.d6(1);
        return coords.translated(n2, n3);
    }

    public static ArrayList<Coords> coordsAtRange(Coords coords, int n) {
        ArrayList<Coords> arrayList = new ArrayList<Coords>(n * 6);
        if (n < 1) {
            arrayList.add(coords);
            return arrayList;
        }
        for (int i = 0; i < 6; ++i) {
            Coords coords2 = coords.translated(i, n);
            for (int j = 0; j < n; ++j) {
                arrayList.add(coords2);
                coords2 = coords2.translated((i + 2) % 6);
            }
        }
        return arrayList;
    }

    public static Entity getSwarmMissileTarget(IGame iGame, int n, Entity entity, int n2) {
        Coords coords = entity.getPosition();
        Entity entity2 = null;
        Entity entity3 = null;
        Entity entity4 = iGame.getEntity(n);
        Enumeration<Entity> enumeration = iGame.getEnemyEntities(coords, entity);
        while (enumeration.hasMoreElements()) {
            entity3 = enumeration.nextElement();
            if (entity3.getTargetedBySwarm(n, n2)) continue;
            return entity3;
        }
        for (int i = 0; i <= 5; ++i) {
            Coords coords2 = coords.translated(i);
            if (!iGame.getBoard().contains(coords2) || coords.equals(coords2)) continue;
            enumeration = iGame.getEnemyEntities(coords2, entity);
            if (enumeration.hasMoreElements() && !(entity3 = enumeration.nextElement()).getTargetedBySwarm(n, n2)) {
                return entity3;
            }
            enumeration = iGame.getFriendlyEntities(coords2, entity);
            if (!enumeration.hasMoreElements() || (entity3 = enumeration.nextElement()).getTargetedBySwarm(n, n2) || entity4.equals(entity3)) continue;
            return entity3;
        }
        return entity2;
    }

    public static int[] getRandomSkills(int n, int n2, int n3, boolean bl) {
        int n4;
        int n5;
        int[] nArray = new int[]{4, 5};
        if (n == 2) {
            if (n3 == 0) {
                nArray[0] = 5;
                nArray[1] = 6;
            }
            if (n3 == 2) {
                nArray[0] = 3;
                nArray[1] = 4;
            }
            if (n3 == 3) {
                nArray[0] = 2;
                nArray[1] = 3;
            }
            if (n2 == 1 || n2 == 2) {
                nArray[0] = nArray[0] - 1;
                nArray[1] = nArray[1] - 1;
            }
            return nArray;
        }
        if (n == 1) {
            n5 = 0;
            if (n3 == 0) {
                n5 -= 2;
            }
            if (n3 == 2) {
                n5 += 2;
            }
            if (n3 == 3) {
                n5 += 4;
            }
            n3 = (n4 = Compute.d6(2) + n5) < 6 ? 0 : (n4 < 10 ? 1 : (n4 < 12 ? 2 : 3));
        }
        n5 = 0;
        if (n2 == 1) {
            n5 = bl ? --n5 : ++n5;
        }
        if (n2 == 2) {
            ++n5;
        }
        n4 = Compute.d6(1) + n5;
        int n6 = Compute.d6(1) + n5;
        int n7 = 0;
        int n8 = 0;
        switch (n3) {
            case 1: {
                n7 = (int)Math.ceil((double)n4 / 2.0) + 2;
                n8 = (int)Math.ceil((double)n6 / 2.0) + 2;
                break;
            }
            case 2: {
                n7 = (int)Math.ceil((double)n4 / 2.0) + 3;
                n8 = (int)Math.ceil((double)n6 / 2.0) + 3;
                break;
            }
            case 3: {
                n7 = (int)Math.ceil((double)n4 / 2.0) + 4;
                n8 = (int)Math.ceil((double)n6 / 2.0) + 4;
                break;
            }
            default: {
                n7 = (int)Math.ceil(((double)n4 + 0.5) / 2.0);
                n8 = (int)Math.ceil(((double)n6 + 0.5) / 2.0);
                if (n4 <= 0) {
                    n7 = 0;
                }
                if (n6 > 0) break;
                n8 = 0;
            }
        }
        nArray[0] = skillLevels[0][n7];
        nArray[1] = skillLevels[1][n8];
        return nArray;
    }

    public static FighterSquadron compileSquadron(Vector<Entity> vector) {
        FighterSquadron fighterSquadron = new FighterSquadron();
        String string = vector.elementAt(0).getChassis();
        int n = 99;
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        int n4 = 99;
        int n5 = 0;
        float f = 0.0f;
        int n6 = 0;
        int n7 = 0;
        double d = 0.0;
        int n8 = 0;
        for (Entity entity : vector) {
            Aero aero;
            if (!string.equals(entity.getChassis())) {
                bl = false;
            }
            ++n5;
            fighterSquadron.fighters.add(entity.getChassis() + " " + entity.getModel());
            n2 += entity.getTotalArmor();
            n3 += entity.getHeatCapacity();
            f += entity.getWeight();
            n7 += entity.calculateBattleValue();
            d += entity.getCost();
            if (entity.getWalkMP() < n4) {
                n4 = entity.getWalkMP();
            }
            if ((aero = (Aero)entity).getSI() < n) {
                n = aero.getSI();
            }
            if (aero.getFuel() < n6 || n6 == 0) {
                n6 = aero.getFuel();
            }
            for (Mounted mounted : entity.getEquipment()) {
                if (mounted.getType() instanceof WeaponType) {
                    Mounted mounted2;
                    WeaponType weaponType = (WeaponType)mounted.getType();
                    try {
                        mounted2 = fighterSquadron.addEquipment(weaponType, mounted.getLocation());
                    }
                    catch (LocationFullException locationFullException) {
                        System.out.println("Unable to compile weapons");
                        locationFullException.printStackTrace();
                        return fighterSquadron;
                    }
                    if (weaponType.getAtClass() == 0) continue;
                    Mounted mounted3 = fighterSquadron.getFirstBay(weaponType, mounted2.getLocation(), mounted2.isRearMounted());
                    if (mounted3 == null) {
                        EquipmentType equipmentType = WeaponType.getBayType(weaponType.getAtClass());
                        try {
                            mounted3 = fighterSquadron.addEquipment(equipmentType, mounted2.getLocation());
                        }
                        catch (LocationFullException locationFullException) {
                            System.out.println("Unable to compile weapons");
                            locationFullException.printStackTrace();
                            return fighterSquadron;
                        }
                    }
                    mounted3.addWeaponToBay(fighterSquadron.getEquipmentNum(mounted2));
                    continue;
                }
                try {
                    if (mounted.getType() instanceof MiscType && mounted.getType().hasFlag(2048L)) {
                        ++n8;
                    }
                    fighterSquadron.addEquipment(mounted.getType(), mounted.getLocation());
                }
                catch (LocationFullException locationFullException) {
                    System.out.println("Unable to add equipment");
                    locationFullException.printStackTrace();
                    return fighterSquadron;
                }
            }
        }
        n2 = (int)Math.round((double)n2 / 10.0);
        fighterSquadron.setArmor(n2);
        fighterSquadron.set0Armor(n2);
        fighterSquadron.setHeatSinks(n3);
        fighterSquadron.setOriginalWalkMP(n4);
        fighterSquadron.setN0Fighters(n5);
        fighterSquadron.setNFighters(n5);
        fighterSquadron.autoSetThresh();
        fighterSquadron.setWeight(f);
        fighterSquadron.set0SI(n);
        fighterSquadron.setCost(d);
        fighterSquadron.setFuel(n6);
        if (n8 >= n5) {
            fighterSquadron.setHasTC(true);
        }
        if (bl) {
            fighterSquadron.setChassis(string + " Squadron");
        } else {
            int n9 = Math.round(f / (float)n5);
            if (n9 <= 45) {
                fighterSquadron.setChassis("Mixed Light Squadron");
            } else if (n9 <= 70) {
                fighterSquadron.setChassis("Mixed Medium Squadron");
            } else {
                fighterSquadron.setChassis("Mixed Heavy Squadron");
            }
        }
        fighterSquadron.setModel("");
        fighterSquadron.loadAllWeapons();
        fighterSquadron.setRapidFire();
        return fighterSquadron;
    }

    public static Coords getFinalPosition(Coords coords, int[] nArray) {
        if (nArray == null || nArray.length != 6) {
            return coords;
        }
        int n = 0;
        Coords coords2 = coords;
        for (int i = 0; i < 6; ++i) {
            for (n = nArray[i]; n > 0; --n) {
                coords2 = coords2.translated(i);
            }
        }
        return coords2;
    }

    public static int[] changeVectors(int[] nArray, int n) {
        int n2;
        if (nArray == null || nArray.length != 6) {
            return nArray;
        }
        int n3 = n + 3;
        if (n3 > 5) {
            n3 -= 6;
        }
        if (nArray[n3] > 0) {
            int n4 = n3;
            nArray[n4] = nArray[n4] - 1;
            return nArray;
        }
        int n5 = n + 2;
        if (n5 > 5) {
            n5 -= 6;
        }
        if ((n2 = n - 2) < 0) {
            n2 += 6;
        }
        if (nArray[n5] > 0 || nArray[n2] > 0) {
            int n6 = n + 1;
            if (n6 > 5) {
                n6 = 0;
            }
            if (nArray[n5] > 0) {
                int n7 = n5;
                nArray[n7] = nArray[n7] - 1;
                int n8 = n6;
                nArray[n8] = nArray[n8] + 1;
            }
            if ((n6 = n - 1) < 0) {
                n6 = 0;
            }
            if (nArray[n2] > 0) {
                int n9 = n2;
                nArray[n9] = nArray[n9] - 1;
                int n10 = n6;
                nArray[n10] = nArray[n10] + 1;
            }
            return nArray;
        }
        int n11 = n;
        nArray[n11] = nArray[n11] + 1;
        return nArray;
    }

    public static boolean sameVectors(int[] nArray, int[] nArray2) {
        for (int i = 0; i < 6; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static int getNetVelocity(Coords coords, Aero aero, int n, int n2) {
        int n3 = aero.sideTableRam(coords);
        switch (n3) {
            case 0: {
                return Math.max(n + n2, 1);
            }
            case 1: {
                return Math.max(n + n2 / 2, 1);
            }
            case 2: {
                return Math.max(n - n2 / 2, 1);
            }
            case 3: {
                return Math.max(n - n2, 1);
            }
        }
        return 0;
    }
}

