/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import megamek.common.ASFBay;
import megamek.common.AmmoType;
import megamek.common.Bay;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HeavyVehicleBay;
import megamek.common.LightVehicleBay;
import megamek.common.MechBay;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Player;
import megamek.common.SmallCraft;
import megamek.common.SmallCraftBay;
import megamek.common.Team;
import megamek.common.WeaponComparator;
import megamek.common.WeaponType;
import megamek.common.weapons.BayWeapon;

public class Dropship
extends SmallCraft {
    private static final long serialVersionUID = -8102587793161001305L;
    int escapePods = 0;
    int lifeBoats = 0;
    private boolean dockCollarDamaged = false;

    public boolean isDockCollarDamaged() {
        return this.dockCollarDamaged;
    }

    public void setDamageDockCollar(boolean bl) {
        this.dockCollarDamaged = bl;
    }

    public void setEscapePods(int n) {
        this.escapePods = n;
    }

    public int getEscapePods() {
        return this.escapePods;
    }

    public void setLifeBoats(int n) {
        this.lifeBoats = n;
    }

    public int getLifeBoats() {
        return this.lifeBoats;
    }

    public int getFuelPerTon() {
        int n = 80;
        if (this.weight >= 40000.0f) {
            n = 10;
            return n;
        }
        if (this.weight >= 20000.0f) {
            n = 20;
            return n;
        }
        if (this.weight >= 3000.0f) {
            n = 30;
            return n;
        }
        if (this.weight >= 1900.0f) {
            n = 40;
            return n;
        }
        if (this.weight >= 1200.0f) {
            n = 50;
            return n;
        }
        if (this.weight >= 800.0f) {
            n = 60;
            return n;
        }
        if (this.weight >= 400.0f) {
            n = 70;
            return n;
        }
        return n;
    }

    public double getCost() {
        double d = 0.0;
        d += (double)(200000.0f + 10.0f * this.weight);
        d += 200000.0;
        d += (double)(5000 * (this.getNCrew() + this.getNPassenger()));
        d += 80000.0;
        d += 100000.0;
        d += (double)(10000 * this.getArcswGuns());
        d += (double)(100000 * this.getSI());
        d += (double)(25000.0f + 10.0f * this.getWeight());
        d += 10000.0;
        double d2 = 0.065;
        if (this.isClan()) {
            d2 = 0.061;
        }
        double d3 = (double)((float)this.getOriginalWalkMP() * this.weight) * d2;
        d += d3 * 1000.0;
        d += (double)((float)(500 * this.getOriginalWalkMP()) * this.weight) / 100.0;
        d += (double)(200 * this.getFuel() / this.getFuelPerTon());
        d += this.getArmorWeight() * EquipmentType.getArmorCost(this.armorType);
        int n = 2000 + 4000 * this.getHeatType();
        d += (double)(n * this.getHeatSinks());
        d += (double)this.getWeaponsAndEquipmentCost();
        int n2 = 0;
        int n3 = 0;
        for (Bay bay : this.getTransportBays()) {
            n2 += bay.getDoors();
            if (bay instanceof MechBay || bay instanceof ASFBay || bay instanceof SmallCraftBay) {
                n3 += 20000 * bay.totalSpace;
            }
            if (!(bay instanceof LightVehicleBay) && !(bay instanceof HeavyVehicleBay)) continue;
            n3 += 10000 * bay.totalSpace;
        }
        d += (double)(n3 + n2 * 1000);
        d += (double)(5000 * (this.getLifeBoats() + this.getEscapePods()));
        double d4 = 36.0;
        if (this.isSpheroid()) {
            d4 = 28.0;
        }
        return Math.round(d * d4);
    }

    public int calculateBattleValue(boolean bl, boolean bl2) {
        EquipmentType equipmentType;
        double d = 0.0;
        double d2 = 0.0;
        d += (double)this.getTotalArmor() * 2.5;
        d += (double)this.getSI() * 2.0;
        double d3 = 0.0;
        for (Mounted serializable2 : this.getEquipment()) {
            EquipmentType d4 = serializable2.getType();
            if (serializable2.isDestroyed() || !(d4 instanceof WeaponType && d4.hasFlag(0x800000L) || d4 instanceof AmmoType && ((AmmoType)d4).getAmmoType() == 14) && (!(d4 instanceof MiscType) || !d4.hasFlag(1024L) && !d4.hasFlag(0x2000000L) && !d4.hasFlag(8192L) && !d4.hasFlag(0x800000000L))) continue;
            d3 += d4.getBV(this);
        }
        d += d3;
        d *= 1.0;
        int n = this.getHeatCapacity();
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        double d4 = 0.0;
        for (Mounted mounted : this.getTotalWeaponList()) {
            WeaponType d7 = (WeaponType)mounted.getType();
            if (d7 instanceof BayWeapon) continue;
            double d5 = d7.getHeat();
            if (mounted.isMissing() || mounted.isHit() || mounted.isDestroyed() || mounted.isBreached()) continue;
            if (d7.getAmmoType() == 29 || d7.hasFlag(16384L)) {
                d5 *= 0.25;
            }
            if (d7.getAmmoType() == 20 || d7.getAmmoType() == 33) {
                d5 *= 2.0;
            }
            if (d7.getAmmoType() == 23) {
                d5 *= 6.0;
            }
            if (d7.getAmmoType() == 11 || d7.getAmmoType() == 42 || d7.getAmmoType() == 31) {
                d5 *= 0.5;
            }
            d4 += d5;
            if (d7.hasFlag(131072L) && d7.getAmmoType() != 46 || d7.hasFlag(16384L) || d7.hasFlag(2048L) || d7.getAmmoType() == -1) continue;
            String string = d7.getAmmoType() + ":" + d7.getRackSize();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, d7.getBV(this));
                continue;
            }
            hashMap.put(string, d7.getBV(this) + (Double)hashMap.get(string));
        }
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        boolean bl3 = this.hasTargComp();
        if (d4 <= (double)n) {
            for (Mounted mounted : this.getTotalWeaponList()) {
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (weaponType instanceof BayWeapon) continue;
                double mounted2 = weaponType.getBV(this);
                if (mounted.isDestroyed() || weaponType.hasFlag(0x800000L)) continue;
                if (weaponType.hasFlag(1L) && bl3) {
                    mounted2 *= 1.25;
                }
                if (mounted.getLocation() == 3) {
                    d8 += mounted2;
                    continue;
                }
                d7 += mounted2;
            }
        } else {
            int d12 = 0;
            ArrayList<Mounted> arrayList = this.getTotalWeaponList();
            Collections.sort(arrayList, new WeaponComparator());
            for (Mounted mounted : arrayList) {
                Mounted mounted3;
                equipmentType = (WeaponType)mounted.getType();
                if (equipmentType instanceof BayWeapon) continue;
                double d9 = equipmentType.getBV(this);
                if (mounted.isDestroyed() || equipmentType.hasFlag(0x800000L)) continue;
                if (equipmentType.hasFlag(0x100000000L)) {
                    double d10 = 0.0;
                    for (Mounted mounted4 : this.getTotalWeaponList()) {
                        if (!mounted4.getType().hasFlag(512L) || mounted4.getLocation() != mounted.getLocation()) continue;
                        d10 += mounted4.getType().getBV(this);
                    }
                    d9 = d10 * 0.67;
                }
                if (equipmentType.hasFlag(1L) && bl3) {
                    d9 *= 1.25;
                }
                if (mounted.getLinkedBy() != null && (mounted3 = mounted.getLinkedBy()).getType() instanceof MiscType && mounted3.getType().hasFlag(512L)) {
                    d9 *= 1.2;
                }
                if (d12 > n && ((WeaponType)equipmentType).getHeat() > 0) {
                    d9 /= 2.0;
                }
                if (mounted.getLocation() == 3) {
                    d8 += d9;
                } else {
                    d7 += d9;
                }
                d12 += ((WeaponType)mounted.getType()).getHeat();
            }
        }
        if (d7 > d8) {
            d6 += d7;
            d6 += d8 * 0.5;
        } else {
            d6 += d8;
            d6 += d7 * 0.5;
        }
        double d11 = 0.0;
        for (Mounted mounted : this.getMisc()) {
            equipmentType = (MiscType)mounted.getType();
            if (mounted.isDestroyed() || equipmentType.hasFlag(1024L) || equipmentType.hasFlag(8192L) || equipmentType.hasFlag(0x2000000L) || equipmentType.hasFlag(0x800000000L) || equipmentType.hasFlag(2048L)) continue;
            d11 += ((MiscType)equipmentType).getBV(this);
            if (!equipmentType.hasFlag(0x80000000L)) continue;
            if (this.getArmor(mounted.getLocation(), false) != -3) {
                d11 += (double)this.getArmor(mounted.getLocation());
            }
            if (!this.hasRearArmor(mounted.getLocation()) || this.getArmor(mounted.getLocation(), true) == -3) continue;
            d11 += (double)this.getArmor(mounted.getLocation(), true);
        }
        d6 += d11;
        double d12 = 0.0;
        double d13 = 0.0;
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Mounted mounted : this.getAmmo()) {
            String string;
            Player player;
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14 || mounted.getLocation() == -1) continue;
            double d14 = ammoType.getBV(this);
            if (mounted.byShot()) {
                double d15 = (double)mounted.getShotsLeft() / (double)ammoType.getShots();
                if (ammoType.getAmmoRatio() > 0.0) {
                    d15 = (double)mounted.getShotsLeft() * ammoType.getAmmoRatio();
                }
                d14 *= d15;
            }
            if (ammoType.getMunitionType() == 262144L && (player = this.getOwner()) != null) {
                if (player.hasTAG()) {
                    d13 += d14;
                } else if (player.getTeam() != 0 && this.game != null) {
                    Enumeration<Team> enumeration = this.game.getTeams();
                    while (enumeration.hasMoreElements()) {
                        Team team = enumeration.nextElement();
                        if (team.getId() != player.getTeam()) continue;
                        if (!team.hasTAG(this.game)) break;
                        d13 += d14;
                        break;
                    }
                }
            }
            if (!arrayList.contains(string = ammoType.getAmmoType() + ":" + ammoType.getRackSize())) {
                arrayList.add(string);
            }
            if (!hashMap2.containsKey(string)) {
                hashMap2.put(string, d14);
                continue;
            }
            hashMap2.put(string, d14 + (Double)hashMap2.get(string));
        }
        for (String string : arrayList) {
            if (hashMap.get(string) != null) {
                if ((Double)hashMap2.get(string) > (Double)hashMap.get(string)) {
                    d12 += ((Double)hashMap.get(string)).doubleValue();
                    continue;
                }
                d12 += ((Double)hashMap2.get(string)).doubleValue();
                continue;
            }
            if (!string.equals(new Integer(36).toString() + "1")) continue;
            d12 += ((Double)hashMap2.get(string)).doubleValue();
        }
        double d16 = this.getOriginalWalkMP();
        double d17 = Math.pow(1.0 + (d16 - 5.0) / 10.0, 1.2);
        d17 = (double)Math.round(d17 * 100.0) / 100.0;
        d2 = (d6 += d12) * d17;
        double d18 = 0.0;
        d18 += d13;
        if ((this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.C3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5 || bl) && !bl2 && this.game != null) {
            int n2 = 0;
            n2 += this.calculateBattleValue(false, true);
            for (Entity entity : this.game.getC3NetworkMembers(this)) {
                if (this.equals(entity) || !this.onSameC3NetworkAs(entity)) continue;
                n2 += entity.calculateBattleValue(true);
            }
            n2 = (int)((double)n2 * 0.05);
            d18 += (double)n2;
        }
        int n3 = (int)Math.round(d + d2 + d18);
        double d19 = this.crew.getBVSkillMultiplier();
        int n4 = (int)Math.round((double)n3 * d19);
        if (bl2) {
            return n3;
        }
        return n4;
    }

    public int calculateBattleValue(boolean bl) {
        return this.calculateBattleValue(bl, false);
    }

    public boolean loadWeapon(Mounted mounted, Mounted mounted2) {
        boolean bl = false;
        WeaponType weaponType = (WeaponType)mounted.getType();
        AmmoType ammoType = (AmmoType)mounted2.getType();
        if (mounted.getLocation() != mounted2.getLocation()) {
            return bl;
        }
        Mounted mounted3 = this.whichBay(this.getEquipmentNum(mounted));
        if (mounted3 != null && !mounted3.ammoInBay(this.getEquipmentNum(mounted2))) {
            return bl;
        }
        if (mounted2.isAmmoUsable() && !weaponType.hasFlag(16384L) && ammoType.getAmmoType() == weaponType.getAmmoType() && ammoType.getRackSize() == weaponType.getRackSize()) {
            mounted.setLinked(mounted2);
            bl = true;
        }
        return bl;
    }
}

