/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentMode;
import megamek.common.EquipmentType;
import megamek.common.IGame;
import megamek.common.Messages;
import megamek.common.MiscType;
import megamek.common.RoundUpdated;
import megamek.common.WeaponType;
import megamek.debug.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mounted
implements Serializable,
RoundUpdated {
    private static final long serialVersionUID = 6438017987074691566L;
    private boolean usedThisRound = false;
    private boolean destroyed = false;
    private boolean hit = false;
    private boolean missing = false;
    private boolean jammed = false;
    private boolean useless = false;
    private boolean fired = false;
    private boolean rapidfire = false;
    private boolean hotloaded = false;
    private int mode;
    private int pendingMode = -1;
    private int location;
    private boolean rearMounted;
    private Mounted linked = null;
    private Mounted linkedBy = null;
    private Entity entity;
    private transient EquipmentType type;
    private String typeName;
    private int shotsLeft;
    private boolean m_bPendingDump;
    private boolean m_bDumping;
    private Vector<Integer> bayWeapons = new Vector();
    private Vector<Integer> bayAmmo = new Vector();
    private boolean byShot = false;
    private boolean bSplit = false;
    private int nFoundCrits = 0;
    private int secondLocation = 0;
    private boolean bombMounted = false;
    private int bombPoints = 0;
    private int mineType = -1;
    private int vibraSetting = 20;
    private IGame.Phase phase = IGame.Phase.PHASE_UNKNOWN;
    public static final int MINE_NONE = -1;
    public static final int MINE_CONVENTIONAL = 0;
    public static final int MINE_VIBRABOMB = 1;
    public static final int MINE_COMMAND_DETONATED = 2;
    protected int baseDamageAbsorptionRate = 0;
    protected int baseDamageCapacity = 0;
    protected int damageTaken = 0;

    public Mounted(Entity entity, EquipmentType equipmentType) {
        this.entity = entity;
        this.type = equipmentType;
        this.typeName = equipmentType.getInternalName();
        if (equipmentType instanceof AmmoType) {
            this.shotsLeft = ((AmmoType)equipmentType).getShots();
        }
        if (equipmentType instanceof MiscType && equipmentType.hasFlag(524288L)) {
            this.mineType = 0;
        }
        if (equipmentType instanceof MiscType && ((MiscType)equipmentType).isShield()) {
            MiscType miscType = (MiscType)equipmentType;
            this.baseDamageAbsorptionRate = miscType.baseDamageAbsorptionRate;
            this.baseDamageCapacity = miscType.baseDamageCapacity;
            this.damageTaken = miscType.damageTaken;
        }
    }

    public void changeAmmoType(AmmoType ammoType) {
        if (!(this.type instanceof AmmoType)) {
            System.out.println("Attempted to change ammo type of non-ammo");
            return;
        }
        this.type = ammoType;
        this.typeName = ammoType.getInternalName();
        this.shotsLeft = this.location == -1 ? 1 : ammoType.getShots();
    }

    public void restore() {
        if (this.typeName == null) {
            this.typeName = this.type.getName();
        } else {
            this.type = EquipmentType.get(this.typeName);
        }
        if (this.type == null) {
            System.err.println("Mounted.restore: could not restore equipment type \"" + this.typeName + "\"");
        }
    }

    public EquipmentType getType() {
        return this.type;
    }

    public EquipmentMode curMode() {
        if (this.mode >= 0 && this.mode < this.type.getModesCount()) {
            return this.type.getMode(this.mode);
        }
        return null;
    }

    public EquipmentMode pendingMode() {
        if (this.pendingMode < 0 || this.pendingMode >= this.type.getModesCount()) {
            return EquipmentMode.getMode("None");
        }
        return this.type.getMode(this.pendingMode);
    }

    public int switchMode() {
        if (this.type.hasModes()) {
            int n = 0;
            n = this.pendingMode > -1 ? (this.pendingMode + 1) % this.type.getModesCount() : (this.mode + 1) % this.type.getModesCount();
            this.setMode(n);
            return n;
        }
        return -1;
    }

    public int setMode(String string) {
        int n = this.type.getModesCount();
        for (int i = 0; i < n; ++i) {
            if (!this.type.getMode(i).equals(string)) continue;
            this.setMode(i);
            return i;
        }
        return -1;
    }

    public void setMode(int n) {
        if (this.type.hasModes()) {
            Assert.assertTrue(n >= 0 && n < this.type.getModesCount(), "Invalid mode, mode=" + n + ", modesCount=" + this.type.getModesCount());
            if (this.type.hasInstantModeSwitch()) {
                this.mode = n;
            } else if (this.pendingMode != n) {
                this.pendingMode = n;
            }
        }
    }

    @Override
    public void newRound(int n) {
        this.setUsedThisRound(false);
        if (this.type != null && this.type.hasModes() && this.pendingMode != -1) {
            this.mode = this.pendingMode;
            this.pendingMode = -1;
        }
    }

    public String getName() {
        return this.type.getName();
    }

    public String getDesc() {
        StringBuffer stringBuffer;
        switch (this.getMineType()) {
            case 0: {
                stringBuffer = new StringBuffer(Messages.getString("Mounted.ConventionalMine"));
                break;
            }
            case 1: {
                stringBuffer = new StringBuffer(Messages.getString("Mounted.VibraBombMine"));
                break;
            }
            case 2: {
                stringBuffer = new StringBuffer(Messages.getString("Mounted.CommandDetonatedMine"));
                break;
            }
            default: {
                stringBuffer = new StringBuffer(this.type.getDesc());
            }
        }
        if (this.destroyed) {
            stringBuffer.insert(0, "*");
        } else if (this.useless) {
            stringBuffer.insert(0, "x ");
        } else if (this.usedThisRound) {
            stringBuffer.insert(0, "+");
        } else if (this.jammed) {
            stringBuffer.insert(0, "j ");
        } else if (this.fired) {
            stringBuffer.insert(0, "x ");
        }
        if (this.rearMounted) {
            stringBuffer.append(" (R)");
        }
        if (this.type instanceof AmmoType && this.location != -1) {
            stringBuffer.append(" (");
            stringBuffer.append(this.shotsLeft);
            stringBuffer.append(")");
        }
        if (this.isDumping()) {
            stringBuffer.append(" (dumping)");
        }
        return stringBuffer.toString();
    }

    public boolean isReady() {
        return !this.usedThisRound && !this.destroyed && !this.jammed && !this.useless;
    }

    public boolean isUsedThisRound() {
        return this.usedThisRound;
    }

    public void setUsedThisRound(boolean bl) {
        this.usedThisRound = bl;
        this.phase = bl ? this.entity.game.getPhase() : IGame.Phase.PHASE_UNKNOWN;
    }

    public IGame.Phase usedInPhase() {
        if (this.usedThisRound) {
            return this.phase;
        }
        return IGame.Phase.PHASE_UNKNOWN;
    }

    public boolean isBreached() {
        return this.useless;
    }

    public void setBreached(boolean bl) {
        this.useless = bl;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean bl) {
        this.destroyed = bl;
    }

    public boolean isHit() {
        return this.hit;
    }

    public void setHit(boolean bl) {
        this.hit = bl;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public void setMissing(boolean bl) {
        this.missing = bl;
    }

    public boolean isJammed() {
        return this.jammed;
    }

    public void setJammed(boolean bl) {
        this.jammed = bl;
    }

    public int getShotsLeft() {
        return this.shotsLeft;
    }

    public void setShotsLeft(int n) {
        if (n < 0) {
            n = 0;
        }
        this.shotsLeft = n;
    }

    public int howManyShots() {
        int n;
        block3: {
            WeaponType weaponType;
            block5: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block4: {
                                    block2: {
                                        weaponType = (WeaponType)this.getType();
                                        n = 1;
                                        if (weaponType.getAmmoType() != 20 && weaponType.getAmmoType() != 33 || !this.curMode().equals("Ultra")) break block2;
                                        n = 2;
                                        break block3;
                                    }
                                    if (weaponType.getAmmoType() != 1 && weaponType.getAmmoType() != 34 || !weaponType.hasModes() || !this.curMode().equals("Rapid")) break block4;
                                    n = 2;
                                    break block3;
                                }
                                if (weaponType.getAmmoType() != 23 && !weaponType.getInternalName().equals("BAMineLauncher")) break block5;
                                if (!this.curMode().equals("2-shot")) break block6;
                                n = 2;
                                break block3;
                            }
                            if (!this.curMode().equals("3-shot")) break block7;
                            n = 3;
                            break block3;
                        }
                        if (!this.curMode().equals("4-shot")) break block8;
                        n = 4;
                        break block3;
                    }
                    if (!this.curMode().equals("5-shot")) break block9;
                    n = 5;
                    break block3;
                }
                if (!this.curMode().equals("6-shot")) break block3;
                n = 6;
                break block3;
            }
            if (weaponType.hasFlag(0x100000000L)) {
                n = 0;
                for (Mounted mounted : this.entity.getWeaponList()) {
                    if (mounted.getLocation() != this.getLocation() || mounted.isDestroyed() || mounted.isBreached() || !mounted.getType().hasFlag(512L) || ((WeaponType)mounted.getType()).getRackSize() != ((WeaponType)this.getType()).getRackSize()) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public boolean isPendingDump() {
        return this.m_bPendingDump;
    }

    public void setPendingDump(boolean bl) {
        this.m_bPendingDump = bl;
    }

    public boolean isDumping() {
        return this.m_bDumping;
    }

    public void setDumping(boolean bl) {
        this.m_bDumping = bl;
    }

    public boolean isRapidfire() {
        return this.rapidfire;
    }

    public void setRapidfire(boolean bl) {
        this.rapidfire = bl;
    }

    public boolean isHotLoaded() {
        boolean bl = false;
        if (this.getType() instanceof WeaponType) {
            Mounted mounted = this.getLinked();
            if (mounted == null || !(mounted.getType() instanceof AmmoType)) {
                return false;
            }
            bl = mounted.hotloaded;
            if (((AmmoType)mounted.getType()).getMunitionType() == 8192L) {
                return true;
            }
            if (!bl && mounted.getType().hasModes() && mounted.curMode().equals("HotLoad")) {
                bl = true;
            }
            return bl;
        }
        if (this.getType() instanceof AmmoType) {
            bl = this.hotloaded;
            if (((AmmoType)this.getType()).getMunitionType() == 8192L) {
                return true;
            }
            if (!bl && this.getType().hasModes() && this.curMode().equals("HotLoad")) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public void setHotLoad(boolean bl) {
        if (this.getType() instanceof WeaponType) {
            Mounted mounted = this.getLinked();
            if (mounted == null || !(mounted.getType() instanceof AmmoType)) {
                return;
            }
            if (((AmmoType)mounted.getType()).hasFlag(8L)) {
                mounted.hotloaded = bl;
            }
        }
        if (this.getType() instanceof AmmoType && ((AmmoType)this.getType()).hasFlag(8L)) {
            this.hotloaded = bl;
        }
    }

    public boolean hasChargedCapacitor() {
        MiscType miscType;
        return this.getLinkedBy() != null && this.getLinkedBy().getType() instanceof MiscType && !this.getLinkedBy().isDestroyed() && (miscType = (MiscType)this.getLinkedBy().getType()).hasFlag(0x1000000000L) && this.getLinkedBy().curMode().equals("Charge");
    }

    public int getLocation() {
        return this.location;
    }

    public int getSecondLocation() {
        if (this.bSplit) {
            return this.secondLocation;
        }
        return -1;
    }

    public boolean isRearMounted() {
        return this.rearMounted;
    }

    public void setLocation(int n) {
        this.setLocation(n, false);
    }

    public void setSecondLocation(int n) {
        this.setSecondLocation(n, false);
    }

    public void setLocation(int n, boolean bl) {
        this.location = n;
        this.rearMounted = bl;
    }

    public void setSecondLocation(int n, boolean bl) {
        this.secondLocation = n;
        this.rearMounted = bl;
    }

    public Mounted getLinked() {
        return this.linked;
    }

    public Mounted getLinkedBy() {
        return this.linkedBy;
    }

    public void setLinked(Mounted mounted) {
        this.linked = mounted;
        mounted.setLinkedBy(this);
    }

    protected void setLinkedBy(Mounted mounted) {
        if (mounted.getLinked() != this) {
            return;
        }
        this.linkedBy = mounted;
    }

    public int getFoundCrits() {
        return this.nFoundCrits;
    }

    public void setFoundCrits(int n) {
        this.nFoundCrits = n;
    }

    public boolean isSplit() {
        return this.bSplit;
    }

    public boolean isSplitable() {
        return this.getType() instanceof WeaponType && this.getType().hasFlag(256L);
    }

    public void setSplit(boolean bl) {
        this.bSplit = bl;
    }

    public int getExplosionDamage() {
        if (this.type instanceof AmmoType) {
            AmmoType ammoType = (AmmoType)this.type;
            int n = ammoType.getRackSize();
            int n2 = ammoType.getDamagePerShot();
            if (ammoType.getMunitionType() == 8192L || ammoType.getMunitionType() == 32768L) {
                ++n2;
            }
            return n2 * n * this.shotsLeft;
        }
        if (this.type instanceof WeaponType) {
            WeaponType weaponType = (WeaponType)this.type;
            if (weaponType.getAmmoType() == 6 || weaponType.getAmmoType() == 47) {
                return 20;
            }
            if (weaponType.getAmmoType() == 21) {
                return 16;
            }
            if (weaponType.getAmmoType() == 48) {
                return 22;
            }
            if (weaponType.getAmmoType() == 22) {
                return 25;
            }
            if (weaponType.getAmmoType() == 23 || weaponType.getAmmoType() == 1 || weaponType.getAmmoType() == 34) {
                return weaponType.getDamage();
            }
            if (weaponType.getAmmoType() == 39) {
                return 3;
            }
            if (weaponType.getAmmoType() == 44) {
                return weaponType.getRackSize() / 2;
            }
            if (this.isHotLoaded() && this.getLinked().getShotsLeft() > 0) {
                Mounted mounted = this.getLinked();
                AmmoType ammoType = (AmmoType)mounted.getType();
                int n = ammoType.getDamagePerShot();
                if ((long)ammoType.getAmmoType() == 8192L) {
                    ++n;
                }
                int n3 = weaponType.getRackSize() * n;
                return n3;
            }
            if (weaponType.hasFlag(8L) && this.hasChargedCapacitor()) {
                if (this.isFired()) {
                    return 0;
                }
                return 15;
            }
        } else if (this.type instanceof MiscType) {
            MiscType miscType = (MiscType)this.type;
            if (miscType.hasFlag(0x1000000000L)) {
                if (this.curMode().equals("Charge") && this.linked != null && !this.linked.isFired()) {
                    return 15;
                }
            } else if (miscType.hasFlag(0x800000000L)) {
                return 2;
            }
            return 0;
        }
        System.err.println("mounted: unable to determine explosion damage for " + this.getName());
        return 0;
    }

    public boolean isFired() {
        return this.fired;
    }

    public void setFired(boolean bl) {
        this.fired = bl;
    }

    public boolean canFire() {
        if (!this.isReady() || this.isBreached() || this.isMissing() || this.isFired()) {
            return false;
        }
        return !this.entity.isShutDown() && this.entity.getCrew().isActive();
    }

    public boolean isAmmoUsable() {
        return !this.destroyed && !this.m_bDumping && !this.useless && this.shotsLeft > 0 && this.location != -1;
    }

    public int getMineType() {
        return this.mineType;
    }

    public void setMineType(int n) {
        this.mineType = n;
    }

    public void setVibraSetting(int n) {
        this.vibraSetting = n;
    }

    public int getVibraSetting() {
        return this.vibraSetting;
    }

    public String toString() {
        return "megamek.common.Mounted (" + this.typeName + ")";
    }

    public int getBaseDamageAbsorptionRate() {
        return this.baseDamageAbsorptionRate;
    }

    public int getBaseDamageCapacity() {
        return this.baseDamageCapacity;
    }

    public int getDamageAbsorption(Entity entity, int n) {
        if (n != 4 && n != 5) {
            return 0;
        }
        int n2 = this.baseDamageAbsorptionRate;
        for (int i = 0; i < entity.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = entity.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || !((equipmentType = (mounted = entity.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !((MiscType)equipmentType).isShield() || !criticalSlot.isDamaged()) continue;
            --n2;
        }
        if (entity.hasSystem(7, n) && !entity.hasWorkingSystem(7, n)) {
            n2 -= 2;
        }
        if (entity.hasSystem(9, n) && !entity.hasWorkingSystem(9, n)) {
            --n2;
        }
        if (entity.hasSystem(8, n) && !entity.hasWorkingSystem(8, n)) {
            --n2;
        }
        return Math.max(0, n2);
    }

    public int getCurrentDamageCapacity(Entity entity, int n) {
        if (n != 4 && n != 5) {
            return 0;
        }
        int n2 = this.baseDamageCapacity;
        for (int i = 0; i < entity.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = entity.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || !((equipmentType = (mounted = entity.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !((MiscType)equipmentType).isShield() || !criticalSlot.isDamaged()) continue;
            n2 -= 5;
        }
        return Math.max(0, n2 - this.damageTaken);
    }

    public void addWeaponToBay(int n) {
        this.bayWeapons.add(n);
    }

    public Vector<Integer> getBayWeapons() {
        return this.bayWeapons;
    }

    public void addAmmoToBay(int n) {
        this.bayAmmo.add(n);
    }

    public Vector<Integer> getBayAmmo() {
        return this.bayAmmo;
    }

    public void setByShot(boolean bl) {
        this.byShot = bl;
    }

    public boolean byShot() {
        return this.byShot;
    }

    public boolean isBombMounted() {
        return this.bombMounted;
    }

    public void setBombMounted(boolean bl) {
        this.bombMounted = bl;
    }

    public int getBombPoints() {
        return this.bombPoints;
    }

    public void setBombPoints(int n) {
        this.bombPoints = n;
    }

    public boolean ammoInBay(int n) {
        for (int n2 : this.bayAmmo) {
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    public int getCurrentShots() {
        int n = 1;
        if (null != this.curMode()) {
            if (this.curMode().equals("6-shot")) {
                n = 6;
            } else if (this.curMode().equals("5-shot")) {
                n = 5;
            } else if (this.curMode().equals("4-shot")) {
                n = 4;
            } else if (this.curMode().equals("3-shot")) {
                n = 3;
            } else if (this.curMode().equals("2-shot")) {
                n = 2;
            } else if (this.curMode().equals("Single")) {
                n = 1;
            } else if (this.curMode().equals("Ultra")) {
                n = 2;
            }
        }
        return n;
    }

    public int getCurrentHeat() {
        if (this.getType() instanceof WeaponType) {
            return ((WeaponType)this.getType()).getHeat() * this.getCurrentShots();
        }
        return 0;
    }
}

