/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.ITerrain;
import megamek.common.Terrains;

public class Terrain
implements ITerrain,
Serializable {
    private static final long serialVersionUID = -7624691566755134033L;
    private final int type;
    private int level;
    private boolean exitsSpecified = false;
    private int exits;
    private int terrainFactor;

    public Terrain(int n, int n2) {
        this(n, n2, false, 0);
    }

    public Terrain(int n, int n2, boolean bl, int n3) {
        this.type = n;
        this.level = n2;
        this.exitsSpecified = bl;
        this.exits = n3;
        this.terrainFactor = 40 * n2 + 10;
    }

    public Terrain(ITerrain iTerrain) {
        this.type = iTerrain.getType();
        this.level = iTerrain.getLevel();
        this.exitsSpecified = iTerrain.hasExitsSpecified();
        this.exits = iTerrain.getExits();
        this.terrainFactor = iTerrain.getTerrainFactor();
    }

    public Terrain(String string) {
        int n = string.indexOf(58);
        int n2 = string.lastIndexOf(58);
        String string2 = string.substring(0, n);
        this.type = Terrains.getType(string2);
        if (n == n2) {
            this.level = Terrain.levelFor(string.substring(n + 1));
            this.exitsSpecified = false;
            if (this.type == 10 || this.type == 34) {
                this.exitsSpecified = true;
            }
        } else {
            this.level = Terrain.levelFor(string.substring(n + 1, n2));
            this.exitsSpecified = true;
            this.exits = Terrain.levelFor(string.substring(n2 + 1));
        }
        this.terrainFactor = 40 * this.level + 10;
    }

    public static int levelFor(String string) {
        if (string.equals("*")) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(string);
    }

    public int getType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }

    public int getTerrainFactor() {
        return this.terrainFactor;
    }

    public void setTerrainFactor(int n) {
        this.terrainFactor = n;
    }

    public int getExits() {
        return this.exits;
    }

    public boolean hasExitsSpecified() {
        return this.exitsSpecified;
    }

    public void setExits(int n) {
        this.exits = n;
    }

    public void setExit(int n, boolean bl) {
        int n2 = (int)Math.pow(2.0, n);
        this.exits = bl ? (this.exits |= n2) : (this.exits &= 0x3F ^ n2);
    }

    public void flipExits(boolean bl, boolean bl2) {
        if (!bl && !bl2) {
            return;
        }
        int n = 0;
        if (0 != (this.exits & 1) && bl2) {
            n |= 8;
        }
        if (0 != (this.exits & 2)) {
            if (bl2 && bl) {
                n |= 0x10;
            } else if (bl) {
                n |= 0x20;
            } else if (bl2) {
                n |= 4;
            }
        }
        if (0 != (this.exits & 4)) {
            if (bl2 && bl) {
                n |= 0x20;
            } else if (bl) {
                n |= 0x10;
            } else if (bl2) {
                n |= 2;
            }
        }
        if (0 != (this.exits & 8) && bl2) {
            n |= 1;
        }
        if (0 != (this.exits & 0x10)) {
            if (bl2 && bl) {
                n |= 2;
            } else if (bl) {
                n |= 4;
            } else if (bl2) {
                n |= 0x20;
            }
        }
        if (0 != (this.exits & 0x20)) {
            if (bl2 && bl) {
                n |= 4;
            } else if (bl) {
                n |= 2;
            } else if (bl2) {
                n |= 0x10;
            }
        }
        this.setExits(n);
    }

    public boolean exitsTo(ITerrain iTerrain) {
        if (iTerrain == null) {
            return false;
        }
        return this.type == iTerrain.getType() && this.level == iTerrain.getLevel();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ITerrain)) {
            return false;
        }
        ITerrain iTerrain = (ITerrain)object;
        return this.type == iTerrain.getType() && this.level == iTerrain.getLevel();
    }

    public String toString() {
        return Terrains.getName(this.type) + ":" + this.level + (this.exitsSpecified ? ":" + this.exits : "");
    }

    public int pilotingModifier() {
        switch (this.type) {
            case 23: {
                return this.level;
            }
            case 24: {
                return this.level == 2 ? 4 : 1;
            }
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                return 1;
            }
            case 22: {
                if (this.level == 2) {
                    return 1;
                }
                return 0;
            }
            case 26: {
                return 2;
            }
        }
        return 0;
    }

    public int movementCost(int n) {
        switch (this.type) {
            case 24: {
                return this.level - 1;
            }
            case 22: {
                if (this.level == 2) {
                    return 1;
                }
                return 0;
            }
            case 1: {
                return this.level;
            }
            case 23: {
                return this.level + 1;
            }
            case 2: 
            case 9: 
            case 25: 
            case 26: 
            case 28: {
                if (n == 5 || n == 15) {
                    return 0;
                }
                return 1;
            }
            case 3: {
                return 1;
            }
            case 27: {
                if (n == 4 || n == 12 || n == 10 || n == 11) {
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }
}

