/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.InitiativeRoll;
import megamek.common.Team;
import megamek.common.TurnVectors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TurnOrdered
implements Serializable {
    private InitiativeRoll initiative = new InitiativeRoll();
    private transient int turns_other = 0;
    private transient int turns_even = 0;
    private transient int turns_multi = 0;
    private transient int turns_ss = 0;
    private transient int turns_js = 0;
    private transient int turns_ws = 0;
    private transient int turns_ds = 0;
    private transient int turns_sc = 0;

    public int getNormalTurns(IGame iGame) {
        return this.getMultiTurns(iGame) + this.getOtherTurns();
    }

    public int getOtherTurns() {
        return this.turns_other;
    }

    public int getEvenTurns() {
        return this.turns_even;
    }

    public int getMultiTurns(IGame iGame) {
        return (int)Math.ceil((double)this.turns_multi / (double)iGame.getOptions().intOption("inf_proto_move_multi"));
    }

    public int getSpaceStationTurns() {
        return this.turns_ss;
    }

    public int getJumpshipTurns() {
        return this.turns_js;
    }

    public int getWarshipTurns() {
        return this.turns_ws;
    }

    public int getDropshipTurns() {
        return this.turns_ds;
    }

    public int getSmallCraftTurns() {
        return this.turns_sc;
    }

    public void incrementOtherTurns() {
        ++this.turns_other;
    }

    public void incrementEvenTurns() {
        ++this.turns_even;
    }

    public void incrementMultiTurns() {
        ++this.turns_multi;
    }

    public void incrementSpaceStationTurns() {
        ++this.turns_ss;
    }

    public void incrementJumpshipTurns() {
        ++this.turns_js;
    }

    public void incrementWarshipTurns() {
        ++this.turns_ws;
    }

    public void incrementDropshipTurns() {
        ++this.turns_ds;
    }

    public void incrementSmallCraftTurns() {
        ++this.turns_sc;
    }

    public void resetOtherTurns() {
        this.turns_other = 0;
    }

    public void resetEvenTurns() {
        this.turns_even = 0;
    }

    public void resetMultiTurns() {
        this.turns_multi = 0;
    }

    public void resetSpaceStationTurns() {
        this.turns_ss = 0;
    }

    public void resetJumpshipTurns() {
        this.turns_js = 0;
    }

    public void resetWarshipTurns() {
        this.turns_ws = 0;
    }

    public void resetDropshipTurns() {
        this.turns_ds = 0;
    }

    public void resetSmallCraftTurns() {
        this.turns_sc = 0;
    }

    public InitiativeRoll getInitiative() {
        return this.initiative;
    }

    public void clearInitiative() {
        this.getInitiative().clear();
    }

    public static void rollInitiative(Vector<? extends TurnOrdered> vector) {
        Enumeration<? extends TurnOrdered> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            TurnOrdered turnOrdered = enumeration.nextElement();
            turnOrdered.clearInitiative();
        }
        TurnOrdered.rollInitAndResolveTies(vector, null);
    }

    public static void rollInitAndResolveTies(Vector<? extends TurnOrdered> vector, Vector<? extends TurnOrdered> vector2) {
        TurnOrdered turnOrdered;
        Enumeration<? extends TurnOrdered> enumeration;
        Object object;
        Object object2 = vector.elements();
        block0: while (object2.hasMoreElements()) {
            object = object2.nextElement();
            int n = 0;
            if (object instanceof Team) {
                n = ((Team)object).getTotalInitBonus();
            }
            if (object instanceof Entity) {
                enumeration = (Entity)object;
                n = ((Entity)((Object)enumeration)).game.getTeamForPlayer(((Entity)((Object)enumeration)).owner).getTotalInitBonus();
            }
            if (vector2 == null) {
                ((TurnOrdered)object).getInitiative().addRoll(n);
                continue;
            }
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                turnOrdered = (TurnOrdered)enumeration.nextElement();
                if (object != turnOrdered) continue;
                ((TurnOrdered)object).getInitiative().replaceRoll(n);
                continue block0;
            }
        }
        object2 = new Vector();
        object = vector.elements();
        while (object.hasMoreElements()) {
            TurnOrdered turnOrdered2 = (TurnOrdered)object.nextElement();
            ((Vector)object2).removeAllElements();
            ((Vector)object2).addElement(turnOrdered2);
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                turnOrdered = enumeration.nextElement();
                if (turnOrdered2 == turnOrdered || !turnOrdered2.getInitiative().equals(turnOrdered.getInitiative())) continue;
                ((Vector)object2).addElement(turnOrdered);
            }
            if (((Vector)object2).size() <= 1) continue;
            TurnOrdered.rollInitAndResolveTies((Vector<? extends TurnOrdered>)object2, null);
        }
    }

    public static TurnVectors generateTurnOrder(Vector<? extends TurnOrdered> vector, IGame iGame) {
        int n;
        int n2;
        int n3;
        int[] nArray = new int[vector.size()];
        int[] nArray2 = new int[vector.size()];
        int[] nArray3 = new int[vector.size()];
        int[] nArray4 = new int[vector.size()];
        int[] nArray5 = new int[vector.size()];
        int[] nArray6 = new int[vector.size()];
        int[] nArray7 = new int[vector.size()];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        TurnOrdered[] turnOrderedArray = new TurnOrdered[vector.size()];
        int n11 = 0;
        ArrayList<? extends TurnOrdered> arrayList = new ArrayList<TurnOrdered>(vector.size());
        arrayList.addAll(vector);
        Collections.sort(arrayList, new Comparator<TurnOrdered>(){

            @Override
            public int compare(TurnOrdered turnOrdered, TurnOrdered turnOrdered2) {
                return turnOrdered.getInitiative().compareTo(turnOrdered2.getInitiative());
            }
        });
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TurnOrdered turnOrdered;
            turnOrderedArray[n11] = turnOrdered = (TurnOrdered)iterator.next();
            nArray2[n11] = turnOrdered.getNormalTurns(iGame);
            nArray[n11] = turnOrdered.getEvenTurns();
            nArray3[n11] = turnOrdered.getSpaceStationTurns();
            nArray4[n11] = turnOrdered.getJumpshipTurns();
            nArray5[n11] = turnOrdered.getWarshipTurns();
            nArray6[n11] = turnOrdered.getDropshipTurns();
            nArray7[n11] = turnOrdered.getSmallCraftTurns();
            n4 += nArray[n11];
            n5 += nArray2[n11];
            n6 += nArray3[n11];
            n7 += nArray4[n11];
            n8 += nArray5[n11];
            n9 += nArray6[n11];
            n10 += nArray7[n11];
            ++n11;
        }
        int n12 = Integer.MAX_VALUE;
        int n13 = Integer.MAX_VALUE;
        int n14 = Integer.MAX_VALUE;
        int n15 = Integer.MAX_VALUE;
        int n16 = Integer.MAX_VALUE;
        int n17 = Integer.MAX_VALUE;
        for (n3 = 0; n3 < n11; ++n3) {
            if (nArray2[n3] != 0 && nArray2[n3] < n12) {
                n12 = nArray2[n3];
            }
            if (nArray3[n3] != 0 && nArray3[n3] < n13) {
                n13 = nArray3[n3];
            }
            if (nArray4[n3] != 0 && nArray4[n3] < n14) {
                n14 = nArray4[n3];
            }
            if (nArray5[n3] != 0 && nArray5[n3] < n15) {
                n15 = nArray5[n3];
            }
            if (nArray6[n3] != 0 && nArray6[n3] < n16) {
                n16 = nArray6[n3];
            }
            if (nArray7[n3] == 0 || nArray7[n3] >= n17) continue;
            n17 = nArray7[n3];
        }
        int n18 = n5 + n6 + n7 + n8 + n9 + n10;
        TurnVectors turnVectors = new TurnVectors(n5, n18, n6, n7, n8, n9, n10, n4, n12);
        int n19 = n6;
        while (n19 > 0) {
            for (n3 = 0; n3 < n11; ++n3) {
                if (nArray3[n3] == 0) continue;
                n2 = nArray3[n3] / n13;
                for (n = 0; n < n2; ++n) {
                    turnVectors.addSpaceStation(turnOrderedArray[n3]);
                    int n20 = n3;
                    nArray3[n20] = nArray3[n20] - 1;
                    --n19;
                }
            }
            --n13;
        }
        n19 = n7;
        while (n19 > 0) {
            for (n3 = 0; n3 < n11; ++n3) {
                if (nArray4[n3] == 0) continue;
                n2 = nArray4[n3] / n14;
                for (n = 0; n < n2; ++n) {
                    turnVectors.addJumpship(turnOrderedArray[n3]);
                    int n21 = n3;
                    nArray4[n21] = nArray4[n21] - 1;
                    --n19;
                }
            }
            --n14;
        }
        n19 = n8;
        while (n19 > 0) {
            for (n3 = 0; n3 < n11; ++n3) {
                if (nArray5[n3] == 0) continue;
                n2 = nArray5[n3] / n15;
                for (n = 0; n < n2; ++n) {
                    turnVectors.addWarship(turnOrderedArray[n3]);
                    int n22 = n3;
                    nArray5[n22] = nArray5[n22] - 1;
                    --n19;
                }
            }
            --n15;
        }
        n19 = n9;
        while (n19 > 0) {
            for (n3 = 0; n3 < n11; ++n3) {
                if (nArray6[n3] == 0) continue;
                n2 = nArray6[n3] / n16;
                for (n = 0; n < n2; ++n) {
                    turnVectors.addDropship(turnOrderedArray[n3]);
                    int n23 = n3;
                    nArray6[n23] = nArray6[n23] - 1;
                    --n19;
                }
            }
            --n16;
        }
        n19 = n10;
        while (n19 > 0) {
            for (n3 = 0; n3 < n11; ++n3) {
                if (nArray7[n3] == 0) continue;
                n2 = nArray7[n3] / n13;
                for (n = 0; n < n2; ++n) {
                    turnVectors.addSmallCraft(turnOrderedArray[n3]);
                    int n24 = n3;
                    nArray7[n24] = nArray7[n24] - 1;
                    --n19;
                }
            }
            --n17;
        }
        n19 = n5;
        while (n19 > 0) {
            for (n3 = 0; n3 < n11; ++n3) {
                if (nArray2[n3] == 0) continue;
                n2 = nArray2[n3] / n12;
                for (n = 0; n < n2; ++n) {
                    turnVectors.addNormal(turnOrderedArray[n3]);
                    int n25 = n3;
                    nArray2[n25] = nArray2[n25] - 1;
                    --n19;
                }
            }
            --n12;
        }
        if (n4 > 0) {
            n12 = Integer.MAX_VALUE;
            for (n3 = 0; n3 < n11; ++n3) {
                if (nArray[n3] == 0 || nArray[n3] >= n12) continue;
                n12 = nArray[n3];
            }
            n19 = n4;
            while (n19 > 0) {
                for (n3 = 0; n3 < n11; ++n3) {
                    if (nArray[n3] == 0) continue;
                    n2 = nArray[n3] / n12;
                    for (n = 0; n < n2; ++n) {
                        turnVectors.addEven(turnOrderedArray[n3]);
                        int n26 = n3;
                        nArray[n26] = nArray[n26] - 1;
                        --n19;
                    }
                }
                --n12;
            }
        }
        return turnVectors;
    }
}

