/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.HitData;
import megamek.common.IHex;
import megamek.common.Mounted;
import megamek.common.MoveStep;
import megamek.common.PilotingRollData;
import megamek.common.Tank;

public class VTOL
extends Tank {
    private static final long serialVersionUID = -7406911547399249173L;
    public static final int LOC_ROTOR = 5;
    protected static String[] LOCATION_ABBRS = new String[]{"BD", "FR", "RS", "LS", "RR", "RO"};
    protected static String[] LOCATION_NAMES = new String[]{"Body", "Front", "Right", "Left", "Rear", "Rotor"};
    public static final int CRIT_COPILOT = 15;
    public static final int CRIT_PILOT = 16;
    public static final int CRIT_ROTOR_DAMAGE = 17;
    public static final int CRIT_ROTOR_DESTROYED = 18;
    public static final int CRIT_FLIGHT_STABILIZER = 19;

    public String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    public PilotingRollData checkSkid(int n, IHex iHex, int n2, MoveStep moveStep, int n3, int n4, Coords coords, Coords coords2, boolean bl, int n5) {
        PilotingRollData pilotingRollData = this.getBasePilotingRoll();
        pilotingRollData.addModifier(-2147483647, "Check false: VTOLs can't skid");
        return pilotingRollData;
    }

    public boolean canCharge() {
        return false;
    }

    public String getMovementString(int n) {
        switch (n) {
            case 4: {
                return "Cruised";
            }
            case 5: {
                return "Flanked";
            }
            case 0: {
                return "None";
            }
        }
        return "Unknown!";
    }

    public String getMovementAbbr(int n) {
        switch (n) {
            case 4: {
                return "C";
            }
            case 5: {
                return "F";
            }
            case 0: {
                return "N";
            }
        }
        return "?";
    }

    public int getMaxElevationChange() {
        return 999;
    }

    public boolean isHexProhibited(IHex iHex) {
        if (iHex.containsTerrain(32)) {
            return true;
        }
        return iHex.containsTerrain(30) && this.doomedInSpace();
    }

    public boolean isRepairable() {
        boolean bl = this.isSalvage();
        for (int i = 1; bl && i < 5; ++i) {
            int n = this.getInternal(i);
            bl = n != -2 && n != -3;
        }
        return bl;
    }

    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = 1;
        boolean bl = false;
        if (n2 == 2) {
            n6 = 3;
            bl = true;
        } else if (n2 == 3) {
            n6 = 2;
            bl = true;
        } else if (n2 == 1) {
            n6 = 4;
        }
        HitData hitData = new HitData(n6);
        boolean bl2 = false;
        if (n3 != -1 && n4 != 0 && 5 < (n5 = Compute.d6(2)) && n5 < 9) {
            hitData = new HitData(n3, n2 == 1, true);
            bl2 = true;
        }
        if (!bl2) {
            switch (Compute.d6(2)) {
                case 2: {
                    hitData.setEffect(1);
                    break;
                }
                case 3: 
                case 4: {
                    hitData = new HitData(5, false, 2);
                    break;
                }
                case 5: {
                    if (bl) {
                        hitData = new HitData(1);
                        break;
                    }
                    hitData = new HitData(2);
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    if (!bl) break;
                    hitData.setEffect(1);
                    break;
                }
                case 9: {
                    if (bl) {
                        hitData = new HitData(4);
                        break;
                    }
                    hitData = new HitData(3);
                    break;
                }
                case 10: 
                case 11: {
                    hitData = new HitData(5, false, 2);
                    break;
                }
                case 12: {
                    hitData = new HitData(5, false, 3);
                }
            }
        }
        if (n == 3) {
            hitData.setEffect(hitData.getEffect() | 1);
        }
        return hitData;
    }

    public boolean doomedInVacuum() {
        return true;
    }

    public boolean doomedInAtmosphere() {
        return true;
    }

    public boolean doomedInSpace() {
        return true;
    }

    public void setOnFire(boolean bl) {
        super.setOnFire(bl);
        this.extinguishLocation(5);
    }

    public int getCriticalEffect(int n, int n2) {
        if (n > 12) {
            n = 12;
        }
        if (n < 6) {
            return -1;
        }
        block32: for (int i = 0; i < 2; ++i) {
            if (i > 0) {
                n = 6;
            }
            if (n2 == 1) {
                switch (n) {
                    case 6: {
                        if (!this.isDriverHit()) {
                            return 15;
                        }
                        if (!this.crew.isDead() && !this.crew.isDoomed()) {
                            return 6;
                        }
                    }
                    case 7: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isJammed() || mounted.isHit()) continue;
                            return 1;
                        }
                    }
                    case 8: {
                        if (!this.isStabiliserHit(n2)) {
                            for (Mounted mounted : this.getWeaponList()) {
                                if (mounted.getLocation() != n2) continue;
                                return 3;
                            }
                        }
                    }
                    case 9: {
                        if (this.getSensorHits() < 4) {
                            return 4;
                        }
                    }
                    case 10: {
                        if (!this.isCommanderHit()) {
                            return 16;
                        }
                        if (!this.crew.isDead() && !this.crew.isDoomed()) {
                            return 6;
                        }
                    }
                    case 11: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isHit()) continue;
                            return 2;
                        }
                    }
                    case 12: {
                        if (this.crew.isDead() || this.crew.isDoomed()) break;
                        return 6;
                    }
                }
                continue;
            }
            if (n2 == 4) {
                switch (n) {
                    case 6: {
                        if (this.getLoadedUnits().size() > 0) {
                            return 8;
                        }
                    }
                    case 7: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isJammed() || mounted.isHit()) continue;
                            return 1;
                        }
                    }
                    case 8: {
                        if (!this.isStabiliserHit(n2)) {
                            for (Mounted mounted : this.getWeaponList()) {
                                if (mounted.getLocation() != n2) continue;
                                return 3;
                            }
                        }
                    }
                    case 9: {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isHit()) continue;
                            return 2;
                        }
                    }
                    case 10: {
                        if (this.getSensorHits() < 4) {
                            return 4;
                        }
                    }
                    case 11: {
                        if (!this.engineHit) {
                            return 9;
                        }
                    }
                    case 12: {
                        if (this.getEngine().isFusion() && !this.engineHit) {
                            return 9;
                        }
                        if (this.getEngine().isFusion()) break;
                        return 10;
                    }
                }
                continue;
            }
            if (n2 == 5) {
                switch (n) {
                    case 6: 
                    case 7: 
                    case 8: {
                        if (!this.isImmobile()) {
                            return 17;
                        }
                    }
                    case 9: 
                    case 10: {
                        if (!this.isStabiliserHit(n2)) {
                            return 19;
                        }
                    }
                    case 11: 
                    case 12: {
                        return 18;
                    }
                }
                continue;
            }
            switch (n) {
                case 6: {
                    for (Mounted mounted : this.getWeaponList()) {
                        if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isJammed() || mounted.isHit()) continue;
                        return 1;
                    }
                }
                case 7: {
                    if (this.getLoadedUnits().size() > 0) {
                        return 8;
                    }
                }
                case 8: {
                    if (!this.isStabiliserHit(n2)) {
                        for (Mounted mounted : this.getWeaponList()) {
                            if (mounted.getLocation() != n2) continue;
                            return 3;
                        }
                    }
                }
                case 9: {
                    for (Mounted mounted : this.getWeaponList()) {
                        if (mounted.getLocation() != n2 || mounted.isDestroyed() || mounted.isHit()) continue;
                        return 2;
                    }
                }
                case 10: {
                    if (!this.engineHit) {
                        return 9;
                    }
                }
                case 11: {
                    for (Mounted mounted : this.getAmmo()) {
                        if (mounted.isDestroyed() || mounted.isHit()) continue;
                        return 11;
                    }
                }
                case 12: {
                    if (this.getEngine().isFusion() && !this.engineHit) {
                        return 9;
                    }
                    if (this.getEngine().isFusion()) continue block32;
                    return 10;
                }
            }
        }
        return -1;
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        if (this.movementDamage > 0) {
            pilotingRollData.addModifier(this.movementDamage, "Steering Damage");
        }
        if (this.isDriverHit()) {
            pilotingRollData.addModifier(2, "pilot injured");
        }
        if (this.isStabiliserHit(5)) {
            pilotingRollData.addModifier(3, "flight stabiliser damaged");
        }
        if (this.getCrew().getOptions().booleanOption("vdni") && !this.getCrew().getOptions().booleanOption("bvdni")) {
            pilotingRollData.addModifier(-1, "VDNI");
        }
        return pilotingRollData;
    }

    public boolean isFlying() {
        return !this.isImmobile();
    }
}

