/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.GunEmplacement;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.PhysicalAttackAction;

public class JumpJetAttackAction
extends PhysicalAttackAction {
    private static final long serialVersionUID = 5068155731614378911L;
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private int leg;

    public JumpJetAttackAction(int n, int n2, int n3) {
        super(n, n2);
        this.leg = n3;
    }

    public JumpJetAttackAction(int n, int n2, int n3, int n4) {
        super(n, n2, n3);
        this.leg = n4;
    }

    public int getLeg() {
        return this.leg;
    }

    public void setLeg(int n) {
        this.leg = n;
    }

    public static int getDamageFor(Entity entity, int n) {
        int n2;
        if (n == 0) {
            return JumpJetAttackAction.getDamageFor(entity, 1) + JumpJetAttackAction.getDamageFor(entity, 2);
        }
        int[] nArray = new int[2];
        if (entity.entityIsQuad() && !entity.isProne()) {
            nArray[0] = 4;
            nArray[1] = 5;
        } else {
            nArray[0] = 6;
            nArray[1] = 7;
        }
        int n3 = n2 = n == 2 ? nArray[0] : nArray[1];
        if (entity.getLocationStatus(n2) == 2) {
            return 0;
        }
        int n4 = 0;
        for (Mounted mounted : entity.getMisc()) {
            if (!mounted.getType().hasFlag(4L) || !mounted.isReady() || mounted.getLocation() != n2) continue;
            n4 += 3 * mounted.getType().getCriticals(entity);
        }
        return n4;
    }

    public ToHitData toHit(IGame iGame) {
        return JumpJetAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()), this.getLeg());
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable, int n2) {
        int n3;
        Entity entity = iGame.getEntity(n);
        if (entity == null) {
            return new ToHitData(Integer.MAX_VALUE, "You can't attack from a null entity!");
        }
        if (!iGame.getOptions().booleanOption("maxtech_new_physicals")) {
            return new ToHitData(Integer.MAX_VALUE, "no MaxTech physicals");
        }
        String string = JumpJetAttackAction.toHitIsImpossible(iGame, entity, targetable);
        if (string != null) {
            return new ToHitData(Integer.MAX_VALUE, "impossible");
        }
        IHex iHex = iGame.getBoard().getHex(entity.getPosition());
        IHex iHex2 = iGame.getBoard().getHex(targetable.getPosition());
        int n4 = entity.getElevation() + iHex.getElevation();
        int n5 = n4 + entity.getHeight();
        int n6 = targetable.getElevation() + iHex2.getElevation();
        int n7 = n6 + targetable.getHeight();
        int[] nArray = new int[2];
        if (entity.entityIsQuad() && !entity.isProne()) {
            nArray[0] = 4;
            nArray[1] = 5;
        } else {
            nArray[0] = 6;
            nArray[1] = 7;
        }
        if (n2 != 2 && n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("Leg must be LEFT or RIGHT");
        }
        if (!(entity instanceof Mech)) {
            return new ToHitData(Integer.MAX_VALUE, "Non-mechs can't kick");
        }
        if (n2 == 0 && !entity.isProne()) {
            return new ToHitData(Integer.MAX_VALUE, "Only prone mechs can attack with both legs");
        }
        if (entity.isLocationBad(nArray[0]) && (n2 == 0 || n2 == 1) || entity.isLocationBad(nArray[1]) && (n2 == 0 || n2 == 2)) {
            return new ToHitData(Integer.MAX_VALUE, "Leg missing");
        }
        for (Mounted mounted : entity.getMisc()) {
            n3 = 0;
            int n8 = mounted.getLocation();
            if (mounted.getType().hasFlag(4L) && mounted.isReady() && (n8 == nArray[0] && (n2 == 0 || n2 == 1) || n8 == nArray[1] && (n2 == 0 || n2 == 2))) {
                n3 = 1;
                break;
            }
            if (n3 != 0) continue;
            return new ToHitData(Integer.MAX_VALUE, "Jump jets missing or destroyed");
        }
        for (Mounted mounted : entity.getWeaponList()) {
            if (!mounted.isUsedThisRound()) continue;
            n3 = mounted.getLocation();
            if ((n2 != 0 && n2 != 1 || n3 != nArray[0]) && (n2 != 0 && n2 != 2 || n3 != nArray[1])) continue;
            return new ToHitData(Integer.MAX_VALUE, "Weapons fired from leg this turn");
        }
        int n9 = entity.getPosition().distance(targetable.getPosition());
        if (1 != n9) {
            return new ToHitData(Integer.MAX_VALUE, "Enemy must be at range 1");
        }
        if (!entity.isProne() && n5 - n7 != 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        if (entity.isProne() && (n5 > n7 || n5 < n6)) {
            return new ToHitData(Integer.MAX_VALUE, "Target elevation not in range");
        }
        if (!entity.isProne()) {
            if (!targetable.getPosition().equals(entity.getPosition().translated(entity.getFacing()))) {
                return new ToHitData(Integer.MAX_VALUE, "Target not directly ahead of feet");
            }
        } else if (!targetable.getPosition().equals(entity.getPosition().translated((3 + entity.getFacing()) % 6))) {
            return new ToHitData(Integer.MAX_VALUE, "Target not directly behind of feet");
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15 || targetable instanceof GunEmplacement) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting adjacent building.");
        }
        int n10 = entity.getCrew().getPiloting() + 2;
        ToHitData toHitData = new ToHitData(n10, "base");
        JumpJetAttackAction.setCommonModifiers(toHitData, iGame, entity, targetable);
        if (entity.isProne()) {
            toHitData.addModifier(2, "Attacker is prone");
        }
        toHitData.setSideTable(Compute.targetSideTable(entity, targetable));
        return toHitData;
    }
}

