/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mounted;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.AbstractAttackAction;

public class LayExplosivesAttackAction
extends AbstractAttackAction {
    private static final long serialVersionUID = -8799415934269686590L;

    public LayExplosivesAttackAction(int n, int n2) {
        super(n, n2);
    }

    public LayExplosivesAttackAction(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public static int getDamageFor(Entity entity) {
        if (!(entity instanceof Infantry)) {
            return 0;
        }
        Infantry infantry = (Infantry)entity;
        return 2 << infantry.turnsLayingExplosives - 1;
    }

    public ToHitData toHit(IGame iGame) {
        return LayExplosivesAttackAction.toHit(iGame, this.getEntityId(), iGame.getTarget(this.getTargetType(), this.getTargetId()));
    }

    public static ToHitData toHit(IGame iGame, int n, Targetable targetable) {
        Entity entity = iGame.getEntity(n);
        if (targetable.getTargetType() != 3 || targetable.getTargetType() != 15) {
            return new ToHitData(Integer.MAX_VALUE, "You can only target buildings");
        }
        if (entity == null) {
            return new ToHitData(Integer.MAX_VALUE, "You can't attack from a null entity!");
        }
        if (!(entity instanceof Infantry)) {
            return new ToHitData(Integer.MAX_VALUE, "Attacker is not infantry");
        }
        Infantry infantry = (Infantry)entity;
        if (infantry.turnsLayingExplosives > 0) {
            return new ToHitData(Integer.MIN_VALUE, "STOP: Expected Damage: " + LayExplosivesAttackAction.getDamageFor(entity));
        }
        boolean bl = false;
        for (Mounted mounted : entity.getMisc()) {
            if (!mounted.getType().hasFlag(0x100000L) || !mounted.getType().hasSubType(2)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return new ToHitData(Integer.MAX_VALUE, "No explosives carried");
        }
        return new ToHitData(Integer.MIN_VALUE, "START: Can't move or fire while laying explosives");
    }
}

