/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.BattleArmor;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Mech;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.AbstractAttackAction;

public class PhysicalAttackAction
extends AbstractAttackAction {
    private static final long serialVersionUID = -4702357516725749181L;

    public PhysicalAttackAction(int n, int n2) {
        super(n, n2);
    }

    public PhysicalAttackAction(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    protected static String toHitIsImpossible(IGame iGame, Entity entity, Targetable targetable) {
        if (targetable == null) {
            return "target is null";
        }
        if (entity.getPosition().distance(targetable.getPosition()) > 1) {
            return "Target not in range";
        }
        if (targetable.getTargetType() == 0) {
            Entity entity2 = (Entity)targetable;
            if (-1 != entity2.getTransportId()) {
                return "Target is a passenger.";
            }
            if (entity.equals(entity2)) {
                return "You can't target yourself";
            }
            if (-1 != entity2.getSwarmTargetId()) {
                return "Target is swarming a Mek.";
            }
            if (entity instanceof Mech && ((Mech)entity).getGrappled() != -1) {
                return "Locked in Grapple";
            }
            boolean bl = Compute.isInBuilding(iGame, entity2);
            if (bl) {
                Building building = iGame.getBoard().getBuildingAt(entity2.getPosition());
                if (!Compute.isInBuilding(iGame, entity)) {
                    return "Target is inside building";
                }
                if (!iGame.getBoard().getBuildingAt(entity.getPosition()).equals(building)) {
                    return "Target is inside different building";
                }
            }
            if (entity2.isMakingDfa()) {
                return "Target is making a DFA attack";
            }
        }
        if (targetable.getTargetType() == 4 || targetable.getTargetType() == 1 || targetable.getTargetType() == 2) {
            return "Invalid attack";
        }
        return null;
    }

    protected static void setCommonModifiers(ToHitData toHitData, IGame iGame, Entity entity, Targetable targetable) {
        int n = entity.getId();
        int n2 = targetable.getTargetId();
        if (targetable instanceof BattleArmor) {
            toHitData.addModifier(1, "battle armor target");
        }
        toHitData.append(Compute.getAttackerMovementModifier(iGame, n));
        toHitData.append(Compute.getAttackerTerrainModifier(iGame, n));
        toHitData.append(Compute.getTargetTerrainModifier(iGame, targetable));
        if (((Mech)entity).getCockpitType() == 1) {
            int n3;
            int n4 = entity.getBadCriticals(0, 1, 0);
            if (n4 + (n3 = entity.getBadCriticals(0, 1, 1)) == 3) {
                toHitData = new ToHitData(Integer.MAX_VALUE, "Sensors Completely Destroyed for Torso-Mounted Cockpit");
                return;
            }
            if (n4 == 2) {
                toHitData.addModifier(4, "Head Sensors Destroyed for Torso-Mounted Cockpit");
            }
        }
        if (entity.isSpotting()) {
            toHitData.addModifier(1, "attacker is spotting for indirect LRM fire");
        }
        toHitData.append(Compute.getImmobileMod(targetable));
        toHitData.append(PhysicalAttackAction.nightModifiers(iGame, targetable, null, entity));
        if (targetable.getTargetType() == 0) {
            Entity entity2 = (Entity)targetable;
            toHitData.append(Compute.getTargetMovementModifier(iGame, n2));
            if (entity2.isProne()) {
                toHitData.addModifier(-2, "target prone and adjacent");
            }
            IHex iHex = iGame.getBoard().getHex(entity2.getPosition());
            if (entity2.height() > 0 && entity2.getElevation() == -1 && iHex.terrainLevel(4) == entity2.height()) {
                toHitData.addModifier(1, "target has partial cover");
            }
            Compute.modifyPhysicalBTHForAdvantages(entity, entity2, toHitData, iGame);
        }
    }
}

